/*
 * Decompiled with CFR 0.152.
 */
package hughai.ui;

import hughai.PlayerObjects;
import hughai.ui.Activator;
import hughai.utils.Formatting;
import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ConsoleEcma {
    final String consoletemplatefilename = "EcmaConsoleTemplate.txt";
    JPanel textpanel;
    GridLayout gridLayout;
    JTextArea textarea;
    JButton gobutton;
    JTextArea outputTextarea;
    PlayerObjects playerObjects;

    public ConsoleEcma(PlayerObjects playerObjects) {
        this.playerObjects = playerObjects;
        this.init();
    }

    void init() {
        try {
            JPanel jPanel = new JPanel(new BorderLayout());
            this.gridLayout = new GridLayout(2, 1);
            this.textpanel = new JPanel(this.gridLayout);
            JPanel jPanel2 = new JPanel(new GridLayout(1, 2));
            jPanel.add("Center", this.textpanel);
            jPanel.add("South", jPanel2);
            this.textarea = new JTextArea();
            JScrollPane jScrollPane = new JScrollPane(this.textarea);
            this.outputTextarea = new JTextArea();
            JScrollPane jScrollPane2 = new JScrollPane(this.outputTextarea);
            this.gobutton = new JButton("Go");
            String string = this.playerObjects.getCSAI().getAIDirectoryPath() + "EcmaConsoleTemplate.txt";
            String string2 = this.readFile(string);
            if (string2 != null) {
                this.textarea.setText(string2);
            } else {
                this.textarea.setText("<Missing file " + string + ">");
            }
            this.gobutton.addActionListener(new GoButton());
            this.textpanel.add(jScrollPane);
            this.textpanel.add(jScrollPane2);
            jPanel2.add(this.gobutton);
            this.playerObjects.getMainUI().addPanelToTabbedPanel("ECMA Console", jPanel);
        }
        catch (Exception exception) {
            this.playerObjects.getLogFile().WriteLine(Formatting.exceptionToStackTrace(exception));
            throw new RuntimeException(exception);
        }
    }

    String readFile(String string) {
        try {
            FileReader fileReader = new FileReader(string);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                stringBuilder.append(string2);
                stringBuilder.append("\n");
                string2 = bufferedReader.readLine();
            }
            bufferedReader.close();
            fileReader.close();
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            this.playerObjects.getLogFile().WriteLine(Formatting.exceptionToStackTrace(exception));
            return null;
        }
    }

    void debug(Object object) {
        this.playerObjects.getLogFile().WriteLine("" + object);
    }

    String exceptionToStackTrace(Exception exception) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        exception.printStackTrace(printWriter);
        return stringWriter.toString();
    }

    class GoButton
    implements ActionListener {
        GoButton() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                Object object;
                Object object22;
                ClassLoader classLoader = ConsoleEcma.class.getClassLoader();
                if (classLoader == null) {
                    System.out.println("using system classloader as base");
                    classLoader = ClassLoader.getSystemClassLoader();
                } else {
                    System.out.println("using our classloader as base");
                }
                Class<?> clazz = classLoader.loadClass("javax.script.ScriptEngineManager");
                if (!ScriptEngineManager.class.isAssignableFrom(clazz)) {
                    throw new RuntimeException("Invalid class");
                }
                Object obj = clazz.newInstance();
                ScriptEngineManager scriptEngineManager = (ScriptEngineManager)obj;
                for (Object object22 : scriptEngineManager.getBindings().keySet()) {
                    ConsoleEcma.this.debug(object22);
                }
                List<ScriptEngineFactory> list = scriptEngineManager.getEngineFactories();
                object22 = null;
                Object object3 = list.iterator();
                while (object3.hasNext()) {
                    object = (ScriptEngineFactory)object3.next();
                    if (!object.getLanguageName().equals("ECMAScript") || !object.getLanguageVersion().equals("1.6")) continue;
                    object22 = object;
                }
                object3 = object22.getScriptEngine();
                ConsoleEcma.this.debug(ConsoleEcma.class.getClassLoader());
                ConsoleEcma.this.debug(ScriptEngineManager.class.getClassLoader());
                ConsoleEcma.this.debug(ScriptEngineFactory.class.getClassLoader());
                ConsoleEcma.this.debug(ScriptEngine.class.getClassLoader());
                object3.eval(ConsoleEcma.this.textarea.getText());
                object = (Invocable)object3;
                String string = (String)object.invokeFunction("go", ConsoleEcma.this.playerObjects, new Activator());
                ConsoleEcma.this.outputTextarea.setText(string);
            }
            catch (Exception exception) {
                ConsoleEcma.this.outputTextarea.setText(ConsoleEcma.this.exceptionToStackTrace(exception));
            }
        }
    }
}

