/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.HierarchyBoundsAdapter;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.View;
import org.jdesktop.swingx.JXHeader;
import org.jdesktop.swingx.JXLabel;
import org.jdesktop.swingx.painter.MattePainter;
import org.jdesktop.swingx.painter.Painter;
import org.jdesktop.swingx.plaf.HeaderUI;
import org.jdesktop.swingx.plaf.PainterUIResource;
import org.jdesktop.swingx.plaf.UIManagerExt;

public class BasicHeaderUI
extends HeaderUI {
    private static final Logger LOG = Logger.getLogger(BasicHeaderUI.class.getName());
    protected JLabel titleLabel;
    protected DescriptionPane descriptionPane;
    protected JLabel imagePanel;
    private PropertyChangeListener propListener;
    private HierarchyBoundsListener boundsListener;
    private Color gradientLightColor;
    private Color gradientDarkColor;

    public static ComponentUI createUI(JComponent c) {
        return new BasicHeaderUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        assert (c instanceof JXHeader);
        JXHeader header2 = (JXHeader)c;
        this.installDefaults(header2);
        this.installComponents(header2);
        this.installListeners(header2);
    }

    @Override
    public void uninstallUI(JComponent c) {
        assert (c instanceof JXHeader);
        JXHeader header2 = (JXHeader)c;
        this.uninstallListeners(header2);
        this.uninstallComponents(header2);
        this.uninstallDefaults(header2);
    }

    protected void installDefaults(JXHeader header2) {
        this.gradientLightColor = UIManagerExt.getColor("JXHeader.startBackground");
        if (this.gradientLightColor == null) {
            this.gradientLightColor = Color.WHITE;
        }
        this.gradientDarkColor = UIManagerExt.getColor("JXHeader.background");
        if (this.gradientDarkColor == null) {
            this.gradientDarkColor = UIManagerExt.getColor("control");
        }
        if (this.isUIInstallable(header2.getBackgroundPainter())) {
            header2.setBackgroundPainter(this.createBackgroundPainter());
        }
        if (this.isUIInstallable(header2.getTitleFont())) {
            Font titleFont = UIManager.getFont("JXHeader.titleFont");
            header2.setTitleFont(titleFont != null ? titleFont : UIManager.getFont("Label.font"));
        }
        if (this.isUIInstallable(header2.getTitleForeground())) {
            Color titleForeground = UIManagerExt.getColor("JXHeader.titleForeground");
            header2.setTitleForeground(titleForeground != null ? titleForeground : UIManagerExt.getColor("Label.foreground"));
        }
        if (this.isUIInstallable(header2.getDescriptionFont())) {
            Font descFont = UIManager.getFont("JXHeader.descriptionFont");
            header2.setDescriptionFont(descFont != null ? descFont : UIManager.getFont("Label.font"));
        }
        if (this.isUIInstallable(header2.getDescriptionForeground())) {
            Color descForeground = UIManagerExt.getColor("JXHeader.descriptionForeground");
            header2.setDescriptionForeground(descForeground != null ? descForeground : UIManagerExt.getColor("Label.foreground"));
        }
        if (this.isUIInstallable(header2.getIcon())) {
            header2.setIcon(UIManager.getIcon("Header.defaultIcon"));
        }
    }

    protected void uninstallDefaults(JXHeader h) {
    }

    protected void installComponents(JXHeader header2) {
        this.titleLabel = new JLabel();
        this.descriptionPane = new DescriptionPane();
        this.imagePanel = new JLabel();
        this.installComponentDefaults(header2);
        header2.setLayout(new GridBagLayout());
        this.resetLayout(header2);
    }

    protected void uninstallComponents(JXHeader header2) {
        this.uninstallComponentDefaults(header2);
        header2.remove(this.titleLabel);
        header2.remove(this.descriptionPane);
        header2.remove(this.imagePanel);
        this.titleLabel = null;
        this.descriptionPane = null;
        this.imagePanel = null;
    }

    protected void installComponentDefaults(JXHeader header2) {
        this.titleLabel.setFont(this.getAsNotUIResource(header2.getTitleFont()));
        this.titleLabel.setForeground(this.getAsNotUIResource(header2.getTitleForeground()));
        this.titleLabel.setText(header2.getTitle());
        this.descriptionPane.setFont(this.getAsNotUIResource(header2.getDescriptionFont()));
        this.descriptionPane.setForeground(this.getAsNotUIResource(header2.getDescriptionForeground()));
        this.descriptionPane.setOpaque(false);
        this.descriptionPane.setText(header2.getDescription());
        this.descriptionPane.setLineWrap(true);
        this.imagePanel.setIcon(header2.getIcon());
    }

    private Font getAsNotUIResource(Font font) {
        if (!(font instanceof UIResource)) {
            return font;
        }
        return font.deriveFont(font.getAttributes());
    }

    private Color getAsNotUIResource(Color color) {
        if (!(color instanceof UIResource)) {
            return color;
        }
        float[] rgb = color.getRGBComponents(null);
        return new Color(rgb[0], rgb[1], rgb[2], rgb[3]);
    }

    private boolean isUIInstallable(Object property) {
        return property == null || property instanceof UIResource;
    }

    protected void uninstallComponentDefaults(JXHeader header2) {
    }

    protected void installListeners(final JXHeader header2) {
        this.propListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                BasicHeaderUI.this.onPropertyChange(header2, evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
            }
        };
        this.boundsListener = new HierarchyBoundsAdapter(){

            @Override
            public void ancestorResized(HierarchyEvent e2) {
                if (header2 == e2.getComponent()) {
                    View v = (View)BasicHeaderUI.this.descriptionPane.getClientProperty("html");
                    if (v == null) {
                        DescriptionPane descriptionPane = BasicHeaderUI.this.descriptionPane;
                        BasicHeaderUI.this.descriptionPane.getMultiLineSupport();
                        descriptionPane.putClientProperty("html", JXLabel.MultiLineSupport.createView(BasicHeaderUI.this.descriptionPane));
                        v = (View)BasicHeaderUI.this.descriptionPane.getClientProperty("html");
                    }
                    if (v != null) {
                        Container tla = header2.getTopLevelAncestor();
                        if (tla == null) {
                            tla = header2.getParent();
                            while (tla.getParent() != null) {
                                tla = tla.getParent();
                            }
                        }
                        int h = Math.max(BasicHeaderUI.this.descriptionPane.getHeight(), tla.getHeight());
                        int w = Math.min(tla.getWidth(), header2.getParent().getWidth());
                        v.setSize(w -= 35 + header2.getInsets().left + header2.getInsets().right + BasicHeaderUI.this.descriptionPane.getInsets().left + BasicHeaderUI.this.descriptionPane.getInsets().right + BasicHeaderUI.this.imagePanel.getInsets().left + BasicHeaderUI.this.imagePanel.getInsets().right + BasicHeaderUI.this.imagePanel.getWidth() + BasicHeaderUI.this.descriptionPane.getBounds().x, h);
                        BasicHeaderUI.this.descriptionPane.setSize(w, (int)Math.ceil(v.getPreferredSpan(1)));
                    }
                }
            }
        };
        header2.addPropertyChangeListener(this.propListener);
        header2.addHierarchyBoundsListener(this.boundsListener);
    }

    protected void uninstallListeners(JXHeader h) {
        h.removePropertyChangeListener(this.propListener);
        h.removeHierarchyBoundsListener(this.boundsListener);
    }

    protected void onPropertyChange(JXHeader h, String propertyName, Object oldValue, Object newValue) {
        if ("title".equals(propertyName)) {
            this.titleLabel.setText(h.getTitle());
        } else if ("description".equals(propertyName)) {
            this.descriptionPane.setText(h.getDescription());
        } else if ("icon".equals(propertyName)) {
            this.imagePanel.setIcon(h.getIcon());
        } else if ("enabled".equals(propertyName)) {
            boolean enabled = h.isEnabled();
            this.titleLabel.setEnabled(enabled);
            this.descriptionPane.setEnabled(enabled);
            this.imagePanel.setEnabled(enabled);
        } else if ("titleFont".equals(propertyName)) {
            this.titleLabel.setFont((Font)newValue);
        } else if ("descriptionFont".equals(propertyName)) {
            this.descriptionPane.setFont((Font)newValue);
        } else if ("titleForeground".equals(propertyName)) {
            this.titleLabel.setForeground((Color)newValue);
        } else if ("descriptionForeground".equals(propertyName)) {
            this.descriptionPane.setForeground((Color)newValue);
        } else if ("iconPosition".equals(propertyName)) {
            this.resetLayout(h);
        }
    }

    private void resetLayout(JXHeader h) {
        h.remove(this.titleLabel);
        h.remove(this.descriptionPane);
        h.remove(this.imagePanel);
        if (h.getIconPosition() == null || h.getIconPosition() == JXHeader.IconPosition.RIGHT) {
            h.add((Component)this.titleLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(12, 12, 0, 11), 0, 0));
            h.add((Component)this.descriptionPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 23, 1, new Insets(0, 24, 12, 11), 0, 0));
            h.add((Component)this.imagePanel, new GridBagConstraints(1, 0, 1, 2, 0.0, 1.0, 24, 0, new Insets(12, 0, 11, 11), 0, 0));
        } else {
            h.add((Component)this.titleLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(12, 12, 0, 11), 0, 0));
            h.add((Component)this.descriptionPane, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 23, 1, new Insets(0, 24, 12, 11), 0, 0));
            h.add((Component)this.imagePanel, new GridBagConstraints(0, 0, 1, 2, 0.0, 1.0, 24, 0, new Insets(12, 11, 0, 11), 0, 0));
        }
    }

    protected Painter createBackgroundPainter() {
        MattePainter p = new MattePainter(new GradientPaint(0.0f, 0.0f, this.gradientLightColor, 1.0f, 0.0f, this.gradientDarkColor));
        p.setPaintStretched(true);
        return new PainterUIResource<Object>(p);
    }

    protected class DescriptionPane
    extends JXLabel {
        protected DescriptionPane() {
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
        }

        @Override
        public JXLabel.MultiLineSupport getMultiLineSupport() {
            return super.getMultiLineSupport();
        }
    }
}

