/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogCommitSelection;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.ui.VcsLogUiEx;
import git4idea.GitProtectedBranchesKt;
import git4idea.i18n.GitBundle;
import git4idea.rebase.log.GitCommitEditingActionBase;
import git4idea.repo.GitRepository;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b \u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J>\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0014J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0014\u00a8\u0006\u0016"}, d2={"Lgit4idea/rebase/GitSingleCommitEditingAction;", "Lgit4idea/rebase/log/GitCommitEditingActionBase;", "Lgit4idea/rebase/GitSingleCommitEditingAction$SingleCommitEditingData;", "<init>", "()V", "createCommitEditingData", "Lgit4idea/rebase/log/GitCommitEditingActionBase$CommitEditingDataCreationResult;", "repository", "Lgit4idea/repo/GitRepository;", "selection", "Lcom/intellij/vcs/log/VcsLogCommitSelection;", "logData", "Lcom/intellij/vcs/log/data/VcsLogData;", "logUiEx", "Lcom/intellij/vcs/log/ui/VcsLogUiEx;", "selectedChanges", "", "Lcom/intellij/openapi/vcs/changes/Change;", "lastCheckCommitsEditingAvailability", "", "commitEditingData", "SingleCommitEditingData", "intellij.vcs.git"})
public abstract class GitSingleCommitEditingAction
extends GitCommitEditingActionBase<SingleCommitEditingData> {
    @Override
    @NotNull
    protected GitCommitEditingActionBase.CommitEditingDataCreationResult<SingleCommitEditingData> createCommitEditingData(@NotNull GitRepository repository2, @NotNull VcsLogCommitSelection selection, @NotNull VcsLogData logData, @Nullable VcsLogUiEx logUiEx, @NotNull List<? extends Change> selectedChanges) {
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        Intrinsics.checkNotNullParameter((Object)logData, (String)"logData");
        Intrinsics.checkNotNullParameter(selectedChanges, (String)"selectedChanges");
        if (selection.getCommits().size() != 1) {
            return new GitCommitEditingActionBase.CommitEditingDataCreationResult.Prohibited(null, 1, null);
        }
        return new GitCommitEditingActionBase.CommitEditingDataCreationResult.Created<GitCommitEditingActionBase.MultipleCommitEditingData>(new SingleCommitEditingData(repository2, selection, logData, logUiEx, selectedChanges));
    }

    @Override
    @Nullable
    protected String lastCheckCommitsEditingAvailability(@NotNull SingleCommitEditingData commitEditingData) {
        Intrinsics.checkNotNullParameter((Object)commitEditingData, (String)"commitEditingData");
        VcsCommitMetadata commit = commitEditingData.getSelectedCommit();
        VcsLogData vcsLogData = commitEditingData.getLogData();
        VirtualFile virtualFile = commit.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
        Object object = commit.getId();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getId(...)");
        List<String> branches = GitCommitEditingActionBase.Companion.findContainingBranches(vcsLogData, virtualFile, (Hash)object);
        if (!branches.contains("HEAD")) {
            return GitBundle.message("rebase.log.commit.editing.action.commit.not.in.head.error.text", new Object[0]);
        }
        String protectedBranch = GitProtectedBranchesKt.findProtectedRemoteBranch(commitEditingData.getRepository(), (Collection<String>)branches);
        if (protectedBranch != null) {
            Object[] objectArray = new Object[]{protectedBranch};
            return GitBundle.message("rebase.log.commit.editing.action.commit.pushed.to.protected.branch.error.text", objectArray);
        }
        return null;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0004\b\r\u0010\u000eR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lgit4idea/rebase/GitSingleCommitEditingAction$SingleCommitEditingData;", "Lgit4idea/rebase/log/GitCommitEditingActionBase$MultipleCommitEditingData;", "repository", "Lgit4idea/repo/GitRepository;", "selection", "Lcom/intellij/vcs/log/VcsLogCommitSelection;", "logData", "Lcom/intellij/vcs/log/data/VcsLogData;", "logUiEx", "Lcom/intellij/vcs/log/ui/VcsLogUiEx;", "selectedChanges", "", "Lcom/intellij/openapi/vcs/changes/Change;", "<init>", "(Lgit4idea/repo/GitRepository;Lcom/intellij/vcs/log/VcsLogCommitSelection;Lcom/intellij/vcs/log/data/VcsLogData;Lcom/intellij/vcs/log/ui/VcsLogUiEx;Ljava/util/List;)V", "getSelectedChanges", "()Ljava/util/List;", "selectedCommit", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "getSelectedCommit", "()Lcom/intellij/vcs/log/VcsCommitMetadata;", "selectedCommitFullDetails", "Lcom/intellij/vcs/log/VcsFullCommitDetails;", "getSelectedCommitFullDetails", "()Lcom/intellij/vcs/log/VcsFullCommitDetails;", "isHeadCommit", "", "()Z", "intellij.vcs.git"})
    public static final class SingleCommitEditingData
    extends GitCommitEditingActionBase.MultipleCommitEditingData {
        @NotNull
        private final List<Change> selectedChanges;
        @NotNull
        private final VcsCommitMetadata selectedCommit;
        @NotNull
        private final VcsFullCommitDetails selectedCommitFullDetails;
        private final boolean isHeadCommit;

        public SingleCommitEditingData(@NotNull GitRepository repository2, @NotNull VcsLogCommitSelection selection, @NotNull VcsLogData logData, @Nullable VcsLogUiEx logUiEx, @NotNull List<? extends Change> selectedChanges) {
            Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
            Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
            Intrinsics.checkNotNullParameter((Object)logData, (String)"logData");
            Intrinsics.checkNotNullParameter(selectedChanges, (String)"selectedChanges");
            super(repository2, selection, logData, logUiEx);
            this.selectedChanges = selectedChanges;
            this.selectedCommit = (VcsCommitMetadata)CollectionsKt.first((List)selection.getCachedMetadata());
            this.selectedCommitFullDetails = (VcsFullCommitDetails)CollectionsKt.first((List)selection.getCachedFullDetails());
            this.isHeadCommit = Intrinsics.areEqual((Object)((Hash)this.selectedCommit.getId()).asString(), (Object)repository2.getCurrentRevision());
        }

        @NotNull
        public final List<Change> getSelectedChanges() {
            return this.selectedChanges;
        }

        @NotNull
        public final VcsCommitMetadata getSelectedCommit() {
            return this.selectedCommit;
        }

        @NotNull
        public final VcsFullCommitDetails getSelectedCommitFullDetails() {
            return this.selectedCommitFullDetails;
        }

        public final boolean isHeadCommit() {
            return this.isHeadCommit;
        }
    }
}

