/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.objects;

import it.unimi.dsi.fastutil.BigArrays;
import it.unimi.dsi.fastutil.Hash;
import java.io.Serializable;
import java.util.Arrays;

public final class ObjectBigArrays {
    public static final Object[][] EMPTY_BIG_ARRAY = new Object[0][];
    public static final Object[][] DEFAULT_EMPTY_BIG_ARRAY = new Object[0][];
    public static final Hash.Strategy HASH_STRATEGY = new BigArrayHashStrategy();

    public static Object[][] newBigArray(long length) {
        if (length == 0L) {
            return EMPTY_BIG_ARRAY;
        }
        BigArrays.ensureLength(length);
        int baseLength = (int)(length + 0x7FFFFFFL >>> 27);
        Object[][] base = new Object[baseLength][];
        int residual = (int)(length & 0x7FFFFFFL);
        if (residual != 0) {
            for (int i = 0; i < baseLength - 1; ++i) {
                base[i] = new Object[0x8000000];
            }
            base[baseLength - 1] = new Object[residual];
        } else {
            for (int i = 0; i < baseLength; ++i) {
                base[i] = new Object[0x8000000];
            }
        }
        return base;
    }

    @Deprecated
    public static <K> boolean equals(K[][] a1, K[][] a2) {
        return BigArrays.equals(a1, a2);
    }

    private static final class BigArrayHashStrategy<K>
    implements Hash.Strategy<K[][]>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;

        private BigArrayHashStrategy() {
        }

        @Override
        public int hashCode(K[][] o) {
            return Arrays.deepHashCode(o);
        }

        @Override
        public boolean equals(K[][] a, K[][] b) {
            return ObjectBigArrays.equals(a, b);
        }
    }
}

