/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleCapability;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ImplicitIntegerCoercionKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\f\u0010\u0010\u001a\u00020\u0006*\u00020\u000bH\u0002R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/resolve/ImplicitIntegerCoercion;", "", "<init>", "()V", "MODULE_CAPABILITY", "Lorg/jetbrains/kotlin/descriptors/ModuleCapability;", "", "getMODULE_CAPABILITY", "()Lorg/jetbrains/kotlin/descriptors/ModuleCapability;", "isEnabledFor", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "IMPLICIT_INTEGER_COERCION_ANNOTATION_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "hasImplicitIntegerCoercionAnnotation", "frontend"})
public final class ImplicitIntegerCoercion {
    @NotNull
    public static final ImplicitIntegerCoercion INSTANCE = new ImplicitIntegerCoercion();
    @NotNull
    private static final ModuleCapability<Boolean> MODULE_CAPABILITY = new ModuleCapability("ImplicitIntegerCoercion");
    @NotNull
    private static final FqName IMPLICIT_INTEGER_COERCION_ANNOTATION_FQ_NAME = new FqName("kotlin.internal.ImplicitIntegerCoercion");

    private ImplicitIntegerCoercion() {
    }

    @NotNull
    public final ModuleCapability<Boolean> getMODULE_CAPABILITY() {
        return MODULE_CAPABILITY;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isEnabledFor(@NotNull DeclarationDescriptor descriptor, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        if (this.hasImplicitIntegerCoercionAnnotation(descriptor)) return true;
        if (!languageVersionSettings.supportsFeature(LanguageFeature.ImplicitSignedToUnsignedIntegerConversion)) return false;
        ModuleDescriptor moduleDescriptor = DescriptorUtils.getContainingModuleOrNull(descriptor);
        if (moduleDescriptor == null) return false;
        if (!ImplicitIntegerCoercionKt.hasImplicitIntegerCoercionCapability(moduleDescriptor)) return false;
        return true;
    }

    private final boolean hasImplicitIntegerCoercionAnnotation(DeclarationDescriptor $this$hasImplicitIntegerCoercionAnnotation) {
        return $this$hasImplicitIntegerCoercionAnnotation.getAnnotations().findAnnotation(IMPLICIT_INTEGER_COERCION_ANNOTATION_FQ_NAME) != null;
    }
}

