/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.psi.file;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StubBuilder;
import com.intellij.psi.stubs.ObjectStubTree;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubTreeLoader;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.decompiler.psi.file.KtDecompiledFile;
import org.jetbrains.kotlin.analysis.decompiler.stub.file.ClsClassFinder;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinFileStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.UtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/psi/file/CompiledStubBuilder;", "Lcom/intellij/psi/StubBuilder;", "<init>", "()V", "buildStubTree", "Lorg/jetbrains/kotlin/psi/stubs/impl/KotlinFileStubImpl;", "file", "Lcom/intellij/psi/PsiFile;", "readOrBuildCompiledStub", "Lorg/jetbrains/kotlin/analysis/decompiler/psi/file/KtDecompiledFile;", "skipChildProcessingWhenBuildingStubs", "", "parent", "Lcom/intellij/lang/ASTNode;", "node", "decompiler-to-psi"})
@SourceDebugExtension(value={"SMAP\nKtDecompiledFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtDecompiledFile.kt\norg/jetbrains/kotlin/analysis/decompiler/psi/file/CompiledStubBuilder\n+ 2 checks.kt\norg/jetbrains/kotlin/analysis/utils/errors/ChecksKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,93:1\n16#2:94\n17#2:96\n1#3:95\n*S KotlinDebug\n*F\n+ 1 KtDecompiledFile.kt\norg/jetbrains/kotlin/analysis/decompiler/psi/file/CompiledStubBuilder\n*L\n46#1:94\n46#1:96\n46#1:95\n*E\n"})
final class CompiledStubBuilder
implements StubBuilder {
    @NotNull
    public static final CompiledStubBuilder INSTANCE = new CompiledStubBuilder();

    private CompiledStubBuilder() {
    }

    @NotNull
    public KotlinFileStubImpl buildStubTree(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        PsiFile obj$iv = file;
        boolean $i$f$requireIsInstance = false;
        if (!(obj$iv instanceof KtDecompiledFile)) {
            boolean bl = false;
            String string = "Expected " + Reflection.getOrCreateKotlinClass(KtDecompiledFile.class) + " instead of " + Reflection.getOrCreateKotlinClass(obj$iv.getClass()) + " for " + obj$iv;
            throw new IllegalArgumentException(string.toString());
        }
        KotlinFileStubImpl stub = this.readOrBuildCompiledStub((KtDecompiledFile)file);
        KotlinFileStubImpl clonedStub = UtilsKt.deepCopy(stub);
        clonedStub.setPsi(file);
        return clonedStub;
    }

    @NotNull
    public final KotlinFileStubImpl readOrBuildCompiledStub(@NotNull KtDecompiledFile file) {
        KotlinFileStubImpl kotlinFileStubImpl;
        KotlinFileStubImpl fileStub;
        ObjectStubTree stubTree;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        VirtualFile virtualFile = file.getViewProvider().getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        VirtualFile virtualFile2 = virtualFile;
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        ObjectStubTree objectStubTree = stubTree = (ObjectStubTree)ClsClassFinder.INSTANCE.allowMultifileClassPart(() -> CompiledStubBuilder.readOrBuildCompiledStub$lambda$0(project2, virtualFile2));
        Stub stub = objectStubTree != null ? objectStubTree.getRoot() : null;
        KotlinFileStubImpl kotlinFileStubImpl2 = fileStub = stub instanceof KotlinFileStubImpl ? (KotlinFileStubImpl)stub : null;
        if (fileStub != null) {
            kotlinFileStubImpl = fileStub;
        } else {
            String cause = stubTree == null ? "stub tree is not found" : "non-Kotlin stub tree (" + Reflection.getOrCreateKotlinClass(stubTree.getClass()).getSimpleName() + ')';
            String text = StringsKt.trimIndent((String)("\n                // Could not decompile the file: " + cause + "\n                // Please report an issue: https://kotl.in/issue\n            "));
            kotlinFileStubImpl = KotlinFileStubImpl.Companion.forInvalid(text);
        }
        return kotlinFileStubImpl;
    }

    public boolean skipChildProcessingWhenBuildingStubs(@NotNull ASTNode parent, @NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return false;
    }

    private static final ObjectStubTree readOrBuildCompiledStub$lambda$0(Project $project, VirtualFile $virtualFile) {
        StubTreeLoader stubLoader = StubTreeLoader.getInstance();
        return $project.isDefault() ? stubLoader.build(null, $virtualFile, null) : stubLoader.readOrBuild($project, $virtualFile, null);
    }
}

