/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public abstract class BasicAttributeValueReference
implements PsiReference {
    protected final PsiElement myElement;
    protected final TextRange myRange;

    public BasicAttributeValueReference(PsiElement element) {
        this(element, ElementManipulators.getValueTextRange((PsiElement)element));
    }

    public BasicAttributeValueReference(PsiElement element, int offset) {
        this(element, BasicAttributeValueReference.createTextRange(element, offset));
    }

    @NotNull
    private static TextRange createTextRange(PsiElement element, int offset) {
        int valueEndOffset = element.getTextLength() - offset;
        return new TextRange(offset, Math.max(offset, valueEndOffset));
    }

    public BasicAttributeValueReference(PsiElement element, TextRange range) {
        this.myElement = element;
        this.myRange = range;
    }

    @NotNull
    public PsiElement getElement() {
        PsiElement psiElement = this.myElement;
        if (psiElement == null) {
            BasicAttributeValueReference.$$$reportNull$$$0(0);
        }
        return psiElement;
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = this.myRange;
        if (textRange == null) {
            BasicAttributeValueReference.$$$reportNull$$$0(1);
        }
        return textRange;
    }

    @NotNull
    public String getCanonicalText() {
        String s = this.myElement.getText();
        if (this.myRange.getStartOffset() < s.length() && this.myRange.getEndOffset() <= s.length()) {
            String string = this.myRange.substring(s);
            if (string == null) {
                BasicAttributeValueReference.$$$reportNull$$$0(2);
            }
            return string;
        }
        return "";
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            BasicAttributeValueReference.$$$reportNull$$$0(3);
        }
        return ElementManipulators.handleContentChange((PsiElement)this.myElement, (TextRange)this.getRangeInElement(), (String)newElementName);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            BasicAttributeValueReference.$$$reportNull$$$0(4);
        }
        return null;
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            BasicAttributeValueReference.$$$reportNull$$$0(5);
        }
        return this.myElement.getManager().areElementsEquivalent(element, this.resolve());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/BasicAttributeValueReference";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/BasicAttributeValueReference";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

