/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.15.0
 *
 * Copyright (c) 2024 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt5.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtGui.h"

#line 26 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtGui/qfont.sip"
#include <qfont.h>
#line 29 "/build/pyqt5/src/PyQt5-5.15.11/build/QtGui/sipQtGuiQFont.cpp"

#line 27 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qstring.sip"
#include <qstring.h>
#line 33 "/build/pyqt5/src/PyQt5-5.15.11/build/QtGui/sipQtGuiQFont.cpp"
#line 26 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtGui/qpaintdevice.sip"
#include <qpaintdevice.h>
#line 36 "/build/pyqt5/src/PyQt5-5.15.11/build/QtGui/sipQtGuiQFont.cpp"
#line 26 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qvariant.sip"
#include <qvariant.h>
#line 39 "/build/pyqt5/src/PyQt5-5.15.11/build/QtGui/sipQtGuiQFont.cpp"
#line 36 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qstringlist.sip"
#include <qstringlist.h>
#line 42 "/build/pyqt5/src/PyQt5-5.15.11/build/QtGui/sipQtGuiQFont.cpp"


PyDoc_STRVAR(doc_QFont_family, "family(self) -> str");

extern "C" {static PyObject *meth_QFont_family(PyObject *, PyObject *);}
static PyObject *meth_QFont_family(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QFont, &sipCpp))
        {
            ::QString*sipRes;

            sipRes = new ::QString(sipCpp->family());

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QFont, sipName_family, doc_QFont_family);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFont_setFamily, "setFamily(self, a0: str|None)");

extern "C" {static PyObject *meth_QFont_setFamily(PyObject *, PyObject *);}
static PyObject *meth_QFont_setFamily(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        ::QFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QFont, &sipCpp, sipType_QString, &a0, &a0State))
        {
            sipCpp->setFamily(*a0);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QFont, sipName_setFamily, doc_QFont_setFamily);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFont_pointSize, "pointSize(self) -> int");

extern "C" {static PyObject *meth_QFont_pointSize(PyObject *, PyObject *);}
static PyObject *meth_QFont_pointSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QFont, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->pointSize();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QFont, sipName_pointSize, doc_QFont_pointSize);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFont_setPointSize, "setPointSize(self, a0: int)");

extern "C" {static PyObject *meth_QFont_setPointSize(PyObject *, PyObject *);}
static PyObject *meth_QFont_setPointSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        ::QFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QFont, &sipCpp, &a0))
        {
            sipCpp->setPointSize(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QFont, sipName_setPointSize, doc_QFont_setPointSize);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFont_pointSizeF, "pointSizeF(self) -> float");

extern "C" {static PyObject *meth_QFont_pointSizeF(PyObject *, PyObject *);}
static PyObject *meth_QFont_pointSizeF(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QFont, &sipCpp))
        {
            ::qreal sipRes;

            sipRes = sipCpp->pointSizeF();

            return PyFloat_FromDouble(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QFont, sipName_pointSizeF, doc_QFont_pointSizeF);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFont_setPointSizeF, "setPointSizeF(self, a0: float)");

extern "C" {static PyObject *meth_QFont_setPointSizeF(PyObject *, PyObject *);}
static PyObject *meth_QFont_setPointSizeF(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qreal a0;
        ::QFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bd", &sipSelf, sipType_QFont, &sipCpp, &a0))
        {
            sipCpp->setPointSizeF(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QFont, sipName_setPointSizeF, doc_QFont_setPointSizeF);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFont_pixelSize, "pixelSize(self) -> int");

extern "C" {static PyObject *meth_QFont_pixelSize(PyObject *, PyObject *);}
static PyObject *meth_QFont_pixelSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QFont, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->pixelSize();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QFont, sipName_pixelSize, doc_QFont_pixelSize);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFont_setPixelSize, "setPixelSize(self, a0: int)");

extern "C" {static PyObject *meth_QFont_setPixelSize(PyObject *, PyObject *);}
static PyObject *meth_QFont_setPixelSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        ::QFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QFont, &sipCpp, &a0))
        {
            sipCpp->setPixelSize(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QFont, sipName_setPixelSize, doc_QFont_setPixelSize);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFont_weight, "weight(self) -> int");

extern "C" {static PyObject *meth_QFont_weight(PyObject *, PyObject *);}
static PyObject *meth_QFont_weight(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QFont, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->weight();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QFont, sipName_weight, doc_QFont_weight);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFont_setWeight, "setWeight(self, a0: int)");

extern "C" {static PyObject *meth_QFont_setWeight(PyObject *, PyObject *);}
static PyObject *meth_QFont_setWeight(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        ::QFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QFont, &sipCpp, &a0))
        {
            sipCpp->setWeight(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QFont, sipName_setWeight, doc_QFont_setWeight);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFont_setStyle, "setStyle(self, style: QFont.Style)");

extern "C" {static PyObject *meth_QFont_setStyle(PyObject *, PyObject *);}
static PyObject *meth_QFont_setStyle(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QFont::Style a0;
        ::QFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BE", &sipSelf, sipType_QFont, &sipCpp, sipType_QFont_Style, &a0))
        {
            sipCpp->setStyle(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QFont, sipName_setStyle, doc_QFont_setStyle);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFont_style, "style(self) -> QFont.Style");

extern "C" {static PyObject *meth_QFont_style(PyObject *, PyObject *);}
static PyObject *meth_QFont_style(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QFont, &sipCpp))
        {
            ::QFont::Style sipRes;

            sipRes = sipCpp->style();

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QFont_Style);
        }
    }

    sipNoMethod(sipParseErr, sipName_QFont, sipName_style, doc_QFont_style);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFont_underline, "underline(self) -> bool");

extern "C" {static PyObject *meth_QFont_underline(PyObject *, PyObject *);}
static PyObject *meth_QFont_underline(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QFont, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->underline();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QFont, sipName_underline, doc_QFont_underline);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFont_setUnderline, "setUnderline(self, a0: bool)");

extern "C" {static PyObject *meth_QFont_setUnderline(PyObject *, PyObject *);}
static PyObject *meth_QFont_setUnderline(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool a0;
        ::QFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bb", &sipSelf, sipType_QFont, &sipCpp, &a0))
        {
            sipCpp->setUnderline(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QFont, sipName_setUnderline, doc_QFont_setUnderline);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFont_overline, "overline(self) -> bool");

extern "C" {static PyObject *meth_QFont_overline(PyObject *, PyObject *);}
static PyObject *meth_QFont_overline(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QFont, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->overline();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QFont, sipName_overline, doc_QFont_overline);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFont_setOverline, "setOverline(self, a0: bool)");

extern "C" {static PyObject *meth_QFont_setOverline(PyObject *, PyObject *);}
static PyObject *meth_QFont_setOverline(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool a0;
        ::QFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bb", &sipSelf, sipType_QFont, &sipCpp, &a0))
        {
            sipCpp->setOverline(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QFont, sipName_setOverline, doc_QFont_setOverline);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFont_strikeOut, "strikeOut(self) -> bool");

extern "C" {static PyObject *meth_QFont_strikeOut(PyObject *, PyObject *);}
static PyObject *meth_QFont_strikeOut(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QFont, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->strikeOut();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QFont, sipName_strikeOut, doc_QFont_strikeOut);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFont_setStrikeOut, "setStrikeOut(self, a0: bool)");

extern "C" {static PyObject *meth_QFont_setStrikeOut(PyObject *, PyObject *);}
static PyObject *meth_QFont_setStrikeOut(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool a0;
        ::QFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bb", &sipSelf, sipType_QFont, &sipCpp, &a0))
        {
            sipCpp->setStrikeOut(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QFont, sipName_setStrikeOut, doc_QFont_setStrikeOut);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFont_fixedPitch, "fixedPitch(self) -> bool");

extern "C" {static PyObject *meth_QFont_fixedPitch(PyObject *, PyObject *);}
static PyObject *meth_QFont_fixedPitch(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QFont, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->fixedPitch();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QFont, sipName_fixedPitch, doc_QFont_fixedPitch);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFont_setFixedPitch, "setFixedPitch(self, a0: bool)");

extern "C" {static PyObject *meth_QFont_setFixedPitch(PyObject *, PyObject *);}
static PyObject *meth_QFont_setFixedPitch(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool a0;
        ::QFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bb", &sipSelf, sipType_QFont, &sipCpp, &a0))
        {
            sipCpp->setFixedPitch(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QFont, sipName_setFixedPitch, doc_QFont_setFixedPitch);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFont_kerning, "kerning(self) -> bool");

extern "C" {static PyObject *meth_QFont_kerning(PyObject *, PyObject *);}
static PyObject *meth_QFont_kerning(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QFont, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->kerning();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QFont, sipName_kerning, doc_QFont_kerning);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFont_setKerning, "setKerning(self, a0: bool)");

extern "C" {static PyObject *meth_QFont_setKerning(PyObject *, PyObject *);}
static PyObject *meth_QFont_setKerning(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool a0;
        ::QFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bb", &sipSelf, sipType_QFont, &sipCpp, &a0))
        {
            sipCpp->setKerning(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QFont, sipName_setKerning, doc_QFont_setKerning);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFont_styleHint, "styleHint(self) -> QFont.StyleHint");

extern "C" {static PyObject *meth_QFont_styleHint(PyObject *, PyObject *);}
static PyObject *meth_QFont_styleHint(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QFont, &sipCpp))
        {
            ::QFont::StyleHint sipRes;

            sipRes = sipCpp->styleHint();

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QFont_StyleHint);
        }
    }

    sipNoMethod(sipParseErr, sipName_QFont, sipName_styleHint, doc_QFont_styleHint);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFont_styleStrategy, "styleStrategy(self) -> QFont.StyleStrategy");

extern "C" {static PyObject *meth_QFont_styleStrategy(PyObject *, PyObject *);}
static PyObject *meth_QFont_styleStrategy(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QFont, &sipCpp))
        {
            ::QFont::StyleStrategy sipRes;

            sipRes = sipCpp->styleStrategy();

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QFont_StyleStrategy);
        }
    }

    sipNoMethod(sipParseErr, sipName_QFont, sipName_styleStrategy, doc_QFont_styleStrategy);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFont_setStyleHint, "setStyleHint(self, hint: QFont.StyleHint, strategy: QFont.StyleStrategy = QFont.PreferDefault)");

extern "C" {static PyObject *meth_QFont_setStyleHint(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QFont_setStyleHint(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QFont::StyleHint a0;
        ::QFont::StyleStrategy a1 = QFont::PreferDefault;
        ::QFont *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_strategy,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BE|E", &sipSelf, sipType_QFont, &sipCpp, sipType_QFont_StyleHint, &a0, sipType_QFont_StyleStrategy, &a1))
        {
            sipCpp->setStyleHint(a0, a1);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QFont, sipName_setStyleHint, doc_QFont_setStyleHint);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFont_setStyleStrategy, "setStyleStrategy(self, s: QFont.StyleStrategy)");

extern "C" {static PyObject *meth_QFont_setStyleStrategy(PyObject *, PyObject *);}
static PyObject *meth_QFont_setStyleStrategy(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QFont::StyleStrategy a0;
        ::QFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BE", &sipSelf, sipType_QFont, &sipCpp, sipType_QFont_StyleStrategy, &a0))
        {
            sipCpp->setStyleStrategy(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QFont, sipName_setStyleStrategy, doc_QFont_setStyleStrategy);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFont_stretch, "stretch(self) -> int");

extern "C" {static PyObject *meth_QFont_stretch(PyObject *, PyObject *);}
static PyObject *meth_QFont_stretch(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QFont, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->stretch();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QFont, sipName_stretch, doc_QFont_stretch);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFont_setStretch, "setStretch(self, a0: int)");

extern "C" {static PyObject *meth_QFont_setStretch(PyObject *, PyObject *);}
static PyObject *meth_QFont_setStretch(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        ::QFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QFont, &sipCpp, &a0))
        {
            sipCpp->setStretch(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QFont, sipName_setStretch, doc_QFont_setStretch);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFont_rawMode, "rawMode(self) -> bool");

extern "C" {static PyObject *meth_QFont_rawMode(PyObject *, PyObject *);}
static PyObject *meth_QFont_rawMode(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QFont, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->rawMode();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QFont, sipName_rawMode, doc_QFont_rawMode);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFont_setRawMode, "setRawMode(self, a0: bool)");

extern "C" {static PyObject *meth_QFont_setRawMode(PyObject *, PyObject *);}
static PyObject *meth_QFont_setRawMode(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool a0;
        ::QFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bb", &sipSelf, sipType_QFont, &sipCpp, &a0))
        {
            sipCpp->setRawMode(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QFont, sipName_setRawMode, doc_QFont_setRawMode);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFont_exactMatch, "exactMatch(self) -> bool");

extern "C" {static PyObject *meth_QFont_exactMatch(PyObject *, PyObject *);}
static PyObject *meth_QFont_exactMatch(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QFont, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->exactMatch();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QFont, sipName_exactMatch, doc_QFont_exactMatch);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFont_isCopyOf, "isCopyOf(self, a0: QFont) -> bool");

extern "C" {static PyObject *meth_QFont_isCopyOf(PyObject *, PyObject *);}
static PyObject *meth_QFont_isCopyOf(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QFont* a0;
        const ::QFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QFont, &sipCpp, sipType_QFont, &a0))
        {
            bool sipRes;

            sipRes = sipCpp->isCopyOf(*a0);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QFont, sipName_isCopyOf, doc_QFont_isCopyOf);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFont_setRawName, "setRawName(self, a0: str|None)");

extern "C" {static PyObject *meth_QFont_setRawName(PyObject *, PyObject *);}
static PyObject *meth_QFont_setRawName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        ::QFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QFont, &sipCpp, sipType_QString, &a0, &a0State))
        {
            sipCpp->setRawName(*a0);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QFont, sipName_setRawName, doc_QFont_setRawName);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFont_rawName, "rawName(self) -> str");

extern "C" {static PyObject *meth_QFont_rawName(PyObject *, PyObject *);}
static PyObject *meth_QFont_rawName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QFont, &sipCpp))
        {
            ::QString*sipRes;

            sipRes = new ::QString(sipCpp->rawName());

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QFont, sipName_rawName, doc_QFont_rawName);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFont_key, "key(self) -> str");

extern "C" {static PyObject *meth_QFont_key(PyObject *, PyObject *);}
static PyObject *meth_QFont_key(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QFont, &sipCpp))
        {
            ::QString*sipRes;

            sipRes = new ::QString(sipCpp->key());

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QFont, sipName_key, doc_QFont_key);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFont_toString, "toString(self) -> str");

extern "C" {static PyObject *meth_QFont_toString(PyObject *, PyObject *);}
static PyObject *meth_QFont_toString(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QFont, &sipCpp))
        {
            ::QString*sipRes;

            sipRes = new ::QString(sipCpp->toString());

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QFont, sipName_toString, doc_QFont_toString);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFont_fromString, "fromString(self, a0: str|None) -> bool");

extern "C" {static PyObject *meth_QFont_fromString(PyObject *, PyObject *);}
static PyObject *meth_QFont_fromString(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        ::QFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QFont, &sipCpp, sipType_QString, &a0, &a0State))
        {
            bool sipRes;

            sipRes = sipCpp->fromString(*a0);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QFont, sipName_fromString, doc_QFont_fromString);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFont_substitute, "substitute(a0: str|None) -> str");

extern "C" {static PyObject *meth_QFont_substitute(PyObject *, PyObject *);}
static PyObject *meth_QFont_substitute(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArgs, "J1", sipType_QString, &a0, &a0State))
        {
            ::QString*sipRes;

            sipRes = new ::QString(::QFont::substitute(*a0));
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QFont, sipName_substitute, doc_QFont_substitute);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFont_substitutes, "substitutes(a0: str|None) -> list[str]");

extern "C" {static PyObject *meth_QFont_substitutes(PyObject *, PyObject *);}
static PyObject *meth_QFont_substitutes(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArgs, "J1", sipType_QString, &a0, &a0State))
        {
            ::QStringList*sipRes;

            sipRes = new ::QStringList(::QFont::substitutes(*a0));
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            return sipConvertFromNewType(sipRes, sipType_QStringList, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QFont, sipName_substitutes, doc_QFont_substitutes);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFont_substitutions, "substitutions() -> list[str]");

extern "C" {static PyObject *meth_QFont_substitutions(PyObject *, PyObject *);}
static PyObject *meth_QFont_substitutions(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            ::QStringList*sipRes;

            sipRes = new ::QStringList(::QFont::substitutions());

            return sipConvertFromNewType(sipRes, sipType_QStringList, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QFont, sipName_substitutions, doc_QFont_substitutions);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFont_insertSubstitution, "insertSubstitution(a0: str|None, a1: str|None)");

extern "C" {static PyObject *meth_QFont_insertSubstitution(PyObject *, PyObject *);}
static PyObject *meth_QFont_insertSubstitution(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        const ::QString* a1;
        int a1State = 0;

        if (sipParseArgs(&sipParseErr, sipArgs, "J1J1", sipType_QString, &a0, &a0State, sipType_QString, &a1, &a1State))
        {
            ::QFont::insertSubstitution(*a0, *a1);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);
            sipReleaseType(const_cast< ::QString *>(a1), sipType_QString, a1State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QFont, sipName_insertSubstitution, doc_QFont_insertSubstitution);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFont_insertSubstitutions, "insertSubstitutions(a0: str|None, a1: Iterable[str|None])");

extern "C" {static PyObject *meth_QFont_insertSubstitutions(PyObject *, PyObject *);}
static PyObject *meth_QFont_insertSubstitutions(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        const ::QStringList* a1;
        int a1State = 0;

        if (sipParseArgs(&sipParseErr, sipArgs, "J1J1", sipType_QString, &a0, &a0State, sipType_QStringList, &a1, &a1State))
        {
            ::QFont::insertSubstitutions(*a0, *a1);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);
            sipReleaseType(const_cast< ::QStringList *>(a1), sipType_QStringList, a1State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QFont, sipName_insertSubstitutions, doc_QFont_insertSubstitutions);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFont_removeSubstitutions, "removeSubstitutions(a0: str|None)");

extern "C" {static PyObject *meth_QFont_removeSubstitutions(PyObject *, PyObject *);}
static PyObject *meth_QFont_removeSubstitutions(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArgs, "J1", sipType_QString, &a0, &a0State))
        {
            ::QFont::removeSubstitutions(*a0);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QFont, sipName_removeSubstitutions, doc_QFont_removeSubstitutions);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFont_initialize, "initialize()");

extern "C" {static PyObject *meth_QFont_initialize(PyObject *, PyObject *);}
static PyObject *meth_QFont_initialize(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            ::QFont::initialize();

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QFont, sipName_initialize, doc_QFont_initialize);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFont_cleanup, "cleanup()");

extern "C" {static PyObject *meth_QFont_cleanup(PyObject *, PyObject *);}
static PyObject *meth_QFont_cleanup(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            ::QFont::cleanup();

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QFont, sipName_cleanup, doc_QFont_cleanup);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFont_cacheStatistics, "cacheStatistics()");

extern "C" {static PyObject *meth_QFont_cacheStatistics(PyObject *, PyObject *);}
static PyObject *meth_QFont_cacheStatistics(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            ::QFont::cacheStatistics();

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QFont, sipName_cacheStatistics, doc_QFont_cacheStatistics);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFont_defaultFamily, "defaultFamily(self) -> str");

extern "C" {static PyObject *meth_QFont_defaultFamily(PyObject *, PyObject *);}
static PyObject *meth_QFont_defaultFamily(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QFont, &sipCpp))
        {
            ::QString*sipRes;

            sipRes = new ::QString(sipCpp->defaultFamily());

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QFont, sipName_defaultFamily, doc_QFont_defaultFamily);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFont_lastResortFamily, "lastResortFamily(self) -> str");

extern "C" {static PyObject *meth_QFont_lastResortFamily(PyObject *, PyObject *);}
static PyObject *meth_QFont_lastResortFamily(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QFont, &sipCpp))
        {
            ::QString*sipRes;

            sipRes = new ::QString(sipCpp->lastResortFamily());

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QFont, sipName_lastResortFamily, doc_QFont_lastResortFamily);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFont_lastResortFont, "lastResortFont(self) -> str");

extern "C" {static PyObject *meth_QFont_lastResortFont(PyObject *, PyObject *);}
static PyObject *meth_QFont_lastResortFont(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QFont, &sipCpp))
        {
            ::QString*sipRes;

            sipRes = new ::QString(sipCpp->lastResortFont());

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QFont, sipName_lastResortFont, doc_QFont_lastResortFont);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFont_resolve, "resolve(self, a0: QFont) -> QFont");

extern "C" {static PyObject *meth_QFont_resolve(PyObject *, PyObject *);}
static PyObject *meth_QFont_resolve(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QFont* a0;
        const ::QFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QFont, &sipCpp, sipType_QFont, &a0))
        {
            ::QFont*sipRes;

            sipRes = new ::QFont(sipCpp->resolve(*a0));

            return sipConvertFromNewType(sipRes, sipType_QFont, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QFont, sipName_resolve, doc_QFont_resolve);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFont_bold, "bold(self) -> bool");

extern "C" {static PyObject *meth_QFont_bold(PyObject *, PyObject *);}
static PyObject *meth_QFont_bold(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QFont, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->bold();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QFont, sipName_bold, doc_QFont_bold);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFont_setBold, "setBold(self, enable: bool)");

extern "C" {static PyObject *meth_QFont_setBold(PyObject *, PyObject *);}
static PyObject *meth_QFont_setBold(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool a0;
        ::QFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bb", &sipSelf, sipType_QFont, &sipCpp, &a0))
        {
            sipCpp->setBold(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QFont, sipName_setBold, doc_QFont_setBold);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFont_italic, "italic(self) -> bool");

extern "C" {static PyObject *meth_QFont_italic(PyObject *, PyObject *);}
static PyObject *meth_QFont_italic(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QFont, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->italic();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QFont, sipName_italic, doc_QFont_italic);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFont_setItalic, "setItalic(self, b: bool)");

extern "C" {static PyObject *meth_QFont_setItalic(PyObject *, PyObject *);}
static PyObject *meth_QFont_setItalic(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool a0;
        ::QFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bb", &sipSelf, sipType_QFont, &sipCpp, &a0))
        {
            sipCpp->setItalic(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QFont, sipName_setItalic, doc_QFont_setItalic);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFont_letterSpacing, "letterSpacing(self) -> float");

extern "C" {static PyObject *meth_QFont_letterSpacing(PyObject *, PyObject *);}
static PyObject *meth_QFont_letterSpacing(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QFont, &sipCpp))
        {
            ::qreal sipRes;

            sipRes = sipCpp->letterSpacing();

            return PyFloat_FromDouble(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QFont, sipName_letterSpacing, doc_QFont_letterSpacing);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFont_letterSpacingType, "letterSpacingType(self) -> QFont.SpacingType");

extern "C" {static PyObject *meth_QFont_letterSpacingType(PyObject *, PyObject *);}
static PyObject *meth_QFont_letterSpacingType(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QFont, &sipCpp))
        {
            ::QFont::SpacingType sipRes;

            sipRes = sipCpp->letterSpacingType();

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QFont_SpacingType);
        }
    }

    sipNoMethod(sipParseErr, sipName_QFont, sipName_letterSpacingType, doc_QFont_letterSpacingType);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFont_setLetterSpacing, "setLetterSpacing(self, type: QFont.SpacingType, spacing: float)");

extern "C" {static PyObject *meth_QFont_setLetterSpacing(PyObject *, PyObject *);}
static PyObject *meth_QFont_setLetterSpacing(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QFont::SpacingType a0;
        ::qreal a1;
        ::QFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BEd", &sipSelf, sipType_QFont, &sipCpp, sipType_QFont_SpacingType, &a0, &a1))
        {
            sipCpp->setLetterSpacing(a0, a1);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QFont, sipName_setLetterSpacing, doc_QFont_setLetterSpacing);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFont_wordSpacing, "wordSpacing(self) -> float");

extern "C" {static PyObject *meth_QFont_wordSpacing(PyObject *, PyObject *);}
static PyObject *meth_QFont_wordSpacing(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QFont, &sipCpp))
        {
            ::qreal sipRes;

            sipRes = sipCpp->wordSpacing();

            return PyFloat_FromDouble(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QFont, sipName_wordSpacing, doc_QFont_wordSpacing);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFont_setWordSpacing, "setWordSpacing(self, spacing: float)");

extern "C" {static PyObject *meth_QFont_setWordSpacing(PyObject *, PyObject *);}
static PyObject *meth_QFont_setWordSpacing(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qreal a0;
        ::QFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bd", &sipSelf, sipType_QFont, &sipCpp, &a0))
        {
            sipCpp->setWordSpacing(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QFont, sipName_setWordSpacing, doc_QFont_setWordSpacing);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFont_setCapitalization, "setCapitalization(self, a0: QFont.Capitalization)");

extern "C" {static PyObject *meth_QFont_setCapitalization(PyObject *, PyObject *);}
static PyObject *meth_QFont_setCapitalization(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QFont::Capitalization a0;
        ::QFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BE", &sipSelf, sipType_QFont, &sipCpp, sipType_QFont_Capitalization, &a0))
        {
            sipCpp->setCapitalization(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QFont, sipName_setCapitalization, doc_QFont_setCapitalization);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFont_capitalization, "capitalization(self) -> QFont.Capitalization");

extern "C" {static PyObject *meth_QFont_capitalization(PyObject *, PyObject *);}
static PyObject *meth_QFont_capitalization(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QFont, &sipCpp))
        {
            ::QFont::Capitalization sipRes;

            sipRes = sipCpp->capitalization();

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QFont_Capitalization);
        }
    }

    sipNoMethod(sipParseErr, sipName_QFont, sipName_capitalization, doc_QFont_capitalization);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFont_styleName, "styleName(self) -> str");

extern "C" {static PyObject *meth_QFont_styleName(PyObject *, PyObject *);}
static PyObject *meth_QFont_styleName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QFont, &sipCpp))
        {
            ::QString*sipRes;

            sipRes = new ::QString(sipCpp->styleName());

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QFont, sipName_styleName, doc_QFont_styleName);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFont_setStyleName, "setStyleName(self, styleName: str|None)");

extern "C" {static PyObject *meth_QFont_setStyleName(PyObject *, PyObject *);}
static PyObject *meth_QFont_setStyleName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        ::QFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QFont, &sipCpp, sipType_QString, &a0, &a0State))
        {
            sipCpp->setStyleName(*a0);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QFont, sipName_setStyleName, doc_QFont_setStyleName);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFont_setHintingPreference, "setHintingPreference(self, hintingPreference: QFont.HintingPreference)");

extern "C" {static PyObject *meth_QFont_setHintingPreference(PyObject *, PyObject *);}
static PyObject *meth_QFont_setHintingPreference(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QFont::HintingPreference a0;
        ::QFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BE", &sipSelf, sipType_QFont, &sipCpp, sipType_QFont_HintingPreference, &a0))
        {
            sipCpp->setHintingPreference(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QFont, sipName_setHintingPreference, doc_QFont_setHintingPreference);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFont_hintingPreference, "hintingPreference(self) -> QFont.HintingPreference");

extern "C" {static PyObject *meth_QFont_hintingPreference(PyObject *, PyObject *);}
static PyObject *meth_QFont_hintingPreference(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QFont, &sipCpp))
        {
            ::QFont::HintingPreference sipRes;

            sipRes = sipCpp->hintingPreference();

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QFont_HintingPreference);
        }
    }

    sipNoMethod(sipParseErr, sipName_QFont, sipName_hintingPreference, doc_QFont_hintingPreference);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFont_swap, "swap(self, other: QFont)");

extern "C" {static PyObject *meth_QFont_swap(PyObject *, PyObject *);}
static PyObject *meth_QFont_swap(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QFont* a0;
        ::QFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QFont, &sipCpp, sipType_QFont, &a0))
        {
            sipCpp->swap(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QFont, sipName_swap, doc_QFont_swap);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFont_families, "families(self) -> list[str]");

extern "C" {static PyObject *meth_QFont_families(PyObject *, PyObject *);}
static PyObject *meth_QFont_families(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QFont, &sipCpp))
        {
            ::QStringList*sipRes;

            sipRes = new ::QStringList(sipCpp->families());

            return sipConvertFromNewType(sipRes, sipType_QStringList, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QFont, sipName_families, doc_QFont_families);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFont_setFamilies, "setFamilies(self, a0: Iterable[str|None])");

extern "C" {static PyObject *meth_QFont_setFamilies(PyObject *, PyObject *);}
static PyObject *meth_QFont_setFamilies(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QStringList* a0;
        int a0State = 0;
        ::QFont *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QFont, &sipCpp, sipType_QStringList, &a0, &a0State))
        {
            sipCpp->setFamilies(*a0);
            sipReleaseType(const_cast< ::QStringList *>(a0), sipType_QStringList, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QFont, sipName_setFamilies, doc_QFont_setFamilies);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *slot_QFont___ge__(PyObject *, PyObject *);}
static PyObject *slot_QFont___ge__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QFont *sipCpp = reinterpret_cast< ::QFont *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QFont));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QFont* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QFont, &a0))
        {
            bool sipRes;

            sipRes = !sipCpp->::QFont::operator<(*a0);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI_QtGui, ge_slot, sipType_QFont, sipSelf, sipArg);
}


extern "C" {static long slot_QFont___hash__(PyObject *);}
static long slot_QFont___hash__(PyObject *sipSelf)
{
    ::QFont *sipCpp = reinterpret_cast< ::QFont *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QFont));

    if (!sipCpp)
        return 0L;


    {
        {
            long sipRes = 0;

#line 223 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtGui/qfont.sip"
        sipRes = qHash(*sipCpp);
#line 1879 "/build/pyqt5/src/PyQt5-5.15.11/build/QtGui/sipQtGuiQFont.cpp"

            return sipRes;
        }
    }

    return 0;
}


extern "C" {static PyObject *slot_QFont___lt__(PyObject *, PyObject *);}
static PyObject *slot_QFont___lt__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QFont *sipCpp = reinterpret_cast< ::QFont *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QFont));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QFont* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QFont, &a0))
        {
            bool sipRes;

            sipRes = sipCpp->::QFont::operator<(*a0);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI_QtGui, lt_slot, sipType_QFont, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QFont___ne__(PyObject *, PyObject *);}
static PyObject *slot_QFont___ne__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QFont *sipCpp = reinterpret_cast< ::QFont *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QFont));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QFont* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QFont, &a0))
        {
            bool sipRes;

            sipRes = sipCpp->::QFont::operator!=(*a0);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI_QtGui, ne_slot, sipType_QFont, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QFont___eq__(PyObject *, PyObject *);}
static PyObject *slot_QFont___eq__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QFont *sipCpp = reinterpret_cast< ::QFont *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QFont));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QFont* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QFont, &a0))
        {
            bool sipRes;

            sipRes = sipCpp->::QFont::operator==(*a0);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI_QtGui, eq_slot, sipType_QFont, sipSelf, sipArg);
}


/* Call the instance's destructor. */
extern "C" {static void release_QFont(void *, int);}
static void release_QFont(void *sipCppV, int)
{
    delete reinterpret_cast< ::QFont *>(sipCppV);
}


extern "C" {static void *array_QFont(Py_ssize_t);}
static void *array_QFont(Py_ssize_t sipNrElem)
{
    return new ::QFont[sipNrElem];
}


extern "C" {static void array_delete_QFont(void *);}
static void array_delete_QFont(void *sipCpp)
{
    delete[] reinterpret_cast< ::QFont *>(sipCpp);
}


extern "C" {static void assign_QFont(void *, Py_ssize_t, void *);}
static void assign_QFont(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::QFont *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::QFont *>(sipSrc);
}


extern "C" {static void *copy_QFont(const void *, Py_ssize_t);}
static void *copy_QFont(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::QFont(reinterpret_cast<const ::QFont *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_QFont(sipSimpleWrapper *);}
static void dealloc_QFont(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QFont(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QFont(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QFont(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::QFont *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            sipCpp = new ::QFont();

            return sipCpp;
        }
    }

    {
        const ::QString* a0;
        int a0State = 0;
        int a1 = -1;
        int a2 = -1;
        bool a3 = 0;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_pointSize,
            sipName_weight,
            sipName_italic,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J1|iib", sipType_QString, &a0, &a0State, &a1, &a2, &a3))
        {
            sipCpp = new ::QFont(*a0, a1, a2, a3);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            return sipCpp;
        }
    }

    {
        const ::QFont* a0;
        ::QPaintDevice* a1;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9J8", sipType_QFont, &a0, sipType_QPaintDevice, &a1))
        {
            sipCpp = new ::QFont(*a0, a1);

            return sipCpp;
        }
    }

    {
        const ::QFont* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QFont, &a0))
        {
            sipCpp = new ::QFont(*a0);

            return sipCpp;
        }
    }

    {
        const ::QVariant* a0;
        PyObject *a0Wrapper;
        int a0State = 0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "@J1", &a0Wrapper, sipType_QVariant, &a0, &a0State))
        {
            sipErrorState sipError = sipErrorNone;

#line 119 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtGui/qfont.sip"
        if (a0->canConvert<QFont>())
            sipCpp = new QFont(a0->value<QFont>());
        else
            sipError = sipBadCallableArg(0, a0Wrapper);
#line 2096 "/build/pyqt5/src/PyQt5-5.15.11/build/QtGui/sipQtGuiQFont.cpp"
            sipReleaseType(const_cast< ::QVariant *>(a0), sipType_QVariant, a0State);

            if (sipError == sipErrorNone)
                return sipCpp;

            if (sipUnused)
            {
                Py_XDECREF(*sipUnused);
            }

            sipAddException(sipError, sipParseErr);

            if (sipError == sipErrorFail)
                return SIP_NULLPTR;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_QFont[] = {
    {(void *)slot_QFont___ge__, ge_slot},
    {(void *)slot_QFont___hash__, hash_slot},
    {(void *)slot_QFont___lt__, lt_slot},
    {(void *)slot_QFont___ne__, ne_slot},
    {(void *)slot_QFont___eq__, eq_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_QFont[] = {
    {sipName_bold, meth_QFont_bold, METH_VARARGS, doc_QFont_bold},
    {sipName_cacheStatistics, meth_QFont_cacheStatistics, METH_VARARGS, doc_QFont_cacheStatistics},
    {sipName_capitalization, meth_QFont_capitalization, METH_VARARGS, doc_QFont_capitalization},
    {sipName_cleanup, meth_QFont_cleanup, METH_VARARGS, doc_QFont_cleanup},
    {sipName_defaultFamily, meth_QFont_defaultFamily, METH_VARARGS, doc_QFont_defaultFamily},
    {sipName_exactMatch, meth_QFont_exactMatch, METH_VARARGS, doc_QFont_exactMatch},
    {sipName_families, meth_QFont_families, METH_VARARGS, doc_QFont_families},
    {sipName_family, meth_QFont_family, METH_VARARGS, doc_QFont_family},
    {sipName_fixedPitch, meth_QFont_fixedPitch, METH_VARARGS, doc_QFont_fixedPitch},
    {sipName_fromString, meth_QFont_fromString, METH_VARARGS, doc_QFont_fromString},
    {sipName_hintingPreference, meth_QFont_hintingPreference, METH_VARARGS, doc_QFont_hintingPreference},
    {sipName_initialize, meth_QFont_initialize, METH_VARARGS, doc_QFont_initialize},
    {sipName_insertSubstitution, meth_QFont_insertSubstitution, METH_VARARGS, doc_QFont_insertSubstitution},
    {sipName_insertSubstitutions, meth_QFont_insertSubstitutions, METH_VARARGS, doc_QFont_insertSubstitutions},
    {sipName_isCopyOf, meth_QFont_isCopyOf, METH_VARARGS, doc_QFont_isCopyOf},
    {sipName_italic, meth_QFont_italic, METH_VARARGS, doc_QFont_italic},
    {sipName_kerning, meth_QFont_kerning, METH_VARARGS, doc_QFont_kerning},
    {sipName_key, meth_QFont_key, METH_VARARGS, doc_QFont_key},
    {sipName_lastResortFamily, meth_QFont_lastResortFamily, METH_VARARGS, doc_QFont_lastResortFamily},
    {sipName_lastResortFont, meth_QFont_lastResortFont, METH_VARARGS, doc_QFont_lastResortFont},
    {sipName_letterSpacing, meth_QFont_letterSpacing, METH_VARARGS, doc_QFont_letterSpacing},
    {sipName_letterSpacingType, meth_QFont_letterSpacingType, METH_VARARGS, doc_QFont_letterSpacingType},
    {sipName_overline, meth_QFont_overline, METH_VARARGS, doc_QFont_overline},
    {sipName_pixelSize, meth_QFont_pixelSize, METH_VARARGS, doc_QFont_pixelSize},
    {sipName_pointSize, meth_QFont_pointSize, METH_VARARGS, doc_QFont_pointSize},
    {sipName_pointSizeF, meth_QFont_pointSizeF, METH_VARARGS, doc_QFont_pointSizeF},
    {sipName_rawMode, meth_QFont_rawMode, METH_VARARGS, doc_QFont_rawMode},
    {sipName_rawName, meth_QFont_rawName, METH_VARARGS, doc_QFont_rawName},
    {sipName_removeSubstitutions, meth_QFont_removeSubstitutions, METH_VARARGS, doc_QFont_removeSubstitutions},
    {sipName_resolve, meth_QFont_resolve, METH_VARARGS, doc_QFont_resolve},
    {sipName_setBold, meth_QFont_setBold, METH_VARARGS, doc_QFont_setBold},
    {sipName_setCapitalization, meth_QFont_setCapitalization, METH_VARARGS, doc_QFont_setCapitalization},
    {sipName_setFamilies, meth_QFont_setFamilies, METH_VARARGS, doc_QFont_setFamilies},
    {sipName_setFamily, meth_QFont_setFamily, METH_VARARGS, doc_QFont_setFamily},
    {sipName_setFixedPitch, meth_QFont_setFixedPitch, METH_VARARGS, doc_QFont_setFixedPitch},
    {sipName_setHintingPreference, meth_QFont_setHintingPreference, METH_VARARGS, doc_QFont_setHintingPreference},
    {sipName_setItalic, meth_QFont_setItalic, METH_VARARGS, doc_QFont_setItalic},
    {sipName_setKerning, meth_QFont_setKerning, METH_VARARGS, doc_QFont_setKerning},
    {sipName_setLetterSpacing, meth_QFont_setLetterSpacing, METH_VARARGS, doc_QFont_setLetterSpacing},
    {sipName_setOverline, meth_QFont_setOverline, METH_VARARGS, doc_QFont_setOverline},
    {sipName_setPixelSize, meth_QFont_setPixelSize, METH_VARARGS, doc_QFont_setPixelSize},
    {sipName_setPointSize, meth_QFont_setPointSize, METH_VARARGS, doc_QFont_setPointSize},
    {sipName_setPointSizeF, meth_QFont_setPointSizeF, METH_VARARGS, doc_QFont_setPointSizeF},
    {sipName_setRawMode, meth_QFont_setRawMode, METH_VARARGS, doc_QFont_setRawMode},
    {sipName_setRawName, meth_QFont_setRawName, METH_VARARGS, doc_QFont_setRawName},
    {sipName_setStretch, meth_QFont_setStretch, METH_VARARGS, doc_QFont_setStretch},
    {sipName_setStrikeOut, meth_QFont_setStrikeOut, METH_VARARGS, doc_QFont_setStrikeOut},
    {sipName_setStyle, meth_QFont_setStyle, METH_VARARGS, doc_QFont_setStyle},
    {sipName_setStyleHint, SIP_MLMETH_CAST(meth_QFont_setStyleHint), METH_VARARGS|METH_KEYWORDS, doc_QFont_setStyleHint},
    {sipName_setStyleName, meth_QFont_setStyleName, METH_VARARGS, doc_QFont_setStyleName},
    {sipName_setStyleStrategy, meth_QFont_setStyleStrategy, METH_VARARGS, doc_QFont_setStyleStrategy},
    {sipName_setUnderline, meth_QFont_setUnderline, METH_VARARGS, doc_QFont_setUnderline},
    {sipName_setWeight, meth_QFont_setWeight, METH_VARARGS, doc_QFont_setWeight},
    {sipName_setWordSpacing, meth_QFont_setWordSpacing, METH_VARARGS, doc_QFont_setWordSpacing},
    {sipName_stretch, meth_QFont_stretch, METH_VARARGS, doc_QFont_stretch},
    {sipName_strikeOut, meth_QFont_strikeOut, METH_VARARGS, doc_QFont_strikeOut},
    {sipName_style, meth_QFont_style, METH_VARARGS, doc_QFont_style},
    {sipName_styleHint, meth_QFont_styleHint, METH_VARARGS, doc_QFont_styleHint},
    {sipName_styleName, meth_QFont_styleName, METH_VARARGS, doc_QFont_styleName},
    {sipName_styleStrategy, meth_QFont_styleStrategy, METH_VARARGS, doc_QFont_styleStrategy},
    {sipName_substitute, meth_QFont_substitute, METH_VARARGS, doc_QFont_substitute},
    {sipName_substitutes, meth_QFont_substitutes, METH_VARARGS, doc_QFont_substitutes},
    {sipName_substitutions, meth_QFont_substitutions, METH_VARARGS, doc_QFont_substitutions},
    {sipName_swap, meth_QFont_swap, METH_VARARGS, doc_QFont_swap},
    {sipName_toString, meth_QFont_toString, METH_VARARGS, doc_QFont_toString},
    {sipName_underline, meth_QFont_underline, METH_VARARGS, doc_QFont_underline},
    {sipName_weight, meth_QFont_weight, METH_VARARGS, doc_QFont_weight},
    {sipName_wordSpacing, meth_QFont_wordSpacing, METH_VARARGS, doc_QFont_wordSpacing}
};

static sipEnumMemberDef enummembers_QFont[] = {
    {sipName_AbsoluteSpacing, static_cast<int>(::QFont::AbsoluteSpacing), 41},
    {sipName_AllLowercase, static_cast<int>(::QFont::AllLowercase), 39},
    {sipName_AllUppercase, static_cast<int>(::QFont::AllUppercase), 39},
    {sipName_AnyStretch, static_cast<int>(::QFont::AnyStretch), 42},
    {sipName_AnyStyle, static_cast<int>(::QFont::AnyStyle), 44},
    {sipName_Black, static_cast<int>(::QFont::Black), 46},
    {sipName_Bold, static_cast<int>(::QFont::Bold), 46},
    {sipName_Capitalize, static_cast<int>(::QFont::Capitalize), 39},
    {sipName_Condensed, static_cast<int>(::QFont::Condensed), 42},
    {sipName_Courier, static_cast<int>(::QFont::Courier), 44},
    {sipName_Cursive, static_cast<int>(::QFont::Cursive), 44},
    {sipName_Decorative, static_cast<int>(::QFont::Decorative), 44},
    {sipName_DemiBold, static_cast<int>(::QFont::DemiBold), 46},
    {sipName_Expanded, static_cast<int>(::QFont::Expanded), 42},
    {sipName_ExtraBold, static_cast<int>(::QFont::ExtraBold), 46},
    {sipName_ExtraCondensed, static_cast<int>(::QFont::ExtraCondensed), 42},
    {sipName_ExtraExpanded, static_cast<int>(::QFont::ExtraExpanded), 42},
    {sipName_ExtraLight, static_cast<int>(::QFont::ExtraLight), 46},
    {sipName_Fantasy, static_cast<int>(::QFont::Fantasy), 44},
    {sipName_ForceIntegerMetrics, static_cast<int>(::QFont::ForceIntegerMetrics), 45},
    {sipName_ForceOutline, static_cast<int>(::QFont::ForceOutline), 45},
    {sipName_Helvetica, static_cast<int>(::QFont::Helvetica), 44},
    {sipName_Light, static_cast<int>(::QFont::Light), 46},
    {sipName_Medium, static_cast<int>(::QFont::Medium), 46},
    {sipName_MixedCase, static_cast<int>(::QFont::MixedCase), 39},
    {sipName_Monospace, static_cast<int>(::QFont::Monospace), 44},
    {sipName_NoAntialias, static_cast<int>(::QFont::NoAntialias), 45},
    {sipName_NoFontMerging, static_cast<int>(::QFont::NoFontMerging), 45},
    {sipName_NoSubpixelAntialias, static_cast<int>(::QFont::NoSubpixelAntialias), 45},
    {sipName_Normal, static_cast<int>(::QFont::Normal), 46},
    {sipName_OldEnglish, static_cast<int>(::QFont::OldEnglish), 44},
    {sipName_OpenGLCompatible, static_cast<int>(::QFont::OpenGLCompatible), 45},
    {sipName_PercentageSpacing, static_cast<int>(::QFont::PercentageSpacing), 41},
    {sipName_PreferAntialias, static_cast<int>(::QFont::PreferAntialias), 45},
    {sipName_PreferBitmap, static_cast<int>(::QFont::PreferBitmap), 45},
    {sipName_PreferDefault, static_cast<int>(::QFont::PreferDefault), 45},
    {sipName_PreferDefaultHinting, static_cast<int>(::QFont::PreferDefaultHinting), 40},
    {sipName_PreferDevice, static_cast<int>(::QFont::PreferDevice), 45},
    {sipName_PreferFullHinting, static_cast<int>(::QFont::PreferFullHinting), 40},
    {sipName_PreferMatch, static_cast<int>(::QFont::PreferMatch), 45},
    {sipName_PreferNoHinting, static_cast<int>(::QFont::PreferNoHinting), 40},
    {sipName_PreferNoShaping, static_cast<int>(::QFont::PreferNoShaping), 45},
    {sipName_PreferOutline, static_cast<int>(::QFont::PreferOutline), 45},
    {sipName_PreferQuality, static_cast<int>(::QFont::PreferQuality), 45},
    {sipName_PreferVerticalHinting, static_cast<int>(::QFont::PreferVerticalHinting), 40},
    {sipName_SansSerif, static_cast<int>(::QFont::SansSerif), 44},
    {sipName_SemiCondensed, static_cast<int>(::QFont::SemiCondensed), 42},
    {sipName_SemiExpanded, static_cast<int>(::QFont::SemiExpanded), 42},
    {sipName_Serif, static_cast<int>(::QFont::Serif), 44},
    {sipName_SmallCaps, static_cast<int>(::QFont::SmallCaps), 39},
    {sipName_StyleItalic, static_cast<int>(::QFont::StyleItalic), 43},
    {sipName_StyleNormal, static_cast<int>(::QFont::StyleNormal), 43},
    {sipName_StyleOblique, static_cast<int>(::QFont::StyleOblique), 43},
    {sipName_System, static_cast<int>(::QFont::System), 44},
    {sipName_Thin, static_cast<int>(::QFont::Thin), 46},
    {sipName_Times, static_cast<int>(::QFont::Times), 44},
    {sipName_TypeWriter, static_cast<int>(::QFont::TypeWriter), 44},
    {sipName_UltraCondensed, static_cast<int>(::QFont::UltraCondensed), 42},
    {sipName_UltraExpanded, static_cast<int>(::QFont::UltraExpanded), 42},
    {sipName_Unstretched, static_cast<int>(::QFont::Unstretched), 42},
};

PyDoc_STRVAR(doc_QFont, "\1QFont()\n"
"QFont(family: str|None, pointSize: int = -1, weight: int = -1, italic: bool = False)\n"
"QFont(a0: QFont, pd: QPaintDevice|None)\n"
"QFont(a0: QFont)\n"
"QFont(variant: Any)");


static pyqt5ClassPluginDef plugin_QFont = {
    SIP_NULLPTR,
    0,
    SIP_NULLPTR,
    SIP_NULLPTR
};


sipClassTypeDef sipTypeDef_QtGui_QFont = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_LIMITED_API|SIP_TYPE_CLASS,
        sipNameNr_QFont,
        SIP_NULLPTR,
        &plugin_QFont,
    },
    {
        sipNameNr_QFont,
        {0, 0, 1},
        68, methods_QFont,
        60, enummembers_QFont,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QFont,
    -1,
    sipNameNr_sip_simplewrapper,
    SIP_NULLPTR,
    slots_QFont,
    init_type_QFont,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QFont,
    assign_QFont,
    array_QFont,
    copy_QFont,
    release_QFont,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_QFont,
    sizeof (::QFont),
};
