/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, blocks, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_blocks_exponentiate_const_cci = R"doc(Exponentiates a complex stream with an integer exponent.

This block raises a complex stream to an integer exponent. The exponent must be at least 1. There is a callback function so the exponent can be changed at runtime.


NOTE: The algorithm uses iterative multiplication to achieve exponentiation, hence it is O(exponent). Therefore, this block could be inefficient for large exponents.

Constructor Specific Documentation:



Args:
    exponent : 
    vlen : )doc";


static const char* __doc_gr_blocks_exponentiate_const_cci_exponentiate_const_cci_0 =
    R"doc()doc";


static const char* __doc_gr_blocks_exponentiate_const_cci_exponentiate_const_cci_1 =
    R"doc()doc";


static const char* __doc_gr_blocks_exponentiate_const_cci_make = R"doc(Exponentiates a complex stream with an integer exponent.

This block raises a complex stream to an integer exponent. The exponent must be at least 1. There is a callback function so the exponent can be changed at runtime.


NOTE: The algorithm uses iterative multiplication to achieve exponentiation, hence it is O(exponent). Therefore, this block could be inefficient for large exponents.

Constructor Specific Documentation:



Args:
    exponent : 
    vlen : )doc";


static const char* __doc_gr_blocks_exponentiate_const_cci_set_exponent = R"doc()doc";
