/* PlacesIndicator.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from PlacesIndicator.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "placesindicator.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "plugin.h"
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <libpeas.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PLACES_INDICATOR_0_PROPERTY,
	PLACES_INDICATOR_NUM_PROPERTIES
};
static GParamSpec* places_indicator_properties[PLACES_INDICATOR_NUM_PROPERTIES];
enum  {
	PLACES_INDICATOR_SETTINGS_0_PROPERTY,
	PLACES_INDICATOR_SETTINGS_NUM_PROPERTIES
};
static GParamSpec* places_indicator_settings_properties[PLACES_INDICATOR_SETTINGS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	PLACES_INDICATOR_APPLET_0_PROPERTY,
	PLACES_INDICATOR_APPLET_UUID_PROPERTY,
	PLACES_INDICATOR_APPLET_NUM_PROPERTIES
};
static GParamSpec* places_indicator_applet_properties[PLACES_INDICATOR_APPLET_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))

struct _PlacesIndicatorSettingsPrivate {
	GtkSwitch* switch_label;
	GtkSwitch* switch_places;
	GtkSwitch* switch_expand_places;
	GtkSwitch* switch_drives;
	GtkSwitch* switch_networks;
	GSettings* settings;
};

struct _PlacesIndicatorAppletPrivate {
	GtkEventBox* ebox;
	PlacesIndicatorWindow* popover;
	GtkLabel* label;
	GtkImage* image;
	BudgiePanelPosition panel_position;
	BudgiePopoverManager* manager;
	GSettings* settings;
	gchar* _uuid;
};

static gpointer places_indicator_parent_class = NULL;
static BudgiePluginIface * places_indicator_budgie_plugin_parent_iface = NULL;
static GType places_indicator_type_id = 0;
static gint PlacesIndicatorSettings_private_offset;
static gpointer places_indicator_settings_parent_class = NULL;
static GType places_indicator_settings_type_id = 0;
static gint PlacesIndicatorApplet_private_offset;
static gpointer places_indicator_applet_parent_class = NULL;
static GType places_indicator_applet_type_id = 0;

static BudgieApplet* places_indicator_real_get_panel_widget (BudgiePlugin* base,
                                                      const gchar* uuid);
static void places_indicator_settings_finalize (GObject * obj);
static GtkWidget* places_indicator_applet_real_get_settings_ui (BudgieApplet* base);
static gboolean places_indicator_applet_real_supports_settings (BudgieApplet* base);
static void _places_indicator_applet_on_settings_changed_g_settings_changed (GSettings* _sender,
                                                                      const gchar* key,
                                                                      gpointer self);
static gboolean __lambda13_ (PlacesIndicatorApplet* self,
                      GdkEventButton* e);
static gboolean ___lambda13__gtk_widget_button_press_event (GtkWidget* _sender,
                                                     GdkEventButton* event,
                                                     gpointer self);
static void places_indicator_applet_real_panel_position_changed (BudgieApplet* base,
                                                          BudgiePanelPosition position);
static void places_indicator_applet_real_invoke_action (BudgieApplet* base,
                                                 BudgiePanelAction action);
static void places_indicator_applet_real_update_popovers (BudgieApplet* base,
                                                   BudgiePopoverManager* manager);
static void places_indicator_applet_finalize (GObject * obj);
static void _vala_places_indicator_applet_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_places_indicator_applet_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);
GType places_indicator_window_register_type (GTypeModule * module);
GType message_revealer_register_type (GTypeModule * module);
GType places_section_register_type (GTypeModule * module);
GType list_item_register_type (GTypeModule * module);
GType volume_item_register_type (GTypeModule * module);
GType mount_item_register_type (GTypeModule * module);
GType place_item_register_type (GTypeModule * module);
GType mount_helper_register_type (GTypeModule * module);

static BudgieApplet*
places_indicator_real_get_panel_widget (BudgiePlugin* base,
                                        const gchar* uuid)
{
	PlacesIndicator * self;
	PlacesIndicatorApplet* _tmp0_;
	BudgieApplet* result;
	self = (PlacesIndicator*) base;
	g_return_val_if_fail (uuid != NULL, NULL);
	_tmp0_ = places_indicator_applet_new (uuid);
	g_object_ref_sink (_tmp0_);
	result = (BudgieApplet*) _tmp0_;
	return result;
}

PlacesIndicator*
places_indicator_construct (GType object_type)
{
	PlacesIndicator * self = NULL;
	self = (PlacesIndicator*) g_object_new (object_type, NULL);
	return self;
}

PlacesIndicator*
places_indicator_new (void)
{
	return places_indicator_construct (TYPE_PLACES_INDICATOR);
}

static void
places_indicator_class_init (PlacesIndicatorClass * klass,
                             gpointer klass_data)
{
	places_indicator_parent_class = g_type_class_peek_parent (klass);
}

static void
places_indicator_budgie_plugin_interface_init (BudgiePluginIface * iface,
                                               gpointer iface_data)
{
	places_indicator_budgie_plugin_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_panel_widget = (BudgieApplet* (*) (BudgiePlugin*, const gchar*)) places_indicator_real_get_panel_widget;
}

static void
places_indicator_instance_init (PlacesIndicator * self,
                                gpointer klass)
{
}

GType
places_indicator_get_type (void)
{
	return places_indicator_type_id;
}

GType
places_indicator_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (PlacesIndicatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) places_indicator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PlacesIndicator), 0, (GInstanceInitFunc) places_indicator_instance_init, NULL };
	static const GInterfaceInfo budgie_plugin_info = { (GInterfaceInitFunc) places_indicator_budgie_plugin_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	places_indicator_type_id = g_type_module_register_type (module, peas_extension_base_get_type (), "PlacesIndicator", &g_define_type_info, 0);
	g_type_module_add_interface (module, places_indicator_type_id, budgie_plugin_get_type (), &budgie_plugin_info);
	return places_indicator_type_id;
}

static inline gpointer
places_indicator_settings_get_instance_private (PlacesIndicatorSettings* self)
{
	return G_STRUCT_MEMBER_P (self, PlacesIndicatorSettings_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

PlacesIndicatorSettings*
places_indicator_settings_construct (GType object_type,
                                     GSettings* settings)
{
	PlacesIndicatorSettings * self = NULL;
	GSettings* _tmp0_;
	GtkSwitch* _tmp1_;
	GtkSwitch* _tmp2_;
	GtkSwitch* _tmp3_;
	GtkSwitch* _tmp4_;
	GtkSwitch* _tmp5_;
	self = (PlacesIndicatorSettings*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (settings);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = self->priv->switch_label;
	g_settings_bind (settings, "show-label", (GObject*) _tmp1_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp2_ = self->priv->switch_expand_places;
	g_settings_bind (settings, "expand-places", (GObject*) _tmp2_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp3_ = self->priv->switch_places;
	g_settings_bind (settings, "show-places", (GObject*) _tmp3_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp4_ = self->priv->switch_drives;
	g_settings_bind (settings, "show-drives", (GObject*) _tmp4_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp5_ = self->priv->switch_networks;
	g_settings_bind (settings, "show-networks", (GObject*) _tmp5_, "active", G_SETTINGS_BIND_DEFAULT);
	return self;
}

PlacesIndicatorSettings*
places_indicator_settings_new (GSettings* settings)
{
	return places_indicator_settings_construct (TYPE_PLACES_INDICATOR_SETTINGS, settings);
}

static void
places_indicator_settings_class_init (PlacesIndicatorSettingsClass * klass,
                                      gpointer klass_data)
{
	places_indicator_settings_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PlacesIndicatorSettings_private_offset);
	G_OBJECT_CLASS (klass)->finalize = places_indicator_settings_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/com/solus-project/places-indicator/settings.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "switch_label", FALSE, PlacesIndicatorSettings_private_offset + G_STRUCT_OFFSET (PlacesIndicatorSettingsPrivate, switch_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "switch_places", FALSE, PlacesIndicatorSettings_private_offset + G_STRUCT_OFFSET (PlacesIndicatorSettingsPrivate, switch_places));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "switch_expand_places", FALSE, PlacesIndicatorSettings_private_offset + G_STRUCT_OFFSET (PlacesIndicatorSettingsPrivate, switch_expand_places));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "switch_drives", FALSE, PlacesIndicatorSettings_private_offset + G_STRUCT_OFFSET (PlacesIndicatorSettingsPrivate, switch_drives));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "switch_networks", FALSE, PlacesIndicatorSettings_private_offset + G_STRUCT_OFFSET (PlacesIndicatorSettingsPrivate, switch_networks));
}

static void
places_indicator_settings_instance_init (PlacesIndicatorSettings * self,
                                         gpointer klass)
{
	self->priv = places_indicator_settings_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
places_indicator_settings_finalize (GObject * obj)
{
	PlacesIndicatorSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PLACES_INDICATOR_SETTINGS, PlacesIndicatorSettings);
	_g_object_unref0 (self->priv->settings);
	G_OBJECT_CLASS (places_indicator_settings_parent_class)->finalize (obj);
}

GType
places_indicator_settings_get_type (void)
{
	return places_indicator_settings_type_id;
}

GType
places_indicator_settings_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (PlacesIndicatorSettingsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) places_indicator_settings_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PlacesIndicatorSettings), 0, (GInstanceInitFunc) places_indicator_settings_instance_init, NULL };
	places_indicator_settings_type_id = g_type_module_register_type (module, gtk_grid_get_type (), "PlacesIndicatorSettings", &g_define_type_info, 0);
	PlacesIndicatorSettings_private_offset = sizeof (PlacesIndicatorSettingsPrivate);
	return places_indicator_settings_type_id;
}

static inline gpointer
places_indicator_applet_get_instance_private (PlacesIndicatorApplet* self)
{
	return G_STRUCT_MEMBER_P (self, PlacesIndicatorApplet_private_offset);
}

static GtkWidget*
places_indicator_applet_real_get_settings_ui (BudgieApplet* base)
{
	PlacesIndicatorApplet * self;
	const gchar* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	PlacesIndicatorSettings* _tmp3_;
	GtkWidget* _tmp4_;
	GtkWidget* result;
	self = (PlacesIndicatorApplet*) base;
	_tmp0_ = self->priv->_uuid;
	_tmp1_ = budgie_applet_get_applet_settings ((BudgieApplet*) self, _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = places_indicator_settings_new (_tmp2_);
	g_object_ref_sink (_tmp3_);
	_tmp4_ = (GtkWidget*) _tmp3_;
	_g_object_unref0 (_tmp2_);
	result = _tmp4_;
	return result;
}

static gboolean
places_indicator_applet_real_supports_settings (BudgieApplet* base)
{
	PlacesIndicatorApplet * self;
	gboolean result;
	self = (PlacesIndicatorApplet*) base;
	result = TRUE;
	return result;
}

static void
_places_indicator_applet_on_settings_changed_g_settings_changed (GSettings* _sender,
                                                                 const gchar* key,
                                                                 gpointer self)
{
	places_indicator_applet_on_settings_changed ((PlacesIndicatorApplet*) self, key);
}

static gboolean
__lambda13_ (PlacesIndicatorApplet* self,
             GdkEventButton* e)
{
	gboolean result;
	g_return_val_if_fail (e != NULL, FALSE);
	if (e->button != ((guint) 1)) {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	places_indicator_applet_toggle_popover (self);
	result = GDK_EVENT_STOP;
	return result;
}

static gboolean
___lambda13__gtk_widget_button_press_event (GtkWidget* _sender,
                                            GdkEventButton* event,
                                            gpointer self)
{
	gboolean result;
	result = __lambda13_ ((PlacesIndicatorApplet*) self, event);
	return result;
}

PlacesIndicatorApplet*
places_indicator_applet_construct (GType object_type,
                                   const gchar* uuid)
{
	PlacesIndicatorApplet * self = NULL;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GtkEventBox* _tmp2_;
	GtkBox* layout = NULL;
	GtkBox* _tmp3_;
	GtkEventBox* _tmp4_;
	GtkImage* _tmp5_;
	GtkImage* _tmp6_;
	GtkLabel* _tmp7_;
	GtkLabel* _tmp8_;
	GtkLabel* _tmp9_;
	GtkImage* _tmp10_;
	PlacesIndicatorWindow* _tmp11_;
	GtkEventBox* _tmp12_;
	PlacesIndicatorWindow* _tmp13_;
	GtkWidget* _tmp14_;
	GtkEventBox* _tmp15_;
	g_return_val_if_fail (uuid != NULL, NULL);
	self = (PlacesIndicatorApplet*) g_object_new (object_type, "uuid", uuid, NULL);
	budgie_applet_set_settings_schema ((BudgieApplet*) self, "com.solus-project.places-indicator");
	budgie_applet_set_settings_prefix ((BudgieApplet*) self, "/com/solus-project/budgie-panel/instance/places-indicator");
	_tmp0_ = budgie_applet_get_applet_settings ((BudgieApplet*) self, uuid);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = self->priv->settings;
	g_signal_connect_object (_tmp1_, "changed", (GCallback) _places_indicator_applet_on_settings_changed_g_settings_changed, self, 0);
	_tmp2_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->ebox);
	self->priv->ebox = _tmp2_;
	_tmp3_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp3_);
	layout = _tmp3_;
	_tmp4_ = self->priv->ebox;
	gtk_container_add ((GtkContainer*) _tmp4_, (GtkWidget*) layout);
	_tmp5_ = (GtkImage*) gtk_image_new_from_icon_name ("folder-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->image);
	self->priv->image = _tmp5_;
	_tmp6_ = self->priv->image;
	gtk_box_pack_start (layout, (GtkWidget*) _tmp6_, TRUE, TRUE, (guint) 3);
	_tmp7_ = (GtkLabel*) gtk_label_new (_ ("Places"));
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->label);
	self->priv->label = _tmp7_;
	_tmp8_ = self->priv->label;
	gtk_widget_set_halign ((GtkWidget*) _tmp8_, GTK_ALIGN_START);
	_tmp9_ = self->priv->label;
	gtk_box_pack_start (layout, (GtkWidget*) _tmp9_, TRUE, TRUE, (guint) 3);
	_tmp10_ = self->priv->image;
	_tmp11_ = places_indicator_window_new ((GtkWidget*) _tmp10_);
	g_object_ref_sink (_tmp11_);
	_g_object_unref0 (self->priv->popover);
	self->priv->popover = _tmp11_;
	_tmp12_ = self->priv->ebox;
	g_signal_connect_object ((GtkWidget*) _tmp12_, "button-press-event", (GCallback) ___lambda13__gtk_widget_button_press_event, self, 0);
	_tmp13_ = self->priv->popover;
	_tmp14_ = gtk_bin_get_child ((GtkBin*) _tmp13_);
	gtk_widget_show_all (_tmp14_);
	_tmp15_ = self->priv->ebox;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp15_);
	gtk_widget_show_all ((GtkWidget*) self);
	places_indicator_applet_on_settings_changed (self, "show-label");
	places_indicator_applet_on_settings_changed (self, "expand-places");
	places_indicator_applet_on_settings_changed (self, "show-places");
	places_indicator_applet_on_settings_changed (self, "show-drives");
	places_indicator_applet_on_settings_changed (self, "show-networks");
	_g_object_unref0 (layout);
	return self;
}

PlacesIndicatorApplet*
places_indicator_applet_new (const gchar* uuid)
{
	return places_indicator_applet_construct (TYPE_PLACES_INDICATOR_APPLET, uuid);
}

static void
places_indicator_applet_real_panel_position_changed (BudgieApplet* base,
                                                     BudgiePanelPosition position)
{
	PlacesIndicatorApplet * self;
	self = (PlacesIndicatorApplet*) base;
	self->priv->panel_position = position;
	places_indicator_applet_on_settings_changed (self, "show-label");
}

void
places_indicator_applet_toggle_popover (PlacesIndicatorApplet* self)
{
	PlacesIndicatorWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->popover;
	if (gtk_widget_get_visible ((GtkWidget*) _tmp0_)) {
		PlacesIndicatorWindow* _tmp1_;
		_tmp1_ = self->priv->popover;
		gtk_widget_hide ((GtkWidget*) _tmp1_);
	} else {
		PlacesIndicatorWindow* _tmp2_;
		GtkWidget* _tmp3_;
		BudgiePopoverManager* _tmp4_;
		GtkEventBox* _tmp5_;
		_tmp2_ = self->priv->popover;
		_tmp3_ = gtk_bin_get_child ((GtkBin*) _tmp2_);
		gtk_widget_show_all (_tmp3_);
		_tmp4_ = self->priv->manager;
		_tmp5_ = self->priv->ebox;
		budgie_popover_manager_show_popover (_tmp4_, (GtkWidget*) _tmp5_);
	}
}

static void
places_indicator_applet_real_invoke_action (BudgieApplet* base,
                                            BudgiePanelAction action)
{
	PlacesIndicatorApplet * self;
	self = (PlacesIndicatorApplet*) base;
	places_indicator_applet_toggle_popover (self);
}

static void
places_indicator_applet_real_update_popovers (BudgieApplet* base,
                                              BudgiePopoverManager* manager)
{
	PlacesIndicatorApplet * self;
	GtkEventBox* _tmp0_;
	PlacesIndicatorWindow* _tmp1_;
	self = (PlacesIndicatorApplet*) base;
	self->priv->manager = manager;
	_tmp0_ = self->priv->ebox;
	_tmp1_ = self->priv->popover;
	budgie_popover_manager_register_popover (manager, (GtkWidget*) _tmp0_, (GtkPopover*) _tmp1_);
}

void
places_indicator_applet_on_settings_changed (PlacesIndicatorApplet* self,
                                             const gchar* key)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	static GQuark _tmp1_label4 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = key;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("show-label")))) {
		switch (0) {
			default:
			{
				gboolean _tmp3_ = FALSE;
				gboolean _tmp4_ = FALSE;
				gboolean visible = FALSE;
				GtkLabel* _tmp6_;
				if (self->priv->panel_position == BUDGIE_PANEL_POSITION_TOP) {
					_tmp4_ = TRUE;
				} else {
					_tmp4_ = self->priv->panel_position == BUDGIE_PANEL_POSITION_BOTTOM;
				}
				if (_tmp4_) {
					GSettings* _tmp5_;
					_tmp5_ = self->priv->settings;
					_tmp3_ = g_settings_get_boolean (_tmp5_, key);
				} else {
					_tmp3_ = FALSE;
				}
				visible = _tmp3_;
				_tmp6_ = self->priv->label;
				gtk_widget_set_visible ((GtkWidget*) _tmp6_, visible);
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("expand-places")))) {
		switch (0) {
			default:
			{
				PlacesIndicatorWindow* _tmp7_;
				GSettings* _tmp8_;
				_tmp7_ = self->priv->popover;
				_tmp8_ = self->priv->settings;
				places_indicator_window_set_expand_places (_tmp7_, g_settings_get_boolean (_tmp8_, key));
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("show-places")))) {
		switch (0) {
			default:
			{
				PlacesIndicatorWindow* _tmp9_;
				GSettings* _tmp10_;
				_tmp9_ = self->priv->popover;
				_tmp10_ = self->priv->settings;
				places_indicator_window_set_show_places (_tmp9_, g_settings_get_boolean (_tmp10_, key));
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("show-drives")))) {
		switch (0) {
			default:
			{
				PlacesIndicatorWindow* _tmp11_;
				GSettings* _tmp12_;
				_tmp11_ = self->priv->popover;
				_tmp12_ = self->priv->settings;
				places_indicator_window_set_show_drives (_tmp11_, g_settings_get_boolean (_tmp12_, key));
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string ("show-networks")))) {
		switch (0) {
			default:
			{
				PlacesIndicatorWindow* _tmp13_;
				GSettings* _tmp14_;
				_tmp13_ = self->priv->popover;
				_tmp14_ = self->priv->settings;
				places_indicator_window_set_show_networks (_tmp13_, g_settings_get_boolean (_tmp14_, key));
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				break;
			}
		}
	}
}

const gchar*
places_indicator_applet_get_uuid (PlacesIndicatorApplet* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_uuid;
	result = _tmp0_;
	return result;
}

void
places_indicator_applet_set_uuid (PlacesIndicatorApplet* self,
                                  const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = places_indicator_applet_get_uuid (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_uuid);
		self->priv->_uuid = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, places_indicator_applet_properties[PLACES_INDICATOR_APPLET_UUID_PROPERTY]);
	}
}

static void
places_indicator_applet_class_init (PlacesIndicatorAppletClass * klass,
                                    gpointer klass_data)
{
	places_indicator_applet_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PlacesIndicatorApplet_private_offset);
	((BudgieAppletClass *) klass)->get_settings_ui = (GtkWidget* (*) (BudgieApplet*)) places_indicator_applet_real_get_settings_ui;
	((BudgieAppletClass *) klass)->supports_settings = (gboolean (*) (BudgieApplet*)) places_indicator_applet_real_supports_settings;
	((BudgieAppletClass *) klass)->panel_position_changed = (void (*) (BudgieApplet*, BudgiePanelPosition)) places_indicator_applet_real_panel_position_changed;
	((BudgieAppletClass *) klass)->invoke_action = (void (*) (BudgieApplet*, BudgiePanelAction)) places_indicator_applet_real_invoke_action;
	((BudgieAppletClass *) klass)->update_popovers = (void (*) (BudgieApplet*, BudgiePopoverManager*)) places_indicator_applet_real_update_popovers;
	G_OBJECT_CLASS (klass)->get_property = _vala_places_indicator_applet_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_places_indicator_applet_set_property;
	G_OBJECT_CLASS (klass)->finalize = places_indicator_applet_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLACES_INDICATOR_APPLET_UUID_PROPERTY, places_indicator_applet_properties[PLACES_INDICATOR_APPLET_UUID_PROPERTY] = g_param_spec_string ("uuid", "uuid", "uuid", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
places_indicator_applet_instance_init (PlacesIndicatorApplet * self,
                                       gpointer klass)
{
	self->priv = places_indicator_applet_get_instance_private (self);
	self->priv->panel_position = BUDGIE_PANEL_POSITION_BOTTOM;
	self->priv->manager = NULL;
}

static void
places_indicator_applet_finalize (GObject * obj)
{
	PlacesIndicatorApplet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PLACES_INDICATOR_APPLET, PlacesIndicatorApplet);
	_g_object_unref0 (self->priv->ebox);
	_g_object_unref0 (self->priv->popover);
	_g_object_unref0 (self->priv->label);
	_g_object_unref0 (self->priv->image);
	_g_object_unref0 (self->priv->settings);
	_g_free0 (self->priv->_uuid);
	G_OBJECT_CLASS (places_indicator_applet_parent_class)->finalize (obj);
}

GType
places_indicator_applet_get_type (void)
{
	return places_indicator_applet_type_id;
}

GType
places_indicator_applet_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (PlacesIndicatorAppletClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) places_indicator_applet_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PlacesIndicatorApplet), 0, (GInstanceInitFunc) places_indicator_applet_instance_init, NULL };
	places_indicator_applet_type_id = g_type_module_register_type (module, budgie_applet_get_type (), "PlacesIndicatorApplet", &g_define_type_info, 0);
	PlacesIndicatorApplet_private_offset = sizeof (PlacesIndicatorAppletPrivate);
	return places_indicator_applet_type_id;
}

static void
_vala_places_indicator_applet_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	PlacesIndicatorApplet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PLACES_INDICATOR_APPLET, PlacesIndicatorApplet);
	switch (property_id) {
		case PLACES_INDICATOR_APPLET_UUID_PROPERTY:
		g_value_set_string (value, places_indicator_applet_get_uuid (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_places_indicator_applet_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	PlacesIndicatorApplet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PLACES_INDICATOR_APPLET, PlacesIndicatorApplet);
	switch (property_id) {
		case PLACES_INDICATOR_APPLET_UUID_PROPERTY:
		places_indicator_applet_set_uuid (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

void
peas_register_types (GTypeModule* module)
{
	PeasObjectModule* objmodule = NULL;
	PeasObjectModule* _tmp0_;
	g_return_if_fail (module != NULL);
	places_indicator_register_type (module);
	places_indicator_settings_register_type (module);
	places_indicator_applet_register_type (module);
	places_indicator_window_register_type (module);
	message_revealer_register_type (module);
	places_section_register_type (module);
	list_item_register_type (module);
	volume_item_register_type (module);
	mount_item_register_type (module);
	place_item_register_type (module);
	mount_helper_register_type (module);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (module, peas_object_module_get_type ()) ? ((PeasObjectModule*) module) : NULL);
	objmodule = _tmp0_;
	peas_object_module_register_extension_type (objmodule, budgie_plugin_get_type (), TYPE_PLACES_INDICATOR);
	_g_object_unref0 (objmodule);
}

