/* background.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from background.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <libgnome-desktop/gnome-bg.h>
#include <gsettings-desktop-schemas/gdesktop-enums.h>
#include <gobject/gvaluecollector.h>

#define BUDGIE_BACKGROUND_SCHEMA "org.gnome.desktop.background"
#define BUDGIE_ACCOUNTS_SCHEMA "org.freedesktop.Accounts"
#define BUDGIE_GNOME_COLOR_HACK "budgie-control-center/pixmaps/noise-texture-light.png"
#define BUDGIE_BACKGROUND_BACKGROUND_TIMEOUT 850
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BUDGIE_TYPE_BACKGROUND (budgie_background_get_type ())
#define BUDGIE_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_BACKGROUND, BudgieBackground))
#define BUDGIE_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_BACKGROUND, BudgieBackgroundClass))
#define BUDGIE_IS_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_BACKGROUND))
#define BUDGIE_IS_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_BACKGROUND))
#define BUDGIE_BACKGROUND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_BACKGROUND, BudgieBackgroundClass))

typedef struct _BudgieBackground BudgieBackground;
typedef struct _BudgieBackgroundClass BudgieBackgroundClass;
typedef struct _BudgieBackgroundPrivate BudgieBackgroundPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block5Data Block5Data;
#define _budgie_background_unref0(var) ((var == NULL) ? NULL : (var = (budgie_background_unref (var), NULL)))
typedef struct _BudgieParamSpecBackground BudgieParamSpecBackground;

struct _BudgieBackground {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BudgieBackgroundPrivate * priv;
};

struct _BudgieBackgroundClass {
	GTypeClass parent_class;
	void (*finalize) (BudgieBackground *self);
};

struct _BudgieBackgroundPrivate {
	GSettings* settings;
	GnomeBG* gnome_bg;
	GSubprocess* bg;
};

struct _Block5Data {
	int _ref_count_;
	BudgieBackground* self;
	GSubprocess* new_bg;
};

struct _BudgieParamSpecBackground {
	GParamSpec parent_instance;
};

static gint BudgieBackground_private_offset;
static gpointer budgie_background_parent_class = NULL;

VALA_EXTERN gpointer budgie_background_ref (gpointer instance);
VALA_EXTERN void budgie_background_unref (gpointer instance);
VALA_EXTERN GParamSpec* budgie_param_spec_background (const gchar* name,
                                          const gchar* nick,
                                          const gchar* blurb,
                                          GType object_type,
                                          GParamFlags flags);
VALA_EXTERN void budgie_value_set_background (GValue* value,
                                  gpointer v_object);
VALA_EXTERN void budgie_value_take_background (GValue* value,
                                   gpointer v_object);
VALA_EXTERN gpointer budgie_value_get_background (const GValue* value);
VALA_EXTERN GType budgie_background_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieBackground, budgie_background_unref)
static gboolean budgie_background_is_color_wallpaper (BudgieBackground* self,
                                               const gchar* bg_filename);
VALA_EXTERN BudgieBackground* budgie_background_new (void);
VALA_EXTERN BudgieBackground* budgie_background_construct (GType object_type);
static gboolean __lambda25_ (BudgieBackground* self);
static gboolean ___lambda25__g_settings_change_event (GSettings* _sender,
                                               GQuark* keys,
                                               gint n_keys,
                                               gpointer self);
static void __lambda26_ (BudgieBackground* self);
static void budgie_background_update (BudgieBackground* self);
static void ___lambda26__gnome_bg_changed (GnomeBG* _sender,
                                    gpointer self);
static void budgie_background_set_accountsservice_user_bg (BudgieBackground* self,
                                                    const gchar* background);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static gboolean ____lambda27_ (Block5Data* _data5_);
static gboolean _____lambda27__gsource_func (gpointer self);
static void budgie_background_finalize (BudgieBackground * obj);
static GType budgie_background_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
budgie_background_get_instance_private (BudgieBackground* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieBackground_private_offset);
}

/**
* Determine if the wallpaper is a colour wallpaper or not
*/
static gboolean
budgie_background_is_color_wallpaper (BudgieBackground* self,
                                      const gchar* bg_filename)
{
	gboolean _tmp0_ = FALSE;
	GnomeBG* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (bg_filename == NULL) {
		result = FALSE;
		return result;
	}
	_tmp1_ = self->priv->gnome_bg;
	if (gnome_bg_get_placement (_tmp1_) == G_DESKTOP_BACKGROUND_STYLE_NONE) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_str_has_suffix (bg_filename, BUDGIE_GNOME_COLOR_HACK);
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
__lambda25_ (BudgieBackground* self)
{
	GnomeBG* _tmp0_;
	GSettings* _tmp1_;
	gboolean result;
	_tmp0_ = self->priv->gnome_bg;
	_tmp1_ = self->priv->settings;
	gnome_bg_load_from_preferences (_tmp0_, _tmp1_);
	result = FALSE;
	return result;
}

static gboolean
___lambda25__g_settings_change_event (GSettings* _sender,
                                      GQuark* keys,
                                      gint n_keys,
                                      gpointer self)
{
	gboolean result;
	result = __lambda25_ ((BudgieBackground*) self);
	return result;
}

static void
__lambda26_ (BudgieBackground* self)
{
	budgie_background_update (self);
}

static void
___lambda26__gnome_bg_changed (GnomeBG* _sender,
                               gpointer self)
{
	__lambda26_ ((BudgieBackground*) self);
}

BudgieBackground*
budgie_background_construct (GType object_type)
{
	BudgieBackground* self = NULL;
	GSettings* _tmp0_;
	GnomeBG* _tmp1_;
	GSettings* _tmp2_;
	GnomeBG* _tmp3_;
	GnomeBG* _tmp4_;
	GSettings* _tmp5_;
	self = (BudgieBackground*) g_type_create_instance (object_type);
	_tmp0_ = g_settings_new (BUDGIE_BACKGROUND_SCHEMA);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = gnome_bg_new ();
	_g_object_unref0 (self->priv->gnome_bg);
	self->priv->gnome_bg = _tmp1_;
	_tmp2_ = self->priv->settings;
	g_signal_connect (_tmp2_, "change-event", (GCallback) ___lambda25__g_settings_change_event, self);
	_tmp3_ = self->priv->gnome_bg;
	g_signal_connect (_tmp3_, "changed", (GCallback) ___lambda26__gnome_bg_changed, self);
	_tmp4_ = self->priv->gnome_bg;
	_tmp5_ = self->priv->settings;
	gnome_bg_load_from_preferences (_tmp4_, _tmp5_);
	return self;
}

BudgieBackground*
budgie_background_new (void)
{
	return budgie_background_construct (BUDGIE_TYPE_BACKGROUND);
}

/**
* call accountsservice dbus with the background file name
* to update the greeter background if the display
* manager supports the dbus call.
*/
static void
budgie_background_set_accountsservice_user_bg (BudgieBackground* self,
                                               const gchar* background)
{
	GDBusConnection* bus = NULL;
	GVariant* variant = NULL;
	gboolean _tmp18_ = FALSE;
	GVariant* _tmp19_;
	gchar* object_path = NULL;
	GVariant* _tmp22_;
	GVariant* _tmp23_;
	GVariant* _tmp24_;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (background != NULL);
	{
		GDBusConnection* _tmp0_ = NULL;
		GDBusConnection* _tmp1_;
		GDBusConnection* _tmp2_;
		_tmp1_ = g_bus_get_sync (G_BUS_TYPE_SYSTEM, NULL, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			_g_variant_unref0 (variant);
			_g_object_unref0 (bus);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (bus);
		bus = _tmp2_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("background.vala:71: Failed to get system bus: %s", _tmp4_);
		_g_error_free0 (e);
		_g_variant_unref0 (variant);
		_g_object_unref0 (bus);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_variant_unref0 (variant);
		_g_object_unref0 (bus);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	{
		GVariant* _tmp5_ = NULL;
		GDBusConnection* _tmp6_;
		const gchar* _tmp7_;
		GVariant* _tmp8_;
		GVariant* _tmp9_;
		GVariantType* _tmp10_;
		GVariantType* _tmp11_;
		GVariant* _tmp12_;
		GVariant* _tmp13_;
		GVariant* _tmp14_;
		_tmp6_ = bus;
		_tmp7_ = g_get_user_name ();
		_tmp8_ = g_variant_new ("(s)", _tmp7_, NULL);
		g_variant_ref_sink (_tmp8_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_variant_type_new ("(o)");
		_tmp11_ = _tmp10_;
		_tmp12_ = g_dbus_connection_call_sync (_tmp6_, BUDGIE_ACCOUNTS_SCHEMA, "/org/freedesktop/Accounts", BUDGIE_ACCOUNTS_SCHEMA, "FindUserByName", _tmp9_, _tmp11_, G_DBUS_CALL_FLAGS_NONE, -1, NULL, &_inner_error0_);
		_tmp13_ = _tmp12_;
		_g_variant_type_free0 (_tmp11_);
		_g_variant_unref0 (_tmp9_);
		_tmp5_ = _tmp13_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		_tmp14_ = _tmp5_;
		_tmp5_ = NULL;
		_g_variant_unref0 (variant);
		variant = _tmp14_;
		_g_variant_unref0 (_tmp5_);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp15_;
		GError* _tmp16_;
		const gchar* _tmp17_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp15_ = g_get_user_name ();
		_tmp16_ = e;
		_tmp17_ = _tmp16_->message;
		g_warning ("background.vala:79: Could not contact accounts service to look up '%s'" \
": %s", _tmp15_, _tmp17_);
		_g_error_free0 (e);
		_g_variant_unref0 (variant);
		_g_object_unref0 (bus);
		return;
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_variant_unref0 (variant);
		_g_object_unref0 (bus);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp19_ = variant;
	if (_tmp19_ == NULL) {
		_tmp18_ = TRUE;
	} else {
		GVariant* _tmp20_;
		_tmp20_ = variant;
		_tmp18_ = g_variant_n_children (_tmp20_) == ((gsize) 0);
	}
	if (_tmp18_) {
		const gchar* _tmp21_;
		_tmp21_ = g_get_user_name ();
		g_warning ("background.vala:85: Invalid response from AccountsService for user '%s" \
"'", _tmp21_);
		_g_variant_unref0 (variant);
		_g_object_unref0 (bus);
		return;
	}
	_tmp22_ = variant;
	_tmp23_ = g_variant_get_child_value (_tmp22_, (gsize) 0);
	_tmp24_ = _tmp23_;
	_tmp25_ = g_variant_get_string (_tmp24_, NULL);
	_tmp26_ = g_strdup (_tmp25_);
	_tmp27_ = _tmp26_;
	_g_variant_unref0 (_tmp24_);
	object_path = _tmp27_;
	{
		GDBusConnection* _tmp28_;
		const gchar* _tmp29_;
		GVariant* _tmp30_;
		GVariant* _tmp31_;
		GVariant* _tmp32_;
		GVariant* _tmp33_;
		GVariantType* _tmp34_;
		GVariantType* _tmp35_;
		GVariant* _tmp36_;
		GVariant* _tmp37_;
		_tmp28_ = bus;
		_tmp29_ = object_path;
		_tmp30_ = g_variant_new_string (background);
		g_variant_ref_sink (_tmp30_);
		_tmp31_ = _tmp30_;
		_tmp32_ = g_variant_new ("(ssv)", "org.freedesktop.DisplayManager.AccountsService", "BackgroundFile", _tmp31_, NULL);
		g_variant_ref_sink (_tmp32_);
		_tmp33_ = _tmp32_;
		_tmp34_ = g_variant_type_new ("()");
		_tmp35_ = _tmp34_;
		_tmp36_ = g_dbus_connection_call_sync (_tmp28_, BUDGIE_ACCOUNTS_SCHEMA, _tmp29_, "org.freedesktop.DBus.Properties", "Set", _tmp33_, _tmp35_, G_DBUS_CALL_FLAGS_NONE, -1, NULL, &_inner_error0_);
		_tmp37_ = _tmp36_;
		_g_variant_unref0 (_tmp37_);
		_g_variant_type_free0 (_tmp35_);
		_g_variant_unref0 (_tmp33_);
		_g_variant_unref0 (_tmp31_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp38_;
		const gchar* _tmp39_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp38_ = e;
		_tmp39_ = _tmp38_->message;
		g_warning ("background.vala:97: Failed to set the background '%s': %s", background, _tmp39_);
		_g_error_free0 (e);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (object_path);
		_g_variant_unref0 (variant);
		_g_object_unref0 (bus);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (object_path);
	_g_variant_unref0 (variant);
	_g_object_unref0 (bus);
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		BudgieBackground* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->new_bg);
		_budgie_background_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
____lambda27_ (Block5Data* _data5_)
{
	BudgieBackground* self;
	GSubprocess* _tmp0_;
	GSubprocess* _tmp2_;
	GSubprocess* _tmp3_;
	gboolean result;
	self = _data5_->self;
	_tmp0_ = self->priv->bg;
	if (_tmp0_ != NULL) {
		GSubprocess* _tmp1_;
		_tmp1_ = self->priv->bg;
		g_subprocess_force_exit (_tmp1_);
	}
	_tmp2_ = _data5_->new_bg;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->bg);
	self->priv->bg = _tmp3_;
	result = FALSE;
	return result;
}

static gboolean
_____lambda27__gsource_func (gpointer self)
{
	gboolean result;
	result = ____lambda27_ (self);
	return result;
}

static void
budgie_background_update (BudgieBackground* self)
{
	gchar* bg_filename = NULL;
	GnomeBG* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->gnome_bg;
	_tmp1_ = gnome_bg_get_filename (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	bg_filename = _tmp2_;
	_tmp3_ = bg_filename;
	if (_tmp3_ == NULL) {
		g_warning ("background.vala:106: No background filename available");
		_g_free0 (bg_filename);
		return;
	}
	_tmp5_ = bg_filename;
	if (!budgie_background_is_color_wallpaper (self, _tmp5_)) {
		const gchar* _tmp6_;
		_tmp6_ = bg_filename;
		_tmp4_ = !g_str_has_suffix (_tmp6_, ".xml");
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		Block5Data* _data5_;
		gchar** cmdline = NULL;
		gchar* _tmp7_;
		gchar* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar** _tmp13_;
		gint cmdline_length1;
		gint _cmdline_size_;
		const gchar* _tmp20_;
		_data5_ = g_slice_new0 (Block5Data);
		_data5_->_ref_count_ = 1;
		_data5_->self = budgie_background_ref (self);
		_tmp7_ = g_strdup ("swaybg");
		_tmp8_ = g_strdup ("-i");
		_tmp9_ = bg_filename;
		_tmp10_ = g_strdup (_tmp9_);
		_tmp11_ = g_strdup ("--mode");
		_tmp12_ = g_strdup ("fill");
		_tmp13_ = g_new0 (gchar*, 5 + 1);
		_tmp13_[0] = _tmp7_;
		_tmp13_[1] = _tmp8_;
		_tmp13_[2] = _tmp10_;
		_tmp13_[3] = _tmp11_;
		_tmp13_[4] = _tmp12_;
		cmdline = _tmp13_;
		cmdline_length1 = 5;
		_cmdline_size_ = cmdline_length1;
		{
			GSubprocess* _tmp14_ = NULL;
			gchar** _tmp15_;
			gint _tmp15__length1;
			GSubprocess* _tmp16_;
			GSubprocess* _tmp17_;
			_tmp15_ = cmdline;
			_tmp15__length1 = cmdline_length1;
			_tmp16_ = g_subprocess_newv (_tmp15_, G_SUBPROCESS_FLAGS_NONE, &_inner_error0_);
			_tmp14_ = _tmp16_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp17_ = _tmp14_;
			_tmp14_ = NULL;
			_g_object_unref0 (_data5_->new_bg);
			_data5_->new_bg = _tmp17_;
			g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) BUDGIE_BACKGROUND_BACKGROUND_TIMEOUT, _____lambda27__gsource_func, block5_data_ref (_data5_), block5_data_unref);
			_g_object_unref0 (_tmp14_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp18_;
			const gchar* _tmp19_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp18_ = e;
			_tmp19_ = _tmp18_->message;
			g_warning ("background.vala:127: Error starting swaybg: %s", _tmp19_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			cmdline = (_vala_array_free (cmdline, cmdline_length1, (GDestroyNotify) g_free), NULL);
			block5_data_unref (_data5_);
			_data5_ = NULL;
			_g_free0 (bg_filename);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp20_ = bg_filename;
		budgie_background_set_accountsservice_user_bg (self, _tmp20_);
		cmdline = (_vala_array_free (cmdline, cmdline_length1, (GDestroyNotify) g_free), NULL);
		block5_data_unref (_data5_);
		_data5_ = NULL;
	}
	_g_free0 (bg_filename);
}

static void
budgie_value_background_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
budgie_value_background_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		budgie_background_unref (value->data[0].v_pointer);
	}
}

static void
budgie_value_background_copy_value (const GValue* src_value,
                                    GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = budgie_background_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
budgie_value_background_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
budgie_value_background_collect_value (GValue* value,
                                       guint n_collect_values,
                                       GTypeCValue* collect_values,
                                       guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		BudgieBackground * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = budgie_background_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
budgie_value_background_lcopy_value (const GValue* value,
                                     guint n_collect_values,
                                     GTypeCValue* collect_values,
                                     guint collect_flags)
{
	BudgieBackground ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = budgie_background_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
budgie_param_spec_background (const gchar* name,
                              const gchar* nick,
                              const gchar* blurb,
                              GType object_type,
                              GParamFlags flags)
{
	BudgieParamSpecBackground* spec;
	g_return_val_if_fail (g_type_is_a (object_type, BUDGIE_TYPE_BACKGROUND), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
budgie_value_get_background (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BUDGIE_TYPE_BACKGROUND), NULL);
	return value->data[0].v_pointer;
}

void
budgie_value_set_background (GValue* value,
                             gpointer v_object)
{
	BudgieBackground * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BUDGIE_TYPE_BACKGROUND));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BUDGIE_TYPE_BACKGROUND));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		budgie_background_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		budgie_background_unref (old);
	}
}

void
budgie_value_take_background (GValue* value,
                              gpointer v_object)
{
	BudgieBackground * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BUDGIE_TYPE_BACKGROUND));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BUDGIE_TYPE_BACKGROUND));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		budgie_background_unref (old);
	}
}

static void
budgie_background_class_init (BudgieBackgroundClass * klass,
                              gpointer klass_data)
{
	budgie_background_parent_class = g_type_class_peek_parent (klass);
	((BudgieBackgroundClass *) klass)->finalize = budgie_background_finalize;
	g_type_class_adjust_private_offset (klass, &BudgieBackground_private_offset);
}

static void
budgie_background_instance_init (BudgieBackground * self,
                                 gpointer klass)
{
	self->priv = budgie_background_get_instance_private (self);
	self->priv->settings = NULL;
	self->priv->bg = NULL;
	self->ref_count = 1;
}

static void
budgie_background_finalize (BudgieBackground * obj)
{
	BudgieBackground * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_BACKGROUND, BudgieBackground);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->gnome_bg);
	_g_object_unref0 (self->priv->bg);
}

static GType
budgie_background_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { budgie_value_background_init, budgie_value_background_free_value, budgie_value_background_copy_value, budgie_value_background_peek_pointer, "p", budgie_value_background_collect_value, "p", budgie_value_background_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (BudgieBackgroundClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_background_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieBackground), 0, (GInstanceInitFunc) budgie_background_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType budgie_background_type_id;
	budgie_background_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BudgieBackground", &g_define_type_info, &g_define_type_fundamental_info, 0);
	BudgieBackground_private_offset = g_type_add_instance_private (budgie_background_type_id, sizeof (BudgieBackgroundPrivate));
	return budgie_background_type_id;
}

GType
budgie_background_get_type (void)
{
	static volatile gsize budgie_background_type_id__once = 0;
	if (g_once_init_enter (&budgie_background_type_id__once)) {
		GType budgie_background_type_id;
		budgie_background_type_id = budgie_background_get_type_once ();
		g_once_init_leave (&budgie_background_type_id__once, budgie_background_type_id);
	}
	return budgie_background_type_id__once;
}

gpointer
budgie_background_ref (gpointer instance)
{
	BudgieBackground * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
budgie_background_unref (gpointer instance)
{
	BudgieBackground * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BUDGIE_BACKGROUND_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

