#line 1 "/build/ecl/src/ecl-24.5.10/src/c/threads/barrier.d"
/* -*- Mode: C; c-basic-offset: 2; indent-tabs-mode: nil -*- */
/* vim: set filetype=c tabstop=2 shiftwidth=2 expandtab: */

/*
 * barrier.d - wait barriers
 *
 * Copyright (c) 2012 Juan Jose Garcia Ripoll
 * Copyright (c) 2020 Marius Gerbershagen
 *
 * See file 'LICENSE' for the copyright details.
 *
 */

#include <ecl/ecl.h>
#include <ecl/internal.h>

cl_object
ecl_make_barrier(cl_object name, cl_index count)
{
  cl_env_ptr env = ecl_process_env();
  cl_object output = ecl_alloc_object(t_barrier);
  output->barrier.disabled = FALSE;
  output->barrier.wakeup = 0;
  output->barrier.name = name;
  output->barrier.arrivers_count = 0;
  output->barrier.count = count;
  ecl_disable_interrupts_env(env);
  ecl_cond_var_init(&output->barrier.cv);
  ecl_mutex_init(&output->barrier.mutex, FALSE);
  ecl_set_finalizer_unprotected(output, ECL_T);
  ecl_enable_interrupts_env(env);
  return output;
}

#line 35
cl_object mp_make_barrier(cl_narg narg, cl_object count, ...)
{
#line 35

  #line 37
#if defined(__clang__) || defined(__GNUC__)
	__attribute__((unused)) const cl_env_ptr the_env = ecl_process_env();
#else
	const cl_env_ptr the_env = ecl_process_env();
#endif
#line 37
	static cl_object KEYS[1] = {(cl_object)(cl_symbols+1306)};
	cl_object name;
#line 37
	cl_object KEY_VARS[2];
#line 37
	ecl_va_list ARGS;
	ecl_va_start(ARGS, count, narg, 1);
#line 37
	if (ecl_unlikely(narg < 1)) FEwrong_num_arguments(ecl_make_fixnum(1499));
#line 37
	cl_parse_key(ARGS, 1, KEYS, KEY_VARS, NULL, 0);
#line 37
	if (KEY_VARS[1]==ECL_NIL) {
#line 37
	  name = ECL_NIL;
	} else {
#line 37
	  name = KEY_VARS[0];
	}
#line 37
  if (count == ECL_T)
    count = ecl_make_fixnum(MOST_POSITIVE_FIXNUM);
  {
#line 39
	#line 39
	cl_object __value0 = ecl_make_barrier(name, fixnnint(count));
#line 39
	the_env->nvalues = 1;
#line 39
	the_env->values[0] = __value0;
#line 39
	ecl_va_end(ARGS);
#line 39
	return __value0;
#line 39
}
;
  }

cl_object
mp_barrier_name(cl_object barrier)
{
  cl_env_ptr env = ecl_process_env();
  unlikely_if (ecl_t_of(barrier) != t_barrier) {
    FEwrong_type_only_arg(ecl_make_fixnum(/*MP::BARRIER-NAME*/1503), barrier, ecl_make_fixnum(/*MP::BARRIER*/1498));
  }
  ecl_return1(env, barrier->barrier.name);
}

cl_object
mp_barrier_count(cl_object barrier)
{
  cl_env_ptr env = ecl_process_env();
  unlikely_if (ecl_t_of(barrier) != t_barrier) {
    FEwrong_type_only_arg(ecl_make_fixnum(/*MP::BARRIER-COUNT*/1502), barrier, ecl_make_fixnum(/*MP::BARRIER*/1498));
  }
  ecl_return1(env, ecl_make_fixnum(barrier->barrier.count));
}

cl_object
mp_barrier_arrivers_count(cl_object barrier)
{
  cl_env_ptr env = ecl_process_env();
  unlikely_if (ecl_t_of(barrier) != t_barrier) {
    FEwrong_type_only_arg(ecl_make_fixnum(/*MP::BARRIER-ARRIVERS-COUNT*/1504), barrier, ecl_make_fixnum(/*MP::BARRIER*/1498));
  }
  ecl_return1(env, ecl_make_fixnum(barrier->barrier.arrivers_count));
}

/* INV: locking the mutex in mp_barrier_unblock and mp_barrier_wait
 * will always succeed since the functions are not reentrant and only
 * lock/unlock the mutex while interrupts are disabled, therefore
 * deadlocks can't happen. */

#line 77
cl_object mp_barrier_unblock(cl_narg narg, cl_object barrier, ...)
{
#line 77

  #line 79
#if defined(__clang__) || defined(__GNUC__)
	__attribute__((unused)) const cl_env_ptr the_env = ecl_process_env();
#else
	const cl_env_ptr the_env = ecl_process_env();
#endif
#line 79
	static cl_object KEYS[3] = {(cl_object)(cl_symbols+1506), (cl_object)(cl_symbols+1505), (cl_object)(cl_symbols+1507)};
	cl_object reset_count;
	cl_object disable;
	cl_object kill_waiting;
#line 79
	cl_object KEY_VARS[6];
#line 79
	ecl_va_list ARGS;
	ecl_va_start(ARGS, barrier, narg, 1);
#line 79
	if (ecl_unlikely(narg < 1)) FEwrong_num_arguments(ecl_make_fixnum(1500));
#line 79
	cl_parse_key(ARGS, 3, KEYS, KEY_VARS, NULL, 0);
#line 79
	if (KEY_VARS[3]==ECL_NIL) {
#line 79
	  reset_count = ECL_NIL;
	} else {
#line 79
	  reset_count = KEY_VARS[0];
	}
#line 79
	if (KEY_VARS[4]==ECL_NIL) {
#line 79
	  disable = ECL_NIL;
	} else {
#line 79
	  disable = KEY_VARS[1];
	}
#line 79
	if (KEY_VARS[5]==ECL_NIL) {
#line 79
	  kill_waiting = ECL_NIL;
	} else {
#line 79
	  kill_waiting = KEY_VARS[2];
	}
#line 79
  unlikely_if (ecl_t_of(barrier) != t_barrier) {
    FEwrong_type_nth_arg(ecl_make_fixnum(/*MP::BARRIER-UNBLOCK*/1500), 1, barrier, ecl_make_fixnum(/*MP::BARRIER*/1498));
  }
  ecl_disable_interrupts_env(the_env);
 AGAIN:
  ecl_mutex_lock(&barrier->barrier.mutex);
  if (barrier->barrier.wakeup) {
    /* we are currently waking up blocked threads; loop until all
     * threads have woken up */
    ecl_mutex_unlock(&barrier->barrier.mutex);
    goto AGAIN;
  }
  if (!Null(reset_count)) {
    barrier->barrier.count = fixnnint(reset_count);
  }
  if (!Null(disable)) {
    barrier->barrier.disabled = TRUE;
  } else {
    barrier->barrier.disabled = FALSE;
  }
  if (barrier->barrier.arrivers_count > 0) {
    if (!Null(kill_waiting)) {
      barrier->barrier.wakeup = ECL_BARRIER_WAKEUP_KILL;
    } else {
      barrier->barrier.wakeup = ECL_BARRIER_WAKEUP_NORMAL;
    }
    ecl_cond_var_broadcast(&barrier->barrier.cv);
  }
  ecl_mutex_unlock(&barrier->barrier.mutex);
  ecl_enable_interrupts_env(the_env);
  {
the_env->nvalues = 0; return ECL_NIL;
#line 109
}
;
  }

cl_object
mp_barrier_wait(cl_object barrier) {
  cl_env_ptr the_env = ecl_process_env();
  volatile int wakeup = 0;
  unlikely_if (ecl_t_of(barrier) != t_barrier) {
    FEwrong_type_only_arg(ecl_make_fixnum(/*MP::BARRIER-WAIT*/1501), barrier, ecl_make_fixnum(/*MP::BARRIER*/1498));
  }
  ecl_bds_bind(the_env, ECL_INTERRUPTS_ENABLED, ECL_NIL);
  /* check if the barrier is disabled */
  do {
    ecl_mutex_lock(&barrier->barrier.mutex);
    if (barrier->barrier.disabled) {
      ecl_mutex_unlock(&barrier->barrier.mutex);
      ecl_bds_unwind1(the_env);
      ecl_check_pending_interrupts(the_env);
      return ECL_NIL;
    }
    if (barrier->barrier.wakeup) {
      /* We are currently waking up blocked threads; loop until all threads have
       * woken up. */
      ecl_mutex_unlock(&barrier->barrier.mutex);
    } else {
      break;
    }
  } while(1);
  /* check if we have reached the maximum count */
  if ((barrier->barrier.arrivers_count+1) == barrier->barrier.count) {
    if (barrier->barrier.arrivers_count > 0) {
      barrier->barrier.wakeup = ECL_BARRIER_WAKEUP_NORMAL;
      ecl_cond_var_broadcast(&barrier->barrier.cv);
    }
    ecl_mutex_unlock(&barrier->barrier.mutex);
    ecl_bds_unwind1(the_env);
    ecl_check_pending_interrupts(the_env);
    return ECL_SYM(":UNBLOCKED",1508);
  }
  /* barrier is neither disabled nor unblocked, start waiting */
  barrier->barrier.arrivers_count++;
  ECL_UNWIND_PROTECT_BEGIN(the_env) {
    do {
      ecl_setq(the_env, ECL_INTERRUPTS_ENABLED, ECL_T);
      ecl_cond_var_wait(&barrier->barrier.cv, &barrier->barrier.mutex);
      ecl_setq(the_env, ECL_INTERRUPTS_ENABLED, ECL_NIL);
    } while(!barrier->barrier.wakeup);
    wakeup = barrier->barrier.wakeup;
    if (barrier->barrier.arrivers_count - 1 == 0) {
      /* we are the last thread to wake up, reset the barrier */
      barrier->barrier.wakeup = 0;
    }
  } ECL_UNWIND_PROTECT_THREAD_SAFE_EXIT {
    --barrier->barrier.arrivers_count;
    ecl_mutex_unlock(&barrier->barrier.mutex);
    if (wakeup == ECL_BARRIER_WAKEUP_KILL) {
      mp_exit_process();
    }
  } ECL_UNWIND_PROTECT_THREAD_SAFE_END;
  ecl_bds_unwind1(the_env);
  ecl_check_pending_interrupts(the_env);
  return ECL_T;
}

