/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

import tim.prune.I18nManager;
import tim.prune.data.FileType;

public class Field {
    private final String _labelKey;
    private final FileType _fileType;
    public static final Field LATITUDE = new Field("latitude");
    public static final Field LONGITUDE = new Field("longitude");
    public static final Field ALTITUDE = new Field("altitude");
    public static final Field TIMESTAMP = new Field("timestamp");
    public static final Field WAYPT_NAME = new Field("waypointname");
    public static final Field WAYPT_TYPE = new Field("waypointtype");
    public static final Field DESCRIPTION = new Field("description");
    public static final Field COMMENT = new Field("comment");
    public static final Field SYMBOL = new Field("symbol");
    public static final Field NEW_SEGMENT = new Field("newsegment");
    public static final Field SPEED = new Field("speed");
    public static final Field VERTICAL_SPEED = new Field("verticalspeed");
    public static final Field GRADIENT = new Field("gradient");
    public static final Field PHOTO = new Field("photo");
    public static final Field AUDIO = new Field("audio");
    private static final Field[] ALL_AVAILABLE_FIELDS = new Field[]{LATITUDE, LONGITUDE, ALTITUDE, TIMESTAMP, WAYPT_NAME, WAYPT_TYPE, DESCRIPTION, NEW_SEGMENT, SPEED, VERTICAL_SPEED};

    private Field(String string) {
        this._labelKey = "fieldname." + string;
        this._fileType = null;
    }

    protected Field(FileType fileType) {
        this._labelKey = null;
        this._fileType = fileType;
    }

    public String getName() {
        return I18nManager.getText(this._labelKey);
    }

    public void setName(String string) {
    }

    public boolean isSpecificToFileType(FileType fileType) {
        return this._fileType == fileType;
    }

    public boolean matchesFileType(FileType fileType) {
        return this._fileType == null || this._fileType == fileType;
    }

    public boolean equals(Object object) {
        return object != null && this.getClass().equals(object.getClass()) && this.getName().equals(((Field)object).getName());
    }

    public final boolean isBuiltIn() {
        return this.getClass() == Field.class;
    }

    public static Field getField(String string) {
        Field[] fieldArray = ALL_AVAILABLE_FIELDS;
        int n = ALL_AVAILABLE_FIELDS.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (field.getName().equals(string)) {
                return field;
            }
            ++n2;
        }
        return null;
    }

    public static String[] getFieldNames() {
        String[] stringArray = new String[ALL_AVAILABLE_FIELDS.length];
        int n = 0;
        while (n < ALL_AVAILABLE_FIELDS.length) {
            stringArray[n] = ALL_AVAILABLE_FIELDS[n].getName();
            ++n;
        }
        return stringArray;
    }
}

