/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.NameSuggestionProvider;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyParameter;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class PyNameSuggestionProvider
implements NameSuggestionProvider {
    public SuggestedNameInfo getSuggestedNames(PsiElement element, PsiElement nameSuggestionContext, Set<String> result2) {
        if (!(element instanceof PyElement)) {
            return null;
        }
        String name2 = ((PyElement)element).getName();
        if (name2 == null) {
            return null;
        }
        if (element instanceof PyClass) {
            result2.add(PyNameSuggestionProvider.toCamelCase(name2, true));
        } else if (element instanceof PyFunction || element instanceof PyParameter) {
            result2.add(PyNameSuggestionProvider.toUnderscores(name2));
        } else {
            result2.add(PyNameSuggestionProvider.toUnderscores(name2));
            PyAssignmentStatement assignmentStatement = (PyAssignmentStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PyAssignmentStatement.class);
            if (assignmentStatement != null) {
                return null;
            }
            result2.add(StringUtil.toUpperCase((String)name2));
            result2.add(PyNameSuggestionProvider.toCamelCase(name2, false));
        }
        return SuggestedNameInfo.NULL_INFO;
    }

    @NotNull
    public static String toUnderscores(@NotNull String name2) {
        if (name2 == null) {
            PyNameSuggestionProvider.$$$reportNull$$$0(0);
        }
        StringBuilder result2 = new StringBuilder();
        for (int i = 0; i < name2.length(); ++i) {
            char next;
            char prev = i > 0 ? name2.charAt(i - 1) : (char)'\u0000';
            char c = name2.charAt(i);
            char c2 = next = i + 1 < name2.length() ? name2.charAt(i + 1) : (char)'\u0000';
            if (Character.isUpperCase(c)) {
                if (Character.isLowerCase(prev) || Character.isDigit(prev) || Character.isUpperCase(prev) && Character.isLowerCase(next)) {
                    result2.append("_");
                }
                result2.append(Character.toLowerCase(c));
                continue;
            }
            result2.append(c);
        }
        String string = result2.toString();
        if (string == null) {
            PyNameSuggestionProvider.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    private static String toCamelCase(@NotNull String name2, boolean uppercaseFirstLetter) {
        List strings;
        if (name2 == null) {
            PyNameSuggestionProvider.$$$reportNull$$$0(2);
        }
        if (!(strings = StringUtil.split((String)name2, (String)"_")).isEmpty()) {
            StringBuilder buf = new StringBuilder();
            String str = StringUtil.toLowerCase((String)((String)strings.get(0)));
            if (uppercaseFirstLetter) {
                str = StringUtil.capitalize((String)str);
            }
            buf.append(str);
            for (int i = 1; i < strings.size(); ++i) {
                buf.append(StringUtil.capitalize((String)StringUtil.toLowerCase((String)((String)strings.get(i)))));
            }
            String string = buf.toString();
            if (string == null) {
                PyNameSuggestionProvider.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = name2;
        if (string == null) {
            PyNameSuggestionProvider.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/refactoring/PyNameSuggestionProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/refactoring/PyNameSuggestionProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "toUnderscores";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "toCamelCase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "toUnderscores";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "toCamelCase";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4 -> new IllegalStateException(string);
        };
    }
}

