/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql.json;

import jakarta.json.JsonValue;
import oracle.jdbc.driver.json.Jsonp;
import oracle.sql.json.OracleJsonArray;
import oracle.sql.json.OracleJsonBinary;
import oracle.sql.json.OracleJsonDate;
import oracle.sql.json.OracleJsonDecimal;
import oracle.sql.json.OracleJsonDouble;
import oracle.sql.json.OracleJsonFloat;
import oracle.sql.json.OracleJsonIntervalDS;
import oracle.sql.json.OracleJsonIntervalYM;
import oracle.sql.json.OracleJsonNumber;
import oracle.sql.json.OracleJsonObject;
import oracle.sql.json.OracleJsonString;
import oracle.sql.json.OracleJsonTimestamp;
import oracle.sql.json.OracleJsonTimestampTZ;
import oracle.sql.json.OracleJsonVector;

public interface OracleJsonValue {
    public static final OracleJsonValue NULL = new OracleJsonValue(){

        @Override
        public OracleJsonType getOracleJsonType() {
            return OracleJsonType.NULL;
        }

        @Override
        public <T> T wrap(Class<T> c) {
            if (Jsonp.isJakartaJson(c)) {
                return c.cast(JsonValue.NULL);
            }
            return c.cast(javax.json.JsonValue.NULL);
        }

        @Override
        public String toString() {
            return "null";
        }

        public int hashCode() {
            return OracleJsonType.NULL.hashCode();
        }

        public boolean equals(Object other) {
            return other == this || other instanceof OracleJsonValue && ((OracleJsonValue)other).getOracleJsonType() == OracleJsonType.NULL;
        }
    };
    public static final OracleJsonValue TRUE = new OracleJsonValue(){

        @Override
        public OracleJsonType getOracleJsonType() {
            return OracleJsonType.TRUE;
        }

        @Override
        public <T> T wrap(Class<T> c) {
            if (Jsonp.isJakartaJson(c)) {
                return c.cast(JsonValue.TRUE);
            }
            return c.cast(javax.json.JsonValue.TRUE);
        }

        @Override
        public String toString() {
            return "true";
        }

        public int hashCode() {
            return OracleJsonType.TRUE.hashCode();
        }

        public boolean equals(Object other) {
            return other == this || other instanceof OracleJsonValue && ((OracleJsonValue)other).getOracleJsonType() == OracleJsonType.TRUE;
        }
    };
    public static final OracleJsonValue FALSE = new OracleJsonValue(){

        @Override
        public OracleJsonType getOracleJsonType() {
            return OracleJsonType.FALSE;
        }

        @Override
        public <T> T wrap(Class<T> c) {
            if (Jsonp.isJakartaJson(c)) {
                return c.cast(JsonValue.FALSE);
            }
            return c.cast(javax.json.JsonValue.FALSE);
        }

        @Override
        public String toString() {
            return "false";
        }

        public int hashCode() {
            return OracleJsonType.FALSE.hashCode();
        }

        public boolean equals(Object other) {
            return other == this || other instanceof OracleJsonValue && ((OracleJsonValue)other).getOracleJsonType() == OracleJsonType.FALSE;
        }
    };

    public OracleJsonType getOracleJsonType();

    public String toString();

    public <T> T wrap(Class<T> var1);

    default public OracleJsonObject asJsonObject() {
        return (OracleJsonObject)this;
    }

    default public OracleJsonArray asJsonArray() {
        return (OracleJsonArray)this;
    }

    default public OracleJsonString asJsonString() {
        return (OracleJsonString)this;
    }

    default public OracleJsonDecimal asJsonDecimal() {
        return (OracleJsonDecimal)this;
    }

    default public OracleJsonDouble asJsonDouble() {
        return (OracleJsonDouble)this;
    }

    default public OracleJsonFloat asJsonFloat() {
        return (OracleJsonFloat)this;
    }

    default public OracleJsonNumber asJsonNumber() {
        return (OracleJsonNumber)this;
    }

    default public OracleJsonIntervalDS asJsonIntervalDS() {
        return (OracleJsonIntervalDS)this;
    }

    default public OracleJsonIntervalYM asJsonIntervalYM() {
        return (OracleJsonIntervalYM)this;
    }

    default public OracleJsonTimestamp asJsonTimestamp() {
        return (OracleJsonTimestamp)this;
    }

    default public OracleJsonTimestampTZ asJsonTimestampTZ() {
        return (OracleJsonTimestampTZ)this;
    }

    default public OracleJsonDate asJsonDate() {
        return (OracleJsonDate)this;
    }

    default public OracleJsonBinary asJsonBinary() {
        return (OracleJsonBinary)this;
    }

    default public OracleJsonVector asJsonVector() {
        return (OracleJsonVector)this;
    }

    public static enum OracleJsonType {
        ARRAY,
        OBJECT,
        NULL,
        TRUE,
        FALSE,
        STRING,
        DECIMAL,
        FLOAT,
        DOUBLE,
        TIMESTAMP,
        TIMESTAMPTZ,
        DATE,
        INTERVALYM,
        INTERVALDS,
        BINARY,
        VECTOR;

    }
}

