"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RedisIrcConnection = void 0;
const types_1 = require("./types");
const matrix_appservice_bridge_1 = require("matrix-appservice-bridge");
const node_stream_1 = require("node:stream");
class RedisIrcConnection extends node_stream_1.EventEmitter {
    redis;
    clientId;
    state;
    log;
    get connecting() {
        return this.isConnecting;
    }
    get readyState() {
        // TODO: Should this be just pulled directly from the socket.
        // No support for readonly / writeonly.
        return this.isConnecting ? 'opening' : 'open';
    }
    isConnecting = true;
    localPort;
    localIp;
    constructor(redis, clientId, state) {
        super();
        this.redis = redis;
        this.clientId = clientId;
        this.state = state;
        this.log = new matrix_appservice_bridge_1.Logger(`RedisIrcConnection:${this.clientId}`);
        this.once('connect', () => {
            this.isConnecting = false;
        });
    }
    setConnectionInfo(info) {
        this.localPort = info.localPort;
        this.localIp = info.localIp;
    }
    setTimeout(timeout) {
        this.redis.sendCommand(types_1.InCommandType.SetTimeout, { clientId: this.clientId, timeout }).catch(ex => {
            this.log.warn(`Could not send setTimeout:`, ex);
        });
    }
    destroy() {
        this.log.debug(`Called destroy`);
        this.redis.sendCommand(types_1.InCommandType.Destroy, { clientId: this.clientId }).catch(ex => {
            this.log.warn(`Could not send destroy:`, ex);
        });
    }
    write(data) {
        this.redis.sendCommand(types_1.InCommandType.Write, { clientId: this.clientId, data }).catch(ex => {
            this.log.warn(`Could not send write:`, ex);
        });
    }
    end() {
        this.log.debug(`Called end`);
        this.redis.sendCommand(types_1.InCommandType.End, { clientId: this.clientId }).catch(ex => {
            this.log.warn(`Could not send end:`, ex);
        });
    }
}
exports.RedisIrcConnection = RedisIrcConnection;
//# sourceMappingURL=RedisIrcConnection.js.map