/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.devmode;

import io.smallrye.config.ConfigValue;
import java.util.List;

public class ConfigDescription
implements Comparable<ConfigDescription> {
    private String name;
    private String description;
    private String defaultValue;
    private ConfigValue configValue;
    private boolean autoFromDevServices = false;
    private String typeName;
    private List<String> allowedValues;
    private String configPhase;
    private boolean wildcardEntry = false;

    public ConfigDescription() {
    }

    public ConfigDescription(String name, boolean wildcardEntry) {
        this.name = name;
        this.wildcardEntry = wildcardEntry;
    }

    public ConfigDescription(String name, String description, String defaultValue, boolean autoFromDevServices, String typeName, List<String> allowedValues, String configPhase) {
        this.name = name;
        this.description = description;
        this.defaultValue = defaultValue;
        this.autoFromDevServices = autoFromDevServices;
        this.typeName = typeName;
        this.allowedValues = allowedValues;
        this.configPhase = configPhase;
    }

    public ConfigDescription(String name, String description, String defaultValue, ConfigValue configValue) {
        this.name = name;
        this.description = description;
        this.defaultValue = defaultValue;
        this.configValue = configValue;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public ConfigValue getConfigValue() {
        return this.configValue;
    }

    public void setConfigValue(ConfigValue configValue) {
        this.configValue = configValue;
    }

    public boolean isAutoFromDevServices() {
        return this.autoFromDevServices;
    }

    public void setAutoFromDevServices(boolean autoFromDevServices) {
        this.autoFromDevServices = autoFromDevServices;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public List<String> getAllowedValues() {
        return this.allowedValues;
    }

    public void setAllowedValues(List<String> allowedValues) {
        this.allowedValues = allowedValues;
    }

    public String getConfigPhase() {
        return this.configPhase;
    }

    public void setConfigPhase(String configPhase) {
        this.configPhase = configPhase;
    }

    public boolean isWildcardEntry() {
        return this.wildcardEntry;
    }

    public ConfigDescription setWildcardEntry(boolean wildcardEntry) {
        this.wildcardEntry = wildcardEntry;
        return this;
    }

    @Override
    public int compareTo(ConfigDescription o) {
        int ordinal = Integer.compare(o.configValue.getConfigSourceOrdinal(), this.configValue.getConfigSourceOrdinal());
        if (ordinal == 0) {
            return this.configValue.getName().compareTo(o.configValue.getName());
        }
        return ordinal;
    }
}

