/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.mutation.internal;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.hibernate.engine.jdbc.batch.JdbcBatchLogging;
import org.hibernate.engine.jdbc.mutation.group.PreparedStatementDetails;
import org.hibernate.engine.jdbc.mutation.group.PreparedStatementGroup;
import org.hibernate.engine.spi.SharedSessionContractImplementor;

public abstract class AbstractPreparedStatementGroup
implements PreparedStatementGroup {
    private final SharedSessionContractImplementor session;

    public AbstractPreparedStatementGroup(SharedSessionContractImplementor session) {
        this.session = session;
    }

    protected void clearBatch(PreparedStatementDetails statementDetails) {
        PreparedStatement statement = statementDetails.getStatement();
        assert (statement != null);
        try {
            if (!statement.isClosed()) {
                statement.clearBatch();
            }
        }
        catch (SQLException e) {
            JdbcBatchLogging.BATCH_MESSAGE_LOGGER.unableToReleaseBatchStatement();
        }
    }

    protected void release(PreparedStatementDetails statementDetails) {
        if (statementDetails.toRelease()) {
            if (statementDetails.getStatement() == null) {
                JdbcBatchLogging.BATCH_LOGGER.debugf("PreparedStatementDetails did not contain PreparedStatement on releaseStatements: %s", (Object)statementDetails.getSqlString());
            } else {
                this.clearBatch(statementDetails);
            }
            statementDetails.releaseStatement(this.session);
        }
    }
}

