/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.common.util.reflections.Types;
import org.keycloak.component.ComponentFactory;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.provider.Provider;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.storage.CacheableStorageProviderModel;
import org.keycloak.utils.ServicesUtils;

public abstract class AbstractStorageManager<ProviderType extends Provider, StorageProviderModelType extends CacheableStorageProviderModel> {
    private static final Logger LOG = Logger.getLogger(AbstractStorageManager.class);
    private static final Long STORAGE_PROVIDER_DEFAULT_TIMEOUT = 3000L;
    protected final KeycloakSession session;
    private final Class<ProviderType> providerTypeClass;
    private final Class<? extends ProviderFactory> factoryTypeClass;
    private final Function<ComponentModel, StorageProviderModelType> toStorageProviderModelTypeFunction;
    private final String configScope;
    private Long storageProviderTimeout;

    public AbstractStorageManager(KeycloakSession session, Class<? extends ProviderFactory> factoryTypeClass, Class<ProviderType> providerTypeClass, Function<ComponentModel, StorageProviderModelType> toStorageProviderModelTypeFunction, String configScope) {
        this.session = session;
        this.providerTypeClass = providerTypeClass;
        this.factoryTypeClass = factoryTypeClass;
        this.toStorageProviderModelTypeFunction = toStorageProviderModelTypeFunction;
        this.configScope = configScope;
    }

    protected Long getStorageProviderTimeout() {
        if (this.storageProviderTimeout == null) {
            this.storageProviderTimeout = Config.scope((String[])new String[]{this.configScope}).getLong("storageProviderTimeout", STORAGE_PROVIDER_DEFAULT_TIMEOUT);
        }
        return this.storageProviderTimeout;
    }

    protected <T extends ProviderType> ComponentFactory<T, ProviderType> getStorageProviderFactory(String providerId) {
        return (ComponentFactory)this.session.getKeycloakSessionFactory().getProviderFactory(this.providerTypeClass, providerId);
    }

    protected <T> Stream<T> getEnabledStorageProviders(RealmModel realm, Class<T> capabilityInterface) {
        return AbstractStorageManager.getStorageProviderModels(realm, this.providerTypeClass).map(this.toStorageProviderModelTypeFunction).filter(CacheableStorageProviderModel::isEnabled).sorted(CacheableStorageProviderModel.comparator).map(storageProviderModelType -> this.getStorageProviderInstance(storageProviderModelType, capabilityInterface, false)).filter(Objects::nonNull);
    }

    protected <R, T> Stream<R> flatMapEnabledStorageProvidersWithTimeout(RealmModel realm, Class<T> capabilityInterface, Function<T, ? extends Stream<R>> applyFunction) {
        return this.getEnabledStorageProviders(realm, capabilityInterface).flatMap(ServicesUtils.timeBound(this.session, this.getStorageProviderTimeout(), applyFunction));
    }

    protected <R, T> Stream<R> mapEnabledStorageProvidersWithTimeout(RealmModel realm, Class<T> capabilityInterface, Function<T, R> applyFunction) {
        return this.getEnabledStorageProviders(realm, capabilityInterface).map(ServicesUtils.timeBoundOne(this.session, this.getStorageProviderTimeout(), applyFunction)).filter(Objects::nonNull);
    }

    protected <T> void consumeEnabledStorageProvidersWithTimeout(RealmModel realm, Class<T> capabilityInterface, Consumer<T> consumer) {
        this.getEnabledStorageProviders(realm, capabilityInterface).forEachOrdered(ServicesUtils.consumeWithTimeBound(this.session, this.getStorageProviderTimeout(), consumer));
    }

    protected <T> T getStorageProviderInstance(RealmModel realm, String providerId, Class<T> capabilityInterface) {
        return this.getStorageProviderInstance(realm, providerId, capabilityInterface, false);
    }

    protected <T> T getStorageProviderInstance(RealmModel realm, String providerId, Class<T> capabilityInterface, boolean includeDisabled) {
        if (providerId == null || capabilityInterface == null) {
            return null;
        }
        return this.getStorageProviderInstance(this.getStorageProviderModel(realm, providerId), capabilityInterface, includeDisabled);
    }

    protected StorageProviderModelType getStorageProviderModel(RealmModel realm, String providerId) {
        ComponentModel componentModel = realm.getComponent(providerId);
        if (componentModel == null) {
            return null;
        }
        return (StorageProviderModelType)((Object)((CacheableStorageProviderModel)((Object)this.toStorageProviderModelTypeFunction.apply(componentModel))));
    }

    protected <T> T getStorageProviderInstance(StorageProviderModelType model, Class<T> capabilityInterface) {
        return this.getStorageProviderInstance(model, capabilityInterface, false);
    }

    protected <T> T getStorageProviderInstance(StorageProviderModelType model, Class<T> capabilityInterface, boolean includeDisabled) {
        if (model == null || !((CacheableStorageProviderModel)((Object)model)).isEnabled() && !includeDisabled || capabilityInterface == null) {
            return null;
        }
        Provider instance = (Provider)this.session.getAttribute(model.getId());
        if (instance != null && capabilityInterface.isAssignableFrom(instance.getClass())) {
            return capabilityInterface.cast(instance);
        }
        ComponentFactory<T, ProviderType> factory = this.getStorageProviderFactory(model.getProviderId());
        if (factory == null) {
            LOG.warnv("Configured StorageProvider {0} of provider id {1} does not exist", (Object)model.getName(), (Object)model.getProviderId());
            return null;
        }
        if (!Types.supports(capabilityInterface, factory, this.factoryTypeClass)) {
            return null;
        }
        instance = (Provider)factory.create(this.session, model);
        if (instance == null) {
            throw new IllegalStateException("StorageProviderFactory (of type " + factory.getClass().getName() + ") produced a null instance");
        }
        this.session.enlistForClose(instance);
        this.session.setAttribute(model.getId(), (Object)instance);
        return capabilityInterface.cast(instance);
    }

    public static Stream<ComponentModel> getStorageProviderModels(RealmModel realm, Class<? extends Provider> storageType) {
        return realm.getStorageProviders(storageType);
    }
}

