---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: DAST browser-based crawler vulnerability checks
---

<!--
This file is autogenerated. Do not edit directly.
See: https://gitlab.com/gitlab-org/security-products/dast-cwe-checks/-/blob/main/doc/how-to-generate-the-markdown-documentation.md
-->

{{< details >}}

- Tier: Ultimate
- Offering: GitLab.com, GitLab Self-Managed, GitLab Dedicated

{{< /details >}}

The [DAST browser-based crawler](../_index.md) provides vulnerability checks that are used to
scan for vulnerabilities in the site under test.

## Passive Checks

| ID                    | Check                                                                                                          | Severity | Type |
|:----------------------|:---------------------------------------------------------------------------------------------------------------|:---------|:-----|
| [1004.1](1004.1.md)   | Sensitive cookie without HttpOnly attribute                                                                    | Low | Passive |
| [16.1](16.1.md)       | Missing Content-Type header                                                                                    | Low | Passive |
| [16.10](16.10.md)     | Content-Security-Policy violations                                                                             | Info | Passive |
| [16.2](16.2.md)       | Server header exposes version information                                                                      | Low | Passive |
| [16.3](16.3.md)       | X-Powered-By header exposes version information                                                                | Low | Passive |
| [16.4](16.4.md)       | X-Backend-Server header exposes server information                                                             | Info | Passive |
| [16.5](16.5.md)       | AspNet header exposes version information                                                                      | Low | Passive |
| [16.6](16.6.md)       | AspNetMvc header exposes version information                                                                   | Low | Passive |
| [16.7](16.7.md)       | Strict-Transport-Security header missing or invalid                                                            | Low | Passive |
| [16.8](16.8.md)       | Content-Security-Policy analysis                                                                               | Info | Passive |
| [16.9](16.9.md)       | Content-Security-Policy-Report-Only analysis                                                                   | Info | Passive |
| [200.1](200.1.md)     | Exposure of sensitive information to an unauthorized actor (private IP address)                                | Low | Passive |
| [209.1](209.1.md)     | Generation of error message containing sensitive information                                                   | Low | Passive |
| [209.2](209.2.md)     | Generation of database error message containing sensitive information                                          | Low | Passive |
| [287.1](287.1.md)     | Insecure authentication over HTTP (Basic Authentication)                                                       | Medium | Passive |
| [287.2](287.2.md)     | Insecure authentication over HTTP (Digest Authentication)                                                      | Low | Passive |
| [319.1](319.1.md)     | Mixed Content                                                                                                  | Info | Passive |
| [352.1](352.1.md)     | Absence of anti-CSRF tokens                                                                                    | Medium | Passive |
| [359.1](359.1.md)     | Exposure of Private Personal Information (PII) to an unauthorized actor (credit card)                          | Medium | Passive |
| [359.2](359.2.md)     | Exposure of Private Personal Information (PII) to an unauthorized actor (United States social security number) | Medium | Passive |
| [548.1](548.1.md)     | Exposure of information through directory listing                                                              | Low | Passive |
| [598.1](598.1.md)     | Use of GET request method with sensitive query strings (session ID)                                            | Medium | Passive |
| [598.2](598.2.md)     | Use of GET request method with sensitive query strings (password)                                              | Medium | Passive |
| [598.3](598.3.md)     | Use of GET request method with sensitive query strings (Authorization header details)                          | Medium | Passive |
| [601.1](601.1.md)     | URL redirection to untrusted site ('open redirect')                                                            | Low | Passive |
| [614.1](614.1.md)     | Sensitive cookie without Secure attribute                                                                      | Low | Passive |
| [693.1](693.1.md)     | Missing X-Content-Type-Options: nosniff                                                                        | Low | Passive |
| [798.2](798.2.md) | Exposure of confidential secret or token Adobe Client ID (OAuth Web)                                           | High | Passive |
| [798.3](798.3.md) | Exposure of confidential secret or token Adobe client secret                                                   | High | Passive |
| [798.4](798.4.md) | Exposure of confidential secret or token Age secret key                                                        | High | Passive |
| [798.7](798.7.md) | Exposure of confidential secret or token Alibaba AccessKey ID                                                  | High | Passive |
| [798.8](798.8.md) | Exposure of confidential secret or token Alibaba Secret Key                                                    | High | Passive |
| [798.9](798.9.md) | Exposure of confidential secret or token Asana client ID                                                       | High | Passive |
| [798.10](798.10.md) | Exposure of confidential secret or token Asana client secret                                                   | High | Passive |
| [798.11](798.11.md) | Exposure of confidential secret or token Atlassian API token                                                   | High | Passive |
| [798.12](798.12.md) | Exposure of confidential secret or token AWS access token                                                      | High | Passive |
| [798.13](798.13.md) | Exposure of confidential secret or token Bitbucket client ID                                                   | High | Passive |
| [798.14](798.14.md) | Exposure of confidential secret or token Bitbucket client secret                                               | High | Passive |
| [798.17](798.17.md) | Exposure of confidential secret or token Beamer API token                                                      | High | Passive |
| [798.20](798.20.md) | Exposure of confidential secret or token Clojars deploy token                                                  | High | Passive |
| [798.23](798.23.md) | Exposure of confidential secret or token Contentful delivery API token                                         | High | Passive |
| [798.24](798.24.md) | Exposure of confidential secret or token Databricks API token                                                  | High | Passive |
| [798.26](798.26.md) | Exposure of confidential secret or token Discord API key                                                       | High | Passive |
| [798.27](798.27.md) | Exposure of confidential secret or token Discord client ID                                                     | High | Passive |
| [798.28](798.28.md) | Exposure of confidential secret or token Discord client secret                                                 | High | Passive |
| [798.29](798.29.md) | Exposure of confidential secret or token Doppler API token                                                     | High | Passive |
| [798.30](798.30.md) | Exposure of confidential secret or token Dropbox API secret/key                                                | High | Passive |
| [798.31](798.31.md) | Exposure of confidential secret or token Dropbox long lived API token                                          | High | Passive |
| [798.32](798.32.md) | Exposure of confidential secret or token Dropbox short lived API token                                         | High | Passive |
| [798.34](798.34.md) | Exposure of confidential secret or token Duffel API token                                                      | High | Passive |
| [798.35](798.35.md) | Exposure of confidential secret or token Dynatrace API token                                                   | High | Passive |
| [798.36](798.36.md) | Exposure of confidential secret or token EasyPost production API key                                           | High | Passive |
| [798.37](798.37.md) | Exposure of confidential secret or token EasyPost test API key                                                 | High | Passive |
| [798.39](798.39.md) | Exposure of confidential secret or token Facebook token                                                        | High | Passive |
| [798.40](798.40.md) | Exposure of confidential secret or token Fastly API user or automation token                                   | High | Passive |
| [798.41](798.41.md) | Exposure of confidential secret or token Finicity client secret                                                | High | Passive |
| [798.42](798.42.md) | Exposure of confidential secret or token Finicity API token                                                    | High | Passive |
| [798.46](798.46.md) | Exposure of confidential secret or token Flutterwave test secret key                                           | High | Passive |
| [798.47](798.47.md) | Exposure of confidential secret or token Flutterwave test encrypted key                                        | High | Passive |
| [798.48](798.48.md) | Exposure of confidential secret or token Frame.io API token                                                    | High | Passive |
| [798.50](798.50.md) | Exposure of confidential secret or token GoCardless API token                                                  | High | Passive |
| [798.52](798.52.md) | Exposure of confidential secret or token GitHub personal access token (classic)                                | High | Passive |
| [798.53](798.53.md) | Exposure of confidential secret or token GitHub OAuth Access Token                                             | High | Passive |
| [798.54](798.54.md) | Exposure of confidential secret or token GitHub app token                                                      | High | Passive |
| [798.55](798.55.md) | Exposure of confidential secret or token GitHub refresh token                                                  | High | Passive |
| [798.56](798.56.md) | Exposure of confidential secret or token GitLab personal access token                                          | High | Passive |
| [798.58](798.58.md) | Exposure of confidential secret or token HashiCorp Terraform API token                                         | High | Passive |
| [798.59](798.59.md) | Exposure of confidential secret or token Heroku API key or application authorization token                     | High | Passive |
| [798.60](798.60.md) | Exposure of confidential secret or token HubSpot private app API token                                         | High | Passive |
| [798.61](798.61.md) | Exposure of confidential secret or token Intercom API token                                                    | High | Passive |
| [798.66](798.66.md) | Exposure of confidential secret or token Linear API token                                                      | High | Passive |
| [798.67](798.67.md) | Exposure of confidential secret or token Linear client secret or ID (OAuth 2.0)                                | High | Passive |
| [798.68](798.68.md) | Exposure of confidential secret or token LinkedIn client ID                                                    | High | Passive |
| [798.69](798.69.md) | Exposure of confidential secret or token LinkedIn client secret                                                | High | Passive |
| [798.70](798.70.md) | Exposure of confidential secret or token Lob API key                                                           | High | Passive |
| [798.72](798.72.md) | Exposure of confidential secret or token Mailchimp API key                                                     | High | Passive |
| [798.74](798.74.md) | Exposure of confidential secret or token Mailgun private API token                                             | High | Passive |
| [798.75](798.75.md) | Exposure of confidential secret or token Mailgun webhook signing key                                           | High | Passive |
| [798.78](798.78.md) | Exposure of confidential secret or token MessageBird access key                                                | High | Passive |
| [798.81](798.81.md) | Exposure of confidential secret or token New Relic user API key                                                | High | Passive |
| [798.82](798.82.md) | Exposure of confidential secret or token New Relic user API ID                                                 | High | Passive |
| [798.83](798.83.md) | Exposure of confidential secret or token New Relic ingest browser API token                                    | High | Passive |
| [798.84](798.84.md) | Exposure of confidential secret or token npm access token                                                      | High | Passive |
| [798.90](798.90.md) | Exposure of confidential secret or token PlanetScale password                                                  | High | Passive |
| [798.91](798.91.md) | Exposure of confidential secret or token PlanetScale API token                                                 | High | Passive |
| [798.93](798.93.md) | Exposure of confidential secret or token Postman API token                                                     | High | Passive |
| [798.94](798.94.md) | Exposure of confidential secret or token SSH private key                                                       | High | Passive |
| [798.95](798.95.md) | Exposure of confidential secret or token Pulumi API token                                                      | High | Passive |
| [798.96](798.96.md) | Exposure of confidential secret or token PyPi upload token                                                     | High | Passive |
| [798.97](798.97.md) | Exposure of confidential secret or token RubyGems API token                                                    | High | Passive |
| [798.101](798.101.md) | Exposure of confidential secret or token SendGrid API token                                                    | High | Passive |
| [798.102](798.102.md) | Exposure of confidential secret or token Brevo API token                                                       | High | Passive |
| [798.104](798.104.md) | Exposure of confidential secret or token Shippo API token                                                      | High | Passive |
| [798.105](798.105.md) | Exposure of confidential secret or token Shopify personal access token                                         | High | Passive |
| [798.106](798.106.md) | Exposure of confidential secret or token Shopify custom app access token                                       | High | Passive |
| [798.107](798.107.md) | Exposure of confidential secret or token Shopify private app access token                                      | High | Passive |
| [798.108](798.108.md) | Exposure of confidential secret or token Shopify shared secret                                                 | High | Passive |
| [798.109](798.109.md) | Exposure of confidential secret or token Slack bot user OAuth token                                            | High | Passive |
| [798.110](798.110.md) | Exposure of confidential secret or token Slack webhook                                                         | High | Passive |
| [798.111](798.111.md) | Exposure of confidential secret or token Stripe live secret key                                                | High | Passive |
| [798.117](798.117.md) | Exposure of confidential secret or token Twilio API key                                                        | High | Passive |
| [798.118](798.118.md) | Exposure of confidential secret or token Twitch OAuth client secret                                            | High | Passive |
| [798.121](798.121.md) | Exposure of confidential secret or token X token                                                               | High | Passive |
| [798.124](798.124.md) | Exposure of confidential secret or token Typeform personal access token                                        | High | Passive |
| [798.130](798.130.md) | Exposure of confidential secret or token Anthropic API key                                                     | High | Passive |
| [798.131](798.131.md) | Exposure of confidential secret or token CircleCI access token                                                 | High | Passive |
| [798.132](798.132.md) | Exposure of confidential secret or token CircleCI Personal Access Token                                        | High | Passive |
| [798.133](798.133.md) | Exposure of confidential secret or token Contentful preview API token                                          | High | Passive |
| [798.134](798.134.md) | Exposure of confidential secret or token Contentful personal access token                                      | High | Passive |
| [798.135](798.135.md) | Exposure of confidential secret or token DigitalOcean OAuth access token                                       | High | Passive |
| [798.136](798.136.md) | Exposure of confidential secret or token DigitalOcean personal access token                                    | High | Passive |
| [798.137](798.137.md) | Exposure of confidential secret or token DigitalOcean refresh token                                            | High | Passive |
| [798.138](798.138.md) | Exposure of confidential secret or token GCP OAuth client secret                                               | High | Passive |
| [798.139](798.139.md) | Exposure of confidential secret or token Google (GCP) service account                                          | High | Passive |
| [798.140](798.140.md) | Exposure of confidential secret or token GitLab Personal Access Token (routable)                               | High | Passive |
| [798.141](798.141.md) | Exposure of confidential secret or token GitLab Personal Access Token (routable)                               | High | Passive |
| [798.142](798.142.md) | Exposure of confidential secret or token GitLab Pipeline trigger token                                         | High | Passive |
| [798.143](798.143.md) | Exposure of confidential secret or token GitLab Runner registration token                                      | High | Passive |
| [798.144](798.144.md) | Exposure of confidential secret or token GitLab Runner authentication token                                    | High | Passive |
| [798.145](798.145.md) | Exposure of confidential secret or token GitLab Feed token                                                     | High | Passive |
| [798.146](798.146.md) | Exposure of confidential secret or token GitLab OAuth application secret                                       | High | Passive |
| [798.147](798.147.md) | Exposure of confidential secret or token GitLab feed token v2                                                  | High | Passive |
| [798.148](798.148.md) | Exposure of confidential secret or token GitLab Kubernetes agent token                                         | High | Passive |
| [798.149](798.149.md) | Exposure of confidential secret or token GitLab incoming email token                                           | High | Passive |
| [798.150](798.150.md) | Exposure of confidential secret or token GitLab deploy token                                                   | High | Passive |
| [798.151](798.151.md) | Exposure of confidential secret or token GitLab SCIM OAuth token                                               | High | Passive |
| [798.152](798.152.md) | Exposure of confidential secret or token GitLab CI build token                                                 | High | Passive |
| [798.153](798.153.md) | Exposure of confidential secret or token Grafana API token                                                     | High | Passive |
| [798.154](798.154.md) | Exposure of confidential secret or token HashiCorp Vault batch token                                           | High | Passive |
| [798.155](798.155.md) | Exposure of confidential secret or token Instagram access token                                                | High | Passive |
| [798.156](798.156.md) | Exposure of confidential secret or token Intercom client secret or client ID                                   | High | Passive |
| [798.157](798.157.md) | Exposure of confidential secret or token Ionic personal access token                                           | High | Passive |
| [798.158](798.158.md) | Exposure of confidential secret or token Artifactory API Key                                                   | High | Passive |
| [798.159](798.159.md) | Exposure of confidential secret or token Artifactory Identity Token                                            | High | Passive |
| [798.160](798.160.md) | Exposure of confidential secret or token MaxMind License Key                                                   | High | Passive |
| [798.161](798.161.md) | Exposure of confidential secret or token Meta access token                                                     | High | Passive |
| [798.162](798.162.md) | Exposure of confidential secret or token Oculus access token                                                   | High | Passive |
| [798.163](798.163.md) | Exposure of confidential secret or token Onfido Live API Token                                                 | High | Passive |
| [798.164](798.164.md) | Exposure of confidential secret or token OpenAI API key                                                        | High | Passive |
| [798.165](798.165.md) | Exposure of confidential secret or token Password in URL                                                       | High | Passive |
| [798.166](798.166.md) | Exposure of confidential secret or token PGP private key                                                       | High | Passive |
| [798.167](798.167.md) | Exposure of confidential secret or token PKCS8 private key                                                     | High | Passive |
| [798.168](798.168.md) | Exposure of confidential secret or token RSA private key                                                       | High | Passive |
| [798.169](798.169.md) | Exposure of confidential secret or token Segment public API token                                              | High | Passive |
| [798.170](798.170.md) | Exposure of confidential secret or token Brevo SMTP token                                                      | High | Passive |
| [798.171](798.171.md) | Exposure of confidential secret or token Shippo Test API token                                                 | High | Passive |
| [798.172](798.172.md) | Exposure of confidential secret or token Slack app level token                                                 | High | Passive |
| [798.173](798.173.md) | Exposure of confidential secret or token SSH (DSA) private key                                                 | High | Passive |
| [798.174](798.174.md) | Exposure of confidential secret or token SSH (EC) private key                                                  | High | Passive |
| [798.175](798.175.md) | Exposure of confidential secret or token Stripe live restricted key                                            | High | Passive |
| [798.176](798.176.md) | Exposure of confidential secret or token Stripe publishable live key                                           | High | Passive |
| [798.177](798.177.md) | Exposure of confidential secret or token Stripe secret test key                                                | High | Passive |
| [798.178](798.178.md) | Exposure of confidential secret or token Stripe restricted test key                                            | High | Passive |
| [798.179](798.179.md) | Exposure of confidential secret or token Stripe publishable test key                                           | High | Passive |
| [798.180](798.180.md) | Exposure of confidential secret or token Tailscale key                                                         | High | Passive |
| [798.181](798.181.md) | Exposure of confidential secret or token Yandex Cloud IAM cookie v1-1                                          | High | Passive |
| [798.182](798.182.md) | Exposure of confidential secret or token Yandex Cloud IAM cookie v1-2                                          | High | Passive |
| [798.183](798.183.md) | Exposure of confidential secret or token Yandex Cloud IAM cookie v1-3                                          | High | Passive |
| [798.184](798.184.md) | Exposure of confidential secret or token Yandex Cloud AWS API compatible access secret                         | High | Passive |
| [829.1](829.1.md)     | Inclusion of Functionality from Untrusted Control Sphere                                                       | Low | Passive |
| [829.2](829.2.md)     | Invalid Sub-Resource Integrity values detected                                                                 | Medium | Passive |

## Active Checks

| ID | Check | Severity | Type |
|:---|:------|:---------|:-----|
| [113.1](113.1.md) | Improper Neutralization of CRLF Sequences in HTTP Headers | High | Active |
| [1336.1](1336.1.md) | Server-Side Template Injection | High | Active |
| [16.11](16.11.md) | TRACE HTTP method enabled | High | Active |
| [22.1](22.1.md) | Improper limitation of a pathname to a restricted directory (Path traversal) | High | Active |
| [611.1](611.1.md) | External XML Entity Injection (XXE) | High | Active |
| [74.1](74.1.md) | XSLT Injection | High | Active |
| [78.1](78.1.md) | OS Command Injection | High | Active |
| [79.1](79.1.md) | Cross Site Scripting | High | Active |
| [89.1](89.1.md) | SQL Injection | High | Active |
| [917.1](917.1.md) | Expression Language Injection | High | Active |
| [918.1](918.1.md) | Server-Side Request Forgery | High | Active |
| [94.1](94.1.md) | Server-side code injection (PHP) | High | Active |
| [94.2](94.2.md) | Server-side code injection (Ruby) | High | Active |
| [94.3](94.3.md) | Server-side code injection (Python) | High | Active |
| [94.4](94.4.md) | Server-side code injection (NodeJS) | High | Active |
| [943.1](943.1.md) | Improper neutralization of special elements in data query logic | High | Active |
| [98.1](98.1.md) | PHP Remote File Inclusion | High | Active |
