﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/securityhub/SecurityHub_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace SecurityHub {
namespace Model {

/**
 * <p>Identifies which finding to get the finding history for.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/AwsSecurityFindingIdentifier">AWS
 * API Reference</a></p>
 */
class AwsSecurityFindingIdentifier {
 public:
  AWS_SECURITYHUB_API AwsSecurityFindingIdentifier() = default;
  AWS_SECURITYHUB_API AwsSecurityFindingIdentifier(Aws::Utils::Json::JsonView jsonValue);
  AWS_SECURITYHUB_API AwsSecurityFindingIdentifier& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_SECURITYHUB_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The identifier of the finding that was specified by the finding provider.</p>
   */
  inline const Aws::String& GetId() const { return m_id; }
  inline bool IdHasBeenSet() const { return m_idHasBeenSet; }
  template <typename IdT = Aws::String>
  void SetId(IdT&& value) {
    m_idHasBeenSet = true;
    m_id = std::forward<IdT>(value);
  }
  template <typename IdT = Aws::String>
  AwsSecurityFindingIdentifier& WithId(IdT&& value) {
    SetId(std::forward<IdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ARN generated by Security Hub that uniquely identifies a product that
   * generates findings. This can be the ARN for a third-party product that is
   * integrated with Security Hub, or the ARN for a custom integration.</p>
   */
  inline const Aws::String& GetProductArn() const { return m_productArn; }
  inline bool ProductArnHasBeenSet() const { return m_productArnHasBeenSet; }
  template <typename ProductArnT = Aws::String>
  void SetProductArn(ProductArnT&& value) {
    m_productArnHasBeenSet = true;
    m_productArn = std::forward<ProductArnT>(value);
  }
  template <typename ProductArnT = Aws::String>
  AwsSecurityFindingIdentifier& WithProductArn(ProductArnT&& value) {
    SetProductArn(std::forward<ProductArnT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_id;
  bool m_idHasBeenSet = false;

  Aws::String m_productArn;
  bool m_productArnHasBeenSet = false;
};

}  // namespace Model
}  // namespace SecurityHub
}  // namespace Aws
