/* i086-dos16.com.h
   created from i086-dos16.com.bin, 4704 (0x1260) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) Markus Franz Xaver Johannes Oberhumer
   Copyright (C) Laszlo Molnar
   Copyright (C) John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ezerotven+github@gmail.com>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */

/* clang-format off */

#define STUB_I086_DOS16_COM_SIZE    4704
#define STUB_I086_DOS16_COM_ADLER32 0x6c5c22ee
#define STUB_I086_DOS16_COM_CRC32   0x6335b4e3

unsigned char stub_i086_dos16_com[4704] = {
/* 0x0000 */ 127, 69, 76, 70,  1,  1,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   1,  0,  3,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */  72,  2,  0,  0,  0,  0,  0,  0, 52,  0,  0,  0,  0,  0, 40,  0,
/* 0x0030 */   0,  0,  0,  0,129,252,  0,  0,119,  2,205, 32,185,  0,  0,190,
/* 0x0040 */   0,  0,191,  0,  0,187,  0,128,253,243,164,252,135,247,131,238,
/* 0x0050 */   0, 25,237, 87, 87,233,255,255, 85, 80, 88, 33,161,216,208,213,
/* 0x0060 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 45,164,232,
/* 0x0070 */  11,  0,114,250, 65,232,  6,  0,227, 21,227, 20,115,  6,131,233,
/* 0x0080 */   3,114,  6,136,204,172,247,208,149, 49,201,232,  6,  0, 17,201,
/* 0x0090 */ 117,  8, 65,232,  6,  0,115,251, 65, 65, 65,129,253,  0,243,131,
/* 0x00a0 */ 209,  1,141,  3,150,243,164,150,235,  0,232,  2,  0, 17,201,  1,
/* 0x00b0 */ 219,117,  4,173, 17,192,147,195, 94,185,  0,  0,172, 44,232, 60,
/* 0x00c0 */   1,119,249,193,  4,  8, 41, 52,139, 28,134,223, 41,243,137, 28,
/* 0x00d0 */ 173,226,  3,176,232,176,233, 95,185,  0,  0,242,174,117, 20,117,
/* 0x00e0 */   2,193,  5,  8, 41, 61,139, 29,134,223, 41,251,137, 29,175,235,
/* 0x00f0 */   3,195,102,105,108,101, 32,102,111,114,109, 97,116, 32,101,108,
/* 0x0100 */ 102, 51, 50, 45,105, 51, 56, 54, 10, 10, 83,101, 99,116,105,111,
/* 0x0110 */ 110,115, 58, 10, 73,100,120, 32, 78, 97,109,101, 32, 32, 32, 32,
/* 0x0120 */  32, 32, 32, 32, 32, 32, 83,105,122,101, 32, 32, 32, 32, 32, 32,
/* 0x0130 */  86, 77, 65, 32, 32, 32, 32, 32, 32, 32, 76, 77, 65, 32, 32, 32,
/* 0x0140 */  32, 32, 32, 32, 70,105,108,101, 32,111,102,102, 32, 32, 65,108,
/* 0x0150 */ 103,110, 32, 32, 70,108, 97,103,115, 10, 32, 32, 48, 32, 67, 79,
/* 0x0160 */  77, 77, 65, 73, 78, 49, 32, 32, 32, 32, 32, 32, 48, 49,100, 32,
/* 0x0170 */  32, 48, 32, 32, 48, 32, 32, 48, 51, 52, 32, 32, 50, 42, 42, 48,
/* 0x0180 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 49, 32, 67,
/* 0x0190 */  79, 77, 83, 66, 66, 66, 80, 32, 32, 32, 32, 32, 32, 48, 50, 32,
/* 0x01a0 */  32, 48, 32, 32, 48, 32, 32, 48, 53, 49, 32, 32, 50, 42, 42, 48,
/* 0x01b0 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 50, 32, 67,
/* 0x01c0 */  79, 77, 80, 83, 72, 68, 73, 32, 32, 32, 32, 32, 32, 48, 49, 32,
/* 0x01d0 */  32, 48, 32, 32, 48, 32, 32, 48, 53, 51, 32, 32, 50, 42, 42, 48,
/* 0x01e0 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 51, 32, 67,
/* 0x01f0 */  79, 77, 67, 65, 76, 76, 84, 32, 32, 32, 32, 32, 32, 48, 49, 32,
/* 0x0200 */  32, 48, 32, 32, 48, 32, 32, 48, 53, 52, 32, 32, 50, 42, 42, 48,
/* 0x0210 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 52, 32, 67,
/* 0x0220 */  79, 77, 77, 65, 73, 78, 50, 32, 32, 32, 32, 32, 32, 48, 51, 32,
/* 0x0230 */  32, 48, 32, 32, 48, 32, 32, 48, 53, 53, 32, 32, 50, 42, 42, 48,
/* 0x0240 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 53, 32, 85,
/* 0x0250 */  80, 88, 49, 72, 69, 65, 68, 32, 32, 32, 32, 32, 32, 48, 49, 54,
/* 0x0260 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 53, 56, 32, 32, 50, 42, 42,
/* 0x0270 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 54, 32,
/* 0x0280 */  67, 79, 77, 67, 85, 84, 80, 79, 32, 32, 32, 32, 32, 32, 48, 32,
/* 0x0290 */  32, 48, 32, 32, 48, 32, 32, 48, 54,101, 32, 32, 50, 42, 42, 48,
/* 0x02a0 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 55, 32, 78,
/* 0x02b0 */  82, 86, 50, 66, 49, 54, 48, 32, 32, 32, 32, 32, 32, 48, 97, 32,
/* 0x02c0 */  32, 48, 32, 32, 48, 32, 32, 48, 54,101, 32, 32, 50, 42, 42, 48,
/* 0x02d0 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 56, 32, 78,
/* 0x02e0 */  82, 86, 68, 68, 79, 78, 69, 32, 32, 32, 32, 32, 32, 48, 50, 32,
/* 0x02f0 */  32, 48, 32, 32, 48, 32, 32, 48, 55, 56, 32, 32, 50, 42, 42, 48,
/* 0x0300 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 57, 32, 78,
/* 0x0310 */  82, 86, 68, 82, 69, 84, 85, 32, 32, 32, 32, 32, 32, 48, 50, 32,
/* 0x0320 */  32, 48, 32, 32, 48, 32, 32, 48, 55, 97, 32, 32, 50, 42, 42, 48,
/* 0x0330 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 48, 32, 78,
/* 0x0340 */  82, 86, 68, 69, 67, 79, 49, 32, 32, 32, 32, 32, 32, 48, 49,101,
/* 0x0350 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 55, 99, 32, 32, 50, 42, 42,
/* 0x0360 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 49, 32,
/* 0x0370 */  78, 82, 86, 76, 69, 68, 48, 48, 32, 32, 32, 32, 32, 32, 48, 49,
/* 0x0380 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 57, 97, 32, 32, 50, 42, 42,
/* 0x0390 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 50, 32,
/* 0x03a0 */  78, 82, 86, 71, 84, 68, 48, 48, 32, 32, 32, 32, 32, 32, 48, 55,
/* 0x03b0 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 57, 98, 32, 32, 50, 42, 42,
/* 0x03c0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 51, 32,
/* 0x03d0 */  78, 82, 86, 68, 69, 67, 79, 50, 32, 32, 32, 32, 32, 32, 48, 49,
/* 0x03e0 */  54, 32, 32, 48, 32, 32, 48, 32, 32, 48, 97, 50, 32, 32, 50, 42,
/* 0x03f0 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 52,
/* 0x0400 */  32, 67, 65, 76, 76, 84, 82, 49, 54, 32, 32, 32, 32, 32, 32, 48,
/* 0x0410 */  98, 32, 32, 48, 32, 32, 48, 32, 32, 48, 98, 56, 32, 32, 50, 42,
/* 0x0420 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 53,
/* 0x0430 */  32, 67, 84, 49, 54, 73, 50, 56, 54, 32, 32, 32, 32, 32, 32, 48,
/* 0x0440 */  51, 32, 32, 48, 32, 32, 48, 32, 32, 48, 99, 51, 32, 32, 50, 42,
/* 0x0450 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 54,
/* 0x0460 */  32, 67, 84, 49, 54, 83, 85, 66, 48, 32, 32, 32, 32, 32, 32, 48,
/* 0x0470 */  50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 99, 54, 32, 32, 50, 42,
/* 0x0480 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 55,
/* 0x0490 */  32, 67, 84, 49, 54, 73, 48, 56, 54, 32, 32, 32, 32, 32, 32, 48,
/* 0x04a0 */  56, 32, 32, 48, 32, 32, 48, 32, 32, 48, 99, 56, 32, 32, 50, 42,
/* 0x04b0 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 56,
/* 0x04c0 */  32, 67, 65, 76, 76, 84, 82, 73, 50, 32, 32, 32, 32, 32, 32, 48,
/* 0x04d0 */  51, 32, 32, 48, 32, 32, 48, 32, 32, 48,100, 48, 32, 32, 50, 42,
/* 0x04e0 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 57,
/* 0x04f0 */  32, 67, 84, 49, 54, 69, 56, 48, 48, 32, 32, 32, 32, 32, 32, 48,
/* 0x0500 */  50, 32, 32, 48, 32, 32, 48, 32, 32, 48,100, 51, 32, 32, 50, 42,
/* 0x0510 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 50, 48,
/* 0x0520 */  32, 67, 84, 49, 54, 69, 57, 48, 48, 32, 32, 32, 32, 32, 32, 48,
/* 0x0530 */  50, 32, 32, 48, 32, 32, 48, 32, 32, 48,100, 53, 32, 32, 50, 42,
/* 0x0540 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 50, 49,
/* 0x0550 */  32, 67, 65, 76, 76, 84, 82, 73, 53, 32, 32, 32, 32, 32, 32, 48,
/* 0x0560 */  54, 32, 32, 48, 32, 32, 48, 32, 32, 48,100, 55, 32, 32, 50, 42,
/* 0x0570 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 50, 50,
/* 0x0580 */  32, 67, 84, 49, 54, 74, 69, 78, 68, 32, 32, 32, 32, 32, 32, 48,
/* 0x0590 */  50, 32, 32, 48, 32, 32, 48, 32, 32, 48,100,100, 32, 32, 50, 42,
/* 0x05a0 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 50, 51,
/* 0x05b0 */  32, 67, 84, 49, 54, 74, 85, 76, 50, 32, 32, 32, 32, 32, 32, 48,
/* 0x05c0 */  50, 32, 32, 48, 32, 32, 48, 32, 32, 48,100,102, 32, 32, 50, 42,
/* 0x05d0 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 50, 52,
/* 0x05e0 */  32, 67, 84, 49, 54, 73, 50, 56, 55, 32, 32, 32, 32, 32, 32, 48,
/* 0x05f0 */  51, 32, 32, 48, 32, 32, 48, 32, 32, 48,101, 49, 32, 32, 50, 42,
/* 0x0600 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 50, 53,
/* 0x0610 */  32, 67, 84, 49, 54, 83, 85, 66, 49, 32, 32, 32, 32, 32, 32, 48,
/* 0x0620 */  50, 32, 32, 48, 32, 32, 48, 32, 32, 48,101, 52, 32, 32, 50, 42,
/* 0x0630 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 50, 54,
/* 0x0640 */  32, 67, 84, 49, 54, 73, 48, 56, 55, 32, 32, 32, 32, 32, 32, 48,
/* 0x0650 */  56, 32, 32, 48, 32, 32, 48, 32, 32, 48,101, 54, 32, 32, 50, 42,
/* 0x0660 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 50, 55,
/* 0x0670 */  32, 67, 65, 76, 76, 84, 82, 73, 54, 32, 32, 32, 32, 32, 32, 48,
/* 0x0680 */  51, 32, 32, 48, 32, 32, 48, 32, 32, 48,101,101, 32, 32, 50, 42,
/* 0x0690 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 50, 56,
/* 0x06a0 */  32, 67, 79, 82, 69, 84, 85, 82, 78, 32, 32, 32, 32, 32, 32, 48,
/* 0x06b0 */  49, 32, 32, 48, 32, 32, 48, 32, 32, 48,102, 49, 32, 32, 50, 42,
/* 0x06c0 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 83, 89, 77,
/* 0x06d0 */  66, 79, 76, 32, 84, 65, 66, 76, 69, 58, 10, 48, 48, 48, 48, 48,
/* 0x06e0 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50,
/* 0x06f0 */  66, 49, 54, 48, 32, 48, 32, 78, 82, 86, 50, 66, 49, 54, 48, 10,
/* 0x0700 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x0710 */  32, 78, 82, 86, 68, 69, 67, 79, 50, 32, 48, 32, 78, 82, 86, 68,
/* 0x0720 */  69, 67, 79, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x0730 */  32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84, 82, 49, 54, 32, 48,
/* 0x0740 */  32, 67, 65, 76, 76, 84, 82, 49, 54, 10, 48, 48, 48, 48, 48, 48,
/* 0x0750 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84,
/* 0x0760 */  82, 73, 53, 32, 48, 32, 67, 65, 76, 76, 84, 82, 73, 53, 10, 48,
/* 0x0770 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x0780 */  67, 65, 76, 76, 84, 82, 73, 54, 32, 48, 32, 67, 65, 76, 76, 84,
/* 0x0790 */  82, 73, 54, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x07a0 */  32, 32,100, 32, 32, 67, 79, 77, 77, 65, 73, 78, 49, 32, 48, 32,
/* 0x07b0 */  67, 79, 77, 77, 65, 73, 78, 49, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x07c0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 79, 77, 83, 66, 66,
/* 0x07d0 */  66, 80, 32, 48, 32, 67, 79, 77, 83, 66, 66, 66, 80, 10, 48, 48,
/* 0x07e0 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67,
/* 0x07f0 */  79, 77, 80, 83, 72, 68, 73, 32, 48, 32, 67, 79, 77, 80, 83, 72,
/* 0x0800 */  68, 73, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x0810 */  32,100, 32, 32, 67, 79, 77, 67, 65, 76, 76, 84, 32, 48, 32, 67,
/* 0x0820 */  79, 77, 67, 65, 76, 76, 84, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x0830 */  32,108, 32, 32, 32, 32,100, 32, 32, 67, 79, 77, 77, 65, 73, 78,
/* 0x0840 */  50, 32, 48, 32, 67, 79, 77, 77, 65, 73, 78, 50, 10, 48, 48, 48,
/* 0x0850 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 85, 80,
/* 0x0860 */  88, 49, 72, 69, 65, 68, 32, 48, 32, 85, 80, 88, 49, 72, 69, 65,
/* 0x0870 */  68, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x0880 */ 100, 32, 32, 67, 79, 77, 67, 85, 84, 80, 79, 32, 48, 32, 67, 79,
/* 0x0890 */  77, 67, 85, 84, 80, 79, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x08a0 */ 108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 68, 68, 79, 78, 69,
/* 0x08b0 */  32, 48, 32, 78, 82, 86, 68, 68, 79, 78, 69, 10, 48, 48, 48, 48,
/* 0x08c0 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86,
/* 0x08d0 */  68, 82, 69, 84, 85, 32, 48, 32, 78, 82, 86, 68, 82, 69, 84, 85,
/* 0x08e0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x08f0 */  32, 32, 78, 82, 86, 68, 69, 67, 79, 49, 32, 48, 32, 78, 82, 86,
/* 0x0900 */  68, 69, 67, 79, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x0910 */  32, 32, 32, 32,100, 32, 32, 78, 82, 86, 76, 69, 68, 48, 48, 32,
/* 0x0920 */  48, 32, 78, 82, 86, 76, 69, 68, 48, 48, 10, 48, 48, 48, 48, 48,
/* 0x0930 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 71,
/* 0x0940 */  84, 68, 48, 48, 32, 48, 32, 78, 82, 86, 71, 84, 68, 48, 48, 10,
/* 0x0950 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x0960 */  32, 67, 84, 49, 54, 73, 50, 56, 54, 32, 48, 32, 67, 84, 49, 54,
/* 0x0970 */  73, 50, 56, 54, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x0980 */  32, 32, 32,100, 32, 32, 67, 84, 49, 54, 83, 85, 66, 48, 32, 48,
/* 0x0990 */  32, 67, 84, 49, 54, 83, 85, 66, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x09a0 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84, 49, 54, 73,
/* 0x09b0 */  48, 56, 54, 32, 48, 32, 67, 84, 49, 54, 73, 48, 56, 54, 10, 48,
/* 0x09c0 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x09d0 */  67, 65, 76, 76, 84, 82, 73, 50, 32, 48, 32, 67, 65, 76, 76, 84,
/* 0x09e0 */  82, 73, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x09f0 */  32, 32,100, 32, 32, 67, 84, 49, 54, 69, 56, 48, 48, 32, 48, 32,
/* 0x0a00 */  67, 84, 49, 54, 69, 56, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x0a10 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84, 49, 54, 69, 57,
/* 0x0a20 */  48, 48, 32, 48, 32, 67, 84, 49, 54, 69, 57, 48, 48, 10, 48, 48,
/* 0x0a30 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67,
/* 0x0a40 */  84, 49, 54, 74, 69, 78, 68, 32, 48, 32, 67, 84, 49, 54, 74, 69,
/* 0x0a50 */  78, 68, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x0a60 */  32,100, 32, 32, 67, 84, 49, 54, 74, 85, 76, 50, 32, 48, 32, 67,
/* 0x0a70 */  84, 49, 54, 74, 85, 76, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x0a80 */  32,108, 32, 32, 32, 32,100, 32, 32, 67, 84, 49, 54, 73, 50, 56,
/* 0x0a90 */  55, 32, 48, 32, 67, 84, 49, 54, 73, 50, 56, 55, 10, 48, 48, 48,
/* 0x0aa0 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84,
/* 0x0ab0 */  49, 54, 83, 85, 66, 49, 32, 48, 32, 67, 84, 49, 54, 83, 85, 66,
/* 0x0ac0 */  49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x0ad0 */ 100, 32, 32, 67, 84, 49, 54, 73, 48, 56, 55, 32, 48, 32, 67, 84,
/* 0x0ae0 */  49, 54, 73, 48, 56, 55, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x0af0 */ 108, 32, 32, 32, 32,100, 32, 32, 67, 79, 82, 69, 84, 85, 82, 78,
/* 0x0b00 */  32, 48, 32, 67, 79, 82, 69, 84, 85, 82, 78, 10, 48, 48, 48, 48,
/* 0x0b10 */  48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78,
/* 0x0b20 */  68, 42, 32, 48, 32,115,112, 95,108,105,109,105,116, 10, 48, 48,
/* 0x0b30 */  48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42,
/* 0x0b40 */  85, 78, 68, 42, 32, 48, 32, 98,121,116,101,115, 95,116,111, 95,
/* 0x0b50 */  99,111,112,121, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32,
/* 0x0b60 */  32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32, 48, 32, 99,111,
/* 0x0b70 */ 112,121, 95,115,111,117,114, 99,101, 10, 48, 48, 48, 48, 48, 48,
/* 0x0b80 */  48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,
/* 0x0b90 */  32, 48, 32, 99,111,112,121, 95,100,101,115,116,105,110, 97,116,
/* 0x0ba0 */ 105,111,110, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32,
/* 0x0bb0 */  32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32, 48, 32,110,101,103,
/* 0x0bc0 */  95,101, 95,108,101,110, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x0bd0 */  32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32, 48, 32,
/* 0x0be0 */  99, 97,108,108,116,114,105, 99,107, 95, 99, 97,108,108,115, 10,
/* 0x0bf0 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x0c00 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 79, 77, 77, 65, 73, 78,
/* 0x0c10 */  49, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,
/* 0x0c20 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x0c30 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 50, 32, 82, 95,
/* 0x0c40 */  51, 56, 54, 95, 49, 54, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x0c50 */ 115,112, 95,108,105,109,105,116, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x0c60 */  57, 32, 82, 95, 51, 56, 54, 95, 49, 54, 32, 32, 32, 32, 32, 32,
/* 0x0c70 */  32, 32, 32, 32, 98,121,116,101,115, 95,116,111, 95, 99,111,112,
/* 0x0c80 */ 121, 10, 48, 48, 48, 48, 48, 48, 48, 99, 32, 82, 95, 51, 56, 54,
/* 0x0c90 */  95, 49, 54, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 99,111,112,
/* 0x0ca0 */ 121, 95,115,111,117,114, 99,101, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x0cb0 */ 102, 32, 82, 95, 51, 56, 54, 95, 49, 54, 32, 32, 32, 32, 32, 32,
/* 0x0cc0 */  32, 32, 32, 32, 99,111,112,121, 95,100,101,115,116,105,110, 97,
/* 0x0cd0 */ 116,105,111,110, 10, 48, 48, 48, 48, 48, 48, 49, 99, 32, 82, 95,
/* 0x0ce0 */  51, 56, 54, 95, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x0cf0 */ 110,101,103, 95,101, 95,108,101,110, 10, 10, 82, 69, 76, 79, 67,
/* 0x0d00 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x0d10 */  82, 32, 91, 67, 79, 77, 77, 65, 73, 78, 50, 93, 58, 10, 79, 70,
/* 0x0d20 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x0d30 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x0d40 */  48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67,
/* 0x0d50 */  49, 54, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 49,
/* 0x0d60 */  54, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x0d70 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 50,
/* 0x0d80 */  66, 49, 54, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x0d90 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x0da0 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 50,
/* 0x0db0 */  32, 82, 95, 51, 56, 54, 95, 80, 67, 49, 54, 32, 32, 32, 32, 32,
/* 0x0dc0 */  32, 32, 32, 78, 82, 86, 68, 69, 67, 79, 50, 10, 48, 48, 48, 48,
/* 0x0dd0 */  48, 48, 48, 56, 32, 82, 95, 51, 56, 54, 95, 80, 67, 49, 54, 32,
/* 0x0de0 */  32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 68, 69, 67, 79, 50, 10,
/* 0x0df0 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x0e00 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 68, 68, 79, 78,
/* 0x0e10 */  69, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,
/* 0x0e20 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x0e30 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95,
/* 0x0e40 */  51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x0e50 */  78, 82, 86, 68, 69, 67, 79, 50, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x0e60 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x0e70 */  32, 91, 78, 82, 86, 68, 82, 69, 84, 85, 93, 58, 10, 79, 70, 70,
/* 0x0e80 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x0e90 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x0ea0 */  48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56,
/* 0x0eb0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 68, 69, 67, 79,
/* 0x0ec0 */  50, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x0ed0 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 68, 69,
/* 0x0ee0 */  67, 79, 49, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x0ef0 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x0f00 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32,
/* 0x0f10 */  82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x0f20 */  32, 32, 78, 82, 86, 50, 66, 49, 54, 48, 10, 48, 48, 48, 48, 48,
/* 0x0f30 */  48, 49, 48, 32, 82, 95, 51, 56, 54, 95, 80, 67, 49, 54, 32, 32,
/* 0x0f40 */  32, 32, 32, 32, 32, 32, 78, 82, 86, 68, 69, 67, 79, 50, 10, 48,
/* 0x0f50 */  48, 48, 48, 48, 48, 49, 56, 32, 82, 95, 51, 56, 54, 95, 80, 67,
/* 0x0f60 */  49, 54, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 68, 69, 67,
/* 0x0f70 */  79, 50, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x0f80 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 68,
/* 0x0f90 */  69, 67, 79, 50, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x0fa0 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x0fb0 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 55,
/* 0x0fc0 */  32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,
/* 0x0fd0 */  32, 32, 32, 78, 82, 86, 50, 66, 49, 54, 48, 10, 10, 82, 69, 76,
/* 0x0fe0 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x0ff0 */  70, 79, 82, 32, 91, 67, 65, 76, 76, 84, 82, 49, 54, 93, 58, 10,
/* 0x1000 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x1010 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x1020 */  10, 48, 48, 48, 48, 48, 48, 48, 50, 32, 82, 95, 51, 56, 54, 95,
/* 0x1030 */  49, 54, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 99, 97,108,108,
/* 0x1040 */ 116,114,105, 99,107, 95, 99, 97,108,108,115, 10, 10, 82, 69, 76,
/* 0x1050 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x1060 */  70, 79, 82, 32, 91, 67, 65, 76, 76, 84, 82, 73, 50, 93, 58, 10,
/* 0x1070 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x1080 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x1090 */  10, 48, 48, 48, 48, 48, 48, 48, 50, 32, 82, 95, 51, 56, 54, 95,
/* 0x10a0 */  80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 67, 65, 76, 76,
/* 0x10b0 */  84, 82, 49, 54, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x10c0 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 65,
/* 0x10d0 */  76, 76, 84, 82, 73, 53, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x10e0 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x10f0 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x1100 */  48, 50, 32, 82, 95, 51, 56, 54, 95, 49, 54, 32, 32, 32, 32, 32,
/* 0x1110 */  32, 32, 32, 32, 32, 99, 97,108,108,116,114,105, 99,107, 95, 99,
/* 0x1120 */  97,108,108,115, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x1130 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 84,
/* 0x1140 */  49, 54, 74, 69, 78, 68, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x1150 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1160 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x1170 */  48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32,
/* 0x1180 */  32, 32, 32, 32, 32, 78, 82, 86, 68, 69, 67, 79, 50, 10, 10, 82,
/* 0x1190 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x11a0 */  83, 32, 70, 79, 82, 32, 91, 67, 84, 49, 54, 74, 85, 76, 50, 93,
/* 0x11b0 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x11c0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x11d0 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56,
/* 0x11e0 */  54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 67, 65,
/* 0x11f0 */  76, 76, 84, 82, 73, 54, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x1200 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x1210 */  67, 65, 76, 76, 84, 82, 73, 54, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x1220 */  84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1230 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x1240 */  48, 48, 48, 50, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32,
/* 0x1250 */  32, 32, 32, 32, 32, 32, 32, 67, 65, 76, 76, 84, 82, 73, 53, 10
};
