/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1alpha2

import (
	labels "k8s.io/apimachinery/pkg/labels"
	listers "k8s.io/client-go/listers"
	cache "k8s.io/client-go/tools/cache"
	apisv1alpha2 "sigs.k8s.io/gateway-api/apis/v1alpha2"
)

// TCPRouteLister helps list TCPRoutes.
// All objects returned here must be treated as read-only.
type TCPRouteLister interface {
	// List lists all TCPRoutes in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*apisv1alpha2.TCPRoute, err error)
	// TCPRoutes returns an object that can list and get TCPRoutes.
	TCPRoutes(namespace string) TCPRouteNamespaceLister
	TCPRouteListerExpansion
}

// tCPRouteLister implements the TCPRouteLister interface.
type tCPRouteLister struct {
	listers.ResourceIndexer[*apisv1alpha2.TCPRoute]
}

// NewTCPRouteLister returns a new TCPRouteLister.
func NewTCPRouteLister(indexer cache.Indexer) TCPRouteLister {
	return &tCPRouteLister{listers.New[*apisv1alpha2.TCPRoute](indexer, apisv1alpha2.Resource("tcproute"))}
}

// TCPRoutes returns an object that can list and get TCPRoutes.
func (s *tCPRouteLister) TCPRoutes(namespace string) TCPRouteNamespaceLister {
	return tCPRouteNamespaceLister{listers.NewNamespaced[*apisv1alpha2.TCPRoute](s.ResourceIndexer, namespace)}
}

// TCPRouteNamespaceLister helps list and get TCPRoutes.
// All objects returned here must be treated as read-only.
type TCPRouteNamespaceLister interface {
	// List lists all TCPRoutes in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*apisv1alpha2.TCPRoute, err error)
	// Get retrieves the TCPRoute from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*apisv1alpha2.TCPRoute, error)
	TCPRouteNamespaceListerExpansion
}

// tCPRouteNamespaceLister implements the TCPRouteNamespaceLister
// interface.
type tCPRouteNamespaceLister struct {
	listers.ResourceIndexer[*apisv1alpha2.TCPRoute]
}
