// python wrapper for ttkExtract
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "ttkExtract.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_ttkExtract(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyttkExtract_ClassNew(); }

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyttkExtract_EXTRACTION_MODE_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "ttkExtract.ttkExtract.EXTRACTION_MODE", // tp_name
  sizeof(PyLongObject), // tp_basicsize
  0, // tp_itemsize
  nullptr, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  nullptr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  nullptr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT
#if PY_VERSION_HEX >= 0x030A0000
    | Py_TPFLAGS_DISALLOW_INSTANTIATION
#endif
  , // tp_flags
  nullptr, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  &PyLong_Type, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  nullptr, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

template<class T>
static PyObject *PyttkExtract_EXTRACTION_MODE_FromEnum(T val)
{
  return PyVTKEnum_New(&PyttkExtract_EXTRACTION_MODE_Type, static_cast<int>(val));
}

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyttkExtract_VALIDATION_MODE_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "ttkExtract.ttkExtract.VALIDATION_MODE", // tp_name
  sizeof(PyLongObject), // tp_basicsize
  0, // tp_itemsize
  nullptr, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  nullptr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  nullptr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT
#if PY_VERSION_HEX >= 0x030A0000
    | Py_TPFLAGS_DISALLOW_INSTANTIATION
#endif
  , // tp_flags
  nullptr, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  &PyLong_Type, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  nullptr, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

template<class T>
static PyObject *PyttkExtract_VALIDATION_MODE_FromEnum(T val)
{
  return PyVTKEnum_New(&PyttkExtract_VALIDATION_MODE_Type, static_cast<int>(val));
}

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyttkExtract_CELL_MODE_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "ttkExtract.ttkExtract.CELL_MODE", // tp_name
  sizeof(PyLongObject), // tp_basicsize
  0, // tp_itemsize
  nullptr, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  nullptr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  nullptr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT
#if PY_VERSION_HEX >= 0x030A0000
    | Py_TPFLAGS_DISALLOW_INSTANTIATION
#endif
  , // tp_flags
  nullptr, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  &PyLong_Type, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  nullptr, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

template<class T>
static PyObject *PyttkExtract_CELL_MODE_FromEnum(T val)
{
  return PyVTKEnum_New(&PyttkExtract_CELL_MODE_Type, static_cast<int>(val));
}


static PyObject *
PyttkExtract_SetExtractionMode_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetExtractionMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkExtract *op = static_cast<ttkExtract *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetExtractionMode(temp0);
    }
    else
    {
      op->ttkExtract::SetExtractionMode(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyttkExtract_SetExtractionMode_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetExtractionMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkExtract *op = static_cast<ttkExtract *>(vp);

  typedef ttkExtract::EXTRACTION_MODE temp0_type;
  temp0_type temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetEnumValue(temp0, "ttkExtract.EXTRACTION_MODE"))
  {
    if (ap.IsBound())
    {
      op->SetExtractionMode(temp0);
    }
    else
    {
      op->ttkExtract::SetExtractionMode(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyttkExtract_SetExtractionMode_Methods[] = {
  {"SetExtractionMode", PyttkExtract_SetExtractionMode_s1, METH_VARARGS,
   "@i"},
  {"SetExtractionMode", PyttkExtract_SetExtractionMode_s2, METH_VARARGS,
   "@E ttkExtract.EXTRACTION_MODE"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyttkExtract_SetExtractionMode(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyttkExtract_SetExtractionMode_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetExtractionMode");
  return nullptr;
}


static PyObject *
PyttkExtract_GetExtractionMode(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetExtractionMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkExtract *op = static_cast<ttkExtract *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    typedef ttkExtract::EXTRACTION_MODE tempr_type;
  tempr_type tempr = (ap.IsBound() ?
      op->GetExtractionMode() :
      op->ttkExtract::GetExtractionMode());

    if (!ap.ErrorOccurred())
    {
      result = PyttkExtract_EXTRACTION_MODE_FromEnum(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkExtract_SetValidationMode_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetValidationMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkExtract *op = static_cast<ttkExtract *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetValidationMode(temp0);
    }
    else
    {
      op->ttkExtract::SetValidationMode(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyttkExtract_SetValidationMode_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetValidationMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkExtract *op = static_cast<ttkExtract *>(vp);

  typedef ttkExtract::VALIDATION_MODE temp0_type;
  temp0_type temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetEnumValue(temp0, "ttkExtract.VALIDATION_MODE"))
  {
    if (ap.IsBound())
    {
      op->SetValidationMode(temp0);
    }
    else
    {
      op->ttkExtract::SetValidationMode(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyttkExtract_SetValidationMode_Methods[] = {
  {"SetValidationMode", PyttkExtract_SetValidationMode_s1, METH_VARARGS,
   "@i"},
  {"SetValidationMode", PyttkExtract_SetValidationMode_s2, METH_VARARGS,
   "@E ttkExtract.VALIDATION_MODE"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyttkExtract_SetValidationMode(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyttkExtract_SetValidationMode_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetValidationMode");
  return nullptr;
}


static PyObject *
PyttkExtract_GetValidationMode(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetValidationMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkExtract *op = static_cast<ttkExtract *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    typedef ttkExtract::VALIDATION_MODE tempr_type;
  tempr_type tempr = (ap.IsBound() ?
      op->GetValidationMode() :
      op->ttkExtract::GetValidationMode());

    if (!ap.ErrorOccurred())
    {
      result = PyttkExtract_VALIDATION_MODE_FromEnum(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkExtract_SetCellMode_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCellMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkExtract *op = static_cast<ttkExtract *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetCellMode(temp0);
    }
    else
    {
      op->ttkExtract::SetCellMode(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyttkExtract_SetCellMode_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCellMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkExtract *op = static_cast<ttkExtract *>(vp);

  typedef ttkExtract::CELL_MODE temp0_type;
  temp0_type temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetEnumValue(temp0, "ttkExtract.CELL_MODE"))
  {
    if (ap.IsBound())
    {
      op->SetCellMode(temp0);
    }
    else
    {
      op->ttkExtract::SetCellMode(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyttkExtract_SetCellMode_Methods[] = {
  {"SetCellMode", PyttkExtract_SetCellMode_s1, METH_VARARGS,
   "@i"},
  {"SetCellMode", PyttkExtract_SetCellMode_s2, METH_VARARGS,
   "@E ttkExtract.CELL_MODE"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyttkExtract_SetCellMode(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyttkExtract_SetCellMode_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetCellMode");
  return nullptr;
}


static PyObject *
PyttkExtract_GetCellMode(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCellMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkExtract *op = static_cast<ttkExtract *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    typedef ttkExtract::CELL_MODE tempr_type;
  tempr_type tempr = (ap.IsBound() ?
      op->GetCellMode() :
      op->ttkExtract::GetCellMode());

    if (!ap.ErrorOccurred())
    {
      result = PyttkExtract_CELL_MODE_FromEnum(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkExtract_SetMaskOnly(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMaskOnly");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkExtract *op = static_cast<ttkExtract *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMaskOnly(temp0);
    }
    else
    {
      op->ttkExtract::SetMaskOnly(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkExtract_GetMaskOnly(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMaskOnly");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkExtract *op = static_cast<ttkExtract *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetMaskOnly() :
      op->ttkExtract::GetMaskOnly());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkExtract_SetOutputType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOutputType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkExtract *op = static_cast<ttkExtract *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetOutputType(temp0);
    }
    else
    {
      op->ttkExtract::SetOutputType(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkExtract_GetOutputType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetOutputType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkExtract *op = static_cast<ttkExtract *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetOutputType() :
      op->ttkExtract::GetOutputType());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkExtract_SetExpressionString(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetExpressionString");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkExtract *op = static_cast<ttkExtract *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetExpressionString(temp0);
    }
    else
    {
      op->ttkExtract::SetExpressionString(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkExtract_GetExpressionString(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetExpressionString");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkExtract *op = static_cast<ttkExtract *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetExpressionString() :
      op->ttkExtract::GetExpressionString());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkExtract_SetExtractUniqueValues(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetExtractUniqueValues");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkExtract *op = static_cast<ttkExtract *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetExtractUniqueValues(temp0);
    }
    else
    {
      op->ttkExtract::SetExtractUniqueValues(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkExtract_GetExtractUniqueValues(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetExtractUniqueValues");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkExtract *op = static_cast<ttkExtract *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetExtractUniqueValues() :
      op->ttkExtract::GetExtractUniqueValues());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkExtract_SetArrayAttributeType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetArrayAttributeType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkExtract *op = static_cast<ttkExtract *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetArrayAttributeType(temp0);
    }
    else
    {
      op->ttkExtract::SetArrayAttributeType(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkExtract_GetArrayAttributeType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetArrayAttributeType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkExtract *op = static_cast<ttkExtract *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetArrayAttributeType() :
      op->ttkExtract::GetArrayAttributeType());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkExtract_SetOutputArrayName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOutputArrayName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkExtract *op = static_cast<ttkExtract *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetOutputArrayName(temp0);
    }
    else
    {
      op->ttkExtract::SetOutputArrayName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkExtract_GetOutputArrayName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetOutputArrayName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkExtract *op = static_cast<ttkExtract *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetOutputArrayName() :
      op->ttkExtract::GetOutputArrayName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkExtract_SetImageExtent_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetImageExtent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkExtract *op = static_cast<ttkExtract *>(vp);

  int temp0;
  int temp1;
  int temp2;
  int temp3;
  int temp4;
  int temp5;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(6) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3) &&
      ap.GetValue(temp4) &&
      ap.GetValue(temp5))
  {
    if (ap.IsBound())
    {
      op->SetImageExtent(temp0, temp1, temp2, temp3, temp4, temp5);
    }
    else
    {
      op->ttkExtract::SetImageExtent(temp0, temp1, temp2, temp3, temp4, temp5);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyttkExtract_SetImageExtent_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetImageExtent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkExtract *op = static_cast<ttkExtract *>(vp);

  const size_t size0 = 6;
  int temp0[6];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetImageExtent(temp0);
    }
    else
    {
      op->ttkExtract::SetImageExtent(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyttkExtract_SetImageExtent(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 6:
      return PyttkExtract_SetImageExtent_s1(self, args);
    case 1:
      return PyttkExtract_SetImageExtent_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetImageExtent");
  return nullptr;
}


static PyObject *
PyttkExtract_GetImageExtent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetImageExtent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkExtract *op = static_cast<ttkExtract *>(vp);

  size_t sizer = 6;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int *tempr = (ap.IsBound() ?
      op->GetImageExtent() :
      op->ttkExtract::GetImageExtent());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyttkExtract_GetVtkDataTypeName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetVtkDataTypeName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkExtract *op = static_cast<ttkExtract *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetVtkDataTypeName(temp0) :
      op->ttkExtract::GetVtkDataTypeName(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkExtract_ExtractBlocks(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ExtractBlocks");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkExtract *op = static_cast<ttkExtract *>(vp);

  vtkDataObject *temp0 = nullptr;
  vtkDataObject *temp1 = nullptr;
  std::vector<double> temp2(ap.GetArgSize(2));
  bool temp3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetVTKObject(temp0, "vtkDataObject") &&
      ap.GetVTKObject(temp1, "vtkDataObject") &&
      ap.GetArray(temp2.data(), temp2.size()) &&
      ap.GetValue(temp3))
  {
    int tempr = (ap.IsBound() ?
      op->ExtractBlocks(temp0, temp1, temp2, temp3) :
      op->ttkExtract::ExtractBlocks(temp0, temp1, temp2, temp3));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkExtract_ExtractRows(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ExtractRows");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkExtract *op = static_cast<ttkExtract *>(vp);

  vtkDataObject *temp0 = nullptr;
  vtkDataObject *temp1 = nullptr;
  std::vector<double> temp2(ap.GetArgSize(2));
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkDataObject") &&
      ap.GetVTKObject(temp1, "vtkDataObject") &&
      ap.GetArray(temp2.data(), temp2.size()))
  {
    int tempr = (ap.IsBound() ?
      op->ExtractRows(temp0, temp1, temp2) :
      op->ttkExtract::ExtractRows(temp0, temp1, temp2));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkExtract_AddMaskArray(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddMaskArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkExtract *op = static_cast<ttkExtract *>(vp);

  vtkDataObject *temp0 = nullptr;
  vtkDataObject *temp1 = nullptr;
  std::vector<double> temp2(ap.GetArgSize(2));
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkDataObject") &&
      ap.GetVTKObject(temp1, "vtkDataObject") &&
      ap.GetArray(temp2.data(), temp2.size()))
  {
    int tempr = (ap.IsBound() ?
      op->AddMaskArray(temp0, temp1, temp2) :
      op->ttkExtract::AddMaskArray(temp0, temp1, temp2));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkExtract_ExtractGeometry(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ExtractGeometry");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkExtract *op = static_cast<ttkExtract *>(vp);

  vtkDataObject *temp0 = nullptr;
  vtkDataObject *temp1 = nullptr;
  std::vector<double> temp2(ap.GetArgSize(2));
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkDataObject") &&
      ap.GetVTKObject(temp1, "vtkDataObject") &&
      ap.GetArray(temp2.data(), temp2.size()))
  {
    int tempr = (ap.IsBound() ?
      op->ExtractGeometry(temp0, temp1, temp2) :
      op->ttkExtract::ExtractGeometry(temp0, temp1, temp2));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkExtract_ExtractArrayValues(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ExtractArrayValues");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkExtract *op = static_cast<ttkExtract *>(vp);

  vtkDataObject *temp0 = nullptr;
  vtkDataObject *temp1 = nullptr;
  std::vector<double> temp2(ap.GetArgSize(2));
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkDataObject") &&
      ap.GetVTKObject(temp1, "vtkDataObject") &&
      ap.GetArray(temp2.data(), temp2.size()))
  {
    int tempr = (ap.IsBound() ?
      op->ExtractArrayValues(temp0, temp1, temp2) :
      op->ttkExtract::ExtractArrayValues(temp0, temp1, temp2));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkExtract_ExtractArray(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ExtractArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkExtract *op = static_cast<ttkExtract *>(vp);

  vtkDataObject *temp0 = nullptr;
  vtkDataObject *temp1 = nullptr;
  std::vector<double> temp2(ap.GetArgSize(2));
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkDataObject") &&
      ap.GetVTKObject(temp1, "vtkDataObject") &&
      ap.GetArray(temp2.data(), temp2.size()))
  {
    int tempr = (ap.IsBound() ?
      op->ExtractArray(temp0, temp1, temp2) :
      op->ttkExtract::ExtractArray(temp0, temp1, temp2));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkExtract_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = ttkExtract::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkExtract_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkExtract *op = static_cast<ttkExtract *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->ttkExtract::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkExtract_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    ttkExtract *tempr = ttkExtract::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkExtract_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkExtract *op = static_cast<ttkExtract *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    ttkExtract *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->ttkExtract::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkExtract_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = ttkExtract::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkExtract_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkExtract *op = static_cast<ttkExtract *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->ttkExtract::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyttkExtract_Methods[] = {
  {"SetExtractionMode", PyttkExtract_SetExtractionMode, METH_VARARGS,
   "SetExtractionMode(self, _arg:int) -> None\nC++: virtual void SetExtractionMode(int _arg)\nSetExtractionMode(self, _arg:EXTRACTION_MODE) -> None\nC++: virtual void SetExtractionMode(EXTRACTION_MODE _arg)\n\n"},
  {"GetExtractionMode", PyttkExtract_GetExtractionMode, METH_VARARGS,
   "GetExtractionMode(self) -> EXTRACTION_MODE\nC++: virtual EXTRACTION_MODE GetExtractionMode()\n\n"},
  {"SetValidationMode", PyttkExtract_SetValidationMode, METH_VARARGS,
   "SetValidationMode(self, _arg:int) -> None\nC++: virtual void SetValidationMode(int _arg)\nSetValidationMode(self, _arg:VALIDATION_MODE) -> None\nC++: virtual void SetValidationMode(VALIDATION_MODE _arg)\n\n"},
  {"GetValidationMode", PyttkExtract_GetValidationMode, METH_VARARGS,
   "GetValidationMode(self) -> VALIDATION_MODE\nC++: virtual VALIDATION_MODE GetValidationMode()\n\n"},
  {"SetCellMode", PyttkExtract_SetCellMode, METH_VARARGS,
   "SetCellMode(self, _arg:int) -> None\nC++: virtual void SetCellMode(int _arg)\nSetCellMode(self, _arg:CELL_MODE) -> None\nC++: virtual void SetCellMode(CELL_MODE _arg)\n\n"},
  {"GetCellMode", PyttkExtract_GetCellMode, METH_VARARGS,
   "GetCellMode(self) -> CELL_MODE\nC++: virtual CELL_MODE GetCellMode()\n\n"},
  {"SetMaskOnly", PyttkExtract_SetMaskOnly, METH_VARARGS,
   "SetMaskOnly(self, _arg:bool) -> None\nC++: virtual void SetMaskOnly(bool _arg)\n\n"},
  {"GetMaskOnly", PyttkExtract_GetMaskOnly, METH_VARARGS,
   "GetMaskOnly(self) -> bool\nC++: virtual bool GetMaskOnly()\n\n"},
  {"SetOutputType", PyttkExtract_SetOutputType, METH_VARARGS,
   "SetOutputType(self, _arg:int) -> None\nC++: virtual void SetOutputType(int _arg)\n\n"},
  {"GetOutputType", PyttkExtract_GetOutputType, METH_VARARGS,
   "GetOutputType(self) -> int\nC++: virtual int GetOutputType()\n\n"},
  {"SetExpressionString", PyttkExtract_SetExpressionString, METH_VARARGS,
   "SetExpressionString(self, _arg:str) -> None\nC++: virtual void SetExpressionString(const std::string &_arg)\n\n"},
  {"GetExpressionString", PyttkExtract_GetExpressionString, METH_VARARGS,
   "GetExpressionString(self) -> str\nC++: virtual std::string GetExpressionString()\n\n"},
  {"SetExtractUniqueValues", PyttkExtract_SetExtractUniqueValues, METH_VARARGS,
   "SetExtractUniqueValues(self, _arg:bool) -> None\nC++: virtual void SetExtractUniqueValues(bool _arg)\n\n"},
  {"GetExtractUniqueValues", PyttkExtract_GetExtractUniqueValues, METH_VARARGS,
   "GetExtractUniqueValues(self) -> bool\nC++: virtual bool GetExtractUniqueValues()\n\n"},
  {"SetArrayAttributeType", PyttkExtract_SetArrayAttributeType, METH_VARARGS,
   "SetArrayAttributeType(self, _arg:int) -> None\nC++: virtual void SetArrayAttributeType(int _arg)\n\n"},
  {"GetArrayAttributeType", PyttkExtract_GetArrayAttributeType, METH_VARARGS,
   "GetArrayAttributeType(self) -> int\nC++: virtual int GetArrayAttributeType()\n\n"},
  {"SetOutputArrayName", PyttkExtract_SetOutputArrayName, METH_VARARGS,
   "SetOutputArrayName(self, _arg:str) -> None\nC++: virtual void SetOutputArrayName(const std::string &_arg)\n\n"},
  {"GetOutputArrayName", PyttkExtract_GetOutputArrayName, METH_VARARGS,
   "GetOutputArrayName(self) -> str\nC++: virtual std::string GetOutputArrayName()\n\n"},
  {"SetImageExtent", PyttkExtract_SetImageExtent, METH_VARARGS,
   "SetImageExtent(self, _arg1:int, _arg2:int, _arg3:int, _arg4:int,\n    _arg5:int, _arg6:int) -> None\nC++: virtual void SetImageExtent(int _arg1, int _arg2, int _arg3,\n    int _arg4, int _arg5, int _arg6)\nSetImageExtent(self, _arg:(int, int, int, int, int, int)) -> None\nC++: virtual void SetImageExtent(const int _arg[6])\n\n"},
  {"GetImageExtent", PyttkExtract_GetImageExtent, METH_VARARGS,
   "GetImageExtent(self) -> (int, int, int, int, int, int)\nC++: virtual int *GetImageExtent()\n\n"},
  {"GetVtkDataTypeName", PyttkExtract_GetVtkDataTypeName, METH_VARARGS,
   "GetVtkDataTypeName(self, outputType:int) -> str\nC++: std::string GetVtkDataTypeName(const int outputType)\n\n"},
  {"ExtractBlocks", PyttkExtract_ExtractBlocks, METH_VARARGS,
   "ExtractBlocks(self, output:vtkDataObject, input:vtkDataObject,\n    indices:(float, ...), extractTuples:bool) -> int\nC++: int ExtractBlocks(vtkDataObject *output,\n    vtkDataObject *input, const std::vector<double> &indices,\n    const bool &extractTuples)\n\n"},
  {"ExtractRows", PyttkExtract_ExtractRows, METH_VARARGS,
   "ExtractRows(self, output:vtkDataObject, input:vtkDataObject,\n    indices:(float, ...)) -> int\nC++: int ExtractRows(vtkDataObject *output, vtkDataObject *input,\n    const std::vector<double> &indices)\n\n"},
  {"AddMaskArray", PyttkExtract_AddMaskArray, METH_VARARGS,
   "AddMaskArray(self, output:vtkDataObject, input:vtkDataObject,\n    labels:(float, ...)) -> int\nC++: int AddMaskArray(vtkDataObject *output, vtkDataObject *input,\n     const std::vector<double> &labels)\n\n"},
  {"ExtractGeometry", PyttkExtract_ExtractGeometry, METH_VARARGS,
   "ExtractGeometry(self, output:vtkDataObject, input:vtkDataObject,\n    labels:(float, ...)) -> int\nC++: int ExtractGeometry(vtkDataObject *output,\n    vtkDataObject *input, const std::vector<double> &labels)\n\n"},
  {"ExtractArrayValues", PyttkExtract_ExtractArrayValues, METH_VARARGS,
   "ExtractArrayValues(self, output:vtkDataObject,\n    input:vtkDataObject, indices:(float, ...)) -> int\nC++: int ExtractArrayValues(vtkDataObject *output,\n    vtkDataObject *input, const std::vector<double> &indices)\n\n"},
  {"ExtractArray", PyttkExtract_ExtractArray, METH_VARARGS,
   "ExtractArray(self, output:vtkDataObject, input:vtkDataObject,\n    indices:(float, ...)) -> int\nC++: int ExtractArray(vtkDataObject *output, vtkDataObject *input,\n     const std::vector<double> &indices)\n\n"},
  {"IsTypeOf", PyttkExtract_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyttkExtract_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyttkExtract_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> ttkExtract\nC++: static ttkExtract *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyttkExtract_NewInstance, METH_VARARGS,
   "NewInstance(self) -> ttkExtract\nC++: ttkExtract *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyttkExtract_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyttkExtract_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyttkExtract_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("extraction_mode"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkExtract_SetExtractionMode(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkExtract_SetExtractionMode(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetExtractionMode\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("extraction_mode"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkExtract_GetExtractionMode(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkExtract_SetExtractionMode(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkExtract_SetExtractionMode(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetExtractionMode/SetExtractionMode\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("validation_mode"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkExtract_SetValidationMode(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkExtract_SetValidationMode(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetValidationMode\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("validation_mode"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkExtract_GetValidationMode(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkExtract_SetValidationMode(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkExtract_SetValidationMode(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetValidationMode/SetValidationMode\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("cell_mode"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkExtract_SetCellMode(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkExtract_SetCellMode(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetCellMode\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("cell_mode"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkExtract_GetCellMode(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkExtract_SetCellMode(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkExtract_SetCellMode(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetCellMode/SetCellMode\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("mask_only"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkExtract_GetMaskOnly(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkExtract_SetMaskOnly(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkExtract_SetMaskOnly(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetMaskOnly/SetMaskOnly\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("output_type"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkExtract_GetOutputType(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkExtract_SetOutputType(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkExtract_SetOutputType(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetOutputType/SetOutputType\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("expression_string"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkExtract_GetExpressionString(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkExtract_SetExpressionString(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkExtract_SetExpressionString(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetExpressionString/SetExpressionString\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("extract_unique_values"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkExtract_GetExtractUniqueValues(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkExtract_SetExtractUniqueValues(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkExtract_SetExtractUniqueValues(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetExtractUniqueValues/SetExtractUniqueValues\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("array_attribute_type"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkExtract_GetArrayAttributeType(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkExtract_SetArrayAttributeType(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkExtract_SetArrayAttributeType(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetArrayAttributeType/SetArrayAttributeType\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("output_array_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkExtract_GetOutputArrayName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkExtract_SetOutputArrayName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkExtract_SetOutputArrayName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetOutputArrayName/SetOutputArrayName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("image_extent"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkExtract_GetImageExtent(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkExtract_SetImageExtent(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkExtract_SetImageExtent(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetImageExtent/SetImageExtent\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyttkExtract_Doc =
  "ttkExtract - \\ingroup vtk\n\n"
  "Superclass: ttkAlgorithm\n\n"
  "\\author Jonas Lukasczyk <jl@jluk.de>\\date 1.10.2018\n\n"
  "TTK VTK-filter that provides multiple methods to extract subsets of\n"
  "an input data object based on a logical expression.\n\n"
  "This filter provides multiple methods to extract subsets of an input\n"
  "data object based on a logical expression:\n\n"
  "1. Blocks: The filter extracts all blocks of a vtkMultiBlockDataSet\n"
  "   based on a list of block indices. It is also possible to extract a\n"
  "single block of a vtkMultiBlockDataSet and explicitly specify its\n"
  "   type, which is then returned instead of a vtkMultiBlockDataSet\n"
  "   containing a single block. This is especially useful to extract\n"
  "   vtkImageData objects.\n\n"
  "2. Block Tuples: Many pipelines produce vtkMultiBlockDataSets that\n"
  "   contain vtkMultiBlockDataSets that represent lists. For example, a\n"
  "parent vtkMultiBlockDataSet might contain lists of Merge Trees,\n"
  "   Persistence Diagrams, and Domain segmentations, where each entry\n"
  "   in a list represents a timestep/ensemble member. Extracting all\n"
  "   elements for a given list of timesteps/ensemble members is very\n"
  "   cumbersome with the original block extraction method. The block\n"
  "   tuples mode makes it possible to conveniently extract these tuples\n"
  "based on a list of timesteps/ensemble member indices.\n\n"
  "3. Rows: The filter extracts all rows of a vtkTable based on a list\n"
  "   of row indices.\n\n"
  "4. Geometry: The filter extracts the subset of the input geometry\n"
  "   whose point/cell data satisfies a logical expression. It is also\n"
  "   possible to pass on the input dataset and only add a mask array\n"
  "   that marks points/cells that satisfy the condition.\n\n"
  "5. Array Values: The filter extracts all array values of a\n"
  "   vtkAbstractArray based on a list of value indices. The extracted\n"
  "   values are stored in a new field data array.\n\n"
  "6. Arrays: The filter extracts all point/cell data arrays based on a\n"
  "   given list of indices (not names).\n\n"
  "Online examples:\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/contourTreeAlignment/\"\n"
  "  > Contour Tree Alignment example\\n\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyttkExtract_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "ttkExtract.ttkExtract", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyttkExtract_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyttkExtract_StaticNew()
{
  return ttkExtract::New();
}

PyObject *PyttkExtract_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyttkExtract_Type, PyttkExtract_Methods,
    "ttkExtract",
 &PyttkExtract_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("ttkAlgorithm");

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  PyType_Ready(&PyttkExtract_EXTRACTION_MODE_Type);
  // members of ttkExtract::EXTRACTION_MODE
  {
    PyObject *enumval;
    PyObject *enumdict = PyDict_New();
    PyttkExtract_EXTRACTION_MODE_Type.tp_dict = enumdict;

    typedef ttkExtract::EXTRACTION_MODE cxx_enum_type;
    static const struct {
      const char *name; cxx_enum_type value;
    } constants[7] = {
      { "AUTO", cxx_enum_type::AUTO },
      { "BLOCKS", cxx_enum_type::BLOCKS },
      { "ROWS", cxx_enum_type::ROWS },
      { "GEOMETRY", cxx_enum_type::GEOMETRY },
      { "ARRAY_VALUES", cxx_enum_type::ARRAY_VALUES },
      { "ARRAYS", cxx_enum_type::ARRAYS },
      { "BLOCK_TUPLES", cxx_enum_type::BLOCK_TUPLES },
    };

    for (int c = 0; c < 7; c++)
    {
      enumval = PyttkExtract_EXTRACTION_MODE_FromEnum(constants[c].value);
      if (enumval)
      {
        PyDict_SetItemString(enumdict, constants[c].name, enumval);
        Py_DECREF(enumval);
      }
    }
  }

  PyVTKEnum_Add(&PyttkExtract_EXTRACTION_MODE_Type, "ttkExtract.EXTRACTION_MODE");

  o = (PyObject *)&PyttkExtract_EXTRACTION_MODE_Type;
  if (PyDict_SetItemString(d, "EXTRACTION_MODE", o) != 0)
  {
    Py_DECREF(o);
  }

  PyType_Ready(&PyttkExtract_VALIDATION_MODE_Type);
  // members of ttkExtract::VALIDATION_MODE
  {
    PyObject *enumval;
    PyObject *enumdict = PyDict_New();
    PyttkExtract_VALIDATION_MODE_Type.tp_dict = enumdict;

    typedef ttkExtract::VALIDATION_MODE cxx_enum_type;
    static const struct {
      const char *name; cxx_enum_type value;
    } constants[6] = {
      { "LESS_THEN", cxx_enum_type::LESS_THEN },
      { "LESS_EQUAL_THEN", cxx_enum_type::LESS_EQUAL_THEN },
      { "EQUAL", cxx_enum_type::EQUAL },
      { "UNEQUAL", cxx_enum_type::UNEQUAL },
      { "GREATER_EQUAL_THEN", cxx_enum_type::GREATER_EQUAL_THEN },
      { "GREATER_THEN", cxx_enum_type::GREATER_THEN },
    };

    for (int c = 0; c < 6; c++)
    {
      enumval = PyttkExtract_VALIDATION_MODE_FromEnum(constants[c].value);
      if (enumval)
      {
        PyDict_SetItemString(enumdict, constants[c].name, enumval);
        Py_DECREF(enumval);
      }
    }
  }

  PyVTKEnum_Add(&PyttkExtract_VALIDATION_MODE_Type, "ttkExtract.VALIDATION_MODE");

  o = (PyObject *)&PyttkExtract_VALIDATION_MODE_Type;
  if (PyDict_SetItemString(d, "VALIDATION_MODE", o) != 0)
  {
    Py_DECREF(o);
  }

  PyType_Ready(&PyttkExtract_CELL_MODE_Type);
  // members of ttkExtract::CELL_MODE
  {
    PyObject *enumval;
    PyObject *enumdict = PyDict_New();
    PyttkExtract_CELL_MODE_Type.tp_dict = enumdict;

    typedef ttkExtract::CELL_MODE cxx_enum_type;
    static const struct {
      const char *name; cxx_enum_type value;
    } constants[2] = {
      { "ALL", cxx_enum_type::ALL },
      { "ANY", cxx_enum_type::ANY },
    };

    for (int c = 0; c < 2; c++)
    {
      enumval = PyttkExtract_CELL_MODE_FromEnum(constants[c].value);
      if (enumval)
      {
        PyDict_SetItemString(enumdict, constants[c].name, enumval);
        Py_DECREF(enumval);
      }
    }
  }

  PyVTKEnum_Add(&PyttkExtract_CELL_MODE_Type, "ttkExtract.CELL_MODE");

  o = (PyObject *)&PyttkExtract_CELL_MODE_Type;
  if (PyDict_SetItemString(d, "CELL_MODE", o) != 0)
  {
    Py_DECREF(o);
  }

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyttkExtract_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_ttkExtract(
  PyObject *dict)
{
  PyObject *o;
  o = PyttkExtract_ClassNew();

  if (o && PyDict_SetItemString(dict, "ttkExtract", o) != 0)
  {
    Py_DECREF(o);
  }

}

