const char memprof_humanize_lua[] =
"-- Simple human-readable renderer of LuaJIT's memprof profile.\n"
"--\n"
"-- Major portions taken verbatim or adapted from the LuaVela.\n"
"-- Copyright (C) 2015-2019 IPONWEB Ltd.\n"
"\n"
"local M = {}\n"
"\n"
"local function human_readable_bytes(bytes)\n"
"  local units = {\"B\", \"KiB\", \"MiB\", \"GiB\"}\n"
"  local magnitude = 1\n"
"\n"
"  while bytes >= 1024 and magnitude < #units do\n"
"    bytes = bytes / 1024\n"
"    magnitude = magnitude + 1\n"
"  end\n"
"  local is_int = math.floor(bytes) == bytes\n"
"  local fmt = is_int and \"%d%s\" or \"%.2f%s\"\n"
"\n"
"  return string.format(fmt, bytes, units[magnitude])\n"
"end\n"
"\n"
"local function format_bytes(bytes, config)\n"
"  if config.human_readable then\n"
"    return human_readable_bytes(bytes)\n"
"  else\n"
"    return string.format('%dB', bytes)\n"
"  end\n"
"end\n"
"\n"
"function M.render(events, config)\n"
"  local ids = {}\n"
"\n"
"  for id, _ in pairs(events) do\n"
"    table.insert(ids, id)\n"
"  end\n"
"\n"
"  table.sort(ids, function(id1, id2)\n"
"    return events[id1].num > events[id2].num\n"
"  end)\n"
"\n"
"  for i = 1, #ids do\n"
"    local event = events[ids[i]]\n"
"    print(string.format(\"%s: %d events\\t+%s\\t-%s\",\n"
"      event.loc,\n"
"      event.num,\n"
"      format_bytes(event.alloc, config),\n"
"      format_bytes(event.free, config)\n"
"    ))\n"
"\n"
"    local prim_loc = {}\n"
"    for _, heap_chunk in pairs(event.primary) do\n"
"      table.insert(prim_loc, heap_chunk.loc)\n"
"    end\n"
"    if #prim_loc ~= 0 then\n"
"      table.sort(prim_loc)\n"
"      print(\"\\tOverrides:\")\n"
"      for j = 1, #prim_loc do\n"
"        print(string.format(\"\\t\\t%s\", prim_loc[j]))\n"
"      end\n"
"      print(\"\")\n"
"    end\n"
"  end\n"
"end\n"
"\n"
"function M.profile_info(events, config)\n"
"  print(\"ALLOCATIONS\")\n"
"  M.render(events.alloc, config)\n"
"  print(\"\")\n"
"\n"
"  print(\"REALLOCATIONS\")\n"
"  M.render(events.realloc, config)\n"
"  print(\"\")\n"
"\n"
"  print(\"DEALLOCATIONS\")\n"
"  M.render(events.free, config)\n"
"  print(\"\")\n"
"end\n"
"\n"
"function M.leak_info(dheap, config)\n"
"  local leaks = {}\n"
"  for line, info in pairs(dheap) do\n"
"    -- Report \"INTERNAL\" events inconsistencies for profiling\n"
"    -- with enabled jit.\n"
"    if info.dbytes > 0 then\n"
"      table.insert(leaks, {line = line, dbytes = info.dbytes})\n"
"    end\n"
"  end\n"
"\n"
"  table.sort(leaks, function(l1, l2)\n"
"    return l1.dbytes > l2.dbytes\n"
"  end)\n"
"\n"
"  print(\"HEAP SUMMARY:\")\n"
"  for _, l in pairs(leaks) do\n"
"    print(string.format(\n"
"      \"%s holds %s: %d allocs, %d frees\",\n"
"      l.line,\n"
"      format_bytes(l.dbytes, config),\n"
"      dheap[l.line].nalloc,\n"
"      dheap[l.line].nfree\n"
"    ))\n"
"  end\n"
"  print(\"\")\n"
"end\n"
"\n"
"function M.aliases(symbols)\n"
"  if #symbols.alias == 0 then return end\n"
"  print(\"ALIASES:\")\n"
"  for _, source in ipairs(symbols.alias) do\n"
"    print(symbols.alias[source]..\":\")\n"
"    local lineno = 1\n"
"    for line in source:gmatch(\"([^\\n]+)\") do\n"
"      print(string.format(\"%d\\t| %s\", lineno, line))\n"
"      lineno = lineno + 1\n"
"    end\n"
"    print(\"\\n\")\n"
"  end\n"
"end\n"
"\n"
"return M\n"
""
;
