/* PrinterManager.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from PrinterManager.vala, do not modify */

/*-
 * Copyright 2015 - 2022 elementary, Inc. (https://elementary.io)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street - Fifth Floor,
 * Boston, MA 02110-1301, USA.
 *
 * Authored by: Corentin Noël <corentin@elementary.io>
 */

#include "io.elementary.settings.printers.h"
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "cups/cups.h"
#include <gio/gio.h>
#include "cups/ipp.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PRINTERS_PRINTER_MANAGER_0_PROPERTY,
	PRINTERS_PRINTER_MANAGER_NUM_PROPERTIES
};
static GParamSpec* printers_printer_manager_properties[PRINTERS_PRINTER_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _ippDelete0(var) ((var == NULL) ? NULL : (var = (ippDelete (var), NULL)))
typedef struct _PrintersPrinterManagerNewSubscriptionData PrintersPrinterManagerNewSubscriptionData;
enum  {
	PRINTERS_PRINTER_MANAGER_PRINTER_ADDED_SIGNAL,
	PRINTERS_PRINTER_MANAGER_NUM_SIGNALS
};
static guint printers_printer_manager_signals[PRINTERS_PRINTER_MANAGER_NUM_SIGNALS] = {0};

struct _PrintersPrinterManagerPrivate {
	gint subscription_id;
	GeeLinkedList* printers;
};

struct _PrintersPrinterManagerNewSubscriptionData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PrintersPrinterManager* self;
	ipp_t* request;
	ipp_t* _tmp0_;
	ipp_t* _tmp1_;
	ipp_t* _tmp2_;
	ipp_t* _tmp3_;
	ipp_t* _tmp4_;
	ipp_t* _tmp5_;
	ipp_t* _tmp6_;
	ipp_t* _tmp7_;
	const gchar* _tmp8_;
	ipp_t* _tmp9_;
	http_t* _tmp10_;
	gboolean _tmp11_;
	ipp_t* _tmp12_;
	ipp_t* _tmp13_;
	ipp_attribute_t* attr;
	ipp_t* _tmp14_;
	ipp_attribute_t* _tmp15_;
	ipp_attribute_t* _tmp16_;
	ipp_attribute_t* _tmp17_;
};

static gint PrintersPrinterManager_private_offset;
static gpointer printers_printer_manager_parent_class = NULL;
static PrintersPrinterManager* printers_printer_manager_printer_manager;
static PrintersPrinterManager* printers_printer_manager_printer_manager = NULL;

static PrintersPrinterManager* printers_printer_manager_new (void);
static PrintersPrinterManager* printers_printer_manager_construct (GType object_type);
static void printers_printer_manager_add_printer (PrintersPrinterManager* self,
                                           cups_dest_t* destination);
static void printers_printer_manager_printer_is_added (PrintersPrinterManager* self,
                                                const gchar* text,
                                                const gchar* printer_uri,
                                                const gchar* name,
                                                guint32 state,
                                                const gchar* state_reasons,
                                                gboolean is_accepting_jobs);
static void _printers_printer_manager_printer_is_added_cups_notifier_printer_added (CupsNotifier* _sender,
                                                                             const gchar* text,
                                                                             const gchar* printer_uri,
                                                                             const gchar* name,
                                                                             guint32 state,
                                                                             const gchar* state_reasons,
                                                                             gboolean is_accepting_jobs,
                                                                             gpointer self);
static void printers_printer_manager_printer_is_deleted (PrintersPrinterManager* self,
                                                  const gchar* text,
                                                  const gchar* printer_uri,
                                                  const gchar* name,
                                                  guint32 state,
                                                  const gchar* state_reasons,
                                                  gboolean is_accepting_jobs);
static void _printers_printer_manager_printer_is_deleted_cups_notifier_printer_deleted (CupsNotifier* _sender,
                                                                                 const gchar* text,
                                                                                 const gchar* printer_uri,
                                                                                 const gchar* name,
                                                                                 guint32 state,
                                                                                 const gchar* state_reasons,
                                                                                 gboolean is_accepting_jobs,
                                                                                 gpointer self);
static void printers_printer_manager_printer_state_has_changed (PrintersPrinterManager* self,
                                                         const gchar* text,
                                                         const gchar* printer_uri,
                                                         const gchar* name,
                                                         guint32 state,
                                                         const gchar* state_reasons,
                                                         gboolean is_accepting_jobs);
static void _printers_printer_manager_printer_state_has_changed_cups_notifier_printer_state_changed (CupsNotifier* _sender,
                                                                                              const gchar* text,
                                                                                              const gchar* printer_uri,
                                                                                              const gchar* name,
                                                                                              guint32 state,
                                                                                              const gchar* state_reasons,
                                                                                              gboolean is_accepting_jobs,
                                                                                              gpointer self);
static void printers_printer_manager_printer_is_modified (PrintersPrinterManager* self,
                                                   const gchar* text,
                                                   const gchar* printer_uri,
                                                   const gchar* name,
                                                   guint32 state,
                                                   const gchar* state_reasons,
                                                   gboolean is_accepting_jobs);
static void _printers_printer_manager_printer_is_modified_cups_notifier_printer_modified (CupsNotifier* _sender,
                                                                                   const gchar* text,
                                                                                   const gchar* printer_uri,
                                                                                   const gchar* name,
                                                                                   guint32 state,
                                                                                   const gchar* state_reasons,
                                                                                   gboolean is_accepting_jobs,
                                                                                   gpointer self);
static void printers_printer_manager_new_subscription (PrintersPrinterManager* self,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_);
static void printers_printer_manager_new_subscription_finish (PrintersPrinterManager* self,
                                                       GAsyncResult* _res_);
static gboolean __lambda44_ (PrintersPrinterManager* self);
static gboolean ___lambda44__gsource_func (gpointer self);
static void printers_printer_manager_new_subscription_data_free (gpointer _data);
static gboolean printers_printer_manager_new_subscription_co (PrintersPrinterManagerNewSubscriptionData* _data_);
static void printers_printer_manager_finalize (GObject * obj);
static GType printers_printer_manager_get_type_once (void);

static const gchar* PRINTERS_PRINTER_MANAGER_SUBSCRIPTION_EVENTS[9] = {"printer-added", "printer-deleted", "printer-stopped", "printer-shutdown", "printer-restarted", "printer-state-changed", "job-created", "job-completed", NULL};

static inline gpointer
printers_printer_manager_get_instance_private (PrintersPrinterManager* self)
{
	return G_STRUCT_MEMBER_P (self, PrintersPrinterManager_private_offset);
}

PrintersPrinterManager*
printers_printer_manager_get_default (void)
{
	PrintersPrinterManager* _tmp0_;
	PrintersPrinterManager* _tmp2_;
	PrintersPrinterManager* result;
	_tmp0_ = printers_printer_manager_printer_manager;
	if (_tmp0_ == NULL) {
		PrintersPrinterManager* _tmp1_;
		_tmp1_ = printers_printer_manager_new ();
		_g_object_unref0 (printers_printer_manager_printer_manager);
		printers_printer_manager_printer_manager = _tmp1_;
	}
	_tmp2_ = printers_printer_manager_printer_manager;
	result = _tmp2_;
	return result;
}

static cups_dest_t*
cups_get_destinations (gint* result_length1)
{
	cups_dest_t* temp = NULL;
	gint temp_length1 = 0;
	gint _temp_size_ = 0;
	gint len = 0;
	cups_dest_t* _tmp0_ = NULL;
	gint _tmp1_;
	cups_dest_t* _tmp2_;
	gint _tmp2__length1;
	cups_dest_t* result;
	_tmp1_ = cupsGetDests (&_tmp0_);
	temp = _tmp0_;
	temp_length1 = -1;
	_temp_size_ = temp_length1;
	len = _tmp1_;
	temp_length1 = len;
	_tmp2_ = temp;
	_tmp2__length1 = temp_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static void
_printers_printer_manager_printer_is_added_cups_notifier_printer_added (CupsNotifier* _sender,
                                                                        const gchar* text,
                                                                        const gchar* printer_uri,
                                                                        const gchar* name,
                                                                        guint32 state,
                                                                        const gchar* state_reasons,
                                                                        gboolean is_accepting_jobs,
                                                                        gpointer self)
{
	printers_printer_manager_printer_is_added ((PrintersPrinterManager*) self, text, printer_uri, name, state, state_reasons, is_accepting_jobs);
}

static void
_printers_printer_manager_printer_is_deleted_cups_notifier_printer_deleted (CupsNotifier* _sender,
                                                                            const gchar* text,
                                                                            const gchar* printer_uri,
                                                                            const gchar* name,
                                                                            guint32 state,
                                                                            const gchar* state_reasons,
                                                                            gboolean is_accepting_jobs,
                                                                            gpointer self)
{
	printers_printer_manager_printer_is_deleted ((PrintersPrinterManager*) self, text, printer_uri, name, state, state_reasons, is_accepting_jobs);
}

static void
_printers_printer_manager_printer_state_has_changed_cups_notifier_printer_state_changed (CupsNotifier* _sender,
                                                                                         const gchar* text,
                                                                                         const gchar* printer_uri,
                                                                                         const gchar* name,
                                                                                         guint32 state,
                                                                                         const gchar* state_reasons,
                                                                                         gboolean is_accepting_jobs,
                                                                                         gpointer self)
{
	printers_printer_manager_printer_state_has_changed ((PrintersPrinterManager*) self, text, printer_uri, name, state, state_reasons, is_accepting_jobs);
}

static void
_printers_printer_manager_printer_is_modified_cups_notifier_printer_modified (CupsNotifier* _sender,
                                                                              const gchar* text,
                                                                              const gchar* printer_uri,
                                                                              const gchar* name,
                                                                              guint32 state,
                                                                              const gchar* state_reasons,
                                                                              gboolean is_accepting_jobs,
                                                                              gpointer self)
{
	printers_printer_manager_printer_is_modified ((PrintersPrinterManager*) self, text, printer_uri, name, state, state_reasons, is_accepting_jobs);
}

static gboolean
__lambda44_ (PrintersPrinterManager* self)
{
	gboolean result;
	printers_printer_manager_new_subscription (self, NULL, NULL);
	result = G_SOURCE_CONTINUE;
	return result;
}

static gboolean
___lambda44__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda44_ ((PrintersPrinterManager*) self);
	return result;
}

static PrintersPrinterManager*
printers_printer_manager_construct (GType object_type)
{
	PrintersPrinterManager * self = NULL;
	GeeLinkedList* _tmp0_;
	cups_dest_t* dests = NULL;
	gint _tmp1_ = 0;
	cups_dest_t* _tmp2_;
	gint dests_length1;
	gint _dests_size_;
	cups_dest_t* _tmp3_;
	gint _tmp3__length1;
	CupsNotifier* notifier = NULL;
	CupsNotifier* _tmp5_;
	self = (PrintersPrinterManager*) g_object_new (object_type, NULL);
	_tmp0_ = gee_linked_list_new (PRINTERS_TYPE_PRINTER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->printers);
	self->priv->printers = _tmp0_;
	_tmp2_ = cups_get_destinations (&_tmp1_);
	dests = _tmp2_;
	dests_length1 = _tmp1_;
	_dests_size_ = dests_length1;
	_tmp3_ = dests;
	_tmp3__length1 = dests_length1;
	{
		cups_dest_t* dest_collection = NULL;
		gint dest_collection_length1 = 0;
		gint _dest_collection_size_ = 0;
		gint dest_it = 0;
		dest_collection = _tmp3_;
		dest_collection_length1 = _tmp3__length1;
		for (dest_it = 0; dest_it < dest_collection_length1; dest_it = dest_it + 1) {
			cups_dest_t dest = {0};
			dest = dest_collection[dest_it];
			{
				cups_dest_t _tmp4_;
				_tmp4_ = dest;
				printers_printer_manager_add_printer (self, &_tmp4_);
			}
		}
	}
	_tmp5_ = cups_notifier_get_default ();
	notifier = _tmp5_;
	g_signal_connect_object (notifier, "printer-added", (GCallback) _printers_printer_manager_printer_is_added_cups_notifier_printer_added, self, 0);
	g_signal_connect_object (notifier, "printer-deleted", (GCallback) _printers_printer_manager_printer_is_deleted_cups_notifier_printer_deleted, self, 0);
	g_signal_connect_object (notifier, "printer-state-changed", (GCallback) _printers_printer_manager_printer_state_has_changed_cups_notifier_printer_state_changed, self, 0);
	g_signal_connect_object (notifier, "printer-modified", (GCallback) _printers_printer_manager_printer_is_modified_cups_notifier_printer_modified, self, 0);
	printers_printer_manager_new_subscription (self, NULL, NULL);
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, PRINTERS_PRINTER_MANAGER_RENEW_INTERVAL, ___lambda44__gsource_func, g_object_ref (self), g_object_unref);
	return self;
}

static PrintersPrinterManager*
printers_printer_manager_new (void)
{
	return printers_printer_manager_construct (PRINTERS_TYPE_PRINTER_MANAGER);
}

GeeLinkedList*
printers_printer_manager_get_printers (PrintersPrinterManager* self)
{
	GeeLinkedList* _tmp0_;
	GeeLinkedList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->printers;
	result = _tmp0_;
	return result;
}

static void
printers_printer_manager_printer_is_added (PrintersPrinterManager* self,
                                           const gchar* text,
                                           const gchar* printer_uri,
                                           const gchar* name,
                                           guint32 state,
                                           const gchar* state_reasons,
                                           gboolean is_accepting_jobs)
{
	cups_dest_t* destinations = NULL;
	gint _tmp0_ = 0;
	cups_dest_t* _tmp1_;
	gint destinations_length1;
	gint _destinations_size_;
	cups_dest_t* _tmp2_;
	gint _tmp2__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	g_return_if_fail (printer_uri != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (state_reasons != NULL);
	_tmp1_ = cups_get_destinations (&_tmp0_);
	destinations = _tmp1_;
	destinations_length1 = _tmp0_;
	_destinations_size_ = destinations_length1;
	_tmp2_ = destinations;
	_tmp2__length1 = destinations_length1;
	{
		cups_dest_t* dest_collection = NULL;
		gint dest_collection_length1 = 0;
		gint _dest_collection_size_ = 0;
		gint dest_it = 0;
		dest_collection = _tmp2_;
		dest_collection_length1 = _tmp2__length1;
		for (dest_it = 0; dest_it < dest_collection_length1; dest_it = dest_it + 1) {
			cups_dest_t dest = {0};
			dest = dest_collection[dest_it];
			{
				cups_dest_t _tmp3_;
				const gchar* _tmp4_;
				_tmp3_ = dest;
				_tmp4_ = _tmp3_.name;
				if (g_strcmp0 (_tmp4_, name) == 0) {
					cups_dest_t _tmp5_;
					_tmp5_ = dest;
					printers_printer_manager_add_printer (self, &_tmp5_);
					break;
				}
			}
		}
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
printers_printer_manager_printer_is_modified (PrintersPrinterManager* self,
                                              const gchar* text,
                                              const gchar* printer_uri,
                                              const gchar* name,
                                              guint32 state,
                                              const gchar* state_reasons,
                                              gboolean is_accepting_jobs)
{
	PrintersPrinter* found_printer = NULL;
	PrintersPrinter* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	g_return_if_fail (printer_uri != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (state_reasons != NULL);
	found_printer = NULL;
	{
		GeeLinkedList* _printer_list = NULL;
		GeeLinkedList* _tmp0_;
		gint _printer_size = 0;
		GeeLinkedList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _printer_index = 0;
		_tmp0_ = self->priv->printers;
		_printer_list = _tmp0_;
		_tmp1_ = _printer_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_printer_size = _tmp3_;
		_printer_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			PrintersPrinter* printer = NULL;
			GeeLinkedList* _tmp6_;
			gpointer _tmp7_;
			PrintersPrinter* _tmp8_;
			cups_dest_t _tmp9_;
			const gchar* _tmp10_;
			_printer_index = _printer_index + 1;
			_tmp4_ = _printer_index;
			_tmp5_ = _printer_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _printer_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _printer_index);
			printer = (PrintersPrinter*) _tmp7_;
			_tmp8_ = printer;
			_tmp9_ = _tmp8_->dest;
			_tmp10_ = _tmp9_.name;
			if (g_strcmp0 (_tmp10_, name) == 0) {
				PrintersPrinter* _tmp11_;
				PrintersPrinter* _tmp12_;
				_tmp11_ = printer;
				_tmp12_ = _g_object_ref0 (_tmp11_);
				_g_object_unref0 (found_printer);
				found_printer = _tmp12_;
				_g_object_unref0 (printer);
				break;
			}
			_g_object_unref0 (printer);
		}
	}
	_tmp13_ = found_printer;
	if (_tmp13_ == NULL) {
		printers_printer_manager_printer_is_added (self, text, printer_uri, name, state, state_reasons, is_accepting_jobs);
	}
	_g_object_unref0 (found_printer);
}

static void
printers_printer_manager_printer_is_deleted (PrintersPrinterManager* self,
                                             const gchar* text,
                                             const gchar* printer_uri,
                                             const gchar* name,
                                             guint32 state,
                                             const gchar* state_reasons,
                                             gboolean is_accepting_jobs)
{
	PrintersPrinter* found_printer = NULL;
	PrintersPrinter* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	g_return_if_fail (printer_uri != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (state_reasons != NULL);
	found_printer = NULL;
	{
		GeeLinkedList* _printer_list = NULL;
		GeeLinkedList* _tmp0_;
		gint _printer_size = 0;
		GeeLinkedList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _printer_index = 0;
		_tmp0_ = self->priv->printers;
		_printer_list = _tmp0_;
		_tmp1_ = _printer_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_printer_size = _tmp3_;
		_printer_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			PrintersPrinter* printer = NULL;
			GeeLinkedList* _tmp6_;
			gpointer _tmp7_;
			PrintersPrinter* _tmp8_;
			cups_dest_t _tmp9_;
			const gchar* _tmp10_;
			_printer_index = _printer_index + 1;
			_tmp4_ = _printer_index;
			_tmp5_ = _printer_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _printer_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _printer_index);
			printer = (PrintersPrinter*) _tmp7_;
			_tmp8_ = printer;
			_tmp9_ = _tmp8_->dest;
			_tmp10_ = _tmp9_.name;
			if (g_strcmp0 (_tmp10_, name) == 0) {
				PrintersPrinter* _tmp11_;
				PrintersPrinter* _tmp12_;
				_tmp11_ = printer;
				_tmp12_ = _g_object_ref0 (_tmp11_);
				_g_object_unref0 (found_printer);
				found_printer = _tmp12_;
				_g_object_unref0 (printer);
				break;
			}
			_g_object_unref0 (printer);
		}
	}
	_tmp13_ = found_printer;
	if (_tmp13_ != NULL) {
		GeeLinkedList* _tmp14_;
		PrintersPrinter* _tmp15_;
		PrintersPrinter* _tmp16_;
		_tmp14_ = self->priv->printers;
		_tmp15_ = found_printer;
		gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp14_, _tmp15_);
		_tmp16_ = found_printer;
		g_signal_emit_by_name (_tmp16_, "deleted");
	}
	_g_object_unref0 (found_printer);
}

static void
printers_printer_manager_printer_state_has_changed (PrintersPrinterManager* self,
                                                    const gchar* text,
                                                    const gchar* printer_uri,
                                                    const gchar* name,
                                                    guint32 state,
                                                    const gchar* state_reasons,
                                                    gboolean is_accepting_jobs)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	g_return_if_fail (printer_uri != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (state_reasons != NULL);
	{
		GeeLinkedList* _printer_list = NULL;
		GeeLinkedList* _tmp0_;
		gint _printer_size = 0;
		GeeLinkedList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _printer_index = 0;
		_tmp0_ = self->priv->printers;
		_printer_list = _tmp0_;
		_tmp1_ = _printer_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_printer_size = _tmp3_;
		_printer_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			PrintersPrinter* printer = NULL;
			GeeLinkedList* _tmp6_;
			gpointer _tmp7_;
			PrintersPrinter* _tmp8_;
			cups_dest_t _tmp9_;
			const gchar* _tmp10_;
			_printer_index = _printer_index + 1;
			_tmp4_ = _printer_index;
			_tmp5_ = _printer_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _printer_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _printer_index);
			printer = (PrintersPrinter*) _tmp7_;
			_tmp8_ = printer;
			_tmp9_ = _tmp8_->dest;
			_tmp10_ = _tmp9_.name;
			if (g_strcmp0 (_tmp10_, name) == 0) {
				PrintersPrinter* _tmp11_;
				PrintersPrinter* _tmp12_;
				PrintersPrinter* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				PrintersPrinter* _tmp16_;
				PrintersPrinter* _tmp17_;
				_tmp11_ = printer;
				printers_printer_set_state_reasons_raw (_tmp11_, state_reasons);
				_tmp12_ = printer;
				printers_printer_set_is_accepting_jobs (_tmp12_, is_accepting_jobs);
				_tmp13_ = printer;
				_tmp14_ = g_strdup_printf ("%u", state);
				_tmp15_ = _tmp14_;
				printers_printer_set_state (_tmp13_, _tmp15_);
				_g_free0 (_tmp15_);
				_tmp16_ = printer;
				g_object_notify ((GObject*) _tmp16_, "state");
				_tmp17_ = printer;
				g_object_notify ((GObject*) _tmp17_, "state-reasons");
				_g_object_unref0 (printer);
				break;
			}
			_g_object_unref0 (printer);
		}
	}
}

static void
printers_printer_manager_add_printer (PrintersPrinterManager* self,
                                      cups_dest_t* destination)
{
	PrintersPrinter* printer = NULL;
	cups_dest_t _tmp0_;
	PrintersPrinter* _tmp1_;
	GeeLinkedList* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (destination != NULL);
	_tmp0_ = *destination;
	_tmp1_ = printers_printer_new (&_tmp0_);
	printer = _tmp1_;
	_tmp2_ = self->priv->printers;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp2_, printer);
	g_signal_emit (self, printers_printer_manager_signals[PRINTERS_PRINTER_MANAGER_PRINTER_ADDED_SIGNAL], 0, printer);
	_g_object_unref0 (printer);
}

static void
printers_printer_manager_new_subscription_data_free (gpointer _data)
{
	PrintersPrinterManagerNewSubscriptionData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (PrintersPrinterManagerNewSubscriptionData, _data_);
}

static void
printers_printer_manager_new_subscription (PrintersPrinterManager* self,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_)
{
	PrintersPrinterManagerNewSubscriptionData* _data_;
	PrintersPrinterManager* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (PrintersPrinterManagerNewSubscriptionData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, printers_printer_manager_new_subscription_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	printers_printer_manager_new_subscription_co (_data_);
}

static void
printers_printer_manager_new_subscription_finish (PrintersPrinterManager* self,
                                                  GAsyncResult* _res_)
{
	PrintersPrinterManagerNewSubscriptionData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static gboolean
printers_printer_manager_new_subscription_co (PrintersPrinterManagerNewSubscriptionData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->request = NULL;
	if (_data_->self->priv->subscription_id <= 0) {
		_data_->_tmp0_ = ippNewRequest (IPP_CREATE_PRINTER_SUBSCRIPTION);
		_ippDelete0 (_data_->request);
		_data_->request = _data_->_tmp0_;
		_data_->_tmp1_ = _data_->request;
		ippAddStrings (_data_->_tmp1_, IPP_TAG_SUBSCRIPTION, IPP_TAG_KEYWORD, "notify-events", (gint) G_N_ELEMENTS (PRINTERS_PRINTER_MANAGER_SUBSCRIPTION_EVENTS), NULL, PRINTERS_PRINTER_MANAGER_SUBSCRIPTION_EVENTS);
		_data_->_tmp2_ = _data_->request;
		ippAddString (_data_->_tmp2_, IPP_TAG_SUBSCRIPTION, IPP_TAG_KEYWORD, "notify-pull-method", NULL, "ippget");
		_data_->_tmp3_ = _data_->request;
		ippAddString (_data_->_tmp3_, IPP_TAG_SUBSCRIPTION, IPP_TAG_URI, "notify-recipient-uri", NULL, "dbus://");
	} else {
		_data_->_tmp4_ = ippNewRequest (IPP_RENEW_SUBSCRIPTION);
		_ippDelete0 (_data_->request);
		_data_->request = _data_->_tmp4_;
		_data_->_tmp5_ = _data_->request;
		ippAddInteger (_data_->_tmp5_, IPP_TAG_OPERATION, IPP_TAG_INTEGER, "notify-subscription-id", _data_->self->priv->subscription_id);
	}
	_data_->_tmp6_ = _data_->request;
	ippAddString (_data_->_tmp6_, IPP_TAG_OPERATION, IPP_TAG_URI, "printer-uri", NULL, "/");
	_data_->_tmp7_ = _data_->request;
	_data_->_tmp8_ = cupsUser ();
	ippAddString (_data_->_tmp7_, IPP_TAG_OPERATION, IPP_TAG_NAME, "requesting-user-name", NULL, _data_->_tmp8_);
	_data_->_tmp9_ = _data_->request;
	ippAddInteger (_data_->_tmp9_, IPP_TAG_SUBSCRIPTION, IPP_TAG_INTEGER, "notify-lease-duration", PRINTERS_PRINTER_MANAGER_SUBSCRIPTION_DURATION);
	_data_->_tmp10_ = CUPS_HTTP_DEFAULT;
	_data_->request = cupsDoRequest (_data_->_tmp10_, _data_->request, "/");
	_data_->_tmp12_ = _data_->request;
	if (_data_->_tmp12_ != NULL) {
		_data_->_tmp13_ = _data_->request;
		_data_->_tmp11_ = ippGetStatusCode (_data_->_tmp13_) <= IPP_OK_CONFLICT;
	} else {
		_data_->_tmp11_ = FALSE;
	}
	if (_data_->_tmp11_) {
		_data_->_tmp14_ = _data_->request;
		_data_->_tmp15_ = ippFindAttribute (_data_->_tmp14_, "notify-subscription-id", IPP_TAG_INTEGER);
		_data_->attr = _data_->_tmp15_;
		_data_->_tmp16_ = _data_->attr;
		if (_data_->_tmp16_ != NULL) {
			_data_->_tmp17_ = _data_->attr;
			_data_->self->priv->subscription_id = ippGetInteger (_data_->_tmp17_, 0);
		} else {
			g_critical ("PrinterManager.vala:155: No notify-subscription-id in response!");
		}
	}
	_ippDelete0 (_data_->request);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
printers_printer_manager_class_init (PrintersPrinterManagerClass * klass,
                                     gpointer klass_data)
{
	printers_printer_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PrintersPrinterManager_private_offset);
	G_OBJECT_CLASS (klass)->finalize = printers_printer_manager_finalize;
	printers_printer_manager_signals[PRINTERS_PRINTER_MANAGER_PRINTER_ADDED_SIGNAL] = g_signal_new ("printer-added", PRINTERS_TYPE_PRINTER_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, PRINTERS_TYPE_PRINTER);
}

static void
printers_printer_manager_instance_init (PrintersPrinterManager * self,
                                        gpointer klass)
{
	self->priv = printers_printer_manager_get_instance_private (self);
	self->priv->subscription_id = -1;
}

static void
printers_printer_manager_finalize (GObject * obj)
{
	PrintersPrinterManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PRINTERS_TYPE_PRINTER_MANAGER, PrintersPrinterManager);
	_g_object_unref0 (self->priv->printers);
	G_OBJECT_CLASS (printers_printer_manager_parent_class)->finalize (obj);
}

static GType
printers_printer_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PrintersPrinterManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) printers_printer_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PrintersPrinterManager), 0, (GInstanceInitFunc) printers_printer_manager_instance_init, NULL };
	GType printers_printer_manager_type_id;
	printers_printer_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "PrintersPrinterManager", &g_define_type_info, 0);
	PrintersPrinterManager_private_offset = g_type_add_instance_private (printers_printer_manager_type_id, sizeof (PrintersPrinterManagerPrivate));
	return printers_printer_manager_type_id;
}

GType
printers_printer_manager_get_type (void)
{
	static volatile gsize printers_printer_manager_type_id__once = 0;
	if (g_once_init_enter (&printers_printer_manager_type_id__once)) {
		GType printers_printer_manager_type_id;
		printers_printer_manager_type_id = printers_printer_manager_get_type_once ();
		g_once_init_leave (&printers_printer_manager_type_id__once, printers_printer_manager_type_id);
	}
	return printers_printer_manager_type_id__once;
}

