/* Layout.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Layout.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-2.0-or-later
 * SPDX-FileCopyrightText: 2017-2023 elementary, Inc. (https://elementary.io)
 */

#include "keyboard.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>

#define KEYBOARD_LAYOUT_PAGE_PAGE_MULTITASKING_VIEW_COMMAND "dbus-send --session --dest=org.pantheon.gala --print-reply /org/panthe" \
"on/gala org.pantheon.gala.PerformAction int32:1"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define KEYBOARD_TYPE_SOURCE_SETTINGS (keyboard_source_settings_get_type ())
#define KEYBOARD_SOURCE_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KEYBOARD_TYPE_SOURCE_SETTINGS, KeyboardSourceSettings))
#define KEYBOARD_SOURCE_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KEYBOARD_TYPE_SOURCE_SETTINGS, KeyboardSourceSettingsClass))
#define KEYBOARD_IS_SOURCE_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KEYBOARD_TYPE_SOURCE_SETTINGS))
#define KEYBOARD_IS_SOURCE_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KEYBOARD_TYPE_SOURCE_SETTINGS))
#define KEYBOARD_SOURCE_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KEYBOARD_TYPE_SOURCE_SETTINGS, KeyboardSourceSettingsClass))

typedef struct _KeyboardSourceSettings KeyboardSourceSettings;
typedef struct _KeyboardSourceSettingsClass KeyboardSourceSettingsClass;
enum  {
	KEYBOARD_LAYOUT_PAGE_PAGE_0_PROPERTY,
	KEYBOARD_LAYOUT_PAGE_PAGE_NUM_PROPERTIES
};
static GParamSpec* keyboard_layout_page_page_properties[KEYBOARD_LAYOUT_PAGE_PAGE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define KEYBOARD_TYPE_XKB_MODIFIER (keyboard_xkb_modifier_get_type ())
#define KEYBOARD_XKB_MODIFIER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KEYBOARD_TYPE_XKB_MODIFIER, KeyboardXkbModifier))
#define KEYBOARD_XKB_MODIFIER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KEYBOARD_TYPE_XKB_MODIFIER, KeyboardXkbModifierClass))
#define KEYBOARD_IS_XKB_MODIFIER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KEYBOARD_TYPE_XKB_MODIFIER))
#define KEYBOARD_IS_XKB_MODIFIER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KEYBOARD_TYPE_XKB_MODIFIER))
#define KEYBOARD_XKB_MODIFIER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KEYBOARD_TYPE_XKB_MODIFIER, KeyboardXkbModifierClass))

typedef struct _KeyboardXkbModifier KeyboardXkbModifier;
typedef struct _KeyboardXkbModifierClass KeyboardXkbModifierClass;
typedef struct _Block16Data Block16Data;
typedef struct _KeyboardXkbModifierPrivate KeyboardXkbModifierPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block17Data Block17Data;
typedef struct _Block18Data Block18Data;

struct _KeyboardLayoutPagePagePrivate {
	AdvancedSettingsPanel** panels;
	gint panels_length1;
	gint _panels_size_;
	KeyboardLayoutPageDisplay* display;
	GHashTable* panel_for_layout;
	KeyboardSourceSettings* settings;
	GtkSizeGroup** size_group;
	gint size_group_length1;
	gint _size_group_size_;
	GtkEntry* entry_test;
	GtkStack* stack;
};

struct _Block16Data {
	int _ref_count_;
	KeyboardLayoutPagePage* self;
	GtkComboBoxText* combo_box;
	KeyboardXkbModifier* modifier;
};

struct _KeyboardXkbModifier {
	GObject parent_instance;
	KeyboardXkbModifierPrivate * priv;
	gchar** option_descriptions;
	gint option_descriptions_length1;
	gint _option_descriptions_size_;
	gchar** xkb_option_commands;
	gint xkb_option_commands_length1;
	gint _xkb_option_commands_size_;
};

struct _KeyboardXkbModifierClass {
	GObjectClass parent_class;
};

struct _Block17Data {
	int _ref_count_;
	KeyboardLayoutPagePage* self;
	GtkSwitch* option_switch;
	KeyboardXkbModifier* modifier;
	gchar* xkb_command;
};

struct _Block18Data {
	int _ref_count_;
	KeyboardLayoutPagePage* self;
	GtkComboBoxText* overlay_key_combo;
	GSettings* gala_behavior_settings;
};

static gint KeyboardLayoutPagePage_private_offset;
static gpointer keyboard_layout_page_page_parent_class = NULL;

VALA_EXTERN GType keyboard_source_settings_get_type (void) G_GNUC_CONST ;
static AdvancedSettingsPanel* keyboard_layout_page_page_third_level_layouts_panel (KeyboardLayoutPagePage* self);
VALA_EXTERN GType keyboard_xkb_modifier_get_type (void) G_GNUC_CONST ;
VALA_EXTERN KeyboardXkbModifier* keyboard_source_settings_get_xkb_modifier_by_name (KeyboardSourceSettings* self,
                                                                        const gchar* name);
static GtkComboBoxText* keyboard_layout_page_page_create_xkb_combobox (KeyboardLayoutPagePage* self,
                                                                KeyboardXkbModifier* modifier);
static GtkLabel* keyboard_layout_page_page_create_settings_label (KeyboardLayoutPagePage* self,
                                                           const gchar* label,
                                                           GtkWidget* mnemonic_widget);
static AdvancedSettingsPanel* keyboard_layout_page_page_fifth_level_layouts_panel (KeyboardLayoutPagePage* self);
VALA_EXTERN KeyboardXkbModifier* keyboard_xkb_modifier_new (const gchar* name,
                                                const gchar* schem,
                                                const gchar* key);
VALA_EXTERN KeyboardXkbModifier* keyboard_xkb_modifier_construct (GType object_type,
                                                      const gchar* name,
                                                      const gchar* schem,
                                                      const gchar* key);
VALA_EXTERN void keyboard_xkb_modifier_append_xkb_option (KeyboardXkbModifier* self,
                                              const gchar* xkb_command,
                                              const gchar* description);
VALA_EXTERN void keyboard_xkb_modifier_set_default_command (KeyboardXkbModifier* self,
                                                const gchar* val);
VALA_EXTERN void keyboard_source_settings_add_xkb_modifier (KeyboardSourceSettings* self,
                                                KeyboardXkbModifier* modifier);
static AdvancedSettingsPanel* keyboard_layout_page_page_japanese_layouts_panel (KeyboardLayoutPagePage* self);
static GtkSwitch* keyboard_layout_page_page_create_xkb_option_switch (KeyboardLayoutPagePage* self,
                                                               KeyboardSourceSettings* settings,
                                                               const gchar* xkb_command);
static AdvancedSettingsPanel* keyboard_layout_page_page_korean_layouts_panel (KeyboardLayoutPagePage* self);
static void keyboard_layout_page_page_show_panel_for_active_layout (KeyboardLayoutPagePage* self);
VALA_EXTERN KeyboardInputSource* keyboard_source_settings_get_active_input_source (KeyboardSourceSettings* self);
static void keyboard_layout_page_page_set_visible_panel_from_layout (KeyboardLayoutPagePage* self,
                                                              const gchar* layout_name);
static Block16Data* block16_data_ref (Block16Data* _data16_);
static void block16_data_unref (void * _userdata_);
VALA_EXTERN gchar* keyboard_xkb_modifier_get_active_command (KeyboardXkbModifier* self);
static void __lambda51_ (Block16Data* _data16_);
VALA_EXTERN void keyboard_xkb_modifier_update_active_command (KeyboardXkbModifier* self,
                                                  const gchar* val);
static void ___lambda51__gtk_combo_box_changed (GtkComboBox* _sender,
                                         gpointer self);
static void __lambda52_ (Block16Data* _data16_);
static void ___lambda52__keyboard_xkb_modifier_active_command_updated (KeyboardXkbModifier* _sender,
                                                                gpointer self);
static Block17Data* block17_data_ref (Block17Data* _data17_);
static void block17_data_unref (void * _userdata_);
static void __lambda53_ (Block17Data* _data17_);
static void ___lambda53__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void keyboard_layout_page_page_update_entry_test_usable (KeyboardLayoutPagePage* self);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
static GObject * keyboard_layout_page_page_constructor (GType type,
                                                 guint n_construct_properties,
                                                 GObjectConstructParam * construct_properties);
static Block18Data* block18_data_ref (Block18Data* _data18_);
static void block18_data_unref (void * _userdata_);
VALA_EXTERN KeyboardSourceSettings* keyboard_source_settings_get_instance (void);
static void _g_free0_ (gpointer var);
static void _keyboard_layout_page_page___lambda54_ (KeyboardLayoutPagePage* self);
static void __keyboard_layout_page_page___lambda54__gtk_widget_map (GtkWidget* _sender,
                                                             gpointer self);
static void _keyboard_layout_page_page___lambda55_ (KeyboardLayoutPagePage* self);
static void __keyboard_layout_page_page___lambda55__g_object_notify (GObject* _sender,
                                                              GParamSpec* pspec,
                                                              gpointer self);
static void _keyboard_layout_page_page___lambda56_ (Block18Data* _data18_);
static void __keyboard_layout_page_page___lambda56__gtk_combo_box_changed (GtkComboBox* _sender,
                                                                    gpointer self);
static void keyboard_layout_page_page_finalize (GObject * obj);
static GType keyboard_layout_page_page_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
keyboard_layout_page_page_get_instance_private (KeyboardLayoutPagePage* self)
{
	return G_STRUCT_MEMBER_P (self, KeyboardLayoutPagePage_private_offset);
}

static AdvancedSettingsPanel*
keyboard_layout_page_page_third_level_layouts_panel (KeyboardLayoutPagePage* self)
{
	KeyboardXkbModifier* modifier = NULL;
	KeyboardSourceSettings* _tmp0_;
	KeyboardXkbModifier* _tmp1_;
	KeyboardXkbModifier* _tmp2_;
	gchar** invalid_input_sources = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	gchar* _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	gchar* _tmp53_;
	gchar* _tmp54_;
	gchar* _tmp55_;
	gchar* _tmp56_;
	gchar* _tmp57_;
	gchar* _tmp58_;
	gchar* _tmp59_;
	gchar* _tmp60_;
	gchar* _tmp61_;
	gchar* _tmp62_;
	gchar* _tmp63_;
	gchar* _tmp64_;
	gchar* _tmp65_;
	gchar* _tmp66_;
	gchar* _tmp67_;
	gchar* _tmp68_;
	gchar** _tmp69_;
	gint invalid_input_sources_length1;
	gint _invalid_input_sources_size_;
	GtkComboBoxText* third_level_combo = NULL;
	KeyboardXkbModifier* _tmp70_;
	GtkComboBoxText* _tmp71_;
	GtkLabel* third_level_label = NULL;
	GtkComboBoxText* _tmp72_;
	GtkLabel* _tmp73_;
	AdvancedSettingsPanel* panel = NULL;
	gchar** _tmp74_;
	gchar** _tmp75_;
	gint _tmp75__length1;
	gchar** _tmp76_;
	gint _tmp76__length1;
	AdvancedSettingsPanel* _tmp77_;
	AdvancedSettingsPanel* _tmp78_;
	AdvancedSettingsPanel* _tmp79_;
	GtkLabel* _tmp80_;
	AdvancedSettingsPanel* _tmp81_;
	GtkComboBoxText* _tmp82_;
	AdvancedSettingsPanel* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = keyboard_source_settings_get_xkb_modifier_by_name (_tmp0_, "third_level_key");
	modifier = _tmp1_;
	_tmp2_ = modifier;
	if (_tmp2_ == NULL) {
		result = NULL;
		_g_object_unref0 (modifier);
		return result;
	}
	_tmp3_ = g_strdup ("am*");
	_tmp4_ = g_strdup ("ara*");
	_tmp5_ = g_strdup ("az+cyrillic");
	_tmp6_ = g_strdup ("bg*");
	_tmp7_ = g_strdup ("by");
	_tmp8_ = g_strdup ("by+legacy");
	_tmp9_ = g_strdup ("ca+eng");
	_tmp10_ = g_strdup ("ca+ike");
	_tmp11_ = g_strdup ("cm");
	_tmp12_ = g_strdup ("cn*");
	_tmp13_ = g_strdup ("cz+ucw");
	_tmp14_ = g_strdup ("fr+dvorak");
	_tmp15_ = g_strdup ("ge+os");
	_tmp16_ = g_strdup ("ge+ru");
	_tmp17_ = g_strdup ("gr+nodeadkeys");
	_tmp18_ = g_strdup ("gr+simple");
	_tmp19_ = g_strdup ("ie+ogam");
	_tmp20_ = g_strdup ("il*");
	_tmp21_ = g_strdup ("in+ben_gitanjali");
	_tmp22_ = g_strdup ("in+ben_inscript");
	_tmp23_ = g_strdup ("in+tam_keyboard_with_numerals");
	_tmp24_ = g_strdup ("in+tam_TAB");
	_tmp25_ = g_strdup ("in+tam_TSCII");
	_tmp26_ = g_strdup ("in+tam_unicode");
	_tmp27_ = g_strdup ("iq");
	_tmp28_ = g_strdup ("jp*");
	_tmp29_ = g_strdup ("kg*");
	_tmp30_ = g_strdup ("kz*");
	_tmp31_ = g_strdup ("la*");
	_tmp32_ = g_strdup ("lk+tam_TAB");
	_tmp33_ = g_strdup ("lk+tam_unicode");
	_tmp34_ = g_strdup ("mk*");
	_tmp35_ = g_strdup ("mv*");
	_tmp36_ = g_strdup ("no+mac");
	_tmp37_ = g_strdup ("no+mac_nodeadkeys");
	_tmp38_ = g_strdup ("np*");
	_tmp39_ = g_strdup ("pk+ara");
	_tmp40_ = g_strdup ("ru");
	_tmp41_ = g_strdup ("ru+dos");
	_tmp42_ = g_strdup ("ru+legacy");
	_tmp43_ = g_strdup ("ru+mac");
	_tmp44_ = g_strdup ("ru+os_legacy");
	_tmp45_ = g_strdup ("ru+os_winkeys");
	_tmp46_ = g_strdup ("ru+phonetic");
	_tmp47_ = g_strdup ("ru+phonetic_winkeys");
	_tmp48_ = g_strdup ("ru+typewriter");
	_tmp49_ = g_strdup ("ru+typewriter-legacy");
	_tmp50_ = g_strdup ("sy");
	_tmp51_ = g_strdup ("sy+syc");
	_tmp52_ = g_strdup ("sy+syc_phonetic");
	_tmp53_ = g_strdup ("th*");
	_tmp54_ = g_strdup ("tz*");
	_tmp55_ = g_strdup ("ua+homophonic");
	_tmp56_ = g_strdup ("ua+legacy");
	_tmp57_ = g_strdup ("ua+phonetic");
	_tmp58_ = g_strdup ("ua+rstu");
	_tmp59_ = g_strdup ("ua+rstu_ru");
	_tmp60_ = g_strdup ("ua+typewriter");
	_tmp61_ = g_strdup ("ua+winkeys");
	_tmp62_ = g_strdup ("us");
	_tmp63_ = g_strdup ("us+chr");
	_tmp64_ = g_strdup ("us+dvorak");
	_tmp65_ = g_strdup ("us+dvorak-classic");
	_tmp66_ = g_strdup ("us+dvorak-l");
	_tmp67_ = g_strdup ("us+dvorak-r");
	_tmp68_ = g_strdup ("uz*");
	_tmp69_ = g_new0 (gchar*, 66 + 1);
	_tmp69_[0] = _tmp3_;
	_tmp69_[1] = _tmp4_;
	_tmp69_[2] = _tmp5_;
	_tmp69_[3] = _tmp6_;
	_tmp69_[4] = _tmp7_;
	_tmp69_[5] = _tmp8_;
	_tmp69_[6] = _tmp9_;
	_tmp69_[7] = _tmp10_;
	_tmp69_[8] = _tmp11_;
	_tmp69_[9] = _tmp12_;
	_tmp69_[10] = _tmp13_;
	_tmp69_[11] = _tmp14_;
	_tmp69_[12] = _tmp15_;
	_tmp69_[13] = _tmp16_;
	_tmp69_[14] = _tmp17_;
	_tmp69_[15] = _tmp18_;
	_tmp69_[16] = _tmp19_;
	_tmp69_[17] = _tmp20_;
	_tmp69_[18] = _tmp21_;
	_tmp69_[19] = _tmp22_;
	_tmp69_[20] = _tmp23_;
	_tmp69_[21] = _tmp24_;
	_tmp69_[22] = _tmp25_;
	_tmp69_[23] = _tmp26_;
	_tmp69_[24] = _tmp27_;
	_tmp69_[25] = _tmp28_;
	_tmp69_[26] = _tmp29_;
	_tmp69_[27] = _tmp30_;
	_tmp69_[28] = _tmp31_;
	_tmp69_[29] = _tmp32_;
	_tmp69_[30] = _tmp33_;
	_tmp69_[31] = _tmp34_;
	_tmp69_[32] = _tmp35_;
	_tmp69_[33] = _tmp36_;
	_tmp69_[34] = _tmp37_;
	_tmp69_[35] = _tmp38_;
	_tmp69_[36] = _tmp39_;
	_tmp69_[37] = _tmp40_;
	_tmp69_[38] = _tmp41_;
	_tmp69_[39] = _tmp42_;
	_tmp69_[40] = _tmp43_;
	_tmp69_[41] = _tmp44_;
	_tmp69_[42] = _tmp45_;
	_tmp69_[43] = _tmp46_;
	_tmp69_[44] = _tmp47_;
	_tmp69_[45] = _tmp48_;
	_tmp69_[46] = _tmp49_;
	_tmp69_[47] = _tmp50_;
	_tmp69_[48] = _tmp51_;
	_tmp69_[49] = _tmp52_;
	_tmp69_[50] = _tmp53_;
	_tmp69_[51] = _tmp54_;
	_tmp69_[52] = _tmp55_;
	_tmp69_[53] = _tmp56_;
	_tmp69_[54] = _tmp57_;
	_tmp69_[55] = _tmp58_;
	_tmp69_[56] = _tmp59_;
	_tmp69_[57] = _tmp60_;
	_tmp69_[58] = _tmp61_;
	_tmp69_[59] = _tmp62_;
	_tmp69_[60] = _tmp63_;
	_tmp69_[61] = _tmp64_;
	_tmp69_[62] = _tmp65_;
	_tmp69_[63] = _tmp66_;
	_tmp69_[64] = _tmp67_;
	_tmp69_[65] = _tmp68_;
	invalid_input_sources = _tmp69_;
	invalid_input_sources_length1 = 66;
	_invalid_input_sources_size_ = invalid_input_sources_length1;
	_tmp70_ = modifier;
	_tmp71_ = keyboard_layout_page_page_create_xkb_combobox (self, _tmp70_);
	third_level_combo = _tmp71_;
	_tmp72_ = third_level_combo;
	_tmp73_ = keyboard_layout_page_page_create_settings_label (self, _ ("Key to choose 3rd level:"), (GtkWidget*) _tmp72_);
	third_level_label = _tmp73_;
	_tmp74_ = g_new0 (gchar*, 0 + 1);
	_tmp75_ = _tmp74_;
	_tmp75__length1 = 0;
	_tmp76_ = invalid_input_sources;
	_tmp76__length1 = invalid_input_sources_length1;
	_tmp77_ = advanced_settings_panel_new ("third_level_layouts", _tmp75_, 0, _tmp76_, _tmp76__length1);
	g_object_ref_sink (_tmp77_);
	_tmp78_ = _tmp77_;
	_tmp75_ = (_vala_array_free (_tmp75_, _tmp75__length1, (GDestroyNotify) g_free), NULL);
	panel = _tmp78_;
	_tmp79_ = panel;
	_tmp80_ = third_level_label;
	gtk_grid_attach ((GtkGrid*) _tmp79_, (GtkWidget*) _tmp80_, 0, 0, 1, 1);
	_tmp81_ = panel;
	_tmp82_ = third_level_combo;
	gtk_grid_attach ((GtkGrid*) _tmp81_, (GtkWidget*) _tmp82_, 1, 0, 1, 1);
	result = panel;
	_g_object_unref0 (third_level_label);
	_g_object_unref0 (third_level_combo);
	invalid_input_sources = (_vala_array_free (invalid_input_sources, invalid_input_sources_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (modifier);
	return result;
}

static AdvancedSettingsPanel*
keyboard_layout_page_page_fifth_level_layouts_panel (KeyboardLayoutPagePage* self)
{
	KeyboardXkbModifier* modifier = NULL;
	KeyboardXkbModifier* _tmp0_;
	KeyboardXkbModifier* _tmp1_;
	KeyboardXkbModifier* _tmp2_;
	KeyboardXkbModifier* _tmp3_;
	KeyboardXkbModifier* _tmp4_;
	KeyboardXkbModifier* _tmp5_;
	KeyboardXkbModifier* _tmp6_;
	KeyboardXkbModifier* _tmp7_;
	KeyboardSourceSettings* _tmp8_;
	KeyboardXkbModifier* _tmp9_;
	GtkComboBoxText* third_level_combo = NULL;
	KeyboardXkbModifier* _tmp10_;
	GtkComboBoxText* _tmp11_;
	GtkLabel* third_level_label = NULL;
	GtkLabel* _tmp12_;
	KeyboardXkbModifier* _tmp13_;
	KeyboardXkbModifier* _tmp14_;
	KeyboardXkbModifier* _tmp15_;
	KeyboardXkbModifier* _tmp16_;
	KeyboardXkbModifier* _tmp17_;
	KeyboardSourceSettings* _tmp18_;
	KeyboardXkbModifier* _tmp19_;
	GtkComboBoxText* fifth_level_combo = NULL;
	KeyboardXkbModifier* _tmp20_;
	GtkComboBoxText* _tmp21_;
	GtkLabel* fifth_level_label = NULL;
	GtkLabel* _tmp22_;
	AdvancedSettingsPanel* panel = NULL;
	gchar* _tmp23_;
	gchar** _tmp24_;
	gchar** _tmp25_;
	gint _tmp25__length1;
	gchar** _tmp26_;
	gchar** _tmp27_;
	gint _tmp27__length1;
	AdvancedSettingsPanel* _tmp28_;
	AdvancedSettingsPanel* _tmp29_;
	AdvancedSettingsPanel* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = keyboard_xkb_modifier_new ("third_level_key", "org.gnome.desktop.input-sources", "xkb-options");
	modifier = _tmp0_;
	_tmp1_ = modifier;
	keyboard_xkb_modifier_append_xkb_option (_tmp1_, "", _ ("Default"));
	_tmp2_ = modifier;
	keyboard_xkb_modifier_append_xkb_option (_tmp2_, "lv3:caps_switch", _ ("Caps Lock"));
	_tmp3_ = modifier;
	keyboard_xkb_modifier_append_xkb_option (_tmp3_, "lv3:lalt_switch", _ ("Left Alt"));
	_tmp4_ = modifier;
	keyboard_xkb_modifier_append_xkb_option (_tmp4_, "lv3:ralt_switch", _ ("Right Alt"));
	_tmp5_ = modifier;
	keyboard_xkb_modifier_append_xkb_option (_tmp5_, "lv3:switch", _ ("Right Ctrl"));
	_tmp6_ = modifier;
	keyboard_xkb_modifier_append_xkb_option (_tmp6_, "lv3:rwin", _ ("Right ⌘"));
	_tmp7_ = modifier;
	keyboard_xkb_modifier_set_default_command (_tmp7_, "");
	_tmp8_ = self->priv->settings;
	_tmp9_ = modifier;
	keyboard_source_settings_add_xkb_modifier (_tmp8_, _tmp9_);
	_tmp10_ = modifier;
	_tmp11_ = keyboard_layout_page_page_create_xkb_combobox (self, _tmp10_);
	third_level_combo = _tmp11_;
	_tmp12_ = keyboard_layout_page_page_create_settings_label (self, _ ("Key to choose 3rd level:"), (GtkWidget*) third_level_combo);
	third_level_label = _tmp12_;
	_tmp13_ = keyboard_xkb_modifier_new ("", "org.gnome.desktop.input-sources", "xkb-options");
	_g_object_unref0 (modifier);
	modifier = _tmp13_;
	_tmp14_ = modifier;
	keyboard_xkb_modifier_append_xkb_option (_tmp14_, "lv5:ralt_switch_lock", _ ("Right Alt"));
	_tmp15_ = modifier;
	keyboard_xkb_modifier_append_xkb_option (_tmp15_, "", _ ("Right Ctrl"));
	_tmp16_ = modifier;
	keyboard_xkb_modifier_append_xkb_option (_tmp16_, "lv5:rwin_switch_lock", _ ("Right ⌘"));
	_tmp17_ = modifier;
	keyboard_xkb_modifier_set_default_command (_tmp17_, "");
	_tmp18_ = self->priv->settings;
	_tmp19_ = modifier;
	keyboard_source_settings_add_xkb_modifier (_tmp18_, _tmp19_);
	_tmp20_ = modifier;
	_tmp21_ = keyboard_layout_page_page_create_xkb_combobox (self, _tmp20_);
	fifth_level_combo = _tmp21_;
	_tmp22_ = keyboard_layout_page_page_create_settings_label (self, _ ("Key to choose 5th level:"), (GtkWidget*) fifth_level_combo);
	fifth_level_label = _tmp22_;
	_tmp23_ = g_strdup ("ca+multix");
	_tmp24_ = g_new0 (gchar*, 1 + 1);
	_tmp24_[0] = _tmp23_;
	_tmp25_ = _tmp24_;
	_tmp25__length1 = 1;
	_tmp26_ = g_new0 (gchar*, 0 + 1);
	_tmp27_ = _tmp26_;
	_tmp27__length1 = 0;
	_tmp28_ = advanced_settings_panel_new ("fifth_level_layouts", _tmp25_, 1, _tmp27_, 0);
	g_object_ref_sink (_tmp28_);
	_tmp29_ = _tmp28_;
	_tmp27_ = (_vala_array_free (_tmp27_, _tmp27__length1, (GDestroyNotify) g_free), NULL);
	_tmp25_ = (_vala_array_free (_tmp25_, _tmp25__length1, (GDestroyNotify) g_free), NULL);
	panel = _tmp29_;
	gtk_grid_attach ((GtkGrid*) panel, (GtkWidget*) third_level_label, 0, 0, 1, 1);
	gtk_grid_attach ((GtkGrid*) panel, (GtkWidget*) third_level_combo, 1, 0, 1, 1);
	gtk_grid_attach ((GtkGrid*) panel, (GtkWidget*) fifth_level_label, 0, 1, 1, 1);
	gtk_grid_attach ((GtkGrid*) panel, (GtkWidget*) fifth_level_combo, 1, 1, 1, 1);
	result = panel;
	_g_object_unref0 (fifth_level_label);
	_g_object_unref0 (fifth_level_combo);
	_g_object_unref0 (third_level_label);
	_g_object_unref0 (third_level_combo);
	_g_object_unref0 (modifier);
	return result;
}

static AdvancedSettingsPanel*
keyboard_layout_page_page_japanese_layouts_panel (KeyboardLayoutPagePage* self)
{
	GtkSwitch* kana_lock_switch = NULL;
	KeyboardSourceSettings* _tmp0_;
	GtkSwitch* _tmp1_;
	GtkLabel* kana_lock_label = NULL;
	GtkLabel* _tmp2_;
	GtkSwitch* nicola_backspace_switch = NULL;
	KeyboardSourceSettings* _tmp3_;
	GtkSwitch* _tmp4_;
	GtkLabel* nicola_backspace_label = NULL;
	GtkLabel* _tmp5_;
	GtkSwitch* zenkaku_switch = NULL;
	KeyboardSourceSettings* _tmp6_;
	GtkSwitch* _tmp7_;
	GtkLabel* zenkaku_label = NULL;
	GtkLabel* _tmp8_;
	AdvancedSettingsPanel* panel = NULL;
	gchar* _tmp9_;
	gchar** _tmp10_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	gchar** _tmp12_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	AdvancedSettingsPanel* _tmp14_;
	AdvancedSettingsPanel* _tmp15_;
	AdvancedSettingsPanel* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = keyboard_layout_page_page_create_xkb_option_switch (self, _tmp0_, "japan:kana_lock");
	kana_lock_switch = _tmp1_;
	_tmp2_ = keyboard_layout_page_page_create_settings_label (self, _ ("Kana Lock:"), (GtkWidget*) kana_lock_switch);
	kana_lock_label = _tmp2_;
	_tmp3_ = self->priv->settings;
	_tmp4_ = keyboard_layout_page_page_create_xkb_option_switch (self, _tmp3_, "japan:nicola_f_bs");
	nicola_backspace_switch = _tmp4_;
	_tmp5_ = keyboard_layout_page_page_create_settings_label (self, _ ("Nicola F Backspace:"), (GtkWidget*) nicola_backspace_switch);
	nicola_backspace_label = _tmp5_;
	_tmp6_ = self->priv->settings;
	_tmp7_ = keyboard_layout_page_page_create_xkb_option_switch (self, _tmp6_, "japan:hztg_escape");
	zenkaku_switch = _tmp7_;
	_tmp8_ = keyboard_layout_page_page_create_settings_label (self, _ ("Hankaku Zenkaku as Escape:"), (GtkWidget*) zenkaku_switch);
	zenkaku_label = _tmp8_;
	_tmp9_ = g_strdup ("jp");
	_tmp10_ = g_new0 (gchar*, 1 + 1);
	_tmp10_[0] = _tmp9_;
	_tmp11_ = _tmp10_;
	_tmp11__length1 = 1;
	_tmp12_ = g_new0 (gchar*, 0 + 1);
	_tmp13_ = _tmp12_;
	_tmp13__length1 = 0;
	_tmp14_ = advanced_settings_panel_new ("japanese_layouts", _tmp11_, 1, _tmp13_, 0);
	g_object_ref_sink (_tmp14_);
	_tmp15_ = _tmp14_;
	_tmp13_ = (_vala_array_free (_tmp13_, _tmp13__length1, (GDestroyNotify) g_free), NULL);
	_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_free), NULL);
	panel = _tmp15_;
	gtk_grid_attach ((GtkGrid*) panel, (GtkWidget*) kana_lock_label, 0, 0, 1, 1);
	gtk_grid_attach ((GtkGrid*) panel, (GtkWidget*) kana_lock_switch, 1, 0, 1, 1);
	gtk_grid_attach ((GtkGrid*) panel, (GtkWidget*) nicola_backspace_label, 0, 1, 1, 1);
	gtk_grid_attach ((GtkGrid*) panel, (GtkWidget*) nicola_backspace_switch, 1, 1, 1, 1);
	gtk_grid_attach ((GtkGrid*) panel, (GtkWidget*) zenkaku_label, 0, 2, 1, 1);
	gtk_grid_attach ((GtkGrid*) panel, (GtkWidget*) zenkaku_switch, 1, 2, 1, 1);
	result = panel;
	_g_object_unref0 (zenkaku_label);
	_g_object_unref0 (zenkaku_switch);
	_g_object_unref0 (nicola_backspace_label);
	_g_object_unref0 (nicola_backspace_switch);
	_g_object_unref0 (kana_lock_label);
	_g_object_unref0 (kana_lock_switch);
	return result;
}

static AdvancedSettingsPanel*
keyboard_layout_page_page_korean_layouts_panel (KeyboardLayoutPagePage* self)
{
	GtkSwitch* hangul_switch = NULL;
	KeyboardSourceSettings* _tmp0_;
	GtkSwitch* _tmp1_;
	GtkLabel* hangul_label = NULL;
	GtkLabel* _tmp2_;
	AdvancedSettingsPanel* panel = NULL;
	gchar* _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	AdvancedSettingsPanel* _tmp8_;
	AdvancedSettingsPanel* _tmp9_;
	AdvancedSettingsPanel* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = keyboard_layout_page_page_create_xkb_option_switch (self, _tmp0_, "korean:ralt_rctrl");
	hangul_switch = _tmp1_;
	_tmp2_ = keyboard_layout_page_page_create_settings_label (self, _ ("Hangul/Hanja keys on Right Alt/Ctrl:"), (GtkWidget*) hangul_switch);
	hangul_label = _tmp2_;
	_tmp3_ = g_strdup ("kr");
	_tmp4_ = g_new0 (gchar*, 1 + 1);
	_tmp4_[0] = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp5__length1 = 1;
	_tmp6_ = g_new0 (gchar*, 0 + 1);
	_tmp7_ = _tmp6_;
	_tmp7__length1 = 0;
	_tmp8_ = advanced_settings_panel_new ("korean_layouts", _tmp5_, 1, _tmp7_, 0);
	g_object_ref_sink (_tmp8_);
	_tmp9_ = _tmp8_;
	_tmp7_ = (_vala_array_free (_tmp7_, _tmp7__length1, (GDestroyNotify) g_free), NULL);
	_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) g_free), NULL);
	panel = _tmp9_;
	gtk_grid_attach ((GtkGrid*) panel, (GtkWidget*) hangul_label, 0, 0, 1, 1);
	gtk_grid_attach ((GtkGrid*) panel, (GtkWidget*) hangul_switch, 1, 0, 1, 1);
	result = panel;
	_g_object_unref0 (hangul_label);
	_g_object_unref0 (hangul_switch);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
keyboard_layout_page_page_show_panel_for_active_layout (KeyboardLayoutPagePage* self)
{
	KeyboardInputSource* active_layout = NULL;
	KeyboardSourceSettings* _tmp0_;
	KeyboardInputSource* _tmp1_;
	KeyboardInputSource* _tmp2_;
	KeyboardInputSource* _tmp3_;
	KeyboardInputSource* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = keyboard_source_settings_get_active_input_source (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	active_layout = _tmp3_;
	_tmp4_ = active_layout;
	if (_tmp4_ != NULL) {
		KeyboardInputSource* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp5_ = active_layout;
		_tmp6_ = keyboard_input_source_get_name (_tmp5_);
		_tmp7_ = _tmp6_;
		keyboard_layout_page_page_set_visible_panel_from_layout (self, _tmp7_);
	} else {
		keyboard_layout_page_page_set_visible_panel_from_layout (self, NULL);
	}
	_g_object_unref0 (active_layout);
}

static Block16Data*
block16_data_ref (Block16Data* _data16_)
{
	g_atomic_int_inc (&_data16_->_ref_count_);
	return _data16_;
}

static void
block16_data_unref (void * _userdata_)
{
	Block16Data* _data16_;
	_data16_ = (Block16Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data16_->_ref_count_)) {
		KeyboardLayoutPagePage* self;
		self = _data16_->self;
		_g_object_unref0 (_data16_->combo_box);
		_g_object_unref0 (_data16_->modifier);
		_g_object_unref0 (self);
		g_slice_free (Block16Data, _data16_);
	}
}

static void
__lambda51_ (Block16Data* _data16_)
{
	KeyboardLayoutPagePage* self;
	GtkComboBoxText* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	self = _data16_->self;
	_tmp0_ = _data16_->combo_box;
	_tmp1_ = gtk_combo_box_get_active_id ((GtkComboBox*) _tmp0_);
	_tmp2_ = _tmp1_;
	keyboard_xkb_modifier_update_active_command (_data16_->modifier, _tmp2_);
}

static void
___lambda51__gtk_combo_box_changed (GtkComboBox* _sender,
                                    gpointer self)
{
	__lambda51_ (self);
}

static void
__lambda52_ (Block16Data* _data16_)
{
	KeyboardLayoutPagePage* self;
	GtkComboBoxText* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	self = _data16_->self;
	_tmp0_ = _data16_->combo_box;
	_tmp1_ = keyboard_xkb_modifier_get_active_command (_data16_->modifier);
	_tmp2_ = _tmp1_;
	gtk_combo_box_set_active_id ((GtkComboBox*) _tmp0_, _tmp2_);
	_g_free0 (_tmp2_);
}

static void
___lambda52__keyboard_xkb_modifier_active_command_updated (KeyboardXkbModifier* _sender,
                                                           gpointer self)
{
	__lambda52_ (self);
}

static GtkComboBoxText*
keyboard_layout_page_page_create_xkb_combobox (KeyboardLayoutPagePage* self,
                                               KeyboardXkbModifier* modifier)
{
	Block16Data* _data16_;
	KeyboardXkbModifier* _tmp0_;
	GtkComboBoxText* _tmp1_ = NULL;
	GtkSizeGroup** _tmp2_;
	gint _tmp2__length1;
	GtkSizeGroup* _tmp3_;
	GtkComboBoxText* _tmp4_;
	GtkComboBoxText* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	GtkComboBoxText* _tmp16_;
	GtkComboBoxText* _tmp17_;
	GtkComboBoxText* _tmp18_;
	GtkComboBoxText* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (modifier != NULL, NULL);
	_data16_ = g_slice_new0 (Block16Data);
	_data16_->_ref_count_ = 1;
	_data16_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (modifier);
	_g_object_unref0 (_data16_->modifier);
	_data16_->modifier = _tmp0_;
	_tmp1_ = (GtkComboBoxText*) gtk_combo_box_text_new ();
	gtk_widget_set_halign ((GtkWidget*) _tmp1_, GTK_ALIGN_START);
	gtk_widget_set_valign ((GtkWidget*) _tmp1_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp1_);
	_data16_->combo_box = _tmp1_;
	_tmp2_ = self->priv->size_group;
	_tmp2__length1 = self->priv->size_group_length1;
	_tmp3_ = _tmp2_[1];
	_tmp4_ = _data16_->combo_box;
	gtk_size_group_add_widget (_tmp3_, (GtkWidget*) _tmp4_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				gchar** _tmp7_;
				gint _tmp7__length1;
				GtkComboBoxText* _tmp8_;
				gchar** _tmp9_;
				gint _tmp9__length1;
				const gchar* _tmp10_;
				gchar** _tmp11_;
				gint _tmp11__length1;
				const gchar* _tmp12_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp7_ = _data16_->modifier->xkb_option_commands;
				_tmp7__length1 = _data16_->modifier->xkb_option_commands_length1;
				if (!(i < _tmp7__length1)) {
					break;
				}
				_tmp8_ = _data16_->combo_box;
				_tmp9_ = _data16_->modifier->xkb_option_commands;
				_tmp9__length1 = _data16_->modifier->xkb_option_commands_length1;
				_tmp10_ = _tmp9_[i];
				_tmp11_ = _data16_->modifier->option_descriptions;
				_tmp11__length1 = _data16_->modifier->option_descriptions_length1;
				_tmp12_ = _tmp11_[i];
				gtk_combo_box_text_append (_tmp8_, _tmp10_, _tmp12_);
			}
		}
	}
	_tmp13_ = _data16_->combo_box;
	_tmp14_ = keyboard_xkb_modifier_get_active_command (_data16_->modifier);
	_tmp15_ = _tmp14_;
	gtk_combo_box_set_active_id ((GtkComboBox*) _tmp13_, _tmp15_);
	_g_free0 (_tmp15_);
	_tmp16_ = _data16_->combo_box;
	g_signal_connect_data ((GtkComboBox*) _tmp16_, "changed", (GCallback) ___lambda51__gtk_combo_box_changed, block16_data_ref (_data16_), (GClosureNotify) block16_data_unref, 0);
	g_signal_connect_data (_data16_->modifier, "active-command-updated", (GCallback) ___lambda52__keyboard_xkb_modifier_active_command_updated, block16_data_ref (_data16_), (GClosureNotify) block16_data_unref, 0);
	_tmp17_ = _data16_->combo_box;
	_tmp18_ = _g_object_ref0 (_tmp17_);
	result = _tmp18_;
	block16_data_unref (_data16_);
	_data16_ = NULL;
	return result;
}

static Block17Data*
block17_data_ref (Block17Data* _data17_)
{
	g_atomic_int_inc (&_data17_->_ref_count_);
	return _data17_;
}

static void
block17_data_unref (void * _userdata_)
{
	Block17Data* _data17_;
	_data17_ = (Block17Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data17_->_ref_count_)) {
		KeyboardLayoutPagePage* self;
		self = _data17_->self;
		_g_object_unref0 (_data17_->modifier);
		_g_object_unref0 (_data17_->option_switch);
		_g_free0 (_data17_->xkb_command);
		_g_object_unref0 (self);
		g_slice_free (Block17Data, _data17_);
	}
}

static void
__lambda53_ (Block17Data* _data17_)
{
	KeyboardLayoutPagePage* self;
	GtkSwitch* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	self = _data17_->self;
	_tmp0_ = _data17_->option_switch;
	_tmp1_ = gtk_switch_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		KeyboardXkbModifier* _tmp3_;
		_tmp3_ = _data17_->modifier;
		keyboard_xkb_modifier_update_active_command (_tmp3_, _data17_->xkb_command);
	} else {
		KeyboardXkbModifier* _tmp4_;
		_tmp4_ = _data17_->modifier;
		keyboard_xkb_modifier_update_active_command (_tmp4_, "");
	}
}

static void
___lambda53__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda53_ (self);
}

static GtkSwitch*
keyboard_layout_page_page_create_xkb_option_switch (KeyboardLayoutPagePage* self,
                                                    KeyboardSourceSettings* settings,
                                                    const gchar* xkb_command)
{
	Block17Data* _data17_;
	gchar* _tmp0_;
	GtkSwitch* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	KeyboardXkbModifier* _tmp4_;
	KeyboardXkbModifier* _tmp5_;
	KeyboardXkbModifier* _tmp6_;
	KeyboardXkbModifier* _tmp7_;
	KeyboardXkbModifier* _tmp8_;
	KeyboardXkbModifier* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gboolean _tmp12_;
	GtkSwitch* _tmp15_;
	GtkSwitch* _tmp16_;
	GtkSwitch* _tmp17_;
	GtkSwitch* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (settings != NULL, NULL);
	g_return_val_if_fail (xkb_command != NULL, NULL);
	_data17_ = g_slice_new0 (Block17Data);
	_data17_->_ref_count_ = 1;
	_data17_->self = g_object_ref (self);
	_tmp0_ = g_strdup (xkb_command);
	_g_free0 (_data17_->xkb_command);
	_data17_->xkb_command = _tmp0_;
	_tmp1_ = (GtkSwitch*) gtk_switch_new ();
	gtk_widget_set_halign ((GtkWidget*) _tmp1_, GTK_ALIGN_START);
	gtk_widget_set_valign ((GtkWidget*) _tmp1_, GTK_ALIGN_START);
	g_object_ref_sink (_tmp1_);
	_data17_->option_switch = _tmp1_;
	_tmp2_ = g_strconcat ("", _data17_->xkb_command, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = keyboard_xkb_modifier_new (_tmp3_, "org.gnome.desktop.input-sources", "xkb-options");
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	_data17_->modifier = _tmp5_;
	_tmp6_ = _data17_->modifier;
	keyboard_xkb_modifier_append_xkb_option (_tmp6_, "", "option off");
	_tmp7_ = _data17_->modifier;
	keyboard_xkb_modifier_append_xkb_option (_tmp7_, _data17_->xkb_command, "option on");
	_tmp8_ = _data17_->modifier;
	keyboard_source_settings_add_xkb_modifier (settings, _tmp8_);
	_tmp9_ = _data17_->modifier;
	_tmp10_ = keyboard_xkb_modifier_get_active_command (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strcmp0 (_tmp11_, "") == 0;
	_g_free0 (_tmp11_);
	if (_tmp12_) {
		GtkSwitch* _tmp13_;
		_tmp13_ = _data17_->option_switch;
		gtk_switch_set_active (_tmp13_, FALSE);
	} else {
		GtkSwitch* _tmp14_;
		_tmp14_ = _data17_->option_switch;
		gtk_switch_set_active (_tmp14_, TRUE);
	}
	_tmp15_ = _data17_->option_switch;
	g_signal_connect_data ((GObject*) _tmp15_, "notify::active", (GCallback) ___lambda53__g_object_notify, block17_data_ref (_data17_), (GClosureNotify) block17_data_unref, 0);
	_tmp16_ = _data17_->option_switch;
	_tmp17_ = _g_object_ref0 (_tmp16_);
	result = _tmp17_;
	block17_data_unref (_data17_);
	_data17_ = NULL;
	return result;
}

static void
keyboard_layout_page_page_update_entry_test_usable (KeyboardLayoutPagePage* self)
{
	gboolean _tmp0_ = FALSE;
	KeyboardSourceSettings* _tmp1_;
	KeyboardInputSource* _tmp2_;
	KeyboardInputSource* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->settings;
	_tmp2_ = keyboard_source_settings_get_active_input_source (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		KeyboardSourceSettings* _tmp4_;
		KeyboardInputSource* _tmp5_;
		KeyboardInputSource* _tmp6_;
		KeyboardLayoutType _tmp7_;
		KeyboardLayoutType _tmp8_;
		_tmp4_ = self->priv->settings;
		_tmp5_ = keyboard_source_settings_get_active_input_source (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = keyboard_input_source_get_layout_type (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp0_ = _tmp8_ == KEYBOARD_LAYOUT_TYPE_XKB;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkEntry* _tmp9_;
		GtkEntry* _tmp10_;
		_tmp9_ = self->priv->entry_test;
		gtk_entry_set_placeholder_text (_tmp9_, _ ("Type to test your layout"));
		_tmp10_ = self->priv->entry_test;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp10_, TRUE);
	} else {
		GtkEntry* _tmp11_;
		GtkEntry* _tmp12_;
		_tmp11_ = self->priv->entry_test;
		gtk_entry_set_placeholder_text (_tmp11_, _ ("Input Method is active"));
		_tmp12_ = self->priv->entry_test;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp12_, FALSE);
	}
}

static GtkLabel*
keyboard_layout_page_page_create_settings_label (KeyboardLayoutPagePage* self,
                                                 const gchar* label,
                                                 GtkWidget* mnemonic_widget)
{
	GtkLabel* settings_label = NULL;
	GtkWidget* _tmp0_;
	GtkLabel* _tmp1_ = NULL;
	GtkSizeGroup** _tmp2_;
	gint _tmp2__length1;
	GtkSizeGroup* _tmp3_;
	GtkLabel* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (label != NULL, NULL);
	g_return_val_if_fail (mnemonic_widget != NULL, NULL);
	_tmp0_ = _g_object_ref0 (mnemonic_widget);
	_tmp1_ = (GtkLabel*) gtk_label_new (label);
	gtk_label_set_mnemonic_widget (_tmp1_, _tmp0_);
	_g_object_unref0 (_tmp0_);
	gtk_label_set_xalign (_tmp1_, (gfloat) 1);
	g_object_ref_sink (_tmp1_);
	settings_label = _tmp1_;
	_tmp2_ = self->priv->size_group;
	_tmp2__length1 = self->priv->size_group_length1;
	_tmp3_ = _tmp2_[0];
	gtk_size_group_add_widget (_tmp3_, (GtkWidget*) settings_label);
	result = settings_label;
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static void
keyboard_layout_page_page_set_visible_panel_from_layout (KeyboardLayoutPagePage* self,
                                                         const gchar* layout_name)
{
	gchar* panel_name = NULL;
	gchar* _tmp0_;
	gchar** split_name = NULL;
	gchar** _tmp1_;
	gint split_name_length1;
	gint _split_name_size_;
	const gchar* _tmp18_;
	const gchar* _tmp44_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("none");
	panel_name = _tmp0_;
	_tmp1_ = g_new0 (gchar*, 0 + 1);
	split_name = _tmp1_;
	split_name_length1 = 0;
	_split_name_size_ = split_name_length1;
	if (layout_name != NULL) {
		GHashTable* _tmp2_;
		gconstpointer _tmp3_ = NULL;
		gboolean _tmp4_;
		gchar* _tmp5_;
		gchar** _tmp7_;
		gchar** _tmp8_;
		gboolean _tmp9_ = FALSE;
		const gchar* _tmp10_;
		_tmp2_ = self->priv->panel_for_layout;
		_tmp4_ = g_hash_table_lookup_extended (_tmp2_, layout_name, NULL, &_tmp3_);
		_g_free0 (panel_name);
		_tmp5_ = g_strdup ((const gchar*) _tmp3_);
		panel_name = _tmp5_;
		if (!_tmp4_) {
			gchar* _tmp6_;
			_tmp6_ = g_strdup ("");
			_g_free0 (panel_name);
			panel_name = _tmp6_;
		}
		_tmp8_ = _tmp7_ = g_strsplit (layout_name, "+", 0);
		split_name = (_vala_array_free (split_name, split_name_length1, (GDestroyNotify) g_free), NULL);
		split_name = _tmp8_;
		split_name_length1 = _vala_array_length (_tmp7_);
		_split_name_size_ = split_name_length1;
		_tmp10_ = panel_name;
		if (g_strcmp0 (_tmp10_, "") == 0) {
			_tmp9_ = string_contains (layout_name, "+");
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			GHashTable* _tmp11_;
			gchar** _tmp12_;
			gint _tmp12__length1;
			const gchar* _tmp13_;
			gconstpointer _tmp14_ = NULL;
			gboolean _tmp15_;
			gchar* _tmp16_;
			_tmp11_ = self->priv->panel_for_layout;
			_tmp12_ = split_name;
			_tmp12__length1 = split_name_length1;
			_tmp13_ = _tmp12_[0];
			_tmp15_ = g_hash_table_lookup_extended (_tmp11_, _tmp13_, NULL, &_tmp14_);
			_g_free0 (panel_name);
			_tmp16_ = g_strdup ((const gchar*) _tmp14_);
			panel_name = _tmp16_;
			if (!_tmp15_) {
				gchar* _tmp17_;
				_tmp17_ = g_strdup ("");
				_g_free0 (panel_name);
				panel_name = _tmp17_;
			}
		}
	}
	_tmp18_ = panel_name;
	if (g_strcmp0 (_tmp18_, "") == 0) {
		AdvancedSettingsPanel** _tmp19_;
		gint _tmp19__length1;
		_tmp19_ = self->priv->panels;
		_tmp19__length1 = self->priv->panels_length1;
		{
			AdvancedSettingsPanel** panel_collection = NULL;
			gint panel_collection_length1 = 0;
			gint _panel_collection_size_ = 0;
			gint panel_it = 0;
			panel_collection = _tmp19_;
			panel_collection_length1 = _tmp19__length1;
			for (panel_it = 0; panel_it < panel_collection_length1; panel_it = panel_it + 1) {
				AdvancedSettingsPanel* panel = NULL;
				panel = panel_collection[panel_it];
				{
					gboolean _tmp20_ = FALSE;
					AdvancedSettingsPanel* _tmp21_;
					gboolean _tmp26_ = FALSE;
					gchar** _tmp27_;
					gint _tmp27__length1;
					const gchar* _tmp28_;
					gchar* _tmp29_;
					gchar* _tmp30_;
					AdvancedSettingsPanel* _tmp31_;
					gchar** _tmp32_;
					gint _tmp32__length1;
					gint _tmp33_ = 0;
					gchar** _tmp34_;
					gint _tmp34__length1;
					gboolean _tmp35_;
					_tmp21_ = panel;
					if (_tmp21_ == NULL) {
						_tmp20_ = TRUE;
					} else {
						AdvancedSettingsPanel* _tmp22_;
						gchar** _tmp23_;
						gint _tmp23__length1;
						gint _tmp24_ = 0;
						gchar** _tmp25_;
						gint _tmp25__length1;
						_tmp22_ = panel;
						_tmp23_ = advanced_settings_panel_get_exclusions (_tmp22_, &_tmp24_);
						_tmp23__length1 = _tmp24_;
						_tmp25_ = _tmp23_;
						_tmp25__length1 = _tmp23__length1;
						_tmp20_ = _tmp25__length1 == 0;
					}
					if (_tmp20_) {
						continue;
					}
					_tmp27_ = split_name;
					_tmp27__length1 = split_name_length1;
					_tmp28_ = _tmp27_[0];
					_tmp29_ = g_strconcat (_tmp28_, "*", NULL);
					_tmp30_ = _tmp29_;
					_tmp31_ = panel;
					_tmp32_ = advanced_settings_panel_get_exclusions (_tmp31_, &_tmp33_);
					_tmp32__length1 = _tmp33_;
					_tmp34_ = _tmp32_;
					_tmp34__length1 = _tmp32__length1;
					_tmp35_ = _vala_string_array_contains (_tmp34_, _tmp34__length1, _tmp30_);
					_g_free0 (_tmp30_);
					if (_tmp35_) {
						_tmp26_ = TRUE;
					} else {
						AdvancedSettingsPanel* _tmp36_;
						gchar** _tmp37_;
						gint _tmp37__length1;
						gint _tmp38_ = 0;
						gchar** _tmp39_;
						gint _tmp39__length1;
						_tmp36_ = panel;
						_tmp37_ = advanced_settings_panel_get_exclusions (_tmp36_, &_tmp38_);
						_tmp37__length1 = _tmp38_;
						_tmp39_ = _tmp37_;
						_tmp39__length1 = _tmp37__length1;
						_tmp26_ = _vala_string_array_contains (_tmp39_, _tmp39__length1, layout_name);
					}
					if (!_tmp26_) {
						AdvancedSettingsPanel* _tmp40_;
						const gchar* _tmp41_;
						const gchar* _tmp42_;
						gchar* _tmp43_;
						_tmp40_ = panel;
						_tmp41_ = advanced_settings_panel_get_panel_name (_tmp40_);
						_tmp42_ = _tmp41_;
						_tmp43_ = g_strdup (_tmp42_);
						_g_free0 (panel_name);
						panel_name = _tmp43_;
						break;
					}
				}
			}
		}
	}
	_tmp44_ = panel_name;
	if (g_strcmp0 (_tmp44_, "") == 0) {
		GtkStack* _tmp45_;
		_tmp45_ = self->priv->stack;
		gtk_stack_set_visible_child_name (_tmp45_, "none");
		split_name = (_vala_array_free (split_name, split_name_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (panel_name);
		return;
	} else {
		GtkStack* _tmp46_;
		const gchar* _tmp47_;
		_tmp46_ = self->priv->stack;
		_tmp47_ = panel_name;
		gtk_stack_set_visible_child_name (_tmp46_, _tmp47_);
	}
	split_name = (_vala_array_free (split_name, split_name_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (panel_name);
}

KeyboardLayoutPagePage*
keyboard_layout_page_page_construct (GType object_type)
{
	KeyboardLayoutPagePage * self = NULL;
	self = (KeyboardLayoutPagePage*) g_object_new (object_type, NULL);
	return self;
}

KeyboardLayoutPagePage*
keyboard_layout_page_page_new (void)
{
	return keyboard_layout_page_page_construct (KEYBOARD_LAYOUT_PAGE_TYPE_PAGE);
}

static Block18Data*
block18_data_ref (Block18Data* _data18_)
{
	g_atomic_int_inc (&_data18_->_ref_count_);
	return _data18_;
}

static void
block18_data_unref (void * _userdata_)
{
	Block18Data* _data18_;
	_data18_ = (Block18Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data18_->_ref_count_)) {
		KeyboardLayoutPagePage* self;
		self = _data18_->self;
		_g_object_unref0 (_data18_->gala_behavior_settings);
		_g_object_unref0 (_data18_->overlay_key_combo);
		_g_object_unref0 (self);
		g_slice_free (Block18Data, _data18_);
	}
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_keyboard_layout_page_page___lambda54_ (KeyboardLayoutPagePage* self)
{
	keyboard_layout_page_page_show_panel_for_active_layout (self);
}

static void
__keyboard_layout_page_page___lambda54__gtk_widget_map (GtkWidget* _sender,
                                                        gpointer self)
{
	_keyboard_layout_page_page___lambda54_ ((KeyboardLayoutPagePage*) self);
}

static void
_keyboard_layout_page_page___lambda55_ (KeyboardLayoutPagePage* self)
{
	keyboard_layout_page_page_update_entry_test_usable (self);
	keyboard_layout_page_page_show_panel_for_active_layout (self);
}

static void
__keyboard_layout_page_page___lambda55__g_object_notify (GObject* _sender,
                                                         GParamSpec* pspec,
                                                         gpointer self)
{
	_keyboard_layout_page_page___lambda55_ ((KeyboardLayoutPagePage*) self);
}

static void
_keyboard_layout_page_page___lambda56_ (Block18Data* _data18_)
{
	KeyboardLayoutPagePage* self;
	gint combo_active = 0;
	GtkComboBoxText* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	self = _data18_->self;
	_tmp0_ = _data18_->overlay_key_combo;
	_tmp1_ = gtk_combo_box_get_active ((GtkComboBox*) _tmp0_);
	_tmp2_ = _tmp1_;
	combo_active = _tmp2_;
	if (combo_active == 0) {
		GSettings* _tmp3_;
		_tmp3_ = _data18_->gala_behavior_settings;
		g_settings_set_string (_tmp3_, "overlay-action", "");
	} else {
		if (combo_active == 1) {
			GSettings* _tmp4_;
			_tmp4_ = _data18_->gala_behavior_settings;
			g_settings_set_string (_tmp4_, "overlay-action", "io.elementary.wingpanel --toggle-indicator=app-launcher");
		} else {
			if (combo_active == 2) {
				GSettings* _tmp5_;
				_tmp5_ = _data18_->gala_behavior_settings;
				g_settings_set_string (_tmp5_, "overlay-action", KEYBOARD_LAYOUT_PAGE_PAGE_MULTITASKING_VIEW_COMMAND);
			} else {
				if (combo_active == 3) {
					GSettings* _tmp6_;
					_tmp6_ = _data18_->gala_behavior_settings;
					g_settings_set_string (_tmp6_, "overlay-action", "io.elementary.shortcut-overlay");
				}
			}
		}
	}
}

static void
__keyboard_layout_page_page___lambda56__gtk_combo_box_changed (GtkComboBox* _sender,
                                                               gpointer self)
{
	_keyboard_layout_page_page___lambda56_ (self);
}

static GObject *
keyboard_layout_page_page_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	KeyboardLayoutPagePage * self;
	Block18Data* _data18_;
	KeyboardSourceSettings* _tmp0_;
	GtkSizeGroup* _tmp1_;
	GtkSizeGroup* _tmp2_;
	GtkSizeGroup** _tmp3_;
	KeyboardLayoutPageDisplay* _tmp4_;
	KeyboardXkbModifier* modifier = NULL;
	KeyboardXkbModifier* _tmp5_;
	KeyboardXkbModifier* _tmp6_;
	KeyboardXkbModifier* _tmp7_;
	KeyboardXkbModifier* _tmp8_;
	KeyboardXkbModifier* _tmp9_;
	KeyboardXkbModifier* _tmp10_;
	KeyboardXkbModifier* _tmp11_;
	KeyboardXkbModifier* _tmp12_;
	KeyboardXkbModifier* _tmp13_;
	KeyboardXkbModifier* _tmp14_;
	KeyboardXkbModifier* _tmp15_;
	KeyboardSourceSettings* _tmp16_;
	KeyboardXkbModifier* _tmp17_;
	GtkComboBoxText* switch_layout_combo = NULL;
	KeyboardXkbModifier* _tmp18_;
	GtkComboBoxText* _tmp19_;
	GtkLabel* switch_layout_label = NULL;
	GtkComboBoxText* _tmp20_;
	GtkLabel* _tmp21_;
	KeyboardXkbModifier* _tmp22_;
	KeyboardXkbModifier* _tmp23_;
	KeyboardXkbModifier* _tmp24_;
	KeyboardXkbModifier* _tmp25_;
	KeyboardXkbModifier* _tmp26_;
	KeyboardXkbModifier* _tmp27_;
	KeyboardXkbModifier* _tmp28_;
	KeyboardXkbModifier* _tmp29_;
	KeyboardSourceSettings* _tmp30_;
	KeyboardXkbModifier* _tmp31_;
	GtkComboBoxText* compose_key_combo = NULL;
	KeyboardXkbModifier* _tmp32_;
	GtkComboBoxText* _tmp33_;
	GtkLabel* compose_key_label = NULL;
	GtkComboBoxText* _tmp34_;
	GtkLabel* _tmp35_;
	GtkComboBoxText* _tmp36_ = NULL;
	GtkComboBoxText* _tmp37_;
	GtkComboBoxText* _tmp38_;
	GtkComboBoxText* _tmp39_;
	GtkLabel* overlay_key_label = NULL;
	GtkComboBoxText* _tmp40_;
	GtkLabel* _tmp41_;
	gchar* cheatsheet_path = NULL;
	gchar* _tmp42_;
	const gchar* _tmp43_;
	GtkSizeGroup** _tmp45_;
	gint _tmp45__length1;
	GtkSizeGroup* _tmp46_;
	GtkComboBoxText* _tmp47_;
	KeyboardXkbModifier* _tmp48_;
	KeyboardXkbModifier* _tmp49_;
	KeyboardXkbModifier* _tmp50_;
	KeyboardXkbModifier* _tmp51_;
	KeyboardXkbModifier* _tmp52_;
	KeyboardXkbModifier* _tmp53_;
	KeyboardXkbModifier* _tmp54_;
	KeyboardXkbModifier* _tmp55_;
	KeyboardXkbModifier* _tmp56_;
	KeyboardXkbModifier* _tmp57_;
	KeyboardXkbModifier* _tmp58_;
	KeyboardSourceSettings* _tmp59_;
	KeyboardXkbModifier* _tmp60_;
	GtkComboBoxText* caps_lock_combo = NULL;
	KeyboardXkbModifier* _tmp61_;
	GtkComboBoxText* _tmp62_;
	GtkLabel* caps_lock_label = NULL;
	GtkComboBoxText* _tmp63_;
	GtkLabel* _tmp64_;
	GtkStack* _tmp65_ = NULL;
	GtkBox* blank_panel = NULL;
	GtkBox* _tmp66_;
	GtkStack* _tmp67_;
	GtkBox* _tmp68_;
	GtkBox* _tmp69_;
	AdvancedSettingsPanel* _tmp70_;
	AdvancedSettingsPanel* _tmp71_;
	AdvancedSettingsPanel* _tmp72_;
	AdvancedSettingsPanel* _tmp73_;
	AdvancedSettingsPanel** _tmp74_;
	GHashFunc _tmp75_;
	GEqualFunc _tmp76_;
	GHashTable* _tmp77_;
	AdvancedSettingsPanel** _tmp78_;
	gint _tmp78__length1;
	GtkEntry* _tmp96_ = NULL;
	KeyboardLayoutPageDisplay* _tmp97_;
	GtkLabel* _tmp98_;
	GtkComboBoxText* _tmp99_;
	GtkLabel* _tmp100_;
	GtkComboBoxText* _tmp101_;
	GtkLabel* _tmp102_;
	GtkComboBoxText* _tmp103_;
	GtkLabel* _tmp104_;
	GtkComboBoxText* _tmp105_;
	GtkStack* _tmp106_;
	GtkEntry* _tmp107_;
	KeyboardSourceSettings* _tmp108_;
	GSettings* _tmp109_;
	gchar* overlay_string = NULL;
	GSettings* _tmp110_;
	gchar* _tmp111_;
	const gchar* _tmp112_;
	const gchar* _tmp113_;
	GQuark _tmp115_ = 0U;
	static GQuark _tmp114_label0 = 0;
	static GQuark _tmp114_label1 = 0;
	static GQuark _tmp114_label2 = 0;
	static GQuark _tmp114_label3 = 0;
	GtkComboBoxText* _tmp120_;
	parent_class = G_OBJECT_CLASS (keyboard_layout_page_page_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, KEYBOARD_LAYOUT_PAGE_TYPE_PAGE, KeyboardLayoutPagePage);
	_data18_ = g_slice_new0 (Block18Data);
	_data18_->_ref_count_ = 1;
	_data18_->self = g_object_ref (self);
	_tmp0_ = keyboard_source_settings_get_instance ();
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);
	_tmp2_ = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);
	_tmp3_ = g_new0 (GtkSizeGroup*, 2 + 1);
	_tmp3_[0] = _tmp1_;
	_tmp3_[1] = _tmp2_;
	self->priv->size_group = (_vala_array_free (self->priv->size_group, self->priv->size_group_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->size_group = _tmp3_;
	self->priv->size_group_length1 = 2;
	self->priv->_size_group_size_ = self->priv->size_group_length1;
	_tmp4_ = keyboard_layout_page_display_new ();
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->display);
	self->priv->display = _tmp4_;
	_tmp5_ = keyboard_xkb_modifier_new ("switch-layout", "org.gnome.desktop.input-sources", "xkb-options");
	modifier = _tmp5_;
	_tmp6_ = modifier;
	keyboard_xkb_modifier_append_xkb_option (_tmp6_, "", _ ("Disabled"));
	_tmp7_ = modifier;
	keyboard_xkb_modifier_append_xkb_option (_tmp7_, "grp:alt_caps_toggle", _ ("Alt + Caps Lock"));
	_tmp8_ = modifier;
	keyboard_xkb_modifier_append_xkb_option (_tmp8_, "grp:alt_shift_toggle", _ ("Alt + Shift"));
	_tmp9_ = modifier;
	keyboard_xkb_modifier_append_xkb_option (_tmp9_, "grp:alt_space_toggle", _ ("Alt + Space"));
	_tmp10_ = modifier;
	keyboard_xkb_modifier_append_xkb_option (_tmp10_, "grp:shifts_toggle", _ ("Both Shift keys together"));
	_tmp11_ = modifier;
	keyboard_xkb_modifier_append_xkb_option (_tmp11_, "grp:caps_toggle", _ ("Caps Lock"));
	_tmp12_ = modifier;
	keyboard_xkb_modifier_append_xkb_option (_tmp12_, "grp:ctrl_alt_toggle", _ ("Ctrl + Alt"));
	_tmp13_ = modifier;
	keyboard_xkb_modifier_append_xkb_option (_tmp13_, "grp:ctrl_shift_toggle", _ ("Ctrl + Shift"));
	_tmp14_ = modifier;
	keyboard_xkb_modifier_append_xkb_option (_tmp14_, "grp:shift_caps_toggle", _ ("Shift + Caps Lock"));
	_tmp15_ = modifier;
	keyboard_xkb_modifier_set_default_command (_tmp15_, "");
	_tmp16_ = self->priv->settings;
	_tmp17_ = modifier;
	keyboard_source_settings_add_xkb_modifier (_tmp16_, _tmp17_);
	_tmp18_ = modifier;
	_tmp19_ = keyboard_layout_page_page_create_xkb_combobox (self, _tmp18_);
	switch_layout_combo = _tmp19_;
	_tmp20_ = switch_layout_combo;
	_tmp21_ = keyboard_layout_page_page_create_settings_label (self, _ ("Switch layout:"), (GtkWidget*) _tmp20_);
	switch_layout_label = _tmp21_;
	_tmp22_ = keyboard_xkb_modifier_new ("", "org.gnome.desktop.input-sources", "xkb-options");
	_g_object_unref0 (modifier);
	modifier = _tmp22_;
	_tmp23_ = modifier;
	keyboard_xkb_modifier_append_xkb_option (_tmp23_, "", _ ("Disabled"));
	_tmp24_ = modifier;
	keyboard_xkb_modifier_append_xkb_option (_tmp24_, "compose:caps", _ ("Caps Lock"));
	_tmp25_ = modifier;
	keyboard_xkb_modifier_append_xkb_option (_tmp25_, "compose:menu", _ ("Menu"));
	_tmp26_ = modifier;
	keyboard_xkb_modifier_append_xkb_option (_tmp26_, "compose:ralt", _ ("Right Alt"));
	_tmp27_ = modifier;
	keyboard_xkb_modifier_append_xkb_option (_tmp27_, "compose:rctrl", _ ("Right Ctrl"));
	_tmp28_ = modifier;
	keyboard_xkb_modifier_append_xkb_option (_tmp28_, "compose:rwin", _ ("Right ⌘"));
	_tmp29_ = modifier;
	keyboard_xkb_modifier_set_default_command (_tmp29_, "");
	_tmp30_ = self->priv->settings;
	_tmp31_ = modifier;
	keyboard_source_settings_add_xkb_modifier (_tmp30_, _tmp31_);
	_tmp32_ = modifier;
	_tmp33_ = keyboard_layout_page_page_create_xkb_combobox (self, _tmp32_);
	compose_key_combo = _tmp33_;
	_tmp34_ = compose_key_combo;
	_tmp35_ = keyboard_layout_page_page_create_settings_label (self, _ ("Compose key:"), (GtkWidget*) _tmp34_);
	compose_key_label = _tmp35_;
	_tmp36_ = (GtkComboBoxText*) gtk_combo_box_text_new ();
	gtk_widget_set_halign ((GtkWidget*) _tmp36_, GTK_ALIGN_START);
	g_object_ref_sink (_tmp36_);
	_data18_->overlay_key_combo = _tmp36_;
	_tmp37_ = _data18_->overlay_key_combo;
	gtk_combo_box_text_append_text (_tmp37_, _ ("Disabled"));
	_tmp38_ = _data18_->overlay_key_combo;
	gtk_combo_box_text_append_text (_tmp38_, _ ("Applications Menu"));
	_tmp39_ = _data18_->overlay_key_combo;
	gtk_combo_box_text_append_text (_tmp39_, _ ("Multitasking View"));
	_tmp40_ = _data18_->overlay_key_combo;
	_tmp41_ = keyboard_layout_page_page_create_settings_label (self, _ ("⌘ key behavior:"), (GtkWidget*) _tmp40_);
	overlay_key_label = _tmp41_;
	_tmp42_ = g_find_program_in_path ("io.elementary.shortcut-overlay");
	cheatsheet_path = _tmp42_;
	_tmp43_ = cheatsheet_path;
	if (_tmp43_ != NULL) {
		GtkComboBoxText* _tmp44_;
		_tmp44_ = _data18_->overlay_key_combo;
		gtk_combo_box_text_append_text (_tmp44_, _ ("Shortcut Overlay"));
	}
	_tmp45_ = self->priv->size_group;
	_tmp45__length1 = self->priv->size_group_length1;
	_tmp46_ = _tmp45_[1];
	_tmp47_ = _data18_->overlay_key_combo;
	gtk_size_group_add_widget (_tmp46_, (GtkWidget*) _tmp47_);
	_tmp48_ = keyboard_xkb_modifier_new ("", "org.gnome.desktop.input-sources", "xkb-options");
	_g_object_unref0 (modifier);
	modifier = _tmp48_;
	_tmp49_ = modifier;
	keyboard_xkb_modifier_append_xkb_option (_tmp49_, "", _ ("Default"));
	_tmp50_ = modifier;
	keyboard_xkb_modifier_append_xkb_option (_tmp50_, "caps:none", _ ("Disabled"));
	_tmp51_ = modifier;
	keyboard_xkb_modifier_append_xkb_option (_tmp51_, "caps:backspace", _ ("as Backspace"));
	_tmp52_ = modifier;
	keyboard_xkb_modifier_append_xkb_option (_tmp52_, "ctrl:nocaps", _ ("as Ctrl"));
	_tmp53_ = modifier;
	keyboard_xkb_modifier_append_xkb_option (_tmp53_, "caps:escape", _ ("as Escape"));
	_tmp54_ = modifier;
	keyboard_xkb_modifier_append_xkb_option (_tmp54_, "caps:numlock", _ ("as Num Lock"));
	_tmp55_ = modifier;
	keyboard_xkb_modifier_append_xkb_option (_tmp55_, "caps:super", _ ("as ⌘"));
	_tmp56_ = modifier;
	keyboard_xkb_modifier_append_xkb_option (_tmp56_, "ctrl:swapcaps", _ ("Swap with Ctrl"));
	_tmp57_ = modifier;
	keyboard_xkb_modifier_append_xkb_option (_tmp57_, "caps:swapescape", _ ("Swap with Escape"));
	_tmp58_ = modifier;
	keyboard_xkb_modifier_set_default_command (_tmp58_, "");
	_tmp59_ = self->priv->settings;
	_tmp60_ = modifier;
	keyboard_source_settings_add_xkb_modifier (_tmp59_, _tmp60_);
	_tmp61_ = modifier;
	_tmp62_ = keyboard_layout_page_page_create_xkb_combobox (self, _tmp61_);
	caps_lock_combo = _tmp62_;
	_tmp63_ = caps_lock_combo;
	_tmp64_ = keyboard_layout_page_page_create_settings_label (self, _ ("Caps Lock behavior:"), (GtkWidget*) _tmp63_);
	caps_lock_label = _tmp64_;
	_tmp65_ = (GtkStack*) gtk_stack_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp65_, TRUE);
	gtk_stack_set_vhomogeneous (_tmp65_, FALSE);
	g_object_ref_sink (_tmp65_);
	_g_object_unref0 (self->priv->stack);
	self->priv->stack = _tmp65_;
	_tmp66_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp66_);
	blank_panel = _tmp66_;
	_tmp67_ = self->priv->stack;
	_tmp68_ = blank_panel;
	gtk_stack_add_named (_tmp67_, (GtkWidget*) _tmp68_, "none");
	_tmp69_ = blank_panel;
	gtk_widget_show ((GtkWidget*) _tmp69_);
	_tmp70_ = keyboard_layout_page_page_fifth_level_layouts_panel (self);
	_tmp71_ = keyboard_layout_page_page_japanese_layouts_panel (self);
	_tmp72_ = keyboard_layout_page_page_korean_layouts_panel (self);
	_tmp73_ = keyboard_layout_page_page_third_level_layouts_panel (self);
	_tmp74_ = g_new0 (AdvancedSettingsPanel*, 4 + 1);
	_tmp74_[0] = _tmp70_;
	_tmp74_[1] = _tmp71_;
	_tmp74_[2] = _tmp72_;
	_tmp74_[3] = _tmp73_;
	self->priv->panels = (_vala_array_free (self->priv->panels, self->priv->panels_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->panels = _tmp74_;
	self->priv->panels_length1 = 4;
	self->priv->_panels_size_ = self->priv->panels_length1;
	_tmp75_ = g_str_hash;
	_tmp76_ = g_str_equal;
	_tmp77_ = g_hash_table_new_full (_tmp75_, _tmp76_, _g_free0_, _g_free0_);
	_g_hash_table_unref0 (self->priv->panel_for_layout);
	self->priv->panel_for_layout = _tmp77_;
	_tmp78_ = self->priv->panels;
	_tmp78__length1 = self->priv->panels_length1;
	{
		AdvancedSettingsPanel** panel_collection = NULL;
		gint panel_collection_length1 = 0;
		gint _panel_collection_size_ = 0;
		gint panel_it = 0;
		panel_collection = _tmp78_;
		panel_collection_length1 = _tmp78__length1;
		for (panel_it = 0; panel_it < panel_collection_length1; panel_it = panel_it + 1) {
			AdvancedSettingsPanel* panel = NULL;
			panel = panel_collection[panel_it];
			{
				GtkStack* _tmp79_;
				AdvancedSettingsPanel* _tmp80_;
				AdvancedSettingsPanel* _tmp81_;
				const gchar* _tmp82_;
				const gchar* _tmp83_;
				AdvancedSettingsPanel* _tmp84_;
				gchar** _tmp85_;
				gint _tmp85__length1;
				gint _tmp86_ = 0;
				gchar** _tmp87_;
				gint _tmp87__length1;
				_tmp79_ = self->priv->stack;
				_tmp80_ = panel;
				_tmp81_ = panel;
				_tmp82_ = advanced_settings_panel_get_panel_name (_tmp81_);
				_tmp83_ = _tmp82_;
				gtk_stack_add_named (_tmp79_, (GtkWidget*) _tmp80_, _tmp83_);
				_tmp84_ = panel;
				_tmp85_ = advanced_settings_panel_get_input_sources (_tmp84_, &_tmp86_);
				_tmp85__length1 = _tmp86_;
				_tmp87_ = _tmp85_;
				_tmp87__length1 = _tmp85__length1;
				{
					gchar** layout_name_collection = NULL;
					gint layout_name_collection_length1 = 0;
					gint _layout_name_collection_size_ = 0;
					gint layout_name_it = 0;
					layout_name_collection = _tmp87_;
					layout_name_collection_length1 = _tmp87__length1;
					for (layout_name_it = 0; layout_name_it < layout_name_collection_length1; layout_name_it = layout_name_it + 1) {
						gchar* _tmp88_;
						gchar* layout_name = NULL;
						_tmp88_ = g_strdup (layout_name_collection[layout_name_it]);
						layout_name = _tmp88_;
						{
							GHashTable* _tmp89_;
							const gchar* _tmp90_;
							gchar* _tmp91_;
							AdvancedSettingsPanel* _tmp92_;
							const gchar* _tmp93_;
							const gchar* _tmp94_;
							gchar* _tmp95_;
							_tmp89_ = self->priv->panel_for_layout;
							_tmp90_ = layout_name;
							_tmp91_ = g_strdup (_tmp90_);
							_tmp92_ = panel;
							_tmp93_ = advanced_settings_panel_get_panel_name (_tmp92_);
							_tmp94_ = _tmp93_;
							_tmp95_ = g_strdup (_tmp94_);
							g_hash_table_insert (_tmp89_, _tmp91_, _tmp95_);
							_g_free0 (layout_name);
						}
					}
				}
			}
		}
	}
	_tmp96_ = (GtkEntry*) gtk_entry_new ();
	gtk_widget_set_vexpand ((GtkWidget*) _tmp96_, TRUE);
	gtk_widget_set_valign ((GtkWidget*) _tmp96_, GTK_ALIGN_END);
	g_object_ref_sink (_tmp96_);
	_g_object_unref0 (self->priv->entry_test);
	self->priv->entry_test = _tmp96_;
	keyboard_layout_page_page_update_entry_test_usable (self);
	gtk_grid_set_column_homogeneous ((GtkGrid*) self, TRUE);
	gtk_grid_set_column_spacing ((GtkGrid*) self, 12);
	gtk_grid_set_row_spacing ((GtkGrid*) self, 12);
	gtk_widget_set_margin_start ((GtkWidget*) self, 12);
	gtk_widget_set_margin_end ((GtkWidget*) self, 12);
	gtk_widget_set_margin_bottom ((GtkWidget*) self, 12);
	gtk_widget_set_margin_top ((GtkWidget*) self, 12);
	_tmp97_ = self->priv->display;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp97_, 0, 0, 1, 12);
	_tmp98_ = switch_layout_label;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp98_, 1, 0, 1, 1);
	_tmp99_ = switch_layout_combo;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp99_, 2, 0, 1, 1);
	_tmp100_ = compose_key_label;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp100_, 1, 1, 1, 1);
	_tmp101_ = compose_key_combo;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp101_, 2, 1, 1, 1);
	_tmp102_ = overlay_key_label;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp102_, 1, 2, 1, 1);
	_tmp103_ = _data18_->overlay_key_combo;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp103_, 2, 2, 1, 1);
	_tmp104_ = caps_lock_label;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp104_, 1, 3, 1, 1);
	_tmp105_ = caps_lock_combo;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp105_, 2, 3, 1, 1);
	_tmp106_ = self->priv->stack;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp106_, 1, 4, 2, 1);
	_tmp107_ = self->priv->entry_test;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp107_, 1, 11, 2, 1);
	g_signal_connect_object ((GtkWidget*) self, "map", (GCallback) __keyboard_layout_page_page___lambda54__gtk_widget_map, self, 0);
	_tmp108_ = self->priv->settings;
	g_signal_connect_object ((GObject*) _tmp108_, "notify::active-index", (GCallback) __keyboard_layout_page_page___lambda55__g_object_notify, self, 0);
	_tmp109_ = g_settings_new ("io.elementary.desktop.wm.behavior");
	_data18_->gala_behavior_settings = _tmp109_;
	_tmp110_ = _data18_->gala_behavior_settings;
	_tmp111_ = g_settings_get_string (_tmp110_, "overlay-action");
	overlay_string = _tmp111_;
	_tmp112_ = overlay_string;
	_tmp113_ = _tmp112_;
	_tmp115_ = (NULL == _tmp113_) ? 0 : g_quark_from_string (_tmp113_);
	if (_tmp115_ == ((0 != _tmp114_label0) ? _tmp114_label0 : (_tmp114_label0 = g_quark_from_static_string ("")))) {
		switch (0) {
			default:
			{
				GtkComboBoxText* _tmp116_;
				_tmp116_ = _data18_->overlay_key_combo;
				gtk_combo_box_set_active ((GtkComboBox*) _tmp116_, 0);
				break;
			}
		}
	} else if (_tmp115_ == ((0 != _tmp114_label1) ? _tmp114_label1 : (_tmp114_label1 = g_quark_from_static_string ("io.elementary.wingpanel --toggle-indicator=app-launcher")))) {
		switch (0) {
			default:
			{
				GtkComboBoxText* _tmp117_;
				_tmp117_ = _data18_->overlay_key_combo;
				gtk_combo_box_set_active ((GtkComboBox*) _tmp117_, 1);
				break;
			}
		}
	} else if (_tmp115_ == ((0 != _tmp114_label2) ? _tmp114_label2 : (_tmp114_label2 = g_quark_from_static_string (KEYBOARD_LAYOUT_PAGE_PAGE_MULTITASKING_VIEW_COMMAND)))) {
		switch (0) {
			default:
			{
				GtkComboBoxText* _tmp118_;
				_tmp118_ = _data18_->overlay_key_combo;
				gtk_combo_box_set_active ((GtkComboBox*) _tmp118_, 2);
				break;
			}
		}
	} else if (_tmp115_ == ((0 != _tmp114_label3) ? _tmp114_label3 : (_tmp114_label3 = g_quark_from_static_string ("io.elementary.shortcut-overlay")))) {
		switch (0) {
			default:
			{
				GtkComboBoxText* _tmp119_;
				_tmp119_ = _data18_->overlay_key_combo;
				gtk_combo_box_set_active ((GtkComboBox*) _tmp119_, 3);
				break;
			}
		}
	}
	_tmp120_ = _data18_->overlay_key_combo;
	g_signal_connect_data ((GtkComboBox*) _tmp120_, "changed", (GCallback) __keyboard_layout_page_page___lambda56__gtk_combo_box_changed, block18_data_ref (_data18_), (GClosureNotify) block18_data_unref, 0);
	_g_free0 (overlay_string);
	_g_object_unref0 (blank_panel);
	_g_object_unref0 (caps_lock_label);
	_g_object_unref0 (caps_lock_combo);
	_g_free0 (cheatsheet_path);
	_g_object_unref0 (overlay_key_label);
	_g_object_unref0 (compose_key_label);
	_g_object_unref0 (compose_key_combo);
	_g_object_unref0 (switch_layout_label);
	_g_object_unref0 (switch_layout_combo);
	_g_object_unref0 (modifier);
	block18_data_unref (_data18_);
	_data18_ = NULL;
	return obj;
}

static void
keyboard_layout_page_page_class_init (KeyboardLayoutPagePageClass * klass,
                                      gpointer klass_data)
{
	keyboard_layout_page_page_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &KeyboardLayoutPagePage_private_offset);
	G_OBJECT_CLASS (klass)->constructor = keyboard_layout_page_page_constructor;
	G_OBJECT_CLASS (klass)->finalize = keyboard_layout_page_page_finalize;
}

static void
keyboard_layout_page_page_instance_init (KeyboardLayoutPagePage * self,
                                         gpointer klass)
{
	self->priv = keyboard_layout_page_page_get_instance_private (self);
}

static void
keyboard_layout_page_page_finalize (GObject * obj)
{
	KeyboardLayoutPagePage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, KEYBOARD_LAYOUT_PAGE_TYPE_PAGE, KeyboardLayoutPagePage);
	self->priv->panels = (_vala_array_free (self->priv->panels, self->priv->panels_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->display);
	_g_hash_table_unref0 (self->priv->panel_for_layout);
	_g_object_unref0 (self->priv->settings);
	self->priv->size_group = (_vala_array_free (self->priv->size_group, self->priv->size_group_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->entry_test);
	_g_object_unref0 (self->priv->stack);
	G_OBJECT_CLASS (keyboard_layout_page_page_parent_class)->finalize (obj);
}

static GType
keyboard_layout_page_page_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (KeyboardLayoutPagePageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) keyboard_layout_page_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KeyboardLayoutPagePage), 0, (GInstanceInitFunc) keyboard_layout_page_page_instance_init, NULL };
	GType keyboard_layout_page_page_type_id;
	keyboard_layout_page_page_type_id = g_type_register_static (gtk_grid_get_type (), "KeyboardLayoutPagePage", &g_define_type_info, 0);
	KeyboardLayoutPagePage_private_offset = g_type_add_instance_private (keyboard_layout_page_page_type_id, sizeof (KeyboardLayoutPagePagePrivate));
	return keyboard_layout_page_page_type_id;
}

GType
keyboard_layout_page_page_get_type (void)
{
	static volatile gsize keyboard_layout_page_page_type_id__once = 0;
	if (g_once_init_enter (&keyboard_layout_page_page_type_id__once)) {
		GType keyboard_layout_page_page_type_id;
		keyboard_layout_page_page_type_id = keyboard_layout_page_page_get_type_once ();
		g_once_init_leave (&keyboard_layout_page_page_type_id__once, keyboard_layout_page_page_type_id);
	}
	return keyboard_layout_page_page_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

