/* SettingsPage.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from SettingsPage.vala, do not modify */

/*
 * Copyright 2017–2024 elementary, Inc. (https://elementary.io)
 * SPDX-License-Identifier: LGPL-2.1-or-later
 */

#include "switchboard.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <adwaita.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <granite-7.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SWITCHBOARD_SETTINGS_PAGE_0_PROPERTY,
	SWITCHBOARD_SETTINGS_PAGE_STATUS_TYPE_PROPERTY,
	SWITCHBOARD_SETTINGS_PAGE_HEADER_PROPERTY,
	SWITCHBOARD_SETTINGS_PAGE_STATUS_PROPERTY,
	SWITCHBOARD_SETTINGS_PAGE_ICON_PROPERTY,
	SWITCHBOARD_SETTINGS_PAGE_TITLE_PROPERTY,
	SWITCHBOARD_SETTINGS_PAGE_CHILD_PROPERTY,
	SWITCHBOARD_SETTINGS_PAGE_STATUS_SWITCH_PROPERTY,
	SWITCHBOARD_SETTINGS_PAGE_ACTIVATABLE_PROPERTY,
	SWITCHBOARD_SETTINGS_PAGE_WITH_AVATAR_PROPERTY,
	SWITCHBOARD_SETTINGS_PAGE_AVATAR_PAINTABLE_PROPERTY,
	SWITCHBOARD_SETTINGS_PAGE_DESCRIPTION_PROPERTY,
	SWITCHBOARD_SETTINGS_PAGE_SHOW_END_TITLE_BUTTONS_PROPERTY,
	SWITCHBOARD_SETTINGS_PAGE_NUM_PROPERTIES
};
static GParamSpec* switchboard_settings_page_properties[SWITCHBOARD_SETTINGS_PAGE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;

struct _SwitchboardSettingsPagePrivate {
	SwitchboardSettingsPageStatusType _status_type;
	gchar* _header;
	gchar* _status;
	GIcon* _icon;
	gchar* _title;
	GtkSwitch* _status_switch;
	gboolean _activatable;
	gboolean _with_avatar;
	GdkPaintable* _avatar_paintable;
	gchar* _description;
	gboolean _show_end_title_buttons;
	AdwClamp* content_area;
	GtkActionBar* action_bar;
	GtkSizeGroup* start_button_group;
	GtkSizeGroup* end_button_group;
};

struct _Block1Data {
	int _ref_count_;
	SwitchboardSettingsPage* self;
	GtkWidget* header_widget;
	GtkLabel* description_label;
	GtkGrid* header_area;
};

static gint SwitchboardSettingsPage_private_offset;
static gpointer switchboard_settings_page_parent_class = NULL;

static GObject * switchboard_settings_page_constructor (GType type,
                                                 guint n_construct_properties,
                                                 GObjectConstructParam * construct_properties);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void _switchboard_settings_page___lambda4_ (Block1Data* _data1_);
static void __switchboard_settings_page___lambda4__g_object_notify (GObject* _sender,
                                                             GParamSpec* pspec,
                                                             gpointer self);
static void switchboard_settings_page_finalize (GObject * obj);
static GType switchboard_settings_page_get_type_once (void);
static void _vala_switchboard_settings_page_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec);
static void _vala_switchboard_settings_page_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec);

static inline gpointer
switchboard_settings_page_get_instance_private (SwitchboardSettingsPage* self)
{
	return G_STRUCT_MEMBER_P (self, SwitchboardSettingsPage_private_offset);
}

/**
     * Used to display a status icon overlayed on the display_widget in a Granite.SettingsSidebar
     */
static GType
switchboard_settings_page_status_type_get_type_once (void)
{
	static const GEnumValue values[] = {{SWITCHBOARD_SETTINGS_PAGE_STATUS_TYPE_ERROR, "SWITCHBOARD_SETTINGS_PAGE_STATUS_TYPE_ERROR", "error"}, {SWITCHBOARD_SETTINGS_PAGE_STATUS_TYPE_OFFLINE, "SWITCHBOARD_SETTINGS_PAGE_STATUS_TYPE_OFFLINE", "offline"}, {SWITCHBOARD_SETTINGS_PAGE_STATUS_TYPE_SUCCESS, "SWITCHBOARD_SETTINGS_PAGE_STATUS_TYPE_SUCCESS", "success"}, {SWITCHBOARD_SETTINGS_PAGE_STATUS_TYPE_WARNING, "SWITCHBOARD_SETTINGS_PAGE_STATUS_TYPE_WARNING", "warning"}, {SWITCHBOARD_SETTINGS_PAGE_STATUS_TYPE_NONE, "SWITCHBOARD_SETTINGS_PAGE_STATUS_TYPE_NONE", "none"}, {0, NULL, NULL}};
	GType switchboard_settings_page_status_type_type_id;
	switchboard_settings_page_status_type_type_id = g_enum_register_static ("SwitchboardSettingsPageStatusType", values);
	return switchboard_settings_page_status_type_type_id;
}

GType
switchboard_settings_page_status_type_get_type (void)
{
	static volatile gsize switchboard_settings_page_status_type_type_id__once = 0;
	if (g_once_init_enter (&switchboard_settings_page_status_type_type_id__once)) {
		GType switchboard_settings_page_status_type_type_id;
		switchboard_settings_page_status_type_type_id = switchboard_settings_page_status_type_get_type_once ();
		g_once_init_leave (&switchboard_settings_page_status_type_type_id__once, switchboard_settings_page_status_type_type_id);
	}
	return switchboard_settings_page_status_type_type_id__once;
}

GtkButton*
switchboard_settings_page_add_start_button (SwitchboardSettingsPage* self,
                                            const gchar* label)
{
	GtkButton* button = NULL;
	GtkButton* _tmp0_;
	GtkActionBar* _tmp1_;
	GtkActionBar* _tmp2_;
	GtkSizeGroup* _tmp3_;
	GtkButton* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (label != NULL, NULL);
	_tmp0_ = (GtkButton*) gtk_button_new_with_label (label);
	g_object_ref_sink (_tmp0_);
	button = _tmp0_;
	_tmp1_ = self->priv->action_bar;
	gtk_action_bar_pack_start (_tmp1_, (GtkWidget*) button);
	_tmp2_ = self->priv->action_bar;
	gtk_action_bar_set_revealed (_tmp2_, TRUE);
	_tmp3_ = self->priv->start_button_group;
	gtk_size_group_add_widget (_tmp3_, (GtkWidget*) button);
	result = button;
	return result;
}

GtkButton*
switchboard_settings_page_add_button (SwitchboardSettingsPage* self,
                                      const gchar* label)
{
	GtkButton* button = NULL;
	GtkButton* _tmp0_;
	GtkActionBar* _tmp1_;
	GtkActionBar* _tmp2_;
	GtkSizeGroup* _tmp3_;
	GtkButton* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (label != NULL, NULL);
	_tmp0_ = (GtkButton*) gtk_button_new_with_label (label);
	g_object_ref_sink (_tmp0_);
	button = _tmp0_;
	_tmp1_ = self->priv->action_bar;
	gtk_action_bar_pack_end (_tmp1_, (GtkWidget*) button);
	_tmp2_ = self->priv->action_bar;
	gtk_action_bar_set_revealed (_tmp2_, TRUE);
	_tmp3_ = self->priv->end_button_group;
	gtk_size_group_add_widget (_tmp3_, (GtkWidget*) button);
	result = button;
	return result;
}

SwitchboardSettingsPage*
switchboard_settings_page_construct (GType object_type)
{
	SwitchboardSettingsPage * self = NULL;
	self = (SwitchboardSettingsPage*) g_object_new (object_type, NULL);
	return self;
}

SwitchboardSettingsPageStatusType
switchboard_settings_page_get_status_type (SwitchboardSettingsPage* self)
{
	SwitchboardSettingsPageStatusType result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_status_type;
	return result;
}

void
switchboard_settings_page_set_status_type (SwitchboardSettingsPage* self,
                                           SwitchboardSettingsPageStatusType value)
{
	SwitchboardSettingsPageStatusType old_value;
	g_return_if_fail (self != NULL);
	old_value = switchboard_settings_page_get_status_type (self);
	if (old_value != value) {
		self->priv->_status_type = value;
		g_object_notify_by_pspec ((GObject *) self, switchboard_settings_page_properties[SWITCHBOARD_SETTINGS_PAGE_STATUS_TYPE_PROPERTY]);
	}
}

const gchar*
switchboard_settings_page_get_header (SwitchboardSettingsPage* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_header;
	result = _tmp0_;
	return result;
}

static void
switchboard_settings_page_set_header (SwitchboardSettingsPage* self,
                                      const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = switchboard_settings_page_get_header (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_header);
		self->priv->_header = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, switchboard_settings_page_properties[SWITCHBOARD_SETTINGS_PAGE_HEADER_PROPERTY]);
	}
}

const gchar*
switchboard_settings_page_get_status (SwitchboardSettingsPage* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_status;
	result = _tmp0_;
	return result;
}

void
switchboard_settings_page_set_status (SwitchboardSettingsPage* self,
                                      const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = switchboard_settings_page_get_status (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_status);
		self->priv->_status = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, switchboard_settings_page_properties[SWITCHBOARD_SETTINGS_PAGE_STATUS_PROPERTY]);
	}
}

GIcon*
switchboard_settings_page_get_icon (SwitchboardSettingsPage* self)
{
	GIcon* result;
	GIcon* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_icon;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
switchboard_settings_page_set_icon (SwitchboardSettingsPage* self,
                                    GIcon* value)
{
	GIcon* old_value;
	g_return_if_fail (self != NULL);
	old_value = switchboard_settings_page_get_icon (self);
	if (old_value != value) {
		GIcon* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_icon);
		self->priv->_icon = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, switchboard_settings_page_properties[SWITCHBOARD_SETTINGS_PAGE_ICON_PROPERTY]);
	}
}

const gchar*
switchboard_settings_page_get_title (SwitchboardSettingsPage* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_title;
	result = _tmp0_;
	return result;
}

void
switchboard_settings_page_set_title (SwitchboardSettingsPage* self,
                                     const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = switchboard_settings_page_get_title (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_title);
		self->priv->_title = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, switchboard_settings_page_properties[SWITCHBOARD_SETTINGS_PAGE_TITLE_PROPERTY]);
	}
}

GtkWidget*
switchboard_settings_page_get_child (SwitchboardSettingsPage* self)
{
	GtkWidget* result;
	AdwClamp* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->content_area;
	_tmp1_ = adw_clamp_get_child (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
switchboard_settings_page_set_child (SwitchboardSettingsPage* self,
                                     GtkWidget* value)
{
	AdwClamp* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->content_area;
	adw_clamp_set_child (_tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, switchboard_settings_page_properties[SWITCHBOARD_SETTINGS_PAGE_CHILD_PROPERTY]);
}

GtkSwitch*
switchboard_settings_page_get_status_switch (SwitchboardSettingsPage* self)
{
	GtkSwitch* result;
	GtkSwitch* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_status_switch;
	result = _tmp0_;
	return result;
}

static void
switchboard_settings_page_set_status_switch (SwitchboardSettingsPage* self,
                                             GtkSwitch* value)
{
	GtkSwitch* old_value;
	g_return_if_fail (self != NULL);
	old_value = switchboard_settings_page_get_status_switch (self);
	if (old_value != value) {
		GtkSwitch* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_status_switch);
		self->priv->_status_switch = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, switchboard_settings_page_properties[SWITCHBOARD_SETTINGS_PAGE_STATUS_SWITCH_PROPERTY]);
	}
}

gboolean
switchboard_settings_page_get_activatable (SwitchboardSettingsPage* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_activatable;
	return result;
}

static void
switchboard_settings_page_set_activatable (SwitchboardSettingsPage* self,
                                           gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = switchboard_settings_page_get_activatable (self);
	if (old_value != value) {
		self->priv->_activatable = value;
		g_object_notify_by_pspec ((GObject *) self, switchboard_settings_page_properties[SWITCHBOARD_SETTINGS_PAGE_ACTIVATABLE_PROPERTY]);
	}
}

gboolean
switchboard_settings_page_get_with_avatar (SwitchboardSettingsPage* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_with_avatar;
	return result;
}

static void
switchboard_settings_page_set_with_avatar (SwitchboardSettingsPage* self,
                                           gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = switchboard_settings_page_get_with_avatar (self);
	if (old_value != value) {
		self->priv->_with_avatar = value;
		g_object_notify_by_pspec ((GObject *) self, switchboard_settings_page_properties[SWITCHBOARD_SETTINGS_PAGE_WITH_AVATAR_PROPERTY]);
	}
}

GdkPaintable*
switchboard_settings_page_get_avatar_paintable (SwitchboardSettingsPage* self)
{
	GdkPaintable* result;
	GdkPaintable* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_avatar_paintable;
	result = _tmp0_;
	return result;
}

void
switchboard_settings_page_set_avatar_paintable (SwitchboardSettingsPage* self,
                                                GdkPaintable* value)
{
	GdkPaintable* old_value;
	g_return_if_fail (self != NULL);
	old_value = switchboard_settings_page_get_avatar_paintable (self);
	if (old_value != value) {
		GdkPaintable* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_avatar_paintable);
		self->priv->_avatar_paintable = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, switchboard_settings_page_properties[SWITCHBOARD_SETTINGS_PAGE_AVATAR_PAINTABLE_PROPERTY]);
	}
}

const gchar*
switchboard_settings_page_get_description (SwitchboardSettingsPage* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_description;
	result = _tmp0_;
	return result;
}

void
switchboard_settings_page_set_description (SwitchboardSettingsPage* self,
                                           const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = switchboard_settings_page_get_description (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_description);
		self->priv->_description = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, switchboard_settings_page_properties[SWITCHBOARD_SETTINGS_PAGE_DESCRIPTION_PROPERTY]);
	}
}

gboolean
switchboard_settings_page_get_show_end_title_buttons (SwitchboardSettingsPage* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_show_end_title_buttons;
	return result;
}

void
switchboard_settings_page_set_show_end_title_buttons (SwitchboardSettingsPage* self,
                                                      gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = switchboard_settings_page_get_show_end_title_buttons (self);
	if (old_value != value) {
		self->priv->_show_end_title_buttons = value;
		g_object_notify_by_pspec ((GObject *) self, switchboard_settings_page_properties[SWITCHBOARD_SETTINGS_PAGE_SHOW_END_TITLE_BUTTONS_PROPERTY]);
	}
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		SwitchboardSettingsPage* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->header_area);
		_g_object_unref0 (_data1_->description_label);
		_g_object_unref0 (_data1_->header_widget);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
_switchboard_settings_page___lambda4_ (Block1Data* _data1_)
{
	SwitchboardSettingsPage* self;
	GtkLabel* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	self = _data1_->self;
	_tmp0_ = _data1_->description_label;
	_tmp1_ = gtk_widget_get_parent ((GtkWidget*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		GtkGrid* _tmp3_;
		GtkWidget* _tmp4_;
		GtkGrid* _tmp5_;
		GtkWidget* _tmp6_;
		GtkGrid* _tmp7_;
		GtkLabel* _tmp8_;
		_tmp3_ = _data1_->header_area;
		_tmp4_ = _data1_->header_widget;
		gtk_grid_remove (_tmp3_, _tmp4_);
		_tmp5_ = _data1_->header_area;
		_tmp6_ = _data1_->header_widget;
		gtk_grid_attach (_tmp5_, _tmp6_, 0, 0, 1, 2);
		_tmp7_ = _data1_->header_area;
		_tmp8_ = _data1_->description_label;
		gtk_grid_attach (_tmp7_, (GtkWidget*) _tmp8_, 1, 1, 2, 1);
	}
}

static void
__switchboard_settings_page___lambda4__g_object_notify (GObject* _sender,
                                                        GParamSpec* pspec,
                                                        gpointer self)
{
	_switchboard_settings_page___lambda4_ (self);
}

static GObject *
switchboard_settings_page_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SwitchboardSettingsPage * self;
	Block1Data* _data1_;
	gboolean _tmp0_;
	GtkLabel* title_label = NULL;
	const gchar* _tmp8_;
	GtkLabel* _tmp9_ = NULL;
	GtkLabel* _tmp10_;
	const gchar* _tmp11_;
	GtkLabel* _tmp12_ = NULL;
	GtkGrid* _tmp13_;
	GtkGrid* _tmp14_;
	GtkLabel* _tmp15_;
	const gchar* _tmp16_;
	gboolean _tmp23_;
	GtkWindowControls* end_widget = NULL;
	GtkWindowControls* _tmp28_ = NULL;
	AdwClamp* header_clamp = NULL;
	GtkGrid* _tmp29_;
	GtkWidget* _tmp30_;
	AdwClamp* _tmp31_ = NULL;
	AdwClamp* _tmp32_;
	GtkCenterBox* headerbar = NULL;
	AdwClamp* _tmp33_;
	GtkWidget* _tmp34_;
	GtkWindowControls* _tmp35_;
	GtkWidget* _tmp36_;
	GtkCenterBox* _tmp37_ = NULL;
	GtkWindowHandle* window_handle = NULL;
	GtkCenterBox* _tmp38_;
	GtkWidget* _tmp39_;
	GtkWindowHandle* _tmp40_ = NULL;
	AdwClamp* _tmp41_ = NULL;
	AdwClamp* _tmp42_;
	GtkScrolledWindow* scrolled = NULL;
	AdwClamp* _tmp43_;
	GtkWidget* _tmp44_;
	GtkScrolledWindow* _tmp45_ = NULL;
	GtkSizeGroup* _tmp46_;
	GtkSizeGroup* _tmp47_;
	GtkActionBar* _tmp48_ = NULL;
	GtkActionBar* _tmp49_;
	GtkLayoutManager* _tmp50_;
	GtkWindowHandle* _tmp51_;
	GtkScrolledWindow* _tmp52_;
	GtkActionBar* _tmp53_;
	GtkLabel* _tmp54_;
	GtkLabel* _tmp55_;
	GtkWindowControls* _tmp56_;
	parent_class = G_OBJECT_CLASS (switchboard_settings_page_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SWITCHBOARD_TYPE_SETTINGS_PAGE, SwitchboardSettingsPage);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = self->priv->_with_avatar;
	if (!_tmp0_) {
		GIcon* _tmp1_;
		GtkImage* _tmp2_ = NULL;
		GtkWidget* _tmp3_;
		_tmp1_ = self->priv->_icon;
		_tmp2_ = (GtkImage*) gtk_image_new_from_gicon (_tmp1_);
		gtk_image_set_icon_size (_tmp2_, GTK_ICON_SIZE_LARGE);
		gtk_widget_set_valign ((GtkWidget*) _tmp2_, GTK_ALIGN_START);
		g_object_ref_sink (_tmp2_);
		_g_object_unref0 (_data1_->header_widget);
		_data1_->header_widget = (GtkWidget*) _tmp2_;
		_tmp3_ = _data1_->header_widget;
		g_object_bind_property_with_closures ((GObject*) self, "icon", (GObject*) _tmp3_, "gicon", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	} else {
		const gchar* _tmp4_;
		AdwAvatar* _tmp5_ = NULL;
		GtkWidget* _tmp6_;
		GtkWidget* _tmp7_;
		_tmp4_ = self->priv->_title;
		_tmp5_ = (AdwAvatar*) adw_avatar_new (48, _tmp4_, TRUE);
		gtk_widget_set_valign ((GtkWidget*) _tmp5_, GTK_ALIGN_START);
		g_object_ref_sink (_tmp5_);
		_g_object_unref0 (_data1_->header_widget);
		_data1_->header_widget = (GtkWidget*) _tmp5_;
		_tmp6_ = _data1_->header_widget;
		g_object_bind_property_with_closures ((GObject*) self, "avatar-paintable", (GObject*) _tmp6_, "custom-image", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
		_tmp7_ = _data1_->header_widget;
		g_object_bind_property_with_closures ((GObject*) self, "title", (GObject*) _tmp7_, "text", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	}
	_tmp8_ = self->priv->_title;
	_tmp9_ = (GtkLabel*) gtk_label_new (_tmp8_);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp9_, TRUE);
	gtk_label_set_wrap (_tmp9_, TRUE);
	gtk_label_set_xalign (_tmp9_, (gfloat) 0);
	g_object_ref_sink (_tmp9_);
	title_label = _tmp9_;
	_tmp10_ = title_label;
	gtk_widget_add_css_class ((GtkWidget*) _tmp10_, GRANITE_STYLE_CLASS_H2_LABEL);
	_tmp11_ = self->priv->_description;
	_tmp12_ = (GtkLabel*) gtk_label_new (_tmp11_);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp12_, TRUE);
	gtk_label_set_max_width_chars (_tmp12_, 0);
	gtk_label_set_selectable (_tmp12_, TRUE);
	gtk_label_set_use_markup (_tmp12_, TRUE);
	gtk_label_set_wrap (_tmp12_, TRUE);
	gtk_label_set_xalign (_tmp12_, (gfloat) 0);
	g_object_ref_sink (_tmp12_);
	_data1_->description_label = _tmp12_;
	_tmp13_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp13_);
	_data1_->header_area = _tmp13_;
	_tmp14_ = _data1_->header_area;
	_tmp15_ = title_label;
	gtk_grid_attach (_tmp14_, (GtkWidget*) _tmp15_, 1, 0, 1, 1);
	_tmp16_ = self->priv->_description;
	if (_tmp16_ != NULL) {
		GtkGrid* _tmp17_;
		GtkWidget* _tmp18_;
		GtkGrid* _tmp19_;
		GtkLabel* _tmp20_;
		_tmp17_ = _data1_->header_area;
		_tmp18_ = _data1_->header_widget;
		gtk_grid_attach (_tmp17_, _tmp18_, 0, 0, 1, 2);
		_tmp19_ = _data1_->header_area;
		_tmp20_ = _data1_->description_label;
		gtk_grid_attach (_tmp19_, (GtkWidget*) _tmp20_, 1, 1, 2, 1);
	} else {
		GtkGrid* _tmp21_;
		GtkWidget* _tmp22_;
		_tmp21_ = _data1_->header_area;
		_tmp22_ = _data1_->header_widget;
		gtk_grid_attach (_tmp21_, _tmp22_, 0, 0, 1, 1);
	}
	_tmp23_ = self->priv->_activatable;
	if (_tmp23_) {
		GtkSwitch* _tmp24_ = NULL;
		GtkSwitch* _tmp25_;
		GtkGrid* _tmp26_;
		GtkSwitch* _tmp27_;
		_tmp24_ = (GtkSwitch*) gtk_switch_new ();
		gtk_widget_set_valign ((GtkWidget*) _tmp24_, GTK_ALIGN_START);
		g_object_ref_sink (_tmp24_);
		_tmp25_ = _tmp24_;
		switchboard_settings_page_set_status_switch (self, _tmp25_);
		_g_object_unref0 (_tmp25_);
		_tmp26_ = _data1_->header_area;
		_tmp27_ = self->priv->_status_switch;
		gtk_grid_attach (_tmp26_, (GtkWidget*) _tmp27_, 2, 0, 1, 1);
	}
	_tmp28_ = (GtkWindowControls*) gtk_window_controls_new (GTK_PACK_END);
	gtk_widget_set_valign ((GtkWidget*) _tmp28_, GTK_ALIGN_START);
	g_object_ref_sink (_tmp28_);
	end_widget = _tmp28_;
	_tmp29_ = _data1_->header_area;
	_tmp30_ = _g_object_ref0 ((GtkWidget*) _tmp29_);
	_tmp31_ = (AdwClamp*) adw_clamp_new ();
	adw_clamp_set_child (_tmp31_, _tmp30_);
	_g_object_unref0 (_tmp30_);
	adw_clamp_set_maximum_size (_tmp31_, 600);
	adw_clamp_set_tightening_threshold (_tmp31_, 600);
	g_object_ref_sink (_tmp31_);
	header_clamp = _tmp31_;
	_tmp32_ = header_clamp;
	gtk_widget_add_css_class ((GtkWidget*) _tmp32_, "header-area");
	_tmp33_ = header_clamp;
	_tmp34_ = _g_object_ref0 ((GtkWidget*) _tmp33_);
	_tmp35_ = end_widget;
	_tmp36_ = _g_object_ref0 ((GtkWidget*) _tmp35_);
	_tmp37_ = (GtkCenterBox*) gtk_center_box_new ();
	gtk_center_box_set_center_widget (_tmp37_, _tmp34_);
	_g_object_unref0 (_tmp34_);
	gtk_center_box_set_end_widget (_tmp37_, _tmp36_);
	_g_object_unref0 (_tmp36_);
	g_object_ref_sink (_tmp37_);
	headerbar = _tmp37_;
	_tmp38_ = headerbar;
	_tmp39_ = _g_object_ref0 ((GtkWidget*) _tmp38_);
	_tmp40_ = (GtkWindowHandle*) gtk_window_handle_new ();
	gtk_window_handle_set_child (_tmp40_, _tmp39_);
	_g_object_unref0 (_tmp39_);
	g_object_ref_sink (_tmp40_);
	window_handle = _tmp40_;
	_tmp41_ = (AdwClamp*) adw_clamp_new ();
	adw_clamp_set_maximum_size (_tmp41_, 600);
	adw_clamp_set_tightening_threshold (_tmp41_, 600);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp41_, TRUE);
	g_object_ref_sink (_tmp41_);
	_g_object_unref0 (self->priv->content_area);
	self->priv->content_area = _tmp41_;
	_tmp42_ = self->priv->content_area;
	gtk_widget_add_css_class ((GtkWidget*) _tmp42_, "content-area");
	_tmp43_ = self->priv->content_area;
	_tmp44_ = _g_object_ref0 ((GtkWidget*) _tmp43_);
	_tmp45_ = (GtkScrolledWindow*) gtk_scrolled_window_new ();
	gtk_scrolled_window_set_child (_tmp45_, _tmp44_);
	_g_object_unref0 (_tmp44_);
	g_object_set (_tmp45_, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);
	g_object_ref_sink (_tmp45_);
	scrolled = _tmp45_;
	_tmp46_ = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);
	_g_object_unref0 (self->priv->start_button_group);
	self->priv->start_button_group = _tmp46_;
	_tmp47_ = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);
	_g_object_unref0 (self->priv->end_button_group);
	self->priv->end_button_group = _tmp47_;
	_tmp48_ = (GtkActionBar*) gtk_action_bar_new ();
	gtk_action_bar_set_revealed (_tmp48_, FALSE);
	g_object_ref_sink (_tmp48_);
	_g_object_unref0 (self->priv->action_bar);
	self->priv->action_bar = _tmp48_;
	_tmp49_ = self->priv->action_bar;
	gtk_widget_add_css_class ((GtkWidget*) _tmp49_, "action-area");
	_tmp50_ = gtk_widget_get_layout_manager ((GtkWidget*) self);
	gtk_orientable_set_orientation ((GtkOrientable*) G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, gtk_box_layout_get_type (), GtkBoxLayout), GTK_ORIENTATION_VERTICAL);
	_tmp51_ = window_handle;
	gtk_widget_set_parent ((GtkWidget*) _tmp51_, (GtkWidget*) self);
	_tmp52_ = scrolled;
	gtk_widget_set_parent ((GtkWidget*) _tmp52_, (GtkWidget*) self);
	_tmp53_ = self->priv->action_bar;
	gtk_widget_set_parent ((GtkWidget*) _tmp53_, (GtkWidget*) self);
	_tmp54_ = _data1_->description_label;
	g_object_bind_property_with_closures ((GObject*) self, "description", (GObject*) _tmp54_, "label", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp55_ = title_label;
	g_object_bind_property_with_closures ((GObject*) self, "title", (GObject*) _tmp55_, "label", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp56_ = end_widget;
	g_object_bind_property_with_closures ((GObject*) self, "show-end-title-buttons", (GObject*) _tmp56_, "visible", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	g_signal_connect_data ((GObject*) self, "notify::description", (GCallback) __switchboard_settings_page___lambda4__g_object_notify, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_g_object_unref0 (scrolled);
	_g_object_unref0 (window_handle);
	_g_object_unref0 (headerbar);
	_g_object_unref0 (header_clamp);
	_g_object_unref0 (end_widget);
	_g_object_unref0 (title_label);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return obj;
}

static void
switchboard_settings_page_base_init (SwitchboardSettingsPageClass * klass)
{
	gtk_widget_class_set_css_name (GTK_WIDGET_CLASS (klass), "settingspage");
}

static void
switchboard_settings_page_class_init (SwitchboardSettingsPageClass * klass,
                                      gpointer klass_data)
{
	switchboard_settings_page_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SwitchboardSettingsPage_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_switchboard_settings_page_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_switchboard_settings_page_set_property;
	G_OBJECT_CLASS (klass)->constructor = switchboard_settings_page_constructor;
	G_OBJECT_CLASS (klass)->finalize = switchboard_settings_page_finalize;
	/**
	     * Selects a colored icon to be displayed in a Granite.SettingsSidebar
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWITCHBOARD_SETTINGS_PAGE_STATUS_TYPE_PROPERTY, switchboard_settings_page_properties[SWITCHBOARD_SETTINGS_PAGE_STATUS_TYPE_PROPERTY] = g_param_spec_enum ("status-type", "status-type", "status-type", SWITCHBOARD_SETTINGS_PAGE_TYPE_STATUS_TYPE, SWITCHBOARD_SETTINGS_PAGE_STATUS_TYPE_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * A header to be sorted under in a Granite.SettingsSidebar
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWITCHBOARD_SETTINGS_PAGE_HEADER_PROPERTY, switchboard_settings_page_properties[SWITCHBOARD_SETTINGS_PAGE_HEADER_PROPERTY] = g_param_spec_string ("header", "header", "header", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	     * A status string to be displayed underneath the title in a Granite.SettingsSidebar
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWITCHBOARD_SETTINGS_PAGE_STATUS_PROPERTY, switchboard_settings_page_properties[SWITCHBOARD_SETTINGS_PAGE_STATUS_PROPERTY] = g_param_spec_string ("status", "status", "status", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	     * An icon to be displayed in the header and sidebar
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWITCHBOARD_SETTINGS_PAGE_ICON_PROPERTY, switchboard_settings_page_properties[SWITCHBOARD_SETTINGS_PAGE_ICON_PROPERTY] = g_param_spec_object ("icon", "icon", "icon", g_icon_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	     * A title to be displayed in a Granite.SettingsSidebar
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWITCHBOARD_SETTINGS_PAGE_TITLE_PROPERTY, switchboard_settings_page_properties[SWITCHBOARD_SETTINGS_PAGE_TITLE_PROPERTY] = g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	     * The child widget for the content area
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWITCHBOARD_SETTINGS_PAGE_CHILD_PROPERTY, switchboard_settings_page_properties[SWITCHBOARD_SETTINGS_PAGE_CHILD_PROPERTY] = g_param_spec_object ("child", "child", "child", gtk_widget_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * A {@link Gtk.Switch} that appears in the header area when #this.activatable is #true. #status_switch will be #null when #this.activatable is #false
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWITCHBOARD_SETTINGS_PAGE_STATUS_SWITCH_PROPERTY, switchboard_settings_page_properties[SWITCHBOARD_SETTINGS_PAGE_STATUS_SWITCH_PROPERTY] = g_param_spec_object ("status-switch", "status-switch", "status-switch", gtk_switch_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	     * Creates a {@link Gtk.Switch} #status_switch in the header of #this
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWITCHBOARD_SETTINGS_PAGE_ACTIVATABLE_PROPERTY, switchboard_settings_page_properties[SWITCHBOARD_SETTINGS_PAGE_ACTIVATABLE_PROPERTY] = g_param_spec_boolean ("activatable", "activatable", "activatable", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	     * Creates a {@link Adw.Avatar} to use instead of #icon
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWITCHBOARD_SETTINGS_PAGE_WITH_AVATAR_PROPERTY, switchboard_settings_page_properties[SWITCHBOARD_SETTINGS_PAGE_WITH_AVATAR_PROPERTY] = g_param_spec_boolean ("with-avatar", "with-avatar", "with-avatar", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	     * Custom image to use with avatar
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWITCHBOARD_SETTINGS_PAGE_AVATAR_PAINTABLE_PROPERTY, switchboard_settings_page_properties[SWITCHBOARD_SETTINGS_PAGE_AVATAR_PAINTABLE_PROPERTY] = g_param_spec_object ("avatar-paintable", "avatar-paintable", "avatar-paintable", gdk_paintable_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Creates a {@link Gtk.Label} with a page description in the header of #this
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWITCHBOARD_SETTINGS_PAGE_DESCRIPTION_PROPERTY, switchboard_settings_page_properties[SWITCHBOARD_SETTINGS_PAGE_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	     * Whether to show title buttons at the end of the header area
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWITCHBOARD_SETTINGS_PAGE_SHOW_END_TITLE_BUTTONS_PROPERTY, switchboard_settings_page_properties[SWITCHBOARD_SETTINGS_PAGE_SHOW_END_TITLE_BUTTONS_PROPERTY] = g_param_spec_boolean ("show-end-title-buttons", "show-end-title-buttons", "show-end-title-buttons", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gtk_widget_class_set_layout_manager_type (GTK_WIDGET_CLASS (klass), gtk_box_layout_get_type ());
}

static void
switchboard_settings_page_instance_init (SwitchboardSettingsPage * self,
                                         gpointer klass)
{
	GThemedIcon* _tmp0_;
	self->priv = switchboard_settings_page_get_instance_private (self);
	self->priv->_status_type = SWITCHBOARD_SETTINGS_PAGE_STATUS_TYPE_NONE;
	_tmp0_ = (GThemedIcon*) g_themed_icon_new ("preferences-other");
	self->priv->_icon = (GIcon*) _tmp0_;
	self->priv->_activatable = FALSE;
	self->priv->_with_avatar = FALSE;
}

static void
switchboard_settings_page_finalize (GObject * obj)
{
	SwitchboardSettingsPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SWITCHBOARD_TYPE_SETTINGS_PAGE, SwitchboardSettingsPage);
	while (TRUE) {
		GtkWidget* _tmp0_;
		GtkWidget* _tmp1_;
		_tmp0_ = gtk_widget_get_first_child ((GtkWidget*) self);
		if (!(_tmp0_ != NULL)) {
			break;
		}
		_tmp1_ = gtk_widget_get_first_child ((GtkWidget*) self);
		gtk_widget_unparent (_tmp1_);
	}
	_g_free0 (self->priv->_header);
	_g_free0 (self->priv->_status);
	_g_object_unref0 (self->priv->_icon);
	_g_free0 (self->priv->_title);
	_g_object_unref0 (self->priv->_status_switch);
	_g_object_unref0 (self->priv->_avatar_paintable);
	_g_free0 (self->priv->_description);
	_g_object_unref0 (self->priv->content_area);
	_g_object_unref0 (self->priv->action_bar);
	_g_object_unref0 (self->priv->start_button_group);
	_g_object_unref0 (self->priv->end_button_group);
	G_OBJECT_CLASS (switchboard_settings_page_parent_class)->finalize (obj);
}

/**
 * SettingsPage is a {@link Gtk.Widget} subclass with properties used
 * by Switchboard.SettingsSidebar
 */
static GType
switchboard_settings_page_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SwitchboardSettingsPageClass), (GBaseInitFunc) switchboard_settings_page_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) switchboard_settings_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SwitchboardSettingsPage), 0, (GInstanceInitFunc) switchboard_settings_page_instance_init, NULL };
	GType switchboard_settings_page_type_id;
	switchboard_settings_page_type_id = g_type_register_static (gtk_widget_get_type (), "SwitchboardSettingsPage", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	SwitchboardSettingsPage_private_offset = g_type_add_instance_private (switchboard_settings_page_type_id, sizeof (SwitchboardSettingsPagePrivate));
	return switchboard_settings_page_type_id;
}

GType
switchboard_settings_page_get_type (void)
{
	static volatile gsize switchboard_settings_page_type_id__once = 0;
	if (g_once_init_enter (&switchboard_settings_page_type_id__once)) {
		GType switchboard_settings_page_type_id;
		switchboard_settings_page_type_id = switchboard_settings_page_get_type_once ();
		g_once_init_leave (&switchboard_settings_page_type_id__once, switchboard_settings_page_type_id);
	}
	return switchboard_settings_page_type_id__once;
}

static void
_vala_switchboard_settings_page_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec)
{
	SwitchboardSettingsPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SWITCHBOARD_TYPE_SETTINGS_PAGE, SwitchboardSettingsPage);
	switch (property_id) {
		case SWITCHBOARD_SETTINGS_PAGE_STATUS_TYPE_PROPERTY:
		g_value_set_enum (value, switchboard_settings_page_get_status_type (self));
		break;
		case SWITCHBOARD_SETTINGS_PAGE_HEADER_PROPERTY:
		g_value_set_string (value, switchboard_settings_page_get_header (self));
		break;
		case SWITCHBOARD_SETTINGS_PAGE_STATUS_PROPERTY:
		g_value_set_string (value, switchboard_settings_page_get_status (self));
		break;
		case SWITCHBOARD_SETTINGS_PAGE_ICON_PROPERTY:
		g_value_set_object (value, switchboard_settings_page_get_icon (self));
		break;
		case SWITCHBOARD_SETTINGS_PAGE_TITLE_PROPERTY:
		g_value_set_string (value, switchboard_settings_page_get_title (self));
		break;
		case SWITCHBOARD_SETTINGS_PAGE_CHILD_PROPERTY:
		g_value_set_object (value, switchboard_settings_page_get_child (self));
		break;
		case SWITCHBOARD_SETTINGS_PAGE_STATUS_SWITCH_PROPERTY:
		g_value_set_object (value, switchboard_settings_page_get_status_switch (self));
		break;
		case SWITCHBOARD_SETTINGS_PAGE_ACTIVATABLE_PROPERTY:
		g_value_set_boolean (value, switchboard_settings_page_get_activatable (self));
		break;
		case SWITCHBOARD_SETTINGS_PAGE_WITH_AVATAR_PROPERTY:
		g_value_set_boolean (value, switchboard_settings_page_get_with_avatar (self));
		break;
		case SWITCHBOARD_SETTINGS_PAGE_AVATAR_PAINTABLE_PROPERTY:
		g_value_set_object (value, switchboard_settings_page_get_avatar_paintable (self));
		break;
		case SWITCHBOARD_SETTINGS_PAGE_DESCRIPTION_PROPERTY:
		g_value_set_string (value, switchboard_settings_page_get_description (self));
		break;
		case SWITCHBOARD_SETTINGS_PAGE_SHOW_END_TITLE_BUTTONS_PROPERTY:
		g_value_set_boolean (value, switchboard_settings_page_get_show_end_title_buttons (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_switchboard_settings_page_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec)
{
	SwitchboardSettingsPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SWITCHBOARD_TYPE_SETTINGS_PAGE, SwitchboardSettingsPage);
	switch (property_id) {
		case SWITCHBOARD_SETTINGS_PAGE_STATUS_TYPE_PROPERTY:
		switchboard_settings_page_set_status_type (self, g_value_get_enum (value));
		break;
		case SWITCHBOARD_SETTINGS_PAGE_HEADER_PROPERTY:
		switchboard_settings_page_set_header (self, g_value_get_string (value));
		break;
		case SWITCHBOARD_SETTINGS_PAGE_STATUS_PROPERTY:
		switchboard_settings_page_set_status (self, g_value_get_string (value));
		break;
		case SWITCHBOARD_SETTINGS_PAGE_ICON_PROPERTY:
		switchboard_settings_page_set_icon (self, g_value_get_object (value));
		break;
		case SWITCHBOARD_SETTINGS_PAGE_TITLE_PROPERTY:
		switchboard_settings_page_set_title (self, g_value_get_string (value));
		break;
		case SWITCHBOARD_SETTINGS_PAGE_CHILD_PROPERTY:
		switchboard_settings_page_set_child (self, g_value_get_object (value));
		break;
		case SWITCHBOARD_SETTINGS_PAGE_STATUS_SWITCH_PROPERTY:
		switchboard_settings_page_set_status_switch (self, g_value_get_object (value));
		break;
		case SWITCHBOARD_SETTINGS_PAGE_ACTIVATABLE_PROPERTY:
		switchboard_settings_page_set_activatable (self, g_value_get_boolean (value));
		break;
		case SWITCHBOARD_SETTINGS_PAGE_WITH_AVATAR_PROPERTY:
		switchboard_settings_page_set_with_avatar (self, g_value_get_boolean (value));
		break;
		case SWITCHBOARD_SETTINGS_PAGE_AVATAR_PAINTABLE_PROPERTY:
		switchboard_settings_page_set_avatar_paintable (self, g_value_get_object (value));
		break;
		case SWITCHBOARD_SETTINGS_PAGE_DESCRIPTION_PROPERTY:
		switchboard_settings_page_set_description (self, g_value_get_string (value));
		break;
		case SWITCHBOARD_SETTINGS_PAGE_SHOW_END_TITLE_BUTTONS_PROPERTY:
		switchboard_settings_page_set_show_end_title_buttons (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

