// services/viz/public/mojom/compositing/filter_operations.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_FILTER_OPERATIONS_MOJOM_SHARED_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_FILTER_OPERATIONS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/compositing/filter_operations.mojom-shared-internal.h"
#include "services/viz/public/mojom/compositing/filter_operation.mojom-shared.h"







namespace viz::mojom {
class FilterOperationsDataView;



}  // viz::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::viz::mojom::FilterOperationsDataView> {
  using Data = ::viz::mojom::internal::FilterOperations_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace viz::mojom {


class FilterOperationsDataView {
 public:
  FilterOperationsDataView() = default;

  FilterOperationsDataView(
      internal::FilterOperations_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetOperationsDataView(
      mojo::ArrayDataView<::viz::mojom::FilterOperationDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOperations(UserType* output) {
    
    auto* pointer = data_->operations.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::viz::mojom::FilterOperationDataView>>(
        pointer, output, message_);
  }
 private:
  internal::FilterOperations_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // viz::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::FilterOperationsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::FilterOperationsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::FilterOperations_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::operations(input)) in_operations = Traits::operations(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->operations)::BaseType>
        operations_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& operations_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::FilterOperationDataView>>(
        in_operations, operations_fragment, &operations_validate_params);
    fragment->operations.Set(
        operations_fragment.is_null() ? nullptr : operations_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->operations.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null operations in FilterOperations struct");
  }

  static bool Deserialize(::viz::mojom::internal::FilterOperations_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::FilterOperationsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace viz::mojom {

inline void FilterOperationsDataView::GetOperationsDataView(
    mojo::ArrayDataView<::viz::mojom::FilterOperationDataView>* output) {
  auto pointer = data_->operations.Get();
  *output = mojo::ArrayDataView<::viz::mojom::FilterOperationDataView>(pointer, message_);
}



}  // viz::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_FILTER_OPERATIONS_MOJOM_SHARED_H_