// services/network/public/mojom/reporting_service.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_REPORTING_SERVICE_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_REPORTING_SERVICE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/reporting_service.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "services/network/public/mojom/network_anonymization_key.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"






namespace network::mojom {
class ReportingApiReportDataView;

class ReportingApiEndpointDataView;



}  // network::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::ReportingApiReportDataView> {
  using Data = ::network::mojom::internal::ReportingApiReport_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::ReportingApiEndpointDataView> {
  using Data = ::network::mojom::internal::ReportingApiEndpoint_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {


enum class ReportingApiReportStatus : int32_t {
  
  kQueued = 0,
  
  kPending = 1,
  
  kDoomed = 2,
  
  kSuccess = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, ReportingApiReportStatus value);
inline bool IsKnownEnumValue(ReportingApiReportStatus value) {
  return internal::ReportingApiReportStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class ReportingApiObserverInterfaceBase {};

using ReportingApiObserverPtrDataView =
    mojo::InterfacePtrDataView<ReportingApiObserverInterfaceBase>;
using ReportingApiObserverRequestDataView =
    mojo::InterfaceRequestDataView<ReportingApiObserverInterfaceBase>;
using ReportingApiObserverAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ReportingApiObserverInterfaceBase>;
using ReportingApiObserverAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ReportingApiObserverInterfaceBase>;


class ReportingApiReportDataView {
 public:
  ReportingApiReportDataView() = default;

  ReportingApiReportDataView(
      internal::ReportingApiReport_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetGroupDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGroup(UserType* output) {
    
    auto* pointer = data_->group.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) {
    
    auto* pointer = data_->type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetTimestampDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTimestamp(UserType* output) {
    
    auto* pointer = data_->timestamp.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  int32_t depth() const {
    return data_->depth;
  }
  int32_t attempts() const {
    return data_->attempts;
  }
  inline void GetBodyDataView(
      ::mojo_base::mojom::DictionaryValueDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBody(UserType* output) {
    
    auto* pointer = data_->body.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::DictionaryValueDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadStatus(UserType* output) const {
    auto data_value = data_->status;
    return mojo::internal::Deserialize<::network::mojom::ReportingApiReportStatus>(
        data_value, output);
  }
  ReportingApiReportStatus status() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::ReportingApiReportStatus>(data_->status));
  }
 private:
  internal::ReportingApiReport_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ReportingApiEndpointDataView {
 public:
  ReportingApiEndpointDataView() = default;

  ReportingApiEndpointDataView(
      internal::ReportingApiEndpoint_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  int32_t attempted_uploads() const {
    return data_->attempted_uploads;
  }
  int32_t successful_uploads() const {
    return data_->successful_uploads;
  }
  int32_t attempted_reports() const {
    return data_->attempted_reports;
  }
  int32_t successful_reports() const {
    return data_->successful_reports;
  }
  int32_t priority() const {
    return data_->priority;
  }
  int32_t weight() const {
    return data_->weight;
  }
  inline void GetOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOrigin(UserType* output) {
    
    auto* pointer = data_->origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetGroupNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGroupName(UserType* output) {
    
    auto* pointer = data_->group_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetNetworkAnonymizationKeyDataView(
      ::network::mojom::NetworkAnonymizationKeyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNetworkAnonymizationKey(UserType* output) {
    
    auto* pointer = !data_->network_anonymization_key.is_null() ? &data_->network_anonymization_key : nullptr;
    return mojo::internal::Deserialize<::network::mojom::NetworkAnonymizationKeyDataView>(
        pointer, output, message_);
  }
  inline void GetReportingSourceDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReportingSource(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::UnguessableTokenDataView, UserType>(),
    "Attempting to read the optional `reporting_source` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadReportingSource` instead "
    "of `ReadReportingSource if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->reporting_source.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
 private:
  internal::ReportingApiEndpoint_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // network::mojom

namespace std {

template <>
struct hash<::network::mojom::ReportingApiReportStatus>
    : public mojo::internal::EnumHashImpl<::network::mojom::ReportingApiReportStatus> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::ReportingApiReportStatus, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::ReportingApiReportStatus, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::ReportingApiReportStatus>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::ReportingApiReportDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::ReportingApiReportDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::ReportingApiReport_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
        in_id, id_fragment);
    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null id in ReportingApiReport struct");
    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_url, url_fragment);
    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in ReportingApiReport struct");
    decltype(Traits::group(input)) in_group = Traits::group(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->group)::BaseType> group_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_group, group_fragment);
    fragment->group.Set(
        group_fragment.is_null() ? nullptr : group_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->group.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null group in ReportingApiReport struct");
    decltype(Traits::type(input)) in_type = Traits::type(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->type)::BaseType> type_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_type, type_fragment);
    fragment->type.Set(
        type_fragment.is_null() ? nullptr : type_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->type.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null type in ReportingApiReport struct");
    decltype(Traits::timestamp(input)) in_timestamp = Traits::timestamp(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->timestamp)::BaseType> timestamp_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_timestamp, timestamp_fragment);
    fragment->timestamp.Set(
        timestamp_fragment.is_null() ? nullptr : timestamp_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->timestamp.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null timestamp in ReportingApiReport struct");
    fragment->depth = Traits::depth(input);
    fragment->attempts = Traits::attempts(input);
    decltype(Traits::body(input)) in_body = Traits::body(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->body)::BaseType> body_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::DictionaryValueDataView>(
        in_body, body_fragment);
    fragment->body.Set(
        body_fragment.is_null() ? nullptr : body_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->body.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null body in ReportingApiReport struct");
    mojo::internal::Serialize<::network::mojom::ReportingApiReportStatus>(
        Traits::status(input), &fragment->status);
  }

  static bool Deserialize(::network::mojom::internal::ReportingApiReport_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::ReportingApiReportDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::ReportingApiEndpointDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::ReportingApiEndpointDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::ReportingApiEndpoint_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_url, url_fragment);
    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in ReportingApiEndpoint struct");
    fragment->attempted_uploads = Traits::attempted_uploads(input);
    fragment->successful_uploads = Traits::successful_uploads(input);
    fragment->attempted_reports = Traits::attempted_reports(input);
    fragment->successful_reports = Traits::successful_reports(input);
    fragment->priority = Traits::priority(input);
    fragment->weight = Traits::weight(input);
    decltype(Traits::origin(input)) in_origin = Traits::origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->origin)::BaseType> origin_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
        in_origin, origin_fragment);
    fragment->origin.Set(
        origin_fragment.is_null() ? nullptr : origin_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->origin.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null origin in ReportingApiEndpoint struct");
    decltype(Traits::group_name(input)) in_group_name = Traits::group_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->group_name)::BaseType> group_name_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_group_name, group_name_fragment);
    fragment->group_name.Set(
        group_name_fragment.is_null() ? nullptr : group_name_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->group_name.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null group_name in ReportingApiEndpoint struct");
    decltype(Traits::network_anonymization_key(input)) in_network_anonymization_key = Traits::network_anonymization_key(input);
    mojo::internal::MessageFragment<decltype(fragment->network_anonymization_key)>
        network_anonymization_key_fragment(fragment.message());
    network_anonymization_key_fragment.Claim(&fragment->network_anonymization_key);
    mojo::internal::Serialize<::network::mojom::NetworkAnonymizationKeyDataView>(
        in_network_anonymization_key, network_anonymization_key_fragment, true);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->network_anonymization_key.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null network_anonymization_key in ReportingApiEndpoint struct");
    decltype(Traits::reporting_source(input)) in_reporting_source = Traits::reporting_source(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->reporting_source)::BaseType> reporting_source_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
        in_reporting_source, reporting_source_fragment);
    fragment->reporting_source.Set(
        reporting_source_fragment.is_null() ? nullptr : reporting_source_fragment.data());
  }

  static bool Deserialize(::network::mojom::internal::ReportingApiEndpoint_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::ReportingApiEndpointDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {

inline void ReportingApiReportDataView::GetIdDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->id.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}
inline void ReportingApiReportDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void ReportingApiReportDataView::GetGroupDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->group.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ReportingApiReportDataView::GetTypeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->type.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ReportingApiReportDataView::GetTimestampDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->timestamp.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}
inline void ReportingApiReportDataView::GetBodyDataView(
    ::mojo_base::mojom::DictionaryValueDataView* output) {
  auto pointer = data_->body.Get();
  *output = ::mojo_base::mojom::DictionaryValueDataView(pointer, message_);
}


inline void ReportingApiEndpointDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void ReportingApiEndpointDataView::GetOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void ReportingApiEndpointDataView::GetGroupNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->group_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ReportingApiEndpointDataView::GetNetworkAnonymizationKeyDataView(
    ::network::mojom::NetworkAnonymizationKeyDataView* output) {
  auto pointer = &data_->network_anonymization_key;
  *output = ::network::mojom::NetworkAnonymizationKeyDataView(pointer, message_);
}
inline void ReportingApiEndpointDataView::GetReportingSourceDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->reporting_source.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}



}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::ReportingApiReportStatus> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::ReportingApiReportStatus value);
};

} // namespace perfetto

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_REPORTING_SERVICE_MOJOM_SHARED_H_