// services/network/public/mojom/oblivious_http_request.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/oblivious_http_request.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/oblivious_http_request.mojom-params-data.h"
namespace network {
namespace mojom {

namespace internal {
// static
bool ObliviousHttpCompletionResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const ObliviousHttpCompletionResult_Data* object = static_cast<const ObliviousHttpCompletionResult_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case ObliviousHttpCompletionResult_Tag::kNetError: {

      return true;
    }
    case ObliviousHttpCompletionResult_Tag::kOuterResponseErrorCode: {

      return true;
    }
    case ObliviousHttpCompletionResult_Tag::kInnerResponse: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_inner_response, 3, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_inner_response, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in ObliviousHttpCompletionResult");
      return false;
    }
  }
}


// static
bool ObliviousHttpRequestBody_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ObliviousHttpRequestBody_Data* object =
      static_cast<const ObliviousHttpRequestBody_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->content, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->content, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->content_type, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& content_type_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->content_type, validation_context,
                                         &content_type_validate_params)) {
    return false;
  }

  return true;
}

ObliviousHttpRequestBody_Data::ObliviousHttpRequestBody_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ObliviousHttpResponse_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ObliviousHttpResponse_Data* object =
      static_cast<const ObliviousHttpResponse_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->headers, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->headers, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->response_body, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->response_body, validation_context))
    return false;

  return true;
}

ObliviousHttpResponse_Data::ObliviousHttpResponse_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ObliviousHttpPaddingParameters_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ObliviousHttpPaddingParameters_Data* object =
      static_cast<const ObliviousHttpPaddingParameters_Data*>(data);

  return true;
}

ObliviousHttpPaddingParameters_Data::ObliviousHttpPaddingParameters_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ObliviousHttpRequest_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 80, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ObliviousHttpRequest_Data* object =
      static_cast<const ObliviousHttpRequest_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->relay_url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->relay_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->traffic_annotation, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->traffic_annotation, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->timeout_duration, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key_config, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& key_config_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->key_config, validation_context,
                                         &key_config_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->resource_url, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->resource_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->method, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& method_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->method, validation_context,
                                         &method_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->request_body, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->trust_token_params, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->padding_params, validation_context))
    return false;

  return true;
}

ObliviousHttpRequest_Data::ObliviousHttpRequest_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ObliviousHttpClient_OnCompleted_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ObliviousHttpClient_OnCompleted_Params_Data* object =
      static_cast<const ObliviousHttpClient_OnCompleted_Params_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->response, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->response, validation_context))
    return false;

  return true;
}

ObliviousHttpClient_OnCompleted_Params_Data::ObliviousHttpClient_OnCompleted_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace network