// components/services/storage/public/mojom/blob_storage_context.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_BLOB_STORAGE_CONTEXT_MOJOM_SHARED_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_BLOB_STORAGE_CONTEXT_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/services/storage/public/mojom/blob_storage_context.mojom-shared-internal.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "third_party/blink/public/mojom/blob/blob.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"






namespace storage::mojom {
class BlobDataItemDataView;



}  // storage::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::storage::mojom::BlobDataItemDataView> {
  using Data = ::storage::mojom::internal::BlobDataItem_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace storage::mojom {


enum class BlobDataItemType : int32_t {
  
  kUnknown = 0,
  
  kCacheStorage = 1,
  
  kIndexedDB = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, BlobDataItemType value);
inline bool IsKnownEnumValue(BlobDataItemType value) {
  return internal::BlobDataItemType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class WriteBlobToFileResult : int32_t {
  
  kError = 0,
  
  kBadPath = 1,
  
  kInvalidBlob = 2,
  
  kIOError = 3,
  
  kTimestampError = 4,
  
  kSuccess = 5,
  kMinValue = 0,
  kMaxValue = 5,
};

 std::ostream& operator<<(std::ostream& os, WriteBlobToFileResult value);
inline bool IsKnownEnumValue(WriteBlobToFileResult value) {
  return internal::WriteBlobToFileResult_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class BlobDataItemReaderInterfaceBase {};

using BlobDataItemReaderPtrDataView =
    mojo::InterfacePtrDataView<BlobDataItemReaderInterfaceBase>;
using BlobDataItemReaderRequestDataView =
    mojo::InterfaceRequestDataView<BlobDataItemReaderInterfaceBase>;
using BlobDataItemReaderAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<BlobDataItemReaderInterfaceBase>;
using BlobDataItemReaderAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<BlobDataItemReaderInterfaceBase>;
class BlobStorageContextInterfaceBase {};

using BlobStorageContextPtrDataView =
    mojo::InterfacePtrDataView<BlobStorageContextInterfaceBase>;
using BlobStorageContextRequestDataView =
    mojo::InterfaceRequestDataView<BlobStorageContextInterfaceBase>;
using BlobStorageContextAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<BlobStorageContextInterfaceBase>;
using BlobStorageContextAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<BlobStorageContextInterfaceBase>;


class BlobDataItemDataView {
 public:
  BlobDataItemDataView() = default;

  BlobDataItemDataView(
      internal::BlobDataItem_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::storage::mojom::BlobDataItemType>(
        data_value, output);
  }
  BlobDataItemType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::storage::mojom::BlobDataItemType>(data_->type));
  }
  uint64_t size() const {
    return data_->size;
  }
  uint64_t side_data_size() const {
    return data_->side_data_size;
  }
  inline void GetContentTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContentType(UserType* output) {
    
    auto* pointer = data_->content_type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeReader() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::storage::mojom::BlobDataItemReaderInterfaceBase>>(
            &data_->reader, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::BlobDataItem_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // storage::mojom

namespace std {

template <>
struct hash<::storage::mojom::BlobDataItemType>
    : public mojo::internal::EnumHashImpl<::storage::mojom::BlobDataItemType> {};

template <>
struct hash<::storage::mojom::WriteBlobToFileResult>
    : public mojo::internal::EnumHashImpl<::storage::mojom::WriteBlobToFileResult> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::storage::mojom::BlobDataItemType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::storage::mojom::BlobDataItemType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::storage::mojom::BlobDataItemType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::storage::mojom::WriteBlobToFileResult, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::storage::mojom::WriteBlobToFileResult, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::storage::mojom::WriteBlobToFileResult>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::storage::mojom::BlobDataItemDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::storage::mojom::BlobDataItemDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::storage::mojom::internal::BlobDataItem_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    mojo::internal::Serialize<::storage::mojom::BlobDataItemType>(
        Traits::type(input), &fragment->type);
    fragment->size = Traits::size(input);
    fragment->side_data_size = Traits::side_data_size(input);
    decltype(Traits::content_type(input)) in_content_type = Traits::content_type(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->content_type)::BaseType> content_type_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_content_type, content_type_fragment);
    fragment->content_type.Set(
        content_type_fragment.is_null() ? nullptr : content_type_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->content_type.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null content_type in BlobDataItem struct");
    decltype(Traits::reader(input)) in_reader = Traits::reader(input);
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::storage::mojom::BlobDataItemReaderInterfaceBase>>(
        in_reader, &fragment->reader, &fragment.message());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid(fragment->reader),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid reader in BlobDataItem struct");
  }

  static bool Deserialize(::storage::mojom::internal::BlobDataItem_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::storage::mojom::BlobDataItemDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace storage::mojom {

inline void BlobDataItemDataView::GetContentTypeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->content_type.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // storage::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::storage::mojom::BlobDataItemType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::storage::mojom::BlobDataItemType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::storage::mojom::WriteBlobToFileResult> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::storage::mojom::WriteBlobToFileResult value);
};

} // namespace perfetto

#endif  // COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_BLOB_STORAGE_CONTEXT_MOJOM_SHARED_H_