#include "vtkABI.h"
#include "vtkClientServerInterpreter.h"

extern "C" { void vtkAddMembershipArray_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkAdjacencyMatrixToEdgeTable_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkArrayNorm_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkArrayToTable_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkCollapseGraph_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkCollapseVerticesByArray_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkContinuousScatterplot_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkDotProductSimilarity_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkEdgeCenters_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkExpandSelectedGraph_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkExtractSelectedGraph_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkExtractSelectedTree_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkGenerateIndexArray_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkGraphHierarchicalBundleEdges_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkGroupLeafVertices_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkKCoreDecomposition_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkMergeColumns_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkMergeGraphs_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkMergeTables_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkMutableGraphHelper_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkNetworkHierarchy_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPipelineGraphSource_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPruneTreeFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkRandomGraphSource_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkReduceTable_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkRemoveHiddenData_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkRemoveIsolatedVertices_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkSparseArrayToTable_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkStreamGraph_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkStringToCategory_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkStringToNumeric_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkTableToArray_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkTableToGraph_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkTableToSparseArray_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkTableToTreeFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkThresholdGraph_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkThresholdTable_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkTransferAttributes_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkTransposeMatrix_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkTreeDifferenceFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkTreeFieldAggregator_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkTreeLevelsFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkVertexDegree_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkWordCloud_Init(vtkClientServerInterpreter*); }

extern "C" VTK_ABI_EXPORT void vtkInfovisCoreCS_Initialize(vtkClientServerInterpreter* csi)
{
  (void)csi;
  vtkAddMembershipArray_Init(csi);
  vtkAdjacencyMatrixToEdgeTable_Init(csi);
  vtkArrayNorm_Init(csi);
  vtkArrayToTable_Init(csi);
  vtkCollapseGraph_Init(csi);
  vtkCollapseVerticesByArray_Init(csi);
  vtkContinuousScatterplot_Init(csi);
  vtkDotProductSimilarity_Init(csi);
  vtkEdgeCenters_Init(csi);
  vtkExpandSelectedGraph_Init(csi);
  vtkExtractSelectedGraph_Init(csi);
  vtkExtractSelectedTree_Init(csi);
  vtkGenerateIndexArray_Init(csi);
  vtkGraphHierarchicalBundleEdges_Init(csi);
  vtkGroupLeafVertices_Init(csi);
  vtkKCoreDecomposition_Init(csi);
  vtkMergeColumns_Init(csi);
  vtkMergeGraphs_Init(csi);
  vtkMergeTables_Init(csi);
  vtkMutableGraphHelper_Init(csi);
  vtkNetworkHierarchy_Init(csi);
  vtkPipelineGraphSource_Init(csi);
  vtkPruneTreeFilter_Init(csi);
  vtkRandomGraphSource_Init(csi);
  vtkReduceTable_Init(csi);
  vtkRemoveHiddenData_Init(csi);
  vtkRemoveIsolatedVertices_Init(csi);
  vtkSparseArrayToTable_Init(csi);
  vtkStreamGraph_Init(csi);
  vtkStringToCategory_Init(csi);
  vtkStringToNumeric_Init(csi);
  vtkTableToArray_Init(csi);
  vtkTableToGraph_Init(csi);
  vtkTableToSparseArray_Init(csi);
  vtkTableToTreeFilter_Init(csi);
  vtkThresholdGraph_Init(csi);
  vtkThresholdTable_Init(csi);
  vtkTransferAttributes_Init(csi);
  vtkTransposeMatrix_Init(csi);
  vtkTreeDifferenceFilter_Init(csi);
  vtkTreeFieldAggregator_Init(csi);
  vtkTreeLevelsFilter_Init(csi);
  vtkVertexDegree_Init(csi);
  vtkWordCloud_Init(csi);
}
