/* SlideshowPage.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from SlideshowPage.vala, do not modify */

/*
* Copyright (c) 2009-2013 Yorba Foundation
*               2017 elementary LLC. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "io.elementary.photos.h"
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <cairo-gobject.h>
#include <glib/gi18n-lib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gee.h>
#include <float.h>
#include <math.h>
#include <pango/pango.h>
#include <pango/pangocairo.h>

#define SLIDESHOW_PAGE_READAHEAD_COUNT 5
#define SLIDESHOW_PAGE_CHECK_ADVANCE_MSEC 250
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define TYPE_SLIDESHOW_PAGE (slideshow_page_get_type ())
#define SLIDESHOW_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SLIDESHOW_PAGE, SlideshowPage))
#define SLIDESHOW_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SLIDESHOW_PAGE, SlideshowPageClass))
#define IS_SLIDESHOW_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SLIDESHOW_PAGE))
#define IS_SLIDESHOW_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SLIDESHOW_PAGE))
#define SLIDESHOW_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SLIDESHOW_PAGE, SlideshowPageClass))

typedef struct _SlideshowPage SlideshowPage;
typedef struct _SlideshowPageClass SlideshowPageClass;
typedef struct _SlideshowPagePrivate SlideshowPagePrivate;
enum  {
	SLIDESHOW_PAGE_0_PROPERTY,
	SLIDESHOW_PAGE_SOURCES_PROPERTY,
	SLIDESHOW_PAGE_CONTROLLER_PROPERTY,
	SLIDESHOW_PAGE_NUM_PROPERTIES
};
static GParamSpec* slideshow_page_properties[SLIDESHOW_PAGE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
#define _data_collection_unref0(var) ((var == NULL) ? NULL : (var = (data_collection_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _pango_attribute_destroy0(var) ((var == NULL) ? NULL : (var = (pango_attribute_destroy (var), NULL)))
#define _pango_attr_list_unref0(var) ((var == NULL) ? NULL : (var = (pango_attr_list_unref (var), NULL)))
typedef struct _Block24Data Block24Data;
#define _transition_effects_manager_unref0(var) ((var == NULL) ? NULL : (var = (transition_effects_manager_unref (var), NULL)))
enum  {
	SLIDESHOW_PAGE_HIDE_TOOLBAR_SIGNAL,
	SLIDESHOW_PAGE_NUM_SIGNALS
};
static guint slideshow_page_signals[SLIDESHOW_PAGE_NUM_SIGNALS] = {0};

struct _SlideshowPage {
	SinglePhotoPage parent_instance;
	SlideshowPagePrivate * priv;
};

struct _SlideshowPageClass {
	SinglePhotoPageClass parent_class;
};

struct _SlideshowPagePrivate {
	Photo* current;
	GtkButton* play_pause_button;
	PixbufCache* cache;
	GTimer* timer;
	gboolean playing;
	gboolean exiting;
	gchar** transitions;
	gint transitions_length1;
	gint _transitions_size_;
	guint32 cookie;
	GSettings* slideshow_settings;
	SourceCollection* _sources;
	ViewCollection* _controller;
};

struct _Block24Data {
	int _ref_count_;
	SlideshowPage* self;
	GtkToggleButton* titles_toggle;
	GtkScale* slider;
};

static gint SlideshowPage_private_offset;
static gpointer slideshow_page_parent_class = NULL;

VALA_EXTERN GType slideshow_page_get_type (void) G_GNUC_CONST ;
VALA_EXTERN SlideshowPage* slideshow_page_new (SourceCollection* sources,
                                   ViewCollection* controller,
                                   Photo* start);
VALA_EXTERN SlideshowPage* slideshow_page_construct (GType object_type,
                                         SourceCollection* sources,
                                         ViewCollection* controller,
                                         Photo* start);
static void slideshow_page_real_switched_to (Page* base);
VALA_EXTERN SourceCollection* slideshow_page_get_sources (SlideshowPage* self);
static gboolean slideshow_page_get_next_photo (SlideshowPage* self,
                                        Photo* start,
                                        Direction direction,
                                        Photo** next,
                                        GdkPixbuf** next_pixbuf);
static gboolean slideshow_page_auto_advance (SlideshowPage* self);
static gboolean _slideshow_page_auto_advance_gsource_func (gpointer self);
static void slideshow_page_inhibit_screensaver (SlideshowPage* self);
static void slideshow_page_real_switching_from (Page* base);
static void slideshow_page_uninhibit_screensaver (SlideshowPage* self);
VALA_EXTERN ViewCollection* slideshow_page_get_controller (SlideshowPage* self);
static void slideshow_page_on_play_pause (SlideshowPage* self);
static void slideshow_page_real_on_previous_photo (SinglePhotoPage* base);
static void slideshow_page_advance (SlideshowPage* self,
                             Photo* photo,
                             Direction direction);
static void slideshow_page_real_on_next_photo (SinglePhotoPage* base);
static void slideshow_page_random_transition_effect (SlideshowPage* self);
static gboolean slideshow_page_real_button_press_event (GtkWidget* base,
                                                 GdkEventButton* event);
static gboolean slideshow_page_real_key_press_event (GtkWidget* base,
                                              GdkEventKey* event);
static void slideshow_page_update_transition_effect (SlideshowPage* self);
static gdouble slideshow_page_calculate_effect_delay (SlideshowPage* self);
static void slideshow_page_paint_title (SlideshowPage* self,
                                 cairo_t* ctx,
                                 Dimensions* ctx_dim);
VALA_EXTERN void set_source_color_from_string (cairo_t* ctx,
                                   const gchar* spec);
static void slideshow_page_real_paint (SinglePhotoPage* base,
                                cairo_t* ctx,
                                Dimensions* ctx_dim);
static void slideshow_page_set_sources (SlideshowPage* self,
                                 SourceCollection* value);
static void slideshow_page_set_controller (SlideshowPage* self,
                                    ViewCollection* value);
static GObject * slideshow_page_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties);
static Block24Data* block24_data_ref (Block24Data* _data24_);
static void block24_data_unref (void * _userdata_);
static void _slideshow_page___lambda32_ (SlideshowPage* self);
static void __slideshow_page___lambda32__g_settings_changed (GSettings* _sender,
                                                      const gchar* key,
                                                      gpointer self);
static void _single_photo_page_on_previous_photo_gtk_button_clicked (GtkButton* _sender,
                                                              gpointer self);
static void _slideshow_page_on_play_pause_gtk_button_clicked (GtkButton* _sender,
                                                       gpointer self);
static void _single_photo_page_on_next_photo_gtk_button_clicked (GtkButton* _sender,
                                                          gpointer self);
static void _slideshow_page___lambda38_ (Block24Data* _data24_);
static void __slideshow_page___lambda38__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                             gpointer self);
static void _slideshow_page___lambda39_ (Block24Data* _data24_);
static void __slideshow_page___lambda39__gtk_range_value_changed (GtkRange* _sender,
                                                           gpointer self);
static void slideshow_page_finalize (GObject * obj);
static GType slideshow_page_get_type_once (void);
static void _vala_slideshow_page_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec);
static void _vala_slideshow_page_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
slideshow_page_get_instance_private (SlideshowPage* self)
{
	return G_STRUCT_MEMBER_P (self, SlideshowPage_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

SlideshowPage*
slideshow_page_construct (GType object_type,
                          SourceCollection* sources,
                          ViewCollection* controller,
                          Photo* start)
{
	SlideshowPage * self = NULL;
	Photo* _tmp0_;
	g_return_val_if_fail (sources != NULL, NULL);
	g_return_val_if_fail (controller != NULL, NULL);
	g_return_val_if_fail (start != NULL, NULL);
	self = (SlideshowPage*) g_object_new (object_type, "controller", controller, "page-name", _ ("Slideshow"), "scale-up-to-viewport", TRUE, "sources", sources, NULL);
	_tmp0_ = _g_object_ref0 (start);
	_g_object_unref0 (self->priv->current);
	self->priv->current = _tmp0_;
	return self;
}

SlideshowPage*
slideshow_page_new (SourceCollection* sources,
                    ViewCollection* controller,
                    Photo* start)
{
	return slideshow_page_construct (TYPE_SLIDESHOW_PAGE, sources, controller, start);
}

static gboolean
_slideshow_page_auto_advance_gsource_func (gpointer self)
{
	gboolean result;
	result = slideshow_page_auto_advance ((SlideshowPage*) self);
	return result;
}

static void
slideshow_page_real_switched_to (Page* base)
{
	SlideshowPage * self;
	SourceCollection* _tmp0_;
	Scaling _tmp1_ = {0};
	PixbufCache* _tmp2_;
	GdkPixbuf* pixbuf = NULL;
	Photo* _tmp3_;
	Photo* _tmp4_ = NULL;
	GdkPixbuf* _tmp5_ = NULL;
	gboolean _tmp6_;
	GTimer* _tmp11_;
	self = (SlideshowPage*) base;
	PAGE_CLASS (slideshow_page_parent_class)->switched_to ((Page*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SINGLE_PHOTO_PAGE, SinglePhotoPage));
	_tmp0_ = self->priv->_sources;
	single_photo_page_get_canvas_scaling ((SinglePhotoPage*) self, &_tmp1_);
	_tmp2_ = pixbuf_cache_new (_tmp0_, PIXBUF_CACHE_PHOTO_TYPE_BASELINE, &_tmp1_, SLIDESHOW_PAGE_READAHEAD_COUNT, NULL, NULL);
	_g_object_unref0 (self->priv->cache);
	self->priv->cache = _tmp2_;
	_tmp3_ = self->priv->current;
	_tmp6_ = slideshow_page_get_next_photo (self, _tmp3_, DIRECTION_FORWARD, &_tmp4_, &_tmp5_);
	_g_object_unref0 (self->priv->current);
	self->priv->current = _tmp4_;
	_g_object_unref0 (pixbuf);
	pixbuf = _tmp5_;
	if (_tmp6_) {
		GdkPixbuf* _tmp7_;
		Photo* _tmp8_;
		Dimensions _tmp9_ = {0};
		Direction _tmp10_;
		_tmp7_ = pixbuf;
		_tmp8_ = self->priv->current;
		media_source_get_dimensions ((MediaSource*) _tmp8_, PHOTO_EXCEPTION_NONE, &_tmp9_);
		_tmp10_ = DIRECTION_FORWARD;
		single_photo_page_set_pixbuf ((SinglePhotoPage*) self, _tmp7_, &_tmp9_, &_tmp10_);
	}
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) SLIDESHOW_PAGE_CHECK_ADVANCE_MSEC, _slideshow_page_auto_advance_gsource_func, g_object_ref (self), g_object_unref);
	_tmp11_ = self->priv->timer;
	g_timer_start (_tmp11_);
	slideshow_page_inhibit_screensaver (self);
	_g_object_unref0 (pixbuf);
}

static void
slideshow_page_real_switching_from (Page* base)
{
	SlideshowPage * self;
	self = (SlideshowPage*) base;
	PAGE_CLASS (slideshow_page_parent_class)->switching_from ((Page*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SINGLE_PHOTO_PAGE, SinglePhotoPage));
	slideshow_page_uninhibit_screensaver (self);
	self->priv->exiting = TRUE;
}

static gboolean
slideshow_page_get_next_photo (SlideshowPage* self,
                               Photo* start,
                               Direction direction,
                               Photo** next,
                               GdkPixbuf** next_pixbuf)
{
	Photo* _vala_next = NULL;
	GdkPixbuf* _vala_next_pixbuf = NULL;
	Photo* _tmp0_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (start != NULL, FALSE);
	_tmp0_ = _g_object_ref0 (start);
	_g_object_unref0 (_vala_next);
	_vala_next = _tmp0_;
	{
		gboolean _tmp1_ = FALSE;
		_tmp1_ = TRUE;
		while (TRUE) {
			DataSource* forward = NULL;
			DataSource* back = NULL;
			ViewCollection* _tmp39_;
			Photo* _tmp40_;
			DataSource* _tmp41_ = NULL;
			DataSource* _tmp42_ = NULL;
			PixbufCache* _tmp43_;
			DataSource* _tmp44_;
			PixbufCache* _tmp45_;
			DataSource* _tmp46_;
			GeeSet* neighbors = NULL;
			ViewCollection* _tmp47_;
			Photo* _tmp48_;
			GeeSet* _tmp49_;
			GeeSet* _tmp50_;
			DataSource* _tmp51_;
			GeeSet* _tmp52_;
			DataSource* _tmp53_;
			PixbufCache* _tmp54_;
			GeeSet* _tmp55_;
			if (!_tmp1_) {
			}
			_tmp1_ = FALSE;
			{
				GdkPixbuf* _tmp2_ = NULL;
				PixbufCache* _tmp3_;
				Photo* _tmp4_;
				GdkPixbuf* _tmp5_;
				GdkPixbuf* _tmp6_;
				_tmp3_ = self->priv->cache;
				_tmp4_ = _vala_next;
				_tmp5_ = pixbuf_cache_fetch (_tmp3_, _tmp4_, &_inner_error0_);
				_tmp2_ = _tmp5_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_tmp6_ = _tmp2_;
				_tmp2_ = NULL;
				_g_object_unref0 (_vala_next_pixbuf);
				_vala_next_pixbuf = _tmp6_;
				_g_object_unref0 (_tmp2_);
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* err = NULL;
				Photo* _tmp7_;
				gchar* _tmp8_;
				gchar* _tmp9_;
				GError* _tmp10_;
				const gchar* _tmp11_;
				DataView* view = NULL;
				ViewCollection* _tmp12_;
				Photo* _tmp13_;
				DataView* _tmp14_;
				DataView* _tmp15_ = NULL;
				DataView* _tmp22_;
				DataView* _tmp23_;
				DataSource* _tmp24_;
				DataSource* _tmp25_;
				Photo* _tmp26_;
				gboolean _tmp27_ = FALSE;
				gboolean _tmp28_ = FALSE;
				Photo* _tmp29_;
				err = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp7_ = _vala_next;
				_tmp8_ = data_object_to_string ((DataObject*) _tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = err;
				_tmp11_ = _tmp10_->message;
				g_warning ("SlideshowPage.vala:153: Unable to fetch pixbuf for %s: %s", _tmp9_, _tmp11_);
				_g_free0 (_tmp9_);
				_tmp12_ = self->priv->_controller;
				_tmp13_ = _vala_next;
				_tmp14_ = view_collection_get_view_for_source (_tmp12_, (DataSource*) _tmp13_);
				view = _tmp14_;
				if (direction == DIRECTION_FORWARD) {
					ViewCollection* _tmp16_;
					DataView* _tmp17_;
					DataView* _tmp18_;
					_tmp16_ = self->priv->_controller;
					_tmp17_ = view;
					_tmp18_ = view_collection_get_next (_tmp16_, _tmp17_);
					_g_object_unref0 (_tmp15_);
					_tmp15_ = _tmp18_;
				} else {
					ViewCollection* _tmp19_;
					DataView* _tmp20_;
					DataView* _tmp21_;
					_tmp19_ = self->priv->_controller;
					_tmp20_ = view;
					_tmp21_ = view_collection_get_previous (_tmp19_, _tmp20_);
					_g_object_unref0 (_tmp15_);
					_tmp15_ = _tmp21_;
				}
				_tmp22_ = _g_object_ref0 (_tmp15_);
				_g_object_unref0 (view);
				view = _tmp22_;
				_tmp23_ = view;
				_tmp24_ = data_view_get_source (_tmp23_);
				_tmp25_ = _tmp24_;
				_tmp26_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, TYPE_PHOTO, Photo));
				_g_object_unref0 (_vala_next);
				_vala_next = _tmp26_;
				_tmp29_ = _vala_next;
				if (_tmp29_ == start) {
					Photo* _tmp30_;
					Photo* _tmp31_;
					_tmp30_ = _vala_next;
					_tmp31_ = self->priv->current;
					_tmp28_ = _tmp30_ != _tmp31_;
				} else {
					_tmp28_ = FALSE;
				}
				if (_tmp28_) {
					_tmp27_ = TRUE;
				} else {
					Photo* _tmp32_;
					Photo* _tmp33_;
					_tmp32_ = _vala_next;
					_tmp33_ = self->priv->current;
					_tmp27_ = _tmp32_ == _tmp33_;
				}
				if (_tmp27_) {
					GtkWindow* _tmp34_;
					GtkWindow* _tmp35_;
					AppWindow* _tmp36_;
					AppWindow* _tmp37_;
					_tmp34_ = page_get_container ((Page*) self);
					_tmp35_ = _tmp34_;
					app_window_error_message (_ ("All photo source files are missing."), NULL, _tmp35_);
					_g_object_unref0 (_tmp35_);
					_tmp36_ = app_window_get_instance ();
					_tmp37_ = _tmp36_;
					app_window_end_fullscreen (_tmp37_);
					_g_object_unref0 (_tmp37_);
					_g_object_unref0 (_vala_next);
					_vala_next = NULL;
					_g_object_unref0 (_vala_next_pixbuf);
					_vala_next_pixbuf = NULL;
					result = FALSE;
					_g_object_unref0 (_tmp15_);
					_g_object_unref0 (view);
					_g_error_free0 (err);
					if (next) {
						*next = _vala_next;
					} else {
						_g_object_unref0 (_vala_next);
					}
					if (next_pixbuf) {
						*next_pixbuf = _vala_next_pixbuf;
					} else {
						_g_object_unref0 (_vala_next_pixbuf);
					}
					return result;
				}
				_g_object_unref0 (_tmp15_);
				_g_object_unref0 (view);
				_g_error_free0 (err);
				continue;
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp38_ = FALSE;
				_g_object_unref0 (_vala_next);
				_g_object_unref0 (_vala_next_pixbuf);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp38_;
			}
			_tmp39_ = self->priv->_controller;
			_tmp40_ = _vala_next;
			view_collection_get_immediate_neighbors (_tmp39_, (DataSource*) _tmp40_, &_tmp41_, &_tmp42_, PHOTO_TYPENAME);
			_g_object_unref0 (forward);
			forward = _tmp41_;
			_g_object_unref0 (back);
			back = _tmp42_;
			_tmp43_ = self->priv->cache;
			_tmp44_ = forward;
			pixbuf_cache_prefetch (_tmp43_, G_TYPE_CHECK_INSTANCE_CAST (_tmp44_, TYPE_PHOTO, Photo), BACKGROUND_JOB_JOB_PRIORITY_HIGHEST, FALSE);
			_tmp45_ = self->priv->cache;
			_tmp46_ = back;
			pixbuf_cache_prefetch (_tmp45_, G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, TYPE_PHOTO, Photo), BACKGROUND_JOB_JOB_PRIORITY_NORMAL, FALSE);
			_tmp47_ = self->priv->_controller;
			_tmp48_ = _vala_next;
			_tmp49_ = view_collection_get_extended_neighbors (_tmp47_, (DataSource*) _tmp48_, PHOTO_TYPENAME);
			neighbors = _tmp49_;
			_tmp50_ = neighbors;
			_tmp51_ = forward;
			gee_collection_remove ((GeeCollection*) _tmp50_, _tmp51_);
			_tmp52_ = neighbors;
			_tmp53_ = back;
			gee_collection_remove ((GeeCollection*) _tmp52_, _tmp53_);
			_tmp54_ = self->priv->cache;
			_tmp55_ = neighbors;
			pixbuf_cache_prefetch_many (_tmp54_, G_TYPE_CHECK_INSTANCE_CAST (_tmp55_, GEE_TYPE_COLLECTION, GeeCollection), BACKGROUND_JOB_JOB_PRIORITY_LOWEST, FALSE);
			result = TRUE;
			_g_object_unref0 (neighbors);
			_g_object_unref0 (back);
			_g_object_unref0 (forward);
			if (next) {
				*next = _vala_next;
			} else {
				_g_object_unref0 (_vala_next);
			}
			if (next_pixbuf) {
				*next_pixbuf = _vala_next_pixbuf;
			} else {
				_g_object_unref0 (_vala_next_pixbuf);
			}
			return result;
		}
	}
}

static void
slideshow_page_on_play_pause (SlideshowPage* self)
{
	GTimer* _tmp8_;
	g_return_if_fail (self != NULL);
	if (self->priv->playing) {
		GtkButton* _tmp0_;
		GtkImage* _tmp1_;
		GtkImage* _tmp2_;
		GtkButton* _tmp3_;
		_tmp0_ = self->priv->play_pause_button;
		_tmp1_ = (GtkImage*) gtk_image_new_from_icon_name ("media-playback-start-symbolic", (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
		g_object_ref_sink (_tmp1_);
		_tmp2_ = _tmp1_;
		gtk_button_set_image (_tmp0_, (GtkWidget*) _tmp2_);
		_g_object_unref0 (_tmp2_);
		_tmp3_ = self->priv->play_pause_button;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp3_, _ ("Continue the slideshow"));
	} else {
		GtkButton* _tmp4_;
		GtkImage* _tmp5_;
		GtkImage* _tmp6_;
		GtkButton* _tmp7_;
		_tmp4_ = self->priv->play_pause_button;
		_tmp5_ = (GtkImage*) gtk_image_new_from_icon_name ("media-playback-pause-symbolic", (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
		g_object_ref_sink (_tmp5_);
		_tmp6_ = _tmp5_;
		gtk_button_set_image (_tmp4_, (GtkWidget*) _tmp6_);
		_g_object_unref0 (_tmp6_);
		_tmp7_ = self->priv->play_pause_button;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp7_, _ ("Pause the slideshow"));
	}
	self->priv->playing = !self->priv->playing;
	_tmp8_ = self->priv->timer;
	g_timer_start (_tmp8_);
}

static void
slideshow_page_real_on_previous_photo (SinglePhotoPage* base)
{
	SlideshowPage * self;
	DataView* view = NULL;
	ViewCollection* _tmp0_;
	Photo* _tmp1_;
	DataView* _tmp2_;
	Photo* prev_photo = NULL;
	DataView* start_view = NULL;
	ViewCollection* _tmp3_;
	DataView* _tmp4_;
	DataView* _tmp5_;
	DataView* prev_view = NULL;
	DataView* _tmp6_;
	DataView* _tmp7_;
	Photo* _tmp21_;
	self = (SlideshowPage*) base;
	_tmp0_ = self->priv->_controller;
	_tmp1_ = self->priv->current;
	_tmp2_ = view_collection_get_view_for_source (_tmp0_, (DataSource*) _tmp1_);
	view = _tmp2_;
	prev_photo = NULL;
	_tmp3_ = self->priv->_controller;
	_tmp4_ = view;
	_tmp5_ = view_collection_get_previous (_tmp3_, _tmp4_);
	start_view = _tmp5_;
	_tmp6_ = start_view;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	prev_view = _tmp7_;
	while (TRUE) {
		DataView* _tmp8_;
		DataView* _tmp9_;
		DataSource* _tmp10_;
		DataSource* _tmp11_;
		ViewCollection* _tmp16_;
		DataView* _tmp17_;
		DataView* _tmp18_;
		DataView* _tmp19_;
		DataView* _tmp20_;
		_tmp8_ = prev_view;
		if (!(_tmp8_ != NULL)) {
			break;
		}
		_tmp9_ = prev_view;
		_tmp10_ = data_view_get_source (_tmp9_);
		_tmp11_ = _tmp10_;
		if (IS_PHOTO (_tmp11_)) {
			DataView* _tmp12_;
			DataSource* _tmp13_;
			DataSource* _tmp14_;
			Photo* _tmp15_;
			_tmp12_ = prev_view;
			_tmp13_ = data_view_get_source (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TYPE_PHOTO, Photo));
			_g_object_unref0 (prev_photo);
			prev_photo = _tmp15_;
			break;
		}
		_tmp16_ = self->priv->_controller;
		_tmp17_ = prev_view;
		_tmp18_ = view_collection_get_previous (_tmp16_, _tmp17_);
		_g_object_unref0 (prev_view);
		prev_view = _tmp18_;
		_tmp19_ = prev_view;
		_tmp20_ = start_view;
		if (_tmp19_ == _tmp20_) {
			g_warning ("SlideshowPage.vala:226: on_previous( ): can't advance to previous phot" \
"o: collection has only videos");
			_g_object_unref0 (prev_view);
			_g_object_unref0 (start_view);
			_g_object_unref0 (prev_photo);
			_g_object_unref0 (view);
			return;
		}
	}
	_tmp21_ = prev_photo;
	slideshow_page_advance (self, _tmp21_, DIRECTION_BACKWARD);
	_g_object_unref0 (prev_view);
	_g_object_unref0 (start_view);
	_g_object_unref0 (prev_photo);
	_g_object_unref0 (view);
}

static void
slideshow_page_real_on_next_photo (SinglePhotoPage* base)
{
	SlideshowPage * self;
	DataView* view = NULL;
	ViewCollection* _tmp0_;
	Photo* _tmp1_;
	DataView* _tmp2_;
	Photo* next_photo = NULL;
	DataView* start_view = NULL;
	ViewCollection* _tmp3_;
	DataView* _tmp4_;
	DataView* _tmp5_;
	DataView* next_view = NULL;
	DataView* _tmp6_;
	DataView* _tmp7_;
	GSettings* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gboolean _tmp24_;
	Photo* _tmp25_;
	self = (SlideshowPage*) base;
	_tmp0_ = self->priv->_controller;
	_tmp1_ = self->priv->current;
	_tmp2_ = view_collection_get_view_for_source (_tmp0_, (DataSource*) _tmp1_);
	view = _tmp2_;
	next_photo = NULL;
	_tmp3_ = self->priv->_controller;
	_tmp4_ = view;
	_tmp5_ = view_collection_get_next (_tmp3_, _tmp4_);
	start_view = _tmp5_;
	_tmp6_ = start_view;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	next_view = _tmp7_;
	while (TRUE) {
		DataView* _tmp8_;
		DataView* _tmp9_;
		DataSource* _tmp10_;
		DataSource* _tmp11_;
		ViewCollection* _tmp16_;
		DataView* _tmp17_;
		DataView* _tmp18_;
		DataView* _tmp19_;
		DataView* _tmp20_;
		_tmp8_ = next_view;
		if (!(_tmp8_ != NULL)) {
			break;
		}
		_tmp9_ = next_view;
		_tmp10_ = data_view_get_source (_tmp9_);
		_tmp11_ = _tmp10_;
		if (IS_PHOTO (_tmp11_)) {
			DataView* _tmp12_;
			DataSource* _tmp13_;
			DataSource* _tmp14_;
			Photo* _tmp15_;
			_tmp12_ = next_view;
			_tmp13_ = data_view_get_source (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TYPE_PHOTO, Photo));
			_g_object_unref0 (next_photo);
			next_photo = _tmp15_;
			break;
		}
		_tmp16_ = self->priv->_controller;
		_tmp17_ = next_view;
		_tmp18_ = view_collection_get_next (_tmp16_, _tmp17_);
		_g_object_unref0 (next_view);
		next_view = _tmp18_;
		_tmp19_ = next_view;
		_tmp20_ = start_view;
		if (_tmp19_ == _tmp20_) {
			g_warning ("SlideshowPage.vala:250: on_next( ): can't advance to next photo: colle" \
"ction has only videos");
			_g_object_unref0 (next_view);
			_g_object_unref0 (start_view);
			_g_object_unref0 (next_photo);
			_g_object_unref0 (view);
			return;
		}
	}
	_tmp21_ = self->priv->slideshow_settings;
	_tmp22_ = g_settings_get_string (_tmp21_, "transition-effect-id");
	_tmp23_ = _tmp22_;
	_tmp24_ = g_strcmp0 (_tmp23_, RANDOM_EFFECT_DESCRIPTOR_EFFECT_ID) == 0;
	_g_free0 (_tmp23_);
	if (_tmp24_) {
		slideshow_page_random_transition_effect (self);
	}
	_tmp25_ = next_photo;
	slideshow_page_advance (self, _tmp25_, DIRECTION_FORWARD);
	_g_object_unref0 (next_view);
	_g_object_unref0 (start_view);
	_g_object_unref0 (next_photo);
	_g_object_unref0 (view);
}

static void
slideshow_page_advance (SlideshowPage* self,
                        Photo* photo,
                        Direction direction)
{
	Photo* _tmp0_;
	GdkPixbuf* next_pixbuf = NULL;
	Photo* _tmp1_;
	Photo* _tmp2_ = NULL;
	GdkPixbuf* _tmp3_ = NULL;
	gboolean _tmp4_;
	GTimer* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (photo != NULL);
	_tmp0_ = _g_object_ref0 (photo);
	_g_object_unref0 (self->priv->current);
	self->priv->current = _tmp0_;
	_tmp1_ = self->priv->current;
	_tmp4_ = slideshow_page_get_next_photo (self, _tmp1_, direction, &_tmp2_, &_tmp3_);
	_g_object_unref0 (self->priv->current);
	self->priv->current = _tmp2_;
	_g_object_unref0 (next_pixbuf);
	next_pixbuf = _tmp3_;
	if (_tmp4_) {
		GdkPixbuf* _tmp5_;
		Photo* _tmp6_;
		Dimensions _tmp7_ = {0};
		_tmp5_ = next_pixbuf;
		_tmp6_ = self->priv->current;
		media_source_get_dimensions ((MediaSource*) _tmp6_, PHOTO_EXCEPTION_NONE, &_tmp7_);
		single_photo_page_set_pixbuf ((SinglePhotoPage*) self, _tmp5_, &_tmp7_, &direction);
	}
	_tmp8_ = self->priv->timer;
	g_timer_start (_tmp8_);
	_g_object_unref0 (next_pixbuf);
}

static gboolean
slideshow_page_auto_advance (SlideshowPage* self)
{
	GTimer* _tmp0_;
	GSettings* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->exiting) {
		result = FALSE;
		return result;
	}
	if (!self->priv->playing) {
		result = TRUE;
		return result;
	}
	_tmp0_ = self->priv->timer;
	_tmp1_ = self->priv->slideshow_settings;
	if (g_timer_elapsed (_tmp0_, NULL) < g_settings_get_double (_tmp1_, "delay")) {
		result = TRUE;
		return result;
	}
	single_photo_page_on_next_photo ((SinglePhotoPage*) self);
	result = TRUE;
	return result;
}

static gboolean
slideshow_page_real_button_press_event (GtkWidget* base,
                                        GdkEventButton* event)
{
	SlideshowPage * self;
	gboolean _tmp0_ = FALSE;
	gboolean result;
	self = (SlideshowPage*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->type == GDK_DOUBLE_BUTTON_PRESS) {
		_tmp0_ = event->button == ((guint) GDK_BUTTON_PRIMARY);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		AppWindow* _tmp1_;
		AppWindow* _tmp2_;
		g_signal_emit (self, slideshow_page_signals[SLIDESHOW_PAGE_HIDE_TOOLBAR_SIGNAL], 0);
		_tmp1_ = app_window_get_instance ();
		_tmp2_ = _tmp1_;
		app_window_end_fullscreen (_tmp2_);
		_g_object_unref0 (_tmp2_);
		page_switching_from ((Page*) self);
	}
	result = FALSE;
	return result;
}

static gboolean
slideshow_page_real_key_press_event (GtkWidget* base,
                                     GdkEventKey* event)
{
	SlideshowPage * self;
	gboolean handled = FALSE;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	gboolean _tmp4_ = FALSE;
	gboolean result;
	self = (SlideshowPage*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	handled = TRUE;
	_tmp0_ = gdk_keyval_name (event->keyval);
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("space")))) {
		switch (0) {
			default:
			{
				slideshow_page_on_play_pause (self);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				handled = FALSE;
				break;
			}
		}
	}
	if (handled) {
		result = TRUE;
		return result;
	}
	if (GTK_WIDGET_CLASS (slideshow_page_parent_class)->key_press_event != NULL) {
		_tmp4_ = GTK_WIDGET_CLASS (slideshow_page_parent_class)->key_press_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SINGLE_PHOTO_PAGE, SinglePhotoPage), event);
	} else {
		_tmp4_ = TRUE;
	}
	result = _tmp4_;
	return result;
}

static void
slideshow_page_update_transition_effect (SlideshowPage* self)
{
	gchar* effect_id = NULL;
	GSettings* _tmp0_;
	gchar* _tmp1_;
	gdouble effect_delay = 0.0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->slideshow_settings;
	_tmp1_ = g_settings_get_string (_tmp0_, "transition-effect-id");
	effect_id = _tmp1_;
	effect_delay = slideshow_page_calculate_effect_delay (self);
	single_photo_page_set_transition ((SinglePhotoPage*) self, effect_id, (gint) (effect_delay * 1000.0));
	_g_free0 (effect_id);
}

static void
slideshow_page_random_transition_effect (SlideshowPage* self)
{
	gdouble effect_delay = 0.0;
	gchar* effect_id = NULL;
	gchar* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp6_;
	g_return_if_fail (self != NULL);
	effect_delay = slideshow_page_calculate_effect_delay (self);
	_tmp0_ = g_strdup (TRANSITION_EFFECTS_MANAGER_NULL_EFFECT_ID);
	effect_id = _tmp0_;
	_tmp1_ = self->priv->transitions;
	_tmp1__length1 = self->priv->transitions_length1;
	if (0 < _tmp1__length1) {
		gint random = 0;
		gchar** _tmp2_;
		gint _tmp2__length1;
		gchar** _tmp3_;
		gint _tmp3__length1;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp2_ = self->priv->transitions;
		_tmp2__length1 = self->priv->transitions_length1;
		random = (gint) g_random_int_range ((gint32) 0, (gint32) _tmp2__length1);
		_tmp3_ = self->priv->transitions;
		_tmp3__length1 = self->priv->transitions_length1;
		_tmp4_ = _tmp3_[random];
		_tmp5_ = g_strdup (_tmp4_);
		_g_free0 (effect_id);
		effect_id = _tmp5_;
	}
	_tmp6_ = effect_id;
	single_photo_page_set_transition ((SinglePhotoPage*) self, _tmp6_, (gint) (effect_delay * 1000.0));
	_g_free0 (effect_id);
}

static gdouble
slideshow_page_calculate_effect_delay (SlideshowPage* self)
{
	gdouble photo_delay = 0.0;
	GSettings* _tmp0_;
	gdouble effect_delay = 0.0;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->priv->slideshow_settings;
	photo_delay = g_settings_get_double (_tmp0_, "delay");
	effect_delay = photo_delay / 7.0;
	if (effect_delay < 0.1) {
		effect_delay = 0.1;
	}
	if (effect_delay > 1.0) {
		effect_delay = 1.0;
	}
	result = effect_delay;
	return result;
}

static void
slideshow_page_paint_title (SlideshowPage* self,
                            cairo_t* ctx,
                            Dimensions* ctx_dim)
{
	gchar* title = NULL;
	Photo* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	PangoLayout* layout = NULL;
	const gchar* _tmp5_;
	PangoLayout* _tmp6_;
	PangoAttrList* list = NULL;
	PangoAttrList* _tmp7_;
	PangoAttribute* size = NULL;
	PangoAttribute* _tmp8_;
	PangoAttrList* _tmp9_;
	PangoAttribute* _tmp10_;
	PangoAttribute* _tmp11_;
	PangoLayout* _tmp12_;
	PangoAttrList* _tmp13_;
	PangoLayout* _tmp14_;
	Dimensions _tmp15_;
	gint title_width = 0;
	gint title_height = 0;
	PangoLayout* _tmp16_;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	gdouble x = 0.0;
	Dimensions _tmp19_;
	gdouble y = 0.0;
	Dimensions _tmp20_;
	Dimensions _tmp21_;
	Dimensions _tmp23_;
	PangoLayout* _tmp25_;
	PangoLayout* _tmp26_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (ctx_dim != NULL);
	_tmp0_ = self->priv->current;
	_tmp1_ = media_source_get_title ((MediaSource*) _tmp0_);
	title = _tmp1_;
	_tmp3_ = title;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = title;
		_tmp2_ = g_strcmp0 (_tmp4_, "") == 0;
	}
	if (_tmp2_) {
		_g_free0 (title);
		return;
	}
	_tmp5_ = title;
	_tmp6_ = gtk_widget_create_pango_layout ((GtkWidget*) self, _tmp5_);
	layout = _tmp6_;
	_tmp7_ = pango_attr_list_new ();
	list = _tmp7_;
	_tmp8_ = pango_attr_scale_new ((gdouble) 3);
	size = _tmp8_;
	_tmp9_ = list;
	_tmp10_ = size;
	_tmp11_ = pango_attribute_copy (_tmp10_);
	pango_attr_list_insert (_tmp9_, _tmp11_);
	_tmp12_ = layout;
	_tmp13_ = list;
	pango_layout_set_attributes (_tmp12_, _tmp13_);
	_tmp14_ = layout;
	_tmp15_ = *ctx_dim;
	pango_layout_set_width (_tmp14_, (gint) ((_tmp15_.width * 0.9) * PANGO_SCALE));
	_tmp16_ = layout;
	pango_layout_get_pixel_size (_tmp16_, &_tmp17_, &_tmp18_);
	title_width = _tmp17_;
	title_height = _tmp18_;
	_tmp19_ = *ctx_dim;
	x = _tmp19_.width * 0.2;
	_tmp20_ = *ctx_dim;
	y = _tmp20_.height * 0.90;
	_tmp21_ = *ctx_dim;
	if ((y + title_height) >= (_tmp21_.height * 0.95)) {
		Dimensions _tmp22_;
		_tmp22_ = *ctx_dim;
		y = (_tmp22_.height * 0.95) - title_height;
	}
	_tmp23_ = *ctx_dim;
	if ((x + title_width) >= (_tmp23_.width * 0.95)) {
		Dimensions _tmp24_;
		_tmp24_ = *ctx_dim;
		x = (gdouble) ((_tmp24_.width / 2) - (title_width / 2));
	}
	set_source_color_from_string (ctx, "#fff");
	cairo_move_to (ctx, x, y);
	_tmp25_ = layout;
	pango_cairo_show_layout (ctx, _tmp25_);
	_tmp26_ = layout;
	pango_cairo_layout_path (ctx, _tmp26_);
	cairo_set_line_width (ctx, 1.5);
	set_source_color_from_string (ctx, "#000");
	cairo_stroke (ctx);
	_pango_attribute_destroy0 (size);
	_pango_attr_list_unref0 (list);
	_g_object_unref0 (layout);
	_g_free0 (title);
}

static void
slideshow_page_real_paint (SinglePhotoPage* base,
                           cairo_t* ctx,
                           Dimensions* ctx_dim)
{
	SlideshowPage * self;
	Dimensions _tmp0_;
	gboolean _tmp1_ = FALSE;
	GSettings* _tmp2_;
	self = (SlideshowPage*) base;
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (ctx_dim != NULL);
	_tmp0_ = *ctx_dim;
	SINGLE_PHOTO_PAGE_CLASS (slideshow_page_parent_class)->paint (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SINGLE_PHOTO_PAGE, SinglePhotoPage), ctx, &_tmp0_);
	_tmp2_ = self->priv->slideshow_settings;
	if (g_settings_get_boolean (_tmp2_, "show-title")) {
		_tmp1_ = !single_photo_page_is_transition_in_progress ((SinglePhotoPage*) self);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		Dimensions _tmp3_;
		_tmp3_ = *ctx_dim;
		slideshow_page_paint_title (self, ctx, &_tmp3_);
	}
}

static void
slideshow_page_inhibit_screensaver (SlideshowPage* self)
{
	GApplication* _tmp0_;
	g_return_if_fail (self != NULL);
	if (self->priv->cookie != ((guint32) 0)) {
		return;
	}
	_tmp0_ = g_application_get_default ();
	self->priv->cookie = (guint32) photos_application_app_inhibit (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, PHOTOS_TYPE_APPLICATION, PhotosApplication), GTK_APPLICATION_INHIBIT_IDLE | GTK_APPLICATION_INHIBIT_SUSPEND, _ ("Slideshow"));
}

static void
slideshow_page_uninhibit_screensaver (SlideshowPage* self)
{
	GApplication* _tmp0_;
	g_return_if_fail (self != NULL);
	if (self->priv->cookie == ((guint32) 0)) {
		return;
	}
	_tmp0_ = g_application_get_default ();
	gtk_application_uninhibit ((GtkApplication*) G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, PHOTOS_TYPE_APPLICATION, PhotosApplication), (guint) self->priv->cookie);
	self->priv->cookie = (guint32) 0;
}

SourceCollection*
slideshow_page_get_sources (SlideshowPage* self)
{
	SourceCollection* result;
	SourceCollection* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_sources;
	result = _tmp0_;
	return result;
}

static gpointer
_data_collection_ref0 (gpointer self)
{
	return self ? data_collection_ref (self) : NULL;
}

static void
slideshow_page_set_sources (SlideshowPage* self,
                            SourceCollection* value)
{
	SourceCollection* old_value;
	g_return_if_fail (self != NULL);
	old_value = slideshow_page_get_sources (self);
	if (old_value != value) {
		SourceCollection* _tmp0_;
		_tmp0_ = _data_collection_ref0 (value);
		_data_collection_unref0 (self->priv->_sources);
		self->priv->_sources = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, slideshow_page_properties[SLIDESHOW_PAGE_SOURCES_PROPERTY]);
	}
}

ViewCollection*
slideshow_page_get_controller (SlideshowPage* self)
{
	ViewCollection* result;
	ViewCollection* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_controller;
	result = _tmp0_;
	return result;
}

static void
slideshow_page_set_controller (SlideshowPage* self,
                               ViewCollection* value)
{
	ViewCollection* old_value;
	g_return_if_fail (self != NULL);
	old_value = slideshow_page_get_controller (self);
	if (old_value != value) {
		ViewCollection* _tmp0_;
		_tmp0_ = _data_collection_ref0 (value);
		_data_collection_unref0 (self->priv->_controller);
		self->priv->_controller = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, slideshow_page_properties[SLIDESHOW_PAGE_CONTROLLER_PROPERTY]);
	}
}

static Block24Data*
block24_data_ref (Block24Data* _data24_)
{
	g_atomic_int_inc (&_data24_->_ref_count_);
	return _data24_;
}

static void
block24_data_unref (void * _userdata_)
{
	Block24Data* _data24_;
	_data24_ = (Block24Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data24_->_ref_count_)) {
		SlideshowPage* self;
		self = _data24_->self;
		_g_object_unref0 (_data24_->slider);
		_g_object_unref0 (_data24_->titles_toggle);
		_g_object_unref0 (self);
		g_slice_free (Block24Data, _data24_);
	}
}

static void
_slideshow_page___lambda32_ (SlideshowPage* self)
{
	slideshow_page_update_transition_effect (self);
}

static void
__slideshow_page___lambda32__g_settings_changed (GSettings* _sender,
                                                 const gchar* key,
                                                 gpointer self)
{
	_slideshow_page___lambda32_ ((SlideshowPage*) self);
}

static void
_single_photo_page_on_previous_photo_gtk_button_clicked (GtkButton* _sender,
                                                         gpointer self)
{
	single_photo_page_on_previous_photo ((SinglePhotoPage*) self);
}

static void
_slideshow_page_on_play_pause_gtk_button_clicked (GtkButton* _sender,
                                                  gpointer self)
{
	slideshow_page_on_play_pause ((SlideshowPage*) self);
}

static void
_single_photo_page_on_next_photo_gtk_button_clicked (GtkButton* _sender,
                                                     gpointer self)
{
	single_photo_page_on_next_photo ((SinglePhotoPage*) self);
}

static void
_slideshow_page___lambda38_ (Block24Data* _data24_)
{
	SlideshowPage* self;
	GSettings* _tmp0_;
	GtkToggleButton* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	self = _data24_->self;
	_tmp0_ = self->priv->slideshow_settings;
	_tmp1_ = _data24_->titles_toggle;
	_tmp2_ = gtk_toggle_button_get_active (_tmp1_);
	_tmp3_ = _tmp2_;
	g_settings_set_boolean (_tmp0_, "show-title", _tmp3_);
}

static void
__slideshow_page___lambda38__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                        gpointer self)
{
	_slideshow_page___lambda38_ (self);
}

static void
_slideshow_page___lambda39_ (Block24Data* _data24_)
{
	SlideshowPage* self;
	GSettings* _tmp0_;
	GtkScale* _tmp1_;
	self = _data24_->self;
	_tmp0_ = self->priv->slideshow_settings;
	_tmp1_ = _data24_->slider;
	g_settings_set_double (_tmp0_, "delay", gtk_range_get_value ((GtkRange*) _tmp1_));
}

static void
__slideshow_page___lambda39__gtk_range_value_changed (GtkRange* _sender,
                                                      gpointer self)
{
	_slideshow_page___lambda39_ (self);
}

static GObject *
slideshow_page_constructor (GType type,
                            guint n_construct_properties,
                            GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SlideshowPage * self;
	Block24Data* _data24_;
	GeeCollection* pluggables = NULL;
	TransitionEffectsManager* _tmp0_;
	TransitionEffectsManager* _tmp1_;
	GeeCollection* _tmp2_;
	GeeCollection* _tmp3_;
	GeeArrayList* a = NULL;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp5_;
	GeeCollection* _tmp6_;
	GeeArrayList* _tmp7_;
	GeeArrayList* _tmp8_;
	GeeArrayList* _tmp9_;
	gint _tmp10_ = 0;
	gpointer* _tmp11_;
	GSettings* _tmp12_;
	GSettings* _tmp13_;
	GtkButton* previous_button = NULL;
	GtkButton* _tmp14_;
	GtkButton* _tmp15_;
	GtkButton* _tmp16_;
	GtkButton* _tmp17_;
	GtkButton* _tmp18_;
	GtkButton* _tmp19_;
	GtkButton* next_button = NULL;
	GtkButton* _tmp20_;
	GtkButton* _tmp21_;
	GtkButton* _tmp22_;
	TransitionEffectSelector* effect_selector = NULL;
	TransitionEffectSelector* _tmp23_;
	GtkToggleButton* _tmp24_;
	GtkToggleButton* _tmp25_;
	GtkImage* _tmp26_;
	GtkImage* _tmp27_;
	GtkToggleButton* _tmp28_;
	GtkToggleButton* _tmp29_;
	GtkToggleButton* _tmp30_;
	GSettings* _tmp31_;
	GtkToggleButton* _tmp32_;
	GtkToggleButton* _tmp33_;
	GtkSizeGroup* dropdown_sizegroup = NULL;
	GtkSizeGroup* _tmp34_;
	GtkSizeGroup* _tmp35_;
	TransitionEffectSelector* _tmp36_;
	GtkSizeGroup* _tmp37_;
	GtkToggleButton* _tmp38_;
	GtkScale* _tmp39_;
	GtkScale* _tmp40_;
	GtkScale* _tmp41_;
	GtkScale* _tmp42_;
	GtkScale* _tmp43_;
	GtkScale* _tmp44_;
	GtkScale* _tmp45_;
	GtkScale* _tmp46_;
	GSettings* _tmp47_;
	GtkScale* _tmp48_;
	GtkToolItem* slider_wrapper = NULL;
	GtkToolItem* _tmp49_;
	GtkToolItem* _tmp50_;
	GtkToolItem* _tmp51_;
	GtkScale* _tmp52_;
	GtkActionBar* toolbar = NULL;
	GtkActionBar* _tmp53_;
	GtkActionBar* _tmp54_;
	GtkButton* _tmp55_;
	GtkActionBar* _tmp56_;
	GtkButton* _tmp57_;
	GtkActionBar* _tmp58_;
	GtkButton* _tmp59_;
	GtkActionBar* _tmp60_;
	GtkSeparator* _tmp61_;
	GtkSeparator* _tmp62_;
	GtkActionBar* _tmp63_;
	TransitionEffectSelector* _tmp64_;
	GtkActionBar* _tmp65_;
	GtkToggleButton* _tmp66_;
	GtkActionBar* _tmp67_;
	GtkToolItem* _tmp68_;
	GtkActionBar* _tmp69_;
	GtkSeparator* _tmp70_;
	GtkSeparator* _tmp71_;
	parent_class = G_OBJECT_CLASS (slideshow_page_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SLIDESHOW_PAGE, SlideshowPage);
	_data24_ = g_slice_new0 (Block24Data);
	_data24_->_ref_count_ = 1;
	_data24_->self = g_object_ref (self);
	_tmp0_ = transition_effects_manager_get_instance ();
	_tmp1_ = _tmp0_;
	_tmp2_ = transition_effects_manager_get_effect_ids (_tmp1_);
	_tmp3_ = _tmp2_;
	_transition_effects_manager_unref0 (_tmp1_);
	pluggables = _tmp3_;
	_tmp4_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	a = _tmp4_;
	_tmp5_ = a;
	_tmp6_ = pluggables;
	gee_array_list_add_all (_tmp5_, _tmp6_);
	_tmp7_ = a;
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp7_, NULL_TRANSITION_DESCRIPTOR_EFFECT_ID);
	_tmp8_ = a;
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp8_, RANDOM_EFFECT_DESCRIPTOR_EFFECT_ID);
	_tmp9_ = a;
	_tmp11_ = gee_collection_to_array ((GeeCollection*) _tmp9_, &_tmp10_);
	self->priv->transitions = (_vala_array_free (self->priv->transitions, self->priv->transitions_length1, (GDestroyNotify) g_free), NULL);
	self->priv->transitions = _tmp11_;
	self->priv->transitions_length1 = _tmp10_;
	self->priv->_transitions_size_ = self->priv->transitions_length1;
	_tmp12_ = g_settings_new (GSETTINGS_CONFIGURATION_ENGINE_SLIDESHOW_PREFS_SCHEMA_NAME);
	_g_object_unref0 (self->priv->slideshow_settings);
	self->priv->slideshow_settings = _tmp12_;
	_tmp13_ = self->priv->slideshow_settings;
	g_signal_connect_object (_tmp13_, "changed", (GCallback) __slideshow_page___lambda32__g_settings_changed, self, 0);
	slideshow_page_update_transition_effect (self);
	_tmp14_ = (GtkButton*) gtk_button_new_from_icon_name ("go-previous-symbolic", (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
	g_object_ref_sink (_tmp14_);
	previous_button = _tmp14_;
	_tmp15_ = previous_button;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp15_, _ ("Go to the previous photo"));
	_tmp16_ = previous_button;
	g_signal_connect_object (_tmp16_, "clicked", (GCallback) _single_photo_page_on_previous_photo_gtk_button_clicked, (SinglePhotoPage*) self, 0);
	_tmp17_ = (GtkButton*) gtk_button_new_from_icon_name ("media-playback-pause-symbolic", (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
	g_object_ref_sink (_tmp17_);
	_g_object_unref0 (self->priv->play_pause_button);
	self->priv->play_pause_button = _tmp17_;
	_tmp18_ = self->priv->play_pause_button;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp18_, _ ("Pause the slideshow"));
	_tmp19_ = self->priv->play_pause_button;
	g_signal_connect_object (_tmp19_, "clicked", (GCallback) _slideshow_page_on_play_pause_gtk_button_clicked, self, 0);
	_tmp20_ = (GtkButton*) gtk_button_new_from_icon_name ("go-next-symbolic", (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
	g_object_ref_sink (_tmp20_);
	next_button = _tmp20_;
	_tmp21_ = next_button;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp21_, _ ("Go to the next photo"));
	_tmp22_ = next_button;
	g_signal_connect_object (_tmp22_, "clicked", (GCallback) _single_photo_page_on_next_photo_gtk_button_clicked, (SinglePhotoPage*) self, 0);
	_tmp23_ = transition_effect_selector_new ();
	g_object_ref_sink (_tmp23_);
	effect_selector = _tmp23_;
	_tmp24_ = (GtkToggleButton*) gtk_toggle_button_new ();
	g_object_ref_sink (_tmp24_);
	_data24_->titles_toggle = _tmp24_;
	_tmp25_ = _data24_->titles_toggle;
	_tmp26_ = (GtkImage*) gtk_image_new_from_icon_name ("preferences-desktop-font-symbolic", (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
	g_object_ref_sink (_tmp26_);
	_tmp27_ = _tmp26_;
	gtk_button_set_image ((GtkButton*) _tmp25_, (GtkWidget*) _tmp27_);
	_g_object_unref0 (_tmp27_);
	_tmp28_ = _data24_->titles_toggle;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp28_, _ ("Show Photo Titles"));
	_tmp29_ = _data24_->titles_toggle;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp29_, 6);
	_tmp30_ = _data24_->titles_toggle;
	_tmp31_ = self->priv->slideshow_settings;
	gtk_toggle_button_set_active (_tmp30_, g_settings_get_boolean (_tmp31_, "show-title"));
	_tmp32_ = _data24_->titles_toggle;
	gtk_widget_set_valign ((GtkWidget*) _tmp32_, GTK_ALIGN_CENTER);
	_tmp33_ = _data24_->titles_toggle;
	g_signal_connect_data (_tmp33_, "toggled", (GCallback) __slideshow_page___lambda38__gtk_toggle_button_toggled, block24_data_ref (_data24_), (GClosureNotify) block24_data_unref, 0);
	_tmp34_ = gtk_size_group_new (GTK_SIZE_GROUP_VERTICAL);
	dropdown_sizegroup = _tmp34_;
	_tmp35_ = dropdown_sizegroup;
	_tmp36_ = effect_selector;
	gtk_size_group_add_widget (_tmp35_, (GtkWidget*) _tmp36_);
	_tmp37_ = dropdown_sizegroup;
	_tmp38_ = _data24_->titles_toggle;
	gtk_size_group_add_widget (_tmp37_, (GtkWidget*) _tmp38_);
	_tmp39_ = (GtkScale*) gtk_scale_new_with_range (GTK_ORIENTATION_HORIZONTAL, 0.5, 15.0, 0.5);
	g_object_ref_sink (_tmp39_);
	_data24_->slider = _tmp39_;
	_tmp40_ = _data24_->slider;
	gtk_scale_set_draw_value (_tmp40_, FALSE);
	_tmp41_ = _data24_->slider;
	gtk_range_set_inverted ((GtkRange*) _tmp41_, TRUE);
	_tmp42_ = _data24_->slider;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp42_, _ ("Transition Speed"));
	_tmp43_ = _data24_->slider;
	g_object_set ((GtkWidget*) _tmp43_, "width-request", 150, NULL);
	_tmp44_ = _data24_->slider;
	gtk_scale_add_mark (_tmp44_, 0.5, GTK_POS_BOTTOM, _ ("Faster"));
	_tmp45_ = _data24_->slider;
	gtk_scale_add_mark (_tmp45_, 15.0, GTK_POS_BOTTOM, _ ("Slower"));
	_tmp46_ = _data24_->slider;
	_tmp47_ = self->priv->slideshow_settings;
	gtk_range_set_value ((GtkRange*) _tmp46_, g_settings_get_double (_tmp47_, "delay"));
	_tmp48_ = _data24_->slider;
	g_signal_connect_data ((GtkRange*) _tmp48_, "value-changed", (GCallback) __slideshow_page___lambda39__gtk_range_value_changed, block24_data_ref (_data24_), (GClosureNotify) block24_data_unref, 0);
	_tmp49_ = gtk_tool_item_new ();
	g_object_ref_sink (_tmp49_);
	slider_wrapper = _tmp49_;
	_tmp50_ = slider_wrapper;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp50_, 6);
	_tmp51_ = slider_wrapper;
	_tmp52_ = _data24_->slider;
	gtk_container_add ((GtkContainer*) _tmp51_, (GtkWidget*) _tmp52_);
	_tmp53_ = page_get_toolbar ((Page*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SINGLE_PHOTO_PAGE, SinglePhotoPage), NULL, GTK_PACK_START);
	toolbar = _tmp53_;
	_tmp54_ = toolbar;
	_tmp55_ = previous_button;
	gtk_action_bar_pack_start (_tmp54_, (GtkWidget*) _tmp55_);
	_tmp56_ = toolbar;
	_tmp57_ = self->priv->play_pause_button;
	gtk_action_bar_pack_start (_tmp56_, (GtkWidget*) _tmp57_);
	_tmp58_ = toolbar;
	_tmp59_ = next_button;
	gtk_action_bar_pack_start (_tmp58_, (GtkWidget*) _tmp59_);
	_tmp60_ = toolbar;
	_tmp61_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_VERTICAL);
	g_object_ref_sink (_tmp61_);
	_tmp62_ = _tmp61_;
	gtk_container_add ((GtkContainer*) _tmp60_, (GtkWidget*) _tmp62_);
	_g_object_unref0 (_tmp62_);
	_tmp63_ = toolbar;
	_tmp64_ = effect_selector;
	gtk_action_bar_pack_start (_tmp63_, (GtkWidget*) _tmp64_);
	_tmp65_ = toolbar;
	_tmp66_ = _data24_->titles_toggle;
	gtk_action_bar_pack_start (_tmp65_, (GtkWidget*) _tmp66_);
	_tmp67_ = toolbar;
	_tmp68_ = slider_wrapper;
	gtk_action_bar_pack_start (_tmp67_, (GtkWidget*) _tmp68_);
	_tmp69_ = toolbar;
	_tmp70_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_VERTICAL);
	g_object_ref_sink (_tmp70_);
	_tmp71_ = _tmp70_;
	gtk_container_add ((GtkContainer*) _tmp69_, (GtkWidget*) _tmp71_);
	_g_object_unref0 (_tmp71_);
	_g_object_unref0 (toolbar);
	_g_object_unref0 (slider_wrapper);
	_g_object_unref0 (dropdown_sizegroup);
	_g_object_unref0 (effect_selector);
	_g_object_unref0 (next_button);
	_g_object_unref0 (previous_button);
	_g_object_unref0 (a);
	_g_object_unref0 (pluggables);
	block24_data_unref (_data24_);
	_data24_ = NULL;
	return obj;
}

static void
slideshow_page_class_init (SlideshowPageClass * klass,
                           gpointer klass_data)
{
	slideshow_page_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SlideshowPage_private_offset);
	((PageClass *) klass)->switched_to = (void (*) (Page*)) slideshow_page_real_switched_to;
	((PageClass *) klass)->switching_from = (void (*) (Page*)) slideshow_page_real_switching_from;
	((SinglePhotoPageClass *) klass)->on_previous_photo = (void (*) (SinglePhotoPage*)) slideshow_page_real_on_previous_photo;
	((SinglePhotoPageClass *) klass)->on_next_photo = (void (*) (SinglePhotoPage*)) slideshow_page_real_on_next_photo;
	((GtkWidgetClass *) klass)->button_press_event = (gboolean (*) (GtkWidget*, GdkEventButton*)) slideshow_page_real_button_press_event;
	((GtkWidgetClass *) klass)->key_press_event = (gboolean (*) (GtkWidget*, GdkEventKey*)) slideshow_page_real_key_press_event;
	((SinglePhotoPageClass *) klass)->paint = (void (*) (SinglePhotoPage*, cairo_t*, Dimensions*)) slideshow_page_real_paint;
	G_OBJECT_CLASS (klass)->get_property = _vala_slideshow_page_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_slideshow_page_set_property;
	G_OBJECT_CLASS (klass)->constructor = slideshow_page_constructor;
	G_OBJECT_CLASS (klass)->finalize = slideshow_page_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLIDESHOW_PAGE_SOURCES_PROPERTY, slideshow_page_properties[SLIDESHOW_PAGE_SOURCES_PROPERTY] = param_spec_data_collection ("sources", "sources", "sources", TYPE_SOURCE_COLLECTION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLIDESHOW_PAGE_CONTROLLER_PROPERTY, slideshow_page_properties[SLIDESHOW_PAGE_CONTROLLER_PROPERTY] = param_spec_data_collection ("controller", "controller", "controller", TYPE_VIEW_COLLECTION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	slideshow_page_signals[SLIDESHOW_PAGE_HIDE_TOOLBAR_SIGNAL] = g_signal_new ("hide-toolbar", TYPE_SLIDESHOW_PAGE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
slideshow_page_instance_init (SlideshowPage * self,
                              gpointer klass)
{
	GTimer* _tmp0_;
	self->priv = slideshow_page_get_instance_private (self);
	self->priv->cache = NULL;
	_tmp0_ = g_timer_new ();
	self->priv->timer = _tmp0_;
	self->priv->playing = TRUE;
	self->priv->exiting = FALSE;
	self->priv->cookie = (guint32) 0;
}

static void
slideshow_page_finalize (GObject * obj)
{
	SlideshowPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SLIDESHOW_PAGE, SlideshowPage);
	_g_object_unref0 (self->priv->current);
	_g_object_unref0 (self->priv->play_pause_button);
	_g_object_unref0 (self->priv->cache);
	_g_timer_destroy0 (self->priv->timer);
	self->priv->transitions = (_vala_array_free (self->priv->transitions, self->priv->transitions_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (self->priv->slideshow_settings);
	_data_collection_unref0 (self->priv->_sources);
	_data_collection_unref0 (self->priv->_controller);
	G_OBJECT_CLASS (slideshow_page_parent_class)->finalize (obj);
}

static GType
slideshow_page_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SlideshowPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) slideshow_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SlideshowPage), 0, (GInstanceInitFunc) slideshow_page_instance_init, NULL };
	GType slideshow_page_type_id;
	slideshow_page_type_id = g_type_register_static (TYPE_SINGLE_PHOTO_PAGE, "SlideshowPage", &g_define_type_info, 0);
	SlideshowPage_private_offset = g_type_add_instance_private (slideshow_page_type_id, sizeof (SlideshowPagePrivate));
	return slideshow_page_type_id;
}

GType
slideshow_page_get_type (void)
{
	static volatile gsize slideshow_page_type_id__once = 0;
	if (g_once_init_enter (&slideshow_page_type_id__once)) {
		GType slideshow_page_type_id;
		slideshow_page_type_id = slideshow_page_get_type_once ();
		g_once_init_leave (&slideshow_page_type_id__once, slideshow_page_type_id);
	}
	return slideshow_page_type_id__once;
}

static void
_vala_slideshow_page_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec)
{
	SlideshowPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SLIDESHOW_PAGE, SlideshowPage);
	switch (property_id) {
		case SLIDESHOW_PAGE_SOURCES_PROPERTY:
		value_set_data_collection (value, slideshow_page_get_sources (self));
		break;
		case SLIDESHOW_PAGE_CONTROLLER_PROPERTY:
		value_set_data_collection (value, slideshow_page_get_controller (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_slideshow_page_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec)
{
	SlideshowPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SLIDESHOW_PAGE, SlideshowPage);
	switch (property_id) {
		case SLIDESHOW_PAGE_SOURCES_PROPERTY:
		slideshow_page_set_sources (self, value_get_data_collection (value));
		break;
		case SLIDESHOW_PAGE_CONTROLLER_PROPERTY:
		slideshow_page_set_controller (self, value_get_data_collection (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

