/* MediaViewTracker.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from MediaViewTracker.vala, do not modify */

/*
* Copyright (c) 2011-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "io.elementary.photos.h"
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	MEDIA_ACCUMULATOR_0_PROPERTY,
	MEDIA_ACCUMULATOR_NUM_PROPERTIES
};
static GParamSpec* media_accumulator_properties[MEDIA_ACCUMULATOR_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

static gpointer media_view_tracker_parent_class = NULL;
static gpointer media_accumulator_parent_class = NULL;
static CoreTrackerAccumulatorIface * media_accumulator_core_tracker_accumulator_parent_iface = NULL;

static void media_view_tracker_finalize (CoreTracker * obj);
static GType media_view_tracker_get_type_once (void);
static gboolean media_accumulator_real_include (CoreTrackerAccumulator* base,
                                         DataObject* object);
static gboolean media_accumulator_real_uninclude (CoreTrackerAccumulator* base,
                                           DataObject* object);
static gboolean media_accumulator_real_altered (CoreTrackerAccumulator* base,
                                         DataObject* object,
                                         Alteration* alteration);
static void media_accumulator_finalize (GObject * obj);
static GType media_accumulator_get_type_once (void);

MediaViewTracker*
media_view_tracker_construct (GType object_type,
                              ViewCollection* collection)
{
	MediaViewTracker* self = NULL;
	MediaAccumulator* _tmp0_;
	MediaAccumulator* _tmp1_;
	MediaAccumulator* _tmp2_;
	g_return_val_if_fail (collection != NULL, NULL);
	self = (MediaViewTracker*) core_view_tracker_construct (object_type, collection);
	_tmp0_ = self->all;
	_tmp1_ = self->visible;
	_tmp2_ = self->selected;
	core_view_tracker_start ((CoreViewTracker*) self, (CoreTrackerAccumulator*) _tmp0_, (CoreTrackerAccumulator*) _tmp1_, (CoreTrackerAccumulator*) _tmp2_);
	return self;
}

MediaViewTracker*
media_view_tracker_new (ViewCollection* collection)
{
	return media_view_tracker_construct (TYPE_MEDIA_VIEW_TRACKER, collection);
}

static void
media_view_tracker_class_init (MediaViewTrackerClass * klass,
                               gpointer klass_data)
{
	media_view_tracker_parent_class = g_type_class_peek_parent (klass);
	((CoreTrackerClass *) klass)->finalize = media_view_tracker_finalize;
}

static void
media_view_tracker_instance_init (MediaViewTracker * self,
                                  gpointer klass)
{
	MediaAccumulator* _tmp0_;
	MediaAccumulator* _tmp1_;
	MediaAccumulator* _tmp2_;
	_tmp0_ = media_accumulator_new ();
	self->all = _tmp0_;
	_tmp1_ = media_accumulator_new ();
	self->visible = _tmp1_;
	_tmp2_ = media_accumulator_new ();
	self->selected = _tmp2_;
}

static void
media_view_tracker_finalize (CoreTracker * obj)
{
	MediaViewTracker * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MEDIA_VIEW_TRACKER, MediaViewTracker);
	_g_object_unref0 (self->all);
	_g_object_unref0 (self->visible);
	_g_object_unref0 (self->selected);
	CORE_TRACKER_CLASS (media_view_tracker_parent_class)->finalize (obj);
}

static GType
media_view_tracker_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MediaViewTrackerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) media_view_tracker_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MediaViewTracker), 0, (GInstanceInitFunc) media_view_tracker_instance_init, NULL };
	GType media_view_tracker_type_id;
	media_view_tracker_type_id = g_type_register_static (CORE_TYPE_VIEW_TRACKER, "MediaViewTracker", &g_define_type_info, 0);
	return media_view_tracker_type_id;
}

GType
media_view_tracker_get_type (void)
{
	static volatile gsize media_view_tracker_type_id__once = 0;
	if (g_once_init_enter (&media_view_tracker_type_id__once)) {
		GType media_view_tracker_type_id;
		media_view_tracker_type_id = media_view_tracker_get_type_once ();
		g_once_init_leave (&media_view_tracker_type_id__once, media_view_tracker_type_id);
	}
	return media_view_tracker_type_id__once;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
media_accumulator_real_include (CoreTrackerAccumulator* base,
                                DataObject* object)
{
	MediaAccumulator * self;
	DataSource* source = NULL;
	DataSource* _tmp0_;
	DataSource* _tmp1_;
	DataSource* _tmp2_;
	gint _tmp3_;
	Photo* photo = NULL;
	DataSource* _tmp4_;
	Photo* _tmp5_;
	Photo* _tmp6_;
	Flaggable* flaggable = NULL;
	DataSource* _tmp15_;
	Flaggable* _tmp16_;
	gboolean _tmp17_ = FALSE;
	Flaggable* _tmp18_;
	gboolean result;
	self = (MediaAccumulator*) base;
	g_return_val_if_fail (object != NULL, FALSE);
	_tmp0_ = data_view_get_source (G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DATA_VIEW, DataView));
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	source = _tmp2_;
	_tmp3_ = self->total;
	self->total = _tmp3_ + 1;
	_tmp4_ = source;
	_tmp5_ = _g_object_ref0 (IS_PHOTO (_tmp4_) ? ((Photo*) _tmp4_) : NULL);
	photo = _tmp5_;
	_tmp6_ = photo;
	if (_tmp6_ != NULL) {
		Photo* _tmp7_;
		gboolean _tmp9_ = FALSE;
		Photo* _tmp10_;
		_tmp7_ = photo;
		if (photo_get_master_file_format (_tmp7_) == PHOTO_FILE_FORMAT_RAW) {
			gint _tmp8_;
			_tmp8_ = self->raw;
			self->raw = _tmp8_ + 1;
		}
		_tmp10_ = photo;
		if (photo_get_master_file_format (_tmp10_) != PHOTO_FILE_FORMAT_RAW) {
			_tmp9_ = TRUE;
		} else {
			Photo* _tmp11_;
			_tmp11_ = photo;
			_tmp9_ = photo_is_raw_developer_available (_tmp11_, RAW_DEVELOPER_CAMERA);
		}
		if (_tmp9_) {
			gint _tmp12_;
			_tmp12_ = self->photos;
			self->photos = _tmp12_ + 1;
		}
	} else {
		DataSource* _tmp13_;
		_tmp13_ = source;
		if (IS_VIDEO_SOURCE (_tmp13_)) {
			gint _tmp14_;
			_tmp14_ = self->videos;
			self->videos = _tmp14_ + 1;
		}
	}
	_tmp15_ = source;
	_tmp16_ = _g_object_ref0 (IS_FLAGGABLE (_tmp15_) ? ((Flaggable*) _tmp15_) : NULL);
	flaggable = _tmp16_;
	_tmp18_ = flaggable;
	if (_tmp18_ != NULL) {
		Flaggable* _tmp19_;
		_tmp19_ = flaggable;
		_tmp17_ = flaggable_is_flagged (_tmp19_);
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		gint _tmp20_;
		_tmp20_ = self->flagged;
		self->flagged = _tmp20_ + 1;
	}
	result = TRUE;
	_g_object_unref0 (flaggable);
	_g_object_unref0 (photo);
	_g_object_unref0 (source);
	return result;
}

static gboolean
media_accumulator_real_uninclude (CoreTrackerAccumulator* base,
                                  DataObject* object)
{
	MediaAccumulator * self;
	DataSource* source = NULL;
	DataSource* _tmp0_;
	DataSource* _tmp1_;
	DataSource* _tmp2_;
	gint _tmp10_;
	Photo* photo = NULL;
	DataSource* _tmp11_;
	Photo* _tmp12_;
	Photo* _tmp13_;
	Flaggable* flaggable = NULL;
	DataSource* _tmp22_;
	Flaggable* _tmp23_;
	gboolean _tmp24_ = FALSE;
	Flaggable* _tmp25_;
	gboolean result;
	self = (MediaAccumulator*) base;
	g_return_val_if_fail (object != NULL, FALSE);
	_tmp0_ = data_view_get_source (G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DATA_VIEW, DataView));
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	source = _tmp2_;
	if (self->total < 1) {
		gchar* _tmp3_;
		gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp3_ = data_object_to_string (object);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_type_name (G_TYPE_FROM_INSTANCE ((GObject*) self));
		_tmp6_ = media_accumulator_to_string (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strdup_printf ("Tried to remove DataObject %s from empty %s (%s)", _tmp4_, _tmp5_, _tmp7_);
		_tmp9_ = _tmp8_;
		g_warning ("MediaViewTracker.vala:70: %s", _tmp9_);
		_g_free0 (_tmp9_);
		_g_free0 (_tmp7_);
		_g_free0 (_tmp4_);
		result = FALSE;
		_g_object_unref0 (source);
		return result;
	}
	_tmp10_ = self->total;
	self->total = _tmp10_ - 1;
	_tmp11_ = source;
	_tmp12_ = _g_object_ref0 (IS_PHOTO (_tmp11_) ? ((Photo*) _tmp11_) : NULL);
	photo = _tmp12_;
	_tmp13_ = photo;
	if (_tmp13_ != NULL) {
		Photo* _tmp14_;
		gboolean _tmp16_ = FALSE;
		Photo* _tmp17_;
		_tmp14_ = photo;
		if (photo_get_master_file_format (_tmp14_) == PHOTO_FILE_FORMAT_RAW) {
			gint _tmp15_;
			_vala_assert (self->raw > 0, "raw > 0");
			_tmp15_ = self->raw;
			self->raw = _tmp15_ - 1;
		}
		_tmp17_ = photo;
		if (photo_get_master_file_format (_tmp17_) != PHOTO_FILE_FORMAT_RAW) {
			_tmp16_ = TRUE;
		} else {
			Photo* _tmp18_;
			_tmp18_ = photo;
			_tmp16_ = photo_is_raw_developer_available (_tmp18_, RAW_DEVELOPER_CAMERA);
		}
		if (_tmp16_) {
			gint _tmp19_;
			_vala_assert (self->photos > 0, "photos > 0");
			_tmp19_ = self->photos;
			self->photos = _tmp19_ - 1;
		}
	} else {
		DataSource* _tmp20_;
		_tmp20_ = source;
		if (IS_VIDEO (_tmp20_)) {
			gint _tmp21_;
			_vala_assert (self->videos > 0, "videos > 0");
			_tmp21_ = self->videos;
			self->videos = _tmp21_ - 1;
		}
	}
	_tmp22_ = source;
	_tmp23_ = _g_object_ref0 (IS_FLAGGABLE (_tmp22_) ? ((Flaggable*) _tmp22_) : NULL);
	flaggable = _tmp23_;
	_tmp25_ = flaggable;
	if (_tmp25_ != NULL) {
		Flaggable* _tmp26_;
		_tmp26_ = flaggable;
		_tmp24_ = flaggable_is_flagged (_tmp26_);
	} else {
		_tmp24_ = FALSE;
	}
	if (_tmp24_) {
		gint _tmp27_;
		_vala_assert (self->flagged > 0, "flagged > 0");
		_tmp27_ = self->flagged;
		self->flagged = _tmp27_ - 1;
	}
	result = TRUE;
	_g_object_unref0 (flaggable);
	_g_object_unref0 (photo);
	_g_object_unref0 (source);
	return result;
}

static gboolean
media_accumulator_real_altered (CoreTrackerAccumulator* base,
                                DataObject* object,
                                Alteration* alteration)
{
	MediaAccumulator * self;
	Flaggable* flaggable = NULL;
	DataSource* _tmp0_;
	DataSource* _tmp1_;
	Flaggable* _tmp2_;
	Flaggable* _tmp3_;
	Flaggable* _tmp4_;
	gboolean result;
	self = (MediaAccumulator*) base;
	g_return_val_if_fail (object != NULL, FALSE);
	g_return_val_if_fail (alteration != NULL, FALSE);
	if (!alteration_has_detail (alteration, "metadata", "flagged")) {
		result = FALSE;
		return result;
	}
	_tmp0_ = data_view_get_source (G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DATA_VIEW, DataView));
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (IS_FLAGGABLE (_tmp1_) ? ((Flaggable*) _tmp1_) : NULL);
	flaggable = _tmp2_;
	_tmp3_ = flaggable;
	if (_tmp3_ == NULL) {
		result = FALSE;
		_g_object_unref0 (flaggable);
		return result;
	}
	_tmp4_ = flaggable;
	if (flaggable_is_flagged (_tmp4_)) {
		gint _tmp5_;
		_tmp5_ = self->flagged;
		self->flagged = _tmp5_ + 1;
	} else {
		gint _tmp6_;
		_vala_assert (self->flagged > 0, "flagged > 0");
		_tmp6_ = self->flagged;
		self->flagged = _tmp6_ - 1;
	}
	result = TRUE;
	_g_object_unref0 (flaggable);
	return result;
}

gchar*
media_accumulator_to_string (MediaAccumulator* self)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup_printf ("%d photos/%d videos/%d raw/%d flagged", self->photos, self->videos, self->raw, self->flagged);
	result = _tmp0_;
	return result;
}

MediaAccumulator*
media_accumulator_construct (GType object_type)
{
	MediaAccumulator * self = NULL;
	self = (MediaAccumulator*) g_object_new (object_type, NULL);
	return self;
}

MediaAccumulator*
media_accumulator_new (void)
{
	return media_accumulator_construct (TYPE_MEDIA_ACCUMULATOR);
}

static void
media_accumulator_class_init (MediaAccumulatorClass * klass,
                              gpointer klass_data)
{
	media_accumulator_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = media_accumulator_finalize;
}

static void
media_accumulator_core_tracker_accumulator_interface_init (CoreTrackerAccumulatorIface * iface,
                                                           gpointer iface_data)
{
	media_accumulator_core_tracker_accumulator_parent_iface = g_type_interface_peek_parent (iface);
	iface->include = (gboolean (*) (CoreTrackerAccumulator*, DataObject*)) media_accumulator_real_include;
	iface->uninclude = (gboolean (*) (CoreTrackerAccumulator*, DataObject*)) media_accumulator_real_uninclude;
	iface->altered = (gboolean (*) (CoreTrackerAccumulator*, DataObject*, Alteration*)) media_accumulator_real_altered;
}

static void
media_accumulator_instance_init (MediaAccumulator * self,
                                 gpointer klass)
{
	self->total = 0;
	self->photos = 0;
	self->videos = 0;
	self->raw = 0;
	self->flagged = 0;
}

static void
media_accumulator_finalize (GObject * obj)
{
	MediaAccumulator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MEDIA_ACCUMULATOR, MediaAccumulator);
	G_OBJECT_CLASS (media_accumulator_parent_class)->finalize (obj);
}

static GType
media_accumulator_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MediaAccumulatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) media_accumulator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MediaAccumulator), 0, (GInstanceInitFunc) media_accumulator_instance_init, NULL };
	static const GInterfaceInfo core_tracker_accumulator_info = { (GInterfaceInitFunc) media_accumulator_core_tracker_accumulator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType media_accumulator_type_id;
	media_accumulator_type_id = g_type_register_static (G_TYPE_OBJECT, "MediaAccumulator", &g_define_type_info, 0);
	g_type_add_interface_static (media_accumulator_type_id, CORE_TYPE_TRACKER_ACCUMULATOR, &core_tracker_accumulator_info);
	return media_accumulator_type_id;
}

GType
media_accumulator_get_type (void)
{
	static volatile gsize media_accumulator_type_id__once = 0;
	if (g_once_init_enter (&media_accumulator_type_id__once)) {
		GType media_accumulator_type_id;
		media_accumulator_type_id = media_accumulator_get_type_once ();
		g_once_init_leave (&media_accumulator_type_id__once, media_accumulator_type_id);
	}
	return media_accumulator_type_id__once;
}

