/******************************************************************************
 * Author:   Laurent Kneip                                                    *
 * Contact:  kneip.laurent@gmail.com                                          *
 * License:  Copyright (c) 2013 Laurent Kneip, ANU. All rights reserved.      *
 *                                                                            *
 * Redistribution and use in source and binary forms, with or without         *
 * modification, are permitted provided that the following conditions         *
 * are met:                                                                   *
 * * Redistributions of source code must retain the above copyright           *
 *   notice, this list of conditions and the following disclaimer.            *
 * * Redistributions in binary form must reproduce the above copyright        *
 *   notice, this list of conditions and the following disclaimer in the      *
 *   documentation and/or other materials provided with the distribution.     *
 * * Neither the name of ANU nor the names of its contributors may be         *
 *   used to endorse or promote products derived from this software without   *
 *   specific prior written permission.                                       *
 *                                                                            *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"*
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE  *
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE *
 * ARE DISCLAIMED. IN NO EVENT SHALL ANU OR THE CONTRIBUTORS BE LIABLE        *
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL *
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR *
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER *
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT         *
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY  *
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF     *
 * SUCH DAMAGE.                                                               *
 ******************************************************************************/

#include <opengv/absolute_pose/modules/upnp2.hpp>
#include <opengv/math/gauss_jordan.hpp>
#include <opengv/math/roots.hpp>

void
opengv::absolute_pose::modules::upnp::setupAction_gj(
    const Eigen::Matrix<double,10,10> & M,
    const Eigen::Matrix<double,1,10> & C,
    double gamma,
    Eigen::Matrix<double,16,16> & Action )
{
  Eigen::Matrix<double,5,29> M1 = Eigen::Matrix<double,5,29>::Zero();
M1(0,0) = 4*M(0,0); M1(0,1) = 4*M(4,0)+2*M(0,4); M1(0,2) = 2*M(4,4)+4*M(1,0); M1(0,3) = 2*M(1,4); M1(0,4) = 4*M(5,0)+2*M(0,5); M1(0,5) = 4*M(7,0)+2*M(5,4)+2*M(4,5); M1(0,6) = 2*M(7,4)+2*M(1,5); M1(0,7) = 2*M(5,5)+4*M(2,0); M1(0,8) = 2*M(7,5)+2*M(2,4); M1(0,9) = 2*M(2,5); M1(0,10) = 4*M(6,0)+2*M(0,6); M1(0,11) = 4*M(8,0)+2*M(6,4)+2*M(4,6); M1(0,12) = 2*M(8,4)+2*M(1,6); M1(0,13) = 4*M(9,0)+2*M(6,5)+2*M(5,6); M1(0,14) = 2*M(9,4)+2*M(8,5)+2*M(7,6); M1(0,15) = 2*M(9,5)+2*M(2,6); M1(0,16) = 2*M(6,6)+4*M(3,0); M1(0,17) = 2*M(8,6)+2*M(3,4); M1(0,18) = 2*M(9,6)+2*M(3,5); M1(0,19) = 2*M(3,6); M1(0,24) = 4*C(0,0); M1(0,25) = 2*C(0,4); M1(0,26) = 2*C(0,5); M1(0,27) = 2*C(0,6); 
M1(1,0) = 2*M(0,4); M1(1,1) = 2*M(4,4)+4*M(0,1); M1(1,2) = 4*M(4,1)+2*M(1,4); M1(1,3) = 4*M(1,1); M1(1,4) = 2*M(5,4)+2*M(0,7); M1(1,5) = 2*M(7,4)+4*M(5,1)+2*M(4,7); M1(1,6) = 4*M(7,1)+2*M(1,7); M1(1,7) = 2*M(5,7)+2*M(2,4); M1(1,8) = 2*M(7,7)+4*M(2,1); M1(1,9) = 2*M(2,7); M1(1,10) = 2*M(6,4)+2*M(0,8); M1(1,11) = 2*M(8,4)+4*M(6,1)+2*M(4,8); M1(1,12) = 4*M(8,1)+2*M(1,8); M1(1,13) = 2*M(9,4)+2*M(6,7)+2*M(5,8); M1(1,14) = 4*M(9,1)+2*M(8,7)+2*M(7,8); M1(1,15) = 2*M(9,7)+2*M(2,8); M1(1,16) = 2*M(6,8)+2*M(3,4); M1(1,17) = 2*M(8,8)+4*M(3,1); M1(1,18) = 2*M(9,8)+2*M(3,7); M1(1,19) = 2*M(3,8); M1(1,24) = 2*C(0,4); M1(1,25) = 4*C(0,1); M1(1,26) = 2*C(0,7); M1(1,27) = 2*C(0,8); 
M1(2,0) = 2*M(0,5); M1(2,1) = 2*M(4,5)+2*M(0,7); M1(2,2) = 2*M(4,7)+2*M(1,5); M1(2,3) = 2*M(1,7); M1(2,4) = 2*M(5,5)+4*M(0,2); M1(2,5) = 2*M(7,5)+2*M(5,7)+4*M(4,2); M1(2,6) = 2*M(7,7)+4*M(1,2); M1(2,7) = 4*M(5,2)+2*M(2,5); M1(2,8) = 4*M(7,2)+2*M(2,7); M1(2,9) = 4*M(2,2); M1(2,10) = 2*M(6,5)+2*M(0,9); M1(2,11) = 2*M(8,5)+2*M(6,7)+2*M(4,9); M1(2,12) = 2*M(8,7)+2*M(1,9); M1(2,13) = 2*M(9,5)+4*M(6,2)+2*M(5,9); M1(2,14) = 2*M(9,7)+4*M(8,2)+2*M(7,9); M1(2,15) = 4*M(9,2)+2*M(2,9); M1(2,16) = 2*M(6,9)+2*M(3,5); M1(2,17) = 2*M(8,9)+2*M(3,7); M1(2,18) = 2*M(9,9)+4*M(3,2); M1(2,19) = 2*M(3,9); M1(2,24) = 2*C(0,5); M1(2,25) = 2*C(0,7); M1(2,26) = 4*C(0,2); M1(2,27) = 2*C(0,9); 
M1(3,0) = 2*M(0,6); M1(3,1) = 2*M(4,6)+2*M(0,8); M1(3,2) = 2*M(4,8)+2*M(1,6); M1(3,3) = 2*M(1,8); M1(3,4) = 2*M(5,6)+2*M(0,9); M1(3,5) = 2*M(7,6)+2*M(5,8)+2*M(4,9); M1(3,6) = 2*M(7,8)+2*M(1,9); M1(3,7) = 2*M(5,9)+2*M(2,6); M1(3,8) = 2*M(7,9)+2*M(2,8); M1(3,9) = 2*M(2,9); M1(3,10) = 2*M(6,6)+4*M(0,3); M1(3,11) = 2*M(8,6)+2*M(6,8)+4*M(4,3); M1(3,12) = 2*M(8,8)+4*M(1,3); M1(3,13) = 2*M(9,6)+2*M(6,9)+4*M(5,3); M1(3,14) = 2*M(9,8)+2*M(8,9)+4*M(7,3); M1(3,15) = 2*M(9,9)+4*M(2,3); M1(3,16) = 4*M(6,3)+2*M(3,6); M1(3,17) = 4*M(8,3)+2*M(3,8); M1(3,18) = 4*M(9,3)+2*M(3,9); M1(3,19) = 4*M(3,3); M1(3,24) = 2*C(0,6); M1(3,25) = 2*C(0,8); M1(3,26) = 2*C(0,9); M1(3,27) = 4*C(0,3); 
M1(4,20) = 1; M1(4,21) = 1; M1(4,22) = 1; M1(4,23) = 1; M1(4,28) = -1; 
  
Eigen::Matrix<double,4,4> M1_part1 = M1.block<4,4>(0,0);
Eigen::Matrix<double,4,29> M1_part2 = M1_part1.inverse() * M1.block<4,29>(0,0);
M1.block<4,29>(0,0) = M1_part2;
  
  std::vector<std::vector<double>*> M2;
for( int r = 0; r < 395; r++ )
{
  std::vector<double> * row = new std::vector<double>();
  for( int c = 0; c < 412; c++ )
    row->push_back(0.0);
  M2.push_back(row);
}
(*(M2[0]))[59] = M1(4,20); (*(M2[0]))[61] = M1(4,21); (*(M2[0]))[70] = M1(4,22); (*(M2[0]))[91] = M1(4,23); (*(M2[0]))[252] = M1(4,28); 
(*(M2[1]))[40] = M1(4,20); (*(M2[1]))[42] = M1(4,21); (*(M2[1]))[51] = M1(4,22); (*(M2[1]))[83] = M1(4,23); (*(M2[1]))[237] = M1(4,28); 
(*(M2[2]))[14] = M1(4,20); (*(M2[2]))[16] = M1(4,21); (*(M2[2]))[25] = M1(4,22); (*(M2[2]))[70] = M1(4,23); (*(M2[2]))[216] = M1(4,28); 
(*(M2[3]))[34] = M1(4,20); (*(M2[3]))[36] = M1(4,21); (*(M2[3]))[47] = M1(4,22); (*(M2[3]))[79] = M1(4,23); (*(M2[3]))[232] = M1(4,28); 
(*(M2[4]))[8] = M1(4,20); (*(M2[4]))[10] = M1(4,21); (*(M2[4]))[21] = M1(4,22); (*(M2[4]))[66] = M1(4,23); (*(M2[4]))[211] = M1(4,28); 
(*(M2[5]))[2] = M1(4,20); (*(M2[5]))[4] = M1(4,21); (*(M2[5]))[16] = M1(4,22); (*(M2[5]))[61] = M1(4,23); (*(M2[5]))[205] = M1(4,28); 
(*(M2[6]))[33] = M1(4,20); (*(M2[6]))[35] = M1(4,21); (*(M2[6]))[46] = M1(4,22); (*(M2[6]))[78] = M1(4,23); (*(M2[6]))[231] = M1(4,28); 
(*(M2[7]))[7] = M1(4,20); (*(M2[7]))[9] = M1(4,21); (*(M2[7]))[20] = M1(4,22); (*(M2[7]))[65] = M1(4,23); (*(M2[7]))[210] = M1(4,28); 
(*(M2[8]))[1] = M1(4,20); (*(M2[8]))[3] = M1(4,21); (*(M2[8]))[15] = M1(4,22); (*(M2[8]))[60] = M1(4,23); (*(M2[8]))[204] = M1(4,28); 
(*(M2[9]))[0] = M1(4,20); (*(M2[9]))[2] = M1(4,21); (*(M2[9]))[14] = M1(4,22); (*(M2[9]))[59] = M1(4,23); (*(M2[9]))[203] = M1(4,28); 
(*(M2[10]))[61] = M1(0,0); (*(M2[10]))[67] = M1(0,4); (*(M2[10]))[68] = M1(0,5); (*(M2[10]))[69] = M1(0,6); (*(M2[10]))[72] = M1(0,7); (*(M2[10]))[73] = M1(0,8); (*(M2[10]))[76] = M1(0,9); (*(M2[10]))[80] = M1(0,10); (*(M2[10]))[81] = M1(0,11); (*(M2[10]))[82] = M1(0,12); (*(M2[10]))[85] = M1(0,13); (*(M2[10]))[86] = M1(0,14); (*(M2[10]))[89] = M1(0,15); (*(M2[10]))[93] = M1(0,16); (*(M2[10]))[94] = M1(0,17); (*(M2[10]))[97] = M1(0,18); (*(M2[10]))[254] = M1(0,24); (*(M2[10]))[255] = M1(0,25); (*(M2[10]))[259] = M1(0,26); (*(M2[10]))[269] = M1(0,27); (*(M2[10]))[395] = M1(0,19); 
(*(M2[11]))[62] = M1(1,1); (*(M2[11]))[67] = M1(1,4); (*(M2[11]))[68] = M1(1,5); (*(M2[11]))[69] = M1(1,6); (*(M2[11]))[72] = M1(1,7); (*(M2[11]))[73] = M1(1,8); (*(M2[11]))[76] = M1(1,9); (*(M2[11]))[80] = M1(1,10); (*(M2[11]))[81] = M1(1,11); (*(M2[11]))[82] = M1(1,12); (*(M2[11]))[85] = M1(1,13); (*(M2[11]))[86] = M1(1,14); (*(M2[11]))[89] = M1(1,15); (*(M2[11]))[93] = M1(1,16); (*(M2[11]))[94] = M1(1,17); (*(M2[11]))[97] = M1(1,18); (*(M2[11]))[254] = M1(1,24); (*(M2[11]))[255] = M1(1,25); (*(M2[11]))[259] = M1(1,26); (*(M2[11]))[269] = M1(1,27); (*(M2[11]))[395] = M1(1,19); 
(*(M2[12]))[63] = M1(2,2); (*(M2[12]))[67] = M1(2,4); (*(M2[12]))[68] = M1(2,5); (*(M2[12]))[69] = M1(2,6); (*(M2[12]))[72] = M1(2,7); (*(M2[12]))[73] = M1(2,8); (*(M2[12]))[76] = M1(2,9); (*(M2[12]))[80] = M1(2,10); (*(M2[12]))[81] = M1(2,11); (*(M2[12]))[82] = M1(2,12); (*(M2[12]))[85] = M1(2,13); (*(M2[12]))[86] = M1(2,14); (*(M2[12]))[89] = M1(2,15); (*(M2[12]))[93] = M1(2,16); (*(M2[12]))[94] = M1(2,17); (*(M2[12]))[97] = M1(2,18); (*(M2[12]))[254] = M1(2,24); (*(M2[12]))[255] = M1(2,25); (*(M2[12]))[259] = M1(2,26); (*(M2[12]))[269] = M1(2,27); (*(M2[12]))[395] = M1(2,19); 
(*(M2[13]))[64] = M1(3,3); (*(M2[13]))[67] = M1(3,4); (*(M2[13]))[68] = M1(3,5); (*(M2[13]))[69] = M1(3,6); (*(M2[13]))[72] = M1(3,7); (*(M2[13]))[73] = M1(3,8); (*(M2[13]))[76] = M1(3,9); (*(M2[13]))[80] = M1(3,10); (*(M2[13]))[81] = M1(3,11); (*(M2[13]))[82] = M1(3,12); (*(M2[13]))[85] = M1(3,13); (*(M2[13]))[86] = M1(3,14); (*(M2[13]))[89] = M1(3,15); (*(M2[13]))[93] = M1(3,16); (*(M2[13]))[94] = M1(3,17); (*(M2[13]))[97] = M1(3,18); (*(M2[13]))[254] = M1(3,24); (*(M2[13]))[255] = M1(3,25); (*(M2[13]))[259] = M1(3,26); (*(M2[13]))[269] = M1(3,27); (*(M2[13]))[395] = M1(3,19); 
(*(M2[14]))[42] = M1(0,0); (*(M2[14]))[48] = M1(0,4); (*(M2[14]))[49] = M1(0,5); (*(M2[14]))[50] = M1(0,6); (*(M2[14]))[53] = M1(0,7); (*(M2[14]))[54] = M1(0,8); (*(M2[14]))[57] = M1(0,9); (*(M2[14]))[67] = M1(0,10); (*(M2[14]))[68] = M1(0,11); (*(M2[14]))[69] = M1(0,12); (*(M2[14]))[72] = M1(0,13); (*(M2[14]))[73] = M1(0,14); (*(M2[14]))[76] = M1(0,15); (*(M2[14]))[85] = M1(0,16); (*(M2[14]))[86] = M1(0,17); (*(M2[14]))[89] = M1(0,18); (*(M2[14]))[97] = M1(0,19); (*(M2[14]))[239] = M1(0,24); (*(M2[14]))[240] = M1(0,25); (*(M2[14]))[244] = M1(0,26); (*(M2[14]))[259] = M1(0,27); 
(*(M2[15]))[43] = M1(1,1); (*(M2[15]))[48] = M1(1,4); (*(M2[15]))[49] = M1(1,5); (*(M2[15]))[50] = M1(1,6); (*(M2[15]))[53] = M1(1,7); (*(M2[15]))[54] = M1(1,8); (*(M2[15]))[57] = M1(1,9); (*(M2[15]))[67] = M1(1,10); (*(M2[15]))[68] = M1(1,11); (*(M2[15]))[69] = M1(1,12); (*(M2[15]))[72] = M1(1,13); (*(M2[15]))[73] = M1(1,14); (*(M2[15]))[76] = M1(1,15); (*(M2[15]))[85] = M1(1,16); (*(M2[15]))[86] = M1(1,17); (*(M2[15]))[89] = M1(1,18); (*(M2[15]))[97] = M1(1,19); (*(M2[15]))[239] = M1(1,24); (*(M2[15]))[240] = M1(1,25); (*(M2[15]))[244] = M1(1,26); (*(M2[15]))[259] = M1(1,27); 
(*(M2[16]))[44] = M1(2,2); (*(M2[16]))[48] = M1(2,4); (*(M2[16]))[49] = M1(2,5); (*(M2[16]))[50] = M1(2,6); (*(M2[16]))[53] = M1(2,7); (*(M2[16]))[54] = M1(2,8); (*(M2[16]))[57] = M1(2,9); (*(M2[16]))[67] = M1(2,10); (*(M2[16]))[68] = M1(2,11); (*(M2[16]))[69] = M1(2,12); (*(M2[16]))[72] = M1(2,13); (*(M2[16]))[73] = M1(2,14); (*(M2[16]))[76] = M1(2,15); (*(M2[16]))[85] = M1(2,16); (*(M2[16]))[86] = M1(2,17); (*(M2[16]))[89] = M1(2,18); (*(M2[16]))[97] = M1(2,19); (*(M2[16]))[239] = M1(2,24); (*(M2[16]))[240] = M1(2,25); (*(M2[16]))[244] = M1(2,26); (*(M2[16]))[259] = M1(2,27); 
(*(M2[17]))[45] = M1(3,3); (*(M2[17]))[48] = M1(3,4); (*(M2[17]))[49] = M1(3,5); (*(M2[17]))[50] = M1(3,6); (*(M2[17]))[53] = M1(3,7); (*(M2[17]))[54] = M1(3,8); (*(M2[17]))[57] = M1(3,9); (*(M2[17]))[67] = M1(3,10); (*(M2[17]))[68] = M1(3,11); (*(M2[17]))[69] = M1(3,12); (*(M2[17]))[72] = M1(3,13); (*(M2[17]))[73] = M1(3,14); (*(M2[17]))[76] = M1(3,15); (*(M2[17]))[85] = M1(3,16); (*(M2[17]))[86] = M1(3,17); (*(M2[17]))[89] = M1(3,18); (*(M2[17]))[97] = M1(3,19); (*(M2[17]))[239] = M1(3,24); (*(M2[17]))[240] = M1(3,25); (*(M2[17]))[244] = M1(3,26); (*(M2[17]))[259] = M1(3,27); 
(*(M2[18]))[16] = M1(0,0); (*(M2[18]))[22] = M1(0,4); (*(M2[18]))[23] = M1(0,5); (*(M2[18]))[24] = M1(0,6); (*(M2[18]))[27] = M1(0,7); (*(M2[18]))[28] = M1(0,8); (*(M2[18]))[31] = M1(0,9); (*(M2[18]))[48] = M1(0,10); (*(M2[18]))[49] = M1(0,11); (*(M2[18]))[50] = M1(0,12); (*(M2[18]))[53] = M1(0,13); (*(M2[18]))[54] = M1(0,14); (*(M2[18]))[57] = M1(0,15); (*(M2[18]))[72] = M1(0,16); (*(M2[18]))[73] = M1(0,17); (*(M2[18]))[76] = M1(0,18); (*(M2[18]))[89] = M1(0,19); (*(M2[18]))[218] = M1(0,24); (*(M2[18]))[219] = M1(0,25); (*(M2[18]))[223] = M1(0,26); (*(M2[18]))[244] = M1(0,27); 
(*(M2[19]))[17] = M1(1,1); (*(M2[19]))[22] = M1(1,4); (*(M2[19]))[23] = M1(1,5); (*(M2[19]))[24] = M1(1,6); (*(M2[19]))[27] = M1(1,7); (*(M2[19]))[28] = M1(1,8); (*(M2[19]))[31] = M1(1,9); (*(M2[19]))[48] = M1(1,10); (*(M2[19]))[49] = M1(1,11); (*(M2[19]))[50] = M1(1,12); (*(M2[19]))[53] = M1(1,13); (*(M2[19]))[54] = M1(1,14); (*(M2[19]))[57] = M1(1,15); (*(M2[19]))[72] = M1(1,16); (*(M2[19]))[73] = M1(1,17); (*(M2[19]))[76] = M1(1,18); (*(M2[19]))[89] = M1(1,19); (*(M2[19]))[218] = M1(1,24); (*(M2[19]))[219] = M1(1,25); (*(M2[19]))[223] = M1(1,26); (*(M2[19]))[244] = M1(1,27); 
(*(M2[20]))[18] = M1(2,2); (*(M2[20]))[22] = M1(2,4); (*(M2[20]))[23] = M1(2,5); (*(M2[20]))[24] = M1(2,6); (*(M2[20]))[27] = M1(2,7); (*(M2[20]))[28] = M1(2,8); (*(M2[20]))[31] = M1(2,9); (*(M2[20]))[48] = M1(2,10); (*(M2[20]))[49] = M1(2,11); (*(M2[20]))[50] = M1(2,12); (*(M2[20]))[53] = M1(2,13); (*(M2[20]))[54] = M1(2,14); (*(M2[20]))[57] = M1(2,15); (*(M2[20]))[72] = M1(2,16); (*(M2[20]))[73] = M1(2,17); (*(M2[20]))[76] = M1(2,18); (*(M2[20]))[89] = M1(2,19); (*(M2[20]))[218] = M1(2,24); (*(M2[20]))[219] = M1(2,25); (*(M2[20]))[223] = M1(2,26); (*(M2[20]))[244] = M1(2,27); 
(*(M2[21]))[19] = M1(3,3); (*(M2[21]))[22] = M1(3,4); (*(M2[21]))[23] = M1(3,5); (*(M2[21]))[24] = M1(3,6); (*(M2[21]))[27] = M1(3,7); (*(M2[21]))[28] = M1(3,8); (*(M2[21]))[31] = M1(3,9); (*(M2[21]))[48] = M1(3,10); (*(M2[21]))[49] = M1(3,11); (*(M2[21]))[50] = M1(3,12); (*(M2[21]))[53] = M1(3,13); (*(M2[21]))[54] = M1(3,14); (*(M2[21]))[57] = M1(3,15); (*(M2[21]))[72] = M1(3,16); (*(M2[21]))[73] = M1(3,17); (*(M2[21]))[76] = M1(3,18); (*(M2[21]))[89] = M1(3,19); (*(M2[21]))[218] = M1(3,24); (*(M2[21]))[219] = M1(3,25); (*(M2[21]))[223] = M1(3,26); (*(M2[21]))[244] = M1(3,27); 
(*(M2[22]))[36] = M1(0,0); (*(M2[22]))[43] = M1(0,4); (*(M2[22]))[44] = M1(0,5); (*(M2[22]))[45] = M1(0,6); (*(M2[22]))[49] = M1(0,7); (*(M2[22]))[50] = M1(0,8); (*(M2[22]))[54] = M1(0,9); (*(M2[22]))[62] = M1(0,10); (*(M2[22]))[63] = M1(0,11); (*(M2[22]))[64] = M1(0,12); (*(M2[22]))[68] = M1(0,13); (*(M2[22]))[69] = M1(0,14); (*(M2[22]))[73] = M1(0,15); (*(M2[22]))[81] = M1(0,16); (*(M2[22]))[82] = M1(0,17); (*(M2[22]))[86] = M1(0,18); (*(M2[22]))[94] = M1(0,19); (*(M2[22]))[234] = M1(0,24); (*(M2[22]))[235] = M1(0,25); (*(M2[22]))[240] = M1(0,26); (*(M2[22]))[255] = M1(0,27); 
(*(M2[23]))[37] = M1(1,1); (*(M2[23]))[43] = M1(1,4); (*(M2[23]))[44] = M1(1,5); (*(M2[23]))[45] = M1(1,6); (*(M2[23]))[49] = M1(1,7); (*(M2[23]))[50] = M1(1,8); (*(M2[23]))[54] = M1(1,9); (*(M2[23]))[62] = M1(1,10); (*(M2[23]))[63] = M1(1,11); (*(M2[23]))[64] = M1(1,12); (*(M2[23]))[68] = M1(1,13); (*(M2[23]))[69] = M1(1,14); (*(M2[23]))[73] = M1(1,15); (*(M2[23]))[81] = M1(1,16); (*(M2[23]))[82] = M1(1,17); (*(M2[23]))[86] = M1(1,18); (*(M2[23]))[94] = M1(1,19); (*(M2[23]))[234] = M1(1,24); (*(M2[23]))[235] = M1(1,25); (*(M2[23]))[240] = M1(1,26); (*(M2[23]))[255] = M1(1,27); 
(*(M2[24]))[38] = M1(2,2); (*(M2[24]))[43] = M1(2,4); (*(M2[24]))[44] = M1(2,5); (*(M2[24]))[45] = M1(2,6); (*(M2[24]))[49] = M1(2,7); (*(M2[24]))[50] = M1(2,8); (*(M2[24]))[54] = M1(2,9); (*(M2[24]))[62] = M1(2,10); (*(M2[24]))[63] = M1(2,11); (*(M2[24]))[64] = M1(2,12); (*(M2[24]))[68] = M1(2,13); (*(M2[24]))[69] = M1(2,14); (*(M2[24]))[73] = M1(2,15); (*(M2[24]))[81] = M1(2,16); (*(M2[24]))[82] = M1(2,17); (*(M2[24]))[86] = M1(2,18); (*(M2[24]))[94] = M1(2,19); (*(M2[24]))[234] = M1(2,24); (*(M2[24]))[235] = M1(2,25); (*(M2[24]))[240] = M1(2,26); (*(M2[24]))[255] = M1(2,27); 
(*(M2[25]))[39] = M1(3,3); (*(M2[25]))[43] = M1(3,4); (*(M2[25]))[44] = M1(3,5); (*(M2[25]))[45] = M1(3,6); (*(M2[25]))[49] = M1(3,7); (*(M2[25]))[50] = M1(3,8); (*(M2[25]))[54] = M1(3,9); (*(M2[25]))[62] = M1(3,10); (*(M2[25]))[63] = M1(3,11); (*(M2[25]))[64] = M1(3,12); (*(M2[25]))[68] = M1(3,13); (*(M2[25]))[69] = M1(3,14); (*(M2[25]))[73] = M1(3,15); (*(M2[25]))[81] = M1(3,16); (*(M2[25]))[82] = M1(3,17); (*(M2[25]))[86] = M1(3,18); (*(M2[25]))[94] = M1(3,19); (*(M2[25]))[234] = M1(3,24); (*(M2[25]))[235] = M1(3,25); (*(M2[25]))[240] = M1(3,26); (*(M2[25]))[255] = M1(3,27); 
(*(M2[26]))[10] = M1(0,0); (*(M2[26]))[17] = M1(0,4); (*(M2[26]))[18] = M1(0,5); (*(M2[26]))[19] = M1(0,6); (*(M2[26]))[23] = M1(0,7); (*(M2[26]))[24] = M1(0,8); (*(M2[26]))[28] = M1(0,9); (*(M2[26]))[43] = M1(0,10); (*(M2[26]))[44] = M1(0,11); (*(M2[26]))[45] = M1(0,12); (*(M2[26]))[49] = M1(0,13); (*(M2[26]))[50] = M1(0,14); (*(M2[26]))[54] = M1(0,15); (*(M2[26]))[68] = M1(0,16); (*(M2[26]))[69] = M1(0,17); (*(M2[26]))[73] = M1(0,18); (*(M2[26]))[86] = M1(0,19); (*(M2[26]))[213] = M1(0,24); (*(M2[26]))[214] = M1(0,25); (*(M2[26]))[219] = M1(0,26); (*(M2[26]))[240] = M1(0,27); 
(*(M2[27]))[11] = M1(1,1); (*(M2[27]))[17] = M1(1,4); (*(M2[27]))[18] = M1(1,5); (*(M2[27]))[19] = M1(1,6); (*(M2[27]))[23] = M1(1,7); (*(M2[27]))[24] = M1(1,8); (*(M2[27]))[28] = M1(1,9); (*(M2[27]))[43] = M1(1,10); (*(M2[27]))[44] = M1(1,11); (*(M2[27]))[45] = M1(1,12); (*(M2[27]))[49] = M1(1,13); (*(M2[27]))[50] = M1(1,14); (*(M2[27]))[54] = M1(1,15); (*(M2[27]))[68] = M1(1,16); (*(M2[27]))[69] = M1(1,17); (*(M2[27]))[73] = M1(1,18); (*(M2[27]))[86] = M1(1,19); (*(M2[27]))[213] = M1(1,24); (*(M2[27]))[214] = M1(1,25); (*(M2[27]))[219] = M1(1,26); (*(M2[27]))[240] = M1(1,27); 
(*(M2[28]))[12] = M1(2,2); (*(M2[28]))[17] = M1(2,4); (*(M2[28]))[18] = M1(2,5); (*(M2[28]))[19] = M1(2,6); (*(M2[28]))[23] = M1(2,7); (*(M2[28]))[24] = M1(2,8); (*(M2[28]))[28] = M1(2,9); (*(M2[28]))[43] = M1(2,10); (*(M2[28]))[44] = M1(2,11); (*(M2[28]))[45] = M1(2,12); (*(M2[28]))[49] = M1(2,13); (*(M2[28]))[50] = M1(2,14); (*(M2[28]))[54] = M1(2,15); (*(M2[28]))[68] = M1(2,16); (*(M2[28]))[69] = M1(2,17); (*(M2[28]))[73] = M1(2,18); (*(M2[28]))[86] = M1(2,19); (*(M2[28]))[213] = M1(2,24); (*(M2[28]))[214] = M1(2,25); (*(M2[28]))[219] = M1(2,26); (*(M2[28]))[240] = M1(2,27); 
(*(M2[29]))[13] = M1(3,3); (*(M2[29]))[17] = M1(3,4); (*(M2[29]))[18] = M1(3,5); (*(M2[29]))[19] = M1(3,6); (*(M2[29]))[23] = M1(3,7); (*(M2[29]))[24] = M1(3,8); (*(M2[29]))[28] = M1(3,9); (*(M2[29]))[43] = M1(3,10); (*(M2[29]))[44] = M1(3,11); (*(M2[29]))[45] = M1(3,12); (*(M2[29]))[49] = M1(3,13); (*(M2[29]))[50] = M1(3,14); (*(M2[29]))[54] = M1(3,15); (*(M2[29]))[68] = M1(3,16); (*(M2[29]))[69] = M1(3,17); (*(M2[29]))[73] = M1(3,18); (*(M2[29]))[86] = M1(3,19); (*(M2[29]))[213] = M1(3,24); (*(M2[29]))[214] = M1(3,25); (*(M2[29]))[219] = M1(3,26); (*(M2[29]))[240] = M1(3,27); 
(*(M2[30]))[4] = M1(0,0); (*(M2[30]))[11] = M1(0,4); (*(M2[30]))[12] = M1(0,5); (*(M2[30]))[13] = M1(0,6); (*(M2[30]))[18] = M1(0,7); (*(M2[30]))[19] = M1(0,8); (*(M2[30]))[24] = M1(0,9); (*(M2[30]))[37] = M1(0,10); (*(M2[30]))[38] = M1(0,11); (*(M2[30]))[39] = M1(0,12); (*(M2[30]))[44] = M1(0,13); (*(M2[30]))[45] = M1(0,14); (*(M2[30]))[50] = M1(0,15); (*(M2[30]))[63] = M1(0,16); (*(M2[30]))[64] = M1(0,17); (*(M2[30]))[69] = M1(0,18); (*(M2[30]))[82] = M1(0,19); (*(M2[30]))[207] = M1(0,24); (*(M2[30]))[208] = M1(0,25); (*(M2[30]))[214] = M1(0,26); (*(M2[30]))[235] = M1(0,27); 
(*(M2[31]))[5] = M1(1,1); (*(M2[31]))[11] = M1(1,4); (*(M2[31]))[12] = M1(1,5); (*(M2[31]))[13] = M1(1,6); (*(M2[31]))[18] = M1(1,7); (*(M2[31]))[19] = M1(1,8); (*(M2[31]))[24] = M1(1,9); (*(M2[31]))[37] = M1(1,10); (*(M2[31]))[38] = M1(1,11); (*(M2[31]))[39] = M1(1,12); (*(M2[31]))[44] = M1(1,13); (*(M2[31]))[45] = M1(1,14); (*(M2[31]))[50] = M1(1,15); (*(M2[31]))[63] = M1(1,16); (*(M2[31]))[64] = M1(1,17); (*(M2[31]))[69] = M1(1,18); (*(M2[31]))[82] = M1(1,19); (*(M2[31]))[207] = M1(1,24); (*(M2[31]))[208] = M1(1,25); (*(M2[31]))[214] = M1(1,26); (*(M2[31]))[235] = M1(1,27); 
(*(M2[32]))[6] = M1(2,2); (*(M2[32]))[11] = M1(2,4); (*(M2[32]))[12] = M1(2,5); (*(M2[32]))[13] = M1(2,6); (*(M2[32]))[18] = M1(2,7); (*(M2[32]))[19] = M1(2,8); (*(M2[32]))[24] = M1(2,9); (*(M2[32]))[37] = M1(2,10); (*(M2[32]))[38] = M1(2,11); (*(M2[32]))[39] = M1(2,12); (*(M2[32]))[44] = M1(2,13); (*(M2[32]))[45] = M1(2,14); (*(M2[32]))[50] = M1(2,15); (*(M2[32]))[63] = M1(2,16); (*(M2[32]))[64] = M1(2,17); (*(M2[32]))[69] = M1(2,18); (*(M2[32]))[82] = M1(2,19); (*(M2[32]))[207] = M1(2,24); (*(M2[32]))[208] = M1(2,25); (*(M2[32]))[214] = M1(2,26); (*(M2[32]))[235] = M1(2,27); 
(*(M2[33]))[47] = M1(1,1); (*(M2[33]))[51] = M1(1,4); (*(M2[33]))[52] = M1(1,5); (*(M2[33]))[53] = M1(1,6); (*(M2[33]))[55] = M1(1,7); (*(M2[33]))[56] = M1(1,8); (*(M2[33]))[58] = M1(1,9); (*(M2[33]))[70] = M1(1,10); (*(M2[33]))[71] = M1(1,11); (*(M2[33]))[72] = M1(1,12); (*(M2[33]))[74] = M1(1,13); (*(M2[33]))[75] = M1(1,14); (*(M2[33]))[77] = M1(1,15); (*(M2[33]))[87] = M1(1,16); (*(M2[33]))[88] = M1(1,17); (*(M2[33]))[90] = M1(1,18); (*(M2[33]))[98] = M1(1,19); (*(M2[33]))[242] = M1(1,24); (*(M2[33]))[243] = M1(1,25); (*(M2[33]))[246] = M1(1,26); (*(M2[33]))[261] = M1(1,27); 
(*(M2[34]))[48] = M1(2,2); (*(M2[34]))[51] = M1(2,4); (*(M2[34]))[52] = M1(2,5); (*(M2[34]))[53] = M1(2,6); (*(M2[34]))[55] = M1(2,7); (*(M2[34]))[56] = M1(2,8); (*(M2[34]))[58] = M1(2,9); (*(M2[34]))[70] = M1(2,10); (*(M2[34]))[71] = M1(2,11); (*(M2[34]))[72] = M1(2,12); (*(M2[34]))[74] = M1(2,13); (*(M2[34]))[75] = M1(2,14); (*(M2[34]))[77] = M1(2,15); (*(M2[34]))[87] = M1(2,16); (*(M2[34]))[88] = M1(2,17); (*(M2[34]))[90] = M1(2,18); (*(M2[34]))[98] = M1(2,19); (*(M2[34]))[242] = M1(2,24); (*(M2[34]))[243] = M1(2,25); (*(M2[34]))[246] = M1(2,26); (*(M2[34]))[261] = M1(2,27); 
(*(M2[35]))[49] = M1(3,3); (*(M2[35]))[51] = M1(3,4); (*(M2[35]))[52] = M1(3,5); (*(M2[35]))[53] = M1(3,6); (*(M2[35]))[55] = M1(3,7); (*(M2[35]))[56] = M1(3,8); (*(M2[35]))[58] = M1(3,9); (*(M2[35]))[70] = M1(3,10); (*(M2[35]))[71] = M1(3,11); (*(M2[35]))[72] = M1(3,12); (*(M2[35]))[74] = M1(3,13); (*(M2[35]))[75] = M1(3,14); (*(M2[35]))[77] = M1(3,15); (*(M2[35]))[87] = M1(3,16); (*(M2[35]))[88] = M1(3,17); (*(M2[35]))[90] = M1(3,18); (*(M2[35]))[98] = M1(3,19); (*(M2[35]))[242] = M1(3,24); (*(M2[35]))[243] = M1(3,25); (*(M2[35]))[246] = M1(3,26); (*(M2[35]))[261] = M1(3,27); 
(*(M2[36]))[20] = M1(0,0); (*(M2[36]))[25] = M1(0,4); (*(M2[36]))[26] = M1(0,5); (*(M2[36]))[27] = M1(0,6); (*(M2[36]))[29] = M1(0,7); (*(M2[36]))[30] = M1(0,8); (*(M2[36]))[32] = M1(0,9); (*(M2[36]))[51] = M1(0,10); (*(M2[36]))[52] = M1(0,11); (*(M2[36]))[53] = M1(0,12); (*(M2[36]))[55] = M1(0,13); (*(M2[36]))[56] = M1(0,14); (*(M2[36]))[58] = M1(0,15); (*(M2[36]))[74] = M1(0,16); (*(M2[36]))[75] = M1(0,17); (*(M2[36]))[77] = M1(0,18); (*(M2[36]))[90] = M1(0,19); (*(M2[36]))[221] = M1(0,24); (*(M2[36]))[222] = M1(0,25); (*(M2[36]))[225] = M1(0,26); (*(M2[36]))[246] = M1(0,27); 
(*(M2[37]))[21] = M1(1,1); (*(M2[37]))[25] = M1(1,4); (*(M2[37]))[26] = M1(1,5); (*(M2[37]))[27] = M1(1,6); (*(M2[37]))[29] = M1(1,7); (*(M2[37]))[30] = M1(1,8); (*(M2[37]))[32] = M1(1,9); (*(M2[37]))[51] = M1(1,10); (*(M2[37]))[52] = M1(1,11); (*(M2[37]))[53] = M1(1,12); (*(M2[37]))[55] = M1(1,13); (*(M2[37]))[56] = M1(1,14); (*(M2[37]))[58] = M1(1,15); (*(M2[37]))[74] = M1(1,16); (*(M2[37]))[75] = M1(1,17); (*(M2[37]))[77] = M1(1,18); (*(M2[37]))[90] = M1(1,19); (*(M2[37]))[221] = M1(1,24); (*(M2[37]))[222] = M1(1,25); (*(M2[37]))[225] = M1(1,26); (*(M2[37]))[246] = M1(1,27); 
(*(M2[38]))[22] = M1(2,2); (*(M2[38]))[25] = M1(2,4); (*(M2[38]))[26] = M1(2,5); (*(M2[38]))[27] = M1(2,6); (*(M2[38]))[29] = M1(2,7); (*(M2[38]))[30] = M1(2,8); (*(M2[38]))[32] = M1(2,9); (*(M2[38]))[51] = M1(2,10); (*(M2[38]))[52] = M1(2,11); (*(M2[38]))[53] = M1(2,12); (*(M2[38]))[55] = M1(2,13); (*(M2[38]))[56] = M1(2,14); (*(M2[38]))[58] = M1(2,15); (*(M2[38]))[74] = M1(2,16); (*(M2[38]))[75] = M1(2,17); (*(M2[38]))[77] = M1(2,18); (*(M2[38]))[90] = M1(2,19); (*(M2[38]))[221] = M1(2,24); (*(M2[38]))[222] = M1(2,25); (*(M2[38]))[225] = M1(2,26); (*(M2[38]))[246] = M1(2,27); 
(*(M2[39]))[23] = M1(3,3); (*(M2[39]))[25] = M1(3,4); (*(M2[39]))[26] = M1(3,5); (*(M2[39]))[27] = M1(3,6); (*(M2[39]))[29] = M1(3,7); (*(M2[39]))[30] = M1(3,8); (*(M2[39]))[32] = M1(3,9); (*(M2[39]))[51] = M1(3,10); (*(M2[39]))[52] = M1(3,11); (*(M2[39]))[53] = M1(3,12); (*(M2[39]))[55] = M1(3,13); (*(M2[39]))[56] = M1(3,14); (*(M2[39]))[58] = M1(3,15); (*(M2[39]))[74] = M1(3,16); (*(M2[39]))[75] = M1(3,17); (*(M2[39]))[77] = M1(3,18); (*(M2[39]))[90] = M1(3,19); (*(M2[39]))[221] = M1(3,24); (*(M2[39]))[222] = M1(3,25); (*(M2[39]))[225] = M1(3,26); (*(M2[39]))[246] = M1(3,27); 
(*(M2[40]))[60] = M1(0,0); (*(M2[40]))[66] = M1(0,4); (*(M2[40]))[67] = M1(0,5); (*(M2[40]))[68] = M1(0,6); (*(M2[40]))[71] = M1(0,7); (*(M2[40]))[72] = M1(0,8); (*(M2[40]))[75] = M1(0,9); (*(M2[40]))[79] = M1(0,10); (*(M2[40]))[80] = M1(0,11); (*(M2[40]))[81] = M1(0,12); (*(M2[40]))[84] = M1(0,13); (*(M2[40]))[85] = M1(0,14); (*(M2[40]))[88] = M1(0,15); (*(M2[40]))[92] = M1(0,16); (*(M2[40]))[93] = M1(0,17); (*(M2[40]))[96] = M1(0,18); (*(M2[40]))[100] = M1(0,19); (*(M2[40]))[253] = M1(0,24); (*(M2[40]))[254] = M1(0,25); (*(M2[40]))[258] = M1(0,26); (*(M2[40]))[268] = M1(0,27); 
(*(M2[41]))[61] = M1(1,1); (*(M2[41]))[66] = M1(1,4); (*(M2[41]))[67] = M1(1,5); (*(M2[41]))[68] = M1(1,6); (*(M2[41]))[71] = M1(1,7); (*(M2[41]))[72] = M1(1,8); (*(M2[41]))[75] = M1(1,9); (*(M2[41]))[79] = M1(1,10); (*(M2[41]))[80] = M1(1,11); (*(M2[41]))[81] = M1(1,12); (*(M2[41]))[84] = M1(1,13); (*(M2[41]))[85] = M1(1,14); (*(M2[41]))[88] = M1(1,15); (*(M2[41]))[92] = M1(1,16); (*(M2[41]))[93] = M1(1,17); (*(M2[41]))[96] = M1(1,18); (*(M2[41]))[100] = M1(1,19); (*(M2[41]))[253] = M1(1,24); (*(M2[41]))[254] = M1(1,25); (*(M2[41]))[258] = M1(1,26); (*(M2[41]))[268] = M1(1,27); 
(*(M2[42]))[62] = M1(2,2); (*(M2[42]))[66] = M1(2,4); (*(M2[42]))[67] = M1(2,5); (*(M2[42]))[68] = M1(2,6); (*(M2[42]))[71] = M1(2,7); (*(M2[42]))[72] = M1(2,8); (*(M2[42]))[75] = M1(2,9); (*(M2[42]))[79] = M1(2,10); (*(M2[42]))[80] = M1(2,11); (*(M2[42]))[81] = M1(2,12); (*(M2[42]))[84] = M1(2,13); (*(M2[42]))[85] = M1(2,14); (*(M2[42]))[88] = M1(2,15); (*(M2[42]))[92] = M1(2,16); (*(M2[42]))[93] = M1(2,17); (*(M2[42]))[96] = M1(2,18); (*(M2[42]))[100] = M1(2,19); (*(M2[42]))[253] = M1(2,24); (*(M2[42]))[254] = M1(2,25); (*(M2[42]))[258] = M1(2,26); (*(M2[42]))[268] = M1(2,27); 
(*(M2[43]))[63] = M1(3,3); (*(M2[43]))[66] = M1(3,4); (*(M2[43]))[67] = M1(3,5); (*(M2[43]))[68] = M1(3,6); (*(M2[43]))[71] = M1(3,7); (*(M2[43]))[72] = M1(3,8); (*(M2[43]))[75] = M1(3,9); (*(M2[43]))[79] = M1(3,10); (*(M2[43]))[80] = M1(3,11); (*(M2[43]))[81] = M1(3,12); (*(M2[43]))[84] = M1(3,13); (*(M2[43]))[85] = M1(3,14); (*(M2[43]))[88] = M1(3,15); (*(M2[43]))[92] = M1(3,16); (*(M2[43]))[93] = M1(3,17); (*(M2[43]))[96] = M1(3,18); (*(M2[43]))[100] = M1(3,19); (*(M2[43]))[253] = M1(3,24); (*(M2[43]))[254] = M1(3,25); (*(M2[43]))[258] = M1(3,26); (*(M2[43]))[268] = M1(3,27); 
(*(M2[44]))[161] = M1(4,20); (*(M2[44]))[163] = M1(4,21); (*(M2[44]))[172] = M1(4,22); (*(M2[44]))[193] = M1(4,23); (*(M2[44]))[322] = M1(4,28); 
(*(M2[45]))[41] = M1(0,0); (*(M2[45]))[47] = M1(0,4); (*(M2[45]))[48] = M1(0,5); (*(M2[45]))[49] = M1(0,6); (*(M2[45]))[52] = M1(0,7); (*(M2[45]))[53] = M1(0,8); (*(M2[45]))[56] = M1(0,9); (*(M2[45]))[66] = M1(0,10); (*(M2[45]))[67] = M1(0,11); (*(M2[45]))[68] = M1(0,12); (*(M2[45]))[71] = M1(0,13); (*(M2[45]))[72] = M1(0,14); (*(M2[45]))[75] = M1(0,15); (*(M2[45]))[84] = M1(0,16); (*(M2[45]))[85] = M1(0,17); (*(M2[45]))[88] = M1(0,18); (*(M2[45]))[96] = M1(0,19); (*(M2[45]))[238] = M1(0,24); (*(M2[45]))[239] = M1(0,25); (*(M2[45]))[243] = M1(0,26); (*(M2[45]))[258] = M1(0,27); 
(*(M2[46]))[42] = M1(1,1); (*(M2[46]))[47] = M1(1,4); (*(M2[46]))[48] = M1(1,5); (*(M2[46]))[49] = M1(1,6); (*(M2[46]))[52] = M1(1,7); (*(M2[46]))[53] = M1(1,8); (*(M2[46]))[56] = M1(1,9); (*(M2[46]))[66] = M1(1,10); (*(M2[46]))[67] = M1(1,11); (*(M2[46]))[68] = M1(1,12); (*(M2[46]))[71] = M1(1,13); (*(M2[46]))[72] = M1(1,14); (*(M2[46]))[75] = M1(1,15); (*(M2[46]))[84] = M1(1,16); (*(M2[46]))[85] = M1(1,17); (*(M2[46]))[88] = M1(1,18); (*(M2[46]))[96] = M1(1,19); (*(M2[46]))[238] = M1(1,24); (*(M2[46]))[239] = M1(1,25); (*(M2[46]))[243] = M1(1,26); (*(M2[46]))[258] = M1(1,27); 
(*(M2[47]))[43] = M1(2,2); (*(M2[47]))[47] = M1(2,4); (*(M2[47]))[48] = M1(2,5); (*(M2[47]))[49] = M1(2,6); (*(M2[47]))[52] = M1(2,7); (*(M2[47]))[53] = M1(2,8); (*(M2[47]))[56] = M1(2,9); (*(M2[47]))[66] = M1(2,10); (*(M2[47]))[67] = M1(2,11); (*(M2[47]))[68] = M1(2,12); (*(M2[47]))[71] = M1(2,13); (*(M2[47]))[72] = M1(2,14); (*(M2[47]))[75] = M1(2,15); (*(M2[47]))[84] = M1(2,16); (*(M2[47]))[85] = M1(2,17); (*(M2[47]))[88] = M1(2,18); (*(M2[47]))[96] = M1(2,19); (*(M2[47]))[238] = M1(2,24); (*(M2[47]))[239] = M1(2,25); (*(M2[47]))[243] = M1(2,26); (*(M2[47]))[258] = M1(2,27); 
(*(M2[48]))[44] = M1(3,3); (*(M2[48]))[47] = M1(3,4); (*(M2[48]))[48] = M1(3,5); (*(M2[48]))[49] = M1(3,6); (*(M2[48]))[52] = M1(3,7); (*(M2[48]))[53] = M1(3,8); (*(M2[48]))[56] = M1(3,9); (*(M2[48]))[66] = M1(3,10); (*(M2[48]))[67] = M1(3,11); (*(M2[48]))[68] = M1(3,12); (*(M2[48]))[71] = M1(3,13); (*(M2[48]))[72] = M1(3,14); (*(M2[48]))[75] = M1(3,15); (*(M2[48]))[84] = M1(3,16); (*(M2[48]))[85] = M1(3,17); (*(M2[48]))[88] = M1(3,18); (*(M2[48]))[96] = M1(3,19); (*(M2[48]))[238] = M1(3,24); (*(M2[48]))[239] = M1(3,25); (*(M2[48]))[243] = M1(3,26); (*(M2[48]))[258] = M1(3,27); 
(*(M2[49]))[142] = M1(4,20); (*(M2[49]))[144] = M1(4,21); (*(M2[49]))[153] = M1(4,22); (*(M2[49]))[185] = M1(4,23); (*(M2[49]))[312] = M1(4,28); 
(*(M2[50]))[15] = M1(0,0); (*(M2[50]))[21] = M1(0,4); (*(M2[50]))[22] = M1(0,5); (*(M2[50]))[23] = M1(0,6); (*(M2[50]))[26] = M1(0,7); (*(M2[50]))[27] = M1(0,8); (*(M2[50]))[30] = M1(0,9); (*(M2[50]))[47] = M1(0,10); (*(M2[50]))[48] = M1(0,11); (*(M2[50]))[49] = M1(0,12); (*(M2[50]))[52] = M1(0,13); (*(M2[50]))[53] = M1(0,14); (*(M2[50]))[56] = M1(0,15); (*(M2[50]))[71] = M1(0,16); (*(M2[50]))[72] = M1(0,17); (*(M2[50]))[75] = M1(0,18); (*(M2[50]))[88] = M1(0,19); (*(M2[50]))[217] = M1(0,24); (*(M2[50]))[218] = M1(0,25); (*(M2[50]))[222] = M1(0,26); (*(M2[50]))[243] = M1(0,27); 
(*(M2[51]))[16] = M1(1,1); (*(M2[51]))[21] = M1(1,4); (*(M2[51]))[22] = M1(1,5); (*(M2[51]))[23] = M1(1,6); (*(M2[51]))[26] = M1(1,7); (*(M2[51]))[27] = M1(1,8); (*(M2[51]))[30] = M1(1,9); (*(M2[51]))[47] = M1(1,10); (*(M2[51]))[48] = M1(1,11); (*(M2[51]))[49] = M1(1,12); (*(M2[51]))[52] = M1(1,13); (*(M2[51]))[53] = M1(1,14); (*(M2[51]))[56] = M1(1,15); (*(M2[51]))[71] = M1(1,16); (*(M2[51]))[72] = M1(1,17); (*(M2[51]))[75] = M1(1,18); (*(M2[51]))[88] = M1(1,19); (*(M2[51]))[217] = M1(1,24); (*(M2[51]))[218] = M1(1,25); (*(M2[51]))[222] = M1(1,26); (*(M2[51]))[243] = M1(1,27); 
(*(M2[52]))[17] = M1(2,2); (*(M2[52]))[21] = M1(2,4); (*(M2[52]))[22] = M1(2,5); (*(M2[52]))[23] = M1(2,6); (*(M2[52]))[26] = M1(2,7); (*(M2[52]))[27] = M1(2,8); (*(M2[52]))[30] = M1(2,9); (*(M2[52]))[47] = M1(2,10); (*(M2[52]))[48] = M1(2,11); (*(M2[52]))[49] = M1(2,12); (*(M2[52]))[52] = M1(2,13); (*(M2[52]))[53] = M1(2,14); (*(M2[52]))[56] = M1(2,15); (*(M2[52]))[71] = M1(2,16); (*(M2[52]))[72] = M1(2,17); (*(M2[52]))[75] = M1(2,18); (*(M2[52]))[88] = M1(2,19); (*(M2[52]))[217] = M1(2,24); (*(M2[52]))[218] = M1(2,25); (*(M2[52]))[222] = M1(2,26); (*(M2[52]))[243] = M1(2,27); 
(*(M2[53]))[18] = M1(3,3); (*(M2[53]))[21] = M1(3,4); (*(M2[53]))[22] = M1(3,5); (*(M2[53]))[23] = M1(3,6); (*(M2[53]))[26] = M1(3,7); (*(M2[53]))[27] = M1(3,8); (*(M2[53]))[30] = M1(3,9); (*(M2[53]))[47] = M1(3,10); (*(M2[53]))[48] = M1(3,11); (*(M2[53]))[49] = M1(3,12); (*(M2[53]))[52] = M1(3,13); (*(M2[53]))[53] = M1(3,14); (*(M2[53]))[56] = M1(3,15); (*(M2[53]))[71] = M1(3,16); (*(M2[53]))[72] = M1(3,17); (*(M2[53]))[75] = M1(3,18); (*(M2[53]))[88] = M1(3,19); (*(M2[53]))[217] = M1(3,24); (*(M2[53]))[218] = M1(3,25); (*(M2[53]))[222] = M1(3,26); (*(M2[53]))[243] = M1(3,27); 
(*(M2[54]))[116] = M1(4,20); (*(M2[54]))[118] = M1(4,21); (*(M2[54]))[127] = M1(4,22); (*(M2[54]))[172] = M1(4,23); (*(M2[54]))[297] = M1(4,28); 
(*(M2[55]))[35] = M1(0,0); (*(M2[55]))[42] = M1(0,4); (*(M2[55]))[43] = M1(0,5); (*(M2[55]))[44] = M1(0,6); (*(M2[55]))[48] = M1(0,7); (*(M2[55]))[49] = M1(0,8); (*(M2[55]))[53] = M1(0,9); (*(M2[55]))[61] = M1(0,10); (*(M2[55]))[62] = M1(0,11); (*(M2[55]))[63] = M1(0,12); (*(M2[55]))[67] = M1(0,13); (*(M2[55]))[68] = M1(0,14); (*(M2[55]))[72] = M1(0,15); (*(M2[55]))[80] = M1(0,16); (*(M2[55]))[81] = M1(0,17); (*(M2[55]))[85] = M1(0,18); (*(M2[55]))[93] = M1(0,19); (*(M2[55]))[233] = M1(0,24); (*(M2[55]))[234] = M1(0,25); (*(M2[55]))[239] = M1(0,26); (*(M2[55]))[254] = M1(0,27); 
(*(M2[56]))[36] = M1(1,1); (*(M2[56]))[42] = M1(1,4); (*(M2[56]))[43] = M1(1,5); (*(M2[56]))[44] = M1(1,6); (*(M2[56]))[48] = M1(1,7); (*(M2[56]))[49] = M1(1,8); (*(M2[56]))[53] = M1(1,9); (*(M2[56]))[61] = M1(1,10); (*(M2[56]))[62] = M1(1,11); (*(M2[56]))[63] = M1(1,12); (*(M2[56]))[67] = M1(1,13); (*(M2[56]))[68] = M1(1,14); (*(M2[56]))[72] = M1(1,15); (*(M2[56]))[80] = M1(1,16); (*(M2[56]))[81] = M1(1,17); (*(M2[56]))[85] = M1(1,18); (*(M2[56]))[93] = M1(1,19); (*(M2[56]))[233] = M1(1,24); (*(M2[56]))[234] = M1(1,25); (*(M2[56]))[239] = M1(1,26); (*(M2[56]))[254] = M1(1,27); 
(*(M2[57]))[37] = M1(2,2); (*(M2[57]))[42] = M1(2,4); (*(M2[57]))[43] = M1(2,5); (*(M2[57]))[44] = M1(2,6); (*(M2[57]))[48] = M1(2,7); (*(M2[57]))[49] = M1(2,8); (*(M2[57]))[53] = M1(2,9); (*(M2[57]))[61] = M1(2,10); (*(M2[57]))[62] = M1(2,11); (*(M2[57]))[63] = M1(2,12); (*(M2[57]))[67] = M1(2,13); (*(M2[57]))[68] = M1(2,14); (*(M2[57]))[72] = M1(2,15); (*(M2[57]))[80] = M1(2,16); (*(M2[57]))[81] = M1(2,17); (*(M2[57]))[85] = M1(2,18); (*(M2[57]))[93] = M1(2,19); (*(M2[57]))[233] = M1(2,24); (*(M2[57]))[234] = M1(2,25); (*(M2[57]))[239] = M1(2,26); (*(M2[57]))[254] = M1(2,27); 
(*(M2[58]))[38] = M1(3,3); (*(M2[58]))[42] = M1(3,4); (*(M2[58]))[43] = M1(3,5); (*(M2[58]))[44] = M1(3,6); (*(M2[58]))[48] = M1(3,7); (*(M2[58]))[49] = M1(3,8); (*(M2[58]))[53] = M1(3,9); (*(M2[58]))[61] = M1(3,10); (*(M2[58]))[62] = M1(3,11); (*(M2[58]))[63] = M1(3,12); (*(M2[58]))[67] = M1(3,13); (*(M2[58]))[68] = M1(3,14); (*(M2[58]))[72] = M1(3,15); (*(M2[58]))[80] = M1(3,16); (*(M2[58]))[81] = M1(3,17); (*(M2[58]))[85] = M1(3,18); (*(M2[58]))[93] = M1(3,19); (*(M2[58]))[233] = M1(3,24); (*(M2[58]))[234] = M1(3,25); (*(M2[58]))[239] = M1(3,26); (*(M2[58]))[254] = M1(3,27); 
(*(M2[59]))[136] = M1(4,20); (*(M2[59]))[138] = M1(4,21); (*(M2[59]))[149] = M1(4,22); (*(M2[59]))[181] = M1(4,23); (*(M2[59]))[308] = M1(4,28); 
(*(M2[60]))[9] = M1(0,0); (*(M2[60]))[16] = M1(0,4); (*(M2[60]))[17] = M1(0,5); (*(M2[60]))[18] = M1(0,6); (*(M2[60]))[22] = M1(0,7); (*(M2[60]))[23] = M1(0,8); (*(M2[60]))[27] = M1(0,9); (*(M2[60]))[42] = M1(0,10); (*(M2[60]))[43] = M1(0,11); (*(M2[60]))[44] = M1(0,12); (*(M2[60]))[48] = M1(0,13); (*(M2[60]))[49] = M1(0,14); (*(M2[60]))[53] = M1(0,15); (*(M2[60]))[67] = M1(0,16); (*(M2[60]))[68] = M1(0,17); (*(M2[60]))[72] = M1(0,18); (*(M2[60]))[85] = M1(0,19); (*(M2[60]))[212] = M1(0,24); (*(M2[60]))[213] = M1(0,25); (*(M2[60]))[218] = M1(0,26); (*(M2[60]))[239] = M1(0,27); 
(*(M2[61]))[10] = M1(1,1); (*(M2[61]))[16] = M1(1,4); (*(M2[61]))[17] = M1(1,5); (*(M2[61]))[18] = M1(1,6); (*(M2[61]))[22] = M1(1,7); (*(M2[61]))[23] = M1(1,8); (*(M2[61]))[27] = M1(1,9); (*(M2[61]))[42] = M1(1,10); (*(M2[61]))[43] = M1(1,11); (*(M2[61]))[44] = M1(1,12); (*(M2[61]))[48] = M1(1,13); (*(M2[61]))[49] = M1(1,14); (*(M2[61]))[53] = M1(1,15); (*(M2[61]))[67] = M1(1,16); (*(M2[61]))[68] = M1(1,17); (*(M2[61]))[72] = M1(1,18); (*(M2[61]))[85] = M1(1,19); (*(M2[61]))[212] = M1(1,24); (*(M2[61]))[213] = M1(1,25); (*(M2[61]))[218] = M1(1,26); (*(M2[61]))[239] = M1(1,27); 
(*(M2[62]))[11] = M1(2,2); (*(M2[62]))[16] = M1(2,4); (*(M2[62]))[17] = M1(2,5); (*(M2[62]))[18] = M1(2,6); (*(M2[62]))[22] = M1(2,7); (*(M2[62]))[23] = M1(2,8); (*(M2[62]))[27] = M1(2,9); (*(M2[62]))[42] = M1(2,10); (*(M2[62]))[43] = M1(2,11); (*(M2[62]))[44] = M1(2,12); (*(M2[62]))[48] = M1(2,13); (*(M2[62]))[49] = M1(2,14); (*(M2[62]))[53] = M1(2,15); (*(M2[62]))[67] = M1(2,16); (*(M2[62]))[68] = M1(2,17); (*(M2[62]))[72] = M1(2,18); (*(M2[62]))[85] = M1(2,19); (*(M2[62]))[212] = M1(2,24); (*(M2[62]))[213] = M1(2,25); (*(M2[62]))[218] = M1(2,26); (*(M2[62]))[239] = M1(2,27); 
(*(M2[63]))[12] = M1(3,3); (*(M2[63]))[16] = M1(3,4); (*(M2[63]))[17] = M1(3,5); (*(M2[63]))[18] = M1(3,6); (*(M2[63]))[22] = M1(3,7); (*(M2[63]))[23] = M1(3,8); (*(M2[63]))[27] = M1(3,9); (*(M2[63]))[42] = M1(3,10); (*(M2[63]))[43] = M1(3,11); (*(M2[63]))[44] = M1(3,12); (*(M2[63]))[48] = M1(3,13); (*(M2[63]))[49] = M1(3,14); (*(M2[63]))[53] = M1(3,15); (*(M2[63]))[67] = M1(3,16); (*(M2[63]))[68] = M1(3,17); (*(M2[63]))[72] = M1(3,18); (*(M2[63]))[85] = M1(3,19); (*(M2[63]))[212] = M1(3,24); (*(M2[63]))[213] = M1(3,25); (*(M2[63]))[218] = M1(3,26); (*(M2[63]))[239] = M1(3,27); 
(*(M2[64]))[110] = M1(4,20); (*(M2[64]))[112] = M1(4,21); (*(M2[64]))[123] = M1(4,22); (*(M2[64]))[168] = M1(4,23); (*(M2[64]))[293] = M1(4,28); 
(*(M2[65]))[3] = M1(0,0); (*(M2[65]))[10] = M1(0,4); (*(M2[65]))[11] = M1(0,5); (*(M2[65]))[12] = M1(0,6); (*(M2[65]))[17] = M1(0,7); (*(M2[65]))[18] = M1(0,8); (*(M2[65]))[23] = M1(0,9); (*(M2[65]))[36] = M1(0,10); (*(M2[65]))[37] = M1(0,11); (*(M2[65]))[38] = M1(0,12); (*(M2[65]))[43] = M1(0,13); (*(M2[65]))[44] = M1(0,14); (*(M2[65]))[49] = M1(0,15); (*(M2[65]))[62] = M1(0,16); (*(M2[65]))[63] = M1(0,17); (*(M2[65]))[68] = M1(0,18); (*(M2[65]))[81] = M1(0,19); (*(M2[65]))[206] = M1(0,24); (*(M2[65]))[207] = M1(0,25); (*(M2[65]))[213] = M1(0,26); (*(M2[65]))[234] = M1(0,27); 
(*(M2[66]))[4] = M1(1,1); (*(M2[66]))[10] = M1(1,4); (*(M2[66]))[11] = M1(1,5); (*(M2[66]))[12] = M1(1,6); (*(M2[66]))[17] = M1(1,7); (*(M2[66]))[18] = M1(1,8); (*(M2[66]))[23] = M1(1,9); (*(M2[66]))[36] = M1(1,10); (*(M2[66]))[37] = M1(1,11); (*(M2[66]))[38] = M1(1,12); (*(M2[66]))[43] = M1(1,13); (*(M2[66]))[44] = M1(1,14); (*(M2[66]))[49] = M1(1,15); (*(M2[66]))[62] = M1(1,16); (*(M2[66]))[63] = M1(1,17); (*(M2[66]))[68] = M1(1,18); (*(M2[66]))[81] = M1(1,19); (*(M2[66]))[206] = M1(1,24); (*(M2[66]))[207] = M1(1,25); (*(M2[66]))[213] = M1(1,26); (*(M2[66]))[234] = M1(1,27); 
(*(M2[67]))[5] = M1(2,2); (*(M2[67]))[10] = M1(2,4); (*(M2[67]))[11] = M1(2,5); (*(M2[67]))[12] = M1(2,6); (*(M2[67]))[17] = M1(2,7); (*(M2[67]))[18] = M1(2,8); (*(M2[67]))[23] = M1(2,9); (*(M2[67]))[36] = M1(2,10); (*(M2[67]))[37] = M1(2,11); (*(M2[67]))[38] = M1(2,12); (*(M2[67]))[43] = M1(2,13); (*(M2[67]))[44] = M1(2,14); (*(M2[67]))[49] = M1(2,15); (*(M2[67]))[62] = M1(2,16); (*(M2[67]))[63] = M1(2,17); (*(M2[67]))[68] = M1(2,18); (*(M2[67]))[81] = M1(2,19); (*(M2[67]))[206] = M1(2,24); (*(M2[67]))[207] = M1(2,25); (*(M2[67]))[213] = M1(2,26); (*(M2[67]))[234] = M1(2,27); 
(*(M2[68]))[6] = M1(3,3); (*(M2[68]))[10] = M1(3,4); (*(M2[68]))[11] = M1(3,5); (*(M2[68]))[12] = M1(3,6); (*(M2[68]))[17] = M1(3,7); (*(M2[68]))[18] = M1(3,8); (*(M2[68]))[23] = M1(3,9); (*(M2[68]))[36] = M1(3,10); (*(M2[68]))[37] = M1(3,11); (*(M2[68]))[38] = M1(3,12); (*(M2[68]))[43] = M1(3,13); (*(M2[68]))[44] = M1(3,14); (*(M2[68]))[49] = M1(3,15); (*(M2[68]))[62] = M1(3,16); (*(M2[68]))[63] = M1(3,17); (*(M2[68]))[68] = M1(3,18); (*(M2[68]))[81] = M1(3,19); (*(M2[68]))[206] = M1(3,24); (*(M2[68]))[207] = M1(3,25); (*(M2[68]))[213] = M1(3,26); (*(M2[68]))[234] = M1(3,27); 
(*(M2[69]))[104] = M1(4,20); (*(M2[69]))[106] = M1(4,21); (*(M2[69]))[118] = M1(4,22); (*(M2[69]))[163] = M1(4,23); (*(M2[69]))[288] = M1(4,28); 
(*(M2[70]))[59] = M1(0,0); (*(M2[70]))[65] = M1(0,4); (*(M2[70]))[66] = M1(0,5); (*(M2[70]))[67] = M1(0,6); (*(M2[70]))[70] = M1(0,7); (*(M2[70]))[71] = M1(0,8); (*(M2[70]))[74] = M1(0,9); (*(M2[70]))[78] = M1(0,10); (*(M2[70]))[79] = M1(0,11); (*(M2[70]))[80] = M1(0,12); (*(M2[70]))[83] = M1(0,13); (*(M2[70]))[84] = M1(0,14); (*(M2[70]))[87] = M1(0,15); (*(M2[70]))[91] = M1(0,16); (*(M2[70]))[92] = M1(0,17); (*(M2[70]))[95] = M1(0,18); (*(M2[70]))[99] = M1(0,19); (*(M2[70]))[252] = M1(0,24); (*(M2[70]))[253] = M1(0,25); (*(M2[70]))[257] = M1(0,26); (*(M2[70]))[267] = M1(0,27); 
(*(M2[71]))[60] = M1(1,1); (*(M2[71]))[65] = M1(1,4); (*(M2[71]))[66] = M1(1,5); (*(M2[71]))[67] = M1(1,6); (*(M2[71]))[70] = M1(1,7); (*(M2[71]))[71] = M1(1,8); (*(M2[71]))[74] = M1(1,9); (*(M2[71]))[78] = M1(1,10); (*(M2[71]))[79] = M1(1,11); (*(M2[71]))[80] = M1(1,12); (*(M2[71]))[83] = M1(1,13); (*(M2[71]))[84] = M1(1,14); (*(M2[71]))[87] = M1(1,15); (*(M2[71]))[91] = M1(1,16); (*(M2[71]))[92] = M1(1,17); (*(M2[71]))[95] = M1(1,18); (*(M2[71]))[99] = M1(1,19); (*(M2[71]))[252] = M1(1,24); (*(M2[71]))[253] = M1(1,25); (*(M2[71]))[257] = M1(1,26); (*(M2[71]))[267] = M1(1,27); 
(*(M2[72]))[61] = M1(2,2); (*(M2[72]))[65] = M1(2,4); (*(M2[72]))[66] = M1(2,5); (*(M2[72]))[67] = M1(2,6); (*(M2[72]))[70] = M1(2,7); (*(M2[72]))[71] = M1(2,8); (*(M2[72]))[74] = M1(2,9); (*(M2[72]))[78] = M1(2,10); (*(M2[72]))[79] = M1(2,11); (*(M2[72]))[80] = M1(2,12); (*(M2[72]))[83] = M1(2,13); (*(M2[72]))[84] = M1(2,14); (*(M2[72]))[87] = M1(2,15); (*(M2[72]))[91] = M1(2,16); (*(M2[72]))[92] = M1(2,17); (*(M2[72]))[95] = M1(2,18); (*(M2[72]))[99] = M1(2,19); (*(M2[72]))[252] = M1(2,24); (*(M2[72]))[253] = M1(2,25); (*(M2[72]))[257] = M1(2,26); (*(M2[72]))[267] = M1(2,27); 
(*(M2[73]))[62] = M1(3,3); (*(M2[73]))[65] = M1(3,4); (*(M2[73]))[66] = M1(3,5); (*(M2[73]))[67] = M1(3,6); (*(M2[73]))[70] = M1(3,7); (*(M2[73]))[71] = M1(3,8); (*(M2[73]))[74] = M1(3,9); (*(M2[73]))[78] = M1(3,10); (*(M2[73]))[79] = M1(3,11); (*(M2[73]))[80] = M1(3,12); (*(M2[73]))[83] = M1(3,13); (*(M2[73]))[84] = M1(3,14); (*(M2[73]))[87] = M1(3,15); (*(M2[73]))[91] = M1(3,16); (*(M2[73]))[92] = M1(3,17); (*(M2[73]))[95] = M1(3,18); (*(M2[73]))[99] = M1(3,19); (*(M2[73]))[252] = M1(3,24); (*(M2[73]))[253] = M1(3,25); (*(M2[73]))[257] = M1(3,26); (*(M2[73]))[267] = M1(3,27); 
(*(M2[74]))[160] = M1(4,20); (*(M2[74]))[162] = M1(4,21); (*(M2[74]))[171] = M1(4,22); (*(M2[74]))[192] = M1(4,23); (*(M2[74]))[321] = M1(4,28); 
(*(M2[75]))[40] = M1(0,0); (*(M2[75]))[46] = M1(0,4); (*(M2[75]))[47] = M1(0,5); (*(M2[75]))[48] = M1(0,6); (*(M2[75]))[51] = M1(0,7); (*(M2[75]))[52] = M1(0,8); (*(M2[75]))[55] = M1(0,9); (*(M2[75]))[65] = M1(0,10); (*(M2[75]))[66] = M1(0,11); (*(M2[75]))[67] = M1(0,12); (*(M2[75]))[70] = M1(0,13); (*(M2[75]))[71] = M1(0,14); (*(M2[75]))[74] = M1(0,15); (*(M2[75]))[83] = M1(0,16); (*(M2[75]))[84] = M1(0,17); (*(M2[75]))[87] = M1(0,18); (*(M2[75]))[95] = M1(0,19); (*(M2[75]))[237] = M1(0,24); (*(M2[75]))[238] = M1(0,25); (*(M2[75]))[242] = M1(0,26); (*(M2[75]))[257] = M1(0,27); 
(*(M2[76]))[41] = M1(1,1); (*(M2[76]))[46] = M1(1,4); (*(M2[76]))[47] = M1(1,5); (*(M2[76]))[48] = M1(1,6); (*(M2[76]))[51] = M1(1,7); (*(M2[76]))[52] = M1(1,8); (*(M2[76]))[55] = M1(1,9); (*(M2[76]))[65] = M1(1,10); (*(M2[76]))[66] = M1(1,11); (*(M2[76]))[67] = M1(1,12); (*(M2[76]))[70] = M1(1,13); (*(M2[76]))[71] = M1(1,14); (*(M2[76]))[74] = M1(1,15); (*(M2[76]))[83] = M1(1,16); (*(M2[76]))[84] = M1(1,17); (*(M2[76]))[87] = M1(1,18); (*(M2[76]))[95] = M1(1,19); (*(M2[76]))[237] = M1(1,24); (*(M2[76]))[238] = M1(1,25); (*(M2[76]))[242] = M1(1,26); (*(M2[76]))[257] = M1(1,27); 
(*(M2[77]))[42] = M1(2,2); (*(M2[77]))[46] = M1(2,4); (*(M2[77]))[47] = M1(2,5); (*(M2[77]))[48] = M1(2,6); (*(M2[77]))[51] = M1(2,7); (*(M2[77]))[52] = M1(2,8); (*(M2[77]))[55] = M1(2,9); (*(M2[77]))[65] = M1(2,10); (*(M2[77]))[66] = M1(2,11); (*(M2[77]))[67] = M1(2,12); (*(M2[77]))[70] = M1(2,13); (*(M2[77]))[71] = M1(2,14); (*(M2[77]))[74] = M1(2,15); (*(M2[77]))[83] = M1(2,16); (*(M2[77]))[84] = M1(2,17); (*(M2[77]))[87] = M1(2,18); (*(M2[77]))[95] = M1(2,19); (*(M2[77]))[237] = M1(2,24); (*(M2[77]))[238] = M1(2,25); (*(M2[77]))[242] = M1(2,26); (*(M2[77]))[257] = M1(2,27); 
(*(M2[78]))[43] = M1(3,3); (*(M2[78]))[46] = M1(3,4); (*(M2[78]))[47] = M1(3,5); (*(M2[78]))[48] = M1(3,6); (*(M2[78]))[51] = M1(3,7); (*(M2[78]))[52] = M1(3,8); (*(M2[78]))[55] = M1(3,9); (*(M2[78]))[65] = M1(3,10); (*(M2[78]))[66] = M1(3,11); (*(M2[78]))[67] = M1(3,12); (*(M2[78]))[70] = M1(3,13); (*(M2[78]))[71] = M1(3,14); (*(M2[78]))[74] = M1(3,15); (*(M2[78]))[83] = M1(3,16); (*(M2[78]))[84] = M1(3,17); (*(M2[78]))[87] = M1(3,18); (*(M2[78]))[95] = M1(3,19); (*(M2[78]))[237] = M1(3,24); (*(M2[78]))[238] = M1(3,25); (*(M2[78]))[242] = M1(3,26); (*(M2[78]))[257] = M1(3,27); 
(*(M2[79]))[141] = M1(4,20); (*(M2[79]))[143] = M1(4,21); (*(M2[79]))[152] = M1(4,22); (*(M2[79]))[184] = M1(4,23); (*(M2[79]))[311] = M1(4,28); 
(*(M2[80]))[14] = M1(0,0); (*(M2[80]))[20] = M1(0,4); (*(M2[80]))[21] = M1(0,5); (*(M2[80]))[22] = M1(0,6); (*(M2[80]))[25] = M1(0,7); (*(M2[80]))[26] = M1(0,8); (*(M2[80]))[29] = M1(0,9); (*(M2[80]))[46] = M1(0,10); (*(M2[80]))[47] = M1(0,11); (*(M2[80]))[48] = M1(0,12); (*(M2[80]))[51] = M1(0,13); (*(M2[80]))[52] = M1(0,14); (*(M2[80]))[55] = M1(0,15); (*(M2[80]))[70] = M1(0,16); (*(M2[80]))[71] = M1(0,17); (*(M2[80]))[74] = M1(0,18); (*(M2[80]))[87] = M1(0,19); (*(M2[80]))[216] = M1(0,24); (*(M2[80]))[217] = M1(0,25); (*(M2[80]))[221] = M1(0,26); (*(M2[80]))[242] = M1(0,27); 
(*(M2[81]))[15] = M1(1,1); (*(M2[81]))[20] = M1(1,4); (*(M2[81]))[21] = M1(1,5); (*(M2[81]))[22] = M1(1,6); (*(M2[81]))[25] = M1(1,7); (*(M2[81]))[26] = M1(1,8); (*(M2[81]))[29] = M1(1,9); (*(M2[81]))[46] = M1(1,10); (*(M2[81]))[47] = M1(1,11); (*(M2[81]))[48] = M1(1,12); (*(M2[81]))[51] = M1(1,13); (*(M2[81]))[52] = M1(1,14); (*(M2[81]))[55] = M1(1,15); (*(M2[81]))[70] = M1(1,16); (*(M2[81]))[71] = M1(1,17); (*(M2[81]))[74] = M1(1,18); (*(M2[81]))[87] = M1(1,19); (*(M2[81]))[216] = M1(1,24); (*(M2[81]))[217] = M1(1,25); (*(M2[81]))[221] = M1(1,26); (*(M2[81]))[242] = M1(1,27); 
(*(M2[82]))[16] = M1(2,2); (*(M2[82]))[20] = M1(2,4); (*(M2[82]))[21] = M1(2,5); (*(M2[82]))[22] = M1(2,6); (*(M2[82]))[25] = M1(2,7); (*(M2[82]))[26] = M1(2,8); (*(M2[82]))[29] = M1(2,9); (*(M2[82]))[46] = M1(2,10); (*(M2[82]))[47] = M1(2,11); (*(M2[82]))[48] = M1(2,12); (*(M2[82]))[51] = M1(2,13); (*(M2[82]))[52] = M1(2,14); (*(M2[82]))[55] = M1(2,15); (*(M2[82]))[70] = M1(2,16); (*(M2[82]))[71] = M1(2,17); (*(M2[82]))[74] = M1(2,18); (*(M2[82]))[87] = M1(2,19); (*(M2[82]))[216] = M1(2,24); (*(M2[82]))[217] = M1(2,25); (*(M2[82]))[221] = M1(2,26); (*(M2[82]))[242] = M1(2,27); 
(*(M2[83]))[17] = M1(3,3); (*(M2[83]))[20] = M1(3,4); (*(M2[83]))[21] = M1(3,5); (*(M2[83]))[22] = M1(3,6); (*(M2[83]))[25] = M1(3,7); (*(M2[83]))[26] = M1(3,8); (*(M2[83]))[29] = M1(3,9); (*(M2[83]))[46] = M1(3,10); (*(M2[83]))[47] = M1(3,11); (*(M2[83]))[48] = M1(3,12); (*(M2[83]))[51] = M1(3,13); (*(M2[83]))[52] = M1(3,14); (*(M2[83]))[55] = M1(3,15); (*(M2[83]))[70] = M1(3,16); (*(M2[83]))[71] = M1(3,17); (*(M2[83]))[74] = M1(3,18); (*(M2[83]))[87] = M1(3,19); (*(M2[83]))[216] = M1(3,24); (*(M2[83]))[217] = M1(3,25); (*(M2[83]))[221] = M1(3,26); (*(M2[83]))[242] = M1(3,27); 
(*(M2[84]))[115] = M1(4,20); (*(M2[84]))[117] = M1(4,21); (*(M2[84]))[126] = M1(4,22); (*(M2[84]))[171] = M1(4,23); (*(M2[84]))[296] = M1(4,28); 
(*(M2[85]))[34] = M1(0,0); (*(M2[85]))[41] = M1(0,4); (*(M2[85]))[42] = M1(0,5); (*(M2[85]))[43] = M1(0,6); (*(M2[85]))[47] = M1(0,7); (*(M2[85]))[48] = M1(0,8); (*(M2[85]))[52] = M1(0,9); (*(M2[85]))[60] = M1(0,10); (*(M2[85]))[61] = M1(0,11); (*(M2[85]))[62] = M1(0,12); (*(M2[85]))[66] = M1(0,13); (*(M2[85]))[67] = M1(0,14); (*(M2[85]))[71] = M1(0,15); (*(M2[85]))[79] = M1(0,16); (*(M2[85]))[80] = M1(0,17); (*(M2[85]))[84] = M1(0,18); (*(M2[85]))[92] = M1(0,19); (*(M2[85]))[232] = M1(0,24); (*(M2[85]))[233] = M1(0,25); (*(M2[85]))[238] = M1(0,26); (*(M2[85]))[253] = M1(0,27); 
(*(M2[86]))[35] = M1(1,1); (*(M2[86]))[41] = M1(1,4); (*(M2[86]))[42] = M1(1,5); (*(M2[86]))[43] = M1(1,6); (*(M2[86]))[47] = M1(1,7); (*(M2[86]))[48] = M1(1,8); (*(M2[86]))[52] = M1(1,9); (*(M2[86]))[60] = M1(1,10); (*(M2[86]))[61] = M1(1,11); (*(M2[86]))[62] = M1(1,12); (*(M2[86]))[66] = M1(1,13); (*(M2[86]))[67] = M1(1,14); (*(M2[86]))[71] = M1(1,15); (*(M2[86]))[79] = M1(1,16); (*(M2[86]))[80] = M1(1,17); (*(M2[86]))[84] = M1(1,18); (*(M2[86]))[92] = M1(1,19); (*(M2[86]))[232] = M1(1,24); (*(M2[86]))[233] = M1(1,25); (*(M2[86]))[238] = M1(1,26); (*(M2[86]))[253] = M1(1,27); 
(*(M2[87]))[36] = M1(2,2); (*(M2[87]))[41] = M1(2,4); (*(M2[87]))[42] = M1(2,5); (*(M2[87]))[43] = M1(2,6); (*(M2[87]))[47] = M1(2,7); (*(M2[87]))[48] = M1(2,8); (*(M2[87]))[52] = M1(2,9); (*(M2[87]))[60] = M1(2,10); (*(M2[87]))[61] = M1(2,11); (*(M2[87]))[62] = M1(2,12); (*(M2[87]))[66] = M1(2,13); (*(M2[87]))[67] = M1(2,14); (*(M2[87]))[71] = M1(2,15); (*(M2[87]))[79] = M1(2,16); (*(M2[87]))[80] = M1(2,17); (*(M2[87]))[84] = M1(2,18); (*(M2[87]))[92] = M1(2,19); (*(M2[87]))[232] = M1(2,24); (*(M2[87]))[233] = M1(2,25); (*(M2[87]))[238] = M1(2,26); (*(M2[87]))[253] = M1(2,27); 
(*(M2[88]))[37] = M1(3,3); (*(M2[88]))[41] = M1(3,4); (*(M2[88]))[42] = M1(3,5); (*(M2[88]))[43] = M1(3,6); (*(M2[88]))[47] = M1(3,7); (*(M2[88]))[48] = M1(3,8); (*(M2[88]))[52] = M1(3,9); (*(M2[88]))[60] = M1(3,10); (*(M2[88]))[61] = M1(3,11); (*(M2[88]))[62] = M1(3,12); (*(M2[88]))[66] = M1(3,13); (*(M2[88]))[67] = M1(3,14); (*(M2[88]))[71] = M1(3,15); (*(M2[88]))[79] = M1(3,16); (*(M2[88]))[80] = M1(3,17); (*(M2[88]))[84] = M1(3,18); (*(M2[88]))[92] = M1(3,19); (*(M2[88]))[232] = M1(3,24); (*(M2[88]))[233] = M1(3,25); (*(M2[88]))[238] = M1(3,26); (*(M2[88]))[253] = M1(3,27); 
(*(M2[89]))[135] = M1(4,20); (*(M2[89]))[137] = M1(4,21); (*(M2[89]))[148] = M1(4,22); (*(M2[89]))[180] = M1(4,23); (*(M2[89]))[307] = M1(4,28); 
(*(M2[90]))[8] = M1(0,0); (*(M2[90]))[15] = M1(0,4); (*(M2[90]))[16] = M1(0,5); (*(M2[90]))[17] = M1(0,6); (*(M2[90]))[21] = M1(0,7); (*(M2[90]))[22] = M1(0,8); (*(M2[90]))[26] = M1(0,9); (*(M2[90]))[41] = M1(0,10); (*(M2[90]))[42] = M1(0,11); (*(M2[90]))[43] = M1(0,12); (*(M2[90]))[47] = M1(0,13); (*(M2[90]))[48] = M1(0,14); (*(M2[90]))[52] = M1(0,15); (*(M2[90]))[66] = M1(0,16); (*(M2[90]))[67] = M1(0,17); (*(M2[90]))[71] = M1(0,18); (*(M2[90]))[84] = M1(0,19); (*(M2[90]))[211] = M1(0,24); (*(M2[90]))[212] = M1(0,25); (*(M2[90]))[217] = M1(0,26); (*(M2[90]))[238] = M1(0,27); 
(*(M2[91]))[9] = M1(1,1); (*(M2[91]))[15] = M1(1,4); (*(M2[91]))[16] = M1(1,5); (*(M2[91]))[17] = M1(1,6); (*(M2[91]))[21] = M1(1,7); (*(M2[91]))[22] = M1(1,8); (*(M2[91]))[26] = M1(1,9); (*(M2[91]))[41] = M1(1,10); (*(M2[91]))[42] = M1(1,11); (*(M2[91]))[43] = M1(1,12); (*(M2[91]))[47] = M1(1,13); (*(M2[91]))[48] = M1(1,14); (*(M2[91]))[52] = M1(1,15); (*(M2[91]))[66] = M1(1,16); (*(M2[91]))[67] = M1(1,17); (*(M2[91]))[71] = M1(1,18); (*(M2[91]))[84] = M1(1,19); (*(M2[91]))[211] = M1(1,24); (*(M2[91]))[212] = M1(1,25); (*(M2[91]))[217] = M1(1,26); (*(M2[91]))[238] = M1(1,27); 
(*(M2[92]))[10] = M1(2,2); (*(M2[92]))[15] = M1(2,4); (*(M2[92]))[16] = M1(2,5); (*(M2[92]))[17] = M1(2,6); (*(M2[92]))[21] = M1(2,7); (*(M2[92]))[22] = M1(2,8); (*(M2[92]))[26] = M1(2,9); (*(M2[92]))[41] = M1(2,10); (*(M2[92]))[42] = M1(2,11); (*(M2[92]))[43] = M1(2,12); (*(M2[92]))[47] = M1(2,13); (*(M2[92]))[48] = M1(2,14); (*(M2[92]))[52] = M1(2,15); (*(M2[92]))[66] = M1(2,16); (*(M2[92]))[67] = M1(2,17); (*(M2[92]))[71] = M1(2,18); (*(M2[92]))[84] = M1(2,19); (*(M2[92]))[211] = M1(2,24); (*(M2[92]))[212] = M1(2,25); (*(M2[92]))[217] = M1(2,26); (*(M2[92]))[238] = M1(2,27); 
(*(M2[93]))[11] = M1(3,3); (*(M2[93]))[15] = M1(3,4); (*(M2[93]))[16] = M1(3,5); (*(M2[93]))[17] = M1(3,6); (*(M2[93]))[21] = M1(3,7); (*(M2[93]))[22] = M1(3,8); (*(M2[93]))[26] = M1(3,9); (*(M2[93]))[41] = M1(3,10); (*(M2[93]))[42] = M1(3,11); (*(M2[93]))[43] = M1(3,12); (*(M2[93]))[47] = M1(3,13); (*(M2[93]))[48] = M1(3,14); (*(M2[93]))[52] = M1(3,15); (*(M2[93]))[66] = M1(3,16); (*(M2[93]))[67] = M1(3,17); (*(M2[93]))[71] = M1(3,18); (*(M2[93]))[84] = M1(3,19); (*(M2[93]))[211] = M1(3,24); (*(M2[93]))[212] = M1(3,25); (*(M2[93]))[217] = M1(3,26); (*(M2[93]))[238] = M1(3,27); 
(*(M2[94]))[109] = M1(4,20); (*(M2[94]))[111] = M1(4,21); (*(M2[94]))[122] = M1(4,22); (*(M2[94]))[167] = M1(4,23); (*(M2[94]))[292] = M1(4,28); 
(*(M2[95]))[2] = M1(0,0); (*(M2[95]))[9] = M1(0,4); (*(M2[95]))[10] = M1(0,5); (*(M2[95]))[11] = M1(0,6); (*(M2[95]))[16] = M1(0,7); (*(M2[95]))[17] = M1(0,8); (*(M2[95]))[22] = M1(0,9); (*(M2[95]))[35] = M1(0,10); (*(M2[95]))[36] = M1(0,11); (*(M2[95]))[37] = M1(0,12); (*(M2[95]))[42] = M1(0,13); (*(M2[95]))[43] = M1(0,14); (*(M2[95]))[48] = M1(0,15); (*(M2[95]))[61] = M1(0,16); (*(M2[95]))[62] = M1(0,17); (*(M2[95]))[67] = M1(0,18); (*(M2[95]))[80] = M1(0,19); (*(M2[95]))[205] = M1(0,24); (*(M2[95]))[206] = M1(0,25); (*(M2[95]))[212] = M1(0,26); (*(M2[95]))[233] = M1(0,27); 
(*(M2[96]))[3] = M1(1,1); (*(M2[96]))[9] = M1(1,4); (*(M2[96]))[10] = M1(1,5); (*(M2[96]))[11] = M1(1,6); (*(M2[96]))[16] = M1(1,7); (*(M2[96]))[17] = M1(1,8); (*(M2[96]))[22] = M1(1,9); (*(M2[96]))[35] = M1(1,10); (*(M2[96]))[36] = M1(1,11); (*(M2[96]))[37] = M1(1,12); (*(M2[96]))[42] = M1(1,13); (*(M2[96]))[43] = M1(1,14); (*(M2[96]))[48] = M1(1,15); (*(M2[96]))[61] = M1(1,16); (*(M2[96]))[62] = M1(1,17); (*(M2[96]))[67] = M1(1,18); (*(M2[96]))[80] = M1(1,19); (*(M2[96]))[205] = M1(1,24); (*(M2[96]))[206] = M1(1,25); (*(M2[96]))[212] = M1(1,26); (*(M2[96]))[233] = M1(1,27); 
(*(M2[97]))[4] = M1(2,2); (*(M2[97]))[9] = M1(2,4); (*(M2[97]))[10] = M1(2,5); (*(M2[97]))[11] = M1(2,6); (*(M2[97]))[16] = M1(2,7); (*(M2[97]))[17] = M1(2,8); (*(M2[97]))[22] = M1(2,9); (*(M2[97]))[35] = M1(2,10); (*(M2[97]))[36] = M1(2,11); (*(M2[97]))[37] = M1(2,12); (*(M2[97]))[42] = M1(2,13); (*(M2[97]))[43] = M1(2,14); (*(M2[97]))[48] = M1(2,15); (*(M2[97]))[61] = M1(2,16); (*(M2[97]))[62] = M1(2,17); (*(M2[97]))[67] = M1(2,18); (*(M2[97]))[80] = M1(2,19); (*(M2[97]))[205] = M1(2,24); (*(M2[97]))[206] = M1(2,25); (*(M2[97]))[212] = M1(2,26); (*(M2[97]))[233] = M1(2,27); 
(*(M2[98]))[5] = M1(3,3); (*(M2[98]))[9] = M1(3,4); (*(M2[98]))[10] = M1(3,5); (*(M2[98]))[11] = M1(3,6); (*(M2[98]))[16] = M1(3,7); (*(M2[98]))[17] = M1(3,8); (*(M2[98]))[22] = M1(3,9); (*(M2[98]))[35] = M1(3,10); (*(M2[98]))[36] = M1(3,11); (*(M2[98]))[37] = M1(3,12); (*(M2[98]))[42] = M1(3,13); (*(M2[98]))[43] = M1(3,14); (*(M2[98]))[48] = M1(3,15); (*(M2[98]))[61] = M1(3,16); (*(M2[98]))[62] = M1(3,17); (*(M2[98]))[67] = M1(3,18); (*(M2[98]))[80] = M1(3,19); (*(M2[98]))[205] = M1(3,24); (*(M2[98]))[206] = M1(3,25); (*(M2[98]))[212] = M1(3,26); (*(M2[98]))[233] = M1(3,27); 
(*(M2[99]))[103] = M1(4,20); (*(M2[99]))[105] = M1(4,21); (*(M2[99]))[117] = M1(4,22); (*(M2[99]))[162] = M1(4,23); (*(M2[99]))[287] = M1(4,28); 
(*(M2[100]))[33] = M1(0,0); (*(M2[100]))[40] = M1(0,4); (*(M2[100]))[41] = M1(0,5); (*(M2[100]))[42] = M1(0,6); (*(M2[100]))[46] = M1(0,7); (*(M2[100]))[47] = M1(0,8); (*(M2[100]))[51] = M1(0,9); (*(M2[100]))[59] = M1(0,10); (*(M2[100]))[60] = M1(0,11); (*(M2[100]))[61] = M1(0,12); (*(M2[100]))[65] = M1(0,13); (*(M2[100]))[66] = M1(0,14); (*(M2[100]))[70] = M1(0,15); (*(M2[100]))[78] = M1(0,16); (*(M2[100]))[79] = M1(0,17); (*(M2[100]))[83] = M1(0,18); (*(M2[100]))[91] = M1(0,19); (*(M2[100]))[231] = M1(0,24); (*(M2[100]))[232] = M1(0,25); (*(M2[100]))[237] = M1(0,26); (*(M2[100]))[252] = M1(0,27); 
(*(M2[101]))[34] = M1(1,1); (*(M2[101]))[40] = M1(1,4); (*(M2[101]))[41] = M1(1,5); (*(M2[101]))[42] = M1(1,6); (*(M2[101]))[46] = M1(1,7); (*(M2[101]))[47] = M1(1,8); (*(M2[101]))[51] = M1(1,9); (*(M2[101]))[59] = M1(1,10); (*(M2[101]))[60] = M1(1,11); (*(M2[101]))[61] = M1(1,12); (*(M2[101]))[65] = M1(1,13); (*(M2[101]))[66] = M1(1,14); (*(M2[101]))[70] = M1(1,15); (*(M2[101]))[78] = M1(1,16); (*(M2[101]))[79] = M1(1,17); (*(M2[101]))[83] = M1(1,18); (*(M2[101]))[91] = M1(1,19); (*(M2[101]))[231] = M1(1,24); (*(M2[101]))[232] = M1(1,25); (*(M2[101]))[237] = M1(1,26); (*(M2[101]))[252] = M1(1,27); 
(*(M2[102]))[35] = M1(2,2); (*(M2[102]))[40] = M1(2,4); (*(M2[102]))[41] = M1(2,5); (*(M2[102]))[42] = M1(2,6); (*(M2[102]))[46] = M1(2,7); (*(M2[102]))[47] = M1(2,8); (*(M2[102]))[51] = M1(2,9); (*(M2[102]))[59] = M1(2,10); (*(M2[102]))[60] = M1(2,11); (*(M2[102]))[61] = M1(2,12); (*(M2[102]))[65] = M1(2,13); (*(M2[102]))[66] = M1(2,14); (*(M2[102]))[70] = M1(2,15); (*(M2[102]))[78] = M1(2,16); (*(M2[102]))[79] = M1(2,17); (*(M2[102]))[83] = M1(2,18); (*(M2[102]))[91] = M1(2,19); (*(M2[102]))[231] = M1(2,24); (*(M2[102]))[232] = M1(2,25); (*(M2[102]))[237] = M1(2,26); (*(M2[102]))[252] = M1(2,27); 
(*(M2[103]))[36] = M1(3,3); (*(M2[103]))[40] = M1(3,4); (*(M2[103]))[41] = M1(3,5); (*(M2[103]))[42] = M1(3,6); (*(M2[103]))[46] = M1(3,7); (*(M2[103]))[47] = M1(3,8); (*(M2[103]))[51] = M1(3,9); (*(M2[103]))[59] = M1(3,10); (*(M2[103]))[60] = M1(3,11); (*(M2[103]))[61] = M1(3,12); (*(M2[103]))[65] = M1(3,13); (*(M2[103]))[66] = M1(3,14); (*(M2[103]))[70] = M1(3,15); (*(M2[103]))[78] = M1(3,16); (*(M2[103]))[79] = M1(3,17); (*(M2[103]))[83] = M1(3,18); (*(M2[103]))[91] = M1(3,19); (*(M2[103]))[231] = M1(3,24); (*(M2[103]))[232] = M1(3,25); (*(M2[103]))[237] = M1(3,26); (*(M2[103]))[252] = M1(3,27); 
(*(M2[104]))[134] = M1(4,20); (*(M2[104]))[136] = M1(4,21); (*(M2[104]))[147] = M1(4,22); (*(M2[104]))[179] = M1(4,23); (*(M2[104]))[306] = M1(4,28); 
(*(M2[105]))[7] = M1(0,0); (*(M2[105]))[14] = M1(0,4); (*(M2[105]))[15] = M1(0,5); (*(M2[105]))[16] = M1(0,6); (*(M2[105]))[20] = M1(0,7); (*(M2[105]))[21] = M1(0,8); (*(M2[105]))[25] = M1(0,9); (*(M2[105]))[40] = M1(0,10); (*(M2[105]))[41] = M1(0,11); (*(M2[105]))[42] = M1(0,12); (*(M2[105]))[46] = M1(0,13); (*(M2[105]))[47] = M1(0,14); (*(M2[105]))[51] = M1(0,15); (*(M2[105]))[65] = M1(0,16); (*(M2[105]))[66] = M1(0,17); (*(M2[105]))[70] = M1(0,18); (*(M2[105]))[83] = M1(0,19); (*(M2[105]))[210] = M1(0,24); (*(M2[105]))[211] = M1(0,25); (*(M2[105]))[216] = M1(0,26); (*(M2[105]))[237] = M1(0,27); 
(*(M2[106]))[8] = M1(1,1); (*(M2[106]))[14] = M1(1,4); (*(M2[106]))[15] = M1(1,5); (*(M2[106]))[16] = M1(1,6); (*(M2[106]))[20] = M1(1,7); (*(M2[106]))[21] = M1(1,8); (*(M2[106]))[25] = M1(1,9); (*(M2[106]))[40] = M1(1,10); (*(M2[106]))[41] = M1(1,11); (*(M2[106]))[42] = M1(1,12); (*(M2[106]))[46] = M1(1,13); (*(M2[106]))[47] = M1(1,14); (*(M2[106]))[51] = M1(1,15); (*(M2[106]))[65] = M1(1,16); (*(M2[106]))[66] = M1(1,17); (*(M2[106]))[70] = M1(1,18); (*(M2[106]))[83] = M1(1,19); (*(M2[106]))[210] = M1(1,24); (*(M2[106]))[211] = M1(1,25); (*(M2[106]))[216] = M1(1,26); (*(M2[106]))[237] = M1(1,27); 
(*(M2[107]))[9] = M1(2,2); (*(M2[107]))[14] = M1(2,4); (*(M2[107]))[15] = M1(2,5); (*(M2[107]))[16] = M1(2,6); (*(M2[107]))[20] = M1(2,7); (*(M2[107]))[21] = M1(2,8); (*(M2[107]))[25] = M1(2,9); (*(M2[107]))[40] = M1(2,10); (*(M2[107]))[41] = M1(2,11); (*(M2[107]))[42] = M1(2,12); (*(M2[107]))[46] = M1(2,13); (*(M2[107]))[47] = M1(2,14); (*(M2[107]))[51] = M1(2,15); (*(M2[107]))[65] = M1(2,16); (*(M2[107]))[66] = M1(2,17); (*(M2[107]))[70] = M1(2,18); (*(M2[107]))[83] = M1(2,19); (*(M2[107]))[210] = M1(2,24); (*(M2[107]))[211] = M1(2,25); (*(M2[107]))[216] = M1(2,26); (*(M2[107]))[237] = M1(2,27); 
(*(M2[108]))[10] = M1(3,3); (*(M2[108]))[14] = M1(3,4); (*(M2[108]))[15] = M1(3,5); (*(M2[108]))[16] = M1(3,6); (*(M2[108]))[20] = M1(3,7); (*(M2[108]))[21] = M1(3,8); (*(M2[108]))[25] = M1(3,9); (*(M2[108]))[40] = M1(3,10); (*(M2[108]))[41] = M1(3,11); (*(M2[108]))[42] = M1(3,12); (*(M2[108]))[46] = M1(3,13); (*(M2[108]))[47] = M1(3,14); (*(M2[108]))[51] = M1(3,15); (*(M2[108]))[65] = M1(3,16); (*(M2[108]))[66] = M1(3,17); (*(M2[108]))[70] = M1(3,18); (*(M2[108]))[83] = M1(3,19); (*(M2[108]))[210] = M1(3,24); (*(M2[108]))[211] = M1(3,25); (*(M2[108]))[216] = M1(3,26); (*(M2[108]))[237] = M1(3,27); 
(*(M2[109]))[108] = M1(4,20); (*(M2[109]))[110] = M1(4,21); (*(M2[109]))[121] = M1(4,22); (*(M2[109]))[166] = M1(4,23); (*(M2[109]))[291] = M1(4,28); 
(*(M2[110]))[1] = M1(0,0); (*(M2[110]))[8] = M1(0,4); (*(M2[110]))[9] = M1(0,5); (*(M2[110]))[10] = M1(0,6); (*(M2[110]))[15] = M1(0,7); (*(M2[110]))[16] = M1(0,8); (*(M2[110]))[21] = M1(0,9); (*(M2[110]))[34] = M1(0,10); (*(M2[110]))[35] = M1(0,11); (*(M2[110]))[36] = M1(0,12); (*(M2[110]))[41] = M1(0,13); (*(M2[110]))[42] = M1(0,14); (*(M2[110]))[47] = M1(0,15); (*(M2[110]))[60] = M1(0,16); (*(M2[110]))[61] = M1(0,17); (*(M2[110]))[66] = M1(0,18); (*(M2[110]))[79] = M1(0,19); (*(M2[110]))[204] = M1(0,24); (*(M2[110]))[205] = M1(0,25); (*(M2[110]))[211] = M1(0,26); (*(M2[110]))[232] = M1(0,27); 
(*(M2[111]))[2] = M1(1,1); (*(M2[111]))[8] = M1(1,4); (*(M2[111]))[9] = M1(1,5); (*(M2[111]))[10] = M1(1,6); (*(M2[111]))[15] = M1(1,7); (*(M2[111]))[16] = M1(1,8); (*(M2[111]))[21] = M1(1,9); (*(M2[111]))[34] = M1(1,10); (*(M2[111]))[35] = M1(1,11); (*(M2[111]))[36] = M1(1,12); (*(M2[111]))[41] = M1(1,13); (*(M2[111]))[42] = M1(1,14); (*(M2[111]))[47] = M1(1,15); (*(M2[111]))[60] = M1(1,16); (*(M2[111]))[61] = M1(1,17); (*(M2[111]))[66] = M1(1,18); (*(M2[111]))[79] = M1(1,19); (*(M2[111]))[204] = M1(1,24); (*(M2[111]))[205] = M1(1,25); (*(M2[111]))[211] = M1(1,26); (*(M2[111]))[232] = M1(1,27); 
(*(M2[112]))[3] = M1(2,2); (*(M2[112]))[8] = M1(2,4); (*(M2[112]))[9] = M1(2,5); (*(M2[112]))[10] = M1(2,6); (*(M2[112]))[15] = M1(2,7); (*(M2[112]))[16] = M1(2,8); (*(M2[112]))[21] = M1(2,9); (*(M2[112]))[34] = M1(2,10); (*(M2[112]))[35] = M1(2,11); (*(M2[112]))[36] = M1(2,12); (*(M2[112]))[41] = M1(2,13); (*(M2[112]))[42] = M1(2,14); (*(M2[112]))[47] = M1(2,15); (*(M2[112]))[60] = M1(2,16); (*(M2[112]))[61] = M1(2,17); (*(M2[112]))[66] = M1(2,18); (*(M2[112]))[79] = M1(2,19); (*(M2[112]))[204] = M1(2,24); (*(M2[112]))[205] = M1(2,25); (*(M2[112]))[211] = M1(2,26); (*(M2[112]))[232] = M1(2,27); 
(*(M2[113]))[4] = M1(3,3); (*(M2[113]))[8] = M1(3,4); (*(M2[113]))[9] = M1(3,5); (*(M2[113]))[10] = M1(3,6); (*(M2[113]))[15] = M1(3,7); (*(M2[113]))[16] = M1(3,8); (*(M2[113]))[21] = M1(3,9); (*(M2[113]))[34] = M1(3,10); (*(M2[113]))[35] = M1(3,11); (*(M2[113]))[36] = M1(3,12); (*(M2[113]))[41] = M1(3,13); (*(M2[113]))[42] = M1(3,14); (*(M2[113]))[47] = M1(3,15); (*(M2[113]))[60] = M1(3,16); (*(M2[113]))[61] = M1(3,17); (*(M2[113]))[66] = M1(3,18); (*(M2[113]))[79] = M1(3,19); (*(M2[113]))[204] = M1(3,24); (*(M2[113]))[205] = M1(3,25); (*(M2[113]))[211] = M1(3,26); (*(M2[113]))[232] = M1(3,27); 
(*(M2[114]))[102] = M1(4,20); (*(M2[114]))[104] = M1(4,21); (*(M2[114]))[116] = M1(4,22); (*(M2[114]))[161] = M1(4,23); (*(M2[114]))[286] = M1(4,28); 
(*(M2[115]))[0] = M1(0,0); (*(M2[115]))[7] = M1(0,4); (*(M2[115]))[8] = M1(0,5); (*(M2[115]))[9] = M1(0,6); (*(M2[115]))[14] = M1(0,7); (*(M2[115]))[15] = M1(0,8); (*(M2[115]))[20] = M1(0,9); (*(M2[115]))[33] = M1(0,10); (*(M2[115]))[34] = M1(0,11); (*(M2[115]))[35] = M1(0,12); (*(M2[115]))[40] = M1(0,13); (*(M2[115]))[41] = M1(0,14); (*(M2[115]))[46] = M1(0,15); (*(M2[115]))[59] = M1(0,16); (*(M2[115]))[60] = M1(0,17); (*(M2[115]))[65] = M1(0,18); (*(M2[115]))[78] = M1(0,19); (*(M2[115]))[203] = M1(0,24); (*(M2[115]))[204] = M1(0,25); (*(M2[115]))[210] = M1(0,26); (*(M2[115]))[231] = M1(0,27); 
(*(M2[116]))[1] = M1(1,1); (*(M2[116]))[7] = M1(1,4); (*(M2[116]))[8] = M1(1,5); (*(M2[116]))[9] = M1(1,6); (*(M2[116]))[14] = M1(1,7); (*(M2[116]))[15] = M1(1,8); (*(M2[116]))[20] = M1(1,9); (*(M2[116]))[33] = M1(1,10); (*(M2[116]))[34] = M1(1,11); (*(M2[116]))[35] = M1(1,12); (*(M2[116]))[40] = M1(1,13); (*(M2[116]))[41] = M1(1,14); (*(M2[116]))[46] = M1(1,15); (*(M2[116]))[59] = M1(1,16); (*(M2[116]))[60] = M1(1,17); (*(M2[116]))[65] = M1(1,18); (*(M2[116]))[78] = M1(1,19); (*(M2[116]))[203] = M1(1,24); (*(M2[116]))[204] = M1(1,25); (*(M2[116]))[210] = M1(1,26); (*(M2[116]))[231] = M1(1,27); 
(*(M2[117]))[2] = M1(2,2); (*(M2[117]))[7] = M1(2,4); (*(M2[117]))[8] = M1(2,5); (*(M2[117]))[9] = M1(2,6); (*(M2[117]))[14] = M1(2,7); (*(M2[117]))[15] = M1(2,8); (*(M2[117]))[20] = M1(2,9); (*(M2[117]))[33] = M1(2,10); (*(M2[117]))[34] = M1(2,11); (*(M2[117]))[35] = M1(2,12); (*(M2[117]))[40] = M1(2,13); (*(M2[117]))[41] = M1(2,14); (*(M2[117]))[46] = M1(2,15); (*(M2[117]))[59] = M1(2,16); (*(M2[117]))[60] = M1(2,17); (*(M2[117]))[65] = M1(2,18); (*(M2[117]))[78] = M1(2,19); (*(M2[117]))[203] = M1(2,24); (*(M2[117]))[204] = M1(2,25); (*(M2[117]))[210] = M1(2,26); (*(M2[117]))[231] = M1(2,27); 
(*(M2[118]))[3] = M1(3,3); (*(M2[118]))[7] = M1(3,4); (*(M2[118]))[8] = M1(3,5); (*(M2[118]))[9] = M1(3,6); (*(M2[118]))[14] = M1(3,7); (*(M2[118]))[15] = M1(3,8); (*(M2[118]))[20] = M1(3,9); (*(M2[118]))[33] = M1(3,10); (*(M2[118]))[34] = M1(3,11); (*(M2[118]))[35] = M1(3,12); (*(M2[118]))[40] = M1(3,13); (*(M2[118]))[41] = M1(3,14); (*(M2[118]))[46] = M1(3,15); (*(M2[118]))[59] = M1(3,16); (*(M2[118]))[60] = M1(3,17); (*(M2[118]))[65] = M1(3,18); (*(M2[118]))[78] = M1(3,19); (*(M2[118]))[203] = M1(3,24); (*(M2[118]))[204] = M1(3,25); (*(M2[118]))[210] = M1(3,26); (*(M2[118]))[231] = M1(3,27); 
(*(M2[119]))[101] = M1(4,20); (*(M2[119]))[103] = M1(4,21); (*(M2[119]))[115] = M1(4,22); (*(M2[119]))[160] = M1(4,23); (*(M2[119]))[285] = M1(4,28); 
(*(M2[120]))[162] = M1(0,0); (*(M2[120]))[168] = M1(0,4); (*(M2[120]))[169] = M1(0,5); (*(M2[120]))[170] = M1(0,6); (*(M2[120]))[173] = M1(0,7); (*(M2[120]))[174] = M1(0,8); (*(M2[120]))[177] = M1(0,9); (*(M2[120]))[181] = M1(0,10); (*(M2[120]))[182] = M1(0,11); (*(M2[120]))[183] = M1(0,12); (*(M2[120]))[186] = M1(0,13); (*(M2[120]))[187] = M1(0,14); (*(M2[120]))[190] = M1(0,15); (*(M2[120]))[194] = M1(0,16); (*(M2[120]))[195] = M1(0,17); (*(M2[120]))[198] = M1(0,18); (*(M2[120]))[202] = M1(0,19); (*(M2[120]))[323] = M1(0,24); (*(M2[120]))[324] = M1(0,25); (*(M2[120]))[327] = M1(0,26); (*(M2[120]))[333] = M1(0,27); 
(*(M2[121]))[163] = M1(1,1); (*(M2[121]))[168] = M1(1,4); (*(M2[121]))[169] = M1(1,5); (*(M2[121]))[170] = M1(1,6); (*(M2[121]))[173] = M1(1,7); (*(M2[121]))[174] = M1(1,8); (*(M2[121]))[177] = M1(1,9); (*(M2[121]))[181] = M1(1,10); (*(M2[121]))[182] = M1(1,11); (*(M2[121]))[183] = M1(1,12); (*(M2[121]))[186] = M1(1,13); (*(M2[121]))[187] = M1(1,14); (*(M2[121]))[190] = M1(1,15); (*(M2[121]))[194] = M1(1,16); (*(M2[121]))[195] = M1(1,17); (*(M2[121]))[198] = M1(1,18); (*(M2[121]))[202] = M1(1,19); (*(M2[121]))[323] = M1(1,24); (*(M2[121]))[324] = M1(1,25); (*(M2[121]))[327] = M1(1,26); (*(M2[121]))[333] = M1(1,27); 
(*(M2[122]))[164] = M1(2,2); (*(M2[122]))[168] = M1(2,4); (*(M2[122]))[169] = M1(2,5); (*(M2[122]))[170] = M1(2,6); (*(M2[122]))[173] = M1(2,7); (*(M2[122]))[174] = M1(2,8); (*(M2[122]))[177] = M1(2,9); (*(M2[122]))[181] = M1(2,10); (*(M2[122]))[182] = M1(2,11); (*(M2[122]))[183] = M1(2,12); (*(M2[122]))[186] = M1(2,13); (*(M2[122]))[187] = M1(2,14); (*(M2[122]))[190] = M1(2,15); (*(M2[122]))[194] = M1(2,16); (*(M2[122]))[195] = M1(2,17); (*(M2[122]))[198] = M1(2,18); (*(M2[122]))[202] = M1(2,19); (*(M2[122]))[323] = M1(2,24); (*(M2[122]))[324] = M1(2,25); (*(M2[122]))[327] = M1(2,26); (*(M2[122]))[333] = M1(2,27); 
(*(M2[123]))[165] = M1(3,3); (*(M2[123]))[168] = M1(3,4); (*(M2[123]))[169] = M1(3,5); (*(M2[123]))[170] = M1(3,6); (*(M2[123]))[173] = M1(3,7); (*(M2[123]))[174] = M1(3,8); (*(M2[123]))[177] = M1(3,9); (*(M2[123]))[181] = M1(3,10); (*(M2[123]))[182] = M1(3,11); (*(M2[123]))[183] = M1(3,12); (*(M2[123]))[186] = M1(3,13); (*(M2[123]))[187] = M1(3,14); (*(M2[123]))[190] = M1(3,15); (*(M2[123]))[194] = M1(3,16); (*(M2[123]))[195] = M1(3,17); (*(M2[123]))[198] = M1(3,18); (*(M2[123]))[202] = M1(3,19); (*(M2[123]))[323] = M1(3,24); (*(M2[123]))[324] = M1(3,25); (*(M2[123]))[327] = M1(3,26); (*(M2[123]))[333] = M1(3,27); 
(*(M2[124]))[143] = M1(0,0); (*(M2[124]))[149] = M1(0,4); (*(M2[124]))[150] = M1(0,5); (*(M2[124]))[151] = M1(0,6); (*(M2[124]))[154] = M1(0,7); (*(M2[124]))[155] = M1(0,8); (*(M2[124]))[158] = M1(0,9); (*(M2[124]))[168] = M1(0,10); (*(M2[124]))[169] = M1(0,11); (*(M2[124]))[170] = M1(0,12); (*(M2[124]))[173] = M1(0,13); (*(M2[124]))[174] = M1(0,14); (*(M2[124]))[177] = M1(0,15); (*(M2[124]))[186] = M1(0,16); (*(M2[124]))[187] = M1(0,17); (*(M2[124]))[190] = M1(0,18); (*(M2[124]))[198] = M1(0,19); (*(M2[124]))[313] = M1(0,24); (*(M2[124]))[314] = M1(0,25); (*(M2[124]))[317] = M1(0,26); (*(M2[124]))[327] = M1(0,27); 
(*(M2[125]))[144] = M1(1,1); (*(M2[125]))[149] = M1(1,4); (*(M2[125]))[150] = M1(1,5); (*(M2[125]))[151] = M1(1,6); (*(M2[125]))[154] = M1(1,7); (*(M2[125]))[155] = M1(1,8); (*(M2[125]))[158] = M1(1,9); (*(M2[125]))[168] = M1(1,10); (*(M2[125]))[169] = M1(1,11); (*(M2[125]))[170] = M1(1,12); (*(M2[125]))[173] = M1(1,13); (*(M2[125]))[174] = M1(1,14); (*(M2[125]))[177] = M1(1,15); (*(M2[125]))[186] = M1(1,16); (*(M2[125]))[187] = M1(1,17); (*(M2[125]))[190] = M1(1,18); (*(M2[125]))[198] = M1(1,19); (*(M2[125]))[313] = M1(1,24); (*(M2[125]))[314] = M1(1,25); (*(M2[125]))[317] = M1(1,26); (*(M2[125]))[327] = M1(1,27); 
(*(M2[126]))[145] = M1(2,2); (*(M2[126]))[149] = M1(2,4); (*(M2[126]))[150] = M1(2,5); (*(M2[126]))[151] = M1(2,6); (*(M2[126]))[154] = M1(2,7); (*(M2[126]))[155] = M1(2,8); (*(M2[126]))[158] = M1(2,9); (*(M2[126]))[168] = M1(2,10); (*(M2[126]))[169] = M1(2,11); (*(M2[126]))[170] = M1(2,12); (*(M2[126]))[173] = M1(2,13); (*(M2[126]))[174] = M1(2,14); (*(M2[126]))[177] = M1(2,15); (*(M2[126]))[186] = M1(2,16); (*(M2[126]))[187] = M1(2,17); (*(M2[126]))[190] = M1(2,18); (*(M2[126]))[198] = M1(2,19); (*(M2[126]))[313] = M1(2,24); (*(M2[126]))[314] = M1(2,25); (*(M2[126]))[317] = M1(2,26); (*(M2[126]))[327] = M1(2,27); 
(*(M2[127]))[146] = M1(3,3); (*(M2[127]))[149] = M1(3,4); (*(M2[127]))[150] = M1(3,5); (*(M2[127]))[151] = M1(3,6); (*(M2[127]))[154] = M1(3,7); (*(M2[127]))[155] = M1(3,8); (*(M2[127]))[158] = M1(3,9); (*(M2[127]))[168] = M1(3,10); (*(M2[127]))[169] = M1(3,11); (*(M2[127]))[170] = M1(3,12); (*(M2[127]))[173] = M1(3,13); (*(M2[127]))[174] = M1(3,14); (*(M2[127]))[177] = M1(3,15); (*(M2[127]))[186] = M1(3,16); (*(M2[127]))[187] = M1(3,17); (*(M2[127]))[190] = M1(3,18); (*(M2[127]))[198] = M1(3,19); (*(M2[127]))[313] = M1(3,24); (*(M2[127]))[314] = M1(3,25); (*(M2[127]))[317] = M1(3,26); (*(M2[127]))[327] = M1(3,27); 
(*(M2[128]))[117] = M1(0,0); (*(M2[128]))[123] = M1(0,4); (*(M2[128]))[124] = M1(0,5); (*(M2[128]))[125] = M1(0,6); (*(M2[128]))[128] = M1(0,7); (*(M2[128]))[129] = M1(0,8); (*(M2[128]))[132] = M1(0,9); (*(M2[128]))[149] = M1(0,10); (*(M2[128]))[150] = M1(0,11); (*(M2[128]))[151] = M1(0,12); (*(M2[128]))[154] = M1(0,13); (*(M2[128]))[155] = M1(0,14); (*(M2[128]))[158] = M1(0,15); (*(M2[128]))[173] = M1(0,16); (*(M2[128]))[174] = M1(0,17); (*(M2[128]))[177] = M1(0,18); (*(M2[128]))[190] = M1(0,19); (*(M2[128]))[298] = M1(0,24); (*(M2[128]))[299] = M1(0,25); (*(M2[128]))[302] = M1(0,26); (*(M2[128]))[317] = M1(0,27); 
(*(M2[129]))[118] = M1(1,1); (*(M2[129]))[123] = M1(1,4); (*(M2[129]))[124] = M1(1,5); (*(M2[129]))[125] = M1(1,6); (*(M2[129]))[128] = M1(1,7); (*(M2[129]))[129] = M1(1,8); (*(M2[129]))[132] = M1(1,9); (*(M2[129]))[149] = M1(1,10); (*(M2[129]))[150] = M1(1,11); (*(M2[129]))[151] = M1(1,12); (*(M2[129]))[154] = M1(1,13); (*(M2[129]))[155] = M1(1,14); (*(M2[129]))[158] = M1(1,15); (*(M2[129]))[173] = M1(1,16); (*(M2[129]))[174] = M1(1,17); (*(M2[129]))[177] = M1(1,18); (*(M2[129]))[190] = M1(1,19); (*(M2[129]))[298] = M1(1,24); (*(M2[129]))[299] = M1(1,25); (*(M2[129]))[302] = M1(1,26); (*(M2[129]))[317] = M1(1,27); 
(*(M2[130]))[119] = M1(2,2); (*(M2[130]))[123] = M1(2,4); (*(M2[130]))[124] = M1(2,5); (*(M2[130]))[125] = M1(2,6); (*(M2[130]))[128] = M1(2,7); (*(M2[130]))[129] = M1(2,8); (*(M2[130]))[132] = M1(2,9); (*(M2[130]))[149] = M1(2,10); (*(M2[130]))[150] = M1(2,11); (*(M2[130]))[151] = M1(2,12); (*(M2[130]))[154] = M1(2,13); (*(M2[130]))[155] = M1(2,14); (*(M2[130]))[158] = M1(2,15); (*(M2[130]))[173] = M1(2,16); (*(M2[130]))[174] = M1(2,17); (*(M2[130]))[177] = M1(2,18); (*(M2[130]))[190] = M1(2,19); (*(M2[130]))[298] = M1(2,24); (*(M2[130]))[299] = M1(2,25); (*(M2[130]))[302] = M1(2,26); (*(M2[130]))[317] = M1(2,27); 
(*(M2[131]))[120] = M1(3,3); (*(M2[131]))[123] = M1(3,4); (*(M2[131]))[124] = M1(3,5); (*(M2[131]))[125] = M1(3,6); (*(M2[131]))[128] = M1(3,7); (*(M2[131]))[129] = M1(3,8); (*(M2[131]))[132] = M1(3,9); (*(M2[131]))[149] = M1(3,10); (*(M2[131]))[150] = M1(3,11); (*(M2[131]))[151] = M1(3,12); (*(M2[131]))[154] = M1(3,13); (*(M2[131]))[155] = M1(3,14); (*(M2[131]))[158] = M1(3,15); (*(M2[131]))[173] = M1(3,16); (*(M2[131]))[174] = M1(3,17); (*(M2[131]))[177] = M1(3,18); (*(M2[131]))[190] = M1(3,19); (*(M2[131]))[298] = M1(3,24); (*(M2[131]))[299] = M1(3,25); (*(M2[131]))[302] = M1(3,26); (*(M2[131]))[317] = M1(3,27); 
(*(M2[132]))[137] = M1(0,0); (*(M2[132]))[144] = M1(0,4); (*(M2[132]))[145] = M1(0,5); (*(M2[132]))[146] = M1(0,6); (*(M2[132]))[150] = M1(0,7); (*(M2[132]))[151] = M1(0,8); (*(M2[132]))[155] = M1(0,9); (*(M2[132]))[163] = M1(0,10); (*(M2[132]))[164] = M1(0,11); (*(M2[132]))[165] = M1(0,12); (*(M2[132]))[169] = M1(0,13); (*(M2[132]))[170] = M1(0,14); (*(M2[132]))[174] = M1(0,15); (*(M2[132]))[182] = M1(0,16); (*(M2[132]))[183] = M1(0,17); (*(M2[132]))[187] = M1(0,18); (*(M2[132]))[195] = M1(0,19); (*(M2[132]))[309] = M1(0,24); (*(M2[132]))[310] = M1(0,25); (*(M2[132]))[314] = M1(0,26); (*(M2[132]))[324] = M1(0,27); 
(*(M2[133]))[138] = M1(1,1); (*(M2[133]))[144] = M1(1,4); (*(M2[133]))[145] = M1(1,5); (*(M2[133]))[146] = M1(1,6); (*(M2[133]))[150] = M1(1,7); (*(M2[133]))[151] = M1(1,8); (*(M2[133]))[155] = M1(1,9); (*(M2[133]))[163] = M1(1,10); (*(M2[133]))[164] = M1(1,11); (*(M2[133]))[165] = M1(1,12); (*(M2[133]))[169] = M1(1,13); (*(M2[133]))[170] = M1(1,14); (*(M2[133]))[174] = M1(1,15); (*(M2[133]))[182] = M1(1,16); (*(M2[133]))[183] = M1(1,17); (*(M2[133]))[187] = M1(1,18); (*(M2[133]))[195] = M1(1,19); (*(M2[133]))[309] = M1(1,24); (*(M2[133]))[310] = M1(1,25); (*(M2[133]))[314] = M1(1,26); (*(M2[133]))[324] = M1(1,27); 
(*(M2[134]))[139] = M1(2,2); (*(M2[134]))[144] = M1(2,4); (*(M2[134]))[145] = M1(2,5); (*(M2[134]))[146] = M1(2,6); (*(M2[134]))[150] = M1(2,7); (*(M2[134]))[151] = M1(2,8); (*(M2[134]))[155] = M1(2,9); (*(M2[134]))[163] = M1(2,10); (*(M2[134]))[164] = M1(2,11); (*(M2[134]))[165] = M1(2,12); (*(M2[134]))[169] = M1(2,13); (*(M2[134]))[170] = M1(2,14); (*(M2[134]))[174] = M1(2,15); (*(M2[134]))[182] = M1(2,16); (*(M2[134]))[183] = M1(2,17); (*(M2[134]))[187] = M1(2,18); (*(M2[134]))[195] = M1(2,19); (*(M2[134]))[309] = M1(2,24); (*(M2[134]))[310] = M1(2,25); (*(M2[134]))[314] = M1(2,26); (*(M2[134]))[324] = M1(2,27); 
(*(M2[135]))[140] = M1(3,3); (*(M2[135]))[144] = M1(3,4); (*(M2[135]))[145] = M1(3,5); (*(M2[135]))[146] = M1(3,6); (*(M2[135]))[150] = M1(3,7); (*(M2[135]))[151] = M1(3,8); (*(M2[135]))[155] = M1(3,9); (*(M2[135]))[163] = M1(3,10); (*(M2[135]))[164] = M1(3,11); (*(M2[135]))[165] = M1(3,12); (*(M2[135]))[169] = M1(3,13); (*(M2[135]))[170] = M1(3,14); (*(M2[135]))[174] = M1(3,15); (*(M2[135]))[182] = M1(3,16); (*(M2[135]))[183] = M1(3,17); (*(M2[135]))[187] = M1(3,18); (*(M2[135]))[195] = M1(3,19); (*(M2[135]))[309] = M1(3,24); (*(M2[135]))[310] = M1(3,25); (*(M2[135]))[314] = M1(3,26); (*(M2[135]))[324] = M1(3,27); 
(*(M2[136]))[234] = M1(4,20); (*(M2[136]))[236] = M1(4,21); (*(M2[136]))[245] = M1(4,22); (*(M2[136]))[270] = M1(4,23); (*(M2[136]))[359] = M1(4,28); 
(*(M2[137]))[111] = M1(0,0); (*(M2[137]))[118] = M1(0,4); (*(M2[137]))[119] = M1(0,5); (*(M2[137]))[120] = M1(0,6); (*(M2[137]))[124] = M1(0,7); (*(M2[137]))[125] = M1(0,8); (*(M2[137]))[129] = M1(0,9); (*(M2[137]))[144] = M1(0,10); (*(M2[137]))[145] = M1(0,11); (*(M2[137]))[146] = M1(0,12); (*(M2[137]))[150] = M1(0,13); (*(M2[137]))[151] = M1(0,14); (*(M2[137]))[155] = M1(0,15); (*(M2[137]))[169] = M1(0,16); (*(M2[137]))[170] = M1(0,17); (*(M2[137]))[174] = M1(0,18); (*(M2[137]))[187] = M1(0,19); (*(M2[137]))[294] = M1(0,24); (*(M2[137]))[295] = M1(0,25); (*(M2[137]))[299] = M1(0,26); (*(M2[137]))[314] = M1(0,27); 
(*(M2[138]))[112] = M1(1,1); (*(M2[138]))[118] = M1(1,4); (*(M2[138]))[119] = M1(1,5); (*(M2[138]))[120] = M1(1,6); (*(M2[138]))[124] = M1(1,7); (*(M2[138]))[125] = M1(1,8); (*(M2[138]))[129] = M1(1,9); (*(M2[138]))[144] = M1(1,10); (*(M2[138]))[145] = M1(1,11); (*(M2[138]))[146] = M1(1,12); (*(M2[138]))[150] = M1(1,13); (*(M2[138]))[151] = M1(1,14); (*(M2[138]))[155] = M1(1,15); (*(M2[138]))[169] = M1(1,16); (*(M2[138]))[170] = M1(1,17); (*(M2[138]))[174] = M1(1,18); (*(M2[138]))[187] = M1(1,19); (*(M2[138]))[294] = M1(1,24); (*(M2[138]))[295] = M1(1,25); (*(M2[138]))[299] = M1(1,26); (*(M2[138]))[314] = M1(1,27); 
(*(M2[139]))[113] = M1(2,2); (*(M2[139]))[118] = M1(2,4); (*(M2[139]))[119] = M1(2,5); (*(M2[139]))[120] = M1(2,6); (*(M2[139]))[124] = M1(2,7); (*(M2[139]))[125] = M1(2,8); (*(M2[139]))[129] = M1(2,9); (*(M2[139]))[144] = M1(2,10); (*(M2[139]))[145] = M1(2,11); (*(M2[139]))[146] = M1(2,12); (*(M2[139]))[150] = M1(2,13); (*(M2[139]))[151] = M1(2,14); (*(M2[139]))[155] = M1(2,15); (*(M2[139]))[169] = M1(2,16); (*(M2[139]))[170] = M1(2,17); (*(M2[139]))[174] = M1(2,18); (*(M2[139]))[187] = M1(2,19); (*(M2[139]))[294] = M1(2,24); (*(M2[139]))[295] = M1(2,25); (*(M2[139]))[299] = M1(2,26); (*(M2[139]))[314] = M1(2,27); 
(*(M2[140]))[114] = M1(3,3); (*(M2[140]))[118] = M1(3,4); (*(M2[140]))[119] = M1(3,5); (*(M2[140]))[120] = M1(3,6); (*(M2[140]))[124] = M1(3,7); (*(M2[140]))[125] = M1(3,8); (*(M2[140]))[129] = M1(3,9); (*(M2[140]))[144] = M1(3,10); (*(M2[140]))[145] = M1(3,11); (*(M2[140]))[146] = M1(3,12); (*(M2[140]))[150] = M1(3,13); (*(M2[140]))[151] = M1(3,14); (*(M2[140]))[155] = M1(3,15); (*(M2[140]))[169] = M1(3,16); (*(M2[140]))[170] = M1(3,17); (*(M2[140]))[174] = M1(3,18); (*(M2[140]))[187] = M1(3,19); (*(M2[140]))[294] = M1(3,24); (*(M2[140]))[295] = M1(3,25); (*(M2[140]))[299] = M1(3,26); (*(M2[140]))[314] = M1(3,27); 
(*(M2[141]))[213] = M1(4,20); (*(M2[141]))[215] = M1(4,21); (*(M2[141]))[224] = M1(4,22); (*(M2[141]))[260] = M1(4,23); (*(M2[141]))[349] = M1(4,28); 
(*(M2[142]))[105] = M1(0,0); (*(M2[142]))[112] = M1(0,4); (*(M2[142]))[113] = M1(0,5); (*(M2[142]))[114] = M1(0,6); (*(M2[142]))[119] = M1(0,7); (*(M2[142]))[120] = M1(0,8); (*(M2[142]))[125] = M1(0,9); (*(M2[142]))[138] = M1(0,10); (*(M2[142]))[139] = M1(0,11); (*(M2[142]))[140] = M1(0,12); (*(M2[142]))[145] = M1(0,13); (*(M2[142]))[146] = M1(0,14); (*(M2[142]))[151] = M1(0,15); (*(M2[142]))[164] = M1(0,16); (*(M2[142]))[165] = M1(0,17); (*(M2[142]))[170] = M1(0,18); (*(M2[142]))[183] = M1(0,19); (*(M2[142]))[289] = M1(0,24); (*(M2[142]))[290] = M1(0,25); (*(M2[142]))[295] = M1(0,26); (*(M2[142]))[310] = M1(0,27); 
(*(M2[143]))[106] = M1(1,1); (*(M2[143]))[112] = M1(1,4); (*(M2[143]))[113] = M1(1,5); (*(M2[143]))[114] = M1(1,6); (*(M2[143]))[119] = M1(1,7); (*(M2[143]))[120] = M1(1,8); (*(M2[143]))[125] = M1(1,9); (*(M2[143]))[138] = M1(1,10); (*(M2[143]))[139] = M1(1,11); (*(M2[143]))[140] = M1(1,12); (*(M2[143]))[145] = M1(1,13); (*(M2[143]))[146] = M1(1,14); (*(M2[143]))[151] = M1(1,15); (*(M2[143]))[164] = M1(1,16); (*(M2[143]))[165] = M1(1,17); (*(M2[143]))[170] = M1(1,18); (*(M2[143]))[183] = M1(1,19); (*(M2[143]))[289] = M1(1,24); (*(M2[143]))[290] = M1(1,25); (*(M2[143]))[295] = M1(1,26); (*(M2[143]))[310] = M1(1,27); 
(*(M2[144]))[107] = M1(2,2); (*(M2[144]))[112] = M1(2,4); (*(M2[144]))[113] = M1(2,5); (*(M2[144]))[114] = M1(2,6); (*(M2[144]))[119] = M1(2,7); (*(M2[144]))[120] = M1(2,8); (*(M2[144]))[125] = M1(2,9); (*(M2[144]))[138] = M1(2,10); (*(M2[144]))[139] = M1(2,11); (*(M2[144]))[140] = M1(2,12); (*(M2[144]))[145] = M1(2,13); (*(M2[144]))[146] = M1(2,14); (*(M2[144]))[151] = M1(2,15); (*(M2[144]))[164] = M1(2,16); (*(M2[144]))[165] = M1(2,17); (*(M2[144]))[170] = M1(2,18); (*(M2[144]))[183] = M1(2,19); (*(M2[144]))[289] = M1(2,24); (*(M2[144]))[290] = M1(2,25); (*(M2[144]))[295] = M1(2,26); (*(M2[144]))[310] = M1(2,27); 
(*(M2[145]))[207] = M1(4,20); (*(M2[145]))[209] = M1(4,21); (*(M2[145]))[220] = M1(4,22); (*(M2[145]))[256] = M1(4,23); (*(M2[145]))[345] = M1(4,28); 
(*(M2[146]))[148] = M1(1,1); (*(M2[146]))[152] = M1(1,4); (*(M2[146]))[153] = M1(1,5); (*(M2[146]))[154] = M1(1,6); (*(M2[146]))[156] = M1(1,7); (*(M2[146]))[157] = M1(1,8); (*(M2[146]))[159] = M1(1,9); (*(M2[146]))[171] = M1(1,10); (*(M2[146]))[172] = M1(1,11); (*(M2[146]))[173] = M1(1,12); (*(M2[146]))[175] = M1(1,13); (*(M2[146]))[176] = M1(1,14); (*(M2[146]))[178] = M1(1,15); (*(M2[146]))[188] = M1(1,16); (*(M2[146]))[189] = M1(1,17); (*(M2[146]))[191] = M1(1,18); (*(M2[146]))[199] = M1(1,19); (*(M2[146]))[315] = M1(1,24); (*(M2[146]))[316] = M1(1,25); (*(M2[146]))[318] = M1(1,26); (*(M2[146]))[328] = M1(1,27); 
(*(M2[147]))[149] = M1(2,2); (*(M2[147]))[152] = M1(2,4); (*(M2[147]))[153] = M1(2,5); (*(M2[147]))[154] = M1(2,6); (*(M2[147]))[156] = M1(2,7); (*(M2[147]))[157] = M1(2,8); (*(M2[147]))[159] = M1(2,9); (*(M2[147]))[171] = M1(2,10); (*(M2[147]))[172] = M1(2,11); (*(M2[147]))[173] = M1(2,12); (*(M2[147]))[175] = M1(2,13); (*(M2[147]))[176] = M1(2,14); (*(M2[147]))[178] = M1(2,15); (*(M2[147]))[188] = M1(2,16); (*(M2[147]))[189] = M1(2,17); (*(M2[147]))[191] = M1(2,18); (*(M2[147]))[199] = M1(2,19); (*(M2[147]))[315] = M1(2,24); (*(M2[147]))[316] = M1(2,25); (*(M2[147]))[318] = M1(2,26); (*(M2[147]))[328] = M1(2,27); 
(*(M2[148]))[150] = M1(3,3); (*(M2[148]))[152] = M1(3,4); (*(M2[148]))[153] = M1(3,5); (*(M2[148]))[154] = M1(3,6); (*(M2[148]))[156] = M1(3,7); (*(M2[148]))[157] = M1(3,8); (*(M2[148]))[159] = M1(3,9); (*(M2[148]))[171] = M1(3,10); (*(M2[148]))[172] = M1(3,11); (*(M2[148]))[173] = M1(3,12); (*(M2[148]))[175] = M1(3,13); (*(M2[148]))[176] = M1(3,14); (*(M2[148]))[178] = M1(3,15); (*(M2[148]))[188] = M1(3,16); (*(M2[148]))[189] = M1(3,17); (*(M2[148]))[191] = M1(3,18); (*(M2[148]))[199] = M1(3,19); (*(M2[148]))[315] = M1(3,24); (*(M2[148]))[316] = M1(3,25); (*(M2[148]))[318] = M1(3,26); (*(M2[148]))[328] = M1(3,27); 
(*(M2[149]))[121] = M1(0,0); (*(M2[149]))[126] = M1(0,4); (*(M2[149]))[127] = M1(0,5); (*(M2[149]))[128] = M1(0,6); (*(M2[149]))[130] = M1(0,7); (*(M2[149]))[131] = M1(0,8); (*(M2[149]))[133] = M1(0,9); (*(M2[149]))[152] = M1(0,10); (*(M2[149]))[153] = M1(0,11); (*(M2[149]))[154] = M1(0,12); (*(M2[149]))[156] = M1(0,13); (*(M2[149]))[157] = M1(0,14); (*(M2[149]))[159] = M1(0,15); (*(M2[149]))[175] = M1(0,16); (*(M2[149]))[176] = M1(0,17); (*(M2[149]))[178] = M1(0,18); (*(M2[149]))[191] = M1(0,19); (*(M2[149]))[300] = M1(0,24); (*(M2[149]))[301] = M1(0,25); (*(M2[149]))[303] = M1(0,26); (*(M2[149]))[318] = M1(0,27); 
(*(M2[150]))[122] = M1(1,1); (*(M2[150]))[126] = M1(1,4); (*(M2[150]))[127] = M1(1,5); (*(M2[150]))[128] = M1(1,6); (*(M2[150]))[130] = M1(1,7); (*(M2[150]))[131] = M1(1,8); (*(M2[150]))[133] = M1(1,9); (*(M2[150]))[152] = M1(1,10); (*(M2[150]))[153] = M1(1,11); (*(M2[150]))[154] = M1(1,12); (*(M2[150]))[156] = M1(1,13); (*(M2[150]))[157] = M1(1,14); (*(M2[150]))[159] = M1(1,15); (*(M2[150]))[175] = M1(1,16); (*(M2[150]))[176] = M1(1,17); (*(M2[150]))[178] = M1(1,18); (*(M2[150]))[191] = M1(1,19); (*(M2[150]))[300] = M1(1,24); (*(M2[150]))[301] = M1(1,25); (*(M2[150]))[303] = M1(1,26); (*(M2[150]))[318] = M1(1,27); 
(*(M2[151]))[123] = M1(2,2); (*(M2[151]))[126] = M1(2,4); (*(M2[151]))[127] = M1(2,5); (*(M2[151]))[128] = M1(2,6); (*(M2[151]))[130] = M1(2,7); (*(M2[151]))[131] = M1(2,8); (*(M2[151]))[133] = M1(2,9); (*(M2[151]))[152] = M1(2,10); (*(M2[151]))[153] = M1(2,11); (*(M2[151]))[154] = M1(2,12); (*(M2[151]))[156] = M1(2,13); (*(M2[151]))[157] = M1(2,14); (*(M2[151]))[159] = M1(2,15); (*(M2[151]))[175] = M1(2,16); (*(M2[151]))[176] = M1(2,17); (*(M2[151]))[178] = M1(2,18); (*(M2[151]))[191] = M1(2,19); (*(M2[151]))[300] = M1(2,24); (*(M2[151]))[301] = M1(2,25); (*(M2[151]))[303] = M1(2,26); (*(M2[151]))[318] = M1(2,27); 
(*(M2[152]))[124] = M1(3,3); (*(M2[152]))[126] = M1(3,4); (*(M2[152]))[127] = M1(3,5); (*(M2[152]))[128] = M1(3,6); (*(M2[152]))[130] = M1(3,7); (*(M2[152]))[131] = M1(3,8); (*(M2[152]))[133] = M1(3,9); (*(M2[152]))[152] = M1(3,10); (*(M2[152]))[153] = M1(3,11); (*(M2[152]))[154] = M1(3,12); (*(M2[152]))[156] = M1(3,13); (*(M2[152]))[157] = M1(3,14); (*(M2[152]))[159] = M1(3,15); (*(M2[152]))[175] = M1(3,16); (*(M2[152]))[176] = M1(3,17); (*(M2[152]))[178] = M1(3,18); (*(M2[152]))[191] = M1(3,19); (*(M2[152]))[300] = M1(3,24); (*(M2[152]))[301] = M1(3,25); (*(M2[152]))[303] = M1(3,26); (*(M2[152]))[318] = M1(3,27); 
(*(M2[153]))[161] = M1(0,0); (*(M2[153]))[167] = M1(0,4); (*(M2[153]))[168] = M1(0,5); (*(M2[153]))[169] = M1(0,6); (*(M2[153]))[172] = M1(0,7); (*(M2[153]))[173] = M1(0,8); (*(M2[153]))[176] = M1(0,9); (*(M2[153]))[180] = M1(0,10); (*(M2[153]))[181] = M1(0,11); (*(M2[153]))[182] = M1(0,12); (*(M2[153]))[185] = M1(0,13); (*(M2[153]))[186] = M1(0,14); (*(M2[153]))[189] = M1(0,15); (*(M2[153]))[193] = M1(0,16); (*(M2[153]))[194] = M1(0,17); (*(M2[153]))[197] = M1(0,18); (*(M2[153]))[201] = M1(0,19); (*(M2[153]))[322] = M1(0,24); (*(M2[153]))[323] = M1(0,25); (*(M2[153]))[326] = M1(0,26); (*(M2[153]))[332] = M1(0,27); 
(*(M2[154]))[162] = M1(1,1); (*(M2[154]))[167] = M1(1,4); (*(M2[154]))[168] = M1(1,5); (*(M2[154]))[169] = M1(1,6); (*(M2[154]))[172] = M1(1,7); (*(M2[154]))[173] = M1(1,8); (*(M2[154]))[176] = M1(1,9); (*(M2[154]))[180] = M1(1,10); (*(M2[154]))[181] = M1(1,11); (*(M2[154]))[182] = M1(1,12); (*(M2[154]))[185] = M1(1,13); (*(M2[154]))[186] = M1(1,14); (*(M2[154]))[189] = M1(1,15); (*(M2[154]))[193] = M1(1,16); (*(M2[154]))[194] = M1(1,17); (*(M2[154]))[197] = M1(1,18); (*(M2[154]))[201] = M1(1,19); (*(M2[154]))[322] = M1(1,24); (*(M2[154]))[323] = M1(1,25); (*(M2[154]))[326] = M1(1,26); (*(M2[154]))[332] = M1(1,27); 
(*(M2[155]))[163] = M1(2,2); (*(M2[155]))[167] = M1(2,4); (*(M2[155]))[168] = M1(2,5); (*(M2[155]))[169] = M1(2,6); (*(M2[155]))[172] = M1(2,7); (*(M2[155]))[173] = M1(2,8); (*(M2[155]))[176] = M1(2,9); (*(M2[155]))[180] = M1(2,10); (*(M2[155]))[181] = M1(2,11); (*(M2[155]))[182] = M1(2,12); (*(M2[155]))[185] = M1(2,13); (*(M2[155]))[186] = M1(2,14); (*(M2[155]))[189] = M1(2,15); (*(M2[155]))[193] = M1(2,16); (*(M2[155]))[194] = M1(2,17); (*(M2[155]))[197] = M1(2,18); (*(M2[155]))[201] = M1(2,19); (*(M2[155]))[322] = M1(2,24); (*(M2[155]))[323] = M1(2,25); (*(M2[155]))[326] = M1(2,26); (*(M2[155]))[332] = M1(2,27); 
(*(M2[156]))[164] = M1(3,3); (*(M2[156]))[167] = M1(3,4); (*(M2[156]))[168] = M1(3,5); (*(M2[156]))[169] = M1(3,6); (*(M2[156]))[172] = M1(3,7); (*(M2[156]))[173] = M1(3,8); (*(M2[156]))[176] = M1(3,9); (*(M2[156]))[180] = M1(3,10); (*(M2[156]))[181] = M1(3,11); (*(M2[156]))[182] = M1(3,12); (*(M2[156]))[185] = M1(3,13); (*(M2[156]))[186] = M1(3,14); (*(M2[156]))[189] = M1(3,15); (*(M2[156]))[193] = M1(3,16); (*(M2[156]))[194] = M1(3,17); (*(M2[156]))[197] = M1(3,18); (*(M2[156]))[201] = M1(3,19); (*(M2[156]))[322] = M1(3,24); (*(M2[156]))[323] = M1(3,25); (*(M2[156]))[326] = M1(3,26); (*(M2[156]))[332] = M1(3,27); 
(*(M2[157]))[253] = M1(4,20); (*(M2[157]))[255] = M1(4,21); (*(M2[157]))[262] = M1(4,22); (*(M2[157]))[278] = M1(4,23); (*(M2[157]))[367] = M1(4,28); 
(*(M2[158]))[142] = M1(0,0); (*(M2[158]))[148] = M1(0,4); (*(M2[158]))[149] = M1(0,5); (*(M2[158]))[150] = M1(0,6); (*(M2[158]))[153] = M1(0,7); (*(M2[158]))[154] = M1(0,8); (*(M2[158]))[157] = M1(0,9); (*(M2[158]))[167] = M1(0,10); (*(M2[158]))[168] = M1(0,11); (*(M2[158]))[169] = M1(0,12); (*(M2[158]))[172] = M1(0,13); (*(M2[158]))[173] = M1(0,14); (*(M2[158]))[176] = M1(0,15); (*(M2[158]))[185] = M1(0,16); (*(M2[158]))[186] = M1(0,17); (*(M2[158]))[189] = M1(0,18); (*(M2[158]))[197] = M1(0,19); (*(M2[158]))[312] = M1(0,24); (*(M2[158]))[313] = M1(0,25); (*(M2[158]))[316] = M1(0,26); (*(M2[158]))[326] = M1(0,27); 
(*(M2[159]))[143] = M1(1,1); (*(M2[159]))[148] = M1(1,4); (*(M2[159]))[149] = M1(1,5); (*(M2[159]))[150] = M1(1,6); (*(M2[159]))[153] = M1(1,7); (*(M2[159]))[154] = M1(1,8); (*(M2[159]))[157] = M1(1,9); (*(M2[159]))[167] = M1(1,10); (*(M2[159]))[168] = M1(1,11); (*(M2[159]))[169] = M1(1,12); (*(M2[159]))[172] = M1(1,13); (*(M2[159]))[173] = M1(1,14); (*(M2[159]))[176] = M1(1,15); (*(M2[159]))[185] = M1(1,16); (*(M2[159]))[186] = M1(1,17); (*(M2[159]))[189] = M1(1,18); (*(M2[159]))[197] = M1(1,19); (*(M2[159]))[312] = M1(1,24); (*(M2[159]))[313] = M1(1,25); (*(M2[159]))[316] = M1(1,26); (*(M2[159]))[326] = M1(1,27); 
(*(M2[160]))[144] = M1(2,2); (*(M2[160]))[148] = M1(2,4); (*(M2[160]))[149] = M1(2,5); (*(M2[160]))[150] = M1(2,6); (*(M2[160]))[153] = M1(2,7); (*(M2[160]))[154] = M1(2,8); (*(M2[160]))[157] = M1(2,9); (*(M2[160]))[167] = M1(2,10); (*(M2[160]))[168] = M1(2,11); (*(M2[160]))[169] = M1(2,12); (*(M2[160]))[172] = M1(2,13); (*(M2[160]))[173] = M1(2,14); (*(M2[160]))[176] = M1(2,15); (*(M2[160]))[185] = M1(2,16); (*(M2[160]))[186] = M1(2,17); (*(M2[160]))[189] = M1(2,18); (*(M2[160]))[197] = M1(2,19); (*(M2[160]))[312] = M1(2,24); (*(M2[160]))[313] = M1(2,25); (*(M2[160]))[316] = M1(2,26); (*(M2[160]))[326] = M1(2,27); 
(*(M2[161]))[145] = M1(3,3); (*(M2[161]))[148] = M1(3,4); (*(M2[161]))[149] = M1(3,5); (*(M2[161]))[150] = M1(3,6); (*(M2[161]))[153] = M1(3,7); (*(M2[161]))[154] = M1(3,8); (*(M2[161]))[157] = M1(3,9); (*(M2[161]))[167] = M1(3,10); (*(M2[161]))[168] = M1(3,11); (*(M2[161]))[169] = M1(3,12); (*(M2[161]))[172] = M1(3,13); (*(M2[161]))[173] = M1(3,14); (*(M2[161]))[176] = M1(3,15); (*(M2[161]))[185] = M1(3,16); (*(M2[161]))[186] = M1(3,17); (*(M2[161]))[189] = M1(3,18); (*(M2[161]))[197] = M1(3,19); (*(M2[161]))[312] = M1(3,24); (*(M2[161]))[313] = M1(3,25); (*(M2[161]))[316] = M1(3,26); (*(M2[161]))[326] = M1(3,27); 
(*(M2[162]))[238] = M1(4,20); (*(M2[162]))[240] = M1(4,21); (*(M2[162]))[247] = M1(4,22); (*(M2[162]))[272] = M1(4,23); (*(M2[162]))[361] = M1(4,28); 
(*(M2[163]))[116] = M1(0,0); (*(M2[163]))[122] = M1(0,4); (*(M2[163]))[123] = M1(0,5); (*(M2[163]))[124] = M1(0,6); (*(M2[163]))[127] = M1(0,7); (*(M2[163]))[128] = M1(0,8); (*(M2[163]))[131] = M1(0,9); (*(M2[163]))[148] = M1(0,10); (*(M2[163]))[149] = M1(0,11); (*(M2[163]))[150] = M1(0,12); (*(M2[163]))[153] = M1(0,13); (*(M2[163]))[154] = M1(0,14); (*(M2[163]))[157] = M1(0,15); (*(M2[163]))[172] = M1(0,16); (*(M2[163]))[173] = M1(0,17); (*(M2[163]))[176] = M1(0,18); (*(M2[163]))[189] = M1(0,19); (*(M2[163]))[297] = M1(0,24); (*(M2[163]))[298] = M1(0,25); (*(M2[163]))[301] = M1(0,26); (*(M2[163]))[316] = M1(0,27); 
(*(M2[164]))[117] = M1(1,1); (*(M2[164]))[122] = M1(1,4); (*(M2[164]))[123] = M1(1,5); (*(M2[164]))[124] = M1(1,6); (*(M2[164]))[127] = M1(1,7); (*(M2[164]))[128] = M1(1,8); (*(M2[164]))[131] = M1(1,9); (*(M2[164]))[148] = M1(1,10); (*(M2[164]))[149] = M1(1,11); (*(M2[164]))[150] = M1(1,12); (*(M2[164]))[153] = M1(1,13); (*(M2[164]))[154] = M1(1,14); (*(M2[164]))[157] = M1(1,15); (*(M2[164]))[172] = M1(1,16); (*(M2[164]))[173] = M1(1,17); (*(M2[164]))[176] = M1(1,18); (*(M2[164]))[189] = M1(1,19); (*(M2[164]))[297] = M1(1,24); (*(M2[164]))[298] = M1(1,25); (*(M2[164]))[301] = M1(1,26); (*(M2[164]))[316] = M1(1,27); 
(*(M2[165]))[118] = M1(2,2); (*(M2[165]))[122] = M1(2,4); (*(M2[165]))[123] = M1(2,5); (*(M2[165]))[124] = M1(2,6); (*(M2[165]))[127] = M1(2,7); (*(M2[165]))[128] = M1(2,8); (*(M2[165]))[131] = M1(2,9); (*(M2[165]))[148] = M1(2,10); (*(M2[165]))[149] = M1(2,11); (*(M2[165]))[150] = M1(2,12); (*(M2[165]))[153] = M1(2,13); (*(M2[165]))[154] = M1(2,14); (*(M2[165]))[157] = M1(2,15); (*(M2[165]))[172] = M1(2,16); (*(M2[165]))[173] = M1(2,17); (*(M2[165]))[176] = M1(2,18); (*(M2[165]))[189] = M1(2,19); (*(M2[165]))[297] = M1(2,24); (*(M2[165]))[298] = M1(2,25); (*(M2[165]))[301] = M1(2,26); (*(M2[165]))[316] = M1(2,27); 
(*(M2[166]))[119] = M1(3,3); (*(M2[166]))[122] = M1(3,4); (*(M2[166]))[123] = M1(3,5); (*(M2[166]))[124] = M1(3,6); (*(M2[166]))[127] = M1(3,7); (*(M2[166]))[128] = M1(3,8); (*(M2[166]))[131] = M1(3,9); (*(M2[166]))[148] = M1(3,10); (*(M2[166]))[149] = M1(3,11); (*(M2[166]))[150] = M1(3,12); (*(M2[166]))[153] = M1(3,13); (*(M2[166]))[154] = M1(3,14); (*(M2[166]))[157] = M1(3,15); (*(M2[166]))[172] = M1(3,16); (*(M2[166]))[173] = M1(3,17); (*(M2[166]))[176] = M1(3,18); (*(M2[166]))[189] = M1(3,19); (*(M2[166]))[297] = M1(3,24); (*(M2[166]))[298] = M1(3,25); (*(M2[166]))[301] = M1(3,26); (*(M2[166]))[316] = M1(3,27); 
(*(M2[167]))[217] = M1(4,20); (*(M2[167]))[219] = M1(4,21); (*(M2[167]))[226] = M1(4,22); (*(M2[167]))[262] = M1(4,23); (*(M2[167]))[351] = M1(4,28); 
(*(M2[168]))[136] = M1(0,0); (*(M2[168]))[143] = M1(0,4); (*(M2[168]))[144] = M1(0,5); (*(M2[168]))[145] = M1(0,6); (*(M2[168]))[149] = M1(0,7); (*(M2[168]))[150] = M1(0,8); (*(M2[168]))[154] = M1(0,9); (*(M2[168]))[162] = M1(0,10); (*(M2[168]))[163] = M1(0,11); (*(M2[168]))[164] = M1(0,12); (*(M2[168]))[168] = M1(0,13); (*(M2[168]))[169] = M1(0,14); (*(M2[168]))[173] = M1(0,15); (*(M2[168]))[181] = M1(0,16); (*(M2[168]))[182] = M1(0,17); (*(M2[168]))[186] = M1(0,18); (*(M2[168]))[194] = M1(0,19); (*(M2[168]))[308] = M1(0,24); (*(M2[168]))[309] = M1(0,25); (*(M2[168]))[313] = M1(0,26); (*(M2[168]))[323] = M1(0,27); 
(*(M2[169]))[137] = M1(1,1); (*(M2[169]))[143] = M1(1,4); (*(M2[169]))[144] = M1(1,5); (*(M2[169]))[145] = M1(1,6); (*(M2[169]))[149] = M1(1,7); (*(M2[169]))[150] = M1(1,8); (*(M2[169]))[154] = M1(1,9); (*(M2[169]))[162] = M1(1,10); (*(M2[169]))[163] = M1(1,11); (*(M2[169]))[164] = M1(1,12); (*(M2[169]))[168] = M1(1,13); (*(M2[169]))[169] = M1(1,14); (*(M2[169]))[173] = M1(1,15); (*(M2[169]))[181] = M1(1,16); (*(M2[169]))[182] = M1(1,17); (*(M2[169]))[186] = M1(1,18); (*(M2[169]))[194] = M1(1,19); (*(M2[169]))[308] = M1(1,24); (*(M2[169]))[309] = M1(1,25); (*(M2[169]))[313] = M1(1,26); (*(M2[169]))[323] = M1(1,27); 
(*(M2[170]))[138] = M1(2,2); (*(M2[170]))[143] = M1(2,4); (*(M2[170]))[144] = M1(2,5); (*(M2[170]))[145] = M1(2,6); (*(M2[170]))[149] = M1(2,7); (*(M2[170]))[150] = M1(2,8); (*(M2[170]))[154] = M1(2,9); (*(M2[170]))[162] = M1(2,10); (*(M2[170]))[163] = M1(2,11); (*(M2[170]))[164] = M1(2,12); (*(M2[170]))[168] = M1(2,13); (*(M2[170]))[169] = M1(2,14); (*(M2[170]))[173] = M1(2,15); (*(M2[170]))[181] = M1(2,16); (*(M2[170]))[182] = M1(2,17); (*(M2[170]))[186] = M1(2,18); (*(M2[170]))[194] = M1(2,19); (*(M2[170]))[308] = M1(2,24); (*(M2[170]))[309] = M1(2,25); (*(M2[170]))[313] = M1(2,26); (*(M2[170]))[323] = M1(2,27); 
(*(M2[171]))[139] = M1(3,3); (*(M2[171]))[143] = M1(3,4); (*(M2[171]))[144] = M1(3,5); (*(M2[171]))[145] = M1(3,6); (*(M2[171]))[149] = M1(3,7); (*(M2[171]))[150] = M1(3,8); (*(M2[171]))[154] = M1(3,9); (*(M2[171]))[162] = M1(3,10); (*(M2[171]))[163] = M1(3,11); (*(M2[171]))[164] = M1(3,12); (*(M2[171]))[168] = M1(3,13); (*(M2[171]))[169] = M1(3,14); (*(M2[171]))[173] = M1(3,15); (*(M2[171]))[181] = M1(3,16); (*(M2[171]))[182] = M1(3,17); (*(M2[171]))[186] = M1(3,18); (*(M2[171]))[194] = M1(3,19); (*(M2[171]))[308] = M1(3,24); (*(M2[171]))[309] = M1(3,25); (*(M2[171]))[313] = M1(3,26); (*(M2[171]))[323] = M1(3,27); 
(*(M2[172]))[233] = M1(4,20); (*(M2[172]))[235] = M1(4,21); (*(M2[172]))[244] = M1(4,22); (*(M2[172]))[269] = M1(4,23); (*(M2[172]))[358] = M1(4,28); 
(*(M2[173]))[110] = M1(0,0); (*(M2[173]))[117] = M1(0,4); (*(M2[173]))[118] = M1(0,5); (*(M2[173]))[119] = M1(0,6); (*(M2[173]))[123] = M1(0,7); (*(M2[173]))[124] = M1(0,8); (*(M2[173]))[128] = M1(0,9); (*(M2[173]))[143] = M1(0,10); (*(M2[173]))[144] = M1(0,11); (*(M2[173]))[145] = M1(0,12); (*(M2[173]))[149] = M1(0,13); (*(M2[173]))[150] = M1(0,14); (*(M2[173]))[154] = M1(0,15); (*(M2[173]))[168] = M1(0,16); (*(M2[173]))[169] = M1(0,17); (*(M2[173]))[173] = M1(0,18); (*(M2[173]))[186] = M1(0,19); (*(M2[173]))[293] = M1(0,24); (*(M2[173]))[294] = M1(0,25); (*(M2[173]))[298] = M1(0,26); (*(M2[173]))[313] = M1(0,27); 
(*(M2[174]))[111] = M1(1,1); (*(M2[174]))[117] = M1(1,4); (*(M2[174]))[118] = M1(1,5); (*(M2[174]))[119] = M1(1,6); (*(M2[174]))[123] = M1(1,7); (*(M2[174]))[124] = M1(1,8); (*(M2[174]))[128] = M1(1,9); (*(M2[174]))[143] = M1(1,10); (*(M2[174]))[144] = M1(1,11); (*(M2[174]))[145] = M1(1,12); (*(M2[174]))[149] = M1(1,13); (*(M2[174]))[150] = M1(1,14); (*(M2[174]))[154] = M1(1,15); (*(M2[174]))[168] = M1(1,16); (*(M2[174]))[169] = M1(1,17); (*(M2[174]))[173] = M1(1,18); (*(M2[174]))[186] = M1(1,19); (*(M2[174]))[293] = M1(1,24); (*(M2[174]))[294] = M1(1,25); (*(M2[174]))[298] = M1(1,26); (*(M2[174]))[313] = M1(1,27); 
(*(M2[175]))[112] = M1(2,2); (*(M2[175]))[117] = M1(2,4); (*(M2[175]))[118] = M1(2,5); (*(M2[175]))[119] = M1(2,6); (*(M2[175]))[123] = M1(2,7); (*(M2[175]))[124] = M1(2,8); (*(M2[175]))[128] = M1(2,9); (*(M2[175]))[143] = M1(2,10); (*(M2[175]))[144] = M1(2,11); (*(M2[175]))[145] = M1(2,12); (*(M2[175]))[149] = M1(2,13); (*(M2[175]))[150] = M1(2,14); (*(M2[175]))[154] = M1(2,15); (*(M2[175]))[168] = M1(2,16); (*(M2[175]))[169] = M1(2,17); (*(M2[175]))[173] = M1(2,18); (*(M2[175]))[186] = M1(2,19); (*(M2[175]))[293] = M1(2,24); (*(M2[175]))[294] = M1(2,25); (*(M2[175]))[298] = M1(2,26); (*(M2[175]))[313] = M1(2,27); 
(*(M2[176]))[113] = M1(3,3); (*(M2[176]))[117] = M1(3,4); (*(M2[176]))[118] = M1(3,5); (*(M2[176]))[119] = M1(3,6); (*(M2[176]))[123] = M1(3,7); (*(M2[176]))[124] = M1(3,8); (*(M2[176]))[128] = M1(3,9); (*(M2[176]))[143] = M1(3,10); (*(M2[176]))[144] = M1(3,11); (*(M2[176]))[145] = M1(3,12); (*(M2[176]))[149] = M1(3,13); (*(M2[176]))[150] = M1(3,14); (*(M2[176]))[154] = M1(3,15); (*(M2[176]))[168] = M1(3,16); (*(M2[176]))[169] = M1(3,17); (*(M2[176]))[173] = M1(3,18); (*(M2[176]))[186] = M1(3,19); (*(M2[176]))[293] = M1(3,24); (*(M2[176]))[294] = M1(3,25); (*(M2[176]))[298] = M1(3,26); (*(M2[176]))[313] = M1(3,27); 
(*(M2[177]))[212] = M1(4,20); (*(M2[177]))[214] = M1(4,21); (*(M2[177]))[223] = M1(4,22); (*(M2[177]))[259] = M1(4,23); (*(M2[177]))[348] = M1(4,28); 
(*(M2[178]))[104] = M1(0,0); (*(M2[178]))[111] = M1(0,4); (*(M2[178]))[112] = M1(0,5); (*(M2[178]))[113] = M1(0,6); (*(M2[178]))[118] = M1(0,7); (*(M2[178]))[119] = M1(0,8); (*(M2[178]))[124] = M1(0,9); (*(M2[178]))[137] = M1(0,10); (*(M2[178]))[138] = M1(0,11); (*(M2[178]))[139] = M1(0,12); (*(M2[178]))[144] = M1(0,13); (*(M2[178]))[145] = M1(0,14); (*(M2[178]))[150] = M1(0,15); (*(M2[178]))[163] = M1(0,16); (*(M2[178]))[164] = M1(0,17); (*(M2[178]))[169] = M1(0,18); (*(M2[178]))[182] = M1(0,19); (*(M2[178]))[288] = M1(0,24); (*(M2[178]))[289] = M1(0,25); (*(M2[178]))[294] = M1(0,26); (*(M2[178]))[309] = M1(0,27); 
(*(M2[179]))[105] = M1(1,1); (*(M2[179]))[111] = M1(1,4); (*(M2[179]))[112] = M1(1,5); (*(M2[179]))[113] = M1(1,6); (*(M2[179]))[118] = M1(1,7); (*(M2[179]))[119] = M1(1,8); (*(M2[179]))[124] = M1(1,9); (*(M2[179]))[137] = M1(1,10); (*(M2[179]))[138] = M1(1,11); (*(M2[179]))[139] = M1(1,12); (*(M2[179]))[144] = M1(1,13); (*(M2[179]))[145] = M1(1,14); (*(M2[179]))[150] = M1(1,15); (*(M2[179]))[163] = M1(1,16); (*(M2[179]))[164] = M1(1,17); (*(M2[179]))[169] = M1(1,18); (*(M2[179]))[182] = M1(1,19); (*(M2[179]))[288] = M1(1,24); (*(M2[179]))[289] = M1(1,25); (*(M2[179]))[294] = M1(1,26); (*(M2[179]))[309] = M1(1,27); 
(*(M2[180]))[106] = M1(2,2); (*(M2[180]))[111] = M1(2,4); (*(M2[180]))[112] = M1(2,5); (*(M2[180]))[113] = M1(2,6); (*(M2[180]))[118] = M1(2,7); (*(M2[180]))[119] = M1(2,8); (*(M2[180]))[124] = M1(2,9); (*(M2[180]))[137] = M1(2,10); (*(M2[180]))[138] = M1(2,11); (*(M2[180]))[139] = M1(2,12); (*(M2[180]))[144] = M1(2,13); (*(M2[180]))[145] = M1(2,14); (*(M2[180]))[150] = M1(2,15); (*(M2[180]))[163] = M1(2,16); (*(M2[180]))[164] = M1(2,17); (*(M2[180]))[169] = M1(2,18); (*(M2[180]))[182] = M1(2,19); (*(M2[180]))[288] = M1(2,24); (*(M2[180]))[289] = M1(2,25); (*(M2[180]))[294] = M1(2,26); (*(M2[180]))[309] = M1(2,27); 
(*(M2[181]))[107] = M1(3,3); (*(M2[181]))[111] = M1(3,4); (*(M2[181]))[112] = M1(3,5); (*(M2[181]))[113] = M1(3,6); (*(M2[181]))[118] = M1(3,7); (*(M2[181]))[119] = M1(3,8); (*(M2[181]))[124] = M1(3,9); (*(M2[181]))[137] = M1(3,10); (*(M2[181]))[138] = M1(3,11); (*(M2[181]))[139] = M1(3,12); (*(M2[181]))[144] = M1(3,13); (*(M2[181]))[145] = M1(3,14); (*(M2[181]))[150] = M1(3,15); (*(M2[181]))[163] = M1(3,16); (*(M2[181]))[164] = M1(3,17); (*(M2[181]))[169] = M1(3,18); (*(M2[181]))[182] = M1(3,19); (*(M2[181]))[288] = M1(3,24); (*(M2[181]))[289] = M1(3,25); (*(M2[181]))[294] = M1(3,26); (*(M2[181]))[309] = M1(3,27); 
(*(M2[182]))[206] = M1(4,20); (*(M2[182]))[208] = M1(4,21); (*(M2[182]))[219] = M1(4,22); (*(M2[182]))[255] = M1(4,23); (*(M2[182]))[344] = M1(4,28); 
(*(M2[183]))[160] = M1(0,0); (*(M2[183]))[166] = M1(0,4); (*(M2[183]))[167] = M1(0,5); (*(M2[183]))[168] = M1(0,6); (*(M2[183]))[171] = M1(0,7); (*(M2[183]))[172] = M1(0,8); (*(M2[183]))[175] = M1(0,9); (*(M2[183]))[179] = M1(0,10); (*(M2[183]))[180] = M1(0,11); (*(M2[183]))[181] = M1(0,12); (*(M2[183]))[184] = M1(0,13); (*(M2[183]))[185] = M1(0,14); (*(M2[183]))[188] = M1(0,15); (*(M2[183]))[192] = M1(0,16); (*(M2[183]))[193] = M1(0,17); (*(M2[183]))[196] = M1(0,18); (*(M2[183]))[200] = M1(0,19); (*(M2[183]))[321] = M1(0,24); (*(M2[183]))[322] = M1(0,25); (*(M2[183]))[325] = M1(0,26); (*(M2[183]))[331] = M1(0,27); 
(*(M2[184]))[161] = M1(1,1); (*(M2[184]))[166] = M1(1,4); (*(M2[184]))[167] = M1(1,5); (*(M2[184]))[168] = M1(1,6); (*(M2[184]))[171] = M1(1,7); (*(M2[184]))[172] = M1(1,8); (*(M2[184]))[175] = M1(1,9); (*(M2[184]))[179] = M1(1,10); (*(M2[184]))[180] = M1(1,11); (*(M2[184]))[181] = M1(1,12); (*(M2[184]))[184] = M1(1,13); (*(M2[184]))[185] = M1(1,14); (*(M2[184]))[188] = M1(1,15); (*(M2[184]))[192] = M1(1,16); (*(M2[184]))[193] = M1(1,17); (*(M2[184]))[196] = M1(1,18); (*(M2[184]))[200] = M1(1,19); (*(M2[184]))[321] = M1(1,24); (*(M2[184]))[322] = M1(1,25); (*(M2[184]))[325] = M1(1,26); (*(M2[184]))[331] = M1(1,27); 
(*(M2[185]))[162] = M1(2,2); (*(M2[185]))[166] = M1(2,4); (*(M2[185]))[167] = M1(2,5); (*(M2[185]))[168] = M1(2,6); (*(M2[185]))[171] = M1(2,7); (*(M2[185]))[172] = M1(2,8); (*(M2[185]))[175] = M1(2,9); (*(M2[185]))[179] = M1(2,10); (*(M2[185]))[180] = M1(2,11); (*(M2[185]))[181] = M1(2,12); (*(M2[185]))[184] = M1(2,13); (*(M2[185]))[185] = M1(2,14); (*(M2[185]))[188] = M1(2,15); (*(M2[185]))[192] = M1(2,16); (*(M2[185]))[193] = M1(2,17); (*(M2[185]))[196] = M1(2,18); (*(M2[185]))[200] = M1(2,19); (*(M2[185]))[321] = M1(2,24); (*(M2[185]))[322] = M1(2,25); (*(M2[185]))[325] = M1(2,26); (*(M2[185]))[331] = M1(2,27); 
(*(M2[186]))[163] = M1(3,3); (*(M2[186]))[166] = M1(3,4); (*(M2[186]))[167] = M1(3,5); (*(M2[186]))[168] = M1(3,6); (*(M2[186]))[171] = M1(3,7); (*(M2[186]))[172] = M1(3,8); (*(M2[186]))[175] = M1(3,9); (*(M2[186]))[179] = M1(3,10); (*(M2[186]))[180] = M1(3,11); (*(M2[186]))[181] = M1(3,12); (*(M2[186]))[184] = M1(3,13); (*(M2[186]))[185] = M1(3,14); (*(M2[186]))[188] = M1(3,15); (*(M2[186]))[192] = M1(3,16); (*(M2[186]))[193] = M1(3,17); (*(M2[186]))[196] = M1(3,18); (*(M2[186]))[200] = M1(3,19); (*(M2[186]))[321] = M1(3,24); (*(M2[186]))[322] = M1(3,25); (*(M2[186]))[325] = M1(3,26); (*(M2[186]))[331] = M1(3,27); 
(*(M2[187]))[252] = M1(4,20); (*(M2[187]))[254] = M1(4,21); (*(M2[187]))[261] = M1(4,22); (*(M2[187]))[277] = M1(4,23); (*(M2[187]))[366] = M1(4,28); 
(*(M2[188]))[141] = M1(0,0); (*(M2[188]))[147] = M1(0,4); (*(M2[188]))[148] = M1(0,5); (*(M2[188]))[149] = M1(0,6); (*(M2[188]))[152] = M1(0,7); (*(M2[188]))[153] = M1(0,8); (*(M2[188]))[156] = M1(0,9); (*(M2[188]))[166] = M1(0,10); (*(M2[188]))[167] = M1(0,11); (*(M2[188]))[168] = M1(0,12); (*(M2[188]))[171] = M1(0,13); (*(M2[188]))[172] = M1(0,14); (*(M2[188]))[175] = M1(0,15); (*(M2[188]))[184] = M1(0,16); (*(M2[188]))[185] = M1(0,17); (*(M2[188]))[188] = M1(0,18); (*(M2[188]))[196] = M1(0,19); (*(M2[188]))[311] = M1(0,24); (*(M2[188]))[312] = M1(0,25); (*(M2[188]))[315] = M1(0,26); (*(M2[188]))[325] = M1(0,27); 
(*(M2[189]))[142] = M1(1,1); (*(M2[189]))[147] = M1(1,4); (*(M2[189]))[148] = M1(1,5); (*(M2[189]))[149] = M1(1,6); (*(M2[189]))[152] = M1(1,7); (*(M2[189]))[153] = M1(1,8); (*(M2[189]))[156] = M1(1,9); (*(M2[189]))[166] = M1(1,10); (*(M2[189]))[167] = M1(1,11); (*(M2[189]))[168] = M1(1,12); (*(M2[189]))[171] = M1(1,13); (*(M2[189]))[172] = M1(1,14); (*(M2[189]))[175] = M1(1,15); (*(M2[189]))[184] = M1(1,16); (*(M2[189]))[185] = M1(1,17); (*(M2[189]))[188] = M1(1,18); (*(M2[189]))[196] = M1(1,19); (*(M2[189]))[311] = M1(1,24); (*(M2[189]))[312] = M1(1,25); (*(M2[189]))[315] = M1(1,26); (*(M2[189]))[325] = M1(1,27); 
(*(M2[190]))[143] = M1(2,2); (*(M2[190]))[147] = M1(2,4); (*(M2[190]))[148] = M1(2,5); (*(M2[190]))[149] = M1(2,6); (*(M2[190]))[152] = M1(2,7); (*(M2[190]))[153] = M1(2,8); (*(M2[190]))[156] = M1(2,9); (*(M2[190]))[166] = M1(2,10); (*(M2[190]))[167] = M1(2,11); (*(M2[190]))[168] = M1(2,12); (*(M2[190]))[171] = M1(2,13); (*(M2[190]))[172] = M1(2,14); (*(M2[190]))[175] = M1(2,15); (*(M2[190]))[184] = M1(2,16); (*(M2[190]))[185] = M1(2,17); (*(M2[190]))[188] = M1(2,18); (*(M2[190]))[196] = M1(2,19); (*(M2[190]))[311] = M1(2,24); (*(M2[190]))[312] = M1(2,25); (*(M2[190]))[315] = M1(2,26); (*(M2[190]))[325] = M1(2,27); 
(*(M2[191]))[144] = M1(3,3); (*(M2[191]))[147] = M1(3,4); (*(M2[191]))[148] = M1(3,5); (*(M2[191]))[149] = M1(3,6); (*(M2[191]))[152] = M1(3,7); (*(M2[191]))[153] = M1(3,8); (*(M2[191]))[156] = M1(3,9); (*(M2[191]))[166] = M1(3,10); (*(M2[191]))[167] = M1(3,11); (*(M2[191]))[168] = M1(3,12); (*(M2[191]))[171] = M1(3,13); (*(M2[191]))[172] = M1(3,14); (*(M2[191]))[175] = M1(3,15); (*(M2[191]))[184] = M1(3,16); (*(M2[191]))[185] = M1(3,17); (*(M2[191]))[188] = M1(3,18); (*(M2[191]))[196] = M1(3,19); (*(M2[191]))[311] = M1(3,24); (*(M2[191]))[312] = M1(3,25); (*(M2[191]))[315] = M1(3,26); (*(M2[191]))[325] = M1(3,27); 
(*(M2[192]))[237] = M1(4,20); (*(M2[192]))[239] = M1(4,21); (*(M2[192]))[246] = M1(4,22); (*(M2[192]))[271] = M1(4,23); (*(M2[192]))[360] = M1(4,28); 
(*(M2[193]))[115] = M1(0,0); (*(M2[193]))[121] = M1(0,4); (*(M2[193]))[122] = M1(0,5); (*(M2[193]))[123] = M1(0,6); (*(M2[193]))[126] = M1(0,7); (*(M2[193]))[127] = M1(0,8); (*(M2[193]))[130] = M1(0,9); (*(M2[193]))[147] = M1(0,10); (*(M2[193]))[148] = M1(0,11); (*(M2[193]))[149] = M1(0,12); (*(M2[193]))[152] = M1(0,13); (*(M2[193]))[153] = M1(0,14); (*(M2[193]))[156] = M1(0,15); (*(M2[193]))[171] = M1(0,16); (*(M2[193]))[172] = M1(0,17); (*(M2[193]))[175] = M1(0,18); (*(M2[193]))[188] = M1(0,19); (*(M2[193]))[296] = M1(0,24); (*(M2[193]))[297] = M1(0,25); (*(M2[193]))[300] = M1(0,26); (*(M2[193]))[315] = M1(0,27); 
(*(M2[194]))[116] = M1(1,1); (*(M2[194]))[121] = M1(1,4); (*(M2[194]))[122] = M1(1,5); (*(M2[194]))[123] = M1(1,6); (*(M2[194]))[126] = M1(1,7); (*(M2[194]))[127] = M1(1,8); (*(M2[194]))[130] = M1(1,9); (*(M2[194]))[147] = M1(1,10); (*(M2[194]))[148] = M1(1,11); (*(M2[194]))[149] = M1(1,12); (*(M2[194]))[152] = M1(1,13); (*(M2[194]))[153] = M1(1,14); (*(M2[194]))[156] = M1(1,15); (*(M2[194]))[171] = M1(1,16); (*(M2[194]))[172] = M1(1,17); (*(M2[194]))[175] = M1(1,18); (*(M2[194]))[188] = M1(1,19); (*(M2[194]))[296] = M1(1,24); (*(M2[194]))[297] = M1(1,25); (*(M2[194]))[300] = M1(1,26); (*(M2[194]))[315] = M1(1,27); 
(*(M2[195]))[117] = M1(2,2); (*(M2[195]))[121] = M1(2,4); (*(M2[195]))[122] = M1(2,5); (*(M2[195]))[123] = M1(2,6); (*(M2[195]))[126] = M1(2,7); (*(M2[195]))[127] = M1(2,8); (*(M2[195]))[130] = M1(2,9); (*(M2[195]))[147] = M1(2,10); (*(M2[195]))[148] = M1(2,11); (*(M2[195]))[149] = M1(2,12); (*(M2[195]))[152] = M1(2,13); (*(M2[195]))[153] = M1(2,14); (*(M2[195]))[156] = M1(2,15); (*(M2[195]))[171] = M1(2,16); (*(M2[195]))[172] = M1(2,17); (*(M2[195]))[175] = M1(2,18); (*(M2[195]))[188] = M1(2,19); (*(M2[195]))[296] = M1(2,24); (*(M2[195]))[297] = M1(2,25); (*(M2[195]))[300] = M1(2,26); (*(M2[195]))[315] = M1(2,27); 
(*(M2[196]))[118] = M1(3,3); (*(M2[196]))[121] = M1(3,4); (*(M2[196]))[122] = M1(3,5); (*(M2[196]))[123] = M1(3,6); (*(M2[196]))[126] = M1(3,7); (*(M2[196]))[127] = M1(3,8); (*(M2[196]))[130] = M1(3,9); (*(M2[196]))[147] = M1(3,10); (*(M2[196]))[148] = M1(3,11); (*(M2[196]))[149] = M1(3,12); (*(M2[196]))[152] = M1(3,13); (*(M2[196]))[153] = M1(3,14); (*(M2[196]))[156] = M1(3,15); (*(M2[196]))[171] = M1(3,16); (*(M2[196]))[172] = M1(3,17); (*(M2[196]))[175] = M1(3,18); (*(M2[196]))[188] = M1(3,19); (*(M2[196]))[296] = M1(3,24); (*(M2[196]))[297] = M1(3,25); (*(M2[196]))[300] = M1(3,26); (*(M2[196]))[315] = M1(3,27); 
(*(M2[197]))[216] = M1(4,20); (*(M2[197]))[218] = M1(4,21); (*(M2[197]))[225] = M1(4,22); (*(M2[197]))[261] = M1(4,23); (*(M2[197]))[350] = M1(4,28); 
(*(M2[198]))[135] = M1(0,0); (*(M2[198]))[142] = M1(0,4); (*(M2[198]))[143] = M1(0,5); (*(M2[198]))[144] = M1(0,6); (*(M2[198]))[148] = M1(0,7); (*(M2[198]))[149] = M1(0,8); (*(M2[198]))[153] = M1(0,9); (*(M2[198]))[161] = M1(0,10); (*(M2[198]))[162] = M1(0,11); (*(M2[198]))[163] = M1(0,12); (*(M2[198]))[167] = M1(0,13); (*(M2[198]))[168] = M1(0,14); (*(M2[198]))[172] = M1(0,15); (*(M2[198]))[180] = M1(0,16); (*(M2[198]))[181] = M1(0,17); (*(M2[198]))[185] = M1(0,18); (*(M2[198]))[193] = M1(0,19); (*(M2[198]))[307] = M1(0,24); (*(M2[198]))[308] = M1(0,25); (*(M2[198]))[312] = M1(0,26); (*(M2[198]))[322] = M1(0,27); 
(*(M2[199]))[136] = M1(1,1); (*(M2[199]))[142] = M1(1,4); (*(M2[199]))[143] = M1(1,5); (*(M2[199]))[144] = M1(1,6); (*(M2[199]))[148] = M1(1,7); (*(M2[199]))[149] = M1(1,8); (*(M2[199]))[153] = M1(1,9); (*(M2[199]))[161] = M1(1,10); (*(M2[199]))[162] = M1(1,11); (*(M2[199]))[163] = M1(1,12); (*(M2[199]))[167] = M1(1,13); (*(M2[199]))[168] = M1(1,14); (*(M2[199]))[172] = M1(1,15); (*(M2[199]))[180] = M1(1,16); (*(M2[199]))[181] = M1(1,17); (*(M2[199]))[185] = M1(1,18); (*(M2[199]))[193] = M1(1,19); (*(M2[199]))[307] = M1(1,24); (*(M2[199]))[308] = M1(1,25); (*(M2[199]))[312] = M1(1,26); (*(M2[199]))[322] = M1(1,27); 
(*(M2[200]))[137] = M1(2,2); (*(M2[200]))[142] = M1(2,4); (*(M2[200]))[143] = M1(2,5); (*(M2[200]))[144] = M1(2,6); (*(M2[200]))[148] = M1(2,7); (*(M2[200]))[149] = M1(2,8); (*(M2[200]))[153] = M1(2,9); (*(M2[200]))[161] = M1(2,10); (*(M2[200]))[162] = M1(2,11); (*(M2[200]))[163] = M1(2,12); (*(M2[200]))[167] = M1(2,13); (*(M2[200]))[168] = M1(2,14); (*(M2[200]))[172] = M1(2,15); (*(M2[200]))[180] = M1(2,16); (*(M2[200]))[181] = M1(2,17); (*(M2[200]))[185] = M1(2,18); (*(M2[200]))[193] = M1(2,19); (*(M2[200]))[307] = M1(2,24); (*(M2[200]))[308] = M1(2,25); (*(M2[200]))[312] = M1(2,26); (*(M2[200]))[322] = M1(2,27); 
(*(M2[201]))[138] = M1(3,3); (*(M2[201]))[142] = M1(3,4); (*(M2[201]))[143] = M1(3,5); (*(M2[201]))[144] = M1(3,6); (*(M2[201]))[148] = M1(3,7); (*(M2[201]))[149] = M1(3,8); (*(M2[201]))[153] = M1(3,9); (*(M2[201]))[161] = M1(3,10); (*(M2[201]))[162] = M1(3,11); (*(M2[201]))[163] = M1(3,12); (*(M2[201]))[167] = M1(3,13); (*(M2[201]))[168] = M1(3,14); (*(M2[201]))[172] = M1(3,15); (*(M2[201]))[180] = M1(3,16); (*(M2[201]))[181] = M1(3,17); (*(M2[201]))[185] = M1(3,18); (*(M2[201]))[193] = M1(3,19); (*(M2[201]))[307] = M1(3,24); (*(M2[201]))[308] = M1(3,25); (*(M2[201]))[312] = M1(3,26); (*(M2[201]))[322] = M1(3,27); 
(*(M2[202]))[232] = M1(4,20); (*(M2[202]))[234] = M1(4,21); (*(M2[202]))[243] = M1(4,22); (*(M2[202]))[268] = M1(4,23); (*(M2[202]))[357] = M1(4,28); 
(*(M2[203]))[109] = M1(0,0); (*(M2[203]))[116] = M1(0,4); (*(M2[203]))[117] = M1(0,5); (*(M2[203]))[118] = M1(0,6); (*(M2[203]))[122] = M1(0,7); (*(M2[203]))[123] = M1(0,8); (*(M2[203]))[127] = M1(0,9); (*(M2[203]))[142] = M1(0,10); (*(M2[203]))[143] = M1(0,11); (*(M2[203]))[144] = M1(0,12); (*(M2[203]))[148] = M1(0,13); (*(M2[203]))[149] = M1(0,14); (*(M2[203]))[153] = M1(0,15); (*(M2[203]))[167] = M1(0,16); (*(M2[203]))[168] = M1(0,17); (*(M2[203]))[172] = M1(0,18); (*(M2[203]))[185] = M1(0,19); (*(M2[203]))[292] = M1(0,24); (*(M2[203]))[293] = M1(0,25); (*(M2[203]))[297] = M1(0,26); (*(M2[203]))[312] = M1(0,27); 
(*(M2[204]))[110] = M1(1,1); (*(M2[204]))[116] = M1(1,4); (*(M2[204]))[117] = M1(1,5); (*(M2[204]))[118] = M1(1,6); (*(M2[204]))[122] = M1(1,7); (*(M2[204]))[123] = M1(1,8); (*(M2[204]))[127] = M1(1,9); (*(M2[204]))[142] = M1(1,10); (*(M2[204]))[143] = M1(1,11); (*(M2[204]))[144] = M1(1,12); (*(M2[204]))[148] = M1(1,13); (*(M2[204]))[149] = M1(1,14); (*(M2[204]))[153] = M1(1,15); (*(M2[204]))[167] = M1(1,16); (*(M2[204]))[168] = M1(1,17); (*(M2[204]))[172] = M1(1,18); (*(M2[204]))[185] = M1(1,19); (*(M2[204]))[292] = M1(1,24); (*(M2[204]))[293] = M1(1,25); (*(M2[204]))[297] = M1(1,26); (*(M2[204]))[312] = M1(1,27); 
(*(M2[205]))[111] = M1(2,2); (*(M2[205]))[116] = M1(2,4); (*(M2[205]))[117] = M1(2,5); (*(M2[205]))[118] = M1(2,6); (*(M2[205]))[122] = M1(2,7); (*(M2[205]))[123] = M1(2,8); (*(M2[205]))[127] = M1(2,9); (*(M2[205]))[142] = M1(2,10); (*(M2[205]))[143] = M1(2,11); (*(M2[205]))[144] = M1(2,12); (*(M2[205]))[148] = M1(2,13); (*(M2[205]))[149] = M1(2,14); (*(M2[205]))[153] = M1(2,15); (*(M2[205]))[167] = M1(2,16); (*(M2[205]))[168] = M1(2,17); (*(M2[205]))[172] = M1(2,18); (*(M2[205]))[185] = M1(2,19); (*(M2[205]))[292] = M1(2,24); (*(M2[205]))[293] = M1(2,25); (*(M2[205]))[297] = M1(2,26); (*(M2[205]))[312] = M1(2,27); 
(*(M2[206]))[112] = M1(3,3); (*(M2[206]))[116] = M1(3,4); (*(M2[206]))[117] = M1(3,5); (*(M2[206]))[118] = M1(3,6); (*(M2[206]))[122] = M1(3,7); (*(M2[206]))[123] = M1(3,8); (*(M2[206]))[127] = M1(3,9); (*(M2[206]))[142] = M1(3,10); (*(M2[206]))[143] = M1(3,11); (*(M2[206]))[144] = M1(3,12); (*(M2[206]))[148] = M1(3,13); (*(M2[206]))[149] = M1(3,14); (*(M2[206]))[153] = M1(3,15); (*(M2[206]))[167] = M1(3,16); (*(M2[206]))[168] = M1(3,17); (*(M2[206]))[172] = M1(3,18); (*(M2[206]))[185] = M1(3,19); (*(M2[206]))[292] = M1(3,24); (*(M2[206]))[293] = M1(3,25); (*(M2[206]))[297] = M1(3,26); (*(M2[206]))[312] = M1(3,27); 
(*(M2[207]))[211] = M1(4,20); (*(M2[207]))[213] = M1(4,21); (*(M2[207]))[222] = M1(4,22); (*(M2[207]))[258] = M1(4,23); (*(M2[207]))[347] = M1(4,28); 
(*(M2[208]))[103] = M1(0,0); (*(M2[208]))[110] = M1(0,4); (*(M2[208]))[111] = M1(0,5); (*(M2[208]))[112] = M1(0,6); (*(M2[208]))[117] = M1(0,7); (*(M2[208]))[118] = M1(0,8); (*(M2[208]))[123] = M1(0,9); (*(M2[208]))[136] = M1(0,10); (*(M2[208]))[137] = M1(0,11); (*(M2[208]))[138] = M1(0,12); (*(M2[208]))[143] = M1(0,13); (*(M2[208]))[144] = M1(0,14); (*(M2[208]))[149] = M1(0,15); (*(M2[208]))[162] = M1(0,16); (*(M2[208]))[163] = M1(0,17); (*(M2[208]))[168] = M1(0,18); (*(M2[208]))[181] = M1(0,19); (*(M2[208]))[287] = M1(0,24); (*(M2[208]))[288] = M1(0,25); (*(M2[208]))[293] = M1(0,26); (*(M2[208]))[308] = M1(0,27); 
(*(M2[209]))[104] = M1(1,1); (*(M2[209]))[110] = M1(1,4); (*(M2[209]))[111] = M1(1,5); (*(M2[209]))[112] = M1(1,6); (*(M2[209]))[117] = M1(1,7); (*(M2[209]))[118] = M1(1,8); (*(M2[209]))[123] = M1(1,9); (*(M2[209]))[136] = M1(1,10); (*(M2[209]))[137] = M1(1,11); (*(M2[209]))[138] = M1(1,12); (*(M2[209]))[143] = M1(1,13); (*(M2[209]))[144] = M1(1,14); (*(M2[209]))[149] = M1(1,15); (*(M2[209]))[162] = M1(1,16); (*(M2[209]))[163] = M1(1,17); (*(M2[209]))[168] = M1(1,18); (*(M2[209]))[181] = M1(1,19); (*(M2[209]))[287] = M1(1,24); (*(M2[209]))[288] = M1(1,25); (*(M2[209]))[293] = M1(1,26); (*(M2[209]))[308] = M1(1,27); 
(*(M2[210]))[105] = M1(2,2); (*(M2[210]))[110] = M1(2,4); (*(M2[210]))[111] = M1(2,5); (*(M2[210]))[112] = M1(2,6); (*(M2[210]))[117] = M1(2,7); (*(M2[210]))[118] = M1(2,8); (*(M2[210]))[123] = M1(2,9); (*(M2[210]))[136] = M1(2,10); (*(M2[210]))[137] = M1(2,11); (*(M2[210]))[138] = M1(2,12); (*(M2[210]))[143] = M1(2,13); (*(M2[210]))[144] = M1(2,14); (*(M2[210]))[149] = M1(2,15); (*(M2[210]))[162] = M1(2,16); (*(M2[210]))[163] = M1(2,17); (*(M2[210]))[168] = M1(2,18); (*(M2[210]))[181] = M1(2,19); (*(M2[210]))[287] = M1(2,24); (*(M2[210]))[288] = M1(2,25); (*(M2[210]))[293] = M1(2,26); (*(M2[210]))[308] = M1(2,27); 
(*(M2[211]))[106] = M1(3,3); (*(M2[211]))[110] = M1(3,4); (*(M2[211]))[111] = M1(3,5); (*(M2[211]))[112] = M1(3,6); (*(M2[211]))[117] = M1(3,7); (*(M2[211]))[118] = M1(3,8); (*(M2[211]))[123] = M1(3,9); (*(M2[211]))[136] = M1(3,10); (*(M2[211]))[137] = M1(3,11); (*(M2[211]))[138] = M1(3,12); (*(M2[211]))[143] = M1(3,13); (*(M2[211]))[144] = M1(3,14); (*(M2[211]))[149] = M1(3,15); (*(M2[211]))[162] = M1(3,16); (*(M2[211]))[163] = M1(3,17); (*(M2[211]))[168] = M1(3,18); (*(M2[211]))[181] = M1(3,19); (*(M2[211]))[287] = M1(3,24); (*(M2[211]))[288] = M1(3,25); (*(M2[211]))[293] = M1(3,26); (*(M2[211]))[308] = M1(3,27); 
(*(M2[212]))[205] = M1(4,20); (*(M2[212]))[207] = M1(4,21); (*(M2[212]))[218] = M1(4,22); (*(M2[212]))[254] = M1(4,23); (*(M2[212]))[343] = M1(4,28); 
(*(M2[213]))[134] = M1(0,0); (*(M2[213]))[141] = M1(0,4); (*(M2[213]))[142] = M1(0,5); (*(M2[213]))[143] = M1(0,6); (*(M2[213]))[147] = M1(0,7); (*(M2[213]))[148] = M1(0,8); (*(M2[213]))[152] = M1(0,9); (*(M2[213]))[160] = M1(0,10); (*(M2[213]))[161] = M1(0,11); (*(M2[213]))[162] = M1(0,12); (*(M2[213]))[166] = M1(0,13); (*(M2[213]))[167] = M1(0,14); (*(M2[213]))[171] = M1(0,15); (*(M2[213]))[179] = M1(0,16); (*(M2[213]))[180] = M1(0,17); (*(M2[213]))[184] = M1(0,18); (*(M2[213]))[192] = M1(0,19); (*(M2[213]))[306] = M1(0,24); (*(M2[213]))[307] = M1(0,25); (*(M2[213]))[311] = M1(0,26); (*(M2[213]))[321] = M1(0,27); 
(*(M2[214]))[135] = M1(1,1); (*(M2[214]))[141] = M1(1,4); (*(M2[214]))[142] = M1(1,5); (*(M2[214]))[143] = M1(1,6); (*(M2[214]))[147] = M1(1,7); (*(M2[214]))[148] = M1(1,8); (*(M2[214]))[152] = M1(1,9); (*(M2[214]))[160] = M1(1,10); (*(M2[214]))[161] = M1(1,11); (*(M2[214]))[162] = M1(1,12); (*(M2[214]))[166] = M1(1,13); (*(M2[214]))[167] = M1(1,14); (*(M2[214]))[171] = M1(1,15); (*(M2[214]))[179] = M1(1,16); (*(M2[214]))[180] = M1(1,17); (*(M2[214]))[184] = M1(1,18); (*(M2[214]))[192] = M1(1,19); (*(M2[214]))[306] = M1(1,24); (*(M2[214]))[307] = M1(1,25); (*(M2[214]))[311] = M1(1,26); (*(M2[214]))[321] = M1(1,27); 
(*(M2[215]))[136] = M1(2,2); (*(M2[215]))[141] = M1(2,4); (*(M2[215]))[142] = M1(2,5); (*(M2[215]))[143] = M1(2,6); (*(M2[215]))[147] = M1(2,7); (*(M2[215]))[148] = M1(2,8); (*(M2[215]))[152] = M1(2,9); (*(M2[215]))[160] = M1(2,10); (*(M2[215]))[161] = M1(2,11); (*(M2[215]))[162] = M1(2,12); (*(M2[215]))[166] = M1(2,13); (*(M2[215]))[167] = M1(2,14); (*(M2[215]))[171] = M1(2,15); (*(M2[215]))[179] = M1(2,16); (*(M2[215]))[180] = M1(2,17); (*(M2[215]))[184] = M1(2,18); (*(M2[215]))[192] = M1(2,19); (*(M2[215]))[306] = M1(2,24); (*(M2[215]))[307] = M1(2,25); (*(M2[215]))[311] = M1(2,26); (*(M2[215]))[321] = M1(2,27); 
(*(M2[216]))[137] = M1(3,3); (*(M2[216]))[141] = M1(3,4); (*(M2[216]))[142] = M1(3,5); (*(M2[216]))[143] = M1(3,6); (*(M2[216]))[147] = M1(3,7); (*(M2[216]))[148] = M1(3,8); (*(M2[216]))[152] = M1(3,9); (*(M2[216]))[160] = M1(3,10); (*(M2[216]))[161] = M1(3,11); (*(M2[216]))[162] = M1(3,12); (*(M2[216]))[166] = M1(3,13); (*(M2[216]))[167] = M1(3,14); (*(M2[216]))[171] = M1(3,15); (*(M2[216]))[179] = M1(3,16); (*(M2[216]))[180] = M1(3,17); (*(M2[216]))[184] = M1(3,18); (*(M2[216]))[192] = M1(3,19); (*(M2[216]))[306] = M1(3,24); (*(M2[216]))[307] = M1(3,25); (*(M2[216]))[311] = M1(3,26); (*(M2[216]))[321] = M1(3,27); 
(*(M2[217]))[231] = M1(4,20); (*(M2[217]))[233] = M1(4,21); (*(M2[217]))[242] = M1(4,22); (*(M2[217]))[267] = M1(4,23); (*(M2[217]))[356] = M1(4,28); 
(*(M2[218]))[108] = M1(0,0); (*(M2[218]))[115] = M1(0,4); (*(M2[218]))[116] = M1(0,5); (*(M2[218]))[117] = M1(0,6); (*(M2[218]))[121] = M1(0,7); (*(M2[218]))[122] = M1(0,8); (*(M2[218]))[126] = M1(0,9); (*(M2[218]))[141] = M1(0,10); (*(M2[218]))[142] = M1(0,11); (*(M2[218]))[143] = M1(0,12); (*(M2[218]))[147] = M1(0,13); (*(M2[218]))[148] = M1(0,14); (*(M2[218]))[152] = M1(0,15); (*(M2[218]))[166] = M1(0,16); (*(M2[218]))[167] = M1(0,17); (*(M2[218]))[171] = M1(0,18); (*(M2[218]))[184] = M1(0,19); (*(M2[218]))[291] = M1(0,24); (*(M2[218]))[292] = M1(0,25); (*(M2[218]))[296] = M1(0,26); (*(M2[218]))[311] = M1(0,27); 
(*(M2[219]))[109] = M1(1,1); (*(M2[219]))[115] = M1(1,4); (*(M2[219]))[116] = M1(1,5); (*(M2[219]))[117] = M1(1,6); (*(M2[219]))[121] = M1(1,7); (*(M2[219]))[122] = M1(1,8); (*(M2[219]))[126] = M1(1,9); (*(M2[219]))[141] = M1(1,10); (*(M2[219]))[142] = M1(1,11); (*(M2[219]))[143] = M1(1,12); (*(M2[219]))[147] = M1(1,13); (*(M2[219]))[148] = M1(1,14); (*(M2[219]))[152] = M1(1,15); (*(M2[219]))[166] = M1(1,16); (*(M2[219]))[167] = M1(1,17); (*(M2[219]))[171] = M1(1,18); (*(M2[219]))[184] = M1(1,19); (*(M2[219]))[291] = M1(1,24); (*(M2[219]))[292] = M1(1,25); (*(M2[219]))[296] = M1(1,26); (*(M2[219]))[311] = M1(1,27); 
(*(M2[220]))[110] = M1(2,2); (*(M2[220]))[115] = M1(2,4); (*(M2[220]))[116] = M1(2,5); (*(M2[220]))[117] = M1(2,6); (*(M2[220]))[121] = M1(2,7); (*(M2[220]))[122] = M1(2,8); (*(M2[220]))[126] = M1(2,9); (*(M2[220]))[141] = M1(2,10); (*(M2[220]))[142] = M1(2,11); (*(M2[220]))[143] = M1(2,12); (*(M2[220]))[147] = M1(2,13); (*(M2[220]))[148] = M1(2,14); (*(M2[220]))[152] = M1(2,15); (*(M2[220]))[166] = M1(2,16); (*(M2[220]))[167] = M1(2,17); (*(M2[220]))[171] = M1(2,18); (*(M2[220]))[184] = M1(2,19); (*(M2[220]))[291] = M1(2,24); (*(M2[220]))[292] = M1(2,25); (*(M2[220]))[296] = M1(2,26); (*(M2[220]))[311] = M1(2,27); 
(*(M2[221]))[111] = M1(3,3); (*(M2[221]))[115] = M1(3,4); (*(M2[221]))[116] = M1(3,5); (*(M2[221]))[117] = M1(3,6); (*(M2[221]))[121] = M1(3,7); (*(M2[221]))[122] = M1(3,8); (*(M2[221]))[126] = M1(3,9); (*(M2[221]))[141] = M1(3,10); (*(M2[221]))[142] = M1(3,11); (*(M2[221]))[143] = M1(3,12); (*(M2[221]))[147] = M1(3,13); (*(M2[221]))[148] = M1(3,14); (*(M2[221]))[152] = M1(3,15); (*(M2[221]))[166] = M1(3,16); (*(M2[221]))[167] = M1(3,17); (*(M2[221]))[171] = M1(3,18); (*(M2[221]))[184] = M1(3,19); (*(M2[221]))[291] = M1(3,24); (*(M2[221]))[292] = M1(3,25); (*(M2[221]))[296] = M1(3,26); (*(M2[221]))[311] = M1(3,27); 
(*(M2[222]))[210] = M1(4,20); (*(M2[222]))[212] = M1(4,21); (*(M2[222]))[221] = M1(4,22); (*(M2[222]))[257] = M1(4,23); (*(M2[222]))[346] = M1(4,28); 
(*(M2[223]))[102] = M1(0,0); (*(M2[223]))[109] = M1(0,4); (*(M2[223]))[110] = M1(0,5); (*(M2[223]))[111] = M1(0,6); (*(M2[223]))[116] = M1(0,7); (*(M2[223]))[117] = M1(0,8); (*(M2[223]))[122] = M1(0,9); (*(M2[223]))[135] = M1(0,10); (*(M2[223]))[136] = M1(0,11); (*(M2[223]))[137] = M1(0,12); (*(M2[223]))[142] = M1(0,13); (*(M2[223]))[143] = M1(0,14); (*(M2[223]))[148] = M1(0,15); (*(M2[223]))[161] = M1(0,16); (*(M2[223]))[162] = M1(0,17); (*(M2[223]))[167] = M1(0,18); (*(M2[223]))[180] = M1(0,19); (*(M2[223]))[286] = M1(0,24); (*(M2[223]))[287] = M1(0,25); (*(M2[223]))[292] = M1(0,26); (*(M2[223]))[307] = M1(0,27); 
(*(M2[224]))[103] = M1(1,1); (*(M2[224]))[109] = M1(1,4); (*(M2[224]))[110] = M1(1,5); (*(M2[224]))[111] = M1(1,6); (*(M2[224]))[116] = M1(1,7); (*(M2[224]))[117] = M1(1,8); (*(M2[224]))[122] = M1(1,9); (*(M2[224]))[135] = M1(1,10); (*(M2[224]))[136] = M1(1,11); (*(M2[224]))[137] = M1(1,12); (*(M2[224]))[142] = M1(1,13); (*(M2[224]))[143] = M1(1,14); (*(M2[224]))[148] = M1(1,15); (*(M2[224]))[161] = M1(1,16); (*(M2[224]))[162] = M1(1,17); (*(M2[224]))[167] = M1(1,18); (*(M2[224]))[180] = M1(1,19); (*(M2[224]))[286] = M1(1,24); (*(M2[224]))[287] = M1(1,25); (*(M2[224]))[292] = M1(1,26); (*(M2[224]))[307] = M1(1,27); 
(*(M2[225]))[104] = M1(2,2); (*(M2[225]))[109] = M1(2,4); (*(M2[225]))[110] = M1(2,5); (*(M2[225]))[111] = M1(2,6); (*(M2[225]))[116] = M1(2,7); (*(M2[225]))[117] = M1(2,8); (*(M2[225]))[122] = M1(2,9); (*(M2[225]))[135] = M1(2,10); (*(M2[225]))[136] = M1(2,11); (*(M2[225]))[137] = M1(2,12); (*(M2[225]))[142] = M1(2,13); (*(M2[225]))[143] = M1(2,14); (*(M2[225]))[148] = M1(2,15); (*(M2[225]))[161] = M1(2,16); (*(M2[225]))[162] = M1(2,17); (*(M2[225]))[167] = M1(2,18); (*(M2[225]))[180] = M1(2,19); (*(M2[225]))[286] = M1(2,24); (*(M2[225]))[287] = M1(2,25); (*(M2[225]))[292] = M1(2,26); (*(M2[225]))[307] = M1(2,27); 
(*(M2[226]))[105] = M1(3,3); (*(M2[226]))[109] = M1(3,4); (*(M2[226]))[110] = M1(3,5); (*(M2[226]))[111] = M1(3,6); (*(M2[226]))[116] = M1(3,7); (*(M2[226]))[117] = M1(3,8); (*(M2[226]))[122] = M1(3,9); (*(M2[226]))[135] = M1(3,10); (*(M2[226]))[136] = M1(3,11); (*(M2[226]))[137] = M1(3,12); (*(M2[226]))[142] = M1(3,13); (*(M2[226]))[143] = M1(3,14); (*(M2[226]))[148] = M1(3,15); (*(M2[226]))[161] = M1(3,16); (*(M2[226]))[162] = M1(3,17); (*(M2[226]))[167] = M1(3,18); (*(M2[226]))[180] = M1(3,19); (*(M2[226]))[286] = M1(3,24); (*(M2[226]))[287] = M1(3,25); (*(M2[226]))[292] = M1(3,26); (*(M2[226]))[307] = M1(3,27); 
(*(M2[227]))[204] = M1(4,20); (*(M2[227]))[206] = M1(4,21); (*(M2[227]))[217] = M1(4,22); (*(M2[227]))[253] = M1(4,23); (*(M2[227]))[342] = M1(4,28); 
(*(M2[228]))[101] = M1(0,0); (*(M2[228]))[108] = M1(0,4); (*(M2[228]))[109] = M1(0,5); (*(M2[228]))[110] = M1(0,6); (*(M2[228]))[115] = M1(0,7); (*(M2[228]))[116] = M1(0,8); (*(M2[228]))[121] = M1(0,9); (*(M2[228]))[134] = M1(0,10); (*(M2[228]))[135] = M1(0,11); (*(M2[228]))[136] = M1(0,12); (*(M2[228]))[141] = M1(0,13); (*(M2[228]))[142] = M1(0,14); (*(M2[228]))[147] = M1(0,15); (*(M2[228]))[160] = M1(0,16); (*(M2[228]))[161] = M1(0,17); (*(M2[228]))[166] = M1(0,18); (*(M2[228]))[179] = M1(0,19); (*(M2[228]))[285] = M1(0,24); (*(M2[228]))[286] = M1(0,25); (*(M2[228]))[291] = M1(0,26); (*(M2[228]))[306] = M1(0,27); 
(*(M2[229]))[102] = M1(1,1); (*(M2[229]))[108] = M1(1,4); (*(M2[229]))[109] = M1(1,5); (*(M2[229]))[110] = M1(1,6); (*(M2[229]))[115] = M1(1,7); (*(M2[229]))[116] = M1(1,8); (*(M2[229]))[121] = M1(1,9); (*(M2[229]))[134] = M1(1,10); (*(M2[229]))[135] = M1(1,11); (*(M2[229]))[136] = M1(1,12); (*(M2[229]))[141] = M1(1,13); (*(M2[229]))[142] = M1(1,14); (*(M2[229]))[147] = M1(1,15); (*(M2[229]))[160] = M1(1,16); (*(M2[229]))[161] = M1(1,17); (*(M2[229]))[166] = M1(1,18); (*(M2[229]))[179] = M1(1,19); (*(M2[229]))[285] = M1(1,24); (*(M2[229]))[286] = M1(1,25); (*(M2[229]))[291] = M1(1,26); (*(M2[229]))[306] = M1(1,27); 
(*(M2[230]))[103] = M1(2,2); (*(M2[230]))[108] = M1(2,4); (*(M2[230]))[109] = M1(2,5); (*(M2[230]))[110] = M1(2,6); (*(M2[230]))[115] = M1(2,7); (*(M2[230]))[116] = M1(2,8); (*(M2[230]))[121] = M1(2,9); (*(M2[230]))[134] = M1(2,10); (*(M2[230]))[135] = M1(2,11); (*(M2[230]))[136] = M1(2,12); (*(M2[230]))[141] = M1(2,13); (*(M2[230]))[142] = M1(2,14); (*(M2[230]))[147] = M1(2,15); (*(M2[230]))[160] = M1(2,16); (*(M2[230]))[161] = M1(2,17); (*(M2[230]))[166] = M1(2,18); (*(M2[230]))[179] = M1(2,19); (*(M2[230]))[285] = M1(2,24); (*(M2[230]))[286] = M1(2,25); (*(M2[230]))[291] = M1(2,26); (*(M2[230]))[306] = M1(2,27); 
(*(M2[231]))[104] = M1(3,3); (*(M2[231]))[108] = M1(3,4); (*(M2[231]))[109] = M1(3,5); (*(M2[231]))[110] = M1(3,6); (*(M2[231]))[115] = M1(3,7); (*(M2[231]))[116] = M1(3,8); (*(M2[231]))[121] = M1(3,9); (*(M2[231]))[134] = M1(3,10); (*(M2[231]))[135] = M1(3,11); (*(M2[231]))[136] = M1(3,12); (*(M2[231]))[141] = M1(3,13); (*(M2[231]))[142] = M1(3,14); (*(M2[231]))[147] = M1(3,15); (*(M2[231]))[160] = M1(3,16); (*(M2[231]))[161] = M1(3,17); (*(M2[231]))[166] = M1(3,18); (*(M2[231]))[179] = M1(3,19); (*(M2[231]))[285] = M1(3,24); (*(M2[231]))[286] = M1(3,25); (*(M2[231]))[291] = M1(3,26); (*(M2[231]))[306] = M1(3,27); 
(*(M2[232]))[203] = M1(4,20); (*(M2[232]))[205] = M1(4,21); (*(M2[232]))[216] = M1(4,22); (*(M2[232]))[252] = M1(4,23); (*(M2[232]))[341] = M1(4,28); 
(*(M2[233]))[243] = M1(1,1); (*(M2[233]))[246] = M1(1,4); (*(M2[233]))[247] = M1(1,5); (*(M2[233]))[248] = M1(1,6); (*(M2[233]))[249] = M1(1,7); (*(M2[233]))[250] = M1(1,8); (*(M2[233]))[251] = M1(1,9); (*(M2[233]))[261] = M1(1,10); (*(M2[233]))[262] = M1(1,11); (*(M2[233]))[263] = M1(1,12); (*(M2[233]))[264] = M1(1,13); (*(M2[233]))[265] = M1(1,14); (*(M2[233]))[266] = M1(1,15); (*(M2[233]))[274] = M1(1,16); (*(M2[233]))[275] = M1(1,17); (*(M2[233]))[276] = M1(1,18); (*(M2[233]))[282] = M1(1,19); (*(M2[233]))[363] = M1(1,24); (*(M2[233]))[364] = M1(1,25); (*(M2[233]))[365] = M1(1,26); (*(M2[233]))[371] = M1(1,27); 
(*(M2[234]))[244] = M1(2,2); (*(M2[234]))[246] = M1(2,4); (*(M2[234]))[247] = M1(2,5); (*(M2[234]))[248] = M1(2,6); (*(M2[234]))[249] = M1(2,7); (*(M2[234]))[250] = M1(2,8); (*(M2[234]))[251] = M1(2,9); (*(M2[234]))[261] = M1(2,10); (*(M2[234]))[262] = M1(2,11); (*(M2[234]))[263] = M1(2,12); (*(M2[234]))[264] = M1(2,13); (*(M2[234]))[265] = M1(2,14); (*(M2[234]))[266] = M1(2,15); (*(M2[234]))[274] = M1(2,16); (*(M2[234]))[275] = M1(2,17); (*(M2[234]))[276] = M1(2,18); (*(M2[234]))[282] = M1(2,19); (*(M2[234]))[363] = M1(2,24); (*(M2[234]))[364] = M1(2,25); (*(M2[234]))[365] = M1(2,26); (*(M2[234]))[371] = M1(2,27); 
(*(M2[235]))[245] = M1(3,3); (*(M2[235]))[246] = M1(3,4); (*(M2[235]))[247] = M1(3,5); (*(M2[235]))[248] = M1(3,6); (*(M2[235]))[249] = M1(3,7); (*(M2[235]))[250] = M1(3,8); (*(M2[235]))[251] = M1(3,9); (*(M2[235]))[261] = M1(3,10); (*(M2[235]))[262] = M1(3,11); (*(M2[235]))[263] = M1(3,12); (*(M2[235]))[264] = M1(3,13); (*(M2[235]))[265] = M1(3,14); (*(M2[235]))[266] = M1(3,15); (*(M2[235]))[274] = M1(3,16); (*(M2[235]))[275] = M1(3,17); (*(M2[235]))[276] = M1(3,18); (*(M2[235]))[282] = M1(3,19); (*(M2[235]))[363] = M1(3,24); (*(M2[235]))[364] = M1(3,25); (*(M2[235]))[365] = M1(3,26); (*(M2[235]))[371] = M1(3,27); 
(*(M2[236]))[221] = M1(0,0); (*(M2[236]))[225] = M1(0,4); (*(M2[236]))[226] = M1(0,5); (*(M2[236]))[227] = M1(0,6); (*(M2[236]))[228] = M1(0,7); (*(M2[236]))[229] = M1(0,8); (*(M2[236]))[230] = M1(0,9); (*(M2[236]))[246] = M1(0,10); (*(M2[236]))[247] = M1(0,11); (*(M2[236]))[248] = M1(0,12); (*(M2[236]))[249] = M1(0,13); (*(M2[236]))[250] = M1(0,14); (*(M2[236]))[251] = M1(0,15); (*(M2[236]))[264] = M1(0,16); (*(M2[236]))[265] = M1(0,17); (*(M2[236]))[266] = M1(0,18); (*(M2[236]))[276] = M1(0,19); (*(M2[236]))[353] = M1(0,24); (*(M2[236]))[354] = M1(0,25); (*(M2[236]))[355] = M1(0,26); (*(M2[236]))[365] = M1(0,27); 
(*(M2[237]))[222] = M1(1,1); (*(M2[237]))[225] = M1(1,4); (*(M2[237]))[226] = M1(1,5); (*(M2[237]))[227] = M1(1,6); (*(M2[237]))[228] = M1(1,7); (*(M2[237]))[229] = M1(1,8); (*(M2[237]))[230] = M1(1,9); (*(M2[237]))[246] = M1(1,10); (*(M2[237]))[247] = M1(1,11); (*(M2[237]))[248] = M1(1,12); (*(M2[237]))[249] = M1(1,13); (*(M2[237]))[250] = M1(1,14); (*(M2[237]))[251] = M1(1,15); (*(M2[237]))[264] = M1(1,16); (*(M2[237]))[265] = M1(1,17); (*(M2[237]))[266] = M1(1,18); (*(M2[237]))[276] = M1(1,19); (*(M2[237]))[353] = M1(1,24); (*(M2[237]))[354] = M1(1,25); (*(M2[237]))[355] = M1(1,26); (*(M2[237]))[365] = M1(1,27); 
(*(M2[238]))[223] = M1(2,2); (*(M2[238]))[225] = M1(2,4); (*(M2[238]))[226] = M1(2,5); (*(M2[238]))[227] = M1(2,6); (*(M2[238]))[228] = M1(2,7); (*(M2[238]))[229] = M1(2,8); (*(M2[238]))[230] = M1(2,9); (*(M2[238]))[246] = M1(2,10); (*(M2[238]))[247] = M1(2,11); (*(M2[238]))[248] = M1(2,12); (*(M2[238]))[249] = M1(2,13); (*(M2[238]))[250] = M1(2,14); (*(M2[238]))[251] = M1(2,15); (*(M2[238]))[264] = M1(2,16); (*(M2[238]))[265] = M1(2,17); (*(M2[238]))[266] = M1(2,18); (*(M2[238]))[276] = M1(2,19); (*(M2[238]))[353] = M1(2,24); (*(M2[238]))[354] = M1(2,25); (*(M2[238]))[355] = M1(2,26); (*(M2[238]))[365] = M1(2,27); 
(*(M2[239]))[224] = M1(3,3); (*(M2[239]))[225] = M1(3,4); (*(M2[239]))[226] = M1(3,5); (*(M2[239]))[227] = M1(3,6); (*(M2[239]))[228] = M1(3,7); (*(M2[239]))[229] = M1(3,8); (*(M2[239]))[230] = M1(3,9); (*(M2[239]))[246] = M1(3,10); (*(M2[239]))[247] = M1(3,11); (*(M2[239]))[248] = M1(3,12); (*(M2[239]))[249] = M1(3,13); (*(M2[239]))[250] = M1(3,14); (*(M2[239]))[251] = M1(3,15); (*(M2[239]))[264] = M1(3,16); (*(M2[239]))[265] = M1(3,17); (*(M2[239]))[266] = M1(3,18); (*(M2[239]))[276] = M1(3,19); (*(M2[239]))[353] = M1(3,24); (*(M2[239]))[354] = M1(3,25); (*(M2[239]))[355] = M1(3,26); (*(M2[239]))[365] = M1(3,27); 
(*(M2[240]))[253] = M1(0,0); (*(M2[240]))[258] = M1(0,4); (*(M2[240]))[259] = M1(0,5); (*(M2[240]))[260] = M1(0,6); (*(M2[240]))[262] = M1(0,7); (*(M2[240]))[263] = M1(0,8); (*(M2[240]))[265] = M1(0,9); (*(M2[240]))[268] = M1(0,10); (*(M2[240]))[269] = M1(0,11); (*(M2[240]))[270] = M1(0,12); (*(M2[240]))[272] = M1(0,13); (*(M2[240]))[273] = M1(0,14); (*(M2[240]))[275] = M1(0,15); (*(M2[240]))[278] = M1(0,16); (*(M2[240]))[279] = M1(0,17); (*(M2[240]))[281] = M1(0,18); (*(M2[240]))[284] = M1(0,19); (*(M2[240]))[367] = M1(0,24); (*(M2[240]))[368] = M1(0,25); (*(M2[240]))[370] = M1(0,26); (*(M2[240]))[373] = M1(0,27); 
(*(M2[241]))[254] = M1(1,1); (*(M2[241]))[258] = M1(1,4); (*(M2[241]))[259] = M1(1,5); (*(M2[241]))[260] = M1(1,6); (*(M2[241]))[262] = M1(1,7); (*(M2[241]))[263] = M1(1,8); (*(M2[241]))[265] = M1(1,9); (*(M2[241]))[268] = M1(1,10); (*(M2[241]))[269] = M1(1,11); (*(M2[241]))[270] = M1(1,12); (*(M2[241]))[272] = M1(1,13); (*(M2[241]))[273] = M1(1,14); (*(M2[241]))[275] = M1(1,15); (*(M2[241]))[278] = M1(1,16); (*(M2[241]))[279] = M1(1,17); (*(M2[241]))[281] = M1(1,18); (*(M2[241]))[284] = M1(1,19); (*(M2[241]))[367] = M1(1,24); (*(M2[241]))[368] = M1(1,25); (*(M2[241]))[370] = M1(1,26); (*(M2[241]))[373] = M1(1,27); 
(*(M2[242]))[255] = M1(2,2); (*(M2[242]))[258] = M1(2,4); (*(M2[242]))[259] = M1(2,5); (*(M2[242]))[260] = M1(2,6); (*(M2[242]))[262] = M1(2,7); (*(M2[242]))[263] = M1(2,8); (*(M2[242]))[265] = M1(2,9); (*(M2[242]))[268] = M1(2,10); (*(M2[242]))[269] = M1(2,11); (*(M2[242]))[270] = M1(2,12); (*(M2[242]))[272] = M1(2,13); (*(M2[242]))[273] = M1(2,14); (*(M2[242]))[275] = M1(2,15); (*(M2[242]))[278] = M1(2,16); (*(M2[242]))[279] = M1(2,17); (*(M2[242]))[281] = M1(2,18); (*(M2[242]))[284] = M1(2,19); (*(M2[242]))[367] = M1(2,24); (*(M2[242]))[368] = M1(2,25); (*(M2[242]))[370] = M1(2,26); (*(M2[242]))[373] = M1(2,27); 
(*(M2[243]))[256] = M1(3,3); (*(M2[243]))[258] = M1(3,4); (*(M2[243]))[259] = M1(3,5); (*(M2[243]))[260] = M1(3,6); (*(M2[243]))[262] = M1(3,7); (*(M2[243]))[263] = M1(3,8); (*(M2[243]))[265] = M1(3,9); (*(M2[243]))[268] = M1(3,10); (*(M2[243]))[269] = M1(3,11); (*(M2[243]))[270] = M1(3,12); (*(M2[243]))[272] = M1(3,13); (*(M2[243]))[273] = M1(3,14); (*(M2[243]))[275] = M1(3,15); (*(M2[243]))[278] = M1(3,16); (*(M2[243]))[279] = M1(3,17); (*(M2[243]))[281] = M1(3,18); (*(M2[243]))[284] = M1(3,19); (*(M2[243]))[367] = M1(3,24); (*(M2[243]))[368] = M1(3,25); (*(M2[243]))[370] = M1(3,26); (*(M2[243]))[373] = M1(3,27); 
(*(M2[244]))[322] = M1(4,20); (*(M2[244]))[324] = M1(4,21); (*(M2[244]))[329] = M1(4,22); (*(M2[244]))[338] = M1(4,23); (*(M2[244]))[398] = M1(4,28); 
(*(M2[245]))[238] = M1(0,0); (*(M2[245]))[243] = M1(0,4); (*(M2[245]))[244] = M1(0,5); (*(M2[245]))[245] = M1(0,6); (*(M2[245]))[247] = M1(0,7); (*(M2[245]))[248] = M1(0,8); (*(M2[245]))[250] = M1(0,9); (*(M2[245]))[258] = M1(0,10); (*(M2[245]))[259] = M1(0,11); (*(M2[245]))[260] = M1(0,12); (*(M2[245]))[262] = M1(0,13); (*(M2[245]))[263] = M1(0,14); (*(M2[245]))[265] = M1(0,15); (*(M2[245]))[272] = M1(0,16); (*(M2[245]))[273] = M1(0,17); (*(M2[245]))[275] = M1(0,18); (*(M2[245]))[281] = M1(0,19); (*(M2[245]))[361] = M1(0,24); (*(M2[245]))[362] = M1(0,25); (*(M2[245]))[364] = M1(0,26); (*(M2[245]))[370] = M1(0,27); 
(*(M2[246]))[239] = M1(1,1); (*(M2[246]))[243] = M1(1,4); (*(M2[246]))[244] = M1(1,5); (*(M2[246]))[245] = M1(1,6); (*(M2[246]))[247] = M1(1,7); (*(M2[246]))[248] = M1(1,8); (*(M2[246]))[250] = M1(1,9); (*(M2[246]))[258] = M1(1,10); (*(M2[246]))[259] = M1(1,11); (*(M2[246]))[260] = M1(1,12); (*(M2[246]))[262] = M1(1,13); (*(M2[246]))[263] = M1(1,14); (*(M2[246]))[265] = M1(1,15); (*(M2[246]))[272] = M1(1,16); (*(M2[246]))[273] = M1(1,17); (*(M2[246]))[275] = M1(1,18); (*(M2[246]))[281] = M1(1,19); (*(M2[246]))[361] = M1(1,24); (*(M2[246]))[362] = M1(1,25); (*(M2[246]))[364] = M1(1,26); (*(M2[246]))[370] = M1(1,27); 
(*(M2[247]))[240] = M1(2,2); (*(M2[247]))[243] = M1(2,4); (*(M2[247]))[244] = M1(2,5); (*(M2[247]))[245] = M1(2,6); (*(M2[247]))[247] = M1(2,7); (*(M2[247]))[248] = M1(2,8); (*(M2[247]))[250] = M1(2,9); (*(M2[247]))[258] = M1(2,10); (*(M2[247]))[259] = M1(2,11); (*(M2[247]))[260] = M1(2,12); (*(M2[247]))[262] = M1(2,13); (*(M2[247]))[263] = M1(2,14); (*(M2[247]))[265] = M1(2,15); (*(M2[247]))[272] = M1(2,16); (*(M2[247]))[273] = M1(2,17); (*(M2[247]))[275] = M1(2,18); (*(M2[247]))[281] = M1(2,19); (*(M2[247]))[361] = M1(2,24); (*(M2[247]))[362] = M1(2,25); (*(M2[247]))[364] = M1(2,26); (*(M2[247]))[370] = M1(2,27); 
(*(M2[248]))[241] = M1(3,3); (*(M2[248]))[243] = M1(3,4); (*(M2[248]))[244] = M1(3,5); (*(M2[248]))[245] = M1(3,6); (*(M2[248]))[247] = M1(3,7); (*(M2[248]))[248] = M1(3,8); (*(M2[248]))[250] = M1(3,9); (*(M2[248]))[258] = M1(3,10); (*(M2[248]))[259] = M1(3,11); (*(M2[248]))[260] = M1(3,12); (*(M2[248]))[262] = M1(3,13); (*(M2[248]))[263] = M1(3,14); (*(M2[248]))[265] = M1(3,15); (*(M2[248]))[272] = M1(3,16); (*(M2[248]))[273] = M1(3,17); (*(M2[248]))[275] = M1(3,18); (*(M2[248]))[281] = M1(3,19); (*(M2[248]))[361] = M1(3,24); (*(M2[248]))[362] = M1(3,25); (*(M2[248]))[364] = M1(3,26); (*(M2[248]))[370] = M1(3,27); 
(*(M2[249]))[312] = M1(4,20); (*(M2[249]))[314] = M1(4,21); (*(M2[249]))[319] = M1(4,22); (*(M2[249]))[335] = M1(4,23); (*(M2[249]))[389] = M1(4,28); 
(*(M2[250]))[217] = M1(0,0); (*(M2[250]))[222] = M1(0,4); (*(M2[250]))[223] = M1(0,5); (*(M2[250]))[224] = M1(0,6); (*(M2[250]))[226] = M1(0,7); (*(M2[250]))[227] = M1(0,8); (*(M2[250]))[229] = M1(0,9); (*(M2[250]))[243] = M1(0,10); (*(M2[250]))[244] = M1(0,11); (*(M2[250]))[245] = M1(0,12); (*(M2[250]))[247] = M1(0,13); (*(M2[250]))[248] = M1(0,14); (*(M2[250]))[250] = M1(0,15); (*(M2[250]))[262] = M1(0,16); (*(M2[250]))[263] = M1(0,17); (*(M2[250]))[265] = M1(0,18); (*(M2[250]))[275] = M1(0,19); (*(M2[250]))[351] = M1(0,24); (*(M2[250]))[352] = M1(0,25); (*(M2[250]))[354] = M1(0,26); (*(M2[250]))[364] = M1(0,27); 
(*(M2[251]))[218] = M1(1,1); (*(M2[251]))[222] = M1(1,4); (*(M2[251]))[223] = M1(1,5); (*(M2[251]))[224] = M1(1,6); (*(M2[251]))[226] = M1(1,7); (*(M2[251]))[227] = M1(1,8); (*(M2[251]))[229] = M1(1,9); (*(M2[251]))[243] = M1(1,10); (*(M2[251]))[244] = M1(1,11); (*(M2[251]))[245] = M1(1,12); (*(M2[251]))[247] = M1(1,13); (*(M2[251]))[248] = M1(1,14); (*(M2[251]))[250] = M1(1,15); (*(M2[251]))[262] = M1(1,16); (*(M2[251]))[263] = M1(1,17); (*(M2[251]))[265] = M1(1,18); (*(M2[251]))[275] = M1(1,19); (*(M2[251]))[351] = M1(1,24); (*(M2[251]))[352] = M1(1,25); (*(M2[251]))[354] = M1(1,26); (*(M2[251]))[364] = M1(1,27); 
(*(M2[252]))[219] = M1(2,2); (*(M2[252]))[222] = M1(2,4); (*(M2[252]))[223] = M1(2,5); (*(M2[252]))[224] = M1(2,6); (*(M2[252]))[226] = M1(2,7); (*(M2[252]))[227] = M1(2,8); (*(M2[252]))[229] = M1(2,9); (*(M2[252]))[243] = M1(2,10); (*(M2[252]))[244] = M1(2,11); (*(M2[252]))[245] = M1(2,12); (*(M2[252]))[247] = M1(2,13); (*(M2[252]))[248] = M1(2,14); (*(M2[252]))[250] = M1(2,15); (*(M2[252]))[262] = M1(2,16); (*(M2[252]))[263] = M1(2,17); (*(M2[252]))[265] = M1(2,18); (*(M2[252]))[275] = M1(2,19); (*(M2[252]))[351] = M1(2,24); (*(M2[252]))[352] = M1(2,25); (*(M2[252]))[354] = M1(2,26); (*(M2[252]))[364] = M1(2,27); 
(*(M2[253]))[220] = M1(3,3); (*(M2[253]))[222] = M1(3,4); (*(M2[253]))[223] = M1(3,5); (*(M2[253]))[224] = M1(3,6); (*(M2[253]))[226] = M1(3,7); (*(M2[253]))[227] = M1(3,8); (*(M2[253]))[229] = M1(3,9); (*(M2[253]))[243] = M1(3,10); (*(M2[253]))[244] = M1(3,11); (*(M2[253]))[245] = M1(3,12); (*(M2[253]))[247] = M1(3,13); (*(M2[253]))[248] = M1(3,14); (*(M2[253]))[250] = M1(3,15); (*(M2[253]))[262] = M1(3,16); (*(M2[253]))[263] = M1(3,17); (*(M2[253]))[265] = M1(3,18); (*(M2[253]))[275] = M1(3,19); (*(M2[253]))[351] = M1(3,24); (*(M2[253]))[352] = M1(3,25); (*(M2[253]))[354] = M1(3,26); (*(M2[253]))[364] = M1(3,27); 
(*(M2[254]))[297] = M1(4,20); (*(M2[254]))[299] = M1(4,21); (*(M2[254]))[304] = M1(4,22); (*(M2[254]))[329] = M1(4,23); (*(M2[254]))[383] = M1(4,28); 
(*(M2[255]))[233] = M1(0,0); (*(M2[255]))[239] = M1(0,4); (*(M2[255]))[240] = M1(0,5); (*(M2[255]))[241] = M1(0,6); (*(M2[255]))[244] = M1(0,7); (*(M2[255]))[245] = M1(0,8); (*(M2[255]))[248] = M1(0,9); (*(M2[255]))[254] = M1(0,10); (*(M2[255]))[255] = M1(0,11); (*(M2[255]))[256] = M1(0,12); (*(M2[255]))[259] = M1(0,13); (*(M2[255]))[260] = M1(0,14); (*(M2[255]))[263] = M1(0,15); (*(M2[255]))[269] = M1(0,16); (*(M2[255]))[270] = M1(0,17); (*(M2[255]))[273] = M1(0,18); (*(M2[255]))[279] = M1(0,19); (*(M2[255]))[358] = M1(0,24); (*(M2[255]))[359] = M1(0,25); (*(M2[255]))[362] = M1(0,26); (*(M2[255]))[368] = M1(0,27); 
(*(M2[256]))[234] = M1(1,1); (*(M2[256]))[239] = M1(1,4); (*(M2[256]))[240] = M1(1,5); (*(M2[256]))[241] = M1(1,6); (*(M2[256]))[244] = M1(1,7); (*(M2[256]))[245] = M1(1,8); (*(M2[256]))[248] = M1(1,9); (*(M2[256]))[254] = M1(1,10); (*(M2[256]))[255] = M1(1,11); (*(M2[256]))[256] = M1(1,12); (*(M2[256]))[259] = M1(1,13); (*(M2[256]))[260] = M1(1,14); (*(M2[256]))[263] = M1(1,15); (*(M2[256]))[269] = M1(1,16); (*(M2[256]))[270] = M1(1,17); (*(M2[256]))[273] = M1(1,18); (*(M2[256]))[279] = M1(1,19); (*(M2[256]))[358] = M1(1,24); (*(M2[256]))[359] = M1(1,25); (*(M2[256]))[362] = M1(1,26); (*(M2[256]))[368] = M1(1,27); 
(*(M2[257]))[235] = M1(2,2); (*(M2[257]))[239] = M1(2,4); (*(M2[257]))[240] = M1(2,5); (*(M2[257]))[241] = M1(2,6); (*(M2[257]))[244] = M1(2,7); (*(M2[257]))[245] = M1(2,8); (*(M2[257]))[248] = M1(2,9); (*(M2[257]))[254] = M1(2,10); (*(M2[257]))[255] = M1(2,11); (*(M2[257]))[256] = M1(2,12); (*(M2[257]))[259] = M1(2,13); (*(M2[257]))[260] = M1(2,14); (*(M2[257]))[263] = M1(2,15); (*(M2[257]))[269] = M1(2,16); (*(M2[257]))[270] = M1(2,17); (*(M2[257]))[273] = M1(2,18); (*(M2[257]))[279] = M1(2,19); (*(M2[257]))[358] = M1(2,24); (*(M2[257]))[359] = M1(2,25); (*(M2[257]))[362] = M1(2,26); (*(M2[257]))[368] = M1(2,27); 
(*(M2[258]))[236] = M1(3,3); (*(M2[258]))[239] = M1(3,4); (*(M2[258]))[240] = M1(3,5); (*(M2[258]))[241] = M1(3,6); (*(M2[258]))[244] = M1(3,7); (*(M2[258]))[245] = M1(3,8); (*(M2[258]))[248] = M1(3,9); (*(M2[258]))[254] = M1(3,10); (*(M2[258]))[255] = M1(3,11); (*(M2[258]))[256] = M1(3,12); (*(M2[258]))[259] = M1(3,13); (*(M2[258]))[260] = M1(3,14); (*(M2[258]))[263] = M1(3,15); (*(M2[258]))[269] = M1(3,16); (*(M2[258]))[270] = M1(3,17); (*(M2[258]))[273] = M1(3,18); (*(M2[258]))[279] = M1(3,19); (*(M2[258]))[358] = M1(3,24); (*(M2[258]))[359] = M1(3,25); (*(M2[258]))[362] = M1(3,26); (*(M2[258]))[368] = M1(3,27); 
(*(M2[259]))[308] = M1(4,20); (*(M2[259]))[310] = M1(4,21); (*(M2[259]))[317] = M1(4,22); (*(M2[259]))[333] = M1(4,23); (*(M2[259]))[387] = M1(4,28); 
(*(M2[260]))[212] = M1(0,0); (*(M2[260]))[218] = M1(0,4); (*(M2[260]))[219] = M1(0,5); (*(M2[260]))[220] = M1(0,6); (*(M2[260]))[223] = M1(0,7); (*(M2[260]))[224] = M1(0,8); (*(M2[260]))[227] = M1(0,9); (*(M2[260]))[239] = M1(0,10); (*(M2[260]))[240] = M1(0,11); (*(M2[260]))[241] = M1(0,12); (*(M2[260]))[244] = M1(0,13); (*(M2[260]))[245] = M1(0,14); (*(M2[260]))[248] = M1(0,15); (*(M2[260]))[259] = M1(0,16); (*(M2[260]))[260] = M1(0,17); (*(M2[260]))[263] = M1(0,18); (*(M2[260]))[273] = M1(0,19); (*(M2[260]))[348] = M1(0,24); (*(M2[260]))[349] = M1(0,25); (*(M2[260]))[352] = M1(0,26); (*(M2[260]))[362] = M1(0,27); 
(*(M2[261]))[213] = M1(1,1); (*(M2[261]))[218] = M1(1,4); (*(M2[261]))[219] = M1(1,5); (*(M2[261]))[220] = M1(1,6); (*(M2[261]))[223] = M1(1,7); (*(M2[261]))[224] = M1(1,8); (*(M2[261]))[227] = M1(1,9); (*(M2[261]))[239] = M1(1,10); (*(M2[261]))[240] = M1(1,11); (*(M2[261]))[241] = M1(1,12); (*(M2[261]))[244] = M1(1,13); (*(M2[261]))[245] = M1(1,14); (*(M2[261]))[248] = M1(1,15); (*(M2[261]))[259] = M1(1,16); (*(M2[261]))[260] = M1(1,17); (*(M2[261]))[263] = M1(1,18); (*(M2[261]))[273] = M1(1,19); (*(M2[261]))[348] = M1(1,24); (*(M2[261]))[349] = M1(1,25); (*(M2[261]))[352] = M1(1,26); (*(M2[261]))[362] = M1(1,27); 
(*(M2[262]))[214] = M1(2,2); (*(M2[262]))[218] = M1(2,4); (*(M2[262]))[219] = M1(2,5); (*(M2[262]))[220] = M1(2,6); (*(M2[262]))[223] = M1(2,7); (*(M2[262]))[224] = M1(2,8); (*(M2[262]))[227] = M1(2,9); (*(M2[262]))[239] = M1(2,10); (*(M2[262]))[240] = M1(2,11); (*(M2[262]))[241] = M1(2,12); (*(M2[262]))[244] = M1(2,13); (*(M2[262]))[245] = M1(2,14); (*(M2[262]))[248] = M1(2,15); (*(M2[262]))[259] = M1(2,16); (*(M2[262]))[260] = M1(2,17); (*(M2[262]))[263] = M1(2,18); (*(M2[262]))[273] = M1(2,19); (*(M2[262]))[348] = M1(2,24); (*(M2[262]))[349] = M1(2,25); (*(M2[262]))[352] = M1(2,26); (*(M2[262]))[362] = M1(2,27); 
(*(M2[263]))[215] = M1(3,3); (*(M2[263]))[218] = M1(3,4); (*(M2[263]))[219] = M1(3,5); (*(M2[263]))[220] = M1(3,6); (*(M2[263]))[223] = M1(3,7); (*(M2[263]))[224] = M1(3,8); (*(M2[263]))[227] = M1(3,9); (*(M2[263]))[239] = M1(3,10); (*(M2[263]))[240] = M1(3,11); (*(M2[263]))[241] = M1(3,12); (*(M2[263]))[244] = M1(3,13); (*(M2[263]))[245] = M1(3,14); (*(M2[263]))[248] = M1(3,15); (*(M2[263]))[259] = M1(3,16); (*(M2[263]))[260] = M1(3,17); (*(M2[263]))[263] = M1(3,18); (*(M2[263]))[273] = M1(3,19); (*(M2[263]))[348] = M1(3,24); (*(M2[263]))[349] = M1(3,25); (*(M2[263]))[352] = M1(3,26); (*(M2[263]))[362] = M1(3,27); 
(*(M2[264]))[293] = M1(4,20); (*(M2[264]))[295] = M1(4,21); (*(M2[264]))[302] = M1(4,22); (*(M2[264]))[327] = M1(4,23); (*(M2[264]))[381] = M1(4,28); 
(*(M2[265]))[206] = M1(0,0); (*(M2[265]))[213] = M1(0,4); (*(M2[265]))[214] = M1(0,5); (*(M2[265]))[215] = M1(0,6); (*(M2[265]))[219] = M1(0,7); (*(M2[265]))[220] = M1(0,8); (*(M2[265]))[224] = M1(0,9); (*(M2[265]))[234] = M1(0,10); (*(M2[265]))[235] = M1(0,11); (*(M2[265]))[236] = M1(0,12); (*(M2[265]))[240] = M1(0,13); (*(M2[265]))[241] = M1(0,14); (*(M2[265]))[245] = M1(0,15); (*(M2[265]))[255] = M1(0,16); (*(M2[265]))[256] = M1(0,17); (*(M2[265]))[260] = M1(0,18); (*(M2[265]))[270] = M1(0,19); (*(M2[265]))[344] = M1(0,24); (*(M2[265]))[345] = M1(0,25); (*(M2[265]))[349] = M1(0,26); (*(M2[265]))[359] = M1(0,27); 
(*(M2[266]))[207] = M1(1,1); (*(M2[266]))[213] = M1(1,4); (*(M2[266]))[214] = M1(1,5); (*(M2[266]))[215] = M1(1,6); (*(M2[266]))[219] = M1(1,7); (*(M2[266]))[220] = M1(1,8); (*(M2[266]))[224] = M1(1,9); (*(M2[266]))[234] = M1(1,10); (*(M2[266]))[235] = M1(1,11); (*(M2[266]))[236] = M1(1,12); (*(M2[266]))[240] = M1(1,13); (*(M2[266]))[241] = M1(1,14); (*(M2[266]))[245] = M1(1,15); (*(M2[266]))[255] = M1(1,16); (*(M2[266]))[256] = M1(1,17); (*(M2[266]))[260] = M1(1,18); (*(M2[266]))[270] = M1(1,19); (*(M2[266]))[344] = M1(1,24); (*(M2[266]))[345] = M1(1,25); (*(M2[266]))[349] = M1(1,26); (*(M2[266]))[359] = M1(1,27); 
(*(M2[267]))[208] = M1(2,2); (*(M2[267]))[213] = M1(2,4); (*(M2[267]))[214] = M1(2,5); (*(M2[267]))[215] = M1(2,6); (*(M2[267]))[219] = M1(2,7); (*(M2[267]))[220] = M1(2,8); (*(M2[267]))[224] = M1(2,9); (*(M2[267]))[234] = M1(2,10); (*(M2[267]))[235] = M1(2,11); (*(M2[267]))[236] = M1(2,12); (*(M2[267]))[240] = M1(2,13); (*(M2[267]))[241] = M1(2,14); (*(M2[267]))[245] = M1(2,15); (*(M2[267]))[255] = M1(2,16); (*(M2[267]))[256] = M1(2,17); (*(M2[267]))[260] = M1(2,18); (*(M2[267]))[270] = M1(2,19); (*(M2[267]))[344] = M1(2,24); (*(M2[267]))[345] = M1(2,25); (*(M2[267]))[349] = M1(2,26); (*(M2[267]))[359] = M1(2,27); 
(*(M2[268]))[209] = M1(3,3); (*(M2[268]))[213] = M1(3,4); (*(M2[268]))[214] = M1(3,5); (*(M2[268]))[215] = M1(3,6); (*(M2[268]))[219] = M1(3,7); (*(M2[268]))[220] = M1(3,8); (*(M2[268]))[224] = M1(3,9); (*(M2[268]))[234] = M1(3,10); (*(M2[268]))[235] = M1(3,11); (*(M2[268]))[236] = M1(3,12); (*(M2[268]))[240] = M1(3,13); (*(M2[268]))[241] = M1(3,14); (*(M2[268]))[245] = M1(3,15); (*(M2[268]))[255] = M1(3,16); (*(M2[268]))[256] = M1(3,17); (*(M2[268]))[260] = M1(3,18); (*(M2[268]))[270] = M1(3,19); (*(M2[268]))[344] = M1(3,24); (*(M2[268]))[345] = M1(3,25); (*(M2[268]))[349] = M1(3,26); (*(M2[268]))[359] = M1(3,27); 
(*(M2[269]))[288] = M1(4,20); (*(M2[269]))[290] = M1(4,21); (*(M2[269]))[299] = M1(4,22); (*(M2[269]))[324] = M1(4,23); (*(M2[269]))[378] = M1(4,28); 
(*(M2[270]))[252] = M1(0,0); (*(M2[270]))[257] = M1(0,4); (*(M2[270]))[258] = M1(0,5); (*(M2[270]))[259] = M1(0,6); (*(M2[270]))[261] = M1(0,7); (*(M2[270]))[262] = M1(0,8); (*(M2[270]))[264] = M1(0,9); (*(M2[270]))[267] = M1(0,10); (*(M2[270]))[268] = M1(0,11); (*(M2[270]))[269] = M1(0,12); (*(M2[270]))[271] = M1(0,13); (*(M2[270]))[272] = M1(0,14); (*(M2[270]))[274] = M1(0,15); (*(M2[270]))[277] = M1(0,16); (*(M2[270]))[278] = M1(0,17); (*(M2[270]))[280] = M1(0,18); (*(M2[270]))[283] = M1(0,19); (*(M2[270]))[366] = M1(0,24); (*(M2[270]))[367] = M1(0,25); (*(M2[270]))[369] = M1(0,26); (*(M2[270]))[372] = M1(0,27); 
(*(M2[271]))[253] = M1(1,1); (*(M2[271]))[257] = M1(1,4); (*(M2[271]))[258] = M1(1,5); (*(M2[271]))[259] = M1(1,6); (*(M2[271]))[261] = M1(1,7); (*(M2[271]))[262] = M1(1,8); (*(M2[271]))[264] = M1(1,9); (*(M2[271]))[267] = M1(1,10); (*(M2[271]))[268] = M1(1,11); (*(M2[271]))[269] = M1(1,12); (*(M2[271]))[271] = M1(1,13); (*(M2[271]))[272] = M1(1,14); (*(M2[271]))[274] = M1(1,15); (*(M2[271]))[277] = M1(1,16); (*(M2[271]))[278] = M1(1,17); (*(M2[271]))[280] = M1(1,18); (*(M2[271]))[283] = M1(1,19); (*(M2[271]))[366] = M1(1,24); (*(M2[271]))[367] = M1(1,25); (*(M2[271]))[369] = M1(1,26); (*(M2[271]))[372] = M1(1,27); 
(*(M2[272]))[254] = M1(2,2); (*(M2[272]))[257] = M1(2,4); (*(M2[272]))[258] = M1(2,5); (*(M2[272]))[259] = M1(2,6); (*(M2[272]))[261] = M1(2,7); (*(M2[272]))[262] = M1(2,8); (*(M2[272]))[264] = M1(2,9); (*(M2[272]))[267] = M1(2,10); (*(M2[272]))[268] = M1(2,11); (*(M2[272]))[269] = M1(2,12); (*(M2[272]))[271] = M1(2,13); (*(M2[272]))[272] = M1(2,14); (*(M2[272]))[274] = M1(2,15); (*(M2[272]))[277] = M1(2,16); (*(M2[272]))[278] = M1(2,17); (*(M2[272]))[280] = M1(2,18); (*(M2[272]))[283] = M1(2,19); (*(M2[272]))[366] = M1(2,24); (*(M2[272]))[367] = M1(2,25); (*(M2[272]))[369] = M1(2,26); (*(M2[272]))[372] = M1(2,27); 
(*(M2[273]))[255] = M1(3,3); (*(M2[273]))[257] = M1(3,4); (*(M2[273]))[258] = M1(3,5); (*(M2[273]))[259] = M1(3,6); (*(M2[273]))[261] = M1(3,7); (*(M2[273]))[262] = M1(3,8); (*(M2[273]))[264] = M1(3,9); (*(M2[273]))[267] = M1(3,10); (*(M2[273]))[268] = M1(3,11); (*(M2[273]))[269] = M1(3,12); (*(M2[273]))[271] = M1(3,13); (*(M2[273]))[272] = M1(3,14); (*(M2[273]))[274] = M1(3,15); (*(M2[273]))[277] = M1(3,16); (*(M2[273]))[278] = M1(3,17); (*(M2[273]))[280] = M1(3,18); (*(M2[273]))[283] = M1(3,19); (*(M2[273]))[366] = M1(3,24); (*(M2[273]))[367] = M1(3,25); (*(M2[273]))[369] = M1(3,26); (*(M2[273]))[372] = M1(3,27); 
(*(M2[274]))[321] = M1(4,20); (*(M2[274]))[323] = M1(4,21); (*(M2[274]))[328] = M1(4,22); (*(M2[274]))[337] = M1(4,23); (*(M2[274]))[397] = M1(4,28); 
(*(M2[275]))[237] = M1(0,0); (*(M2[275]))[242] = M1(0,4); (*(M2[275]))[243] = M1(0,5); (*(M2[275]))[244] = M1(0,6); (*(M2[275]))[246] = M1(0,7); (*(M2[275]))[247] = M1(0,8); (*(M2[275]))[249] = M1(0,9); (*(M2[275]))[257] = M1(0,10); (*(M2[275]))[258] = M1(0,11); (*(M2[275]))[259] = M1(0,12); (*(M2[275]))[261] = M1(0,13); (*(M2[275]))[262] = M1(0,14); (*(M2[275]))[264] = M1(0,15); (*(M2[275]))[271] = M1(0,16); (*(M2[275]))[272] = M1(0,17); (*(M2[275]))[274] = M1(0,18); (*(M2[275]))[280] = M1(0,19); (*(M2[275]))[360] = M1(0,24); (*(M2[275]))[361] = M1(0,25); (*(M2[275]))[363] = M1(0,26); (*(M2[275]))[369] = M1(0,27); 
(*(M2[276]))[238] = M1(1,1); (*(M2[276]))[242] = M1(1,4); (*(M2[276]))[243] = M1(1,5); (*(M2[276]))[244] = M1(1,6); (*(M2[276]))[246] = M1(1,7); (*(M2[276]))[247] = M1(1,8); (*(M2[276]))[249] = M1(1,9); (*(M2[276]))[257] = M1(1,10); (*(M2[276]))[258] = M1(1,11); (*(M2[276]))[259] = M1(1,12); (*(M2[276]))[261] = M1(1,13); (*(M2[276]))[262] = M1(1,14); (*(M2[276]))[264] = M1(1,15); (*(M2[276]))[271] = M1(1,16); (*(M2[276]))[272] = M1(1,17); (*(M2[276]))[274] = M1(1,18); (*(M2[276]))[280] = M1(1,19); (*(M2[276]))[360] = M1(1,24); (*(M2[276]))[361] = M1(1,25); (*(M2[276]))[363] = M1(1,26); (*(M2[276]))[369] = M1(1,27); 
(*(M2[277]))[239] = M1(2,2); (*(M2[277]))[242] = M1(2,4); (*(M2[277]))[243] = M1(2,5); (*(M2[277]))[244] = M1(2,6); (*(M2[277]))[246] = M1(2,7); (*(M2[277]))[247] = M1(2,8); (*(M2[277]))[249] = M1(2,9); (*(M2[277]))[257] = M1(2,10); (*(M2[277]))[258] = M1(2,11); (*(M2[277]))[259] = M1(2,12); (*(M2[277]))[261] = M1(2,13); (*(M2[277]))[262] = M1(2,14); (*(M2[277]))[264] = M1(2,15); (*(M2[277]))[271] = M1(2,16); (*(M2[277]))[272] = M1(2,17); (*(M2[277]))[274] = M1(2,18); (*(M2[277]))[280] = M1(2,19); (*(M2[277]))[360] = M1(2,24); (*(M2[277]))[361] = M1(2,25); (*(M2[277]))[363] = M1(2,26); (*(M2[277]))[369] = M1(2,27); 
(*(M2[278]))[240] = M1(3,3); (*(M2[278]))[242] = M1(3,4); (*(M2[278]))[243] = M1(3,5); (*(M2[278]))[244] = M1(3,6); (*(M2[278]))[246] = M1(3,7); (*(M2[278]))[247] = M1(3,8); (*(M2[278]))[249] = M1(3,9); (*(M2[278]))[257] = M1(3,10); (*(M2[278]))[258] = M1(3,11); (*(M2[278]))[259] = M1(3,12); (*(M2[278]))[261] = M1(3,13); (*(M2[278]))[262] = M1(3,14); (*(M2[278]))[264] = M1(3,15); (*(M2[278]))[271] = M1(3,16); (*(M2[278]))[272] = M1(3,17); (*(M2[278]))[274] = M1(3,18); (*(M2[278]))[280] = M1(3,19); (*(M2[278]))[360] = M1(3,24); (*(M2[278]))[361] = M1(3,25); (*(M2[278]))[363] = M1(3,26); (*(M2[278]))[369] = M1(3,27); 
(*(M2[279]))[311] = M1(4,20); (*(M2[279]))[313] = M1(4,21); (*(M2[279]))[318] = M1(4,22); (*(M2[279]))[334] = M1(4,23); (*(M2[279]))[388] = M1(4,28); 
(*(M2[280]))[216] = M1(0,0); (*(M2[280]))[221] = M1(0,4); (*(M2[280]))[222] = M1(0,5); (*(M2[280]))[223] = M1(0,6); (*(M2[280]))[225] = M1(0,7); (*(M2[280]))[226] = M1(0,8); (*(M2[280]))[228] = M1(0,9); (*(M2[280]))[242] = M1(0,10); (*(M2[280]))[243] = M1(0,11); (*(M2[280]))[244] = M1(0,12); (*(M2[280]))[246] = M1(0,13); (*(M2[280]))[247] = M1(0,14); (*(M2[280]))[249] = M1(0,15); (*(M2[280]))[261] = M1(0,16); (*(M2[280]))[262] = M1(0,17); (*(M2[280]))[264] = M1(0,18); (*(M2[280]))[274] = M1(0,19); (*(M2[280]))[350] = M1(0,24); (*(M2[280]))[351] = M1(0,25); (*(M2[280]))[353] = M1(0,26); (*(M2[280]))[363] = M1(0,27); 
(*(M2[281]))[217] = M1(1,1); (*(M2[281]))[221] = M1(1,4); (*(M2[281]))[222] = M1(1,5); (*(M2[281]))[223] = M1(1,6); (*(M2[281]))[225] = M1(1,7); (*(M2[281]))[226] = M1(1,8); (*(M2[281]))[228] = M1(1,9); (*(M2[281]))[242] = M1(1,10); (*(M2[281]))[243] = M1(1,11); (*(M2[281]))[244] = M1(1,12); (*(M2[281]))[246] = M1(1,13); (*(M2[281]))[247] = M1(1,14); (*(M2[281]))[249] = M1(1,15); (*(M2[281]))[261] = M1(1,16); (*(M2[281]))[262] = M1(1,17); (*(M2[281]))[264] = M1(1,18); (*(M2[281]))[274] = M1(1,19); (*(M2[281]))[350] = M1(1,24); (*(M2[281]))[351] = M1(1,25); (*(M2[281]))[353] = M1(1,26); (*(M2[281]))[363] = M1(1,27); 
(*(M2[282]))[218] = M1(2,2); (*(M2[282]))[221] = M1(2,4); (*(M2[282]))[222] = M1(2,5); (*(M2[282]))[223] = M1(2,6); (*(M2[282]))[225] = M1(2,7); (*(M2[282]))[226] = M1(2,8); (*(M2[282]))[228] = M1(2,9); (*(M2[282]))[242] = M1(2,10); (*(M2[282]))[243] = M1(2,11); (*(M2[282]))[244] = M1(2,12); (*(M2[282]))[246] = M1(2,13); (*(M2[282]))[247] = M1(2,14); (*(M2[282]))[249] = M1(2,15); (*(M2[282]))[261] = M1(2,16); (*(M2[282]))[262] = M1(2,17); (*(M2[282]))[264] = M1(2,18); (*(M2[282]))[274] = M1(2,19); (*(M2[282]))[350] = M1(2,24); (*(M2[282]))[351] = M1(2,25); (*(M2[282]))[353] = M1(2,26); (*(M2[282]))[363] = M1(2,27); 
(*(M2[283]))[219] = M1(3,3); (*(M2[283]))[221] = M1(3,4); (*(M2[283]))[222] = M1(3,5); (*(M2[283]))[223] = M1(3,6); (*(M2[283]))[225] = M1(3,7); (*(M2[283]))[226] = M1(3,8); (*(M2[283]))[228] = M1(3,9); (*(M2[283]))[242] = M1(3,10); (*(M2[283]))[243] = M1(3,11); (*(M2[283]))[244] = M1(3,12); (*(M2[283]))[246] = M1(3,13); (*(M2[283]))[247] = M1(3,14); (*(M2[283]))[249] = M1(3,15); (*(M2[283]))[261] = M1(3,16); (*(M2[283]))[262] = M1(3,17); (*(M2[283]))[264] = M1(3,18); (*(M2[283]))[274] = M1(3,19); (*(M2[283]))[350] = M1(3,24); (*(M2[283]))[351] = M1(3,25); (*(M2[283]))[353] = M1(3,26); (*(M2[283]))[363] = M1(3,27); 
(*(M2[284]))[296] = M1(4,20); (*(M2[284]))[298] = M1(4,21); (*(M2[284]))[303] = M1(4,22); (*(M2[284]))[328] = M1(4,23); (*(M2[284]))[382] = M1(4,28); 
(*(M2[285]))[232] = M1(0,0); (*(M2[285]))[238] = M1(0,4); (*(M2[285]))[239] = M1(0,5); (*(M2[285]))[240] = M1(0,6); (*(M2[285]))[243] = M1(0,7); (*(M2[285]))[244] = M1(0,8); (*(M2[285]))[247] = M1(0,9); (*(M2[285]))[253] = M1(0,10); (*(M2[285]))[254] = M1(0,11); (*(M2[285]))[255] = M1(0,12); (*(M2[285]))[258] = M1(0,13); (*(M2[285]))[259] = M1(0,14); (*(M2[285]))[262] = M1(0,15); (*(M2[285]))[268] = M1(0,16); (*(M2[285]))[269] = M1(0,17); (*(M2[285]))[272] = M1(0,18); (*(M2[285]))[278] = M1(0,19); (*(M2[285]))[357] = M1(0,24); (*(M2[285]))[358] = M1(0,25); (*(M2[285]))[361] = M1(0,26); (*(M2[285]))[367] = M1(0,27); 
(*(M2[286]))[233] = M1(1,1); (*(M2[286]))[238] = M1(1,4); (*(M2[286]))[239] = M1(1,5); (*(M2[286]))[240] = M1(1,6); (*(M2[286]))[243] = M1(1,7); (*(M2[286]))[244] = M1(1,8); (*(M2[286]))[247] = M1(1,9); (*(M2[286]))[253] = M1(1,10); (*(M2[286]))[254] = M1(1,11); (*(M2[286]))[255] = M1(1,12); (*(M2[286]))[258] = M1(1,13); (*(M2[286]))[259] = M1(1,14); (*(M2[286]))[262] = M1(1,15); (*(M2[286]))[268] = M1(1,16); (*(M2[286]))[269] = M1(1,17); (*(M2[286]))[272] = M1(1,18); (*(M2[286]))[278] = M1(1,19); (*(M2[286]))[357] = M1(1,24); (*(M2[286]))[358] = M1(1,25); (*(M2[286]))[361] = M1(1,26); (*(M2[286]))[367] = M1(1,27); 
(*(M2[287]))[234] = M1(2,2); (*(M2[287]))[238] = M1(2,4); (*(M2[287]))[239] = M1(2,5); (*(M2[287]))[240] = M1(2,6); (*(M2[287]))[243] = M1(2,7); (*(M2[287]))[244] = M1(2,8); (*(M2[287]))[247] = M1(2,9); (*(M2[287]))[253] = M1(2,10); (*(M2[287]))[254] = M1(2,11); (*(M2[287]))[255] = M1(2,12); (*(M2[287]))[258] = M1(2,13); (*(M2[287]))[259] = M1(2,14); (*(M2[287]))[262] = M1(2,15); (*(M2[287]))[268] = M1(2,16); (*(M2[287]))[269] = M1(2,17); (*(M2[287]))[272] = M1(2,18); (*(M2[287]))[278] = M1(2,19); (*(M2[287]))[357] = M1(2,24); (*(M2[287]))[358] = M1(2,25); (*(M2[287]))[361] = M1(2,26); (*(M2[287]))[367] = M1(2,27); 
(*(M2[288]))[235] = M1(3,3); (*(M2[288]))[238] = M1(3,4); (*(M2[288]))[239] = M1(3,5); (*(M2[288]))[240] = M1(3,6); (*(M2[288]))[243] = M1(3,7); (*(M2[288]))[244] = M1(3,8); (*(M2[288]))[247] = M1(3,9); (*(M2[288]))[253] = M1(3,10); (*(M2[288]))[254] = M1(3,11); (*(M2[288]))[255] = M1(3,12); (*(M2[288]))[258] = M1(3,13); (*(M2[288]))[259] = M1(3,14); (*(M2[288]))[262] = M1(3,15); (*(M2[288]))[268] = M1(3,16); (*(M2[288]))[269] = M1(3,17); (*(M2[288]))[272] = M1(3,18); (*(M2[288]))[278] = M1(3,19); (*(M2[288]))[357] = M1(3,24); (*(M2[288]))[358] = M1(3,25); (*(M2[288]))[361] = M1(3,26); (*(M2[288]))[367] = M1(3,27); 
(*(M2[289]))[307] = M1(4,20); (*(M2[289]))[309] = M1(4,21); (*(M2[289]))[316] = M1(4,22); (*(M2[289]))[332] = M1(4,23); (*(M2[289]))[386] = M1(4,28); 
(*(M2[290]))[211] = M1(0,0); (*(M2[290]))[217] = M1(0,4); (*(M2[290]))[218] = M1(0,5); (*(M2[290]))[219] = M1(0,6); (*(M2[290]))[222] = M1(0,7); (*(M2[290]))[223] = M1(0,8); (*(M2[290]))[226] = M1(0,9); (*(M2[290]))[238] = M1(0,10); (*(M2[290]))[239] = M1(0,11); (*(M2[290]))[240] = M1(0,12); (*(M2[290]))[243] = M1(0,13); (*(M2[290]))[244] = M1(0,14); (*(M2[290]))[247] = M1(0,15); (*(M2[290]))[258] = M1(0,16); (*(M2[290]))[259] = M1(0,17); (*(M2[290]))[262] = M1(0,18); (*(M2[290]))[272] = M1(0,19); (*(M2[290]))[347] = M1(0,24); (*(M2[290]))[348] = M1(0,25); (*(M2[290]))[351] = M1(0,26); (*(M2[290]))[361] = M1(0,27); 
(*(M2[291]))[212] = M1(1,1); (*(M2[291]))[217] = M1(1,4); (*(M2[291]))[218] = M1(1,5); (*(M2[291]))[219] = M1(1,6); (*(M2[291]))[222] = M1(1,7); (*(M2[291]))[223] = M1(1,8); (*(M2[291]))[226] = M1(1,9); (*(M2[291]))[238] = M1(1,10); (*(M2[291]))[239] = M1(1,11); (*(M2[291]))[240] = M1(1,12); (*(M2[291]))[243] = M1(1,13); (*(M2[291]))[244] = M1(1,14); (*(M2[291]))[247] = M1(1,15); (*(M2[291]))[258] = M1(1,16); (*(M2[291]))[259] = M1(1,17); (*(M2[291]))[262] = M1(1,18); (*(M2[291]))[272] = M1(1,19); (*(M2[291]))[347] = M1(1,24); (*(M2[291]))[348] = M1(1,25); (*(M2[291]))[351] = M1(1,26); (*(M2[291]))[361] = M1(1,27); 
(*(M2[292]))[213] = M1(2,2); (*(M2[292]))[217] = M1(2,4); (*(M2[292]))[218] = M1(2,5); (*(M2[292]))[219] = M1(2,6); (*(M2[292]))[222] = M1(2,7); (*(M2[292]))[223] = M1(2,8); (*(M2[292]))[226] = M1(2,9); (*(M2[292]))[238] = M1(2,10); (*(M2[292]))[239] = M1(2,11); (*(M2[292]))[240] = M1(2,12); (*(M2[292]))[243] = M1(2,13); (*(M2[292]))[244] = M1(2,14); (*(M2[292]))[247] = M1(2,15); (*(M2[292]))[258] = M1(2,16); (*(M2[292]))[259] = M1(2,17); (*(M2[292]))[262] = M1(2,18); (*(M2[292]))[272] = M1(2,19); (*(M2[292]))[347] = M1(2,24); (*(M2[292]))[348] = M1(2,25); (*(M2[292]))[351] = M1(2,26); (*(M2[292]))[361] = M1(2,27); 
(*(M2[293]))[214] = M1(3,3); (*(M2[293]))[217] = M1(3,4); (*(M2[293]))[218] = M1(3,5); (*(M2[293]))[219] = M1(3,6); (*(M2[293]))[222] = M1(3,7); (*(M2[293]))[223] = M1(3,8); (*(M2[293]))[226] = M1(3,9); (*(M2[293]))[238] = M1(3,10); (*(M2[293]))[239] = M1(3,11); (*(M2[293]))[240] = M1(3,12); (*(M2[293]))[243] = M1(3,13); (*(M2[293]))[244] = M1(3,14); (*(M2[293]))[247] = M1(3,15); (*(M2[293]))[258] = M1(3,16); (*(M2[293]))[259] = M1(3,17); (*(M2[293]))[262] = M1(3,18); (*(M2[293]))[272] = M1(3,19); (*(M2[293]))[347] = M1(3,24); (*(M2[293]))[348] = M1(3,25); (*(M2[293]))[351] = M1(3,26); (*(M2[293]))[361] = M1(3,27); 
(*(M2[294]))[292] = M1(4,20); (*(M2[294]))[294] = M1(4,21); (*(M2[294]))[301] = M1(4,22); (*(M2[294]))[326] = M1(4,23); (*(M2[294]))[380] = M1(4,28); 
(*(M2[295]))[205] = M1(0,0); (*(M2[295]))[212] = M1(0,4); (*(M2[295]))[213] = M1(0,5); (*(M2[295]))[214] = M1(0,6); (*(M2[295]))[218] = M1(0,7); (*(M2[295]))[219] = M1(0,8); (*(M2[295]))[223] = M1(0,9); (*(M2[295]))[233] = M1(0,10); (*(M2[295]))[234] = M1(0,11); (*(M2[295]))[235] = M1(0,12); (*(M2[295]))[239] = M1(0,13); (*(M2[295]))[240] = M1(0,14); (*(M2[295]))[244] = M1(0,15); (*(M2[295]))[254] = M1(0,16); (*(M2[295]))[255] = M1(0,17); (*(M2[295]))[259] = M1(0,18); (*(M2[295]))[269] = M1(0,19); (*(M2[295]))[343] = M1(0,24); (*(M2[295]))[344] = M1(0,25); (*(M2[295]))[348] = M1(0,26); (*(M2[295]))[358] = M1(0,27); 
(*(M2[296]))[206] = M1(1,1); (*(M2[296]))[212] = M1(1,4); (*(M2[296]))[213] = M1(1,5); (*(M2[296]))[214] = M1(1,6); (*(M2[296]))[218] = M1(1,7); (*(M2[296]))[219] = M1(1,8); (*(M2[296]))[223] = M1(1,9); (*(M2[296]))[233] = M1(1,10); (*(M2[296]))[234] = M1(1,11); (*(M2[296]))[235] = M1(1,12); (*(M2[296]))[239] = M1(1,13); (*(M2[296]))[240] = M1(1,14); (*(M2[296]))[244] = M1(1,15); (*(M2[296]))[254] = M1(1,16); (*(M2[296]))[255] = M1(1,17); (*(M2[296]))[259] = M1(1,18); (*(M2[296]))[269] = M1(1,19); (*(M2[296]))[343] = M1(1,24); (*(M2[296]))[344] = M1(1,25); (*(M2[296]))[348] = M1(1,26); (*(M2[296]))[358] = M1(1,27); 
(*(M2[297]))[207] = M1(2,2); (*(M2[297]))[212] = M1(2,4); (*(M2[297]))[213] = M1(2,5); (*(M2[297]))[214] = M1(2,6); (*(M2[297]))[218] = M1(2,7); (*(M2[297]))[219] = M1(2,8); (*(M2[297]))[223] = M1(2,9); (*(M2[297]))[233] = M1(2,10); (*(M2[297]))[234] = M1(2,11); (*(M2[297]))[235] = M1(2,12); (*(M2[297]))[239] = M1(2,13); (*(M2[297]))[240] = M1(2,14); (*(M2[297]))[244] = M1(2,15); (*(M2[297]))[254] = M1(2,16); (*(M2[297]))[255] = M1(2,17); (*(M2[297]))[259] = M1(2,18); (*(M2[297]))[269] = M1(2,19); (*(M2[297]))[343] = M1(2,24); (*(M2[297]))[344] = M1(2,25); (*(M2[297]))[348] = M1(2,26); (*(M2[297]))[358] = M1(2,27); 
(*(M2[298]))[208] = M1(3,3); (*(M2[298]))[212] = M1(3,4); (*(M2[298]))[213] = M1(3,5); (*(M2[298]))[214] = M1(3,6); (*(M2[298]))[218] = M1(3,7); (*(M2[298]))[219] = M1(3,8); (*(M2[298]))[223] = M1(3,9); (*(M2[298]))[233] = M1(3,10); (*(M2[298]))[234] = M1(3,11); (*(M2[298]))[235] = M1(3,12); (*(M2[298]))[239] = M1(3,13); (*(M2[298]))[240] = M1(3,14); (*(M2[298]))[244] = M1(3,15); (*(M2[298]))[254] = M1(3,16); (*(M2[298]))[255] = M1(3,17); (*(M2[298]))[259] = M1(3,18); (*(M2[298]))[269] = M1(3,19); (*(M2[298]))[343] = M1(3,24); (*(M2[298]))[344] = M1(3,25); (*(M2[298]))[348] = M1(3,26); (*(M2[298]))[358] = M1(3,27); 
(*(M2[299]))[287] = M1(4,20); (*(M2[299]))[289] = M1(4,21); (*(M2[299]))[298] = M1(4,22); (*(M2[299]))[323] = M1(4,23); (*(M2[299]))[377] = M1(4,28); 
(*(M2[300]))[231] = M1(0,0); (*(M2[300]))[237] = M1(0,4); (*(M2[300]))[238] = M1(0,5); (*(M2[300]))[239] = M1(0,6); (*(M2[300]))[242] = M1(0,7); (*(M2[300]))[243] = M1(0,8); (*(M2[300]))[246] = M1(0,9); (*(M2[300]))[252] = M1(0,10); (*(M2[300]))[253] = M1(0,11); (*(M2[300]))[254] = M1(0,12); (*(M2[300]))[257] = M1(0,13); (*(M2[300]))[258] = M1(0,14); (*(M2[300]))[261] = M1(0,15); (*(M2[300]))[267] = M1(0,16); (*(M2[300]))[268] = M1(0,17); (*(M2[300]))[271] = M1(0,18); (*(M2[300]))[277] = M1(0,19); (*(M2[300]))[356] = M1(0,24); (*(M2[300]))[357] = M1(0,25); (*(M2[300]))[360] = M1(0,26); (*(M2[300]))[366] = M1(0,27); 
(*(M2[301]))[232] = M1(1,1); (*(M2[301]))[237] = M1(1,4); (*(M2[301]))[238] = M1(1,5); (*(M2[301]))[239] = M1(1,6); (*(M2[301]))[242] = M1(1,7); (*(M2[301]))[243] = M1(1,8); (*(M2[301]))[246] = M1(1,9); (*(M2[301]))[252] = M1(1,10); (*(M2[301]))[253] = M1(1,11); (*(M2[301]))[254] = M1(1,12); (*(M2[301]))[257] = M1(1,13); (*(M2[301]))[258] = M1(1,14); (*(M2[301]))[261] = M1(1,15); (*(M2[301]))[267] = M1(1,16); (*(M2[301]))[268] = M1(1,17); (*(M2[301]))[271] = M1(1,18); (*(M2[301]))[277] = M1(1,19); (*(M2[301]))[356] = M1(1,24); (*(M2[301]))[357] = M1(1,25); (*(M2[301]))[360] = M1(1,26); (*(M2[301]))[366] = M1(1,27); 
(*(M2[302]))[233] = M1(2,2); (*(M2[302]))[237] = M1(2,4); (*(M2[302]))[238] = M1(2,5); (*(M2[302]))[239] = M1(2,6); (*(M2[302]))[242] = M1(2,7); (*(M2[302]))[243] = M1(2,8); (*(M2[302]))[246] = M1(2,9); (*(M2[302]))[252] = M1(2,10); (*(M2[302]))[253] = M1(2,11); (*(M2[302]))[254] = M1(2,12); (*(M2[302]))[257] = M1(2,13); (*(M2[302]))[258] = M1(2,14); (*(M2[302]))[261] = M1(2,15); (*(M2[302]))[267] = M1(2,16); (*(M2[302]))[268] = M1(2,17); (*(M2[302]))[271] = M1(2,18); (*(M2[302]))[277] = M1(2,19); (*(M2[302]))[356] = M1(2,24); (*(M2[302]))[357] = M1(2,25); (*(M2[302]))[360] = M1(2,26); (*(M2[302]))[366] = M1(2,27); 
(*(M2[303]))[234] = M1(3,3); (*(M2[303]))[237] = M1(3,4); (*(M2[303]))[238] = M1(3,5); (*(M2[303]))[239] = M1(3,6); (*(M2[303]))[242] = M1(3,7); (*(M2[303]))[243] = M1(3,8); (*(M2[303]))[246] = M1(3,9); (*(M2[303]))[252] = M1(3,10); (*(M2[303]))[253] = M1(3,11); (*(M2[303]))[254] = M1(3,12); (*(M2[303]))[257] = M1(3,13); (*(M2[303]))[258] = M1(3,14); (*(M2[303]))[261] = M1(3,15); (*(M2[303]))[267] = M1(3,16); (*(M2[303]))[268] = M1(3,17); (*(M2[303]))[271] = M1(3,18); (*(M2[303]))[277] = M1(3,19); (*(M2[303]))[356] = M1(3,24); (*(M2[303]))[357] = M1(3,25); (*(M2[303]))[360] = M1(3,26); (*(M2[303]))[366] = M1(3,27); 
(*(M2[304]))[306] = M1(4,20); (*(M2[304]))[308] = M1(4,21); (*(M2[304]))[315] = M1(4,22); (*(M2[304]))[331] = M1(4,23); (*(M2[304]))[385] = M1(4,28); 
(*(M2[305]))[210] = M1(0,0); (*(M2[305]))[216] = M1(0,4); (*(M2[305]))[217] = M1(0,5); (*(M2[305]))[218] = M1(0,6); (*(M2[305]))[221] = M1(0,7); (*(M2[305]))[222] = M1(0,8); (*(M2[305]))[225] = M1(0,9); (*(M2[305]))[237] = M1(0,10); (*(M2[305]))[238] = M1(0,11); (*(M2[305]))[239] = M1(0,12); (*(M2[305]))[242] = M1(0,13); (*(M2[305]))[243] = M1(0,14); (*(M2[305]))[246] = M1(0,15); (*(M2[305]))[257] = M1(0,16); (*(M2[305]))[258] = M1(0,17); (*(M2[305]))[261] = M1(0,18); (*(M2[305]))[271] = M1(0,19); (*(M2[305]))[346] = M1(0,24); (*(M2[305]))[347] = M1(0,25); (*(M2[305]))[350] = M1(0,26); (*(M2[305]))[360] = M1(0,27); 
(*(M2[306]))[211] = M1(1,1); (*(M2[306]))[216] = M1(1,4); (*(M2[306]))[217] = M1(1,5); (*(M2[306]))[218] = M1(1,6); (*(M2[306]))[221] = M1(1,7); (*(M2[306]))[222] = M1(1,8); (*(M2[306]))[225] = M1(1,9); (*(M2[306]))[237] = M1(1,10); (*(M2[306]))[238] = M1(1,11); (*(M2[306]))[239] = M1(1,12); (*(M2[306]))[242] = M1(1,13); (*(M2[306]))[243] = M1(1,14); (*(M2[306]))[246] = M1(1,15); (*(M2[306]))[257] = M1(1,16); (*(M2[306]))[258] = M1(1,17); (*(M2[306]))[261] = M1(1,18); (*(M2[306]))[271] = M1(1,19); (*(M2[306]))[346] = M1(1,24); (*(M2[306]))[347] = M1(1,25); (*(M2[306]))[350] = M1(1,26); (*(M2[306]))[360] = M1(1,27); 
(*(M2[307]))[212] = M1(2,2); (*(M2[307]))[216] = M1(2,4); (*(M2[307]))[217] = M1(2,5); (*(M2[307]))[218] = M1(2,6); (*(M2[307]))[221] = M1(2,7); (*(M2[307]))[222] = M1(2,8); (*(M2[307]))[225] = M1(2,9); (*(M2[307]))[237] = M1(2,10); (*(M2[307]))[238] = M1(2,11); (*(M2[307]))[239] = M1(2,12); (*(M2[307]))[242] = M1(2,13); (*(M2[307]))[243] = M1(2,14); (*(M2[307]))[246] = M1(2,15); (*(M2[307]))[257] = M1(2,16); (*(M2[307]))[258] = M1(2,17); (*(M2[307]))[261] = M1(2,18); (*(M2[307]))[271] = M1(2,19); (*(M2[307]))[346] = M1(2,24); (*(M2[307]))[347] = M1(2,25); (*(M2[307]))[350] = M1(2,26); (*(M2[307]))[360] = M1(2,27); 
(*(M2[308]))[213] = M1(3,3); (*(M2[308]))[216] = M1(3,4); (*(M2[308]))[217] = M1(3,5); (*(M2[308]))[218] = M1(3,6); (*(M2[308]))[221] = M1(3,7); (*(M2[308]))[222] = M1(3,8); (*(M2[308]))[225] = M1(3,9); (*(M2[308]))[237] = M1(3,10); (*(M2[308]))[238] = M1(3,11); (*(M2[308]))[239] = M1(3,12); (*(M2[308]))[242] = M1(3,13); (*(M2[308]))[243] = M1(3,14); (*(M2[308]))[246] = M1(3,15); (*(M2[308]))[257] = M1(3,16); (*(M2[308]))[258] = M1(3,17); (*(M2[308]))[261] = M1(3,18); (*(M2[308]))[271] = M1(3,19); (*(M2[308]))[346] = M1(3,24); (*(M2[308]))[347] = M1(3,25); (*(M2[308]))[350] = M1(3,26); (*(M2[308]))[360] = M1(3,27); 
(*(M2[309]))[291] = M1(4,20); (*(M2[309]))[293] = M1(4,21); (*(M2[309]))[300] = M1(4,22); (*(M2[309]))[325] = M1(4,23); (*(M2[309]))[379] = M1(4,28); 
(*(M2[310]))[204] = M1(0,0); (*(M2[310]))[211] = M1(0,4); (*(M2[310]))[212] = M1(0,5); (*(M2[310]))[213] = M1(0,6); (*(M2[310]))[217] = M1(0,7); (*(M2[310]))[218] = M1(0,8); (*(M2[310]))[222] = M1(0,9); (*(M2[310]))[232] = M1(0,10); (*(M2[310]))[233] = M1(0,11); (*(M2[310]))[234] = M1(0,12); (*(M2[310]))[238] = M1(0,13); (*(M2[310]))[239] = M1(0,14); (*(M2[310]))[243] = M1(0,15); (*(M2[310]))[253] = M1(0,16); (*(M2[310]))[254] = M1(0,17); (*(M2[310]))[258] = M1(0,18); (*(M2[310]))[268] = M1(0,19); (*(M2[310]))[342] = M1(0,24); (*(M2[310]))[343] = M1(0,25); (*(M2[310]))[347] = M1(0,26); (*(M2[310]))[357] = M1(0,27); 
(*(M2[311]))[205] = M1(1,1); (*(M2[311]))[211] = M1(1,4); (*(M2[311]))[212] = M1(1,5); (*(M2[311]))[213] = M1(1,6); (*(M2[311]))[217] = M1(1,7); (*(M2[311]))[218] = M1(1,8); (*(M2[311]))[222] = M1(1,9); (*(M2[311]))[232] = M1(1,10); (*(M2[311]))[233] = M1(1,11); (*(M2[311]))[234] = M1(1,12); (*(M2[311]))[238] = M1(1,13); (*(M2[311]))[239] = M1(1,14); (*(M2[311]))[243] = M1(1,15); (*(M2[311]))[253] = M1(1,16); (*(M2[311]))[254] = M1(1,17); (*(M2[311]))[258] = M1(1,18); (*(M2[311]))[268] = M1(1,19); (*(M2[311]))[342] = M1(1,24); (*(M2[311]))[343] = M1(1,25); (*(M2[311]))[347] = M1(1,26); (*(M2[311]))[357] = M1(1,27); 
(*(M2[312]))[206] = M1(2,2); (*(M2[312]))[211] = M1(2,4); (*(M2[312]))[212] = M1(2,5); (*(M2[312]))[213] = M1(2,6); (*(M2[312]))[217] = M1(2,7); (*(M2[312]))[218] = M1(2,8); (*(M2[312]))[222] = M1(2,9); (*(M2[312]))[232] = M1(2,10); (*(M2[312]))[233] = M1(2,11); (*(M2[312]))[234] = M1(2,12); (*(M2[312]))[238] = M1(2,13); (*(M2[312]))[239] = M1(2,14); (*(M2[312]))[243] = M1(2,15); (*(M2[312]))[253] = M1(2,16); (*(M2[312]))[254] = M1(2,17); (*(M2[312]))[258] = M1(2,18); (*(M2[312]))[268] = M1(2,19); (*(M2[312]))[342] = M1(2,24); (*(M2[312]))[343] = M1(2,25); (*(M2[312]))[347] = M1(2,26); (*(M2[312]))[357] = M1(2,27); 
(*(M2[313]))[207] = M1(3,3); (*(M2[313]))[211] = M1(3,4); (*(M2[313]))[212] = M1(3,5); (*(M2[313]))[213] = M1(3,6); (*(M2[313]))[217] = M1(3,7); (*(M2[313]))[218] = M1(3,8); (*(M2[313]))[222] = M1(3,9); (*(M2[313]))[232] = M1(3,10); (*(M2[313]))[233] = M1(3,11); (*(M2[313]))[234] = M1(3,12); (*(M2[313]))[238] = M1(3,13); (*(M2[313]))[239] = M1(3,14); (*(M2[313]))[243] = M1(3,15); (*(M2[313]))[253] = M1(3,16); (*(M2[313]))[254] = M1(3,17); (*(M2[313]))[258] = M1(3,18); (*(M2[313]))[268] = M1(3,19); (*(M2[313]))[342] = M1(3,24); (*(M2[313]))[343] = M1(3,25); (*(M2[313]))[347] = M1(3,26); (*(M2[313]))[357] = M1(3,27); 
(*(M2[314]))[286] = M1(4,20); (*(M2[314]))[288] = M1(4,21); (*(M2[314]))[297] = M1(4,22); (*(M2[314]))[322] = M1(4,23); (*(M2[314]))[376] = M1(4,28); 
(*(M2[315]))[203] = M1(0,0); (*(M2[315]))[210] = M1(0,4); (*(M2[315]))[211] = M1(0,5); (*(M2[315]))[212] = M1(0,6); (*(M2[315]))[216] = M1(0,7); (*(M2[315]))[217] = M1(0,8); (*(M2[315]))[221] = M1(0,9); (*(M2[315]))[231] = M1(0,10); (*(M2[315]))[232] = M1(0,11); (*(M2[315]))[233] = M1(0,12); (*(M2[315]))[237] = M1(0,13); (*(M2[315]))[238] = M1(0,14); (*(M2[315]))[242] = M1(0,15); (*(M2[315]))[252] = M1(0,16); (*(M2[315]))[253] = M1(0,17); (*(M2[315]))[257] = M1(0,18); (*(M2[315]))[267] = M1(0,19); (*(M2[315]))[341] = M1(0,24); (*(M2[315]))[342] = M1(0,25); (*(M2[315]))[346] = M1(0,26); (*(M2[315]))[356] = M1(0,27); 
(*(M2[316]))[204] = M1(1,1); (*(M2[316]))[210] = M1(1,4); (*(M2[316]))[211] = M1(1,5); (*(M2[316]))[212] = M1(1,6); (*(M2[316]))[216] = M1(1,7); (*(M2[316]))[217] = M1(1,8); (*(M2[316]))[221] = M1(1,9); (*(M2[316]))[231] = M1(1,10); (*(M2[316]))[232] = M1(1,11); (*(M2[316]))[233] = M1(1,12); (*(M2[316]))[237] = M1(1,13); (*(M2[316]))[238] = M1(1,14); (*(M2[316]))[242] = M1(1,15); (*(M2[316]))[252] = M1(1,16); (*(M2[316]))[253] = M1(1,17); (*(M2[316]))[257] = M1(1,18); (*(M2[316]))[267] = M1(1,19); (*(M2[316]))[341] = M1(1,24); (*(M2[316]))[342] = M1(1,25); (*(M2[316]))[346] = M1(1,26); (*(M2[316]))[356] = M1(1,27); 
(*(M2[317]))[205] = M1(2,2); (*(M2[317]))[210] = M1(2,4); (*(M2[317]))[211] = M1(2,5); (*(M2[317]))[212] = M1(2,6); (*(M2[317]))[216] = M1(2,7); (*(M2[317]))[217] = M1(2,8); (*(M2[317]))[221] = M1(2,9); (*(M2[317]))[231] = M1(2,10); (*(M2[317]))[232] = M1(2,11); (*(M2[317]))[233] = M1(2,12); (*(M2[317]))[237] = M1(2,13); (*(M2[317]))[238] = M1(2,14); (*(M2[317]))[242] = M1(2,15); (*(M2[317]))[252] = M1(2,16); (*(M2[317]))[253] = M1(2,17); (*(M2[317]))[257] = M1(2,18); (*(M2[317]))[267] = M1(2,19); (*(M2[317]))[341] = M1(2,24); (*(M2[317]))[342] = M1(2,25); (*(M2[317]))[346] = M1(2,26); (*(M2[317]))[356] = M1(2,27); 
(*(M2[318]))[206] = M1(3,3); (*(M2[318]))[210] = M1(3,4); (*(M2[318]))[211] = M1(3,5); (*(M2[318]))[212] = M1(3,6); (*(M2[318]))[216] = M1(3,7); (*(M2[318]))[217] = M1(3,8); (*(M2[318]))[221] = M1(3,9); (*(M2[318]))[231] = M1(3,10); (*(M2[318]))[232] = M1(3,11); (*(M2[318]))[233] = M1(3,12); (*(M2[318]))[237] = M1(3,13); (*(M2[318]))[238] = M1(3,14); (*(M2[318]))[242] = M1(3,15); (*(M2[318]))[252] = M1(3,16); (*(M2[318]))[253] = M1(3,17); (*(M2[318]))[257] = M1(3,18); (*(M2[318]))[267] = M1(3,19); (*(M2[318]))[341] = M1(3,24); (*(M2[318]))[342] = M1(3,25); (*(M2[318]))[346] = M1(3,26); (*(M2[318]))[356] = M1(3,27); 
(*(M2[319]))[285] = M1(4,20); (*(M2[319]))[287] = M1(4,21); (*(M2[319]))[296] = M1(4,22); (*(M2[319]))[321] = M1(4,23); (*(M2[319]))[375] = M1(4,28); 
(*(M2[320]))[321] = M1(0,0); (*(M2[320]))[325] = M1(0,4); (*(M2[320]))[326] = M1(0,5); (*(M2[320]))[327] = M1(0,6); (*(M2[320]))[328] = M1(0,7); (*(M2[320]))[329] = M1(0,8); (*(M2[320]))[330] = M1(0,9); (*(M2[320]))[331] = M1(0,10); (*(M2[320]))[332] = M1(0,11); (*(M2[320]))[333] = M1(0,12); (*(M2[320]))[334] = M1(0,13); (*(M2[320]))[335] = M1(0,14); (*(M2[320]))[336] = M1(0,15); (*(M2[320]))[337] = M1(0,16); (*(M2[320]))[338] = M1(0,17); (*(M2[320]))[339] = M1(0,18); (*(M2[320]))[340] = M1(0,19); (*(M2[320]))[397] = M1(0,24); (*(M2[320]))[398] = M1(0,25); (*(M2[320]))[399] = M1(0,26); (*(M2[320]))[400] = M1(0,27); 
(*(M2[321]))[322] = M1(1,1); (*(M2[321]))[325] = M1(1,4); (*(M2[321]))[326] = M1(1,5); (*(M2[321]))[327] = M1(1,6); (*(M2[321]))[328] = M1(1,7); (*(M2[321]))[329] = M1(1,8); (*(M2[321]))[330] = M1(1,9); (*(M2[321]))[331] = M1(1,10); (*(M2[321]))[332] = M1(1,11); (*(M2[321]))[333] = M1(1,12); (*(M2[321]))[334] = M1(1,13); (*(M2[321]))[335] = M1(1,14); (*(M2[321]))[336] = M1(1,15); (*(M2[321]))[337] = M1(1,16); (*(M2[321]))[338] = M1(1,17); (*(M2[321]))[339] = M1(1,18); (*(M2[321]))[340] = M1(1,19); (*(M2[321]))[397] = M1(1,24); (*(M2[321]))[398] = M1(1,25); (*(M2[321]))[399] = M1(1,26); (*(M2[321]))[400] = M1(1,27); 
(*(M2[322]))[323] = M1(2,2); (*(M2[322]))[325] = M1(2,4); (*(M2[322]))[326] = M1(2,5); (*(M2[322]))[327] = M1(2,6); (*(M2[322]))[328] = M1(2,7); (*(M2[322]))[329] = M1(2,8); (*(M2[322]))[330] = M1(2,9); (*(M2[322]))[331] = M1(2,10); (*(M2[322]))[332] = M1(2,11); (*(M2[322]))[333] = M1(2,12); (*(M2[322]))[334] = M1(2,13); (*(M2[322]))[335] = M1(2,14); (*(M2[322]))[336] = M1(2,15); (*(M2[322]))[337] = M1(2,16); (*(M2[322]))[338] = M1(2,17); (*(M2[322]))[339] = M1(2,18); (*(M2[322]))[340] = M1(2,19); (*(M2[322]))[397] = M1(2,24); (*(M2[322]))[398] = M1(2,25); (*(M2[322]))[399] = M1(2,26); (*(M2[322]))[400] = M1(2,27); 
(*(M2[323]))[324] = M1(3,3); (*(M2[323]))[325] = M1(3,4); (*(M2[323]))[326] = M1(3,5); (*(M2[323]))[327] = M1(3,6); (*(M2[323]))[328] = M1(3,7); (*(M2[323]))[329] = M1(3,8); (*(M2[323]))[330] = M1(3,9); (*(M2[323]))[331] = M1(3,10); (*(M2[323]))[332] = M1(3,11); (*(M2[323]))[333] = M1(3,12); (*(M2[323]))[334] = M1(3,13); (*(M2[323]))[335] = M1(3,14); (*(M2[323]))[336] = M1(3,15); (*(M2[323]))[337] = M1(3,16); (*(M2[323]))[338] = M1(3,17); (*(M2[323]))[339] = M1(3,18); (*(M2[323]))[340] = M1(3,19); (*(M2[323]))[397] = M1(3,24); (*(M2[323]))[398] = M1(3,25); (*(M2[323]))[399] = M1(3,26); (*(M2[323]))[400] = M1(3,27); 
(*(M2[324]))[366] = M1(4,20); (*(M2[324]))[368] = M1(4,21); (*(M2[324]))[371] = M1(4,22); (*(M2[324]))[396] = M1(4,23); (*(M2[324]))[406] = M1(4,28); 
(*(M2[325]))[311] = M1(0,0); (*(M2[325]))[315] = M1(0,4); (*(M2[325]))[316] = M1(0,5); (*(M2[325]))[317] = M1(0,6); (*(M2[325]))[318] = M1(0,7); (*(M2[325]))[319] = M1(0,8); (*(M2[325]))[320] = M1(0,9); (*(M2[325]))[325] = M1(0,10); (*(M2[325]))[326] = M1(0,11); (*(M2[325]))[327] = M1(0,12); (*(M2[325]))[328] = M1(0,13); (*(M2[325]))[329] = M1(0,14); (*(M2[325]))[330] = M1(0,15); (*(M2[325]))[334] = M1(0,16); (*(M2[325]))[335] = M1(0,17); (*(M2[325]))[336] = M1(0,18); (*(M2[325]))[339] = M1(0,19); (*(M2[325]))[388] = M1(0,24); (*(M2[325]))[389] = M1(0,25); (*(M2[325]))[390] = M1(0,26); (*(M2[325]))[399] = M1(0,27); 
(*(M2[326]))[312] = M1(1,1); (*(M2[326]))[315] = M1(1,4); (*(M2[326]))[316] = M1(1,5); (*(M2[326]))[317] = M1(1,6); (*(M2[326]))[318] = M1(1,7); (*(M2[326]))[319] = M1(1,8); (*(M2[326]))[320] = M1(1,9); (*(M2[326]))[325] = M1(1,10); (*(M2[326]))[326] = M1(1,11); (*(M2[326]))[327] = M1(1,12); (*(M2[326]))[328] = M1(1,13); (*(M2[326]))[329] = M1(1,14); (*(M2[326]))[330] = M1(1,15); (*(M2[326]))[334] = M1(1,16); (*(M2[326]))[335] = M1(1,17); (*(M2[326]))[336] = M1(1,18); (*(M2[326]))[339] = M1(1,19); (*(M2[326]))[388] = M1(1,24); (*(M2[326]))[389] = M1(1,25); (*(M2[326]))[390] = M1(1,26); (*(M2[326]))[399] = M1(1,27); 
(*(M2[327]))[313] = M1(2,2); (*(M2[327]))[315] = M1(2,4); (*(M2[327]))[316] = M1(2,5); (*(M2[327]))[317] = M1(2,6); (*(M2[327]))[318] = M1(2,7); (*(M2[327]))[319] = M1(2,8); (*(M2[327]))[320] = M1(2,9); (*(M2[327]))[325] = M1(2,10); (*(M2[327]))[326] = M1(2,11); (*(M2[327]))[327] = M1(2,12); (*(M2[327]))[328] = M1(2,13); (*(M2[327]))[329] = M1(2,14); (*(M2[327]))[330] = M1(2,15); (*(M2[327]))[334] = M1(2,16); (*(M2[327]))[335] = M1(2,17); (*(M2[327]))[336] = M1(2,18); (*(M2[327]))[339] = M1(2,19); (*(M2[327]))[388] = M1(2,24); (*(M2[327]))[389] = M1(2,25); (*(M2[327]))[390] = M1(2,26); (*(M2[327]))[399] = M1(2,27); 
(*(M2[328]))[314] = M1(3,3); (*(M2[328]))[315] = M1(3,4); (*(M2[328]))[316] = M1(3,5); (*(M2[328]))[317] = M1(3,6); (*(M2[328]))[318] = M1(3,7); (*(M2[328]))[319] = M1(3,8); (*(M2[328]))[320] = M1(3,9); (*(M2[328]))[325] = M1(3,10); (*(M2[328]))[326] = M1(3,11); (*(M2[328]))[327] = M1(3,12); (*(M2[328]))[328] = M1(3,13); (*(M2[328]))[329] = M1(3,14); (*(M2[328]))[330] = M1(3,15); (*(M2[328]))[334] = M1(3,16); (*(M2[328]))[335] = M1(3,17); (*(M2[328]))[336] = M1(3,18); (*(M2[328]))[339] = M1(3,19); (*(M2[328]))[388] = M1(3,24); (*(M2[328]))[389] = M1(3,25); (*(M2[328]))[390] = M1(3,26); (*(M2[328]))[399] = M1(3,27); 
(*(M2[329]))[360] = M1(4,20); (*(M2[329]))[362] = M1(4,21); (*(M2[329]))[365] = M1(4,22); (*(M2[329]))[374] = M1(4,23); (*(M2[329]))[405] = M1(4,28); 
(*(M2[330]))[296] = M1(0,0); (*(M2[330]))[300] = M1(0,4); (*(M2[330]))[301] = M1(0,5); (*(M2[330]))[302] = M1(0,6); (*(M2[330]))[303] = M1(0,7); (*(M2[330]))[304] = M1(0,8); (*(M2[330]))[305] = M1(0,9); (*(M2[330]))[315] = M1(0,10); (*(M2[330]))[316] = M1(0,11); (*(M2[330]))[317] = M1(0,12); (*(M2[330]))[318] = M1(0,13); (*(M2[330]))[319] = M1(0,14); (*(M2[330]))[320] = M1(0,15); (*(M2[330]))[328] = M1(0,16); (*(M2[330]))[329] = M1(0,17); (*(M2[330]))[330] = M1(0,18); (*(M2[330]))[336] = M1(0,19); (*(M2[330]))[382] = M1(0,24); (*(M2[330]))[383] = M1(0,25); (*(M2[330]))[384] = M1(0,26); (*(M2[330]))[390] = M1(0,27); 
(*(M2[331]))[297] = M1(1,1); (*(M2[331]))[300] = M1(1,4); (*(M2[331]))[301] = M1(1,5); (*(M2[331]))[302] = M1(1,6); (*(M2[331]))[303] = M1(1,7); (*(M2[331]))[304] = M1(1,8); (*(M2[331]))[305] = M1(1,9); (*(M2[331]))[315] = M1(1,10); (*(M2[331]))[316] = M1(1,11); (*(M2[331]))[317] = M1(1,12); (*(M2[331]))[318] = M1(1,13); (*(M2[331]))[319] = M1(1,14); (*(M2[331]))[320] = M1(1,15); (*(M2[331]))[328] = M1(1,16); (*(M2[331]))[329] = M1(1,17); (*(M2[331]))[330] = M1(1,18); (*(M2[331]))[336] = M1(1,19); (*(M2[331]))[382] = M1(1,24); (*(M2[331]))[383] = M1(1,25); (*(M2[331]))[384] = M1(1,26); (*(M2[331]))[390] = M1(1,27); 
(*(M2[332]))[298] = M1(2,2); (*(M2[332]))[300] = M1(2,4); (*(M2[332]))[301] = M1(2,5); (*(M2[332]))[302] = M1(2,6); (*(M2[332]))[303] = M1(2,7); (*(M2[332]))[304] = M1(2,8); (*(M2[332]))[305] = M1(2,9); (*(M2[332]))[315] = M1(2,10); (*(M2[332]))[316] = M1(2,11); (*(M2[332]))[317] = M1(2,12); (*(M2[332]))[318] = M1(2,13); (*(M2[332]))[319] = M1(2,14); (*(M2[332]))[320] = M1(2,15); (*(M2[332]))[328] = M1(2,16); (*(M2[332]))[329] = M1(2,17); (*(M2[332]))[330] = M1(2,18); (*(M2[332]))[336] = M1(2,19); (*(M2[332]))[382] = M1(2,24); (*(M2[332]))[383] = M1(2,25); (*(M2[332]))[384] = M1(2,26); (*(M2[332]))[390] = M1(2,27); 
(*(M2[333]))[299] = M1(3,3); (*(M2[333]))[300] = M1(3,4); (*(M2[333]))[301] = M1(3,5); (*(M2[333]))[302] = M1(3,6); (*(M2[333]))[303] = M1(3,7); (*(M2[333]))[304] = M1(3,8); (*(M2[333]))[305] = M1(3,9); (*(M2[333]))[315] = M1(3,10); (*(M2[333]))[316] = M1(3,11); (*(M2[333]))[317] = M1(3,12); (*(M2[333]))[318] = M1(3,13); (*(M2[333]))[319] = M1(3,14); (*(M2[333]))[320] = M1(3,15); (*(M2[333]))[328] = M1(3,16); (*(M2[333]))[329] = M1(3,17); (*(M2[333]))[330] = M1(3,18); (*(M2[333]))[336] = M1(3,19); (*(M2[333]))[382] = M1(3,24); (*(M2[333]))[383] = M1(3,25); (*(M2[333]))[384] = M1(3,26); (*(M2[333]))[390] = M1(3,27); 
(*(M2[334]))[350] = M1(4,20); (*(M2[334]))[352] = M1(4,21); (*(M2[334]))[355] = M1(4,22); (*(M2[334]))[371] = M1(4,23); (*(M2[334]))[402] = M1(4,28); 
(*(M2[335]))[307] = M1(0,0); (*(M2[335]))[312] = M1(0,4); (*(M2[335]))[313] = M1(0,5); (*(M2[335]))[314] = M1(0,6); (*(M2[335]))[316] = M1(0,7); (*(M2[335]))[317] = M1(0,8); (*(M2[335]))[319] = M1(0,9); (*(M2[335]))[322] = M1(0,10); (*(M2[335]))[323] = M1(0,11); (*(M2[335]))[324] = M1(0,12); (*(M2[335]))[326] = M1(0,13); (*(M2[335]))[327] = M1(0,14); (*(M2[335]))[329] = M1(0,15); (*(M2[335]))[332] = M1(0,16); (*(M2[335]))[333] = M1(0,17); (*(M2[335]))[335] = M1(0,18); (*(M2[335]))[338] = M1(0,19); (*(M2[335]))[386] = M1(0,24); (*(M2[335]))[387] = M1(0,25); (*(M2[335]))[389] = M1(0,26); (*(M2[335]))[398] = M1(0,27); 
(*(M2[336]))[308] = M1(1,1); (*(M2[336]))[312] = M1(1,4); (*(M2[336]))[313] = M1(1,5); (*(M2[336]))[314] = M1(1,6); (*(M2[336]))[316] = M1(1,7); (*(M2[336]))[317] = M1(1,8); (*(M2[336]))[319] = M1(1,9); (*(M2[336]))[322] = M1(1,10); (*(M2[336]))[323] = M1(1,11); (*(M2[336]))[324] = M1(1,12); (*(M2[336]))[326] = M1(1,13); (*(M2[336]))[327] = M1(1,14); (*(M2[336]))[329] = M1(1,15); (*(M2[336]))[332] = M1(1,16); (*(M2[336]))[333] = M1(1,17); (*(M2[336]))[335] = M1(1,18); (*(M2[336]))[338] = M1(1,19); (*(M2[336]))[386] = M1(1,24); (*(M2[336]))[387] = M1(1,25); (*(M2[336]))[389] = M1(1,26); (*(M2[336]))[398] = M1(1,27); 
(*(M2[337]))[309] = M1(2,2); (*(M2[337]))[312] = M1(2,4); (*(M2[337]))[313] = M1(2,5); (*(M2[337]))[314] = M1(2,6); (*(M2[337]))[316] = M1(2,7); (*(M2[337]))[317] = M1(2,8); (*(M2[337]))[319] = M1(2,9); (*(M2[337]))[322] = M1(2,10); (*(M2[337]))[323] = M1(2,11); (*(M2[337]))[324] = M1(2,12); (*(M2[337]))[326] = M1(2,13); (*(M2[337]))[327] = M1(2,14); (*(M2[337]))[329] = M1(2,15); (*(M2[337]))[332] = M1(2,16); (*(M2[337]))[333] = M1(2,17); (*(M2[337]))[335] = M1(2,18); (*(M2[337]))[338] = M1(2,19); (*(M2[337]))[386] = M1(2,24); (*(M2[337]))[387] = M1(2,25); (*(M2[337]))[389] = M1(2,26); (*(M2[337]))[398] = M1(2,27); 
(*(M2[338]))[310] = M1(3,3); (*(M2[338]))[312] = M1(3,4); (*(M2[338]))[313] = M1(3,5); (*(M2[338]))[314] = M1(3,6); (*(M2[338]))[316] = M1(3,7); (*(M2[338]))[317] = M1(3,8); (*(M2[338]))[319] = M1(3,9); (*(M2[338]))[322] = M1(3,10); (*(M2[338]))[323] = M1(3,11); (*(M2[338]))[324] = M1(3,12); (*(M2[338]))[326] = M1(3,13); (*(M2[338]))[327] = M1(3,14); (*(M2[338]))[329] = M1(3,15); (*(M2[338]))[332] = M1(3,16); (*(M2[338]))[333] = M1(3,17); (*(M2[338]))[335] = M1(3,18); (*(M2[338]))[338] = M1(3,19); (*(M2[338]))[386] = M1(3,24); (*(M2[338]))[387] = M1(3,25); (*(M2[338]))[389] = M1(3,26); (*(M2[338]))[398] = M1(3,27); 
(*(M2[339]))[357] = M1(4,20); (*(M2[339]))[359] = M1(4,21); (*(M2[339]))[364] = M1(4,22); (*(M2[339]))[373] = M1(4,23); (*(M2[339]))[404] = M1(4,28); 
(*(M2[340]))[292] = M1(0,0); (*(M2[340]))[297] = M1(0,4); (*(M2[340]))[298] = M1(0,5); (*(M2[340]))[299] = M1(0,6); (*(M2[340]))[301] = M1(0,7); (*(M2[340]))[302] = M1(0,8); (*(M2[340]))[304] = M1(0,9); (*(M2[340]))[312] = M1(0,10); (*(M2[340]))[313] = M1(0,11); (*(M2[340]))[314] = M1(0,12); (*(M2[340]))[316] = M1(0,13); (*(M2[340]))[317] = M1(0,14); (*(M2[340]))[319] = M1(0,15); (*(M2[340]))[326] = M1(0,16); (*(M2[340]))[327] = M1(0,17); (*(M2[340]))[329] = M1(0,18); (*(M2[340]))[335] = M1(0,19); (*(M2[340]))[380] = M1(0,24); (*(M2[340]))[381] = M1(0,25); (*(M2[340]))[383] = M1(0,26); (*(M2[340]))[389] = M1(0,27); 
(*(M2[341]))[293] = M1(1,1); (*(M2[341]))[297] = M1(1,4); (*(M2[341]))[298] = M1(1,5); (*(M2[341]))[299] = M1(1,6); (*(M2[341]))[301] = M1(1,7); (*(M2[341]))[302] = M1(1,8); (*(M2[341]))[304] = M1(1,9); (*(M2[341]))[312] = M1(1,10); (*(M2[341]))[313] = M1(1,11); (*(M2[341]))[314] = M1(1,12); (*(M2[341]))[316] = M1(1,13); (*(M2[341]))[317] = M1(1,14); (*(M2[341]))[319] = M1(1,15); (*(M2[341]))[326] = M1(1,16); (*(M2[341]))[327] = M1(1,17); (*(M2[341]))[329] = M1(1,18); (*(M2[341]))[335] = M1(1,19); (*(M2[341]))[380] = M1(1,24); (*(M2[341]))[381] = M1(1,25); (*(M2[341]))[383] = M1(1,26); (*(M2[341]))[389] = M1(1,27); 
(*(M2[342]))[294] = M1(2,2); (*(M2[342]))[297] = M1(2,4); (*(M2[342]))[298] = M1(2,5); (*(M2[342]))[299] = M1(2,6); (*(M2[342]))[301] = M1(2,7); (*(M2[342]))[302] = M1(2,8); (*(M2[342]))[304] = M1(2,9); (*(M2[342]))[312] = M1(2,10); (*(M2[342]))[313] = M1(2,11); (*(M2[342]))[314] = M1(2,12); (*(M2[342]))[316] = M1(2,13); (*(M2[342]))[317] = M1(2,14); (*(M2[342]))[319] = M1(2,15); (*(M2[342]))[326] = M1(2,16); (*(M2[342]))[327] = M1(2,17); (*(M2[342]))[329] = M1(2,18); (*(M2[342]))[335] = M1(2,19); (*(M2[342]))[380] = M1(2,24); (*(M2[342]))[381] = M1(2,25); (*(M2[342]))[383] = M1(2,26); (*(M2[342]))[389] = M1(2,27); 
(*(M2[343]))[295] = M1(3,3); (*(M2[343]))[297] = M1(3,4); (*(M2[343]))[298] = M1(3,5); (*(M2[343]))[299] = M1(3,6); (*(M2[343]))[301] = M1(3,7); (*(M2[343]))[302] = M1(3,8); (*(M2[343]))[304] = M1(3,9); (*(M2[343]))[312] = M1(3,10); (*(M2[343]))[313] = M1(3,11); (*(M2[343]))[314] = M1(3,12); (*(M2[343]))[316] = M1(3,13); (*(M2[343]))[317] = M1(3,14); (*(M2[343]))[319] = M1(3,15); (*(M2[343]))[326] = M1(3,16); (*(M2[343]))[327] = M1(3,17); (*(M2[343]))[329] = M1(3,18); (*(M2[343]))[335] = M1(3,19); (*(M2[343]))[380] = M1(3,24); (*(M2[343]))[381] = M1(3,25); (*(M2[343]))[383] = M1(3,26); (*(M2[343]))[389] = M1(3,27); 
(*(M2[344]))[347] = M1(4,20); (*(M2[344]))[349] = M1(4,21); (*(M2[344]))[354] = M1(4,22); (*(M2[344]))[370] = M1(4,23); (*(M2[344]))[401] = M1(4,28); 
(*(M2[345]))[287] = M1(0,0); (*(M2[345]))[293] = M1(0,4); (*(M2[345]))[294] = M1(0,5); (*(M2[345]))[295] = M1(0,6); (*(M2[345]))[298] = M1(0,7); (*(M2[345]))[299] = M1(0,8); (*(M2[345]))[302] = M1(0,9); (*(M2[345]))[308] = M1(0,10); (*(M2[345]))[309] = M1(0,11); (*(M2[345]))[310] = M1(0,12); (*(M2[345]))[313] = M1(0,13); (*(M2[345]))[314] = M1(0,14); (*(M2[345]))[317] = M1(0,15); (*(M2[345]))[323] = M1(0,16); (*(M2[345]))[324] = M1(0,17); (*(M2[345]))[327] = M1(0,18); (*(M2[345]))[333] = M1(0,19); (*(M2[345]))[377] = M1(0,24); (*(M2[345]))[378] = M1(0,25); (*(M2[345]))[381] = M1(0,26); (*(M2[345]))[387] = M1(0,27); 
(*(M2[346]))[288] = M1(1,1); (*(M2[346]))[293] = M1(1,4); (*(M2[346]))[294] = M1(1,5); (*(M2[346]))[295] = M1(1,6); (*(M2[346]))[298] = M1(1,7); (*(M2[346]))[299] = M1(1,8); (*(M2[346]))[302] = M1(1,9); (*(M2[346]))[308] = M1(1,10); (*(M2[346]))[309] = M1(1,11); (*(M2[346]))[310] = M1(1,12); (*(M2[346]))[313] = M1(1,13); (*(M2[346]))[314] = M1(1,14); (*(M2[346]))[317] = M1(1,15); (*(M2[346]))[323] = M1(1,16); (*(M2[346]))[324] = M1(1,17); (*(M2[346]))[327] = M1(1,18); (*(M2[346]))[333] = M1(1,19); (*(M2[346]))[377] = M1(1,24); (*(M2[346]))[378] = M1(1,25); (*(M2[346]))[381] = M1(1,26); (*(M2[346]))[387] = M1(1,27); 
(*(M2[347]))[289] = M1(2,2); (*(M2[347]))[293] = M1(2,4); (*(M2[347]))[294] = M1(2,5); (*(M2[347]))[295] = M1(2,6); (*(M2[347]))[298] = M1(2,7); (*(M2[347]))[299] = M1(2,8); (*(M2[347]))[302] = M1(2,9); (*(M2[347]))[308] = M1(2,10); (*(M2[347]))[309] = M1(2,11); (*(M2[347]))[310] = M1(2,12); (*(M2[347]))[313] = M1(2,13); (*(M2[347]))[314] = M1(2,14); (*(M2[347]))[317] = M1(2,15); (*(M2[347]))[323] = M1(2,16); (*(M2[347]))[324] = M1(2,17); (*(M2[347]))[327] = M1(2,18); (*(M2[347]))[333] = M1(2,19); (*(M2[347]))[377] = M1(2,24); (*(M2[347]))[378] = M1(2,25); (*(M2[347]))[381] = M1(2,26); (*(M2[347]))[387] = M1(2,27); 
(*(M2[348]))[290] = M1(3,3); (*(M2[348]))[293] = M1(3,4); (*(M2[348]))[294] = M1(3,5); (*(M2[348]))[295] = M1(3,6); (*(M2[348]))[298] = M1(3,7); (*(M2[348]))[299] = M1(3,8); (*(M2[348]))[302] = M1(3,9); (*(M2[348]))[308] = M1(3,10); (*(M2[348]))[309] = M1(3,11); (*(M2[348]))[310] = M1(3,12); (*(M2[348]))[313] = M1(3,13); (*(M2[348]))[314] = M1(3,14); (*(M2[348]))[317] = M1(3,15); (*(M2[348]))[323] = M1(3,16); (*(M2[348]))[324] = M1(3,17); (*(M2[348]))[327] = M1(3,18); (*(M2[348]))[333] = M1(3,19); (*(M2[348]))[377] = M1(3,24); (*(M2[348]))[378] = M1(3,25); (*(M2[348]))[381] = M1(3,26); (*(M2[348]))[387] = M1(3,27); 
(*(M2[349]))[343] = M1(4,20); (*(M2[349]))[345] = M1(4,21); (*(M2[349]))[352] = M1(4,22); (*(M2[349]))[368] = M1(4,23); (*(M2[349]))[393] = M1(4,28); 
(*(M2[350]))[306] = M1(0,0); (*(M2[350]))[311] = M1(0,4); (*(M2[350]))[312] = M1(0,5); (*(M2[350]))[313] = M1(0,6); (*(M2[350]))[315] = M1(0,7); (*(M2[350]))[316] = M1(0,8); (*(M2[350]))[318] = M1(0,9); (*(M2[350]))[321] = M1(0,10); (*(M2[350]))[322] = M1(0,11); (*(M2[350]))[323] = M1(0,12); (*(M2[350]))[325] = M1(0,13); (*(M2[350]))[326] = M1(0,14); (*(M2[350]))[328] = M1(0,15); (*(M2[350]))[331] = M1(0,16); (*(M2[350]))[332] = M1(0,17); (*(M2[350]))[334] = M1(0,18); (*(M2[350]))[337] = M1(0,19); (*(M2[350]))[385] = M1(0,24); (*(M2[350]))[386] = M1(0,25); (*(M2[350]))[388] = M1(0,26); (*(M2[350]))[397] = M1(0,27); 
(*(M2[351]))[307] = M1(1,1); (*(M2[351]))[311] = M1(1,4); (*(M2[351]))[312] = M1(1,5); (*(M2[351]))[313] = M1(1,6); (*(M2[351]))[315] = M1(1,7); (*(M2[351]))[316] = M1(1,8); (*(M2[351]))[318] = M1(1,9); (*(M2[351]))[321] = M1(1,10); (*(M2[351]))[322] = M1(1,11); (*(M2[351]))[323] = M1(1,12); (*(M2[351]))[325] = M1(1,13); (*(M2[351]))[326] = M1(1,14); (*(M2[351]))[328] = M1(1,15); (*(M2[351]))[331] = M1(1,16); (*(M2[351]))[332] = M1(1,17); (*(M2[351]))[334] = M1(1,18); (*(M2[351]))[337] = M1(1,19); (*(M2[351]))[385] = M1(1,24); (*(M2[351]))[386] = M1(1,25); (*(M2[351]))[388] = M1(1,26); (*(M2[351]))[397] = M1(1,27); 
(*(M2[352]))[308] = M1(2,2); (*(M2[352]))[311] = M1(2,4); (*(M2[352]))[312] = M1(2,5); (*(M2[352]))[313] = M1(2,6); (*(M2[352]))[315] = M1(2,7); (*(M2[352]))[316] = M1(2,8); (*(M2[352]))[318] = M1(2,9); (*(M2[352]))[321] = M1(2,10); (*(M2[352]))[322] = M1(2,11); (*(M2[352]))[323] = M1(2,12); (*(M2[352]))[325] = M1(2,13); (*(M2[352]))[326] = M1(2,14); (*(M2[352]))[328] = M1(2,15); (*(M2[352]))[331] = M1(2,16); (*(M2[352]))[332] = M1(2,17); (*(M2[352]))[334] = M1(2,18); (*(M2[352]))[337] = M1(2,19); (*(M2[352]))[385] = M1(2,24); (*(M2[352]))[386] = M1(2,25); (*(M2[352]))[388] = M1(2,26); (*(M2[352]))[397] = M1(2,27); 
(*(M2[353]))[309] = M1(3,3); (*(M2[353]))[311] = M1(3,4); (*(M2[353]))[312] = M1(3,5); (*(M2[353]))[313] = M1(3,6); (*(M2[353]))[315] = M1(3,7); (*(M2[353]))[316] = M1(3,8); (*(M2[353]))[318] = M1(3,9); (*(M2[353]))[321] = M1(3,10); (*(M2[353]))[322] = M1(3,11); (*(M2[353]))[323] = M1(3,12); (*(M2[353]))[325] = M1(3,13); (*(M2[353]))[326] = M1(3,14); (*(M2[353]))[328] = M1(3,15); (*(M2[353]))[331] = M1(3,16); (*(M2[353]))[332] = M1(3,17); (*(M2[353]))[334] = M1(3,18); (*(M2[353]))[337] = M1(3,19); (*(M2[353]))[385] = M1(3,24); (*(M2[353]))[386] = M1(3,25); (*(M2[353]))[388] = M1(3,26); (*(M2[353]))[397] = M1(3,27); 
(*(M2[354]))[356] = M1(4,20); (*(M2[354]))[358] = M1(4,21); (*(M2[354]))[363] = M1(4,22); (*(M2[354]))[372] = M1(4,23); (*(M2[354]))[403] = M1(4,28); 
(*(M2[355]))[291] = M1(0,0); (*(M2[355]))[296] = M1(0,4); (*(M2[355]))[297] = M1(0,5); (*(M2[355]))[298] = M1(0,6); (*(M2[355]))[300] = M1(0,7); (*(M2[355]))[301] = M1(0,8); (*(M2[355]))[303] = M1(0,9); (*(M2[355]))[311] = M1(0,10); (*(M2[355]))[312] = M1(0,11); (*(M2[355]))[313] = M1(0,12); (*(M2[355]))[315] = M1(0,13); (*(M2[355]))[316] = M1(0,14); (*(M2[355]))[318] = M1(0,15); (*(M2[355]))[325] = M1(0,16); (*(M2[355]))[326] = M1(0,17); (*(M2[355]))[328] = M1(0,18); (*(M2[355]))[334] = M1(0,19); (*(M2[355]))[379] = M1(0,24); (*(M2[355]))[380] = M1(0,25); (*(M2[355]))[382] = M1(0,26); (*(M2[355]))[388] = M1(0,27); 
(*(M2[356]))[292] = M1(1,1); (*(M2[356]))[296] = M1(1,4); (*(M2[356]))[297] = M1(1,5); (*(M2[356]))[298] = M1(1,6); (*(M2[356]))[300] = M1(1,7); (*(M2[356]))[301] = M1(1,8); (*(M2[356]))[303] = M1(1,9); (*(M2[356]))[311] = M1(1,10); (*(M2[356]))[312] = M1(1,11); (*(M2[356]))[313] = M1(1,12); (*(M2[356]))[315] = M1(1,13); (*(M2[356]))[316] = M1(1,14); (*(M2[356]))[318] = M1(1,15); (*(M2[356]))[325] = M1(1,16); (*(M2[356]))[326] = M1(1,17); (*(M2[356]))[328] = M1(1,18); (*(M2[356]))[334] = M1(1,19); (*(M2[356]))[379] = M1(1,24); (*(M2[356]))[380] = M1(1,25); (*(M2[356]))[382] = M1(1,26); (*(M2[356]))[388] = M1(1,27); 
(*(M2[357]))[293] = M1(2,2); (*(M2[357]))[296] = M1(2,4); (*(M2[357]))[297] = M1(2,5); (*(M2[357]))[298] = M1(2,6); (*(M2[357]))[300] = M1(2,7); (*(M2[357]))[301] = M1(2,8); (*(M2[357]))[303] = M1(2,9); (*(M2[357]))[311] = M1(2,10); (*(M2[357]))[312] = M1(2,11); (*(M2[357]))[313] = M1(2,12); (*(M2[357]))[315] = M1(2,13); (*(M2[357]))[316] = M1(2,14); (*(M2[357]))[318] = M1(2,15); (*(M2[357]))[325] = M1(2,16); (*(M2[357]))[326] = M1(2,17); (*(M2[357]))[328] = M1(2,18); (*(M2[357]))[334] = M1(2,19); (*(M2[357]))[379] = M1(2,24); (*(M2[357]))[380] = M1(2,25); (*(M2[357]))[382] = M1(2,26); (*(M2[357]))[388] = M1(2,27); 
(*(M2[358]))[294] = M1(3,3); (*(M2[358]))[296] = M1(3,4); (*(M2[358]))[297] = M1(3,5); (*(M2[358]))[298] = M1(3,6); (*(M2[358]))[300] = M1(3,7); (*(M2[358]))[301] = M1(3,8); (*(M2[358]))[303] = M1(3,9); (*(M2[358]))[311] = M1(3,10); (*(M2[358]))[312] = M1(3,11); (*(M2[358]))[313] = M1(3,12); (*(M2[358]))[315] = M1(3,13); (*(M2[358]))[316] = M1(3,14); (*(M2[358]))[318] = M1(3,15); (*(M2[358]))[325] = M1(3,16); (*(M2[358]))[326] = M1(3,17); (*(M2[358]))[328] = M1(3,18); (*(M2[358]))[334] = M1(3,19); (*(M2[358]))[379] = M1(3,24); (*(M2[358]))[380] = M1(3,25); (*(M2[358]))[382] = M1(3,26); (*(M2[358]))[388] = M1(3,27); 
(*(M2[359]))[346] = M1(4,20); (*(M2[359]))[348] = M1(4,21); (*(M2[359]))[353] = M1(4,22); (*(M2[359]))[369] = M1(4,23); (*(M2[359]))[394] = M1(4,28); 
(*(M2[360]))[286] = M1(0,0); (*(M2[360]))[292] = M1(0,4); (*(M2[360]))[293] = M1(0,5); (*(M2[360]))[294] = M1(0,6); (*(M2[360]))[297] = M1(0,7); (*(M2[360]))[298] = M1(0,8); (*(M2[360]))[301] = M1(0,9); (*(M2[360]))[307] = M1(0,10); (*(M2[360]))[308] = M1(0,11); (*(M2[360]))[309] = M1(0,12); (*(M2[360]))[312] = M1(0,13); (*(M2[360]))[313] = M1(0,14); (*(M2[360]))[316] = M1(0,15); (*(M2[360]))[322] = M1(0,16); (*(M2[360]))[323] = M1(0,17); (*(M2[360]))[326] = M1(0,18); (*(M2[360]))[332] = M1(0,19); (*(M2[360]))[376] = M1(0,24); (*(M2[360]))[377] = M1(0,25); (*(M2[360]))[380] = M1(0,26); (*(M2[360]))[386] = M1(0,27); 
(*(M2[361]))[287] = M1(1,1); (*(M2[361]))[292] = M1(1,4); (*(M2[361]))[293] = M1(1,5); (*(M2[361]))[294] = M1(1,6); (*(M2[361]))[297] = M1(1,7); (*(M2[361]))[298] = M1(1,8); (*(M2[361]))[301] = M1(1,9); (*(M2[361]))[307] = M1(1,10); (*(M2[361]))[308] = M1(1,11); (*(M2[361]))[309] = M1(1,12); (*(M2[361]))[312] = M1(1,13); (*(M2[361]))[313] = M1(1,14); (*(M2[361]))[316] = M1(1,15); (*(M2[361]))[322] = M1(1,16); (*(M2[361]))[323] = M1(1,17); (*(M2[361]))[326] = M1(1,18); (*(M2[361]))[332] = M1(1,19); (*(M2[361]))[376] = M1(1,24); (*(M2[361]))[377] = M1(1,25); (*(M2[361]))[380] = M1(1,26); (*(M2[361]))[386] = M1(1,27); 
(*(M2[362]))[288] = M1(2,2); (*(M2[362]))[292] = M1(2,4); (*(M2[362]))[293] = M1(2,5); (*(M2[362]))[294] = M1(2,6); (*(M2[362]))[297] = M1(2,7); (*(M2[362]))[298] = M1(2,8); (*(M2[362]))[301] = M1(2,9); (*(M2[362]))[307] = M1(2,10); (*(M2[362]))[308] = M1(2,11); (*(M2[362]))[309] = M1(2,12); (*(M2[362]))[312] = M1(2,13); (*(M2[362]))[313] = M1(2,14); (*(M2[362]))[316] = M1(2,15); (*(M2[362]))[322] = M1(2,16); (*(M2[362]))[323] = M1(2,17); (*(M2[362]))[326] = M1(2,18); (*(M2[362]))[332] = M1(2,19); (*(M2[362]))[376] = M1(2,24); (*(M2[362]))[377] = M1(2,25); (*(M2[362]))[380] = M1(2,26); (*(M2[362]))[386] = M1(2,27); 
(*(M2[363]))[289] = M1(3,3); (*(M2[363]))[292] = M1(3,4); (*(M2[363]))[293] = M1(3,5); (*(M2[363]))[294] = M1(3,6); (*(M2[363]))[297] = M1(3,7); (*(M2[363]))[298] = M1(3,8); (*(M2[363]))[301] = M1(3,9); (*(M2[363]))[307] = M1(3,10); (*(M2[363]))[308] = M1(3,11); (*(M2[363]))[309] = M1(3,12); (*(M2[363]))[312] = M1(3,13); (*(M2[363]))[313] = M1(3,14); (*(M2[363]))[316] = M1(3,15); (*(M2[363]))[322] = M1(3,16); (*(M2[363]))[323] = M1(3,17); (*(M2[363]))[326] = M1(3,18); (*(M2[363]))[332] = M1(3,19); (*(M2[363]))[376] = M1(3,24); (*(M2[363]))[377] = M1(3,25); (*(M2[363]))[380] = M1(3,26); (*(M2[363]))[386] = M1(3,27); 
(*(M2[364]))[342] = M1(4,20); (*(M2[364]))[344] = M1(4,21); (*(M2[364]))[351] = M1(4,22); (*(M2[364]))[367] = M1(4,23); (*(M2[364]))[392] = M1(4,28); 
(*(M2[365]))[285] = M1(0,0); (*(M2[365]))[291] = M1(0,4); (*(M2[365]))[292] = M1(0,5); (*(M2[365]))[293] = M1(0,6); (*(M2[365]))[296] = M1(0,7); (*(M2[365]))[297] = M1(0,8); (*(M2[365]))[300] = M1(0,9); (*(M2[365]))[306] = M1(0,10); (*(M2[365]))[307] = M1(0,11); (*(M2[365]))[308] = M1(0,12); (*(M2[365]))[311] = M1(0,13); (*(M2[365]))[312] = M1(0,14); (*(M2[365]))[315] = M1(0,15); (*(M2[365]))[321] = M1(0,16); (*(M2[365]))[322] = M1(0,17); (*(M2[365]))[325] = M1(0,18); (*(M2[365]))[331] = M1(0,19); (*(M2[365]))[375] = M1(0,24); (*(M2[365]))[376] = M1(0,25); (*(M2[365]))[379] = M1(0,26); (*(M2[365]))[385] = M1(0,27); 
(*(M2[366]))[286] = M1(1,1); (*(M2[366]))[291] = M1(1,4); (*(M2[366]))[292] = M1(1,5); (*(M2[366]))[293] = M1(1,6); (*(M2[366]))[296] = M1(1,7); (*(M2[366]))[297] = M1(1,8); (*(M2[366]))[300] = M1(1,9); (*(M2[366]))[306] = M1(1,10); (*(M2[366]))[307] = M1(1,11); (*(M2[366]))[308] = M1(1,12); (*(M2[366]))[311] = M1(1,13); (*(M2[366]))[312] = M1(1,14); (*(M2[366]))[315] = M1(1,15); (*(M2[366]))[321] = M1(1,16); (*(M2[366]))[322] = M1(1,17); (*(M2[366]))[325] = M1(1,18); (*(M2[366]))[331] = M1(1,19); (*(M2[366]))[375] = M1(1,24); (*(M2[366]))[376] = M1(1,25); (*(M2[366]))[379] = M1(1,26); (*(M2[366]))[385] = M1(1,27); 
(*(M2[367]))[287] = M1(2,2); (*(M2[367]))[291] = M1(2,4); (*(M2[367]))[292] = M1(2,5); (*(M2[367]))[293] = M1(2,6); (*(M2[367]))[296] = M1(2,7); (*(M2[367]))[297] = M1(2,8); (*(M2[367]))[300] = M1(2,9); (*(M2[367]))[306] = M1(2,10); (*(M2[367]))[307] = M1(2,11); (*(M2[367]))[308] = M1(2,12); (*(M2[367]))[311] = M1(2,13); (*(M2[367]))[312] = M1(2,14); (*(M2[367]))[315] = M1(2,15); (*(M2[367]))[321] = M1(2,16); (*(M2[367]))[322] = M1(2,17); (*(M2[367]))[325] = M1(2,18); (*(M2[367]))[331] = M1(2,19); (*(M2[367]))[375] = M1(2,24); (*(M2[367]))[376] = M1(2,25); (*(M2[367]))[379] = M1(2,26); (*(M2[367]))[385] = M1(2,27); 
(*(M2[368]))[288] = M1(3,3); (*(M2[368]))[291] = M1(3,4); (*(M2[368]))[292] = M1(3,5); (*(M2[368]))[293] = M1(3,6); (*(M2[368]))[296] = M1(3,7); (*(M2[368]))[297] = M1(3,8); (*(M2[368]))[300] = M1(3,9); (*(M2[368]))[306] = M1(3,10); (*(M2[368]))[307] = M1(3,11); (*(M2[368]))[308] = M1(3,12); (*(M2[368]))[311] = M1(3,13); (*(M2[368]))[312] = M1(3,14); (*(M2[368]))[315] = M1(3,15); (*(M2[368]))[321] = M1(3,16); (*(M2[368]))[322] = M1(3,17); (*(M2[368]))[325] = M1(3,18); (*(M2[368]))[331] = M1(3,19); (*(M2[368]))[375] = M1(3,24); (*(M2[368]))[376] = M1(3,25); (*(M2[368]))[379] = M1(3,26); (*(M2[368]))[385] = M1(3,27); 
(*(M2[369]))[341] = M1(4,20); (*(M2[369]))[343] = M1(4,21); (*(M2[369]))[350] = M1(4,22); (*(M2[369]))[366] = M1(4,23); (*(M2[369]))[391] = M1(4,28); 
(*(M2[370]))[356] = M1(0,0); (*(M2[370]))[360] = M1(0,4); (*(M2[370]))[361] = M1(0,5); (*(M2[370]))[362] = M1(0,6); (*(M2[370]))[363] = M1(0,7); (*(M2[370]))[364] = M1(0,8); (*(M2[370]))[365] = M1(0,9); (*(M2[370]))[366] = M1(0,10); (*(M2[370]))[367] = M1(0,11); (*(M2[370]))[368] = M1(0,12); (*(M2[370]))[369] = M1(0,13); (*(M2[370]))[370] = M1(0,14); (*(M2[370]))[371] = M1(0,15); (*(M2[370]))[372] = M1(0,16); (*(M2[370]))[373] = M1(0,17); (*(M2[370]))[374] = M1(0,18); (*(M2[370]))[396] = M1(0,19); (*(M2[370]))[403] = M1(0,24); (*(M2[370]))[404] = M1(0,25); (*(M2[370]))[405] = M1(0,26); (*(M2[370]))[406] = M1(0,27); 
(*(M2[371]))[357] = M1(1,1); (*(M2[371]))[360] = M1(1,4); (*(M2[371]))[361] = M1(1,5); (*(M2[371]))[362] = M1(1,6); (*(M2[371]))[363] = M1(1,7); (*(M2[371]))[364] = M1(1,8); (*(M2[371]))[365] = M1(1,9); (*(M2[371]))[366] = M1(1,10); (*(M2[371]))[367] = M1(1,11); (*(M2[371]))[368] = M1(1,12); (*(M2[371]))[369] = M1(1,13); (*(M2[371]))[370] = M1(1,14); (*(M2[371]))[371] = M1(1,15); (*(M2[371]))[372] = M1(1,16); (*(M2[371]))[373] = M1(1,17); (*(M2[371]))[374] = M1(1,18); (*(M2[371]))[396] = M1(1,19); (*(M2[371]))[403] = M1(1,24); (*(M2[371]))[404] = M1(1,25); (*(M2[371]))[405] = M1(1,26); (*(M2[371]))[406] = M1(1,27); 
(*(M2[372]))[358] = M1(2,2); (*(M2[372]))[360] = M1(2,4); (*(M2[372]))[361] = M1(2,5); (*(M2[372]))[362] = M1(2,6); (*(M2[372]))[363] = M1(2,7); (*(M2[372]))[364] = M1(2,8); (*(M2[372]))[365] = M1(2,9); (*(M2[372]))[366] = M1(2,10); (*(M2[372]))[367] = M1(2,11); (*(M2[372]))[368] = M1(2,12); (*(M2[372]))[369] = M1(2,13); (*(M2[372]))[370] = M1(2,14); (*(M2[372]))[371] = M1(2,15); (*(M2[372]))[372] = M1(2,16); (*(M2[372]))[373] = M1(2,17); (*(M2[372]))[374] = M1(2,18); (*(M2[372]))[396] = M1(2,19); (*(M2[372]))[403] = M1(2,24); (*(M2[372]))[404] = M1(2,25); (*(M2[372]))[405] = M1(2,26); (*(M2[372]))[406] = M1(2,27); 
(*(M2[373]))[359] = M1(3,3); (*(M2[373]))[360] = M1(3,4); (*(M2[373]))[361] = M1(3,5); (*(M2[373]))[362] = M1(3,6); (*(M2[373]))[363] = M1(3,7); (*(M2[373]))[364] = M1(3,8); (*(M2[373]))[365] = M1(3,9); (*(M2[373]))[366] = M1(3,10); (*(M2[373]))[367] = M1(3,11); (*(M2[373]))[368] = M1(3,12); (*(M2[373]))[369] = M1(3,13); (*(M2[373]))[370] = M1(3,14); (*(M2[373]))[371] = M1(3,15); (*(M2[373]))[372] = M1(3,16); (*(M2[373]))[373] = M1(3,17); (*(M2[373]))[374] = M1(3,18); (*(M2[373]))[396] = M1(3,19); (*(M2[373]))[403] = M1(3,24); (*(M2[373]))[404] = M1(3,25); (*(M2[373]))[405] = M1(3,26); (*(M2[373]))[406] = M1(3,27); 
(*(M2[374]))[385] = M1(4,20); (*(M2[374]))[387] = M1(4,21); (*(M2[374]))[390] = M1(4,22); (*(M2[374]))[400] = M1(4,23); (*(M2[374]))[410] = M1(4,28); 
(*(M2[375]))[346] = M1(0,0); (*(M2[375]))[350] = M1(0,4); (*(M2[375]))[351] = M1(0,5); (*(M2[375]))[352] = M1(0,6); (*(M2[375]))[353] = M1(0,7); (*(M2[375]))[354] = M1(0,8); (*(M2[375]))[355] = M1(0,9); (*(M2[375]))[360] = M1(0,10); (*(M2[375]))[361] = M1(0,11); (*(M2[375]))[362] = M1(0,12); (*(M2[375]))[363] = M1(0,13); (*(M2[375]))[364] = M1(0,14); (*(M2[375]))[365] = M1(0,15); (*(M2[375]))[369] = M1(0,16); (*(M2[375]))[370] = M1(0,17); (*(M2[375]))[371] = M1(0,18); (*(M2[375]))[374] = M1(0,19); (*(M2[375]))[394] = M1(0,24); (*(M2[375]))[401] = M1(0,25); (*(M2[375]))[402] = M1(0,26); (*(M2[375]))[405] = M1(0,27); 
(*(M2[376]))[347] = M1(1,1); (*(M2[376]))[350] = M1(1,4); (*(M2[376]))[351] = M1(1,5); (*(M2[376]))[352] = M1(1,6); (*(M2[376]))[353] = M1(1,7); (*(M2[376]))[354] = M1(1,8); (*(M2[376]))[355] = M1(1,9); (*(M2[376]))[360] = M1(1,10); (*(M2[376]))[361] = M1(1,11); (*(M2[376]))[362] = M1(1,12); (*(M2[376]))[363] = M1(1,13); (*(M2[376]))[364] = M1(1,14); (*(M2[376]))[365] = M1(1,15); (*(M2[376]))[369] = M1(1,16); (*(M2[376]))[370] = M1(1,17); (*(M2[376]))[371] = M1(1,18); (*(M2[376]))[374] = M1(1,19); (*(M2[376]))[394] = M1(1,24); (*(M2[376]))[401] = M1(1,25); (*(M2[376]))[402] = M1(1,26); (*(M2[376]))[405] = M1(1,27); 
(*(M2[377]))[348] = M1(2,2); (*(M2[377]))[350] = M1(2,4); (*(M2[377]))[351] = M1(2,5); (*(M2[377]))[352] = M1(2,6); (*(M2[377]))[353] = M1(2,7); (*(M2[377]))[354] = M1(2,8); (*(M2[377]))[355] = M1(2,9); (*(M2[377]))[360] = M1(2,10); (*(M2[377]))[361] = M1(2,11); (*(M2[377]))[362] = M1(2,12); (*(M2[377]))[363] = M1(2,13); (*(M2[377]))[364] = M1(2,14); (*(M2[377]))[365] = M1(2,15); (*(M2[377]))[369] = M1(2,16); (*(M2[377]))[370] = M1(2,17); (*(M2[377]))[371] = M1(2,18); (*(M2[377]))[374] = M1(2,19); (*(M2[377]))[394] = M1(2,24); (*(M2[377]))[401] = M1(2,25); (*(M2[377]))[402] = M1(2,26); (*(M2[377]))[405] = M1(2,27); 
(*(M2[378]))[349] = M1(3,3); (*(M2[378]))[350] = M1(3,4); (*(M2[378]))[351] = M1(3,5); (*(M2[378]))[352] = M1(3,6); (*(M2[378]))[353] = M1(3,7); (*(M2[378]))[354] = M1(3,8); (*(M2[378]))[355] = M1(3,9); (*(M2[378]))[360] = M1(3,10); (*(M2[378]))[361] = M1(3,11); (*(M2[378]))[362] = M1(3,12); (*(M2[378]))[363] = M1(3,13); (*(M2[378]))[364] = M1(3,14); (*(M2[378]))[365] = M1(3,15); (*(M2[378]))[369] = M1(3,16); (*(M2[378]))[370] = M1(3,17); (*(M2[378]))[371] = M1(3,18); (*(M2[378]))[374] = M1(3,19); (*(M2[378]))[394] = M1(3,24); (*(M2[378]))[401] = M1(3,25); (*(M2[378]))[402] = M1(3,26); (*(M2[378]))[405] = M1(3,27); 
(*(M2[379]))[379] = M1(4,20); (*(M2[379]))[381] = M1(4,21); (*(M2[379]))[384] = M1(4,22); (*(M2[379]))[399] = M1(4,23); (*(M2[379]))[409] = M1(4,28); 
(*(M2[380]))[342] = M1(0,0); (*(M2[380]))[347] = M1(0,4); (*(M2[380]))[348] = M1(0,5); (*(M2[380]))[349] = M1(0,6); (*(M2[380]))[351] = M1(0,7); (*(M2[380]))[352] = M1(0,8); (*(M2[380]))[354] = M1(0,9); (*(M2[380]))[357] = M1(0,10); (*(M2[380]))[358] = M1(0,11); (*(M2[380]))[359] = M1(0,12); (*(M2[380]))[361] = M1(0,13); (*(M2[380]))[362] = M1(0,14); (*(M2[380]))[364] = M1(0,15); (*(M2[380]))[367] = M1(0,16); (*(M2[380]))[368] = M1(0,17); (*(M2[380]))[370] = M1(0,18); (*(M2[380]))[373] = M1(0,19); (*(M2[380]))[392] = M1(0,24); (*(M2[380]))[393] = M1(0,25); (*(M2[380]))[401] = M1(0,26); (*(M2[380]))[404] = M1(0,27); 
(*(M2[381]))[343] = M1(1,1); (*(M2[381]))[347] = M1(1,4); (*(M2[381]))[348] = M1(1,5); (*(M2[381]))[349] = M1(1,6); (*(M2[381]))[351] = M1(1,7); (*(M2[381]))[352] = M1(1,8); (*(M2[381]))[354] = M1(1,9); (*(M2[381]))[357] = M1(1,10); (*(M2[381]))[358] = M1(1,11); (*(M2[381]))[359] = M1(1,12); (*(M2[381]))[361] = M1(1,13); (*(M2[381]))[362] = M1(1,14); (*(M2[381]))[364] = M1(1,15); (*(M2[381]))[367] = M1(1,16); (*(M2[381]))[368] = M1(1,17); (*(M2[381]))[370] = M1(1,18); (*(M2[381]))[373] = M1(1,19); (*(M2[381]))[392] = M1(1,24); (*(M2[381]))[393] = M1(1,25); (*(M2[381]))[401] = M1(1,26); (*(M2[381]))[404] = M1(1,27); 
(*(M2[382]))[344] = M1(2,2); (*(M2[382]))[347] = M1(2,4); (*(M2[382]))[348] = M1(2,5); (*(M2[382]))[349] = M1(2,6); (*(M2[382]))[351] = M1(2,7); (*(M2[382]))[352] = M1(2,8); (*(M2[382]))[354] = M1(2,9); (*(M2[382]))[357] = M1(2,10); (*(M2[382]))[358] = M1(2,11); (*(M2[382]))[359] = M1(2,12); (*(M2[382]))[361] = M1(2,13); (*(M2[382]))[362] = M1(2,14); (*(M2[382]))[364] = M1(2,15); (*(M2[382]))[367] = M1(2,16); (*(M2[382]))[368] = M1(2,17); (*(M2[382]))[370] = M1(2,18); (*(M2[382]))[373] = M1(2,19); (*(M2[382]))[392] = M1(2,24); (*(M2[382]))[393] = M1(2,25); (*(M2[382]))[401] = M1(2,26); (*(M2[382]))[404] = M1(2,27); 
(*(M2[383]))[345] = M1(3,3); (*(M2[383]))[347] = M1(3,4); (*(M2[383]))[348] = M1(3,5); (*(M2[383]))[349] = M1(3,6); (*(M2[383]))[351] = M1(3,7); (*(M2[383]))[352] = M1(3,8); (*(M2[383]))[354] = M1(3,9); (*(M2[383]))[357] = M1(3,10); (*(M2[383]))[358] = M1(3,11); (*(M2[383]))[359] = M1(3,12); (*(M2[383]))[361] = M1(3,13); (*(M2[383]))[362] = M1(3,14); (*(M2[383]))[364] = M1(3,15); (*(M2[383]))[367] = M1(3,16); (*(M2[383]))[368] = M1(3,17); (*(M2[383]))[370] = M1(3,18); (*(M2[383]))[373] = M1(3,19); (*(M2[383]))[392] = M1(3,24); (*(M2[383]))[393] = M1(3,25); (*(M2[383]))[401] = M1(3,26); (*(M2[383]))[404] = M1(3,27); 
(*(M2[384]))[376] = M1(4,20); (*(M2[384]))[378] = M1(4,21); (*(M2[384]))[383] = M1(4,22); (*(M2[384]))[398] = M1(4,23); (*(M2[384]))[408] = M1(4,28); 
(*(M2[385]))[341] = M1(0,0); (*(M2[385]))[346] = M1(0,4); (*(M2[385]))[347] = M1(0,5); (*(M2[385]))[348] = M1(0,6); (*(M2[385]))[350] = M1(0,7); (*(M2[385]))[351] = M1(0,8); (*(M2[385]))[353] = M1(0,9); (*(M2[385]))[356] = M1(0,10); (*(M2[385]))[357] = M1(0,11); (*(M2[385]))[358] = M1(0,12); (*(M2[385]))[360] = M1(0,13); (*(M2[385]))[361] = M1(0,14); (*(M2[385]))[363] = M1(0,15); (*(M2[385]))[366] = M1(0,16); (*(M2[385]))[367] = M1(0,17); (*(M2[385]))[369] = M1(0,18); (*(M2[385]))[372] = M1(0,19); (*(M2[385]))[391] = M1(0,24); (*(M2[385]))[392] = M1(0,25); (*(M2[385]))[394] = M1(0,26); (*(M2[385]))[403] = M1(0,27); 
(*(M2[386]))[342] = M1(1,1); (*(M2[386]))[346] = M1(1,4); (*(M2[386]))[347] = M1(1,5); (*(M2[386]))[348] = M1(1,6); (*(M2[386]))[350] = M1(1,7); (*(M2[386]))[351] = M1(1,8); (*(M2[386]))[353] = M1(1,9); (*(M2[386]))[356] = M1(1,10); (*(M2[386]))[357] = M1(1,11); (*(M2[386]))[358] = M1(1,12); (*(M2[386]))[360] = M1(1,13); (*(M2[386]))[361] = M1(1,14); (*(M2[386]))[363] = M1(1,15); (*(M2[386]))[366] = M1(1,16); (*(M2[386]))[367] = M1(1,17); (*(M2[386]))[369] = M1(1,18); (*(M2[386]))[372] = M1(1,19); (*(M2[386]))[391] = M1(1,24); (*(M2[386]))[392] = M1(1,25); (*(M2[386]))[394] = M1(1,26); (*(M2[386]))[403] = M1(1,27); 
(*(M2[387]))[343] = M1(2,2); (*(M2[387]))[346] = M1(2,4); (*(M2[387]))[347] = M1(2,5); (*(M2[387]))[348] = M1(2,6); (*(M2[387]))[350] = M1(2,7); (*(M2[387]))[351] = M1(2,8); (*(M2[387]))[353] = M1(2,9); (*(M2[387]))[356] = M1(2,10); (*(M2[387]))[357] = M1(2,11); (*(M2[387]))[358] = M1(2,12); (*(M2[387]))[360] = M1(2,13); (*(M2[387]))[361] = M1(2,14); (*(M2[387]))[363] = M1(2,15); (*(M2[387]))[366] = M1(2,16); (*(M2[387]))[367] = M1(2,17); (*(M2[387]))[369] = M1(2,18); (*(M2[387]))[372] = M1(2,19); (*(M2[387]))[391] = M1(2,24); (*(M2[387]))[392] = M1(2,25); (*(M2[387]))[394] = M1(2,26); (*(M2[387]))[403] = M1(2,27); 
(*(M2[388]))[344] = M1(3,3); (*(M2[388]))[346] = M1(3,4); (*(M2[388]))[347] = M1(3,5); (*(M2[388]))[348] = M1(3,6); (*(M2[388]))[350] = M1(3,7); (*(M2[388]))[351] = M1(3,8); (*(M2[388]))[353] = M1(3,9); (*(M2[388]))[356] = M1(3,10); (*(M2[388]))[357] = M1(3,11); (*(M2[388]))[358] = M1(3,12); (*(M2[388]))[360] = M1(3,13); (*(M2[388]))[361] = M1(3,14); (*(M2[388]))[363] = M1(3,15); (*(M2[388]))[366] = M1(3,16); (*(M2[388]))[367] = M1(3,17); (*(M2[388]))[369] = M1(3,18); (*(M2[388]))[372] = M1(3,19); (*(M2[388]))[391] = M1(3,24); (*(M2[388]))[392] = M1(3,25); (*(M2[388]))[394] = M1(3,26); (*(M2[388]))[403] = M1(3,27); 
(*(M2[389]))[375] = M1(4,20); (*(M2[389]))[377] = M1(4,21); (*(M2[389]))[382] = M1(4,22); (*(M2[389]))[397] = M1(4,23); (*(M2[389]))[407] = M1(4,28); 
(*(M2[390]))[375] = M1(0,0); (*(M2[390]))[379] = M1(0,4); (*(M2[390]))[380] = M1(0,5); (*(M2[390]))[381] = M1(0,6); (*(M2[390]))[382] = M1(0,7); (*(M2[390]))[383] = M1(0,8); (*(M2[390]))[384] = M1(0,9); (*(M2[390]))[385] = M1(0,10); (*(M2[390]))[386] = M1(0,11); (*(M2[390]))[387] = M1(0,12); (*(M2[390]))[388] = M1(0,13); (*(M2[390]))[389] = M1(0,14); (*(M2[390]))[390] = M1(0,15); (*(M2[390]))[397] = M1(0,16); (*(M2[390]))[398] = M1(0,17); (*(M2[390]))[399] = M1(0,18); (*(M2[390]))[400] = M1(0,19); (*(M2[390]))[407] = M1(0,24); (*(M2[390]))[408] = M1(0,25); (*(M2[390]))[409] = M1(0,26); (*(M2[390]))[410] = M1(0,27); 
(*(M2[391]))[376] = M1(1,1); (*(M2[391]))[379] = M1(1,4); (*(M2[391]))[380] = M1(1,5); (*(M2[391]))[381] = M1(1,6); (*(M2[391]))[382] = M1(1,7); (*(M2[391]))[383] = M1(1,8); (*(M2[391]))[384] = M1(1,9); (*(M2[391]))[385] = M1(1,10); (*(M2[391]))[386] = M1(1,11); (*(M2[391]))[387] = M1(1,12); (*(M2[391]))[388] = M1(1,13); (*(M2[391]))[389] = M1(1,14); (*(M2[391]))[390] = M1(1,15); (*(M2[391]))[397] = M1(1,16); (*(M2[391]))[398] = M1(1,17); (*(M2[391]))[399] = M1(1,18); (*(M2[391]))[400] = M1(1,19); (*(M2[391]))[407] = M1(1,24); (*(M2[391]))[408] = M1(1,25); (*(M2[391]))[409] = M1(1,26); (*(M2[391]))[410] = M1(1,27); 
(*(M2[392]))[377] = M1(2,2); (*(M2[392]))[379] = M1(2,4); (*(M2[392]))[380] = M1(2,5); (*(M2[392]))[381] = M1(2,6); (*(M2[392]))[382] = M1(2,7); (*(M2[392]))[383] = M1(2,8); (*(M2[392]))[384] = M1(2,9); (*(M2[392]))[385] = M1(2,10); (*(M2[392]))[386] = M1(2,11); (*(M2[392]))[387] = M1(2,12); (*(M2[392]))[388] = M1(2,13); (*(M2[392]))[389] = M1(2,14); (*(M2[392]))[390] = M1(2,15); (*(M2[392]))[397] = M1(2,16); (*(M2[392]))[398] = M1(2,17); (*(M2[392]))[399] = M1(2,18); (*(M2[392]))[400] = M1(2,19); (*(M2[392]))[407] = M1(2,24); (*(M2[392]))[408] = M1(2,25); (*(M2[392]))[409] = M1(2,26); (*(M2[392]))[410] = M1(2,27); 
(*(M2[393]))[378] = M1(3,3); (*(M2[393]))[379] = M1(3,4); (*(M2[393]))[380] = M1(3,5); (*(M2[393]))[381] = M1(3,6); (*(M2[393]))[382] = M1(3,7); (*(M2[393]))[383] = M1(3,8); (*(M2[393]))[384] = M1(3,9); (*(M2[393]))[385] = M1(3,10); (*(M2[393]))[386] = M1(3,11); (*(M2[393]))[387] = M1(3,12); (*(M2[393]))[388] = M1(3,13); (*(M2[393]))[389] = M1(3,14); (*(M2[393]))[390] = M1(3,15); (*(M2[393]))[397] = M1(3,16); (*(M2[393]))[398] = M1(3,17); (*(M2[393]))[399] = M1(3,18); (*(M2[393]))[400] = M1(3,19); (*(M2[393]))[407] = M1(3,24); (*(M2[393]))[408] = M1(3,25); (*(M2[393]))[409] = M1(3,26); (*(M2[393]))[410] = M1(3,27); 
(*(M2[394]))[391] = M1(4,20); (*(M2[394]))[393] = M1(4,21); (*(M2[394]))[402] = M1(4,22); (*(M2[394]))[406] = M1(4,23); (*(M2[394]))[411] = M1(4,28); 

opengv::math::gauss_jordan(M2,340);
Action = Eigen::Matrix<double,16,16>::Zero();
for( int s = 0; s < 16; s++ )
  Action(0,s) -= (*(M2[340]))[396+s];
for( int s = 0; s < 16; s++ )
  Action(1,s) -= (*(M2[372]))[396+s];
for( int s = 0; s < 16; s++ )
  Action(2,s) -= (*(M2[373]))[396+s];
for( int s = 0; s < 16; s++ )
  Action(3,s) -= (*(M2[374]))[396+s];
Action(4,0) = 1.0;
for( int s = 0; s < 16; s++ )
  Action(5,s) -= (*(M2[389]))[396+s];
for( int s = 0; s < 16; s++ )
  Action(6,s) -= (*(M2[390]))[396+s];
Action(7,1) = 1.0;
Action(8,2) = 1.0;
Action(9,3) = 1.0;
Action(10,4) = 1.0;
Action(11,7) = 1.0;
Action(12,8) = 1.0;
Action(13,9) = 1.0;
Action(14,10) = 1.0;
Action(15,14) = 1.0;
//columns of Action mean:
// x_4^4 x_1*x_4^2 x_2*x_4^2 x_3*x_4^2 x_4^3 x_2*x_3 x_3^2 x_1*x_4 x_2*x_4 x_3*x_4 x_4^2 x_1 x_2 x_3 x_4 1

for( int r = 0; r < 395; r++ )
  delete M2[r];
}

