{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Sorts items via a callback function.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.CustomSorter
    ( 

-- * Exported types
    CustomSorter(..)                        ,
    IsCustomSorter                          ,
    toCustomSorter                          ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [changed]("GI.Gtk.Objects.Sorter#g:method:changed"), [compare]("GI.Gtk.Objects.Sorter#g:method:compare"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getOrder]("GI.Gtk.Objects.Sorter#g:method:getOrder"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setSortFunc]("GI.Gtk.Objects.CustomSorter#g:method:setSortFunc").

#if defined(ENABLE_OVERLOADING)
    ResolveCustomSorterMethod               ,
#endif

-- ** new #method:new#

    customSorterNew                         ,


-- ** setSortFunc #method:setSortFunc#

#if defined(ENABLE_OVERLOADING)
    CustomSorterSetSortFuncMethodInfo       ,
#endif
    customSorterSetSortFunc                 ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Objects.Sorter as Gtk.Sorter

#else
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Objects.Sorter as Gtk.Sorter

#endif

-- | Memory-managed wrapper type.
newtype CustomSorter = CustomSorter (SP.ManagedPtr CustomSorter)
    deriving (Eq)

instance SP.ManagedPtrNewtype CustomSorter where
    toManagedPtr (CustomSorter p) = p

foreign import ccall "gtk_custom_sorter_get_type"
    c_gtk_custom_sorter_get_type :: IO B.Types.GType

instance B.Types.TypedObject CustomSorter where
    glibType = c_gtk_custom_sorter_get_type

instance B.Types.GObject CustomSorter

-- | Type class for types which can be safely cast to t'CustomSorter', for instance with `toCustomSorter`.
class (SP.GObject o, O.IsDescendantOf CustomSorter o) => IsCustomSorter o
instance (SP.GObject o, O.IsDescendantOf CustomSorter o) => IsCustomSorter o

instance O.HasParentTypes CustomSorter
type instance O.ParentTypes CustomSorter = '[Gtk.Sorter.Sorter, GObject.Object.Object]

-- | Cast to t'CustomSorter', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toCustomSorter :: (MIO.MonadIO m, IsCustomSorter o) => o -> m CustomSorter
toCustomSorter = MIO.liftIO . B.ManagedPtr.unsafeCastTo CustomSorter

-- | Convert t'CustomSorter' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe CustomSorter) where
    gvalueGType_ = c_gtk_custom_sorter_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr CustomSorter)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr CustomSorter)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject CustomSorter ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveCustomSorterMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveCustomSorterMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveCustomSorterMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveCustomSorterMethod "changed" o = Gtk.Sorter.SorterChangedMethodInfo
    ResolveCustomSorterMethod "compare" o = Gtk.Sorter.SorterCompareMethodInfo
    ResolveCustomSorterMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveCustomSorterMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveCustomSorterMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveCustomSorterMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveCustomSorterMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveCustomSorterMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveCustomSorterMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveCustomSorterMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveCustomSorterMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveCustomSorterMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveCustomSorterMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveCustomSorterMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveCustomSorterMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveCustomSorterMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveCustomSorterMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveCustomSorterMethod "getOrder" o = Gtk.Sorter.SorterGetOrderMethodInfo
    ResolveCustomSorterMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveCustomSorterMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveCustomSorterMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveCustomSorterMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveCustomSorterMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveCustomSorterMethod "setSortFunc" o = CustomSorterSetSortFuncMethodInfo
    ResolveCustomSorterMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveCustomSorterMethod t CustomSorter, O.OverloadedMethod info CustomSorter p) => OL.IsLabel t (CustomSorter -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveCustomSorterMethod t CustomSorter, O.OverloadedMethod info CustomSorter p, R.HasField t CustomSorter p) => R.HasField t CustomSorter p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveCustomSorterMethod t CustomSorter, O.OverloadedMethodInfo info CustomSorter) => OL.IsLabel t (O.MethodProxy info CustomSorter) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList CustomSorter
type instance O.AttributeList CustomSorter = CustomSorterAttributeList
type CustomSorterAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList CustomSorter = CustomSorterSignalList
type CustomSorterSignalList = ('[ '("changed", Gtk.Sorter.SorterChangedSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method CustomSorter::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "sort_func"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "CompareDataFunc" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the `GCompareDataFunc` to use for sorting"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeNotified
--           , argClosure = 1
--           , argDestroy = 2
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data to pass to @sort_func"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_destroy"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "DestroyNotify" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "destroy notify for @user_data"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "CustomSorter" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_custom_sorter_new" gtk_custom_sorter_new :: 
    FunPtr GLib.Callbacks.C_CompareDataFunc -> -- sort_func : TInterface (Name {namespace = "GLib", name = "CompareDataFunc"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    FunPtr GLib.Callbacks.C_DestroyNotify -> -- user_destroy : TInterface (Name {namespace = "GLib", name = "DestroyNotify"})
    IO (Ptr CustomSorter)

-- | Creates a new @GtkSorter@ that works by calling
-- /@sortFunc@/ to compare items.
-- 
-- If /@sortFunc@/ is 'P.Nothing', all items are considered equal.
customSorterNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (GLib.Callbacks.CompareDataFunc)
    -- ^ /@sortFunc@/: the @GCompareDataFunc@ to use for sorting
    -> m CustomSorter
    -- ^ __Returns:__ a new @GtkCustomSorter@
customSorterNew sortFunc = liftIO $ do
    maybeSortFunc <- case sortFunc of
        Nothing -> return FP.nullFunPtr
        Just jSortFunc -> do
            jSortFunc' <- GLib.Callbacks.mk_CompareDataFunc (GLib.Callbacks.wrap_CompareDataFunc Nothing (GLib.Callbacks.drop_closures_CompareDataFunc jSortFunc))
            return jSortFunc'
    let userData = castFunPtrToPtr maybeSortFunc
    let userDestroy = SP.safeFreeFunPtrPtr
    result <- gtk_custom_sorter_new maybeSortFunc userData userDestroy
    checkUnexpectedReturnNULL "customSorterNew" result
    result' <- (wrapObject CustomSorter) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method CustomSorter::set_sort_func
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "CustomSorter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkCustomSorter`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "sort_func"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "CompareDataFunc" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "function to sort items"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeNotified
--           , argClosure = 2
--           , argDestroy = 3
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data to pass to @match_func"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_destroy"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "DestroyNotify" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "destroy notify for @user_data"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_custom_sorter_set_sort_func" gtk_custom_sorter_set_sort_func :: 
    Ptr CustomSorter ->                     -- self : TInterface (Name {namespace = "Gtk", name = "CustomSorter"})
    FunPtr GLib.Callbacks.C_CompareDataFunc -> -- sort_func : TInterface (Name {namespace = "GLib", name = "CompareDataFunc"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    FunPtr GLib.Callbacks.C_DestroyNotify -> -- user_destroy : TInterface (Name {namespace = "GLib", name = "DestroyNotify"})
    IO ()

-- | Sets (or unsets) the function used for sorting items.
-- 
-- If /@sortFunc@/ is 'P.Nothing', all items are considered equal.
-- 
-- If the sort func changes its sorting behavior,
-- 'GI.Gtk.Objects.Sorter.sorterChanged' needs to be called.
-- 
-- If a previous function was set, its /@userDestroy@/ will be
-- called now.
customSorterSetSortFunc ::
    (B.CallStack.HasCallStack, MonadIO m, IsCustomSorter a) =>
    a
    -- ^ /@self@/: a @GtkCustomSorter@
    -> Maybe (GLib.Callbacks.CompareDataFunc)
    -- ^ /@sortFunc@/: function to sort items
    -> m ()
customSorterSetSortFunc self sortFunc = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeSortFunc <- case sortFunc of
        Nothing -> return FP.nullFunPtr
        Just jSortFunc -> do
            jSortFunc' <- GLib.Callbacks.mk_CompareDataFunc (GLib.Callbacks.wrap_CompareDataFunc Nothing (GLib.Callbacks.drop_closures_CompareDataFunc jSortFunc))
            return jSortFunc'
    let userData = castFunPtrToPtr maybeSortFunc
    let userDestroy = SP.safeFreeFunPtrPtr
    gtk_custom_sorter_set_sort_func self' maybeSortFunc userData userDestroy
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data CustomSorterSetSortFuncMethodInfo
instance (signature ~ (Maybe (GLib.Callbacks.CompareDataFunc) -> m ()), MonadIO m, IsCustomSorter a) => O.OverloadedMethod CustomSorterSetSortFuncMethodInfo a signature where
    overloadedMethod = customSorterSetSortFunc

instance O.OverloadedMethodInfo CustomSorterSetSortFuncMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.CustomSorter.customSorterSetSortFunc",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-CustomSorter.html#v:customSorterSetSortFunc"
        })


#endif


