// Copyright The prometheus-operator Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1alpha1

import (
	monitoringv1 "github.com/prometheus-operator/prometheus-operator/pkg/apis/monitoring/v1"
	applyconfigurationmonitoringv1 "github.com/prometheus-operator/prometheus-operator/pkg/client/applyconfiguration/monitoring/v1"
	v1 "k8s.io/api/core/v1"
)

// LightSailSDConfigApplyConfiguration represents a declarative configuration of the LightSailSDConfig type for use
// with apply.
type LightSailSDConfigApplyConfiguration struct {
	Region                                                       *string                                                             `json:"region,omitempty"`
	AccessKey                                                    *v1.SecretKeySelector                                               `json:"accessKey,omitempty"`
	SecretKey                                                    *v1.SecretKeySelector                                               `json:"secretKey,omitempty"`
	RoleARN                                                      *string                                                             `json:"roleARN,omitempty"`
	Endpoint                                                     *string                                                             `json:"endpoint,omitempty"`
	RefreshInterval                                              *monitoringv1.Duration                                              `json:"refreshInterval,omitempty"`
	Port                                                         *int32                                                              `json:"port,omitempty"`
	BasicAuth                                                    *applyconfigurationmonitoringv1.BasicAuthApplyConfiguration         `json:"basicAuth,omitempty"`
	Authorization                                                *applyconfigurationmonitoringv1.SafeAuthorizationApplyConfiguration `json:"authorization,omitempty"`
	OAuth2                                                       *applyconfigurationmonitoringv1.OAuth2ApplyConfiguration            `json:"oauth2,omitempty"`
	applyconfigurationmonitoringv1.ProxyConfigApplyConfiguration `json:",inline"`
	TLSConfig                                                    *applyconfigurationmonitoringv1.SafeTLSConfigApplyConfiguration `json:"tlsConfig,omitempty"`
	FollowRedirects                                              *bool                                                           `json:"followRedirects,omitempty"`
	EnableHTTP2                                                  *bool                                                           `json:"enableHTTP2,omitempty"`
}

// LightSailSDConfigApplyConfiguration constructs a declarative configuration of the LightSailSDConfig type for use with
// apply.
func LightSailSDConfig() *LightSailSDConfigApplyConfiguration {
	return &LightSailSDConfigApplyConfiguration{}
}

// WithRegion sets the Region field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Region field is set to the value of the last call.
func (b *LightSailSDConfigApplyConfiguration) WithRegion(value string) *LightSailSDConfigApplyConfiguration {
	b.Region = &value
	return b
}

// WithAccessKey sets the AccessKey field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the AccessKey field is set to the value of the last call.
func (b *LightSailSDConfigApplyConfiguration) WithAccessKey(value v1.SecretKeySelector) *LightSailSDConfigApplyConfiguration {
	b.AccessKey = &value
	return b
}

// WithSecretKey sets the SecretKey field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the SecretKey field is set to the value of the last call.
func (b *LightSailSDConfigApplyConfiguration) WithSecretKey(value v1.SecretKeySelector) *LightSailSDConfigApplyConfiguration {
	b.SecretKey = &value
	return b
}

// WithRoleARN sets the RoleARN field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the RoleARN field is set to the value of the last call.
func (b *LightSailSDConfigApplyConfiguration) WithRoleARN(value string) *LightSailSDConfigApplyConfiguration {
	b.RoleARN = &value
	return b
}

// WithEndpoint sets the Endpoint field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Endpoint field is set to the value of the last call.
func (b *LightSailSDConfigApplyConfiguration) WithEndpoint(value string) *LightSailSDConfigApplyConfiguration {
	b.Endpoint = &value
	return b
}

// WithRefreshInterval sets the RefreshInterval field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the RefreshInterval field is set to the value of the last call.
func (b *LightSailSDConfigApplyConfiguration) WithRefreshInterval(value monitoringv1.Duration) *LightSailSDConfigApplyConfiguration {
	b.RefreshInterval = &value
	return b
}

// WithPort sets the Port field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Port field is set to the value of the last call.
func (b *LightSailSDConfigApplyConfiguration) WithPort(value int32) *LightSailSDConfigApplyConfiguration {
	b.Port = &value
	return b
}

// WithBasicAuth sets the BasicAuth field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the BasicAuth field is set to the value of the last call.
func (b *LightSailSDConfigApplyConfiguration) WithBasicAuth(value *applyconfigurationmonitoringv1.BasicAuthApplyConfiguration) *LightSailSDConfigApplyConfiguration {
	b.BasicAuth = value
	return b
}

// WithAuthorization sets the Authorization field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Authorization field is set to the value of the last call.
func (b *LightSailSDConfigApplyConfiguration) WithAuthorization(value *applyconfigurationmonitoringv1.SafeAuthorizationApplyConfiguration) *LightSailSDConfigApplyConfiguration {
	b.Authorization = value
	return b
}

// WithOAuth2 sets the OAuth2 field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the OAuth2 field is set to the value of the last call.
func (b *LightSailSDConfigApplyConfiguration) WithOAuth2(value *applyconfigurationmonitoringv1.OAuth2ApplyConfiguration) *LightSailSDConfigApplyConfiguration {
	b.OAuth2 = value
	return b
}

// WithProxyURL sets the ProxyURL field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ProxyURL field is set to the value of the last call.
func (b *LightSailSDConfigApplyConfiguration) WithProxyURL(value string) *LightSailSDConfigApplyConfiguration {
	b.ProxyConfigApplyConfiguration.ProxyURL = &value
	return b
}

// WithNoProxy sets the NoProxy field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the NoProxy field is set to the value of the last call.
func (b *LightSailSDConfigApplyConfiguration) WithNoProxy(value string) *LightSailSDConfigApplyConfiguration {
	b.ProxyConfigApplyConfiguration.NoProxy = &value
	return b
}

// WithProxyFromEnvironment sets the ProxyFromEnvironment field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ProxyFromEnvironment field is set to the value of the last call.
func (b *LightSailSDConfigApplyConfiguration) WithProxyFromEnvironment(value bool) *LightSailSDConfigApplyConfiguration {
	b.ProxyConfigApplyConfiguration.ProxyFromEnvironment = &value
	return b
}

// WithProxyConnectHeader puts the entries into the ProxyConnectHeader field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the ProxyConnectHeader field,
// overwriting an existing map entries in ProxyConnectHeader field with the same key.
func (b *LightSailSDConfigApplyConfiguration) WithProxyConnectHeader(entries map[string][]v1.SecretKeySelector) *LightSailSDConfigApplyConfiguration {
	if b.ProxyConfigApplyConfiguration.ProxyConnectHeader == nil && len(entries) > 0 {
		b.ProxyConfigApplyConfiguration.ProxyConnectHeader = make(map[string][]v1.SecretKeySelector, len(entries))
	}
	for k, v := range entries {
		b.ProxyConfigApplyConfiguration.ProxyConnectHeader[k] = v
	}
	return b
}

// WithTLSConfig sets the TLSConfig field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the TLSConfig field is set to the value of the last call.
func (b *LightSailSDConfigApplyConfiguration) WithTLSConfig(value *applyconfigurationmonitoringv1.SafeTLSConfigApplyConfiguration) *LightSailSDConfigApplyConfiguration {
	b.TLSConfig = value
	return b
}

// WithFollowRedirects sets the FollowRedirects field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the FollowRedirects field is set to the value of the last call.
func (b *LightSailSDConfigApplyConfiguration) WithFollowRedirects(value bool) *LightSailSDConfigApplyConfiguration {
	b.FollowRedirects = &value
	return b
}

// WithEnableHTTP2 sets the EnableHTTP2 field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the EnableHTTP2 field is set to the value of the last call.
func (b *LightSailSDConfigApplyConfiguration) WithEnableHTTP2(value bool) *LightSailSDConfigApplyConfiguration {
	b.EnableHTTP2 = &value
	return b
}
