/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, iio, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */

static const char* __doc_gr_iio_device_sink = R"doc(Generic sink for IIO drivers with buffered input channels.

This block allows for streaming data to any IIO driver which has input scan elements or buffered channels.

Constructor Specific Documentation:

Return a shared_ptr to a new instance of iio::device.

Args:
    uri : String of the context uri
    device : String of device name
    channels : Vector of strings of channels names
    device_phy : String of phy device name where attribute updates are applied
    params : Vector of strings of attributes to set in form: \"<attribute name>=<value to set>,<attribute name>=<value to set>\"
    buffer_size : Integer number of samples to be put into each IIO buffered passed to hardware.
    interpolation : Integer number of zeros to insert into transmit transmit buffers between samples
    cyclic : Boolean when True sends first buffer_size number of samples to hardware which is repeated in the hardware itself. Future samples are ignored.)doc";

static const char* __doc_gr_iio_device_sink_make = R"doc(Generic sink for IIO drivers with buffered input channels.

This block allows for streaming data to any IIO driver which has input scan elements or buffered channels.

Constructor Specific Documentation:

Return a shared_ptr to a new instance of iio::device.

Args:
    uri : String of the context uri
    device : String of device name
    channels : Vector of strings of channels names
    device_phy : String of phy device name where attribute updates are applied
    params : Vector of strings of attributes to set in form: \"<attribute name>=<value to set>,<attribute name>=<value to set>\"
    buffer_size : Integer number of samples to be put into each IIO buffered passed to hardware.
    interpolation : Integer number of zeros to insert into transmit transmit buffers between samples
    cyclic : Boolean when True sends first buffer_size number of samples to hardware which is repeated in the hardware itself. Future samples are ignored.)doc";

static const char* __doc_gr_iio_device_sink_set_len_tag_key = R"doc(The key of the tag that indicates packet length. When not empty, samples are expected as \"packets\" and must be tagged as such, i.e. the first sample of a packet needs to be tagged with the corresponding length of that packet. Note, packet size MUST be equal to buffer_size / (1+interpolation), otherwise a runtime_error will be thrown. This is a deliberate design choice, because all other options would result in potentially unexpected behavior.)doc";
