/* gnome-sudoku.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gnome-sudoku.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * Copyright © 2014 Parin Porecha
 * Copyright © 2014 Michael Catanzaro
 *
 * This file is part of GNOME Sudoku.
 *
 * GNOME Sudoku is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME Sudoku is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME Sudoku. If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <adwaita.h>
#include <glib-object.h>
#include <gio/gio.h>
#include "libsudoku.h"
#include <glib/gi18n-lib.h>
#include <stdio.h>
#include <float.h>
#include <math.h>
#include <gee.h>
#include <gdk/gdk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_SUDOKU (sudoku_get_type ())
#define SUDOKU(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU, Sudoku))
#define SUDOKU_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU, SudokuClass))
#define IS_SUDOKU(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU))
#define IS_SUDOKU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU))
#define SUDOKU_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU, SudokuClass))

typedef struct _Sudoku Sudoku;
typedef struct _SudokuClass SudokuClass;
typedef struct _SudokuPrivate SudokuPrivate;

#define TYPE_SUDOKU_WINDOW (sudoku_window_get_type ())
#define SUDOKU_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_WINDOW, SudokuWindow))
#define SUDOKU_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_WINDOW, SudokuWindowClass))
#define IS_SUDOKU_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_WINDOW))
#define IS_SUDOKU_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_WINDOW))
#define SUDOKU_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_WINDOW, SudokuWindowClass))

typedef struct _SudokuWindow SudokuWindow;
typedef struct _SudokuWindowClass SudokuWindowClass;
typedef enum  {
	ZOOM_LEVEL_NONE = 0,
	ZOOM_LEVEL_SMALL = 1,
	ZOOM_LEVEL_MEDIUM = 2,
	ZOOM_LEVEL_LARGE = 3
} ZoomLevel;

#define TYPE_ZOOM_LEVEL (zoom_level_get_type ())
enum  {
	SUDOKU_0_PROPERTY,
	SUDOKU_PLAY_DIFFICULTY_PROPERTY,
	SUDOKU_ZOOM_LEVEL_PROPERTY,
	SUDOKU_SHOW_TIMER_PROPERTY,
	SUDOKU_EARMARK_MODE_PROPERTY,
	SUDOKU_SHOW_POSSIBILITIES_PROPERTY,
	SUDOKU_HIGHLIGHTER_PROPERTY,
	SUDOKU_HIGHLIGHT_ROW_COLUMN_PROPERTY,
	SUDOKU_HIGHLIGHT_BLOCK_PROPERTY,
	SUDOKU_HIGHLIGHT_NUMBERS_PROPERTY,
	SUDOKU_SHOW_WARNINGS_PROPERTY,
	SUDOKU_SOLUTION_WARNINGS_PROPERTY,
	SUDOKU_EARMARK_WARNINGS_PROPERTY,
	SUDOKU_AUTOCLEAN_EARMARKS_PROPERTY,
	SUDOKU_NUMBER_PICKER_SECOND_CLICK_PROPERTY,
	SUDOKU_NUM_PROPERTIES
};
static GParamSpec* sudoku_properties[SUDOKU_NUM_PROPERTIES];
typedef void (*GSimpleActionActivateCallback) (GSimpleAction* action, GVariant* parameter, gpointer user_data);
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_SUDOKU_GAME_VIEW (sudoku_game_view_get_type ())
#define SUDOKU_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_GAME_VIEW, SudokuGameView))
#define SUDOKU_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_GAME_VIEW, SudokuGameViewClass))
#define IS_SUDOKU_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_GAME_VIEW))
#define IS_SUDOKU_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_GAME_VIEW))
#define SUDOKU_GAME_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_GAME_VIEW, SudokuGameViewClass))

typedef struct _SudokuGameView SudokuGameView;
typedef struct _SudokuGameViewClass SudokuGameViewClass;
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
typedef struct _SudokuGameViewPrivate SudokuGameViewPrivate;

#define TYPE_SUDOKU_GRID (sudoku_grid_get_type ())
#define SUDOKU_GRID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_GRID, SudokuGrid))
#define SUDOKU_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_GRID, SudokuGridClass))
#define IS_SUDOKU_GRID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_GRID))
#define IS_SUDOKU_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_GRID))
#define SUDOKU_GRID_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_GRID, SudokuGridClass))

typedef struct _SudokuGrid SudokuGrid;
typedef struct _SudokuGridClass SudokuGridClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef enum  {
	SUDOKU_WINDOW_SCREEN_NONE,
	SUDOKU_WINDOW_SCREEN_PLAY,
	SUDOKU_WINDOW_SCREEN_CREATE,
	SUDOKU_WINDOW_SCREEN_START
} SudokuWindowScreen;

#define TYPE_SUDOKU_WINDOW_SCREEN (sudoku_window_screen_get_type ())

#define TYPE_SUDOKU_PRINTER (sudoku_printer_get_type ())
#define SUDOKU_PRINTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_PRINTER, SudokuPrinter))
#define SUDOKU_PRINTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_PRINTER, SudokuPrinterClass))
#define IS_SUDOKU_PRINTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_PRINTER))
#define IS_SUDOKU_PRINTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_PRINTER))
#define SUDOKU_PRINTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_PRINTER, SudokuPrinterClass))

typedef struct _SudokuPrinter SudokuPrinter;
typedef struct _SudokuPrinterClass SudokuPrinterClass;

#define TYPE_SUDOKU_PRINT_DIALOG (sudoku_print_dialog_get_type ())
#define SUDOKU_PRINT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_PRINT_DIALOG, SudokuPrintDialog))
#define SUDOKU_PRINT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_PRINT_DIALOG, SudokuPrintDialogClass))
#define IS_SUDOKU_PRINT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_PRINT_DIALOG))
#define IS_SUDOKU_PRINT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_PRINT_DIALOG))
#define SUDOKU_PRINT_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_PRINT_DIALOG, SudokuPrintDialogClass))

typedef struct _SudokuPrintDialog SudokuPrintDialog;
typedef struct _SudokuPrintDialogClass SudokuPrintDialogClass;

#define TYPE_SUDOKU_PREFERENCES_DIALOG (sudoku_preferences_dialog_get_type ())
#define SUDOKU_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_PREFERENCES_DIALOG, SudokuPreferencesDialog))
#define SUDOKU_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_PREFERENCES_DIALOG, SudokuPreferencesDialogClass))
#define IS_SUDOKU_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_PREFERENCES_DIALOG))
#define IS_SUDOKU_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_PREFERENCES_DIALOG))
#define SUDOKU_PREFERENCES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_PREFERENCES_DIALOG, SudokuPreferencesDialogClass))

typedef struct _SudokuPreferencesDialog SudokuPreferencesDialog;
typedef struct _SudokuPreferencesDialogClass SudokuPreferencesDialogClass;
typedef struct _SudokuWindowPrivate SudokuWindowPrivate;

#define TYPE_SUDOKU_START_VIEW (sudoku_start_view_get_type ())
#define SUDOKU_START_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_START_VIEW, SudokuStartView))
#define SUDOKU_START_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_START_VIEW, SudokuStartViewClass))
#define IS_SUDOKU_START_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_START_VIEW))
#define IS_SUDOKU_START_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_START_VIEW))
#define SUDOKU_START_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_START_VIEW, SudokuStartViewClass))

typedef struct _SudokuStartView SudokuStartView;
typedef struct _SudokuStartViewClass SudokuStartViewClass;

struct _Sudoku {
	AdwApplication parent_instance;
	SudokuPrivate * priv;
};

struct _SudokuClass {
	AdwApplicationClass parent_class;
};

struct _SudokuPrivate {
	GSettings* settings;
	SudokuWindow* window;
	SudokuSaver* saver;
	GSimpleAction* print_current_board_action;
	GSimpleAction* print_multiple_action;
	GSimpleAction* new_game_action;
	GSimpleAction* back_action;
	GSimpleAction* zoom_in_action;
	GSimpleAction* zoom_out_action;
	guint autosave_timeout;
	DifficultyCategory _play_difficulty;
	ZoomLevel _zoom_level;
	gboolean _show_timer;
	gboolean _earmark_mode;
	gboolean _show_possibilities;
	gboolean _highlighter;
	gboolean _highlight_row_column;
	gboolean _highlight_block;
	gboolean _highlight_numbers;
	gboolean _show_warnings;
	gboolean _solution_warnings;
	gboolean _earmark_warnings;
	gboolean _autoclean_earmarks;
	gboolean _number_picker_second_click;
};

struct _Block1Data {
	int _ref_count_;
	Sudoku* self;
	AdwAlertDialog* dialog;
};

struct _Block2Data {
	int _ref_count_;
	Sudoku* self;
	AdwAlertDialog* dialog;
};

struct _Block3Data {
	int _ref_count_;
	Sudoku* self;
	AdwAlertDialog* dialog;
};

struct _SudokuGameView {
	AdwBin parent_instance;
	SudokuGameViewPrivate * priv;
	SudokuGame* game;
	SudokuGrid* grid;
	SudokuWindow* window;
	gdouble* highscore;
};

struct _SudokuGameViewClass {
	AdwBinClass parent_class;
};

struct _SudokuWindow {
	AdwApplicationWindow parent_instance;
	SudokuWindowPrivate * priv;
	SudokuStartView* start_view;
	SudokuGameView* game_view;
};

struct _SudokuWindowClass {
	AdwApplicationWindowClass parent_class;
};

static gint Sudoku_private_offset;
static gpointer sudoku_parent_class = NULL;
VALA_EXTERN Sudoku* sudoku_app;
Sudoku* sudoku_app = NULL;

VALA_EXTERN GType sudoku_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Sudoku, g_object_unref)
VALA_EXTERN GType sudoku_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SudokuWindow, g_object_unref)
VALA_EXTERN GType zoom_level_get_type (void) G_GNUC_CONST ;
static void sudoku_new_game_cb (Sudoku* self);
static void _sudoku_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self);
static void sudoku_start_game_cb (Sudoku* self,
                           GSimpleAction* action,
                           GVariant* difficulty);
static void _sudoku_start_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                             GVariant* parameter,
                                                             gpointer self);
static void sudoku_create_game_cb (Sudoku* self);
static void _sudoku_create_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                              GVariant* parameter,
                                                              gpointer self);
static void sudoku_back_cb (Sudoku* self);
static void _sudoku_back_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                       GVariant* parameter,
                                                       gpointer self);
static void sudoku_print_current_board_cb (Sudoku* self);
static void _sudoku_print_current_board_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      gpointer self);
static void sudoku_play_custom_game_cb (Sudoku* self);
static void _sudoku_play_custom_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self);
static void sudoku_print_multiple_cb (Sudoku* self);
static void _sudoku_print_multiple_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self);
static void sudoku_help_cb (Sudoku* self);
static void _sudoku_help_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                       GVariant* parameter,
                                                       gpointer self);
static void sudoku_about_cb (Sudoku* self);
static void _sudoku_about_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                        GVariant* parameter,
                                                        gpointer self);
static void sudoku_toggle_fullscreen_cb (Sudoku* self);
static void _sudoku_toggle_fullscreen_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                    GVariant* parameter,
                                                                    gpointer self);
static void sudoku_zoom_in_cb (Sudoku* self);
static void _sudoku_zoom_in_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                          GVariant* parameter,
                                                          gpointer self);
static void sudoku_zoom_out_cb (Sudoku* self);
static void _sudoku_zoom_out_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self);
static void sudoku_zoom_reset_cb (Sudoku* self);
static void _sudoku_zoom_reset_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                             GVariant* parameter,
                                                             gpointer self);
static void sudoku_shortcuts_window_cb (Sudoku* self);
static void _sudoku_shortcuts_window_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self);
static void sudoku_preferences_dialog_cb (Sudoku* self);
static void _sudoku_preferences_dialog_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                     GVariant* parameter,
                                                                     gpointer self);
static void _g_application_quit_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self);
VALA_EXTERN Sudoku* sudoku_new (void);
VALA_EXTERN Sudoku* sudoku_construct (GType object_type);
static gint sudoku_real_handle_local_options (GApplication* base,
                                       GVariantDict* options);
static void sudoku_real_startup (GApplication* base);
VALA_EXTERN ZoomLevel sudoku_get_zoom_level (Sudoku* self);
VALA_EXTERN gboolean zoom_level_is_fully_zoomed_in (ZoomLevel self);
VALA_EXTERN gboolean zoom_level_is_fully_zoomed_out (ZoomLevel self);
static void sudoku_real_activate (GApplication* base);
VALA_EXTERN SudokuWindow* sudoku_window_new (GSettings* settings);
VALA_EXTERN SudokuWindow* sudoku_window_construct (GType object_type,
                                       GSettings* settings);
static void sudoku_start_game (Sudoku* self,
                        SudokuBoard* board);
static void sudoku_show_start_view (Sudoku* self);
static void sudoku_real_shutdown (GApplication* base);
static SudokuGame* sudoku_get_game (Sudoku* self);
static void sudoku_save_game (Sudoku* self);
static void sudoku_paused_cb (Sudoku* self);
VALA_EXTERN GType sudoku_game_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SudokuGameView, g_object_unref)
static SudokuGameView* sudoku_get_game_view (Sudoku* self);
static void sudoku_start_custom_game (Sudoku* self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void ____lambda10_ (Block1Data* _data1_);
static void _____lambda10__adw_alert_dialog_response (AdwAlertDialog* _sender,
                                               const gchar* response,
                                               gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void ____lambda11_ (Block2Data* _data2_);
static void _____lambda11__adw_alert_dialog_response (AdwAlertDialog* _sender,
                                               const gchar* response,
                                               gpointer self);
static void sudoku_board_completed_cb (Sudoku* self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
VALA_EXTERN gboolean sudoku_get_show_timer (Sudoku* self);
VALA_EXTERN GType sudoku_grid_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SudokuGrid, g_object_unref)
static void __lambda9_ (Block3Data* _data3_,
                 const gchar* response_id);
static void sudoku_start_game_async (Sudoku* self);
static void ___lambda9__adw_alert_dialog_response (AdwAlertDialog* _sender,
                                            const gchar* response,
                                            gpointer self);
VALA_EXTERN void sudoku_window_start_game (SudokuWindow* self,
                               SudokuBoard* board,
                               gdouble* highscore);
static void _sudoku_paused_cb_g_object_notify (GObject* _sender,
                                        GParamSpec* pspec,
                                        gpointer self);
VALA_EXTERN void sudoku_window_change_board (SudokuWindow* self,
                                 SudokuBoard* board,
                                 gdouble* highscore);
static void sudoku_show_game_view (Sudoku* self);
static void sudoku_start_autosave (Sudoku* self);
static void _sudoku_board_completed_cb_sudoku_board_completed (SudokuBoard* _sender,
                                                        gpointer self);
VALA_EXTERN void sudoku_window_show_start_view (SudokuWindow* self);
VALA_EXTERN void sudoku_window_show_game_view (SudokuWindow* self);
static gboolean __lambda8_ (Sudoku* self);
static gboolean ___lambda8__gsource_func (gpointer self);
VALA_EXTERN void sudoku_set_play_difficulty (Sudoku* self,
                                 DifficultyCategory value);
VALA_EXTERN DifficultyCategory sudoku_get_play_difficulty (Sudoku* self);
static void __lambda7_ (Sudoku* self,
                 GObject* obj,
                 GAsyncResult* res);
static void ___lambda7__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
VALA_EXTERN GType sudoku_window_screen_get_type (void) G_GNUC_CONST ;
VALA_EXTERN SudokuWindowScreen sudoku_window_get_current_screen (SudokuWindow* self);
VALA_EXTERN GType sudoku_printer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SudokuPrinter, g_object_unref)
VALA_EXTERN SudokuPrinter* sudoku_printer_new (GeeList* boards,
                                   gint sudokus_per_page);
VALA_EXTERN SudokuPrinter* sudoku_printer_construct (GType object_type,
                                         GeeList* boards,
                                         gint sudokus_per_page);
VALA_EXTERN GtkPrintOperationResult sudoku_printer_print_sudoku (SudokuPrinter* self,
                                                     GtkWindow* window);
VALA_EXTERN GType sudoku_print_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SudokuPrintDialog, g_object_unref)
VALA_EXTERN SudokuPrintDialog* sudoku_print_dialog_new (SudokuSaver* saver,
                                            SudokuWindow* window);
VALA_EXTERN SudokuPrintDialog* sudoku_print_dialog_construct (GType object_type,
                                                  SudokuSaver* saver,
                                                  SudokuWindow* window);
VALA_EXTERN GType sudoku_preferences_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SudokuPreferencesDialog, g_object_unref)
VALA_EXTERN SudokuPreferencesDialog* sudoku_preferences_dialog_new (void);
VALA_EXTERN SudokuPreferencesDialog* sudoku_preferences_dialog_construct (GType object_type);
VALA_EXTERN void sudoku_grid_unselect (SudokuGrid* self);
static gboolean ___lambda16_ (Sudoku* self);
static gboolean ____lambda16__gtk_window_close_request (GtkWindow* _sender,
                                                 gpointer self);
VALA_EXTERN ZoomLevel zoom_level_zoom_in (ZoomLevel self);
VALA_EXTERN void sudoku_set_zoom_level (Sudoku* self,
                            ZoomLevel value);
VALA_EXTERN ZoomLevel zoom_level_zoom_out (ZoomLevel self);
static gint sudoku_main (gchar** args,
                  gint args_length1);
VALA_EXTERN GType sudoku_start_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SudokuStartView, g_object_unref)
VALA_EXTERN void sudoku_set_show_timer (Sudoku* self,
                            gboolean value);
VALA_EXTERN gboolean sudoku_get_earmark_mode (Sudoku* self);
VALA_EXTERN void sudoku_set_earmark_mode (Sudoku* self,
                              gboolean value);
VALA_EXTERN gboolean sudoku_get_show_possibilities (Sudoku* self);
VALA_EXTERN void sudoku_set_show_possibilities (Sudoku* self,
                                    gboolean value);
VALA_EXTERN gboolean sudoku_get_highlighter (Sudoku* self);
VALA_EXTERN void sudoku_set_highlighter (Sudoku* self,
                             gboolean value);
VALA_EXTERN gboolean sudoku_get_highlight_row_column (Sudoku* self);
VALA_EXTERN void sudoku_set_highlight_row_column (Sudoku* self,
                                      gboolean value);
VALA_EXTERN gboolean sudoku_get_highlight_block (Sudoku* self);
VALA_EXTERN void sudoku_set_highlight_block (Sudoku* self,
                                 gboolean value);
VALA_EXTERN gboolean sudoku_get_highlight_numbers (Sudoku* self);
VALA_EXTERN void sudoku_set_highlight_numbers (Sudoku* self,
                                   gboolean value);
VALA_EXTERN gboolean sudoku_get_show_warnings (Sudoku* self);
VALA_EXTERN void sudoku_set_show_warnings (Sudoku* self,
                               gboolean value);
VALA_EXTERN gboolean sudoku_get_solution_warnings (Sudoku* self);
VALA_EXTERN void sudoku_set_solution_warnings (Sudoku* self,
                                   gboolean value);
VALA_EXTERN gboolean sudoku_get_earmark_warnings (Sudoku* self);
VALA_EXTERN void sudoku_set_earmark_warnings (Sudoku* self,
                                  gboolean value);
VALA_EXTERN gboolean sudoku_get_autoclean_earmarks (Sudoku* self);
VALA_EXTERN void sudoku_set_autoclean_earmarks (Sudoku* self,
                                    gboolean value);
VALA_EXTERN gboolean sudoku_get_number_picker_second_click (Sudoku* self);
VALA_EXTERN void sudoku_set_number_picker_second_click (Sudoku* self,
                                            gboolean value);
static void sudoku_finalize (GObject * obj);
static GType sudoku_get_type_once (void);
static void _vala_sudoku_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec);
static void _vala_sudoku_set_property (GObject * object,
                                guint property_id,
                                const GValue * value,
                                GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GActionEntry SUDOKU_action_entries[16] = {{"new-game", _sudoku_new_game_cb_gsimple_action_activate_callback}, {"start-game", _sudoku_start_game_cb_gsimple_action_activate_callback, "i"}, {"create-game", _sudoku_create_game_cb_gsimple_action_activate_callback}, {"back", _sudoku_back_cb_gsimple_action_activate_callback}, {"print-current-board", _sudoku_print_current_board_cb_gsimple_action_activate_callback}, {"play-custom-game", _sudoku_play_custom_game_cb_gsimple_action_activate_callback}, {"print-multiple", _sudoku_print_multiple_cb_gsimple_action_activate_callback}, {"help", _sudoku_help_cb_gsimple_action_activate_callback}, {"about", _sudoku_about_cb_gsimple_action_activate_callback}, {"toggle-fullscreen", _sudoku_toggle_fullscreen_cb_gsimple_action_activate_callback}, {"zoom-in", _sudoku_zoom_in_cb_gsimple_action_activate_callback, NULL, "false"}, {"zoom-out", _sudoku_zoom_out_cb_gsimple_action_activate_callback, NULL, "false"}, {"zoom-reset", _sudoku_zoom_reset_cb_gsimple_action_activate_callback}, {"shortcuts-window", _sudoku_shortcuts_window_cb_gsimple_action_activate_callback}, {"preferences-dialog", _sudoku_preferences_dialog_cb_gsimple_action_activate_callback}, {"quit", _g_application_quit_gsimple_action_activate_callback}};
static const GOptionEntry SUDOKU_option_entries[2] = {{"version", 'v', (gint) 0, G_OPTION_ARG_NONE, NULL, N_ ("Show release version"), NULL}, {NULL}};
static const gchar* SUDOKU_authors[7] = {"Robert Ancell <robert.ancell@gmail.com>", "Christopher Baines <cbaines8@gmail.com>", "Thomas M. Hinkle <Thomas_Hinkle@alumni.brown.edu>", "Parin Porecha <parinporecha@gmail.com>", "John Stowers <john.stowers@gmail.com>", "Jamie Murphy <jmurphy@gnome.org>", NULL};

static inline gpointer
sudoku_get_instance_private (Sudoku* self)
{
	return G_STRUCT_MEMBER_P (self, Sudoku_private_offset);
}

static void
_sudoku_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                      GVariant* parameter,
                                                      gpointer self)
{
	sudoku_new_game_cb ((Sudoku*) self);
}

static void
_sudoku_start_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                        GVariant* parameter,
                                                        gpointer self)
{
	sudoku_start_game_cb ((Sudoku*) self, action, parameter);
}

static void
_sudoku_create_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                         GVariant* parameter,
                                                         gpointer self)
{
	sudoku_create_game_cb ((Sudoku*) self);
}

static void
_sudoku_back_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                  GVariant* parameter,
                                                  gpointer self)
{
	sudoku_back_cb ((Sudoku*) self);
}

static void
_sudoku_print_current_board_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self)
{
	sudoku_print_current_board_cb ((Sudoku*) self);
}

static void
_sudoku_play_custom_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                              GVariant* parameter,
                                                              gpointer self)
{
	sudoku_play_custom_game_cb ((Sudoku*) self);
}

static void
_sudoku_print_multiple_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self)
{
	sudoku_print_multiple_cb ((Sudoku*) self);
}

static void
_sudoku_help_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                  GVariant* parameter,
                                                  gpointer self)
{
	sudoku_help_cb ((Sudoku*) self);
}

static void
_sudoku_about_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                   GVariant* parameter,
                                                   gpointer self)
{
	sudoku_about_cb ((Sudoku*) self);
}

static void
_sudoku_toggle_fullscreen_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                               GVariant* parameter,
                                                               gpointer self)
{
	sudoku_toggle_fullscreen_cb ((Sudoku*) self);
}

static void
_sudoku_zoom_in_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                     GVariant* parameter,
                                                     gpointer self)
{
	sudoku_zoom_in_cb ((Sudoku*) self);
}

static void
_sudoku_zoom_out_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                      GVariant* parameter,
                                                      gpointer self)
{
	sudoku_zoom_out_cb ((Sudoku*) self);
}

static void
_sudoku_zoom_reset_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                        GVariant* parameter,
                                                        gpointer self)
{
	sudoku_zoom_reset_cb ((Sudoku*) self);
}

static void
_sudoku_shortcuts_window_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                              GVariant* parameter,
                                                              gpointer self)
{
	sudoku_shortcuts_window_cb ((Sudoku*) self);
}

static void
_sudoku_preferences_dialog_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                GVariant* parameter,
                                                                gpointer self)
{
	sudoku_preferences_dialog_cb ((Sudoku*) self);
}

static void
_g_application_quit_gsimple_action_activate_callback (GSimpleAction* action,
                                                      GVariant* parameter,
                                                      gpointer self)
{
	g_application_quit ((GApplication*) self);
}

Sudoku*
sudoku_construct (GType object_type)
{
	Sudoku * self = NULL;
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	self = (Sudoku*) g_object_new (object_type, "application-id", APP_ID, "flags", G_APPLICATION_DEFAULT_FLAGS, "resource-base-path", "/org/gnome/Sudoku", NULL);
	g_application_add_main_option_entries ((GApplication*) self, SUDOKU_option_entries);
	return self;
}

Sudoku*
sudoku_new (void)
{
	return sudoku_construct (TYPE_SUDOKU);
}

static gint
sudoku_real_handle_local_options (GApplication* base,
                                  GVariantDict* options)
{
	Sudoku * self;
	gint result;
	self = (Sudoku*) base;
	g_return_val_if_fail (options != NULL, 0);
	if (g_variant_dict_contains (options, "version")) {
		FILE* _tmp0_;
		_tmp0_ = stderr;
		fprintf (_tmp0_, "gnome-sudoku %s\n", VERSION);
		result = EXIT_SUCCESS;
		return result;
	}
	result = -1;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
sudoku_real_startup (GApplication* base)
{
	Sudoku * self;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	GSettings* _tmp4_;
	GSettings* _tmp5_;
	GSettings* _tmp6_;
	GSettings* _tmp7_;
	GSettings* _tmp8_;
	GSettings* _tmp9_;
	GSettings* _tmp10_;
	GSettings* _tmp11_;
	GSettings* _tmp12_;
	GSettings* _tmp13_;
	GAction* action = NULL;
	GSettings* _tmp14_;
	GAction* _tmp15_;
	GAction* _tmp16_;
	GSettings* _tmp17_;
	GAction* _tmp18_;
	GAction* _tmp19_;
	gchar* _tmp20_;
	gchar** _tmp21_;
	gchar** _tmp22_;
	gint _tmp22__length1;
	gchar* _tmp23_;
	gchar** _tmp24_;
	gchar** _tmp25_;
	gint _tmp25__length1;
	gchar* _tmp26_;
	gchar** _tmp27_;
	gchar** _tmp28_;
	gint _tmp28__length1;
	gchar* _tmp29_;
	gchar** _tmp30_;
	gchar** _tmp31_;
	gint _tmp31__length1;
	gchar* _tmp32_;
	gchar** _tmp33_;
	gchar** _tmp34_;
	gint _tmp34__length1;
	gchar* _tmp35_;
	gchar** _tmp36_;
	gchar** _tmp37_;
	gint _tmp37__length1;
	gchar* _tmp38_;
	gchar** _tmp39_;
	gchar** _tmp40_;
	gint _tmp40__length1;
	gchar* _tmp41_;
	gchar* _tmp42_;
	gchar** _tmp43_;
	gchar** _tmp44_;
	gint _tmp44__length1;
	gchar* _tmp45_;
	gchar** _tmp46_;
	gchar** _tmp47_;
	gint _tmp47__length1;
	gchar* _tmp48_;
	gchar* _tmp49_;
	gchar* _tmp50_;
	gchar* _tmp51_;
	gchar** _tmp52_;
	gchar** _tmp53_;
	gint _tmp53__length1;
	gchar* _tmp54_;
	gchar* _tmp55_;
	gchar* _tmp56_;
	gchar** _tmp57_;
	gchar** _tmp58_;
	gint _tmp58__length1;
	gchar* _tmp59_;
	gchar* _tmp60_;
	gchar** _tmp61_;
	gchar** _tmp62_;
	gint _tmp62__length1;
	GAction* _tmp63_;
	GSimpleAction* _tmp64_;
	GAction* _tmp65_;
	GSimpleAction* _tmp66_;
	GAction* _tmp67_;
	GSimpleAction* _tmp68_;
	GAction* _tmp69_;
	GSimpleAction* _tmp70_;
	GAction* _tmp71_;
	GSimpleAction* _tmp72_;
	GAction* _tmp73_;
	GSimpleAction* _tmp74_;
	GSimpleAction* _tmp75_;
	ZoomLevel _tmp76_;
	GSimpleAction* _tmp77_;
	ZoomLevel _tmp78_;
	self = (Sudoku*) base;
	sudoku_app = self;
	G_APPLICATION_CLASS (sudoku_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, adw_application_get_type (), AdwApplication));
	_tmp0_ = g_settings_new ("org.gnome.Sudoku");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = self->priv->settings;
	g_settings_bind (_tmp1_, "play-difficulty", (GObject*) self, "play-difficulty", G_SETTINGS_BIND_DEFAULT);
	_tmp2_ = self->priv->settings;
	g_settings_bind (_tmp2_, "zoom-level", (GObject*) self, "zoom-level", G_SETTINGS_BIND_DEFAULT);
	_tmp3_ = self->priv->settings;
	g_settings_bind (_tmp3_, "show-timer", (GObject*) self, "show-timer", G_SETTINGS_BIND_DEFAULT);
	_tmp4_ = self->priv->settings;
	g_settings_bind (_tmp4_, "show-possibilities", (GObject*) self, "show-possibilities", G_SETTINGS_BIND_DEFAULT);
	_tmp5_ = self->priv->settings;
	g_settings_bind (_tmp5_, "highlighter", (GObject*) self, "highlighter", G_SETTINGS_BIND_DEFAULT);
	_tmp6_ = self->priv->settings;
	g_settings_bind (_tmp6_, "highlight-row-column", (GObject*) self, "highlight-row-column", G_SETTINGS_BIND_DEFAULT);
	_tmp7_ = self->priv->settings;
	g_settings_bind (_tmp7_, "highlight-block", (GObject*) self, "highlight-block", G_SETTINGS_BIND_DEFAULT);
	_tmp8_ = self->priv->settings;
	g_settings_bind (_tmp8_, "highlight-numbers", (GObject*) self, "highlight-numbers", G_SETTINGS_BIND_DEFAULT);
	_tmp9_ = self->priv->settings;
	g_settings_bind (_tmp9_, "show-warnings", (GObject*) self, "show-warnings", G_SETTINGS_BIND_DEFAULT);
	_tmp10_ = self->priv->settings;
	g_settings_bind (_tmp10_, "solution-warnings", (GObject*) self, "solution-warnings", G_SETTINGS_BIND_DEFAULT);
	_tmp11_ = self->priv->settings;
	g_settings_bind (_tmp11_, "earmark-warnings", (GObject*) self, "earmark-warnings", G_SETTINGS_BIND_DEFAULT);
	_tmp12_ = self->priv->settings;
	g_settings_bind (_tmp12_, "autoclean-earmarks", (GObject*) self, "autoclean-earmarks", G_SETTINGS_BIND_DEFAULT);
	_tmp13_ = self->priv->settings;
	g_settings_bind (_tmp13_, "number-picker-second-click", (GObject*) self, "number-picker-second-click", G_SETTINGS_BIND_DEFAULT);
	g_action_map_add_action_entries ((GActionMap*) self, SUDOKU_action_entries, (gint) G_N_ELEMENTS (SUDOKU_action_entries), self);
	_tmp14_ = self->priv->settings;
	_tmp15_ = g_settings_create_action (_tmp14_, "show-warnings");
	action = _tmp15_;
	_tmp16_ = action;
	g_action_map_add_action ((GActionMap*) self, _tmp16_);
	_tmp17_ = self->priv->settings;
	_tmp18_ = g_settings_create_action (_tmp17_, "highlighter");
	_g_object_unref0 (action);
	action = _tmp18_;
	_tmp19_ = action;
	g_action_map_add_action ((GActionMap*) self, _tmp19_);
	_tmp20_ = g_strdup ("<Primary>n");
	_tmp21_ = g_new0 (gchar*, 1 + 1);
	_tmp21_[0] = _tmp20_;
	_tmp22_ = _tmp21_;
	_tmp22__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.new-game", _tmp22_);
	_tmp22_ = (_vala_array_free (_tmp22_, _tmp22__length1, (GDestroyNotify) g_free), NULL);
	_tmp23_ = g_strdup ("<Primary>p");
	_tmp24_ = g_new0 (gchar*, 1 + 1);
	_tmp24_[0] = _tmp23_;
	_tmp25_ = _tmp24_;
	_tmp25__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.print-current-board", _tmp25_);
	_tmp25_ = (_vala_array_free (_tmp25_, _tmp25__length1, (GDestroyNotify) g_free), NULL);
	_tmp26_ = g_strdup ("<Primary>q");
	_tmp27_ = g_new0 (gchar*, 1 + 1);
	_tmp27_[0] = _tmp26_;
	_tmp28_ = _tmp27_;
	_tmp28__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.quit", _tmp28_);
	_tmp28_ = (_vala_array_free (_tmp28_, _tmp28__length1, (GDestroyNotify) g_free), NULL);
	_tmp29_ = g_strdup ("<Primary>w");
	_tmp30_ = g_new0 (gchar*, 1 + 1);
	_tmp30_[0] = _tmp29_;
	_tmp31_ = _tmp30_;
	_tmp31__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.show-warnings", _tmp31_);
	_tmp31_ = (_vala_array_free (_tmp31_, _tmp31__length1, (GDestroyNotify) g_free), NULL);
	_tmp32_ = g_strdup ("F1");
	_tmp33_ = g_new0 (gchar*, 1 + 1);
	_tmp33_[0] = _tmp32_;
	_tmp34_ = _tmp33_;
	_tmp34__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.help", _tmp34_);
	_tmp34_ = (_vala_array_free (_tmp34_, _tmp34__length1, (GDestroyNotify) g_free), NULL);
	_tmp35_ = g_strdup ("<Primary>question");
	_tmp36_ = g_new0 (gchar*, 1 + 1);
	_tmp36_[0] = _tmp35_;
	_tmp37_ = _tmp36_;
	_tmp37__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.shortcuts-window", _tmp37_);
	_tmp37_ = (_vala_array_free (_tmp37_, _tmp37__length1, (GDestroyNotify) g_free), NULL);
	_tmp38_ = g_strdup ("<Primary>comma");
	_tmp39_ = g_new0 (gchar*, 1 + 1);
	_tmp39_[0] = _tmp38_;
	_tmp40_ = _tmp39_;
	_tmp40__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.preferences-dialog", _tmp40_);
	_tmp40_ = (_vala_array_free (_tmp40_, _tmp40__length1, (GDestroyNotify) g_free), NULL);
	_tmp41_ = g_strdup ("F11");
	_tmp42_ = g_strdup ("f");
	_tmp43_ = g_new0 (gchar*, 2 + 1);
	_tmp43_[0] = _tmp41_;
	_tmp43_[1] = _tmp42_;
	_tmp44_ = _tmp43_;
	_tmp44__length1 = 2;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.toggle-fullscreen", _tmp44_);
	_tmp44_ = (_vala_array_free (_tmp44_, _tmp44__length1, (GDestroyNotify) g_free), NULL);
	_tmp45_ = g_strdup ("<Primary>h");
	_tmp46_ = g_new0 (gchar*, 1 + 1);
	_tmp46_[0] = _tmp45_;
	_tmp47_ = _tmp46_;
	_tmp47__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.highlighter", _tmp47_);
	_tmp47_ = (_vala_array_free (_tmp47_, _tmp47__length1, (GDestroyNotify) g_free), NULL);
	_tmp48_ = g_strdup ("<Primary>plus");
	_tmp49_ = g_strdup ("<Primary>equal");
	_tmp50_ = g_strdup ("ZoomIn");
	_tmp51_ = g_strdup ("<Primary>KP_Add");
	_tmp52_ = g_new0 (gchar*, 4 + 1);
	_tmp52_[0] = _tmp48_;
	_tmp52_[1] = _tmp49_;
	_tmp52_[2] = _tmp50_;
	_tmp52_[3] = _tmp51_;
	_tmp53_ = _tmp52_;
	_tmp53__length1 = 4;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.zoom-in", _tmp53_);
	_tmp53_ = (_vala_array_free (_tmp53_, _tmp53__length1, (GDestroyNotify) g_free), NULL);
	_tmp54_ = g_strdup ("<Primary>minus");
	_tmp55_ = g_strdup ("ZoomOut");
	_tmp56_ = g_strdup ("<Primary>KP_Subtract");
	_tmp57_ = g_new0 (gchar*, 3 + 1);
	_tmp57_[0] = _tmp54_;
	_tmp57_[1] = _tmp55_;
	_tmp57_[2] = _tmp56_;
	_tmp58_ = _tmp57_;
	_tmp58__length1 = 3;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.zoom-out", _tmp58_);
	_tmp58_ = (_vala_array_free (_tmp58_, _tmp58__length1, (GDestroyNotify) g_free), NULL);
	_tmp59_ = g_strdup ("<Primary>0");
	_tmp60_ = g_strdup ("<Primary>KP_0");
	_tmp61_ = g_new0 (gchar*, 2 + 1);
	_tmp61_[0] = _tmp59_;
	_tmp61_[1] = _tmp60_;
	_tmp62_ = _tmp61_;
	_tmp62__length1 = 2;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.zoom-reset", _tmp62_);
	_tmp62_ = (_vala_array_free (_tmp62_, _tmp62__length1, (GDestroyNotify) g_free), NULL);
	_tmp63_ = g_action_map_lookup_action ((GActionMap*) self, "new-game");
	_tmp64_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp63_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp63_) : NULL);
	_g_object_unref0 (self->priv->new_game_action);
	self->priv->new_game_action = _tmp64_;
	_tmp65_ = g_action_map_lookup_action ((GActionMap*) self, "print-current-board");
	_tmp66_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp65_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp65_) : NULL);
	_g_object_unref0 (self->priv->print_current_board_action);
	self->priv->print_current_board_action = _tmp66_;
	_tmp67_ = g_action_map_lookup_action ((GActionMap*) self, "print-multiple");
	_tmp68_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp67_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp67_) : NULL);
	_g_object_unref0 (self->priv->print_multiple_action);
	self->priv->print_multiple_action = _tmp68_;
	_tmp69_ = g_action_map_lookup_action ((GActionMap*) self, "zoom-in");
	_tmp70_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp69_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp69_) : NULL);
	_g_object_unref0 (self->priv->zoom_in_action);
	self->priv->zoom_in_action = _tmp70_;
	_tmp71_ = g_action_map_lookup_action ((GActionMap*) self, "back");
	_tmp72_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp71_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp71_) : NULL);
	_g_object_unref0 (self->priv->back_action);
	self->priv->back_action = _tmp72_;
	_tmp73_ = g_action_map_lookup_action ((GActionMap*) self, "zoom-out");
	_tmp74_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp73_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp73_) : NULL);
	_g_object_unref0 (self->priv->zoom_out_action);
	self->priv->zoom_out_action = _tmp74_;
	_tmp75_ = self->priv->zoom_in_action;
	_tmp76_ = self->priv->_zoom_level;
	g_simple_action_set_enabled (_tmp75_, !zoom_level_is_fully_zoomed_in (_tmp76_));
	_tmp77_ = self->priv->zoom_out_action;
	_tmp78_ = self->priv->_zoom_level;
	g_simple_action_set_enabled (_tmp77_, !zoom_level_is_fully_zoomed_out (_tmp78_));
	gtk_window_set_default_icon_name (APP_ID);
	_g_object_unref0 (action);
}

static void
sudoku_real_activate (GApplication* base)
{
	Sudoku * self;
	SudokuWindow* _tmp0_;
	SudokuWindow* _tmp11_;
	self = (Sudoku*) base;
	_tmp0_ = self->priv->window;
	if (_tmp0_ == NULL) {
		GSettings* _tmp1_;
		SudokuWindow* _tmp2_;
		SudokuWindow* _tmp3_;
		SudokuSaver* _tmp4_;
		SudokuGame* savegame = NULL;
		SudokuSaver* _tmp5_;
		SudokuGame* _tmp6_;
		SudokuGame* _tmp7_;
		_tmp1_ = self->priv->settings;
		_tmp2_ = sudoku_window_new (_tmp1_);
		g_object_ref_sink (_tmp2_);
		_g_object_unref0 (self->priv->window);
		self->priv->window = _tmp2_;
		_tmp3_ = self->priv->window;
		gtk_application_add_window ((GtkApplication*) self, (GtkWindow*) _tmp3_);
		_tmp4_ = sudoku_saver_new ();
		_g_object_unref0 (self->priv->saver);
		self->priv->saver = _tmp4_;
		_tmp5_ = self->priv->saver;
		_tmp6_ = sudoku_saver_get_savedgame (_tmp5_);
		savegame = _tmp6_;
		_tmp7_ = savegame;
		if (_tmp7_ != NULL) {
			SudokuGame* _tmp8_;
			SudokuBoard* _tmp9_;
			SudokuBoard* _tmp10_;
			_tmp8_ = savegame;
			_tmp9_ = sudoku_game_get_board (_tmp8_);
			_tmp10_ = _tmp9_;
			sudoku_start_game (self, _tmp10_);
		} else {
			sudoku_show_start_view (self);
		}
		_g_object_unref0 (savegame);
	}
	_tmp11_ = self->priv->window;
	gtk_window_present ((GtkWindow*) _tmp11_);
}

static void
sudoku_real_shutdown (GApplication* base)
{
	Sudoku * self;
	SudokuWindow* _tmp0_;
	self = (Sudoku*) base;
	_tmp0_ = self->priv->window;
	if (_tmp0_ != NULL) {
		SudokuGame* _tmp1_;
		SudokuGame* _tmp2_;
		SudokuWindow* _tmp3_;
		_tmp1_ = sudoku_get_game (self);
		_tmp2_ = _tmp1_;
		if (_tmp2_ != NULL) {
			sudoku_save_game (self);
		}
		_tmp3_ = self->priv->window;
		gtk_window_close ((GtkWindow*) _tmp3_);
	}
	G_APPLICATION_CLASS (sudoku_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, adw_application_get_type (), AdwApplication));
}

static void
sudoku_paused_cb (Sudoku* self)
{
	SudokuGame* _tmp0_;
	SudokuGame* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	SudokuGameView* _tmp6_;
	SudokuGameView* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = sudoku_get_game (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = sudoku_game_get_paused (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		GSimpleAction* _tmp4_;
		_tmp4_ = self->priv->new_game_action;
		g_simple_action_set_enabled (_tmp4_, FALSE);
	} else {
		GSimpleAction* _tmp5_;
		_tmp5_ = self->priv->new_game_action;
		g_simple_action_set_enabled (_tmp5_, TRUE);
	}
	_tmp6_ = sudoku_get_game_view (self);
	_tmp7_ = _tmp6_;
	gtk_widget_queue_draw ((GtkWidget*) _tmp7_);
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		Sudoku* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->dialog);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
____lambda10_ (Block1Data* _data1_)
{
	Sudoku* self;
	AdwAlertDialog* _tmp0_;
	self = _data1_->self;
	_tmp0_ = _data1_->dialog;
	g_signal_emit_by_name ((GtkWidget*) _tmp0_, "destroy");
}

static void
_____lambda10__adw_alert_dialog_response (AdwAlertDialog* _sender,
                                          const gchar* response,
                                          gpointer self)
{
	____lambda10_ (self);
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		Sudoku* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->dialog);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
____lambda11_ (Block2Data* _data2_)
{
	Sudoku* self;
	AdwAlertDialog* _tmp0_;
	self = _data2_->self;
	sudoku_start_custom_game (self);
	_tmp0_ = _data2_->dialog;
	g_signal_emit_by_name ((GtkWidget*) _tmp0_, "destroy");
}

static void
_____lambda11__adw_alert_dialog_response (AdwAlertDialog* _sender,
                                          const gchar* response,
                                          gpointer self)
{
	____lambda11_ (self);
}

static void
sudoku_play_custom_game_cb (Sudoku* self)
{
	gint solutions = 0;
	SudokuGame* _tmp0_;
	SudokuGame* _tmp1_;
	SudokuBoard* _tmp2_;
	SudokuBoard* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = sudoku_get_game (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = sudoku_game_get_board (_tmp1_);
	_tmp3_ = _tmp2_;
	solutions = sudoku_board_count_solutions_limited (_tmp3_);
	if (solutions == 1) {
		sudoku_start_custom_game (self);
	} else {
		if (solutions == 0) {
			Block1Data* _data1_;
			AdwAlertDialog* _tmp4_;
			AdwAlertDialog* _tmp5_;
			AdwAlertDialog* _tmp6_;
			AdwAlertDialog* _tmp7_;
			SudokuWindow* _tmp8_;
			_data1_ = g_slice_new0 (Block1Data);
			_data1_->_ref_count_ = 1;
			_data1_->self = g_object_ref (self);
			_tmp4_ = (AdwAlertDialog*) adw_alert_dialog_new (_ ("The puzzle you have entered is not a valid Sudoku."), _ ("Please enter a valid puzzle."));
			g_object_ref_sink (_tmp4_);
			_data1_->dialog = _tmp4_;
			_tmp5_ = _data1_->dialog;
			adw_alert_dialog_add_response (_tmp5_, "close", _ ("Close"));
			_tmp6_ = _data1_->dialog;
			g_signal_connect_data (_tmp6_, "response", (GCallback) _____lambda10__adw_alert_dialog_response, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
			_tmp7_ = _data1_->dialog;
			_tmp8_ = self->priv->window;
			adw_dialog_present ((AdwDialog*) _tmp7_, (GtkWidget*) _tmp8_);
			block1_data_unref (_data1_);
			_data1_ = NULL;
		} else {
			Block2Data* _data2_;
			AdwAlertDialog* _tmp9_;
			AdwAlertDialog* _tmp10_;
			AdwAlertDialog* _tmp11_;
			AdwAlertDialog* _tmp12_;
			AdwAlertDialog* _tmp13_;
			AdwAlertDialog* _tmp14_;
			SudokuWindow* _tmp15_;
			_data2_ = g_slice_new0 (Block2Data);
			_data2_->_ref_count_ = 1;
			_data2_->self = g_object_ref (self);
			_tmp9_ = (AdwAlertDialog*) adw_alert_dialog_new (_ ("The puzzle you have entered has multiple solutions."), _ ("Valid Sudoku puzzles have exactly one solution."));
			g_object_ref_sink (_tmp9_);
			_data2_->dialog = _tmp9_;
			_tmp10_ = _data2_->dialog;
			adw_alert_dialog_add_response (_tmp10_, "close", _ ("_Back"));
			_tmp11_ = _data2_->dialog;
			adw_alert_dialog_add_response (_tmp11_, "continue", _ ("Play _Anyway"));
			_tmp12_ = _data2_->dialog;
			adw_alert_dialog_set_response_appearance (_tmp12_, "continue", ADW_RESPONSE_DESTRUCTIVE);
			_tmp13_ = _data2_->dialog;
			g_signal_connect_data (_tmp13_, "response::continue", (GCallback) _____lambda11__adw_alert_dialog_response, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
			_tmp14_ = _data2_->dialog;
			_tmp15_ = self->priv->window;
			adw_dialog_present ((AdwDialog*) _tmp14_, (GtkWidget*) _tmp15_);
			block2_data_unref (_data2_);
			_data2_ = NULL;
		}
	}
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		Sudoku* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->dialog);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static void
__lambda9_ (Block3Data* _data3_,
            const gchar* response_id)
{
	Sudoku* self;
	self = _data3_->self;
	g_return_if_fail (response_id != NULL);
	if (g_strcmp0 (response_id, "play-again") == 0) {
		sudoku_start_game_async (self);
	} else {
		if (g_strcmp0 (response_id, "close") == 0) {
			g_application_quit ((GApplication*) self);
		}
	}
	g_signal_emit_by_name ((GtkWidget*) _data3_->dialog, "destroy");
}

static void
___lambda9__adw_alert_dialog_response (AdwAlertDialog* _sender,
                                       const gchar* response,
                                       gpointer self)
{
	__lambda9_ (self, response);
}

static void
sudoku_board_completed_cb (Sudoku* self)
{
	Block3Data* _data3_;
	SudokuSaver* _tmp0_;
	SudokuGame* _tmp1_;
	SudokuGame* _tmp2_;
	gboolean _tmp3_;
	gchar* win_str = NULL;
	gboolean _tmp4_;
	const gchar* _tmp35_;
	AdwAlertDialog* _tmp36_;
	SudokuWindow* _tmp37_;
	g_return_if_fail (self != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = self->priv->saver;
	_tmp1_ = sudoku_get_game (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->_show_timer;
	sudoku_saver_add_game_to_finished (_tmp0_, _tmp2_, TRUE, _tmp3_);
	_tmp4_ = self->priv->_show_timer;
	if (_tmp4_) {
		gint minutes = 0;
		SudokuGame* _tmp5_;
		SudokuGame* _tmp6_;
		gchar* localized_time = NULL;
		gchar* _tmp7_;
		gboolean _tmp8_ = FALSE;
		SudokuGameView* _tmp9_;
		SudokuGameView* _tmp10_;
		gdouble* _tmp11_;
		_tmp5_ = sudoku_get_game (self);
		_tmp6_ = _tmp5_;
		minutes = ((gint) sudoku_game_get_total_time_played (_tmp6_)) / 60;
		_tmp7_ = g_strdup_printf (ngettext ("%d minute", "%d minutes", (gulong) minutes), minutes);
		localized_time = _tmp7_;
		_tmp9_ = sudoku_get_game_view (self);
		_tmp10_ = _tmp9_;
		_tmp11_ = _tmp10_->highscore;
		if (_tmp11_ == NULL) {
			_tmp8_ = TRUE;
		} else {
			gboolean _tmp12_ = FALSE;
			SudokuGameView* _tmp13_;
			SudokuGameView* _tmp14_;
			gdouble* _tmp15_;
			_tmp13_ = sudoku_get_game_view (self);
			_tmp14_ = _tmp13_;
			_tmp15_ = _tmp14_->highscore;
			if (_tmp15_ != NULL) {
				SudokuGame* _tmp16_;
				SudokuGame* _tmp17_;
				SudokuGameView* _tmp18_;
				SudokuGameView* _tmp19_;
				gdouble* _tmp20_;
				_tmp16_ = sudoku_get_game (self);
				_tmp17_ = _tmp16_;
				_tmp18_ = sudoku_get_game_view (self);
				_tmp19_ = _tmp18_;
				_tmp20_ = _tmp19_->highscore;
				_tmp12_ = sudoku_game_get_total_time_played (_tmp17_) < (*_tmp20_);
			} else {
				_tmp12_ = FALSE;
			}
			_tmp8_ = _tmp12_;
		}
		if (_tmp8_) {
			const gchar* _tmp21_;
			gchar* _tmp22_;
			SudokuSaver* _tmp23_;
			SudokuGame* _tmp24_;
			SudokuGame* _tmp25_;
			SudokuBoard* _tmp26_;
			SudokuBoard* _tmp27_;
			DifficultyCategory _tmp28_;
			DifficultyCategory _tmp29_;
			SudokuGame* _tmp30_;
			SudokuGame* _tmp31_;
			_tmp21_ = localized_time;
			_tmp22_ = g_strdup_printf (_ ("Well done, you completed the puzzle in %s and set a new personal best!"), _tmp21_);
			_g_free0 (win_str);
			win_str = _tmp22_;
			_tmp23_ = self->priv->saver;
			_tmp24_ = sudoku_get_game (self);
			_tmp25_ = _tmp24_;
			_tmp26_ = sudoku_game_get_board (_tmp25_);
			_tmp27_ = _tmp26_;
			_tmp28_ = sudoku_board_get_difficulty_category (_tmp27_);
			_tmp29_ = _tmp28_;
			_tmp30_ = sudoku_get_game (self);
			_tmp31_ = _tmp30_;
			sudoku_saver_save_highscore (_tmp23_, _tmp29_, sudoku_game_get_total_time_played (_tmp31_));
		} else {
			const gchar* _tmp32_;
			gchar* _tmp33_;
			_tmp32_ = localized_time;
			_tmp33_ = g_strdup_printf (_ ("Well done, you completed the puzzle in %s!"), _tmp32_);
			_g_free0 (win_str);
			win_str = _tmp33_;
		}
		_g_free0 (localized_time);
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup (_ ("Well done, you completed the puzzle!"));
		_g_free0 (win_str);
		win_str = _tmp34_;
	}
	_tmp35_ = win_str;
	_tmp36_ = (AdwAlertDialog*) adw_alert_dialog_new (_tmp35_, NULL);
	g_object_ref_sink (_tmp36_);
	_data3_->dialog = _tmp36_;
	adw_alert_dialog_add_response (_data3_->dialog, "close", _ ("Quit"));
	adw_alert_dialog_add_response (_data3_->dialog, "play-again", _ ("Play _Again"));
	adw_alert_dialog_set_response_appearance (_data3_->dialog, "play-again", ADW_RESPONSE_SUGGESTED);
	g_signal_connect_data (_data3_->dialog, "response", (GCallback) ___lambda9__adw_alert_dialog_response, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	_tmp37_ = self->priv->window;
	adw_dialog_present ((AdwDialog*) _data3_->dialog, (GtkWidget*) _tmp37_);
	_g_free0 (win_str);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}

static void
sudoku_start_custom_game (Sudoku* self)
{
	SudokuGame* _tmp0_;
	SudokuGame* _tmp1_;
	SudokuBoard* _tmp2_;
	SudokuBoard* _tmp3_;
	SudokuGame* _tmp4_;
	SudokuGame* _tmp5_;
	SudokuGame* _tmp6_;
	SudokuGame* _tmp7_;
	SudokuBoard* _tmp8_;
	SudokuBoard* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = sudoku_get_game (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = sudoku_game_get_board (_tmp1_);
	_tmp3_ = _tmp2_;
	sudoku_board_set_all_fixed (_tmp3_);
	_tmp4_ = sudoku_get_game (self);
	_tmp5_ = _tmp4_;
	sudoku_game_set_mode (_tmp5_, GAME_MODE_PLAY);
	_tmp6_ = sudoku_get_game (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = sudoku_game_get_board (_tmp7_);
	_tmp9_ = _tmp8_;
	sudoku_start_game (self, _tmp9_);
}

static void
sudoku_save_game (Sudoku* self)
{
	gboolean _tmp0_ = FALSE;
	SudokuGame* _tmp1_;
	SudokuGame* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp1_ = sudoku_get_game (self);
	_tmp2_ = _tmp1_;
	if (!sudoku_game_is_empty (_tmp2_)) {
		SudokuGame* _tmp3_;
		SudokuGame* _tmp4_;
		SudokuBoard* _tmp5_;
		SudokuBoard* _tmp6_;
		gboolean _tmp7_;
		gboolean _tmp8_;
		_tmp3_ = sudoku_get_game (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = sudoku_game_get_board (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = sudoku_board_get_complete (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp0_ = !_tmp8_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		SudokuSaver* _tmp9_;
		SudokuGame* _tmp10_;
		SudokuGame* _tmp11_;
		_tmp9_ = self->priv->saver;
		_tmp10_ = sudoku_get_game (self);
		_tmp11_ = _tmp10_;
		sudoku_saver_save_game (_tmp9_, _tmp11_);
	} else {
		SudokuSaver* _tmp12_;
		_tmp12_ = self->priv->saver;
		sudoku_saver_delete_save (_tmp12_);
	}
}

static void
_sudoku_paused_cb_g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self)
{
	sudoku_paused_cb ((Sudoku*) self);
}

static void
_sudoku_board_completed_cb_sudoku_board_completed (SudokuBoard* _sender,
                                                   gpointer self)
{
	sudoku_board_completed_cb ((Sudoku*) self);
}

static void
sudoku_start_game (Sudoku* self,
                   SudokuBoard* board)
{
	gdouble* highscore = NULL;
	SudokuSaver* _tmp0_;
	DifficultyCategory _tmp1_;
	DifficultyCategory _tmp2_;
	gdouble* _tmp3_;
	SudokuGame* _tmp4_;
	SudokuGame* _tmp5_;
	SudokuGame* _tmp12_;
	SudokuGame* _tmp13_;
	GameMode _tmp14_;
	GameMode _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (board != NULL);
	_tmp0_ = self->priv->saver;
	_tmp1_ = sudoku_board_get_difficulty_category (board);
	_tmp2_ = _tmp1_;
	_tmp3_ = sudoku_saver_get_highscore (_tmp0_, _tmp2_);
	highscore = _tmp3_;
	_tmp4_ = sudoku_get_game (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == NULL) {
		SudokuWindow* _tmp6_;
		gdouble* _tmp7_;
		SudokuGame* _tmp8_;
		SudokuGame* _tmp9_;
		_tmp6_ = self->priv->window;
		_tmp7_ = highscore;
		sudoku_window_start_game (_tmp6_, board, _tmp7_);
		_tmp8_ = sudoku_get_game (self);
		_tmp9_ = _tmp8_;
		g_signal_connect_object ((GObject*) _tmp9_, "notify::paused", (GCallback) _sudoku_paused_cb_g_object_notify, self, 0);
	} else {
		SudokuWindow* _tmp10_;
		gdouble* _tmp11_;
		_tmp10_ = self->priv->window;
		_tmp11_ = highscore;
		sudoku_window_change_board (_tmp10_, board, _tmp11_);
	}
	sudoku_show_game_view (self);
	sudoku_start_autosave (self);
	_tmp12_ = sudoku_get_game (self);
	_tmp13_ = _tmp12_;
	_tmp14_ = sudoku_game_get_mode (_tmp13_);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != GAME_MODE_CREATE) {
		SudokuGame* _tmp16_;
		SudokuGame* _tmp17_;
		SudokuBoard* _tmp18_;
		SudokuBoard* _tmp19_;
		_tmp16_ = sudoku_get_game (self);
		_tmp17_ = _tmp16_;
		_tmp18_ = sudoku_game_get_board (_tmp17_);
		_tmp19_ = _tmp18_;
		g_signal_connect_object (_tmp19_, "completed", (GCallback) _sudoku_board_completed_cb_sudoku_board_completed, self, 0);
	} else {
		SudokuGame* _tmp20_;
		SudokuGame* _tmp21_;
		SudokuBoard* _tmp22_;
		SudokuBoard* _tmp23_;
		guint _tmp24_;
		_tmp20_ = sudoku_get_game (self);
		_tmp21_ = _tmp20_;
		_tmp22_ = sudoku_game_get_board (_tmp21_);
		_tmp23_ = _tmp22_;
		g_signal_parse_name ("completed", TYPE_SUDOKU_BOARD, &_tmp24_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp23_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp24_, 0, NULL, (GCallback) _sudoku_board_completed_cb_sudoku_board_completed, self);
	}
	_g_free0 (highscore);
}

static void
sudoku_show_start_view (Sudoku* self)
{
	gboolean _tmp0_ = FALSE;
	SudokuGame* _tmp1_;
	SudokuGame* _tmp2_;
	GSimpleAction* _tmp11_;
	GSimpleAction* _tmp12_;
	SudokuWindow* _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp1_ = sudoku_get_game (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		SudokuGame* _tmp3_;
		SudokuGame* _tmp4_;
		SudokuBoard* _tmp5_;
		SudokuBoard* _tmp6_;
		gboolean _tmp7_;
		gboolean _tmp8_;
		_tmp3_ = sudoku_get_game (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = sudoku_game_get_board (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = sudoku_board_get_complete (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp0_ = _tmp8_ != TRUE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		SudokuGame* _tmp9_;
		SudokuGame* _tmp10_;
		_tmp9_ = sudoku_get_game (self);
		_tmp10_ = _tmp9_;
		sudoku_game_stop_clock (_tmp10_);
	}
	_tmp11_ = self->priv->print_current_board_action;
	g_simple_action_set_enabled (_tmp11_, FALSE);
	_tmp12_ = self->priv->new_game_action;
	g_simple_action_set_enabled (_tmp12_, FALSE);
	_tmp13_ = self->priv->window;
	sudoku_window_show_start_view (_tmp13_);
}

static void
sudoku_show_game_view (Sudoku* self)
{
	GSimpleAction* _tmp0_;
	GSimpleAction* _tmp1_;
	SudokuWindow* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->print_current_board_action;
	g_simple_action_set_enabled (_tmp0_, TRUE);
	_tmp1_ = self->priv->new_game_action;
	g_simple_action_set_enabled (_tmp1_, TRUE);
	_tmp2_ = self->priv->window;
	sudoku_window_show_game_view (_tmp2_);
}

static void
sudoku_new_game_cb (Sudoku* self)
{
	g_return_if_fail (self != NULL);
	sudoku_show_start_view (self);
}

static gboolean
__lambda8_ (Sudoku* self)
{
	gboolean result;
	sudoku_save_game (self);
	result = G_SOURCE_CONTINUE;
	return result;
}

static gboolean
___lambda8__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda8_ ((Sudoku*) self);
	return result;
}

static void
sudoku_start_autosave (Sudoku* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->autosave_timeout != ((guint) 0)) {
		g_source_remove (self->priv->autosave_timeout);
	}
	self->priv->autosave_timeout = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 300, ___lambda8__gsource_func, g_object_ref (self), g_object_unref);
	g_source_set_name_by_id (self->priv->autosave_timeout, "[gnome-sudoku] autosave");
}

static void
sudoku_create_game_cb (Sudoku* self)
{
	g_return_if_fail (self != NULL);
	sudoku_set_play_difficulty (self, DIFFICULTY_CATEGORY_CUSTOM);
	sudoku_start_game_async (self);
}

static void
sudoku_start_game_cb (Sudoku* self,
                      GSimpleAction* action,
                      GVariant* difficulty)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	sudoku_set_play_difficulty (self, (DifficultyCategory) g_variant_get_int32 (difficulty));
	sudoku_start_game_async (self);
}

static void
__lambda7_ (Sudoku* self,
            GObject* obj,
            GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		GeeList* gen_boards = NULL;
		GeeList* _tmp0_;
		gpointer _tmp1_;
		SudokuBoard* _tmp2_;
		_tmp0_ = sudoku_generator_generate_boards_finish (res, &_inner_error0_);
		gen_boards = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp1_ = gee_list_get (gen_boards, 0);
		_tmp2_ = (SudokuBoard*) _tmp1_;
		sudoku_start_game (self, _tmp2_);
		_g_object_unref0 (_tmp2_);
		_g_object_unref0 (gen_boards);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e->message;
		g_error ("gnome-sudoku.vala:392: Error: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda7__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
	__lambda7_ ((Sudoku*) self, source_object, res);
	g_object_unref (self);
}

static void
sudoku_start_game_async (Sudoku* self)
{
	DifficultyCategory _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_play_difficulty;
	sudoku_generator_generate_boards_async (1, _tmp0_, NULL, ___lambda7__gasync_ready_callback, g_object_ref (self));
}

static void
sudoku_back_cb (Sudoku* self)
{
	gboolean _tmp0_ = FALSE;
	SudokuGame* _tmp1_;
	SudokuGame* _tmp2_;
	SudokuWindow* _tmp9_;
	SudokuWindowScreen _tmp10_;
	SudokuWindowScreen _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp1_ = sudoku_get_game (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		SudokuGame* _tmp3_;
		SudokuGame* _tmp4_;
		SudokuBoard* _tmp5_;
		SudokuBoard* _tmp6_;
		gboolean _tmp7_;
		gboolean _tmp8_;
		_tmp3_ = sudoku_get_game (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = sudoku_game_get_board (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = sudoku_board_get_complete (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp0_ = _tmp8_ == TRUE;
	}
	if (_tmp0_) {
		return;
	}
	sudoku_show_game_view (self);
	_tmp9_ = self->priv->window;
	_tmp10_ = sudoku_window_get_current_screen (_tmp9_);
	_tmp11_ = _tmp10_;
	if (_tmp11_ == SUDOKU_WINDOW_SCREEN_PLAY) {
		SudokuGame* _tmp12_;
		SudokuGame* _tmp13_;
		_tmp12_ = sudoku_get_game (self);
		_tmp13_ = _tmp12_;
		sudoku_game_resume_clock (_tmp13_);
	}
}

static void
sudoku_print_current_board_cb (Sudoku* self)
{
	GSimpleAction* _tmp0_;
	GSimpleAction* _tmp1_;
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp2_;
	SudokuGame* _tmp3_;
	SudokuGame* _tmp4_;
	SudokuBoard* _tmp5_;
	SudokuBoard* _tmp6_;
	SudokuBoard* _tmp7_;
	SudokuBoard* _tmp8_;
	SudokuPrinter* printer = NULL;
	SudokuPrinter* _tmp9_;
	SudokuWindow* _tmp10_;
	GSimpleAction* _tmp11_;
	GSimpleAction* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->print_current_board_action;
	g_simple_action_set_enabled (_tmp0_, FALSE);
	_tmp1_ = self->priv->print_multiple_action;
	g_simple_action_set_enabled (_tmp1_, FALSE);
	_tmp2_ = gee_array_list_new (TYPE_SUDOKU_BOARD, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	list = _tmp2_;
	_tmp3_ = sudoku_get_game (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = sudoku_game_get_board (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = sudoku_board_clone (_tmp6_);
	_tmp8_ = _tmp7_;
	gee_abstract_collection_add ((GeeAbstractCollection*) list, _tmp8_);
	_g_object_unref0 (_tmp8_);
	_tmp9_ = sudoku_printer_new ((GeeList*) list, 1);
	printer = _tmp9_;
	_tmp10_ = self->priv->window;
	sudoku_printer_print_sudoku (printer, (GtkWindow*) _tmp10_);
	_tmp11_ = self->priv->print_current_board_action;
	g_simple_action_set_enabled (_tmp11_, TRUE);
	_tmp12_ = self->priv->print_multiple_action;
	g_simple_action_set_enabled (_tmp12_, TRUE);
	_g_object_unref0 (printer);
	_g_object_unref0 (list);
}

static void
sudoku_print_multiple_cb (Sudoku* self)
{
	SudokuPrintDialog* print_dialog = NULL;
	SudokuSaver* _tmp0_;
	SudokuWindow* _tmp1_;
	SudokuPrintDialog* _tmp2_;
	SudokuWindow* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->saver;
	_tmp1_ = self->priv->window;
	_tmp2_ = sudoku_print_dialog_new (_tmp0_, _tmp1_);
	g_object_ref_sink (_tmp2_);
	print_dialog = _tmp2_;
	_tmp3_ = self->priv->window;
	adw_dialog_present ((AdwDialog*) print_dialog, (GtkWidget*) _tmp3_);
	_g_object_unref0 (print_dialog);
}

static void
sudoku_preferences_dialog_cb (Sudoku* self)
{
	SudokuPreferencesDialog* preferences_dialog = NULL;
	SudokuPreferencesDialog* _tmp0_;
	SudokuWindow* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = sudoku_preferences_dialog_new ();
	g_object_ref_sink (_tmp0_);
	preferences_dialog = _tmp0_;
	_tmp1_ = self->priv->window;
	adw_dialog_present ((AdwDialog*) preferences_dialog, (GtkWidget*) _tmp1_);
	_g_object_unref0 (preferences_dialog);
}

static gboolean
___lambda16_ (Sudoku* self)
{
	SudokuWindow* _tmp0_;
	SudokuWindowScreen _tmp1_;
	SudokuWindowScreen _tmp2_;
	gboolean result;
	_tmp0_ = self->priv->window;
	_tmp1_ = sudoku_window_get_current_screen (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != SUDOKU_WINDOW_SCREEN_START) {
		SudokuGame* _tmp3_;
		SudokuGame* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		SudokuGameView* _tmp9_;
		SudokuGameView* _tmp10_;
		_tmp3_ = sudoku_get_game (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = sudoku_game_get_paused (_tmp4_);
		_tmp6_ = _tmp5_;
		if (!_tmp6_) {
			SudokuGame* _tmp7_;
			SudokuGame* _tmp8_;
			_tmp7_ = sudoku_get_game (self);
			_tmp8_ = _tmp7_;
			sudoku_game_resume_clock (_tmp8_);
		}
		_tmp9_ = sudoku_get_game_view (self);
		_tmp10_ = _tmp9_;
		gtk_widget_grab_focus ((GtkWidget*) _tmp10_);
	}
	result = GDK_EVENT_PROPAGATE;
	return result;
}

static gboolean
____lambda16__gtk_window_close_request (GtkWindow* _sender,
                                        gpointer self)
{
	gboolean result;
	result = ___lambda16_ ((Sudoku*) self);
	return result;
}

static void
sudoku_shortcuts_window_cb (Sudoku* self)
{
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp0_;
	GtkShortcutsWindow* shortcuts_window = NULL;
	GtkBuilder* _tmp1_;
	GObject* _tmp2_;
	GtkShortcutsWindow* _tmp3_;
	SudokuGame* _tmp4_;
	SudokuGame* _tmp5_;
	GtkShortcutsWindow* _tmp16_;
	SudokuWindow* _tmp17_;
	GtkShortcutsWindow* _tmp18_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_builder_new_from_resource ("/org/gnome/Sudoku/ui/shortcuts-window.ui");
	builder = _tmp0_;
	_tmp1_ = builder;
	_tmp2_ = gtk_builder_get_object (_tmp1_, "shortcuts-window");
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_shortcuts_window_get_type ()) ? ((GtkShortcutsWindow*) _tmp2_) : NULL);
	shortcuts_window = _tmp3_;
	_tmp4_ = sudoku_get_game (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		SudokuGame* _tmp6_;
		SudokuGame* _tmp7_;
		gboolean _tmp8_;
		gboolean _tmp9_;
		SudokuGameView* _tmp12_;
		SudokuGameView* _tmp13_;
		SudokuGrid* _tmp14_;
		GtkShortcutsWindow* _tmp15_;
		_tmp6_ = sudoku_get_game (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = sudoku_game_get_paused (_tmp7_);
		_tmp9_ = _tmp8_;
		if (!_tmp9_) {
			SudokuGame* _tmp10_;
			SudokuGame* _tmp11_;
			_tmp10_ = sudoku_get_game (self);
			_tmp11_ = _tmp10_;
			sudoku_game_stop_clock (_tmp11_);
		}
		_tmp12_ = sudoku_get_game_view (self);
		_tmp13_ = _tmp12_;
		_tmp14_ = _tmp13_->grid;
		sudoku_grid_unselect (_tmp14_);
		_tmp15_ = shortcuts_window;
		g_signal_connect_object ((GtkWindow*) _tmp15_, "close-request", (GCallback) ____lambda16__gtk_window_close_request, self, 0);
	}
	_tmp16_ = shortcuts_window;
	_tmp17_ = self->priv->window;
	gtk_window_set_transient_for ((GtkWindow*) _tmp16_, (GtkWindow*) _tmp17_);
	_tmp18_ = shortcuts_window;
	gtk_window_present ((GtkWindow*) _tmp18_);
	_g_object_unref0 (shortcuts_window);
	_g_object_unref0 (builder);
}

static void
sudoku_help_cb (Sudoku* self)
{
	SudokuWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	gtk_show_uri ((GtkWindow*) _tmp0_, "help:gnome-sudoku", (guint32) GDK_CURRENT_TIME);
}

static void
sudoku_about_cb (Sudoku* self)
{
	AdwAboutDialog* about_dialog = NULL;
	AdwAboutDialog* _tmp0_;
	SudokuWindow* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (AdwAboutDialog*) adw_about_dialog_new_from_appdata ("/org/gnome/Sudoku/metainfo.xml", VERSION);
	g_object_ref_sink (_tmp0_);
	about_dialog = _tmp0_;
	adw_about_dialog_set_version (about_dialog, VERSION);
	adw_about_dialog_set_copyright (about_dialog, "Copyright © 2005–2008 Thomas M. Hinkle\n" \
"Copyright © 2010–2011 Robert Ancell\n" \
"Copyright © 2014 Parin Porecha\n" \
"Copyright © 2023 Jamie Murphy\n" \
"Copyright © 2024-2025 Johan Gay");
	adw_about_dialog_set_developers (about_dialog, SUDOKU_authors);
	adw_about_dialog_set_translator_credits (about_dialog, _ ("translator-credits"));
	_tmp1_ = self->priv->window;
	adw_dialog_present ((AdwDialog*) about_dialog, (GtkWidget*) _tmp1_);
	_g_object_unref0 (about_dialog);
}

static void
sudoku_toggle_fullscreen_cb (Sudoku* self)
{
	SudokuWindow* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	g_object_get ((GtkWindow*) _tmp0_, "fullscreened", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		SudokuWindow* _tmp3_;
		_tmp3_ = self->priv->window;
		gtk_window_unfullscreen ((GtkWindow*) _tmp3_);
	} else {
		SudokuWindow* _tmp4_;
		_tmp4_ = self->priv->window;
		gtk_window_fullscreen ((GtkWindow*) _tmp4_);
	}
}

static void
sudoku_zoom_in_cb (Sudoku* self)
{
	ZoomLevel _tmp0_;
	ZoomLevel _tmp1_;
	GSimpleAction* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_zoom_level;
	sudoku_set_zoom_level (self, zoom_level_zoom_in (_tmp0_));
	_tmp1_ = self->priv->_zoom_level;
	if (zoom_level_is_fully_zoomed_in (_tmp1_)) {
		GSimpleAction* _tmp2_;
		_tmp2_ = self->priv->zoom_in_action;
		g_simple_action_set_enabled (_tmp2_, FALSE);
	}
	_tmp3_ = self->priv->zoom_out_action;
	g_simple_action_set_enabled (_tmp3_, TRUE);
}

static void
sudoku_zoom_out_cb (Sudoku* self)
{
	ZoomLevel _tmp0_;
	ZoomLevel _tmp1_;
	GSimpleAction* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_zoom_level;
	sudoku_set_zoom_level (self, zoom_level_zoom_out (_tmp0_));
	_tmp1_ = self->priv->_zoom_level;
	if (zoom_level_is_fully_zoomed_out (_tmp1_)) {
		GSimpleAction* _tmp2_;
		_tmp2_ = self->priv->zoom_out_action;
		g_simple_action_set_enabled (_tmp2_, FALSE);
	}
	_tmp3_ = self->priv->zoom_in_action;
	g_simple_action_set_enabled (_tmp3_, TRUE);
}

static void
sudoku_zoom_reset_cb (Sudoku* self)
{
	GSettings* _tmp0_;
	GSimpleAction* _tmp1_;
	GSimpleAction* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	g_settings_reset (_tmp0_, "zoom-level");
	_tmp1_ = self->priv->zoom_in_action;
	g_simple_action_set_enabled (_tmp1_, TRUE);
	_tmp2_ = self->priv->zoom_out_action;
	g_simple_action_set_enabled (_tmp2_, TRUE);
}

static gint
sudoku_main (gchar** args,
             gint args_length1)
{
	Sudoku* _tmp0_;
	Sudoku* _tmp1_;
	gint _tmp2_;
	gint result;
	_tmp0_ = sudoku_new ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_application_run ((GApplication*) _tmp1_, (gint) args_length1, args);
	_g_object_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

int
main (int argc,
      char ** argv)
{
	return sudoku_main (argv, argc);
}

static SudokuGameView*
sudoku_get_game_view (Sudoku* self)
{
	SudokuGameView* result;
	SudokuWindow* _tmp0_;
	SudokuGameView* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->window;
	_tmp1_ = _tmp0_->game_view;
	result = _tmp1_;
	return result;
}

static SudokuGame*
sudoku_get_game (Sudoku* self)
{
	SudokuGame* result;
	SudokuGameView* _tmp0_;
	SudokuGameView* _tmp1_;
	SudokuGame* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = sudoku_get_game_view (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->game;
	result = _tmp2_;
	return result;
}

DifficultyCategory
sudoku_get_play_difficulty (Sudoku* self)
{
	DifficultyCategory result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_play_difficulty;
	return result;
}

void
sudoku_set_play_difficulty (Sudoku* self,
                            DifficultyCategory value)
{
	DifficultyCategory old_value;
	g_return_if_fail (self != NULL);
	old_value = sudoku_get_play_difficulty (self);
	if (old_value != value) {
		self->priv->_play_difficulty = value;
		g_object_notify_by_pspec ((GObject *) self, sudoku_properties[SUDOKU_PLAY_DIFFICULTY_PROPERTY]);
	}
}

ZoomLevel
sudoku_get_zoom_level (Sudoku* self)
{
	ZoomLevel result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_zoom_level;
	return result;
}

void
sudoku_set_zoom_level (Sudoku* self,
                       ZoomLevel value)
{
	ZoomLevel old_value;
	g_return_if_fail (self != NULL);
	old_value = sudoku_get_zoom_level (self);
	if (old_value != value) {
		self->priv->_zoom_level = value;
		g_object_notify_by_pspec ((GObject *) self, sudoku_properties[SUDOKU_ZOOM_LEVEL_PROPERTY]);
	}
}

gboolean
sudoku_get_show_timer (Sudoku* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_show_timer;
	return result;
}

void
sudoku_set_show_timer (Sudoku* self,
                       gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = sudoku_get_show_timer (self);
	if (old_value != value) {
		self->priv->_show_timer = value;
		g_object_notify_by_pspec ((GObject *) self, sudoku_properties[SUDOKU_SHOW_TIMER_PROPERTY]);
	}
}

gboolean
sudoku_get_earmark_mode (Sudoku* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_earmark_mode;
	return result;
}

void
sudoku_set_earmark_mode (Sudoku* self,
                         gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = sudoku_get_earmark_mode (self);
	if (old_value != value) {
		self->priv->_earmark_mode = value;
		g_object_notify_by_pspec ((GObject *) self, sudoku_properties[SUDOKU_EARMARK_MODE_PROPERTY]);
	}
}

gboolean
sudoku_get_show_possibilities (Sudoku* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_show_possibilities;
	return result;
}

void
sudoku_set_show_possibilities (Sudoku* self,
                               gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = sudoku_get_show_possibilities (self);
	if (old_value != value) {
		self->priv->_show_possibilities = value;
		g_object_notify_by_pspec ((GObject *) self, sudoku_properties[SUDOKU_SHOW_POSSIBILITIES_PROPERTY]);
	}
}

gboolean
sudoku_get_highlighter (Sudoku* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_highlighter;
	return result;
}

void
sudoku_set_highlighter (Sudoku* self,
                        gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = sudoku_get_highlighter (self);
	if (old_value != value) {
		self->priv->_highlighter = value;
		g_object_notify_by_pspec ((GObject *) self, sudoku_properties[SUDOKU_HIGHLIGHTER_PROPERTY]);
	}
}

gboolean
sudoku_get_highlight_row_column (Sudoku* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_highlight_row_column;
	return result;
}

void
sudoku_set_highlight_row_column (Sudoku* self,
                                 gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = sudoku_get_highlight_row_column (self);
	if (old_value != value) {
		self->priv->_highlight_row_column = value;
		g_object_notify_by_pspec ((GObject *) self, sudoku_properties[SUDOKU_HIGHLIGHT_ROW_COLUMN_PROPERTY]);
	}
}

gboolean
sudoku_get_highlight_block (Sudoku* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_highlight_block;
	return result;
}

void
sudoku_set_highlight_block (Sudoku* self,
                            gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = sudoku_get_highlight_block (self);
	if (old_value != value) {
		self->priv->_highlight_block = value;
		g_object_notify_by_pspec ((GObject *) self, sudoku_properties[SUDOKU_HIGHLIGHT_BLOCK_PROPERTY]);
	}
}

gboolean
sudoku_get_highlight_numbers (Sudoku* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_highlight_numbers;
	return result;
}

void
sudoku_set_highlight_numbers (Sudoku* self,
                              gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = sudoku_get_highlight_numbers (self);
	if (old_value != value) {
		self->priv->_highlight_numbers = value;
		g_object_notify_by_pspec ((GObject *) self, sudoku_properties[SUDOKU_HIGHLIGHT_NUMBERS_PROPERTY]);
	}
}

gboolean
sudoku_get_show_warnings (Sudoku* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_show_warnings;
	return result;
}

void
sudoku_set_show_warnings (Sudoku* self,
                          gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = sudoku_get_show_warnings (self);
	if (old_value != value) {
		self->priv->_show_warnings = value;
		g_object_notify_by_pspec ((GObject *) self, sudoku_properties[SUDOKU_SHOW_WARNINGS_PROPERTY]);
	}
}

gboolean
sudoku_get_solution_warnings (Sudoku* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_solution_warnings;
	return result;
}

void
sudoku_set_solution_warnings (Sudoku* self,
                              gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = sudoku_get_solution_warnings (self);
	if (old_value != value) {
		self->priv->_solution_warnings = value;
		g_object_notify_by_pspec ((GObject *) self, sudoku_properties[SUDOKU_SOLUTION_WARNINGS_PROPERTY]);
	}
}

gboolean
sudoku_get_earmark_warnings (Sudoku* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_earmark_warnings;
	return result;
}

void
sudoku_set_earmark_warnings (Sudoku* self,
                             gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = sudoku_get_earmark_warnings (self);
	if (old_value != value) {
		self->priv->_earmark_warnings = value;
		g_object_notify_by_pspec ((GObject *) self, sudoku_properties[SUDOKU_EARMARK_WARNINGS_PROPERTY]);
	}
}

gboolean
sudoku_get_autoclean_earmarks (Sudoku* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_autoclean_earmarks;
	return result;
}

void
sudoku_set_autoclean_earmarks (Sudoku* self,
                               gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = sudoku_get_autoclean_earmarks (self);
	if (old_value != value) {
		self->priv->_autoclean_earmarks = value;
		g_object_notify_by_pspec ((GObject *) self, sudoku_properties[SUDOKU_AUTOCLEAN_EARMARKS_PROPERTY]);
	}
}

gboolean
sudoku_get_number_picker_second_click (Sudoku* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_number_picker_second_click;
	return result;
}

void
sudoku_set_number_picker_second_click (Sudoku* self,
                                       gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = sudoku_get_number_picker_second_click (self);
	if (old_value != value) {
		self->priv->_number_picker_second_click = value;
		g_object_notify_by_pspec ((GObject *) self, sudoku_properties[SUDOKU_NUMBER_PICKER_SECOND_CLICK_PROPERTY]);
	}
}

static void
sudoku_class_init (SudokuClass * klass,
                   gpointer klass_data)
{
	sudoku_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Sudoku_private_offset);
	((GApplicationClass *) klass)->handle_local_options = (gint (*) (GApplication*, GVariantDict*)) sudoku_real_handle_local_options;
	((GApplicationClass *) klass)->startup = (void (*) (GApplication*)) sudoku_real_startup;
	((GApplicationClass *) klass)->activate = (void (*) (GApplication*)) sudoku_real_activate;
	((GApplicationClass *) klass)->shutdown = (void (*) (GApplication*)) sudoku_real_shutdown;
	G_OBJECT_CLASS (klass)->get_property = _vala_sudoku_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sudoku_set_property;
	G_OBJECT_CLASS (klass)->finalize = sudoku_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_PLAY_DIFFICULTY_PROPERTY, sudoku_properties[SUDOKU_PLAY_DIFFICULTY_PROPERTY] = g_param_spec_enum ("play-difficulty", "play-difficulty", "play-difficulty", TYPE_DIFFICULTY_CATEGORY, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_ZOOM_LEVEL_PROPERTY, sudoku_properties[SUDOKU_ZOOM_LEVEL_PROPERTY] = g_param_spec_enum ("zoom-level", "zoom-level", "zoom-level", TYPE_ZOOM_LEVEL, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_SHOW_TIMER_PROPERTY, sudoku_properties[SUDOKU_SHOW_TIMER_PROPERTY] = g_param_spec_boolean ("show-timer", "show-timer", "show-timer", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_EARMARK_MODE_PROPERTY, sudoku_properties[SUDOKU_EARMARK_MODE_PROPERTY] = g_param_spec_boolean ("earmark-mode", "earmark-mode", "earmark-mode", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_SHOW_POSSIBILITIES_PROPERTY, sudoku_properties[SUDOKU_SHOW_POSSIBILITIES_PROPERTY] = g_param_spec_boolean ("show-possibilities", "show-possibilities", "show-possibilities", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_HIGHLIGHTER_PROPERTY, sudoku_properties[SUDOKU_HIGHLIGHTER_PROPERTY] = g_param_spec_boolean ("highlighter", "highlighter", "highlighter", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_HIGHLIGHT_ROW_COLUMN_PROPERTY, sudoku_properties[SUDOKU_HIGHLIGHT_ROW_COLUMN_PROPERTY] = g_param_spec_boolean ("highlight-row-column", "highlight-row-column", "highlight-row-column", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_HIGHLIGHT_BLOCK_PROPERTY, sudoku_properties[SUDOKU_HIGHLIGHT_BLOCK_PROPERTY] = g_param_spec_boolean ("highlight-block", "highlight-block", "highlight-block", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_HIGHLIGHT_NUMBERS_PROPERTY, sudoku_properties[SUDOKU_HIGHLIGHT_NUMBERS_PROPERTY] = g_param_spec_boolean ("highlight-numbers", "highlight-numbers", "highlight-numbers", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_SHOW_WARNINGS_PROPERTY, sudoku_properties[SUDOKU_SHOW_WARNINGS_PROPERTY] = g_param_spec_boolean ("show-warnings", "show-warnings", "show-warnings", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_SOLUTION_WARNINGS_PROPERTY, sudoku_properties[SUDOKU_SOLUTION_WARNINGS_PROPERTY] = g_param_spec_boolean ("solution-warnings", "solution-warnings", "solution-warnings", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_EARMARK_WARNINGS_PROPERTY, sudoku_properties[SUDOKU_EARMARK_WARNINGS_PROPERTY] = g_param_spec_boolean ("earmark-warnings", "earmark-warnings", "earmark-warnings", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_AUTOCLEAN_EARMARKS_PROPERTY, sudoku_properties[SUDOKU_AUTOCLEAN_EARMARKS_PROPERTY] = g_param_spec_boolean ("autoclean-earmarks", "autoclean-earmarks", "autoclean-earmarks", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_NUMBER_PICKER_SECOND_CLICK_PROPERTY, sudoku_properties[SUDOKU_NUMBER_PICKER_SECOND_CLICK_PROPERTY] = g_param_spec_boolean ("number-picker-second-click", "number-picker-second-click", "number-picker-second-click", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
sudoku_instance_init (Sudoku * self,
                      gpointer klass)
{
	self->priv = sudoku_get_instance_private (self);
	self->priv->_earmark_mode = FALSE;
}

static void
sudoku_finalize (GObject * obj)
{
	Sudoku * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU, Sudoku);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->window);
	_g_object_unref0 (self->priv->saver);
	_g_object_unref0 (self->priv->print_current_board_action);
	_g_object_unref0 (self->priv->print_multiple_action);
	_g_object_unref0 (self->priv->new_game_action);
	_g_object_unref0 (self->priv->back_action);
	_g_object_unref0 (self->priv->zoom_in_action);
	_g_object_unref0 (self->priv->zoom_out_action);
	G_OBJECT_CLASS (sudoku_parent_class)->finalize (obj);
}

static GType
sudoku_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SudokuClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Sudoku), 0, (GInstanceInitFunc) sudoku_instance_init, NULL };
	GType sudoku_type_id;
	sudoku_type_id = g_type_register_static (adw_application_get_type (), "Sudoku", &g_define_type_info, 0);
	Sudoku_private_offset = g_type_add_instance_private (sudoku_type_id, sizeof (SudokuPrivate));
	return sudoku_type_id;
}

GType
sudoku_get_type (void)
{
	static volatile gsize sudoku_type_id__once = 0;
	if (g_once_init_enter (&sudoku_type_id__once)) {
		GType sudoku_type_id;
		sudoku_type_id = sudoku_get_type_once ();
		g_once_init_leave (&sudoku_type_id__once, sudoku_type_id);
	}
	return sudoku_type_id__once;
}

static void
_vala_sudoku_get_property (GObject * object,
                           guint property_id,
                           GValue * value,
                           GParamSpec * pspec)
{
	Sudoku * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU, Sudoku);
	switch (property_id) {
		case SUDOKU_PLAY_DIFFICULTY_PROPERTY:
		g_value_set_enum (value, sudoku_get_play_difficulty (self));
		break;
		case SUDOKU_ZOOM_LEVEL_PROPERTY:
		g_value_set_enum (value, sudoku_get_zoom_level (self));
		break;
		case SUDOKU_SHOW_TIMER_PROPERTY:
		g_value_set_boolean (value, sudoku_get_show_timer (self));
		break;
		case SUDOKU_EARMARK_MODE_PROPERTY:
		g_value_set_boolean (value, sudoku_get_earmark_mode (self));
		break;
		case SUDOKU_SHOW_POSSIBILITIES_PROPERTY:
		g_value_set_boolean (value, sudoku_get_show_possibilities (self));
		break;
		case SUDOKU_HIGHLIGHTER_PROPERTY:
		g_value_set_boolean (value, sudoku_get_highlighter (self));
		break;
		case SUDOKU_HIGHLIGHT_ROW_COLUMN_PROPERTY:
		g_value_set_boolean (value, sudoku_get_highlight_row_column (self));
		break;
		case SUDOKU_HIGHLIGHT_BLOCK_PROPERTY:
		g_value_set_boolean (value, sudoku_get_highlight_block (self));
		break;
		case SUDOKU_HIGHLIGHT_NUMBERS_PROPERTY:
		g_value_set_boolean (value, sudoku_get_highlight_numbers (self));
		break;
		case SUDOKU_SHOW_WARNINGS_PROPERTY:
		g_value_set_boolean (value, sudoku_get_show_warnings (self));
		break;
		case SUDOKU_SOLUTION_WARNINGS_PROPERTY:
		g_value_set_boolean (value, sudoku_get_solution_warnings (self));
		break;
		case SUDOKU_EARMARK_WARNINGS_PROPERTY:
		g_value_set_boolean (value, sudoku_get_earmark_warnings (self));
		break;
		case SUDOKU_AUTOCLEAN_EARMARKS_PROPERTY:
		g_value_set_boolean (value, sudoku_get_autoclean_earmarks (self));
		break;
		case SUDOKU_NUMBER_PICKER_SECOND_CLICK_PROPERTY:
		g_value_set_boolean (value, sudoku_get_number_picker_second_click (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_sudoku_set_property (GObject * object,
                           guint property_id,
                           const GValue * value,
                           GParamSpec * pspec)
{
	Sudoku * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU, Sudoku);
	switch (property_id) {
		case SUDOKU_PLAY_DIFFICULTY_PROPERTY:
		sudoku_set_play_difficulty (self, g_value_get_enum (value));
		break;
		case SUDOKU_ZOOM_LEVEL_PROPERTY:
		sudoku_set_zoom_level (self, g_value_get_enum (value));
		break;
		case SUDOKU_SHOW_TIMER_PROPERTY:
		sudoku_set_show_timer (self, g_value_get_boolean (value));
		break;
		case SUDOKU_EARMARK_MODE_PROPERTY:
		sudoku_set_earmark_mode (self, g_value_get_boolean (value));
		break;
		case SUDOKU_SHOW_POSSIBILITIES_PROPERTY:
		sudoku_set_show_possibilities (self, g_value_get_boolean (value));
		break;
		case SUDOKU_HIGHLIGHTER_PROPERTY:
		sudoku_set_highlighter (self, g_value_get_boolean (value));
		break;
		case SUDOKU_HIGHLIGHT_ROW_COLUMN_PROPERTY:
		sudoku_set_highlight_row_column (self, g_value_get_boolean (value));
		break;
		case SUDOKU_HIGHLIGHT_BLOCK_PROPERTY:
		sudoku_set_highlight_block (self, g_value_get_boolean (value));
		break;
		case SUDOKU_HIGHLIGHT_NUMBERS_PROPERTY:
		sudoku_set_highlight_numbers (self, g_value_get_boolean (value));
		break;
		case SUDOKU_SHOW_WARNINGS_PROPERTY:
		sudoku_set_show_warnings (self, g_value_get_boolean (value));
		break;
		case SUDOKU_SOLUTION_WARNINGS_PROPERTY:
		sudoku_set_solution_warnings (self, g_value_get_boolean (value));
		break;
		case SUDOKU_EARMARK_WARNINGS_PROPERTY:
		sudoku_set_earmark_warnings (self, g_value_get_boolean (value));
		break;
		case SUDOKU_AUTOCLEAN_EARMARKS_PROPERTY:
		sudoku_set_autoclean_earmarks (self, g_value_get_boolean (value));
		break;
		case SUDOKU_NUMBER_PICKER_SECOND_CLICK_PROPERTY:
		sudoku_set_number_picker_second_click (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

