/* window.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from window.vala, do not modify */

/*
 * Copyright (C) 2013  Paolo Borelli <pborelli@gnome.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <adwaita.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include "config.h"
#include <libgweather/gweather.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CLOCKS_TYPE_WINDOW (clocks_window_get_type ())
#define CLOCKS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_WINDOW, ClocksWindow))
#define CLOCKS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_TYPE_WINDOW, ClocksWindowClass))
#define CLOCKS_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_WINDOW))
#define CLOCKS_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_TYPE_WINDOW))
#define CLOCKS_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_TYPE_WINDOW, ClocksWindowClass))

typedef struct _ClocksWindow ClocksWindow;
typedef struct _ClocksWindowClass ClocksWindowClass;
typedef struct _ClocksWindowPrivate ClocksWindowPrivate;

#define CLOCKS_TYPE_HEADER_BAR (clocks_header_bar_get_type ())
#define CLOCKS_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_HEADER_BAR, ClocksHeaderBar))
#define CLOCKS_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_TYPE_HEADER_BAR, ClocksHeaderBarClass))
#define CLOCKS_IS_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_HEADER_BAR))
#define CLOCKS_IS_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_TYPE_HEADER_BAR))
#define CLOCKS_HEADER_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_TYPE_HEADER_BAR, ClocksHeaderBarClass))

typedef struct _ClocksHeaderBar ClocksHeaderBar;
typedef struct _ClocksHeaderBarClass ClocksHeaderBarClass;

#define CLOCKS_WORLD_TYPE_FACE (clocks_world_face_get_type ())
#define CLOCKS_WORLD_FACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_WORLD_TYPE_FACE, ClocksWorldFace))
#define CLOCKS_WORLD_FACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_WORLD_TYPE_FACE, ClocksWorldFaceClass))
#define CLOCKS_WORLD_IS_FACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_WORLD_TYPE_FACE))
#define CLOCKS_WORLD_IS_FACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_WORLD_TYPE_FACE))
#define CLOCKS_WORLD_FACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_WORLD_TYPE_FACE, ClocksWorldFaceClass))

typedef struct _ClocksWorldFace ClocksWorldFace;
typedef struct _ClocksWorldFaceClass ClocksWorldFaceClass;

#define CLOCKS_ALARM_TYPE_FACE (clocks_alarm_face_get_type ())
#define CLOCKS_ALARM_FACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_ALARM_TYPE_FACE, ClocksAlarmFace))
#define CLOCKS_ALARM_FACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_ALARM_TYPE_FACE, ClocksAlarmFaceClass))
#define CLOCKS_ALARM_IS_FACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_ALARM_TYPE_FACE))
#define CLOCKS_ALARM_IS_FACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_ALARM_TYPE_FACE))
#define CLOCKS_ALARM_FACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_ALARM_TYPE_FACE, ClocksAlarmFaceClass))

typedef struct _ClocksAlarmFace ClocksAlarmFace;
typedef struct _ClocksAlarmFaceClass ClocksAlarmFaceClass;

#define CLOCKS_WORLD_TYPE_STANDALONE (clocks_world_standalone_get_type ())
#define CLOCKS_WORLD_STANDALONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_WORLD_TYPE_STANDALONE, ClocksWorldStandalone))
#define CLOCKS_WORLD_STANDALONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_WORLD_TYPE_STANDALONE, ClocksWorldStandaloneClass))
#define CLOCKS_WORLD_IS_STANDALONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_WORLD_TYPE_STANDALONE))
#define CLOCKS_WORLD_IS_STANDALONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_WORLD_TYPE_STANDALONE))
#define CLOCKS_WORLD_STANDALONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_WORLD_TYPE_STANDALONE, ClocksWorldStandaloneClass))

typedef struct _ClocksWorldStandalone ClocksWorldStandalone;
typedef struct _ClocksWorldStandaloneClass ClocksWorldStandaloneClass;

#define CLOCKS_ALARM_TYPE_RINGING_PANEL (clocks_alarm_ringing_panel_get_type ())
#define CLOCKS_ALARM_RINGING_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_ALARM_TYPE_RINGING_PANEL, ClocksAlarmRingingPanel))
#define CLOCKS_ALARM_RINGING_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_ALARM_TYPE_RINGING_PANEL, ClocksAlarmRingingPanelClass))
#define CLOCKS_ALARM_IS_RINGING_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_ALARM_TYPE_RINGING_PANEL))
#define CLOCKS_ALARM_IS_RINGING_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_ALARM_TYPE_RINGING_PANEL))
#define CLOCKS_ALARM_RINGING_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_ALARM_TYPE_RINGING_PANEL, ClocksAlarmRingingPanelClass))

typedef struct _ClocksAlarmRingingPanel ClocksAlarmRingingPanel;
typedef struct _ClocksAlarmRingingPanelClass ClocksAlarmRingingPanelClass;

#define CLOCKS_STOPWATCH_TYPE_FACE (clocks_stopwatch_face_get_type ())
#define CLOCKS_STOPWATCH_FACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_STOPWATCH_TYPE_FACE, ClocksStopwatchFace))
#define CLOCKS_STOPWATCH_FACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_STOPWATCH_TYPE_FACE, ClocksStopwatchFaceClass))
#define CLOCKS_STOPWATCH_IS_FACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_STOPWATCH_TYPE_FACE))
#define CLOCKS_STOPWATCH_IS_FACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_STOPWATCH_TYPE_FACE))
#define CLOCKS_STOPWATCH_FACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_STOPWATCH_TYPE_FACE, ClocksStopwatchFaceClass))

typedef struct _ClocksStopwatchFace ClocksStopwatchFace;
typedef struct _ClocksStopwatchFaceClass ClocksStopwatchFaceClass;

#define CLOCKS_TIMER_TYPE_FACE (clocks_timer_face_get_type ())
#define CLOCKS_TIMER_FACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TIMER_TYPE_FACE, ClocksTimerFace))
#define CLOCKS_TIMER_FACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_TIMER_TYPE_FACE, ClocksTimerFaceClass))
#define CLOCKS_TIMER_IS_FACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TIMER_TYPE_FACE))
#define CLOCKS_TIMER_IS_FACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_TIMER_TYPE_FACE))
#define CLOCKS_TIMER_FACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_TIMER_TYPE_FACE, ClocksTimerFaceClass))

typedef struct _ClocksTimerFace ClocksTimerFace;
typedef struct _ClocksTimerFaceClass ClocksTimerFaceClass;
enum  {
	CLOCKS_WINDOW_0_PROPERTY,
	CLOCKS_WINDOW_NUM_PROPERTIES
};
static GParamSpec* clocks_window_properties[CLOCKS_WINDOW_NUM_PROPERTIES];
typedef void (*GSimpleActionActivateCallback) (GSimpleAction* action, GVariant* parameter, gpointer user_data);
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define CLOCKS_TYPE_APPLICATION (clocks_application_get_type ())
#define CLOCKS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_APPLICATION, ClocksApplication))
#define CLOCKS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_TYPE_APPLICATION, ClocksApplicationClass))
#define CLOCKS_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_APPLICATION))
#define CLOCKS_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_TYPE_APPLICATION))
#define CLOCKS_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_TYPE_APPLICATION, ClocksApplicationClass))

typedef struct _ClocksApplication ClocksApplication;
typedef struct _ClocksApplicationClass ClocksApplicationClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define CLOCKS_WORLD_TYPE_ITEM (clocks_world_item_get_type ())
#define CLOCKS_WORLD_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_WORLD_TYPE_ITEM, ClocksWorldItem))
#define CLOCKS_WORLD_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_WORLD_TYPE_ITEM, ClocksWorldItemClass))
#define CLOCKS_WORLD_IS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_WORLD_TYPE_ITEM))
#define CLOCKS_WORLD_IS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_WORLD_TYPE_ITEM))
#define CLOCKS_WORLD_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_WORLD_TYPE_ITEM, ClocksWorldItemClass))

typedef struct _ClocksWorldItem ClocksWorldItem;
typedef struct _ClocksWorldItemClass ClocksWorldItemClass;

#define CLOCKS_UTILS_TYPE_WALL_CLOCK (clocks_utils_wall_clock_get_type ())
#define CLOCKS_UTILS_WALL_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_UTILS_TYPE_WALL_CLOCK, ClocksUtilsWallClock))
#define CLOCKS_UTILS_WALL_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_UTILS_TYPE_WALL_CLOCK, ClocksUtilsWallClockClass))
#define CLOCKS_UTILS_IS_WALL_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_UTILS_TYPE_WALL_CLOCK))
#define CLOCKS_UTILS_IS_WALL_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_UTILS_TYPE_WALL_CLOCK))
#define CLOCKS_UTILS_WALL_CLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_UTILS_TYPE_WALL_CLOCK, ClocksUtilsWallClockClass))

typedef struct _ClocksUtilsWallClock ClocksUtilsWallClock;
typedef struct _ClocksUtilsWallClockClass ClocksUtilsWallClockClass;

#define CLOCKS_ALARM_TYPE_ITEM (clocks_alarm_item_get_type ())
#define CLOCKS_ALARM_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_ALARM_TYPE_ITEM, ClocksAlarmItem))
#define CLOCKS_ALARM_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_ALARM_TYPE_ITEM, ClocksAlarmItemClass))
#define CLOCKS_ALARM_IS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_ALARM_TYPE_ITEM))
#define CLOCKS_ALARM_IS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_ALARM_TYPE_ITEM))
#define CLOCKS_ALARM_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_ALARM_TYPE_ITEM, ClocksAlarmItemClass))

typedef struct _ClocksAlarmItem ClocksAlarmItem;
typedef struct _ClocksAlarmItemClass ClocksAlarmItemClass;
typedef enum  {
	CLOCKS_STOPWATCH_FACE_STATE_RESET,
	CLOCKS_STOPWATCH_FACE_STATE_RUNNING,
	CLOCKS_STOPWATCH_FACE_STATE_STOPPED
} ClocksStopwatchFaceState;

#define CLOCKS_STOPWATCH_FACE_TYPE_STATE (clocks_stopwatch_face_state_get_type ())

#define CLOCKS_TYPE_CLOCK (clocks_clock_get_type ())
#define CLOCKS_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_CLOCK, ClocksClock))
#define CLOCKS_IS_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_CLOCK))
#define CLOCKS_CLOCK_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CLOCKS_TYPE_CLOCK, ClocksClockIface))

typedef struct _ClocksClock ClocksClock;
typedef struct _ClocksClockIface ClocksClockIface;
typedef enum  {
	CLOCKS_PANEL_ID_WORLD,
	CLOCKS_PANEL_ID_ALARM,
	CLOCKS_PANEL_ID_STOPWATCH,
	CLOCKS_PANEL_ID_TIMER
} ClocksPanelId;

#define CLOCKS_TYPE_PANEL_ID (clocks_panel_id_get_type ())
typedef enum  {
	CLOCKS_BUTTON_MODE_NEW,
	CLOCKS_BUTTON_MODE_NONE
} ClocksButtonMode;

#define CLOCKS_TYPE_BUTTON_MODE (clocks_button_mode_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _ClocksWindow {
	AdwApplicationWindow parent_instance;
	ClocksWindowPrivate * priv;
};

struct _ClocksWindowClass {
	AdwApplicationWindowClass parent_class;
};

struct _ClocksWindowPrivate {
	ClocksHeaderBar* header_bar;
	AdwToastOverlay* toast_overlay;
	AdwNavigationView* navigation_view;
	AdwNavigationPage* main_page;
	AdwNavigationPage* world_subpage;
	AdwNavigationPage* alarm_subpage;
	AdwViewStack* stack;
	ClocksWorldFace* world;
	ClocksAlarmFace* alarm;
	ClocksWorldStandalone* world_standalone;
	ClocksAlarmRingingPanel* alarm_ringing_panel;
	ClocksStopwatchFace* stopwatch;
	ClocksTimerFace* timer;
	GSettings* settings;
	GBinding* bind_button_mode;
	GBinding* bind_new_label;
	gboolean inited;
};

struct _ClocksClockIface {
	GTypeInterface parent_iface;
	void (*activate_new) (ClocksClock* self);
	gboolean (*escape_pressed) (ClocksClock* self);
	ClocksPanelId (*get_panel_id) (ClocksClock* self);
	void (*set_panel_id) (ClocksClock* self, ClocksPanelId value);
	ClocksButtonMode (*get_button_mode) (ClocksClock* self);
	void (*set_button_mode) (ClocksClock* self, ClocksButtonMode value);
	const gchar* (*get_new_label) (ClocksClock* self);
};

static gint ClocksWindow_private_offset;
static gpointer clocks_window_parent_class = NULL;

VALA_EXTERN GType clocks_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksWindow, g_object_unref)
VALA_EXTERN GType clocks_header_bar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksHeaderBar, g_object_unref)
VALA_EXTERN GType clocks_world_face_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksWorldFace, g_object_unref)
VALA_EXTERN GType clocks_alarm_face_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksAlarmFace, g_object_unref)
VALA_EXTERN GType clocks_world_standalone_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksWorldStandalone, g_object_unref)
VALA_EXTERN GType clocks_alarm_ringing_panel_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksAlarmRingingPanel, g_object_unref)
VALA_EXTERN GType clocks_stopwatch_face_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksStopwatchFace, g_object_unref)
VALA_EXTERN GType clocks_timer_face_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksTimerFace, g_object_unref)
static void clocks_window_on_new_activate (ClocksWindow* self);
static void _clocks_window_on_new_activate_gsimple_action_activate_callback (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      gpointer self);
static void clocks_window_on_help_activate (ClocksWindow* self);
static void _clocks_window_on_help_activate_gsimple_action_activate_callback (GSimpleAction* action,
                                                                       GVariant* parameter,
                                                                       gpointer self);
static void clocks_window_on_navigate_forward (ClocksWindow* self);
static void _clocks_window_on_navigate_forward_gsimple_action_activate_callback (GSimpleAction* action,
                                                                          GVariant* parameter,
                                                                          gpointer self);
static void clocks_window_on_navigate_backward (ClocksWindow* self);
static void _clocks_window_on_navigate_backward_gsimple_action_activate_callback (GSimpleAction* action,
                                                                           GVariant* parameter,
                                                                           gpointer self);
static void clocks_window_on_about_activate (ClocksWindow* self);
static void _clocks_window_on_about_activate_gsimple_action_activate_callback (GSimpleAction* action,
                                                                        GVariant* parameter,
                                                                        gpointer self);
VALA_EXTERN GType clocks_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksApplication, g_object_unref)
VALA_EXTERN ClocksWindow* clocks_window_new (ClocksApplication* app);
VALA_EXTERN ClocksWindow* clocks_window_construct (GType object_type,
                                       ClocksApplication* app);
static void clocks_window_pane_changed (ClocksWindow* self);
static void clocks_window_load_window_state (ClocksWindow* self);
VALA_EXTERN GType clocks_world_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksWorldItem, g_object_unref)
static void __lambda59_ (ClocksWindow* self,
                  ClocksWorldFace* w,
                  ClocksWorldItem* l);
VALA_EXTERN void clocks_world_standalone_set_location (ClocksWorldStandalone* self,
                                           ClocksWorldItem* value);
VALA_EXTERN GType clocks_utils_wall_clock_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksUtilsWallClock, g_object_unref)
VALA_EXTERN ClocksUtilsWallClock* clocks_utils_wall_clock_get_default (void);
VALA_EXTERN void clocks_utils_wall_clock_set_seconds_precision (ClocksUtilsWallClock* self,
                                                    gboolean value);
static void ___lambda59__clocks_world_face_show_standalone (ClocksWorldFace* _sender,
                                                     ClocksWorldItem* location,
                                                     gpointer self);
static void __lambda60_ (ClocksWindow* self);
static void ___lambda60__adw_navigation_page_hidden (AdwNavigationPage* _sender,
                                              gpointer self);
VALA_EXTERN GType clocks_alarm_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksAlarmItem, g_object_unref)
static void __lambda61_ (ClocksWindow* self,
                  ClocksAlarmFace* w,
                  ClocksAlarmItem* a);
static void clocks_window_close_standalone (ClocksWindow* self);
VALA_EXTERN void clocks_alarm_ringing_panel_set_alarm (ClocksAlarmRingingPanel* self,
                                           ClocksAlarmItem* value);
static void ___lambda61__clocks_alarm_face_ring (ClocksAlarmFace* _sender,
                                          ClocksAlarmItem* item,
                                          gpointer self);
static void __lambda62_ (ClocksWindow* self,
                  GParamSpec* w);
VALA_EXTERN GType clocks_stopwatch_face_state_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ClocksStopwatchFaceState clocks_stopwatch_face_get_state (ClocksStopwatchFace* self);
static void ___lambda62__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda63_ (ClocksWindow* self,
                  ClocksTimerFace* w);
static void ___lambda63__clocks_timer_face_ring (ClocksTimerFace* _sender,
                                          gpointer self);
static void __lambda64_ (ClocksWindow* self,
                  GParamSpec* w);
VALA_EXTERN gboolean clocks_timer_face_get_is_running (ClocksTimerFace* self);
static void ___lambda64__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
VALA_EXTERN GType clocks_panel_id_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType clocks_button_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType clocks_clock_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksClock, g_object_unref)
VALA_EXTERN void clocks_clock_activate_new (ClocksClock* self);
VALA_EXTERN void clocks_window_show_world (ClocksWindow* self);
VALA_EXTERN void clocks_window_add_world_location (ClocksWindow* self,
                                       GWeatherLocation* location);
VALA_EXTERN void clocks_world_face_add_location (ClocksWorldFace* self,
                                     GWeatherLocation* location);
static gboolean clocks_window_real_close_request (GtkWindow* base);
static void clocks_window_save_window_state (ClocksWindow* self);
static void clocks_window_on_window_active (ClocksWindow* self);
VALA_EXTERN void clocks_application_withdraw_notifications (ClocksApplication* self);
static void _clocks_window_on_window_active_g_object_notify (GObject* _sender,
                                                      GParamSpec* pspec,
                                                      gpointer self);
static gboolean clocks_window_key_press_cb (ClocksWindow* self,
                                     GtkEventControllerKey* controller,
                                     guint keyval,
                                     guint keycode,
                                     GdkModifierType mod_state);
VALA_EXTERN gboolean clocks_clock_escape_pressed (ClocksClock* self);
static gboolean _clocks_window_key_press_cb_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                           guint keyval,
                                                                           guint keycode,
                                                                           GdkModifierType state,
                                                                           gpointer self);
static void __lambda58_ (ClocksWindow* self,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda58__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static gchar** _vala_array_dup5 (gchar** self,
                          gssize length);
VALA_EXTERN ClocksPanelId clocks_clock_get_panel_id (ClocksClock* self);
static void _clocks_window_pane_changed_g_object_notify (GObject* _sender,
                                                  GParamSpec* pspec,
                                                  gpointer self);
static void clocks_window_visible_page_changed (ClocksWindow* self);
VALA_EXTERN const gchar* clocks_world_standalone_get_title (ClocksWorldStandalone* self);
static void _clocks_window_visible_page_changed_g_object_notify (GObject* _sender,
                                                          GParamSpec* pspec,
                                                          gpointer self);
static void clocks_window_alarm_dismissed (ClocksWindow* self);
static void _clocks_window_alarm_dismissed_clocks_alarm_ringing_panel_dismiss (ClocksAlarmRingingPanel* _sender,
                                                                        gpointer self);
static void clocks_window_on_set_page (ClocksWindow* self,
                                const gchar* action_name,
                                GVariant* param);
VALA_EXTERN void clocks_window_add_toast (ClocksWindow* self,
                              AdwToast* toast);
static GObject * clocks_window_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties);
static void clocks_window_finalize (GObject * obj);
static GType clocks_window_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GActionEntry CLOCKS_WINDOW_ACTION_ENTRIES[5] = {{"new", _clocks_window_on_new_activate_gsimple_action_activate_callback}, {"help", _clocks_window_on_help_activate_gsimple_action_activate_callback}, {"navigate-forward", _clocks_window_on_navigate_forward_gsimple_action_activate_callback}, {"navigate-backward", _clocks_window_on_navigate_backward_gsimple_action_activate_callback}, {"about", _clocks_window_on_about_activate_gsimple_action_activate_callback}};

static inline gpointer
clocks_window_get_instance_private (ClocksWindow* self)
{
	return G_STRUCT_MEMBER_P (self, ClocksWindow_private_offset);
}

static void
_clocks_window_on_new_activate_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self)
{
	clocks_window_on_new_activate ((ClocksWindow*) self);
}

static void
_clocks_window_on_help_activate_gsimple_action_activate_callback (GSimpleAction* action,
                                                                  GVariant* parameter,
                                                                  gpointer self)
{
	clocks_window_on_help_activate ((ClocksWindow*) self);
}

static void
_clocks_window_on_navigate_forward_gsimple_action_activate_callback (GSimpleAction* action,
                                                                     GVariant* parameter,
                                                                     gpointer self)
{
	clocks_window_on_navigate_forward ((ClocksWindow*) self);
}

static void
_clocks_window_on_navigate_backward_gsimple_action_activate_callback (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      gpointer self)
{
	clocks_window_on_navigate_backward ((ClocksWindow*) self);
}

static void
_clocks_window_on_about_activate_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self)
{
	clocks_window_on_about_activate ((ClocksWindow*) self);
}

static void
__lambda59_ (ClocksWindow* self,
             ClocksWorldFace* w,
             ClocksWorldItem* l)
{
	AdwViewStack* _tmp0_;
	ClocksWorldStandalone* _tmp1_;
	ClocksUtilsWallClock* _tmp2_;
	ClocksUtilsWallClock* _tmp3_;
	AdwNavigationView* _tmp4_;
	AdwNavigationPage* _tmp5_;
	g_return_if_fail (w != NULL);
	g_return_if_fail (l != NULL);
	_tmp0_ = self->priv->stack;
	adw_view_stack_set_visible_child (_tmp0_, (GtkWidget*) w);
	_tmp1_ = self->priv->world_standalone;
	clocks_world_standalone_set_location (_tmp1_, l);
	_tmp2_ = clocks_utils_wall_clock_get_default ();
	_tmp3_ = _tmp2_;
	clocks_utils_wall_clock_set_seconds_precision (_tmp3_, TRUE);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = self->priv->navigation_view;
	_tmp5_ = self->priv->world_subpage;
	adw_navigation_view_push (_tmp4_, _tmp5_);
}

static void
___lambda59__clocks_world_face_show_standalone (ClocksWorldFace* _sender,
                                                ClocksWorldItem* location,
                                                gpointer self)
{
	__lambda59_ ((ClocksWindow*) self, _sender, location);
}

static void
__lambda60_ (ClocksWindow* self)
{
	ClocksUtilsWallClock* _tmp0_;
	ClocksUtilsWallClock* _tmp1_;
	_tmp0_ = clocks_utils_wall_clock_get_default ();
	_tmp1_ = _tmp0_;
	clocks_utils_wall_clock_set_seconds_precision (_tmp1_, FALSE);
	_g_object_unref0 (_tmp1_);
}

static void
___lambda60__adw_navigation_page_hidden (AdwNavigationPage* _sender,
                                         gpointer self)
{
	__lambda60_ ((ClocksWindow*) self);
}

static void
__lambda61_ (ClocksWindow* self,
             ClocksAlarmFace* w,
             ClocksAlarmItem* a)
{
	AdwViewStack* _tmp0_;
	ClocksAlarmRingingPanel* _tmp1_;
	AdwNavigationView* _tmp2_;
	AdwNavigationPage* _tmp3_;
	g_return_if_fail (w != NULL);
	g_return_if_fail (a != NULL);
	clocks_window_close_standalone (self);
	_tmp0_ = self->priv->stack;
	adw_view_stack_set_visible_child (_tmp0_, (GtkWidget*) w);
	_tmp1_ = self->priv->alarm_ringing_panel;
	clocks_alarm_ringing_panel_set_alarm (_tmp1_, a);
	_tmp2_ = self->priv->navigation_view;
	_tmp3_ = self->priv->alarm_subpage;
	adw_navigation_view_push (_tmp2_, _tmp3_);
}

static void
___lambda61__clocks_alarm_face_ring (ClocksAlarmFace* _sender,
                                     ClocksAlarmItem* item,
                                     gpointer self)
{
	__lambda61_ ((ClocksWindow*) self, _sender, item);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda62_ (ClocksWindow* self,
             GParamSpec* w)
{
	AdwViewStackPage* stopwatch_stack_page = NULL;
	AdwViewStack* _tmp0_;
	ClocksStopwatchFace* _tmp1_;
	AdwViewStackPage* _tmp2_;
	AdwViewStackPage* _tmp3_;
	ClocksStopwatchFace* _tmp4_;
	ClocksStopwatchFaceState _tmp5_;
	ClocksStopwatchFaceState _tmp6_;
	g_return_if_fail (w != NULL);
	_tmp0_ = self->priv->stack;
	_tmp1_ = self->priv->stopwatch;
	_tmp2_ = adw_view_stack_get_page (_tmp0_, (GtkWidget*) _tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	stopwatch_stack_page = _tmp3_;
	_tmp4_ = self->priv->stopwatch;
	_tmp5_ = clocks_stopwatch_face_get_state (_tmp4_);
	_tmp6_ = _tmp5_;
	adw_view_stack_page_set_needs_attention (stopwatch_stack_page, _tmp6_ == CLOCKS_STOPWATCH_FACE_STATE_RUNNING);
	_g_object_unref0 (stopwatch_stack_page);
}

static void
___lambda62__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda62_ ((ClocksWindow*) self, pspec);
}

static void
__lambda63_ (ClocksWindow* self,
             ClocksTimerFace* w)
{
	AdwViewStack* _tmp0_;
	g_return_if_fail (w != NULL);
	clocks_window_close_standalone (self);
	_tmp0_ = self->priv->stack;
	adw_view_stack_set_visible_child (_tmp0_, (GtkWidget*) w);
}

static void
___lambda63__clocks_timer_face_ring (ClocksTimerFace* _sender,
                                     gpointer self)
{
	__lambda63_ ((ClocksWindow*) self, _sender);
}

static void
__lambda64_ (ClocksWindow* self,
             GParamSpec* w)
{
	AdwViewStackPage* timer_stack_page = NULL;
	AdwViewStack* _tmp0_;
	ClocksTimerFace* _tmp1_;
	AdwViewStackPage* _tmp2_;
	AdwViewStackPage* _tmp3_;
	ClocksTimerFace* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	g_return_if_fail (w != NULL);
	_tmp0_ = self->priv->stack;
	_tmp1_ = self->priv->timer;
	_tmp2_ = adw_view_stack_get_page (_tmp0_, (GtkWidget*) _tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	timer_stack_page = _tmp3_;
	_tmp4_ = self->priv->timer;
	_tmp5_ = clocks_timer_face_get_is_running (_tmp4_);
	_tmp6_ = _tmp5_;
	adw_view_stack_page_set_needs_attention (timer_stack_page, _tmp6_);
	_g_object_unref0 (timer_stack_page);
}

static void
___lambda64__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda64_ ((ClocksWindow*) self, pspec);
}

ClocksWindow*
clocks_window_construct (GType object_type,
                         ClocksApplication* app)
{
	ClocksWindow * self = NULL;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	AdwViewStack* _tmp2_;
	GSettings* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	ClocksWorldFace* _tmp6_;
	AdwNavigationPage* _tmp7_;
	ClocksAlarmFace* _tmp8_;
	ClocksUtilsWallClock* _tmp9_;
	ClocksUtilsWallClock* _tmp10_;
	ClocksStopwatchFace* _tmp11_;
	ClocksTimerFace* _tmp12_;
	ClocksTimerFace* _tmp13_;
	g_return_val_if_fail (app != NULL, NULL);
	self = (ClocksWindow*) g_object_new (object_type, "application", app, NULL);
	g_action_map_add_action_entries ((GActionMap*) self, CLOCKS_WINDOW_ACTION_ENTRIES, (gint) G_N_ELEMENTS (CLOCKS_WINDOW_ACTION_ENTRIES), self);
	_tmp0_ = g_settings_new ("org.gnome.clocks.state.window");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = self->priv->settings;
	g_settings_delay (_tmp1_);
	_tmp2_ = self->priv->stack;
	_tmp3_ = self->priv->settings;
	_tmp4_ = g_settings_get_string (_tmp3_, "panel-id");
	_tmp5_ = _tmp4_;
	adw_view_stack_set_visible_child_name (_tmp2_, _tmp5_);
	_g_free0 (_tmp5_);
	self->priv->inited = TRUE;
	clocks_window_pane_changed (self);
	clocks_window_load_window_state (self);
	_tmp6_ = self->priv->world;
	g_signal_connect_object (_tmp6_, "show-standalone", (GCallback) ___lambda59__clocks_world_face_show_standalone, self, 0);
	_tmp7_ = self->priv->world_subpage;
	g_signal_connect_object (_tmp7_, "hidden", (GCallback) ___lambda60__adw_navigation_page_hidden, self, 0);
	_tmp8_ = self->priv->alarm;
	g_signal_connect_object (_tmp8_, "ring", (GCallback) ___lambda61__clocks_alarm_face_ring, self, 0);
	_tmp9_ = clocks_utils_wall_clock_get_default ();
	_tmp10_ = _tmp9_;
	g_signal_emit_by_name (_tmp10_, "tick");
	_g_object_unref0 (_tmp10_);
	_tmp11_ = self->priv->stopwatch;
	g_signal_connect_object ((GObject*) _tmp11_, "notify::state", (GCallback) ___lambda62__g_object_notify, self, 0);
	_tmp12_ = self->priv->timer;
	g_signal_connect_object (_tmp12_, "ring", (GCallback) ___lambda63__clocks_timer_face_ring, self, 0);
	_tmp13_ = self->priv->timer;
	g_signal_connect_object ((GObject*) _tmp13_, "notify::is-running", (GCallback) ___lambda64__g_object_notify, self, 0);
	if (g_strcmp0 (PROFILE, "Devel") == 0) {
		gtk_widget_add_css_class ((GtkWidget*) self, "devel");
	}
	return self;
}

ClocksWindow*
clocks_window_new (ClocksApplication* app)
{
	return clocks_window_construct (CLOCKS_TYPE_WINDOW, app);
}

static void
clocks_window_on_new_activate (ClocksWindow* self)
{
	AdwViewStack* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->stack;
	_tmp1_ = adw_view_stack_get_visible_child (_tmp0_);
	_tmp2_ = _tmp1_;
	clocks_clock_activate_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, CLOCKS_TYPE_CLOCK, ClocksClock));
}

void
clocks_window_show_world (ClocksWindow* self)
{
	AdwViewStack* _tmp0_;
	ClocksWorldFace* _tmp1_;
	g_return_if_fail (self != NULL);
	clocks_window_close_standalone (self);
	_tmp0_ = self->priv->stack;
	_tmp1_ = self->priv->world;
	adw_view_stack_set_visible_child (_tmp0_, (GtkWidget*) _tmp1_);
}

void
clocks_window_add_world_location (ClocksWindow* self,
                                  GWeatherLocation* location)
{
	ClocksWorldFace* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (location != NULL);
	_tmp0_ = self->priv->world;
	clocks_world_face_add_location (_tmp0_, location);
}

static gboolean
clocks_window_real_close_request (GtkWindow* base)
{
	ClocksWindow * self;
	gboolean result;
	self = (ClocksWindow*) base;
	clocks_window_save_window_state (self);
	result = GTK_WINDOW_CLASS (clocks_window_parent_class)->close_request ((GtkWindow*) G_TYPE_CHECK_INSTANCE_CAST (self, adw_application_window_get_type (), AdwApplicationWindow));
	return result;
}

static void
clocks_window_load_window_state (ClocksWindow* self)
{
	gboolean window_maximized = FALSE;
	GSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	window_maximized = g_settings_get_boolean (_tmp0_, "maximized");
	if (window_maximized) {
		gtk_window_maximize ((GtkWindow*) self);
	} else {
		gint width = 0;
		gint height = 0;
		GSettings* _tmp1_;
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
		_tmp1_ = self->priv->settings;
		g_settings_get (_tmp1_, "size", "(ii)", &_tmp2_, &_tmp3_);
		width = _tmp2_;
		height = _tmp3_;
		gtk_window_set_default_size ((GtkWindow*) self, width, height);
	}
}

static void
clocks_window_save_window_state (ClocksWindow* self)
{
	gint width = 0;
	gint height = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	GSettings* _tmp4_;
	g_return_if_fail (self != NULL);
	width = 0;
	height = 0;
	gtk_window_get_default_size ((GtkWindow*) self, &_tmp0_, &_tmp1_);
	width = _tmp0_;
	height = _tmp1_;
	g_debug ("window.vala:176: Saving window geometry: %i × %i", width, height);
	_tmp2_ = self->priv->settings;
	g_settings_set (_tmp2_, "size", "(ii)", width, height);
	_tmp3_ = self->priv->settings;
	g_settings_set_boolean (_tmp3_, "maximized", gtk_window_is_maximized ((GtkWindow*) self));
	_tmp4_ = self->priv->settings;
	g_settings_apply (_tmp4_);
}

static void
clocks_window_on_window_active (ClocksWindow* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_object_get ((GtkWindow*) self, "is-active", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		GtkApplication* _tmp2_;
		GtkApplication* _tmp3_;
		_tmp2_ = gtk_window_get_application ((GtkWindow*) self);
		_tmp3_ = _tmp2_;
		clocks_application_withdraw_notifications (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, CLOCKS_TYPE_APPLICATION, ClocksApplication));
	}
}

static void
_clocks_window_on_window_active_g_object_notify (GObject* _sender,
                                                 GParamSpec* pspec,
                                                 gpointer self)
{
	clocks_window_on_window_active ((ClocksWindow*) self);
}

static gboolean
clocks_window_key_press_cb (ClocksWindow* self,
                            GtkEventControllerKey* controller,
                            guint keyval,
                            guint keycode,
                            GdkModifierType mod_state)
{
	gboolean handled = FALSE;
	GdkModifierType state = 0U;
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (controller != NULL, FALSE);
	handled = FALSE;
	state = mod_state & (GDK_CONTROL_MASK | GDK_ALT_MASK);
	if (keyval == GDK_KEY_Escape) {
		_tmp0_ = state == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		AdwNavigationView* _tmp1_;
		AdwNavigationPage* _tmp2_;
		AdwNavigationPage* _tmp3_;
		AdwNavigationPage* _tmp4_;
		_tmp1_ = self->priv->navigation_view;
		_tmp2_ = adw_navigation_view_get_visible_page (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = self->priv->main_page;
		if (_tmp3_ == _tmp4_) {
			AdwViewStack* _tmp5_;
			GtkWidget* _tmp6_;
			GtkWidget* _tmp7_;
			_tmp5_ = self->priv->stack;
			_tmp6_ = adw_view_stack_get_visible_child (_tmp5_);
			_tmp7_ = _tmp6_;
			handled = clocks_clock_escape_pressed (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, CLOCKS_TYPE_CLOCK, ClocksClock));
		} else {
			AdwNavigationView* _tmp8_;
			_tmp8_ = self->priv->navigation_view;
			adw_navigation_view_pop (_tmp8_);
		}
	}
	result = handled;
	return result;
}

static gboolean
_clocks_window_key_press_cb_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                  guint keyval,
                                                                  guint keycode,
                                                                  GdkModifierType state,
                                                                  gpointer self)
{
	gboolean result;
	result = clocks_window_key_press_cb ((ClocksWindow*) self, _sender, keyval, keycode, state);
	return result;
}

static void
__lambda58_ (ClocksWindow* self,
             GObject* obj,
             GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		g_app_info_launch_default_for_uri_finish (res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = _error_;
		_tmp1_ = _tmp0_->message;
		g_warning ("window.vala:221: Could not open help: %s", _tmp1_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda58__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda58_ ((ClocksWindow*) self, source_object, res);
	g_object_unref (self);
}

static void
clocks_window_on_help_activate (ClocksWindow* self)
{
	GdkDisplay* display = NULL;
	GAppLaunchContext* context = NULL;
	GdkDisplay* _tmp0_;
	GdkDisplay* _tmp1_;
	GdkDisplay* _tmp2_;
	GAppLaunchContext* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_root_get_display ((GtkRoot*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (display);
	display = _tmp1_;
	_tmp2_ = display;
	if (_tmp2_ != NULL) {
		GdkDisplay* _tmp3_;
		GdkAppLaunchContext* _tmp4_;
		_tmp3_ = display;
		_tmp4_ = gdk_display_get_app_launch_context (_tmp3_);
		_g_object_unref0 (context);
		context = (GAppLaunchContext*) _tmp4_;
	} else {
		_g_object_unref0 (context);
		context = NULL;
	}
	_tmp5_ = context;
	g_app_info_launch_default_for_uri_async ("help:gnome-clocks", _tmp5_, NULL, ___lambda58__gasync_ready_callback, g_object_ref (self));
	_g_object_unref0 (context);
	_g_object_unref0 (display);
}

static gchar**
_vala_array_dup5 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
clocks_window_on_about_activate (ClocksWindow* self)
{
	static const char COPYRIGHT[] = "\xc2\xa9 2011 Collabora Ltd.\n" "\xc2\xa9 2012-2013 Collabora Ltd., Seif Lotfy, Emily Gonyer, " "Eslam Mostafa, Paolo Borelli, Volker Sobek\n" "\xc2\xa9 2019-2020 Bilal Elmoussaoui &amp; Zander Brown et al";
	static const gchar* DEVELOPERS[16] = {"Alex Anthony", "Paolo Borelli", "Allan Day", "Piotr Drąg", "Emily Gonyer", "Evgeny Bobkin", "Maël Lavault", "Seif Lotfy", "William Jon McCann", "Eslam Mostafa", "Bastien Nocera", "Volker Sobek", "Jakub Steiner", "Bilal Elmoussaoui", "Zander Brown", NULL};
	AdwAboutDialog* about = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar* _tmp6_;
	gchar* _tmp7_;
	AdwAboutDialog* _tmp8_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (_ ("Clocks"));
	_tmp1_ = g_strdup (APP_ID);
	_tmp2_ = g_strdup (_ ("The GNOME Project"));
	_tmp3_ = g_strdup (VERSION);
	_tmp4_ = g_strdup (COPYRIGHT);
	_tmp5_ = _vala_array_dup5 (DEVELOPERS, G_N_ELEMENTS (DEVELOPERS));
	_tmp5__length1 = G_N_ELEMENTS (DEVELOPERS);
	_tmp6_ = g_strdup ("https://gitlab.gnome.org/GNOME/gnome-clocks/-/issues/");
	_tmp7_ = g_strdup (_ ("translator-credits"));
	_tmp8_ = (AdwAboutDialog*) adw_about_dialog_new ();
	adw_about_dialog_set_application_name (_tmp8_, _tmp0_);
	_g_free0 (_tmp0_);
	adw_about_dialog_set_application_icon (_tmp8_, _tmp1_);
	_g_free0 (_tmp1_);
	adw_about_dialog_set_developer_name (_tmp8_, _tmp2_);
	_g_free0 (_tmp2_);
	adw_about_dialog_set_version (_tmp8_, _tmp3_);
	_g_free0 (_tmp3_);
	adw_about_dialog_set_copyright (_tmp8_, _tmp4_);
	_g_free0 (_tmp4_);
	adw_about_dialog_set_developers (_tmp8_, _tmp5_);
	_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) g_free), NULL);
	adw_about_dialog_set_issue_url (_tmp8_, _tmp6_);
	_g_free0 (_tmp6_);
	adw_about_dialog_set_license_type (_tmp8_, GTK_LICENSE_GPL_2_0);
	adw_about_dialog_set_translator_credits (_tmp8_, _tmp7_);
	_g_free0 (_tmp7_);
	g_object_ref_sink (_tmp8_);
	about = _tmp8_;
	adw_dialog_present ((AdwDialog*) about, (GtkWidget*) self);
	_g_object_unref0 (about);
}

static void
clocks_window_pane_changed (ClocksWindow* self)
{
	ClocksClock* panel = NULL;
	AdwViewStack* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	ClocksClock* _tmp3_;
	AdwViewStack* _tmp4_;
	GBinding* _tmp9_;
	ClocksClock* _tmp12_;
	ClocksHeaderBar* _tmp13_;
	GBinding* _tmp14_;
	GBinding* _tmp15_;
	GBinding* _tmp16_;
	ClocksClock* _tmp19_;
	ClocksHeaderBar* _tmp20_;
	GBinding* _tmp21_;
	GBinding* _tmp22_;
	AdwViewStack* _tmp23_;
	GtkWidget* _tmp24_;
	GtkWidget* _tmp25_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->stack;
	_tmp1_ = adw_view_stack_get_visible_child (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, CLOCKS_TYPE_CLOCK, ClocksClock));
	panel = _tmp3_;
	_tmp4_ = self->priv->stack;
	if (gtk_widget_in_destruction ((GtkWidget*) _tmp4_)) {
		_g_object_unref0 (panel);
		return;
	}
	if (self->priv->inited) {
		GSettings* _tmp5_;
		ClocksClock* _tmp6_;
		ClocksPanelId _tmp7_;
		ClocksPanelId _tmp8_;
		_tmp5_ = self->priv->settings;
		_tmp6_ = panel;
		_tmp7_ = clocks_clock_get_panel_id (_tmp6_);
		_tmp8_ = _tmp7_;
		g_settings_set_enum (_tmp5_, "panel-id", (gint) _tmp8_);
	}
	_tmp9_ = self->priv->bind_button_mode;
	if (_tmp9_ != NULL) {
		GBinding* _tmp10_;
		GBinding* _tmp11_;
		_tmp10_ = self->priv->bind_button_mode;
		_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, G_TYPE_BINDING, GBinding));
		g_binding_unbind (_tmp11_);
	}
	_tmp12_ = panel;
	_tmp13_ = self->priv->header_bar;
	_tmp14_ = g_object_bind_property_with_closures ((GObject*) _tmp12_, "button-mode", (GObject*) _tmp13_, "button-mode", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp15_ = _g_object_ref0 (_tmp14_);
	_g_object_unref0 (self->priv->bind_button_mode);
	self->priv->bind_button_mode = _tmp15_;
	_tmp16_ = self->priv->bind_new_label;
	if (_tmp16_ != NULL) {
		GBinding* _tmp17_;
		GBinding* _tmp18_;
		_tmp17_ = self->priv->bind_new_label;
		_tmp18_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, G_TYPE_BINDING, GBinding));
		g_binding_unbind (_tmp18_);
	}
	_tmp19_ = panel;
	_tmp20_ = self->priv->header_bar;
	_tmp21_ = g_object_bind_property_with_closures ((GObject*) _tmp19_, "new-label", (GObject*) _tmp20_, "new-label", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp22_ = _g_object_ref0 (_tmp21_);
	_g_object_unref0 (self->priv->bind_new_label);
	self->priv->bind_new_label = _tmp22_;
	_tmp23_ = self->priv->stack;
	_tmp24_ = adw_view_stack_get_visible_child (_tmp23_);
	_tmp25_ = _tmp24_;
	gtk_widget_grab_focus (_tmp25_);
	_g_object_unref0 (panel);
}

static void
_clocks_window_pane_changed_g_object_notify (GObject* _sender,
                                             GParamSpec* pspec,
                                             gpointer self)
{
	clocks_window_pane_changed ((ClocksWindow*) self);
}

static void
clocks_window_visible_page_changed (ClocksWindow* self)
{
	AdwNavigationView* _tmp0_;
	AdwNavigationPage* _tmp1_;
	AdwNavigationPage* _tmp2_;
	AdwNavigationPage* _tmp3_;
	AdwNavigationView* _tmp11_;
	AdwNavigationPage* _tmp12_;
	AdwNavigationPage* _tmp13_;
	AdwNavigationPage* _tmp14_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->navigation_view;
	_tmp1_ = adw_navigation_view_get_visible_page (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->alarm_subpage;
	if (_tmp2_ == _tmp3_) {
		gtk_window_set_title ((GtkWindow*) self, _ ("Alarm"));
	} else {
		AdwNavigationView* _tmp4_;
		AdwNavigationPage* _tmp5_;
		AdwNavigationPage* _tmp6_;
		AdwNavigationPage* _tmp7_;
		_tmp4_ = self->priv->navigation_view;
		_tmp5_ = adw_navigation_view_get_visible_page (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = self->priv->world_subpage;
		if (_tmp6_ == _tmp7_) {
			ClocksWorldStandalone* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			_tmp8_ = self->priv->world_standalone;
			_tmp9_ = clocks_world_standalone_get_title (_tmp8_);
			_tmp10_ = _tmp9_;
			gtk_window_set_title ((GtkWindow*) self, _tmp10_);
		} else {
			gtk_window_set_title ((GtkWindow*) self, _ ("Clocks"));
		}
	}
	_tmp11_ = self->priv->navigation_view;
	_tmp12_ = adw_navigation_view_get_visible_page (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = self->priv->alarm_subpage;
	gtk_window_set_deletable ((GtkWindow*) self, _tmp13_ != _tmp14_);
}

static void
_clocks_window_visible_page_changed_g_object_notify (GObject* _sender,
                                                     GParamSpec* pspec,
                                                     gpointer self)
{
	clocks_window_visible_page_changed ((ClocksWindow*) self);
}

static void
clocks_window_alarm_dismissed (ClocksWindow* self)
{
	AdwNavigationView* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->navigation_view;
	adw_navigation_view_pop (_tmp0_);
}

static void
_clocks_window_alarm_dismissed_clocks_alarm_ringing_panel_dismiss (ClocksAlarmRingingPanel* _sender,
                                                                   gpointer self)
{
	clocks_window_alarm_dismissed ((ClocksWindow*) self);
}

static void
clocks_window_close_standalone (ClocksWindow* self)
{
	AdwNavigationView* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->navigation_view;
	adw_navigation_view_pop (_tmp0_);
}

static void
clocks_window_on_navigate_forward (ClocksWindow* self)
{
	gchar* current = NULL;
	AdwViewStack* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GQuark _tmp7_ = 0U;
	static GQuark _tmp6_label0 = 0;
	static GQuark _tmp6_label1 = 0;
	static GQuark _tmp6_label2 = 0;
	static GQuark _tmp6_label3 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->stack;
	_tmp1_ = adw_view_stack_get_visible_child_name (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	current = _tmp3_;
	_tmp4_ = current;
	_tmp5_ = _tmp4_;
	_tmp7_ = (NULL == _tmp5_) ? 0 : g_quark_from_string (_tmp5_);
	if (_tmp7_ == ((0 != _tmp6_label0) ? _tmp6_label0 : (_tmp6_label0 = g_quark_from_static_string ("world")))) {
		switch (0) {
			default:
			{
				AdwViewStack* _tmp8_;
				_tmp8_ = self->priv->stack;
				adw_view_stack_set_visible_child_name (_tmp8_, "alarm");
				break;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label1) ? _tmp6_label1 : (_tmp6_label1 = g_quark_from_static_string ("alarm")))) {
		switch (0) {
			default:
			{
				AdwViewStack* _tmp9_;
				_tmp9_ = self->priv->stack;
				adw_view_stack_set_visible_child_name (_tmp9_, "stopwatch");
				break;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label2) ? _tmp6_label2 : (_tmp6_label2 = g_quark_from_static_string ("stopwatch")))) {
		switch (0) {
			default:
			{
				AdwViewStack* _tmp10_;
				_tmp10_ = self->priv->stack;
				adw_view_stack_set_visible_child_name (_tmp10_, "timer");
				break;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label3) ? _tmp6_label3 : (_tmp6_label3 = g_quark_from_static_string ("timer")))) {
		switch (0) {
			default:
			{
				AdwViewStack* _tmp11_;
				_tmp11_ = self->priv->stack;
				adw_view_stack_set_visible_child_name (_tmp11_, "world");
				break;
			}
		}
	}
	_g_free0 (current);
}

static void
clocks_window_on_navigate_backward (ClocksWindow* self)
{
	gchar* current = NULL;
	AdwViewStack* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GQuark _tmp7_ = 0U;
	static GQuark _tmp6_label0 = 0;
	static GQuark _tmp6_label1 = 0;
	static GQuark _tmp6_label2 = 0;
	static GQuark _tmp6_label3 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->stack;
	_tmp1_ = adw_view_stack_get_visible_child_name (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	current = _tmp3_;
	_tmp4_ = current;
	_tmp5_ = _tmp4_;
	_tmp7_ = (NULL == _tmp5_) ? 0 : g_quark_from_string (_tmp5_);
	if (_tmp7_ == ((0 != _tmp6_label0) ? _tmp6_label0 : (_tmp6_label0 = g_quark_from_static_string ("world")))) {
		switch (0) {
			default:
			{
				AdwViewStack* _tmp8_;
				_tmp8_ = self->priv->stack;
				adw_view_stack_set_visible_child_name (_tmp8_, "timer");
				break;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label1) ? _tmp6_label1 : (_tmp6_label1 = g_quark_from_static_string ("alarm")))) {
		switch (0) {
			default:
			{
				AdwViewStack* _tmp9_;
				_tmp9_ = self->priv->stack;
				adw_view_stack_set_visible_child_name (_tmp9_, "world");
				break;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label2) ? _tmp6_label2 : (_tmp6_label2 = g_quark_from_static_string ("stopwatch")))) {
		switch (0) {
			default:
			{
				AdwViewStack* _tmp10_;
				_tmp10_ = self->priv->stack;
				adw_view_stack_set_visible_child_name (_tmp10_, "alarm");
				break;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label3) ? _tmp6_label3 : (_tmp6_label3 = g_quark_from_static_string ("timer")))) {
		switch (0) {
			default:
			{
				AdwViewStack* _tmp11_;
				_tmp11_ = self->priv->stack;
				adw_view_stack_set_visible_child_name (_tmp11_, "stopwatch");
				break;
			}
		}
	}
	_g_free0 (current);
}

static void
clocks_window_on_set_page (ClocksWindow* self,
                           const gchar* action_name,
                           GVariant* param)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (action_name != NULL);
	if (param != NULL) {
		gchar* page = NULL;
		const gchar* _tmp0_;
		gchar* _tmp1_;
		AdwViewStack* _tmp2_;
		const gchar* _tmp3_;
		_tmp0_ = g_variant_get_string (param, NULL);
		_tmp1_ = g_strdup (_tmp0_);
		page = _tmp1_;
		_tmp2_ = self->priv->stack;
		_tmp3_ = page;
		adw_view_stack_set_visible_child_name (_tmp2_, _tmp3_);
		_g_free0 (page);
	}
}

void
clocks_window_add_toast (ClocksWindow* self,
                         AdwToast* toast)
{
	AdwToastOverlay* _tmp0_;
	AdwToast* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (toast != NULL);
	_tmp0_ = self->priv->toast_overlay;
	_tmp1_ = _g_object_ref0 (toast);
	adw_toast_overlay_add_toast (_tmp0_, _tmp1_);
}

static GObject *
clocks_window_constructor (GType type,
                           guint n_construct_properties,
                           GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ClocksWindow * self;
	parent_class = G_OBJECT_CLASS (clocks_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_TYPE_WINDOW, ClocksWindow);
	gtk_widget_class_install_action (G_TYPE_INSTANCE_GET_CLASS (self, gtk_widget_get_type (), GtkWidgetClass), "set-page", "s", (GtkWidgetActionActivateFunc) clocks_window_on_set_page);
	gtk_widget_class_add_binding_action (G_TYPE_INSTANCE_GET_CLASS (self, gtk_widget_get_type (), GtkWidgetClass), GDK_KEY_1, GDK_ALT_MASK, "set-page", "s", "world", NULL);
	gtk_widget_class_add_binding_action (G_TYPE_INSTANCE_GET_CLASS (self, gtk_widget_get_type (), GtkWidgetClass), GDK_KEY_2, GDK_ALT_MASK, "set-page", "s", "alarm", NULL);
	gtk_widget_class_add_binding_action (G_TYPE_INSTANCE_GET_CLASS (self, gtk_widget_get_type (), GtkWidgetClass), GDK_KEY_3, GDK_ALT_MASK, "set-page", "s", "stopwatch", NULL);
	gtk_widget_class_add_binding_action (G_TYPE_INSTANCE_GET_CLASS (self, gtk_widget_get_type (), GtkWidgetClass), GDK_KEY_4, GDK_ALT_MASK, "set-page", "s", "timer", NULL);
	return obj;
}

static void
clocks_window_class_init (ClocksWindowClass * klass,
                          gpointer klass_data)
{
	clocks_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ClocksWindow_private_offset);
	((GtkWindowClass *) klass)->close_request = (gboolean (*) (GtkWindow*)) clocks_window_real_close_request;
	G_OBJECT_CLASS (klass)->constructor = clocks_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = clocks_window_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/clocks/ui/window.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "header_bar", FALSE, ClocksWindow_private_offset + G_STRUCT_OFFSET (ClocksWindowPrivate, header_bar));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "toast_overlay", FALSE, ClocksWindow_private_offset + G_STRUCT_OFFSET (ClocksWindowPrivate, toast_overlay));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "navigation_view", FALSE, ClocksWindow_private_offset + G_STRUCT_OFFSET (ClocksWindowPrivate, navigation_view));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "main_page", FALSE, ClocksWindow_private_offset + G_STRUCT_OFFSET (ClocksWindowPrivate, main_page));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "world_subpage", FALSE, ClocksWindow_private_offset + G_STRUCT_OFFSET (ClocksWindowPrivate, world_subpage));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "alarm_subpage", FALSE, ClocksWindow_private_offset + G_STRUCT_OFFSET (ClocksWindowPrivate, alarm_subpage));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "stack", FALSE, ClocksWindow_private_offset + G_STRUCT_OFFSET (ClocksWindowPrivate, stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "world", FALSE, ClocksWindow_private_offset + G_STRUCT_OFFSET (ClocksWindowPrivate, world));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "alarm", FALSE, ClocksWindow_private_offset + G_STRUCT_OFFSET (ClocksWindowPrivate, alarm));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "world_standalone", FALSE, ClocksWindow_private_offset + G_STRUCT_OFFSET (ClocksWindowPrivate, world_standalone));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "alarm_ringing_panel", FALSE, ClocksWindow_private_offset + G_STRUCT_OFFSET (ClocksWindowPrivate, alarm_ringing_panel));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "stopwatch", FALSE, ClocksWindow_private_offset + G_STRUCT_OFFSET (ClocksWindowPrivate, stopwatch));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "timer", FALSE, ClocksWindow_private_offset + G_STRUCT_OFFSET (ClocksWindowPrivate, timer));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_window_active", G_CALLBACK(_clocks_window_on_window_active_g_object_notify));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "key_press_cb", G_CALLBACK(_clocks_window_key_press_cb_gtk_event_controller_key_key_pressed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "pane_changed", G_CALLBACK(_clocks_window_pane_changed_g_object_notify));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "visible_page_changed", G_CALLBACK(_clocks_window_visible_page_changed_g_object_notify));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "alarm_dismissed", G_CALLBACK(_clocks_window_alarm_dismissed_clocks_alarm_ringing_panel_dismiss));
}

static void
clocks_window_instance_init (ClocksWindow * self,
                             gpointer klass)
{
	self->priv = clocks_window_get_instance_private (self);
	self->priv->bind_button_mode = NULL;
	self->priv->bind_new_label = NULL;
	self->priv->inited = FALSE;
	g_type_ensure (CLOCKS_TYPE_HEADER_BAR);
	g_type_ensure (CLOCKS_WORLD_TYPE_FACE);
	g_type_ensure (CLOCKS_ALARM_TYPE_FACE);
	g_type_ensure (CLOCKS_WORLD_TYPE_STANDALONE);
	g_type_ensure (CLOCKS_ALARM_TYPE_RINGING_PANEL);
	g_type_ensure (CLOCKS_STOPWATCH_TYPE_FACE);
	g_type_ensure (CLOCKS_TIMER_TYPE_FACE);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
clocks_window_finalize (GObject * obj)
{
	ClocksWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_TYPE_WINDOW, ClocksWindow);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->bind_button_mode);
	_g_object_unref0 (self->priv->bind_new_label);
	G_OBJECT_CLASS (clocks_window_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
clocks_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ClocksWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clocks_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClocksWindow), 0, (GInstanceInitFunc) clocks_window_instance_init, NULL };
	GType clocks_window_type_id;
	clocks_window_type_id = g_type_register_static (adw_application_window_get_type (), "ClocksWindow", &g_define_type_info, 0);
	ClocksWindow_private_offset = g_type_add_instance_private (clocks_window_type_id, sizeof (ClocksWindowPrivate));
	return clocks_window_type_id;
}

GType
clocks_window_get_type (void)
{
	static gsize clocks_window_type_id__once = 0;
	if (g_once_init_enter (&clocks_window_type_id__once)) {
		GType clocks_window_type_id;
		clocks_window_type_id = clocks_window_get_type_once ();
		g_once_init_leave (&clocks_window_type_id__once, clocks_window_type_id);
	}
	return clocks_window_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

