/* alarm-item.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from alarm-item.vala, do not modify */

/*
 * Copyright (C) 2013  Paolo Borelli <pborelli@gnome.org>
 * Copyright (C) 2020  Zander Brown <zbrown@gnome.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <glib-object.h>
#include <glib.h>
#include <string.h>
#include <stdlib.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <adwaita.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CLOCKS_ALARM_TYPE_ALARM_TIME (clocks_alarm_alarm_time_get_type ())
typedef struct _ClocksAlarmAlarmTime ClocksAlarmAlarmTime;

#define CLOCKS_TYPE_CONTENT_ITEM (clocks_content_item_get_type ())
#define CLOCKS_CONTENT_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_CONTENT_ITEM, ClocksContentItem))
#define CLOCKS_IS_CONTENT_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_CONTENT_ITEM))
#define CLOCKS_CONTENT_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CLOCKS_TYPE_CONTENT_ITEM, ClocksContentItemIface))

typedef struct _ClocksContentItem ClocksContentItem;
typedef struct _ClocksContentItemIface ClocksContentItemIface;

#define CLOCKS_ALARM_TYPE_ITEM (clocks_alarm_item_get_type ())
#define CLOCKS_ALARM_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_ALARM_TYPE_ITEM, ClocksAlarmItem))
#define CLOCKS_ALARM_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_ALARM_TYPE_ITEM, ClocksAlarmItemClass))
#define CLOCKS_ALARM_IS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_ALARM_TYPE_ITEM))
#define CLOCKS_ALARM_IS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_ALARM_TYPE_ITEM))
#define CLOCKS_ALARM_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_ALARM_TYPE_ITEM, ClocksAlarmItemClass))

typedef struct _ClocksAlarmItem ClocksAlarmItem;
typedef struct _ClocksAlarmItemClass ClocksAlarmItemClass;
typedef struct _ClocksAlarmItemPrivate ClocksAlarmItemPrivate;

#define CLOCKS_UTILS_TYPE_WEEKDAYS (clocks_utils_weekdays_get_type ())
#define CLOCKS_UTILS_WEEKDAYS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_UTILS_TYPE_WEEKDAYS, ClocksUtilsWeekdays))
#define CLOCKS_UTILS_WEEKDAYS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_UTILS_TYPE_WEEKDAYS, ClocksUtilsWeekdaysClass))
#define CLOCKS_UTILS_IS_WEEKDAYS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_UTILS_TYPE_WEEKDAYS))
#define CLOCKS_UTILS_IS_WEEKDAYS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_UTILS_TYPE_WEEKDAYS))
#define CLOCKS_UTILS_WEEKDAYS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_UTILS_TYPE_WEEKDAYS, ClocksUtilsWeekdaysClass))

typedef struct _ClocksUtilsWeekdays ClocksUtilsWeekdays;
typedef struct _ClocksUtilsWeekdaysClass ClocksUtilsWeekdaysClass;
typedef enum  {
	CLOCKS_ALARM_ITEM_STATE_READY,
	CLOCKS_ALARM_ITEM_STATE_RINGING,
	CLOCKS_ALARM_ITEM_STATE_SNOOZING,
	CLOCKS_ALARM_ITEM_STATE_MISSED
} ClocksAlarmItemState;

#define CLOCKS_ALARM_ITEM_TYPE_STATE (clocks_alarm_item_state_get_type ())

#define CLOCKS_UTILS_TYPE_BELL (clocks_utils_bell_get_type ())
#define CLOCKS_UTILS_BELL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_UTILS_TYPE_BELL, ClocksUtilsBell))
#define CLOCKS_UTILS_BELL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_UTILS_TYPE_BELL, ClocksUtilsBellClass))
#define CLOCKS_UTILS_IS_BELL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_UTILS_TYPE_BELL))
#define CLOCKS_UTILS_IS_BELL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_UTILS_TYPE_BELL))
#define CLOCKS_UTILS_BELL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_UTILS_TYPE_BELL, ClocksUtilsBellClass))

typedef struct _ClocksUtilsBell ClocksUtilsBell;
typedef struct _ClocksUtilsBellClass ClocksUtilsBellClass;
enum  {
	CLOCKS_ALARM_ITEM_0_PROPERTY,
	CLOCKS_ALARM_ITEM_ID_PROPERTY,
	CLOCKS_ALARM_ITEM_SNOOZE_MINUTES_PROPERTY,
	CLOCKS_ALARM_ITEM_RING_MINUTES_PROPERTY,
	CLOCKS_ALARM_ITEM_SOUND_FILE_PROPERTY,
	CLOCKS_ALARM_ITEM_NAME_PROPERTY,
	CLOCKS_ALARM_ITEM_TIME_PROPERTY,
	CLOCKS_ALARM_ITEM_RING_TIME_PROPERTY,
	CLOCKS_ALARM_ITEM_DAYS_PROPERTY,
	CLOCKS_ALARM_ITEM_STATE_PROPERTY,
	CLOCKS_ALARM_ITEM_TIME_LABEL_PROPERTY,
	CLOCKS_ALARM_ITEM_RING_TIME_LABEL_PROPERTY,
	CLOCKS_ALARM_ITEM_DAYS_LABEL_PROPERTY,
	CLOCKS_ALARM_ITEM_ACTIVE_PROPERTY,
	CLOCKS_ALARM_ITEM_NUM_PROPERTIES
};
static GParamSpec* clocks_alarm_item_properties[CLOCKS_ALARM_ITEM_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _clocks_utils_weekdays_unref0(var) ((var == NULL) ? NULL : (var = (clocks_utils_weekdays_unref (var), NULL)))

#define CLOCKS_UTILS_TYPE_WALL_CLOCK (clocks_utils_wall_clock_get_type ())
#define CLOCKS_UTILS_WALL_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_UTILS_TYPE_WALL_CLOCK, ClocksUtilsWallClock))
#define CLOCKS_UTILS_WALL_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_UTILS_TYPE_WALL_CLOCK, ClocksUtilsWallClockClass))
#define CLOCKS_UTILS_IS_WALL_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_UTILS_TYPE_WALL_CLOCK))
#define CLOCKS_UTILS_IS_WALL_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_UTILS_TYPE_WALL_CLOCK))
#define CLOCKS_UTILS_WALL_CLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_UTILS_TYPE_WALL_CLOCK, ClocksUtilsWallClockClass))

typedef struct _ClocksUtilsWallClock ClocksUtilsWallClock;
typedef struct _ClocksUtilsWallClockClass ClocksUtilsWallClockClass;
typedef enum  {
	CLOCKS_UTILS_WEEKDAYS_DAY_MON = 0,
	CLOCKS_UTILS_WEEKDAYS_DAY_TUE,
	CLOCKS_UTILS_WEEKDAYS_DAY_WED,
	CLOCKS_UTILS_WEEKDAYS_DAY_THU,
	CLOCKS_UTILS_WEEKDAYS_DAY_FRI,
	CLOCKS_UTILS_WEEKDAYS_DAY_SAT,
	CLOCKS_UTILS_WEEKDAYS_DAY_SUN
} ClocksUtilsWeekdaysDay;

#define CLOCKS_UTILS_WEEKDAYS_TYPE_DAY (clocks_utils_weekdays_day_get_type ())

#define CLOCKS_TYPE_APPLICATION (clocks_application_get_type ())
#define CLOCKS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_APPLICATION, ClocksApplication))
#define CLOCKS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_TYPE_APPLICATION, ClocksApplicationClass))
#define CLOCKS_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_APPLICATION))
#define CLOCKS_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_TYPE_APPLICATION))
#define CLOCKS_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_TYPE_APPLICATION, ClocksApplicationClass))

typedef struct _ClocksApplication ClocksApplication;
typedef struct _ClocksApplicationClass ClocksApplicationClass;
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))

struct _ClocksAlarmAlarmTime {
	gint hour;
	gint minute;
};

struct _ClocksContentItemIface {
	GTypeInterface parent_iface;
	void (*serialize) (ClocksContentItem* self, GVariantBuilder* builder);
	const gchar* (*get_name) (ClocksContentItem* self);
	void (*set_name) (ClocksContentItem* self, const gchar* value);
};

struct _ClocksAlarmItem {
	GObject parent_instance;
	ClocksAlarmItemPrivate * priv;
};

struct _ClocksAlarmItemClass {
	GObjectClass parent_class;
};

struct _ClocksAlarmItemPrivate {
	gchar* _id;
	gint _snooze_minutes;
	gint _ring_minutes;
	GFile* _sound_file;
	ClocksAlarmAlarmTime _time;
	GDateTime* _ring_time;
	ClocksUtilsWeekdays* _days;
	ClocksAlarmItemState _state;
	gchar* _name;
	ClocksUtilsBell* bell;
	GNotification* notification;
};

static gint ClocksAlarmItem_private_offset;
static gpointer clocks_alarm_item_parent_class = NULL;
static ClocksContentItemIface * clocks_alarm_item_clocks_content_item_parent_iface = NULL;

VALA_EXTERN GType clocks_alarm_alarm_time_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ClocksAlarmAlarmTime* clocks_alarm_alarm_time_dup (const ClocksAlarmAlarmTime* self);
VALA_EXTERN void clocks_alarm_alarm_time_free (ClocksAlarmAlarmTime* self);
VALA_EXTERN gboolean clocks_alarm_alarm_time_is_eq (ClocksAlarmAlarmTime *self,
                                        ClocksAlarmAlarmTime* other);
VALA_EXTERN gint clocks_alarm_alarm_time_compare (ClocksAlarmAlarmTime *self,
                                      ClocksAlarmAlarmTime* other);
VALA_EXTERN GType clocks_content_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksContentItem, g_object_unref)
VALA_EXTERN GType clocks_alarm_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksAlarmItem, g_object_unref)
VALA_EXTERN gpointer clocks_utils_weekdays_ref (gpointer instance);
VALA_EXTERN void clocks_utils_weekdays_unref (gpointer instance);
VALA_EXTERN GParamSpec* clocks_utils_param_spec_weekdays (const gchar* name,
                                              const gchar* nick,
                                              const gchar* blurb,
                                              GType object_type,
                                              GParamFlags flags);
VALA_EXTERN void clocks_utils_value_set_weekdays (GValue* value,
                                      gpointer v_object);
VALA_EXTERN void clocks_utils_value_take_weekdays (GValue* value,
                                       gpointer v_object);
VALA_EXTERN gpointer clocks_utils_value_get_weekdays (const GValue* value);
VALA_EXTERN GType clocks_utils_weekdays_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksUtilsWeekdays, clocks_utils_weekdays_unref)
VALA_EXTERN GType clocks_alarm_item_state_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType clocks_utils_bell_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksUtilsBell, g_object_unref)
VALA_EXTERN GFile* clocks_alarm_sound_model_build_default_file (void);
VALA_EXTERN ClocksAlarmItem* clocks_alarm_item_new (const gchar* id);
VALA_EXTERN ClocksAlarmItem* clocks_alarm_item_construct (GType object_type,
                                              const gchar* id);
static void clocks_alarm_item_setup_bell (ClocksAlarmItem* self);
VALA_EXTERN GFile* clocks_alarm_item_get_sound_file (ClocksAlarmItem* self);
VALA_EXTERN ClocksUtilsBell* clocks_utils_bell_new (GFile* sound);
VALA_EXTERN ClocksUtilsBell* clocks_utils_bell_construct (GType object_type,
                                              GFile* sound);
VALA_EXTERN const gchar* clocks_content_item_get_name (ClocksContentItem* self);
VALA_EXTERN const gchar* clocks_alarm_item_get_id (ClocksAlarmItem* self);
VALA_EXTERN void clocks_alarm_item_reset (ClocksAlarmItem* self);
static GDateTime* clocks_alarm_item_next_ring_time (ClocksAlarmItem* self);
static void clocks_alarm_item_set_ring_time (ClocksAlarmItem* self,
                                      GDateTime* value);
static void clocks_alarm_item_set_state (ClocksAlarmItem* self,
                                  ClocksAlarmItemState value);
VALA_EXTERN GType clocks_utils_wall_clock_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksUtilsWallClock, g_object_unref)
VALA_EXTERN ClocksUtilsWallClock* clocks_utils_wall_clock_get_default (void);
VALA_EXTERN GDateTime* clocks_utils_wall_clock_get_date_time (ClocksUtilsWallClock* self);
VALA_EXTERN GTimeZone* clocks_utils_wall_clock_get_timezone (ClocksUtilsWallClock* self);
VALA_EXTERN void clocks_alarm_item_get_time (ClocksAlarmItem* self,
                                 ClocksAlarmAlarmTime * result);
VALA_EXTERN ClocksUtilsWeekdays* clocks_alarm_item_get_days (ClocksAlarmItem* self);
VALA_EXTERN gboolean clocks_utils_weekdays_get_empty (ClocksUtilsWeekdays* self);
VALA_EXTERN GType clocks_utils_weekdays_day_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gboolean clocks_utils_weekdays_get (ClocksUtilsWeekdays* self,
                                    ClocksUtilsWeekdaysDay d);
static void clocks_alarm_item_ring (ClocksAlarmItem* self);
VALA_EXTERN GType clocks_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksApplication, g_object_unref)
VALA_EXTERN void clocks_application_send_notification (ClocksApplication* self,
                                           const gchar* notification_id,
                                           GNotification* notification);
VALA_EXTERN void clocks_utils_bell_ring (ClocksUtilsBell* self);
VALA_EXTERN void clocks_alarm_item_snooze (ClocksAlarmItem* self);
VALA_EXTERN GDateTime* clocks_alarm_item_get_ring_time (ClocksAlarmItem* self);
VALA_EXTERN gint clocks_alarm_item_get_snooze_minutes (ClocksAlarmItem* self);
VALA_EXTERN void clocks_alarm_item_stop (ClocksAlarmItem* self,
                             gboolean missed);
static gboolean clocks_alarm_item_compare_with_item (ClocksAlarmItem* self,
                                              ClocksAlarmItem* i);
VALA_EXTERN gboolean clocks_alarm_item_get_active (ClocksAlarmItem* self);
VALA_EXTERN gboolean clocks_alarm_item_check_duplicate_alarm (ClocksAlarmItem* self,
                                                  GList* alarms);
VALA_EXTERN gboolean clocks_alarm_item_tick (ClocksAlarmItem* self);
VALA_EXTERN ClocksAlarmItemState clocks_alarm_item_get_state (ClocksAlarmItem* self);
VALA_EXTERN gint clocks_alarm_item_get_ring_minutes (ClocksAlarmItem* self);
static void clocks_alarm_item_real_serialize (ClocksContentItem* base,
                                       GVariantBuilder* builder);
VALA_EXTERN GVariant* clocks_utils_weekdays_serialize (ClocksUtilsWeekdays* self);
VALA_EXTERN ClocksContentItem* clocks_alarm_item_deserialize (GVariant* alarm_variant);
static gchar* _variant_get3 (GVariant* value);
static gchar* _variant_get4 (GVariant* value);
static gboolean _variant_get5 (GVariant* value);
static gint32 _variant_get6 (GVariant* value);
static gint32 _variant_get7 (GVariant* value);
static gchar* _variant_get8 (GVariant* value);
VALA_EXTERN ClocksUtilsWeekdays* clocks_utils_weekdays_deserialize (GVariant* days_variant);
static gint32 _variant_get9 (GVariant* value);
static gint32 _variant_get10 (GVariant* value);
static gchar* _variant_get11 (GVariant* value);
VALA_EXTERN void clocks_content_item_set_name (ClocksContentItem* self,
                                   const gchar* value);
VALA_EXTERN void clocks_alarm_item_set_time (ClocksAlarmItem* self,
                                 ClocksAlarmAlarmTime * value);
VALA_EXTERN void clocks_alarm_item_set_active (ClocksAlarmItem* self,
                                   gboolean value);
VALA_EXTERN void clocks_alarm_item_set_days (ClocksAlarmItem* self,
                                 ClocksUtilsWeekdays* value);
VALA_EXTERN void clocks_alarm_item_set_ring_minutes (ClocksAlarmItem* self,
                                         gint value);
VALA_EXTERN void clocks_alarm_item_set_snooze_minutes (ClocksAlarmItem* self,
                                           gint value);
VALA_EXTERN void clocks_alarm_item_set_sound_file (ClocksAlarmItem* self,
                                       GFile* value);
VALA_EXTERN gint clocks_alarm_item_compare (ClocksAlarmItem* a,
                                ClocksAlarmItem* b);
VALA_EXTERN void clocks_alarm_item_set_id (ClocksAlarmItem* self,
                               const gchar* value);
static gboolean _clocks_alarm_alarm_time_equal (const ClocksAlarmAlarmTime * s1,
                                         const ClocksAlarmAlarmTime * s2);
VALA_EXTERN void clocks_utils_bell_stop (ClocksUtilsBell* self);
VALA_EXTERN gchar* clocks_alarm_item_get_time_label (ClocksAlarmItem* self);
VALA_EXTERN gchar* clocks_utils_wall_clock_format_time (ClocksUtilsWallClock* self,
                                            GDateTime* date_time,
                                            gboolean seconds);
VALA_EXTERN gchar* clocks_alarm_item_get_ring_time_label (ClocksAlarmItem* self);
VALA_EXTERN gchar* clocks_alarm_item_get_days_label (ClocksAlarmItem* self);
VALA_EXTERN gchar* clocks_utils_weekdays_get_label (ClocksUtilsWeekdays* self);
VALA_EXTERN void clocks_content_item_serialize (ClocksContentItem* self,
                                    GVariantBuilder* builder);
static void clocks_alarm_item_finalize (GObject * obj);
static GType clocks_alarm_item_get_type_once (void);
static void _vala_clocks_alarm_item_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_clocks_alarm_item_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);

gboolean
clocks_alarm_alarm_time_is_eq (ClocksAlarmAlarmTime *self,
                               ClocksAlarmAlarmTime* other)
{
	gboolean _tmp0_ = FALSE;
	ClocksAlarmAlarmTime _tmp1_;
	gboolean result;
	g_return_val_if_fail (other != NULL, FALSE);
	_tmp1_ = *other;
	if ((*self).hour == _tmp1_.hour) {
		ClocksAlarmAlarmTime _tmp2_;
		_tmp2_ = *other;
		_tmp0_ = (*self).minute == _tmp2_.minute;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gint
clocks_alarm_alarm_time_compare (ClocksAlarmAlarmTime *self,
                                 ClocksAlarmAlarmTime* other)
{
	gint this_minutes = 0;
	gint other_minutes = 0;
	ClocksAlarmAlarmTime _tmp0_;
	ClocksAlarmAlarmTime _tmp1_;
	gint result;
	g_return_val_if_fail (other != NULL, 0);
	this_minutes = ((*self).hour * 60) + (*self).minute;
	_tmp0_ = *other;
	_tmp1_ = *other;
	other_minutes = (_tmp0_.hour * 60) + _tmp1_.minute;
	if (this_minutes < other_minutes) {
		result = -1;
		return result;
	}
	if (this_minutes > other_minutes) {
		result = 1;
		return result;
	}
	result = 0;
	return result;
}

ClocksAlarmAlarmTime*
clocks_alarm_alarm_time_dup (const ClocksAlarmAlarmTime* self)
{
	ClocksAlarmAlarmTime* dup;
	dup = g_new0 (ClocksAlarmAlarmTime, 1);
	memcpy (dup, self, sizeof (ClocksAlarmAlarmTime));
	return dup;
}

void
clocks_alarm_alarm_time_free (ClocksAlarmAlarmTime* self)
{
	g_free (self);
}

 G_GNUC_NO_INLINE static GType
clocks_alarm_alarm_time_get_type_once (void)
{
	GType clocks_alarm_alarm_time_type_id;
	clocks_alarm_alarm_time_type_id = g_boxed_type_register_static ("ClocksAlarmAlarmTime", (GBoxedCopyFunc) clocks_alarm_alarm_time_dup, (GBoxedFreeFunc) clocks_alarm_alarm_time_free);
	return clocks_alarm_alarm_time_type_id;
}

GType
clocks_alarm_alarm_time_get_type (void)
{
	static gsize clocks_alarm_alarm_time_type_id__once = 0;
	if (g_once_init_enter (&clocks_alarm_alarm_time_type_id__once)) {
		GType clocks_alarm_alarm_time_type_id;
		clocks_alarm_alarm_time_type_id = clocks_alarm_alarm_time_get_type_once ();
		g_once_init_leave (&clocks_alarm_alarm_time_type_id__once, clocks_alarm_alarm_time_type_id);
	}
	return clocks_alarm_alarm_time_type_id__once;
}

static inline gpointer
clocks_alarm_item_get_instance_private (ClocksAlarmItem* self)
{
	return G_STRUCT_MEMBER_P (self, ClocksAlarmItem_private_offset);
}

 G_GNUC_NO_INLINE static GType
clocks_alarm_item_state_get_type_once (void)
{
	static const GEnumValue values[] = {{CLOCKS_ALARM_ITEM_STATE_READY, "CLOCKS_ALARM_ITEM_STATE_READY", "ready"}, {CLOCKS_ALARM_ITEM_STATE_RINGING, "CLOCKS_ALARM_ITEM_STATE_RINGING", "ringing"}, {CLOCKS_ALARM_ITEM_STATE_SNOOZING, "CLOCKS_ALARM_ITEM_STATE_SNOOZING", "snoozing"}, {CLOCKS_ALARM_ITEM_STATE_MISSED, "CLOCKS_ALARM_ITEM_STATE_MISSED", "missed"}, {0, NULL, NULL}};
	GType clocks_alarm_item_state_type_id;
	clocks_alarm_item_state_type_id = g_enum_register_static ("ClocksAlarmItemState", values);
	return clocks_alarm_item_state_type_id;
}

GType
clocks_alarm_item_state_get_type (void)
{
	static gsize clocks_alarm_item_state_type_id__once = 0;
	if (g_once_init_enter (&clocks_alarm_item_state_type_id__once)) {
		GType clocks_alarm_item_state_type_id;
		clocks_alarm_item_state_type_id = clocks_alarm_item_state_get_type_once ();
		g_once_init_leave (&clocks_alarm_item_state_type_id__once, clocks_alarm_item_state_type_id);
	}
	return clocks_alarm_item_state_type_id__once;
}

ClocksAlarmItem*
clocks_alarm_item_construct (GType object_type,
                             const gchar* id)
{
	ClocksAlarmItem * self = NULL;
	gchar* _tmp0_ = NULL;
	gchar* guid = NULL;
	gchar* _tmp3_;
	if (id != NULL) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ((const gchar*) id);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp1_;
	} else {
		gchar* _tmp2_;
		_tmp2_ = g_dbus_generate_guid ();
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp2_;
	}
	_tmp3_ = g_strdup (_tmp0_);
	guid = _tmp3_;
	self = (ClocksAlarmItem*) g_object_new (object_type, "id", guid, NULL);
	_g_free0 (guid);
	_g_free0 (_tmp0_);
	return self;
}

ClocksAlarmItem*
clocks_alarm_item_new (const gchar* id)
{
	return clocks_alarm_item_construct (CLOCKS_ALARM_TYPE_ITEM, id);
}

static void
clocks_alarm_item_setup_bell (ClocksAlarmItem* self)
{
	GFile* _tmp0_;
	ClocksUtilsBell* _tmp1_;
	GNotification* _tmp2_;
	GNotification* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GNotification* _tmp6_;
	GNotification* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GNotification* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_sound_file;
	_tmp1_ = clocks_utils_bell_new (_tmp0_);
	_g_object_unref0 (self->priv->bell);
	self->priv->bell = _tmp1_;
	_tmp2_ = g_notification_new (_ ("Alarm"));
	_g_object_unref0 (self->priv->notification);
	self->priv->notification = _tmp2_;
	_tmp3_ = self->priv->notification;
	_tmp4_ = clocks_content_item_get_name ((ClocksContentItem*) self);
	_tmp5_ = _tmp4_;
	g_notification_set_body (_tmp3_, _tmp5_);
	_tmp6_ = self->priv->notification;
	g_notification_set_priority (_tmp6_, G_NOTIFICATION_PRIORITY_HIGH);
	_tmp7_ = self->priv->notification;
	_tmp8_ = self->priv->_id;
	_tmp9_ = g_strconcat ("app.stop-alarm::", _tmp8_, NULL);
	_tmp10_ = _tmp9_;
	g_notification_add_button (_tmp7_, _ ("Stop"), _tmp10_);
	_g_free0 (_tmp10_);
	_tmp11_ = self->priv->notification;
	_tmp12_ = self->priv->_id;
	_tmp13_ = g_strconcat ("app.snooze-alarm::", _tmp12_, NULL);
	_tmp14_ = _tmp13_;
	g_notification_add_button (_tmp11_, _ ("Snooze"), _tmp14_);
	_g_free0 (_tmp14_);
}

void
clocks_alarm_item_reset (ClocksAlarmItem* self)
{
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = clocks_alarm_item_next_ring_time (self);
	_tmp1_ = _tmp0_;
	clocks_alarm_item_set_ring_time (self, _tmp1_);
	_g_date_time_unref0 (_tmp1_);
	clocks_alarm_item_set_state (self, CLOCKS_ALARM_ITEM_STATE_READY);
}

static gpointer
_g_date_time_ref0 (gpointer self)
{
	return self ? g_date_time_ref (self) : NULL;
}

static GDateTime*
clocks_alarm_item_next_ring_time (ClocksAlarmItem* self)
{
	ClocksUtilsWallClock* wallclock = NULL;
	ClocksUtilsWallClock* _tmp0_;
	GDateTime* now = NULL;
	ClocksUtilsWallClock* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	GDateTime* _tmp4_;
	GDateTime* dt = NULL;
	ClocksUtilsWallClock* _tmp5_;
	GTimeZone* _tmp6_;
	GTimeZone* _tmp7_;
	GDateTime* _tmp8_;
	GDateTime* _tmp9_;
	GDateTime* _tmp10_;
	ClocksAlarmAlarmTime _tmp11_;
	ClocksAlarmAlarmTime _tmp12_;
	GDateTime* _tmp13_;
	gboolean _tmp14_ = FALSE;
	ClocksUtilsWeekdays* _tmp15_;
	ClocksUtilsWeekdays* _tmp16_;
	GDateTime* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = clocks_utils_wall_clock_get_default ();
	wallclock = _tmp0_;
	_tmp1_ = wallclock;
	_tmp2_ = clocks_utils_wall_clock_get_date_time (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _g_date_time_ref0 (_tmp3_);
	now = _tmp4_;
	_tmp5_ = wallclock;
	_tmp6_ = clocks_utils_wall_clock_get_timezone (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = now;
	_tmp9_ = now;
	_tmp10_ = now;
	_tmp11_ = self->priv->_time;
	_tmp12_ = self->priv->_time;
	_tmp13_ = g_date_time_new (_tmp7_, g_date_time_get_year (_tmp8_), g_date_time_get_month (_tmp9_), g_date_time_get_day_of_month (_tmp10_), _tmp11_.hour, _tmp12_.minute, (gdouble) 0);
	dt = _tmp13_;
	_tmp15_ = clocks_alarm_item_get_days (self);
	_tmp16_ = _tmp15_;
	if (_tmp16_ == NULL) {
		_tmp14_ = TRUE;
	} else {
		ClocksUtilsWeekdays* _tmp17_;
		ClocksUtilsWeekdays* _tmp18_;
		gboolean _tmp19_;
		gboolean _tmp20_;
		_tmp17_ = clocks_alarm_item_get_days (self);
		_tmp18_ = _tmp17_;
		_tmp19_ = clocks_utils_weekdays_get_empty (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, CLOCKS_UTILS_TYPE_WEEKDAYS, ClocksUtilsWeekdays));
		_tmp20_ = _tmp19_;
		_tmp14_ = _tmp20_;
	}
	if (_tmp14_) {
		GDateTime* _tmp21_;
		GDateTime* _tmp22_;
		_tmp21_ = dt;
		_tmp22_ = now;
		if (g_date_time_compare (_tmp21_, _tmp22_) <= 0) {
			GDateTime* _tmp23_;
			GDateTime* _tmp24_;
			_tmp23_ = dt;
			_tmp24_ = g_date_time_add_days (_tmp23_, 1);
			_g_date_time_unref0 (dt);
			dt = _tmp24_;
		}
	} else {
		while (TRUE) {
			gboolean _tmp25_ = FALSE;
			GDateTime* _tmp26_;
			GDateTime* _tmp27_;
			GDateTime* _tmp31_;
			GDateTime* _tmp32_;
			_tmp26_ = dt;
			_tmp27_ = now;
			if (g_date_time_compare (_tmp26_, _tmp27_) <= 0) {
				_tmp25_ = TRUE;
			} else {
				ClocksUtilsWeekdays* _tmp28_;
				ClocksUtilsWeekdays* _tmp29_;
				GDateTime* _tmp30_;
				_tmp28_ = clocks_alarm_item_get_days (self);
				_tmp29_ = _tmp28_;
				_tmp30_ = dt;
				_tmp25_ = !clocks_utils_weekdays_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, CLOCKS_UTILS_TYPE_WEEKDAYS, ClocksUtilsWeekdays), (ClocksUtilsWeekdaysDay) (g_date_time_get_day_of_week (_tmp30_) - 1));
			}
			if (!_tmp25_) {
				break;
			}
			_tmp31_ = dt;
			_tmp32_ = g_date_time_add_days (_tmp31_, 1);
			_g_date_time_unref0 (dt);
			dt = _tmp32_;
		}
	}
	result = dt;
	_g_date_time_unref0 (now);
	_g_object_unref0 (wallclock);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
clocks_alarm_item_ring (ClocksAlarmItem* self)
{
	ClocksApplication* app = NULL;
	GApplication* _tmp0_;
	ClocksApplication* _tmp1_;
	GNotification* _tmp2_;
	ClocksUtilsBell* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_application_get_default ();
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, CLOCKS_TYPE_APPLICATION, ClocksApplication));
	app = _tmp1_;
	_tmp2_ = self->priv->notification;
	clocks_application_send_notification (app, "alarm-clock-elapsed", _tmp2_);
	_tmp3_ = self->priv->bell;
	clocks_utils_bell_ring (_tmp3_);
	_g_object_unref0 (app);
}

void
clocks_alarm_item_snooze (ClocksAlarmItem* self)
{
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	gint _tmp2_;
	GDateTime* _tmp3_;
	GDateTime* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = clocks_alarm_item_get_ring_time (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->_snooze_minutes;
	_tmp3_ = g_date_time_add_minutes (_tmp1_, _tmp2_);
	_tmp4_ = _tmp3_;
	clocks_alarm_item_set_ring_time (self, _tmp4_);
	_g_date_time_unref0 (_tmp4_);
	clocks_alarm_item_set_state (self, CLOCKS_ALARM_ITEM_STATE_SNOOZING);
}

void
clocks_alarm_item_stop (ClocksAlarmItem* self,
                        gboolean missed)
{
	gboolean _tmp0_ = FALSE;
	ClocksUtilsWeekdays* _tmp1_;
	ClocksUtilsWeekdays* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp1_ = clocks_alarm_item_get_days (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ClocksUtilsWeekdays* _tmp3_;
		ClocksUtilsWeekdays* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp3_ = clocks_alarm_item_get_days (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = clocks_utils_weekdays_get_empty (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, CLOCKS_UTILS_TYPE_WEEKDAYS, ClocksUtilsWeekdays));
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_;
	}
	if (_tmp0_) {
		clocks_alarm_item_set_ring_time (self, NULL);
	} else {
		GDateTime* _tmp7_;
		GDateTime* _tmp8_;
		_tmp7_ = clocks_alarm_item_next_ring_time (self);
		_tmp8_ = _tmp7_;
		clocks_alarm_item_set_ring_time (self, _tmp8_);
		_g_date_time_unref0 (_tmp8_);
	}
	if (missed) {
		clocks_alarm_item_set_state (self, CLOCKS_ALARM_ITEM_STATE_MISSED);
	} else {
		clocks_alarm_item_set_state (self, CLOCKS_ALARM_ITEM_STATE_READY);
	}
}

static gboolean
clocks_alarm_item_compare_with_item (ClocksAlarmItem* self,
                                     ClocksAlarmItem* i)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ClocksAlarmAlarmTime _tmp2_;
	ClocksAlarmAlarmTime _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (i != NULL, FALSE);
	_tmp2_ = self->priv->_time;
	_tmp3_ = i->priv->_time;
	if (clocks_alarm_alarm_time_is_eq (&_tmp2_, &_tmp3_)) {
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp4_ = clocks_alarm_item_get_active (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = _tmp5_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp6_ = clocks_alarm_item_get_active (i);
		_tmp7_ = _tmp6_;
		_tmp0_ = _tmp7_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gboolean
clocks_alarm_item_check_duplicate_alarm (ClocksAlarmItem* self,
                                         GList* alarms)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		GList* item_collection = NULL;
		GList* item_it = NULL;
		item_collection = alarms;
		for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
			ClocksAlarmItem* _tmp0_;
			ClocksAlarmItem* item = NULL;
			_tmp0_ = _g_object_ref0 ((ClocksAlarmItem*) item_it->data);
			item = _tmp0_;
			{
				ClocksAlarmItem* _tmp1_;
				_tmp1_ = item;
				if (clocks_alarm_item_compare_with_item (self, _tmp1_)) {
					result = TRUE;
					_g_object_unref0 (item);
					return result;
				}
				_g_object_unref0 (item);
			}
		}
	}
	result = FALSE;
	return result;
}

gboolean
clocks_alarm_item_tick (ClocksAlarmItem* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	ClocksAlarmItemState last_state = 0;
	ClocksAlarmItemState _tmp2_;
	ClocksAlarmItemState _tmp3_;
	ClocksUtilsWallClock* wallclock = NULL;
	ClocksUtilsWallClock* _tmp4_;
	GDateTime* now = NULL;
	ClocksUtilsWallClock* _tmp5_;
	GDateTime* _tmp6_;
	GDateTime* _tmp7_;
	GDateTime* _tmp8_;
	GDateTime* ring_end_time = NULL;
	GDateTime* _tmp9_;
	GDateTime* _tmp10_;
	gint _tmp11_;
	GDateTime* _tmp12_;
	GDateTime* _tmp13_;
	GDateTime* _tmp14_;
	ClocksAlarmItemState _tmp21_;
	ClocksAlarmItemState _tmp22_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = clocks_alarm_item_get_active (self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = clocks_alarm_item_get_state (self);
	_tmp3_ = _tmp2_;
	last_state = _tmp3_;
	_tmp4_ = clocks_utils_wall_clock_get_default ();
	wallclock = _tmp4_;
	_tmp5_ = wallclock;
	_tmp6_ = clocks_utils_wall_clock_get_date_time (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _g_date_time_ref0 (_tmp7_);
	now = _tmp8_;
	_tmp9_ = clocks_alarm_item_get_ring_time (self);
	_tmp10_ = _tmp9_;
	_tmp11_ = self->priv->_ring_minutes;
	_tmp12_ = g_date_time_add_minutes (_tmp10_, _tmp11_);
	ring_end_time = _tmp12_;
	_tmp13_ = now;
	_tmp14_ = ring_end_time;
	if (g_date_time_compare (_tmp13_, _tmp14_) > 0) {
		clocks_alarm_item_stop (self, TRUE);
	} else {
		gboolean _tmp15_ = FALSE;
		ClocksAlarmItemState _tmp16_;
		ClocksAlarmItemState _tmp17_;
		_tmp16_ = clocks_alarm_item_get_state (self);
		_tmp17_ = _tmp16_;
		if (_tmp17_ != CLOCKS_ALARM_ITEM_STATE_RINGING) {
			GDateTime* _tmp18_;
			GDateTime* _tmp19_;
			GDateTime* _tmp20_;
			_tmp18_ = now;
			_tmp19_ = clocks_alarm_item_get_ring_time (self);
			_tmp20_ = _tmp19_;
			_tmp15_ = g_date_time_compare (_tmp18_, _tmp20_) > 0;
		} else {
			_tmp15_ = FALSE;
		}
		if (_tmp15_) {
			clocks_alarm_item_set_state (self, CLOCKS_ALARM_ITEM_STATE_RINGING);
		}
	}
	_tmp21_ = clocks_alarm_item_get_state (self);
	_tmp22_ = _tmp21_;
	result = _tmp22_ != last_state;
	_g_date_time_unref0 (ring_end_time);
	_g_date_time_unref0 (now);
	_g_object_unref0 (wallclock);
	return result;
}

static void
clocks_alarm_item_real_serialize (ClocksContentItem* base,
                                  GVariantBuilder* builder)
{
	ClocksAlarmItem * self;
	GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GVariant* _tmp4_;
	GVariant* _tmp5_;
	const gchar* _tmp6_;
	GVariant* _tmp7_;
	GVariant* _tmp8_;
	ClocksAlarmAlarmTime _tmp9_;
	GVariant* _tmp10_;
	GVariant* _tmp11_;
	ClocksAlarmAlarmTime _tmp12_;
	GVariant* _tmp13_;
	GVariant* _tmp14_;
	GDateTime* _tmp15_;
	GDateTime* _tmp16_;
	ClocksUtilsWeekdays* _tmp23_;
	ClocksUtilsWeekdays* _tmp24_;
	GVariant* _tmp25_;
	GVariant* _tmp26_;
	gint _tmp27_;
	GVariant* _tmp28_;
	GVariant* _tmp29_;
	gint _tmp30_;
	GVariant* _tmp31_;
	GVariant* _tmp32_;
	GFile* _tmp33_;
	gchar* _tmp34_;
	GVariant* _tmp35_;
	GVariant* _tmp36_;
	self = (ClocksAlarmItem*) base;
	g_return_if_fail (builder != NULL);
	_tmp0_ = g_variant_type_new ("a{sv}");
	_tmp1_ = _tmp0_;
	g_variant_builder_open (builder, _tmp1_);
	_g_variant_type_free0 (_tmp1_);
	_tmp2_ = clocks_content_item_get_name ((ClocksContentItem*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_variant_new_string ((const gchar*) _tmp3_);
	g_variant_ref_sink (_tmp4_);
	_tmp5_ = _tmp4_;
	g_variant_builder_add (builder, "{sv}", "name", _tmp5_, NULL);
	_g_variant_unref0 (_tmp5_);
	_tmp6_ = self->priv->_id;
	_tmp7_ = g_variant_new_string (_tmp6_);
	g_variant_ref_sink (_tmp7_);
	_tmp8_ = _tmp7_;
	g_variant_builder_add (builder, "{sv}", "id", _tmp8_, NULL);
	_g_variant_unref0 (_tmp8_);
	_tmp9_ = self->priv->_time;
	_tmp10_ = g_variant_new_int32 ((gint32) _tmp9_.hour);
	g_variant_ref_sink (_tmp10_);
	_tmp11_ = _tmp10_;
	g_variant_builder_add (builder, "{sv}", "hour", _tmp11_, NULL);
	_g_variant_unref0 (_tmp11_);
	_tmp12_ = self->priv->_time;
	_tmp13_ = g_variant_new_int32 ((gint32) _tmp12_.minute);
	g_variant_ref_sink (_tmp13_);
	_tmp14_ = _tmp13_;
	g_variant_builder_add (builder, "{sv}", "minute", _tmp14_, NULL);
	_g_variant_unref0 (_tmp14_);
	_tmp15_ = clocks_alarm_item_get_ring_time (self);
	_tmp16_ = _tmp15_;
	if (_tmp16_ != NULL) {
		GDateTime* _tmp17_;
		GDateTime* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		GVariant* _tmp21_;
		GVariant* _tmp22_;
		_tmp17_ = clocks_alarm_item_get_ring_time (self);
		_tmp18_ = _tmp17_;
		_tmp19_ = g_date_time_format_iso8601 ((GDateTime*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = g_variant_new_string (_tmp20_);
		g_variant_ref_sink (_tmp21_);
		_tmp22_ = _tmp21_;
		g_variant_builder_add (builder, "{sv}", "ring_time", _tmp22_, NULL);
		_g_variant_unref0 (_tmp22_);
		_g_free0 (_tmp20_);
	}
	_tmp23_ = clocks_alarm_item_get_days (self);
	_tmp24_ = _tmp23_;
	_tmp25_ = clocks_utils_weekdays_serialize (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, CLOCKS_UTILS_TYPE_WEEKDAYS, ClocksUtilsWeekdays));
	_tmp26_ = _tmp25_;
	g_variant_builder_add (builder, "{sv}", "days", _tmp26_, NULL);
	_g_variant_unref0 (_tmp26_);
	_tmp27_ = self->priv->_snooze_minutes;
	_tmp28_ = g_variant_new_int32 ((gint32) _tmp27_);
	g_variant_ref_sink (_tmp28_);
	_tmp29_ = _tmp28_;
	g_variant_builder_add (builder, "{sv}", "snooze_minutes", _tmp29_, NULL);
	_g_variant_unref0 (_tmp29_);
	_tmp30_ = self->priv->_ring_minutes;
	_tmp31_ = g_variant_new_int32 ((gint32) _tmp30_);
	g_variant_ref_sink (_tmp31_);
	_tmp32_ = _tmp31_;
	g_variant_builder_add (builder, "{sv}", "ring_minutes", _tmp32_, NULL);
	_g_variant_unref0 (_tmp32_);
	_tmp33_ = self->priv->_sound_file;
	_tmp34_ = g_file_get_uri (_tmp33_);
	_tmp35_ = g_variant_new_take_string (_tmp34_);
	g_variant_ref_sink (_tmp35_);
	_tmp36_ = _tmp35_;
	g_variant_builder_add (builder, "{sv}", "sound_uri", _tmp36_, NULL);
	_g_variant_unref0 (_tmp36_);
	g_variant_builder_close (builder);
}

static gchar*
_variant_get3 (GVariant* value)
{
	return g_variant_dup_string (value, NULL);
}

static gchar*
_variant_get4 (GVariant* value)
{
	return g_variant_dup_string (value, NULL);
}

static gboolean
_variant_get5 (GVariant* value)
{
	return g_variant_get_boolean (value);
}

static gint32
_variant_get6 (GVariant* value)
{
	return g_variant_get_int32 (value);
}

static gint32
_variant_get7 (GVariant* value)
{
	return g_variant_get_int32 (value);
}

static gchar*
_variant_get8 (GVariant* value)
{
	return g_variant_dup_string (value, NULL);
}

static gint32
_variant_get9 (GVariant* value)
{
	return g_variant_get_int32 (value);
}

static gint32
_variant_get10 (GVariant* value)
{
	return g_variant_get_int32 (value);
}

static gchar*
_variant_get11 (GVariant* value)
{
	return g_variant_dup_string (value, NULL);
}

ClocksContentItem*
clocks_alarm_item_deserialize (GVariant* alarm_variant)
{
	gchar* key = NULL;
	GVariant* val = NULL;
	gchar* name = NULL;
	gchar* id = NULL;
	gboolean active = FALSE;
	gint hour = 0;
	gint minute = 0;
	GDateTime* ring_time = NULL;
	gint snooze_minutes = 0;
	gint ring_minutes = 0;
	GFile* sound_file = NULL;
	GFile* _tmp0_;
	ClocksUtilsWeekdays* days = NULL;
	GVariantIter* iter = NULL;
	GVariantIter* _tmp1_;
	gboolean _tmp40_ = FALSE;
	ClocksContentItem* result;
	g_return_val_if_fail (alarm_variant != NULL, NULL);
	name = NULL;
	id = NULL;
	active = FALSE;
	hour = -1;
	minute = -1;
	ring_time = NULL;
	snooze_minutes = 10;
	ring_minutes = 5;
	_tmp0_ = clocks_alarm_sound_model_build_default_file ();
	sound_file = _tmp0_;
	days = NULL;
	_tmp1_ = g_variant_iter_new (alarm_variant);
	iter = _tmp1_;
	while (TRUE) {
		GVariantIter* _tmp2_;
		gchar* _tmp3_ = NULL;
		GVariant* _tmp4_ = NULL;
		gboolean _tmp5_;
		const gchar* _tmp6_;
		_tmp2_ = iter;
		_tmp5_ = g_variant_iter_next (_tmp2_, "{sv}", &_tmp3_, &_tmp4_, NULL);
		_g_free0 (key);
		key = _tmp3_;
		_g_variant_unref0 (val);
		val = _tmp4_;
		if (!_tmp5_) {
			break;
		}
		_tmp6_ = key;
		if (g_strcmp0 (_tmp6_, "name") == 0) {
			GVariant* _tmp7_;
			gchar* _tmp8_;
			_tmp7_ = val;
			_tmp8_ = _variant_get3 (_tmp7_);
			_g_free0 (name);
			name = _tmp8_;
		} else {
			const gchar* _tmp9_;
			_tmp9_ = key;
			if (g_strcmp0 (_tmp9_, "id") == 0) {
				GVariant* _tmp10_;
				gchar* _tmp11_;
				_tmp10_ = val;
				_tmp11_ = _variant_get4 (_tmp10_);
				_g_free0 (id);
				id = _tmp11_;
			} else {
				const gchar* _tmp12_;
				_tmp12_ = key;
				if (g_strcmp0 (_tmp12_, "active") == 0) {
					GVariant* _tmp13_;
					gboolean _tmp14_;
					_tmp13_ = val;
					_tmp14_ = _variant_get5 (_tmp13_);
					active = _tmp14_;
				} else {
					const gchar* _tmp15_;
					_tmp15_ = key;
					if (g_strcmp0 (_tmp15_, "hour") == 0) {
						GVariant* _tmp16_;
						gint32 _tmp17_;
						_tmp16_ = val;
						_tmp17_ = _variant_get6 (_tmp16_);
						hour = (gint) _tmp17_;
					} else {
						const gchar* _tmp18_;
						_tmp18_ = key;
						if (g_strcmp0 (_tmp18_, "minute") == 0) {
							GVariant* _tmp19_;
							gint32 _tmp20_;
							_tmp19_ = val;
							_tmp20_ = _variant_get7 (_tmp19_);
							minute = (gint) _tmp20_;
						} else {
							const gchar* _tmp21_;
							_tmp21_ = key;
							if (g_strcmp0 (_tmp21_, "ring_time") == 0) {
								GVariant* _tmp22_;
								gchar* _tmp23_;
								gchar* _tmp24_;
								GDateTime* _tmp25_;
								_tmp22_ = val;
								_tmp23_ = _variant_get8 (_tmp22_);
								_tmp24_ = _tmp23_;
								_tmp25_ = g_date_time_new_from_iso8601 (_tmp24_, NULL);
								_g_date_time_unref0 (ring_time);
								ring_time = _tmp25_;
								_g_free0 (_tmp24_);
							} else {
								const gchar* _tmp26_;
								_tmp26_ = key;
								if (g_strcmp0 (_tmp26_, "days") == 0) {
									GVariant* _tmp27_;
									ClocksUtilsWeekdays* _tmp28_;
									_tmp27_ = val;
									_tmp28_ = clocks_utils_weekdays_deserialize (_tmp27_);
									_clocks_utils_weekdays_unref0 (days);
									days = _tmp28_;
								} else {
									const gchar* _tmp29_;
									_tmp29_ = key;
									if (g_strcmp0 (_tmp29_, "snooze_minutes") == 0) {
										GVariant* _tmp30_;
										gint32 _tmp31_;
										_tmp30_ = val;
										_tmp31_ = _variant_get9 (_tmp30_);
										snooze_minutes = (gint) _tmp31_;
									} else {
										const gchar* _tmp32_;
										_tmp32_ = key;
										if (g_strcmp0 (_tmp32_, "ring_minutes") == 0) {
											GVariant* _tmp33_;
											gint32 _tmp34_;
											_tmp33_ = val;
											_tmp34_ = _variant_get10 (_tmp33_);
											ring_minutes = (gint) _tmp34_;
										} else {
											const gchar* _tmp35_;
											_tmp35_ = key;
											if (g_strcmp0 (_tmp35_, "sound_uri") == 0) {
												GVariant* _tmp36_;
												gchar* _tmp37_;
												gchar* _tmp38_;
												GFile* _tmp39_;
												_tmp36_ = val;
												_tmp37_ = _variant_get11 (_tmp36_);
												_tmp38_ = _tmp37_;
												_tmp39_ = g_file_new_for_uri (_tmp38_);
												_g_object_unref0 (sound_file);
												sound_file = _tmp39_;
												_g_free0 (_tmp38_);
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	if (hour >= 0) {
		_tmp40_ = minute >= 0;
	} else {
		_tmp40_ = FALSE;
	}
	if (_tmp40_) {
		ClocksAlarmItem* alarm = NULL;
		const gchar* _tmp41_;
		ClocksAlarmItem* _tmp42_;
		ClocksAlarmItem* _tmp43_;
		const gchar* _tmp44_;
		ClocksAlarmItem* _tmp45_;
		ClocksAlarmAlarmTime _tmp46_ = {0};
		gboolean _tmp47_ = FALSE;
		ClocksAlarmItem* _tmp52_;
		ClocksUtilsWeekdays* _tmp53_;
		ClocksAlarmItem* _tmp54_;
		ClocksAlarmItem* _tmp55_;
		ClocksAlarmItem* _tmp56_;
		GFile* _tmp57_;
		_tmp41_ = id;
		_tmp42_ = clocks_alarm_item_new (_tmp41_);
		alarm = _tmp42_;
		_tmp43_ = alarm;
		_tmp44_ = name;
		clocks_content_item_set_name ((ClocksContentItem*) _tmp43_, _tmp44_);
		_tmp45_ = alarm;
		_tmp46_.hour = hour;
		_tmp46_.minute = minute;
		clocks_alarm_item_set_time (_tmp45_, &_tmp46_);
		if (active) {
			GDateTime* _tmp48_;
			_tmp48_ = ring_time;
			_tmp47_ = _tmp48_ == NULL;
		} else {
			_tmp47_ = FALSE;
		}
		if (_tmp47_) {
			ClocksAlarmItem* _tmp49_;
			_tmp49_ = alarm;
			clocks_alarm_item_set_active (_tmp49_, TRUE);
		} else {
			ClocksAlarmItem* _tmp50_;
			GDateTime* _tmp51_;
			_tmp50_ = alarm;
			_tmp51_ = ring_time;
			clocks_alarm_item_set_ring_time (_tmp50_, _tmp51_);
		}
		_tmp52_ = alarm;
		_tmp53_ = days;
		clocks_alarm_item_set_days (_tmp52_, _tmp53_);
		_tmp54_ = alarm;
		clocks_alarm_item_set_ring_minutes (_tmp54_, ring_minutes);
		_tmp55_ = alarm;
		clocks_alarm_item_set_snooze_minutes (_tmp55_, snooze_minutes);
		_tmp56_ = alarm;
		_tmp57_ = sound_file;
		clocks_alarm_item_set_sound_file (_tmp56_, _tmp57_);
		result = (ClocksContentItem*) alarm;
		_g_variant_iter_free0 (iter);
		_clocks_utils_weekdays_unref0 (days);
		_g_object_unref0 (sound_file);
		_g_date_time_unref0 (ring_time);
		_g_free0 (id);
		_g_free0 (name);
		_g_variant_unref0 (val);
		_g_free0 (key);
		return result;
	} else {
		const gchar* _tmp58_ = NULL;
		const gchar* _tmp59_;
		_tmp59_ = name;
		if (_tmp59_ != NULL) {
			const gchar* _tmp60_;
			_tmp60_ = name;
			_tmp58_ = (const gchar*) _tmp60_;
		} else {
			_tmp58_ = "[unnamed]";
		}
		g_warning ("alarm-item.vala:367: Invalid alarm %s", _tmp58_);
	}
	result = NULL;
	_g_variant_iter_free0 (iter);
	_clocks_utils_weekdays_unref0 (days);
	_g_object_unref0 (sound_file);
	_g_date_time_unref0 (ring_time);
	_g_free0 (id);
	_g_free0 (name);
	_g_variant_unref0 (val);
	_g_free0 (key);
	return result;
}

gint
clocks_alarm_item_compare (ClocksAlarmItem* a,
                           ClocksAlarmItem* b)
{
	ClocksAlarmAlarmTime _tmp0_;
	ClocksAlarmAlarmTime _tmp1_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = a->priv->_time;
	_tmp1_ = b->priv->_time;
	result = clocks_alarm_alarm_time_compare (&_tmp0_, &_tmp1_);
	return result;
}

const gchar*
clocks_alarm_item_get_id (ClocksAlarmItem* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}

void
clocks_alarm_item_set_id (ClocksAlarmItem* self,
                          const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = clocks_alarm_item_get_id (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_id);
		self->priv->_id = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, clocks_alarm_item_properties[CLOCKS_ALARM_ITEM_ID_PROPERTY]);
	}
}

gint
clocks_alarm_item_get_snooze_minutes (ClocksAlarmItem* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_snooze_minutes;
	return result;
}

void
clocks_alarm_item_set_snooze_minutes (ClocksAlarmItem* self,
                                      gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = clocks_alarm_item_get_snooze_minutes (self);
	if (old_value != value) {
		self->priv->_snooze_minutes = value;
		g_object_notify_by_pspec ((GObject *) self, clocks_alarm_item_properties[CLOCKS_ALARM_ITEM_SNOOZE_MINUTES_PROPERTY]);
	}
}

gint
clocks_alarm_item_get_ring_minutes (ClocksAlarmItem* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_ring_minutes;
	return result;
}

void
clocks_alarm_item_set_ring_minutes (ClocksAlarmItem* self,
                                    gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = clocks_alarm_item_get_ring_minutes (self);
	if (old_value != value) {
		self->priv->_ring_minutes = value;
		g_object_notify_by_pspec ((GObject *) self, clocks_alarm_item_properties[CLOCKS_ALARM_ITEM_RING_MINUTES_PROPERTY]);
	}
}

GFile*
clocks_alarm_item_get_sound_file (ClocksAlarmItem* self)
{
	GFile* result;
	GFile* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_sound_file;
	result = _tmp0_;
	return result;
}

void
clocks_alarm_item_set_sound_file (ClocksAlarmItem* self,
                                  GFile* value)
{
	GFile* old_value;
	g_return_if_fail (self != NULL);
	old_value = clocks_alarm_item_get_sound_file (self);
	if (old_value != value) {
		GFile* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_sound_file);
		self->priv->_sound_file = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, clocks_alarm_item_properties[CLOCKS_ALARM_ITEM_SOUND_FILE_PROPERTY]);
	}
}

static const gchar*
clocks_alarm_item_real_get_name (ClocksContentItem* base)
{
	const gchar* result;
	ClocksAlarmItem* self;
	const gchar* _tmp0_;
	self = (ClocksAlarmItem*) base;
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

static void
clocks_alarm_item_real_set_name (ClocksContentItem* base,
                                 const gchar* value)
{
	ClocksAlarmItem* self;
	gchar* _tmp0_;
	self = (ClocksAlarmItem*) base;
	_tmp0_ = g_strdup ((const gchar*) value);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp0_;
	clocks_alarm_item_setup_bell (self);
	g_object_notify_by_pspec ((GObject *) self, clocks_alarm_item_properties[CLOCKS_ALARM_ITEM_NAME_PROPERTY]);
}

void
clocks_alarm_item_get_time (ClocksAlarmItem* self,
                            ClocksAlarmAlarmTime * result)
{
	ClocksAlarmAlarmTime _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_time;
	*result = _tmp0_;
	return;
}

static gboolean
_clocks_alarm_alarm_time_equal (const ClocksAlarmAlarmTime * s1,
                                const ClocksAlarmAlarmTime * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	if (s1->hour != s2->hour) {
		return FALSE;
	}
	if (s1->minute != s2->minute) {
		return FALSE;
	}
	return TRUE;
}

void
clocks_alarm_item_set_time (ClocksAlarmItem* self,
                            ClocksAlarmAlarmTime * value)
{
	ClocksAlarmAlarmTime old_value;
	g_return_if_fail (self != NULL);
	clocks_alarm_item_get_time (self, &old_value);
	if (_clocks_alarm_alarm_time_equal (value, &old_value) != TRUE) {
		ClocksAlarmAlarmTime _tmp0_;
		_tmp0_ = *value;
		self->priv->_time = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, clocks_alarm_item_properties[CLOCKS_ALARM_ITEM_TIME_PROPERTY]);
	}
}

GDateTime*
clocks_alarm_item_get_ring_time (ClocksAlarmItem* self)
{
	GDateTime* result;
	GDateTime* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_ring_time;
	result = _tmp0_;
	return result;
}

static void
clocks_alarm_item_set_ring_time (ClocksAlarmItem* self,
                                 GDateTime* value)
{
	GDateTime* _tmp0_;
	gboolean prev_active = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GDateTime* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_ring_time;
	if (value == _tmp0_) {
		return;
	}
	_tmp1_ = clocks_alarm_item_get_active (self);
	_tmp2_ = _tmp1_;
	prev_active = _tmp2_;
	_tmp3_ = _g_date_time_ref0 (value);
	_g_date_time_unref0 (self->priv->_ring_time);
	self->priv->_ring_time = _tmp3_;
	_tmp4_ = clocks_alarm_item_get_active (self);
	_tmp5_ = _tmp4_;
	if (prev_active != _tmp5_) {
		g_object_notify ((GObject*) self, "active");
	}
	g_object_notify ((GObject*) self, "ring-time");
}

ClocksUtilsWeekdays*
clocks_alarm_item_get_days (ClocksAlarmItem* self)
{
	ClocksUtilsWeekdays* result;
	ClocksUtilsWeekdays* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_days;
	result = _tmp0_;
	return result;
}

static gpointer
_clocks_utils_weekdays_ref0 (gpointer self)
{
	return self ? clocks_utils_weekdays_ref (self) : NULL;
}

void
clocks_alarm_item_set_days (ClocksAlarmItem* self,
                            ClocksUtilsWeekdays* value)
{
	ClocksUtilsWeekdays* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _clocks_utils_weekdays_ref0 (value);
	_clocks_utils_weekdays_unref0 (self->priv->_days);
	self->priv->_days = _tmp0_;
	g_object_notify ((GObject*) self, "days-label");
	g_object_notify_by_pspec ((GObject *) self, clocks_alarm_item_properties[CLOCKS_ALARM_ITEM_DAYS_PROPERTY]);
}

ClocksAlarmItemState
clocks_alarm_item_get_state (ClocksAlarmItem* self)
{
	ClocksAlarmItemState result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_state;
	return result;
}

static void
clocks_alarm_item_set_state (ClocksAlarmItem* self,
                             ClocksAlarmItemState value)
{
	ClocksAlarmItemState prev_state = 0;
	g_return_if_fail (self != NULL);
	if (value == self->priv->_state) {
		return;
	}
	prev_state = self->priv->_state;
	self->priv->_state = value;
	if (prev_state == CLOCKS_ALARM_ITEM_STATE_RINGING) {
		ClocksUtilsBell* _tmp0_;
		_tmp0_ = self->priv->bell;
		clocks_utils_bell_stop (_tmp0_);
	}
	if (self->priv->_state == CLOCKS_ALARM_ITEM_STATE_RINGING) {
		clocks_alarm_item_ring (self);
	}
	g_object_notify ((GObject*) self, "state");
}

gchar*
clocks_alarm_item_get_time_label (ClocksAlarmItem* self)
{
	gchar* result;
	ClocksUtilsWallClock* wallclock = NULL;
	ClocksUtilsWallClock* _tmp0_;
	GDateTime* now = NULL;
	GDateTime* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	GDateTime* dt = NULL;
	GTimeZone* _tmp4_;
	GTimeZone* _tmp5_;
	ClocksAlarmAlarmTime _tmp6_;
	ClocksAlarmAlarmTime _tmp7_;
	GDateTime* _tmp8_;
	gchar* _tmp9_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = clocks_utils_wall_clock_get_default ();
	wallclock = _tmp0_;
	_tmp1_ = clocks_utils_wall_clock_get_date_time (wallclock);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_date_time_ref0 (_tmp2_);
	now = _tmp3_;
	_tmp4_ = clocks_utils_wall_clock_get_timezone (wallclock);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->_time;
	_tmp7_ = self->priv->_time;
	_tmp8_ = g_date_time_new (_tmp5_, g_date_time_get_year (now), g_date_time_get_month (now), g_date_time_get_day_of_month (now), _tmp6_.hour, _tmp7_.minute, (gdouble) 0);
	dt = _tmp8_;
	_tmp9_ = clocks_utils_wall_clock_format_time (wallclock, dt, FALSE);
	result = _tmp9_;
	_g_date_time_unref0 (dt);
	_g_date_time_unref0 (now);
	_g_object_unref0 (wallclock);
	return result;
}

gchar*
clocks_alarm_item_get_ring_time_label (ClocksAlarmItem* self)
{
	gchar* result;
	ClocksUtilsWallClock* _tmp0_;
	ClocksUtilsWallClock* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = clocks_utils_wall_clock_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = clocks_alarm_item_get_ring_time (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = clocks_utils_wall_clock_format_time (_tmp1_, _tmp3_, FALSE);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp1_);
	result = _tmp5_;
	return result;
}

gchar*
clocks_alarm_item_get_days_label (ClocksAlarmItem* self)
{
	gchar* result;
	gchar* _tmp0_ = NULL;
	ClocksUtilsWeekdays* _tmp1_;
	ClocksUtilsWeekdays* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = clocks_alarm_item_get_days (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		ClocksUtilsWeekdays* _tmp3_;
		ClocksUtilsWeekdays* _tmp4_;
		gchar* _tmp5_;
		_tmp3_ = clocks_alarm_item_get_days (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = clocks_utils_weekdays_get_label (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, CLOCKS_UTILS_TYPE_WEEKDAYS, ClocksUtilsWeekdays));
		_g_free0 (_tmp0_);
		_tmp0_ = (gchar*) _tmp5_;
	} else {
		_g_free0 (_tmp0_);
		_tmp0_ = NULL;
	}
	result = _tmp0_;
	return result;
}

gboolean
clocks_alarm_item_get_active (ClocksAlarmItem* self)
{
	gboolean result;
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = clocks_alarm_item_get_ring_time (self);
	_tmp1_ = _tmp0_;
	result = _tmp1_ != NULL;
	return result;
}

void
clocks_alarm_item_set_active (ClocksAlarmItem* self,
                              gboolean value)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = clocks_alarm_item_get_active (self);
	_tmp1_ = _tmp0_;
	if (value == _tmp1_) {
		return;
	}
	if (value) {
		GDateTime* _tmp2_;
		GDateTime* _tmp3_;
		_tmp2_ = clocks_alarm_item_next_ring_time (self);
		_tmp3_ = _tmp2_;
		clocks_alarm_item_set_ring_time (self, _tmp3_);
		_g_date_time_unref0 (_tmp3_);
	} else {
		clocks_alarm_item_set_ring_time (self, NULL);
	}
	clocks_alarm_item_set_state (self, CLOCKS_ALARM_ITEM_STATE_READY);
}

static void
clocks_alarm_item_class_init (ClocksAlarmItemClass * klass,
                              gpointer klass_data)
{
	clocks_alarm_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ClocksAlarmItem_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_clocks_alarm_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_clocks_alarm_item_set_property;
	G_OBJECT_CLASS (klass)->finalize = clocks_alarm_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_ALARM_ITEM_ID_PROPERTY, clocks_alarm_item_properties[CLOCKS_ALARM_ITEM_ID_PROPERTY] = g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_ALARM_ITEM_SNOOZE_MINUTES_PROPERTY, clocks_alarm_item_properties[CLOCKS_ALARM_ITEM_SNOOZE_MINUTES_PROPERTY] = g_param_spec_int ("snooze-minutes", "snooze-minutes", "snooze-minutes", G_MININT, G_MAXINT, 10, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_ALARM_ITEM_RING_MINUTES_PROPERTY, clocks_alarm_item_properties[CLOCKS_ALARM_ITEM_RING_MINUTES_PROPERTY] = g_param_spec_int ("ring-minutes", "ring-minutes", "ring-minutes", G_MININT, G_MAXINT, 5, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_ALARM_ITEM_SOUND_FILE_PROPERTY, clocks_alarm_item_properties[CLOCKS_ALARM_ITEM_SOUND_FILE_PROPERTY] = g_param_spec_object ("sound-file", "sound-file", "sound-file", g_file_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_ALARM_ITEM_NAME_PROPERTY, clocks_alarm_item_properties[CLOCKS_ALARM_ITEM_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_ALARM_ITEM_TIME_PROPERTY, clocks_alarm_item_properties[CLOCKS_ALARM_ITEM_TIME_PROPERTY] = g_param_spec_boxed ("time", "time", "time", CLOCKS_ALARM_TYPE_ALARM_TIME, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_ALARM_ITEM_RING_TIME_PROPERTY, clocks_alarm_item_properties[CLOCKS_ALARM_ITEM_RING_TIME_PROPERTY] = g_param_spec_boxed ("ring-time", "ring-time", "ring-time", G_TYPE_DATE_TIME, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_ALARM_ITEM_DAYS_PROPERTY, clocks_alarm_item_properties[CLOCKS_ALARM_ITEM_DAYS_PROPERTY] = clocks_utils_param_spec_weekdays ("days", "days", "days", CLOCKS_UTILS_TYPE_WEEKDAYS, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_ALARM_ITEM_STATE_PROPERTY, clocks_alarm_item_properties[CLOCKS_ALARM_ITEM_STATE_PROPERTY] = g_param_spec_enum ("state", "state", "state", CLOCKS_ALARM_ITEM_TYPE_STATE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_ALARM_ITEM_TIME_LABEL_PROPERTY, clocks_alarm_item_properties[CLOCKS_ALARM_ITEM_TIME_LABEL_PROPERTY] = g_param_spec_string ("time-label", "time-label", "time-label", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_ALARM_ITEM_RING_TIME_LABEL_PROPERTY, clocks_alarm_item_properties[CLOCKS_ALARM_ITEM_RING_TIME_LABEL_PROPERTY] = g_param_spec_string ("ring-time-label", "ring-time-label", "ring-time-label", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_ALARM_ITEM_DAYS_LABEL_PROPERTY, clocks_alarm_item_properties[CLOCKS_ALARM_ITEM_DAYS_LABEL_PROPERTY] = g_param_spec_string ("days-label", "days-label", "days-label", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_ALARM_ITEM_ACTIVE_PROPERTY, clocks_alarm_item_properties[CLOCKS_ALARM_ITEM_ACTIVE_PROPERTY] = g_param_spec_boolean ("active", "active", "active", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_EXPLICIT_NOTIFY));
}

static void
clocks_alarm_item_clocks_content_item_interface_init (ClocksContentItemIface * iface,
                                                      gpointer iface_data)
{
	clocks_alarm_item_clocks_content_item_parent_iface = g_type_interface_peek_parent (iface);
	iface->serialize = (void (*) (ClocksContentItem*, GVariantBuilder*)) clocks_alarm_item_real_serialize;
	iface->get_name = clocks_alarm_item_real_get_name;
	iface->set_name = clocks_alarm_item_real_set_name;
}

static void
clocks_alarm_item_instance_init (ClocksAlarmItem * self,
                                 gpointer klass)
{
	GFile* _tmp0_;
	self->priv = clocks_alarm_item_get_instance_private (self);
	self->priv->_snooze_minutes = 10;
	self->priv->_ring_minutes = 5;
	_tmp0_ = clocks_alarm_sound_model_build_default_file ();
	self->priv->_sound_file = _tmp0_;
	self->priv->_state = CLOCKS_ALARM_ITEM_STATE_READY;
}

static void
clocks_alarm_item_finalize (GObject * obj)
{
	ClocksAlarmItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_ALARM_TYPE_ITEM, ClocksAlarmItem);
	_g_free0 (self->priv->_id);
	_g_object_unref0 (self->priv->_sound_file);
	_g_date_time_unref0 (self->priv->_ring_time);
	_clocks_utils_weekdays_unref0 (self->priv->_days);
	_g_free0 (self->priv->_name);
	_g_object_unref0 (self->priv->bell);
	_g_object_unref0 (self->priv->notification);
	G_OBJECT_CLASS (clocks_alarm_item_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
clocks_alarm_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ClocksAlarmItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clocks_alarm_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClocksAlarmItem), 0, (GInstanceInitFunc) clocks_alarm_item_instance_init, NULL };
	static const GInterfaceInfo clocks_content_item_info = { (GInterfaceInitFunc) clocks_alarm_item_clocks_content_item_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType clocks_alarm_item_type_id;
	clocks_alarm_item_type_id = g_type_register_static (G_TYPE_OBJECT, "ClocksAlarmItem", &g_define_type_info, 0);
	g_type_add_interface_static (clocks_alarm_item_type_id, CLOCKS_TYPE_CONTENT_ITEM, &clocks_content_item_info);
	ClocksAlarmItem_private_offset = g_type_add_instance_private (clocks_alarm_item_type_id, sizeof (ClocksAlarmItemPrivate));
	return clocks_alarm_item_type_id;
}

GType
clocks_alarm_item_get_type (void)
{
	static gsize clocks_alarm_item_type_id__once = 0;
	if (g_once_init_enter (&clocks_alarm_item_type_id__once)) {
		GType clocks_alarm_item_type_id;
		clocks_alarm_item_type_id = clocks_alarm_item_get_type_once ();
		g_once_init_leave (&clocks_alarm_item_type_id__once, clocks_alarm_item_type_id);
	}
	return clocks_alarm_item_type_id__once;
}

static void
_vala_clocks_alarm_item_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	ClocksAlarmItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_ALARM_TYPE_ITEM, ClocksAlarmItem);
	switch (property_id) {
		case CLOCKS_ALARM_ITEM_ID_PROPERTY:
		g_value_set_string (value, clocks_alarm_item_get_id (self));
		break;
		case CLOCKS_ALARM_ITEM_SNOOZE_MINUTES_PROPERTY:
		g_value_set_int (value, clocks_alarm_item_get_snooze_minutes (self));
		break;
		case CLOCKS_ALARM_ITEM_RING_MINUTES_PROPERTY:
		g_value_set_int (value, clocks_alarm_item_get_ring_minutes (self));
		break;
		case CLOCKS_ALARM_ITEM_SOUND_FILE_PROPERTY:
		g_value_set_object (value, clocks_alarm_item_get_sound_file (self));
		break;
		case CLOCKS_ALARM_ITEM_NAME_PROPERTY:
		g_value_set_string (value, clocks_content_item_get_name ((ClocksContentItem*) self));
		break;
		case CLOCKS_ALARM_ITEM_TIME_PROPERTY:
		{
			ClocksAlarmAlarmTime boxed;
			clocks_alarm_item_get_time (self, &boxed);
			g_value_set_boxed (value, &boxed);
		}
		break;
		case CLOCKS_ALARM_ITEM_RING_TIME_PROPERTY:
		g_value_set_boxed (value, clocks_alarm_item_get_ring_time (self));
		break;
		case CLOCKS_ALARM_ITEM_DAYS_PROPERTY:
		clocks_utils_value_set_weekdays (value, clocks_alarm_item_get_days (self));
		break;
		case CLOCKS_ALARM_ITEM_STATE_PROPERTY:
		g_value_set_enum (value, clocks_alarm_item_get_state (self));
		break;
		case CLOCKS_ALARM_ITEM_TIME_LABEL_PROPERTY:
		g_value_take_string (value, clocks_alarm_item_get_time_label (self));
		break;
		case CLOCKS_ALARM_ITEM_RING_TIME_LABEL_PROPERTY:
		g_value_take_string (value, clocks_alarm_item_get_ring_time_label (self));
		break;
		case CLOCKS_ALARM_ITEM_DAYS_LABEL_PROPERTY:
		g_value_take_string (value, clocks_alarm_item_get_days_label (self));
		break;
		case CLOCKS_ALARM_ITEM_ACTIVE_PROPERTY:
		g_value_set_boolean (value, clocks_alarm_item_get_active (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_clocks_alarm_item_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	ClocksAlarmItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_ALARM_TYPE_ITEM, ClocksAlarmItem);
	switch (property_id) {
		case CLOCKS_ALARM_ITEM_ID_PROPERTY:
		clocks_alarm_item_set_id (self, g_value_get_string (value));
		break;
		case CLOCKS_ALARM_ITEM_SNOOZE_MINUTES_PROPERTY:
		clocks_alarm_item_set_snooze_minutes (self, g_value_get_int (value));
		break;
		case CLOCKS_ALARM_ITEM_RING_MINUTES_PROPERTY:
		clocks_alarm_item_set_ring_minutes (self, g_value_get_int (value));
		break;
		case CLOCKS_ALARM_ITEM_SOUND_FILE_PROPERTY:
		clocks_alarm_item_set_sound_file (self, g_value_get_object (value));
		break;
		case CLOCKS_ALARM_ITEM_NAME_PROPERTY:
		clocks_content_item_set_name ((ClocksContentItem*) self, g_value_get_string (value));
		break;
		case CLOCKS_ALARM_ITEM_TIME_PROPERTY:
		clocks_alarm_item_set_time (self, g_value_get_boxed (value));
		break;
		case CLOCKS_ALARM_ITEM_RING_TIME_PROPERTY:
		clocks_alarm_item_set_ring_time (self, g_value_get_boxed (value));
		break;
		case CLOCKS_ALARM_ITEM_DAYS_PROPERTY:
		clocks_alarm_item_set_days (self, clocks_utils_value_get_weekdays (value));
		break;
		case CLOCKS_ALARM_ITEM_STATE_PROPERTY:
		clocks_alarm_item_set_state (self, g_value_get_enum (value));
		break;
		case CLOCKS_ALARM_ITEM_ACTIVE_PROPERTY:
		clocks_alarm_item_set_active (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

