/* SPDX-FileCopyrightText: 2005 - Paolo Borelli
 * SPDX-FileCopyrightText: 2025 - Sébastien Wilmet
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

#pragma once

#include "gedit-window.h"

G_BEGIN_DECLS

#define GEDIT_TYPE_WINDOW_STATUS             (_gedit_window_status_get_type ())
#define GEDIT_WINDOW_STATUS(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEDIT_TYPE_WINDOW_STATUS, GeditWindowStatus))
#define GEDIT_WINDOW_STATUS_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((klass), GEDIT_TYPE_WINDOW_STATUS, GeditWindowStatusClass))
#define GEDIT_IS_WINDOW_STATUS(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEDIT_TYPE_WINDOW_STATUS))
#define GEDIT_IS_WINDOW_STATUS_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), GEDIT_TYPE_WINDOW_STATUS))
#define GEDIT_WINDOW_STATUS_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), GEDIT_TYPE_WINDOW_STATUS, GeditWindowStatusClass))

typedef struct _GeditWindowStatus         GeditWindowStatus;
typedef struct _GeditWindowStatusClass    GeditWindowStatusClass;
typedef struct _GeditWindowStatusPrivate  GeditWindowStatusPrivate;

struct _GeditWindowStatus
{
	GObject parent;

	GeditWindowStatusPrivate *priv;
};

struct _GeditWindowStatusClass
{
	GObjectClass parent_class;
};

G_GNUC_INTERNAL
GType			_gedit_window_status_get_type	(void) G_GNUC_CONST;

G_GNUC_INTERNAL
GeditWindowStatus *	_gedit_window_status_new	(GeditWindow *window);

G_END_DECLS
