/* imap-uid.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from imap-uid.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GEARY_IMAP_UID_0_PROPERTY,
	GEARY_IMAP_UID_NUM_PROPERTIES
};
static GParamSpec* geary_imap_uid_properties[GEARY_IMAP_UID_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

static gpointer geary_imap_uid_parent_class = NULL;
static GearyImapMessageDataIface * geary_imap_uid_geary_imap_message_data_parent_iface = NULL;
static GeeComparableIface * geary_imap_uid_gee_comparable_parent_iface = NULL;

static gint geary_imap_uid_real_compare_to (GearyImapUID* self,
                                     GearyImapUID* other);
static GType geary_imap_uid_get_type_once (void);

/**
     * Creates a new {@link UID} without checking for validity.
     *
     * @see UID.UID.checked
     * @see is_value_valid
     */
GearyImapUID*
geary_imap_uid_construct (GType object_type,
                          gint64 value)
{
	GearyImapUID * self = NULL;
	self = (GearyImapUID*) geary_message_data_int64_message_data_construct (object_type, value);
	return self;
}

GearyImapUID*
geary_imap_uid_new (gint64 value)
{
	return geary_imap_uid_construct (GEARY_IMAP_TYPE_UID, value);
}

/**
     * Creates a new {@link UID}, throwing an {@link ImapError.INVALID} if the supplied value is
     * not a positive unsigned 32-bit integer.
     *
     * @see is_value_valid
     */
GearyImapUID*
geary_imap_uid_construct_checked (GType object_type,
                                  gint64 value,
                                  GError** error)
{
	GearyImapUID * self = NULL;
	GError* _inner_error0_ = NULL;
	if (!geary_imap_uid_is_value_valid (value)) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		GError* _tmp2_;
		GError* _tmp3_;
		_tmp0_ = g_strdup_printf ("%" G_GINT64_FORMAT, value);
		_tmp1_ = _tmp0_;
		_tmp2_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_INVALID, "Invalid UID %s", _tmp1_);
		_tmp3_ = _tmp2_;
		_g_free0 (_tmp1_);
		_inner_error0_ = _tmp3_;
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	self = (GearyImapUID*) geary_message_data_int64_message_data_construct (object_type, value);
	return self;
}

GearyImapUID*
geary_imap_uid_new_checked (gint64 value,
                            GError** error)
{
	return geary_imap_uid_construct_checked (GEARY_IMAP_TYPE_UID, value, error);
}

/**
     * @see is_value_valid
     */
gboolean
geary_imap_uid_is_valid (GearyImapUID* self)
{
	gint64 _tmp0_;
	gint64 _tmp1_;
	gboolean result;
	g_return_val_if_fail (GEARY_IMAP_IS_UID (self), FALSE);
	_tmp0_ = geary_message_data_int64_message_data_get_value (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_MESSAGE_DATA_TYPE_INT64_MESSAGE_DATA, GearyMessageDataInt64MessageData));
	_tmp1_ = _tmp0_;
	result = geary_imap_uid_is_value_valid (_tmp1_);
	return result;
}

/**
     * Returns true if the supplied value is between {@link MIN} and {@link MAX}, inclusive.
     */
gboolean
geary_imap_uid_is_value_valid (gint64 val)
{
	gboolean result;
	result = geary_numeric_int64_in_range_inclusive (val, GEARY_IMAP_UID_MIN, GEARY_IMAP_UID_MAX);
	return result;
}

/**
     * Returns the UID logically next (or after) this one.
     *
     * If clamped this always returns a valid UID, which means returning MIN or MAX if
     * the value is out of range (either direction) or MAX if this value is already MAX.
     *
     * Otherwise, it may return an invalid UID and should be verified before using.
     *
     * @see previous
     * @see is_valid
     */
GearyImapUID*
geary_imap_uid_next (GearyImapUID* self,
                     gboolean clamped)
{
	GearyImapUID* _tmp0_ = NULL;
	GearyImapUID* result;
	g_return_val_if_fail (GEARY_IMAP_IS_UID (self), NULL);
	if (clamped) {
		gint64 _tmp1_;
		gint64 _tmp2_;
		GearyImapUID* _tmp3_;
		_tmp1_ = geary_message_data_int64_message_data_get_value (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_MESSAGE_DATA_TYPE_INT64_MESSAGE_DATA, GearyMessageDataInt64MessageData));
		_tmp2_ = _tmp1_;
		_tmp3_ = geary_imap_uid_new (CLAMP (_tmp2_ + 1, GEARY_IMAP_UID_MIN, GEARY_IMAP_UID_MAX));
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp3_;
	} else {
		gint64 _tmp4_;
		gint64 _tmp5_;
		GearyImapUID* _tmp6_;
		_tmp4_ = geary_message_data_int64_message_data_get_value (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_MESSAGE_DATA_TYPE_INT64_MESSAGE_DATA, GearyMessageDataInt64MessageData));
		_tmp5_ = _tmp4_;
		_tmp6_ = geary_imap_uid_new (_tmp5_ + 1);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp6_;
	}
	result = _tmp0_;
	return result;
}

/**
     * Returns the UID logically previous (or before) this one.
     *
     * If clamped this always returns a valid UID, which means returning MIN or MAX if
     * the value is out of range (either direction) or MIN if this value is already MIN.
     *
     * Otherwise, it may return a UID where {@link is_valid} returns false.
     *
     * @see next
     * @see is_valid
     */
GearyImapUID*
geary_imap_uid_previous (GearyImapUID* self,
                         gboolean clamped)
{
	GearyImapUID* _tmp0_ = NULL;
	GearyImapUID* result;
	g_return_val_if_fail (GEARY_IMAP_IS_UID (self), NULL);
	if (clamped) {
		gint64 _tmp1_;
		gint64 _tmp2_;
		GearyImapUID* _tmp3_;
		_tmp1_ = geary_message_data_int64_message_data_get_value (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_MESSAGE_DATA_TYPE_INT64_MESSAGE_DATA, GearyMessageDataInt64MessageData));
		_tmp2_ = _tmp1_;
		_tmp3_ = geary_imap_uid_new (CLAMP (_tmp2_ - 1, GEARY_IMAP_UID_MIN, GEARY_IMAP_UID_MAX));
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp3_;
	} else {
		gint64 _tmp4_;
		gint64 _tmp5_;
		GearyImapUID* _tmp6_;
		_tmp4_ = geary_message_data_int64_message_data_get_value (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_MESSAGE_DATA_TYPE_INT64_MESSAGE_DATA, GearyMessageDataInt64MessageData));
		_tmp5_ = _tmp4_;
		_tmp6_ = geary_imap_uid_new (_tmp5_ - 1);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp6_;
	}
	result = _tmp0_;
	return result;
}

static gint
geary_imap_uid_real_compare_to (GearyImapUID* self,
                                GearyImapUID* other)
{
	gint64 _tmp0_;
	gint64 _tmp1_;
	gint64 _tmp2_;
	gint64 _tmp3_;
	gint result;
	g_return_val_if_fail (GEARY_IMAP_IS_UID (other), 0);
	_tmp0_ = geary_message_data_int64_message_data_get_value (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_MESSAGE_DATA_TYPE_INT64_MESSAGE_DATA, GearyMessageDataInt64MessageData));
	_tmp1_ = _tmp0_;
	_tmp2_ = geary_message_data_int64_message_data_get_value (G_TYPE_CHECK_INSTANCE_CAST (other, GEARY_MESSAGE_DATA_TYPE_INT64_MESSAGE_DATA, GearyMessageDataInt64MessageData));
	_tmp3_ = _tmp2_;
	result = (gint) CLAMP (_tmp1_ - _tmp3_, (gint64) -1, (gint64) 1);
	return result;
}

gint
geary_imap_uid_compare_to (GearyImapUID* self,
                           GearyImapUID* other)
{
	GearyImapUIDClass* _klass_;
	g_return_val_if_fail (GEARY_IMAP_IS_UID (self), 0);
	_klass_ = GEARY_IMAP_UID_GET_CLASS (self);
	if (_klass_->compare_to) {
		return _klass_->compare_to (self, other);
	}
	return -1;
}

gchar*
geary_imap_uid_serialize (GearyImapUID* self)
{
	gint64 _tmp0_;
	gint64 _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (GEARY_IMAP_IS_UID (self), NULL);
	_tmp0_ = geary_message_data_int64_message_data_get_value (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_MESSAGE_DATA_TYPE_INT64_MESSAGE_DATA, GearyMessageDataInt64MessageData));
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp1_);
	result = _tmp2_;
	return result;
}

static void
geary_imap_uid_class_init (GearyImapUIDClass * klass,
                           gpointer klass_data)
{
	geary_imap_uid_parent_class = g_type_class_peek_parent (klass);
	((GearyImapUIDClass *) klass)->compare_to = (gint (*) (GearyImapUID*, GearyImapUID*)) geary_imap_uid_real_compare_to;
}

static void
geary_imap_uid_geary_imap_message_data_interface_init (GearyImapMessageDataIface * iface,
                                                       gpointer iface_data)
{
	geary_imap_uid_geary_imap_message_data_parent_iface = g_type_interface_peek_parent (iface);
}

static void
geary_imap_uid_gee_comparable_interface_init (GeeComparableIface * iface,
                                              gpointer iface_data)
{
	geary_imap_uid_gee_comparable_parent_iface = g_type_interface_peek_parent (iface);
	iface->compare_to = (gint (*) (GeeComparable*, gconstpointer)) geary_imap_uid_compare_to;
}

static void
geary_imap_uid_instance_init (GearyImapUID * self,
                              gpointer klass)
{
}

/**
 * An IMAP UID.
 *
 * See [[tools.ietf.org/html/rfc3501#section-2.3.1.1]]
 *
 * @see SequenceNumber
 */
 G_GNUC_NO_INLINE static GType
geary_imap_uid_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyImapUIDClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_imap_uid_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyImapUID), 0, (GInstanceInitFunc) geary_imap_uid_instance_init, NULL };
	static const GInterfaceInfo geary_imap_message_data_info = { (GInterfaceInitFunc) geary_imap_uid_geary_imap_message_data_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo gee_comparable_info = { (GInterfaceInitFunc) geary_imap_uid_gee_comparable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType geary_imap_uid_type_id;
	geary_imap_uid_type_id = g_type_register_static (GEARY_MESSAGE_DATA_TYPE_INT64_MESSAGE_DATA, "GearyImapUID", &g_define_type_info, 0);
	g_type_add_interface_static (geary_imap_uid_type_id, GEARY_IMAP_TYPE_MESSAGE_DATA, &geary_imap_message_data_info);
	g_type_add_interface_static (geary_imap_uid_type_id, GEE_TYPE_COMPARABLE, &gee_comparable_info);
	return geary_imap_uid_type_id;
}

GType
geary_imap_uid_get_type (void)
{
	static gsize geary_imap_uid_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_uid_type_id__once)) {
		GType geary_imap_uid_type_id;
		geary_imap_uid_type_id = geary_imap_uid_get_type_once ();
		g_once_init_leave (&geary_imap_uid_type_id__once, geary_imap_uid_type_id);
	}
	return geary_imap_uid_type_id__once;
}

