/* application-startup-manager.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from application-startup-manager.vala, do not modify */

/*
 * Copyright 2022 Cédric Bellegarde <cedric.bellegarde@adishatz.org>
 * Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */
/* Background portal*/

#include "geary-client-46.0.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>

#define APPLICATION_STARTUP_MANAGER_AUTOSTART_FOLDER "autostart"
#define APPLICATION_STARTUP_MANAGER_AUTOSTART_DESKTOP_FILE "geary-autostart.desktop"
#define APPLICATION_STARTUP_MANAGER_BUS_NAME "org.freedesktop.portal.Desktop"
#define APPLICATION_STARTUP_MANAGER_OBJECT_PATH "/org/freedesktop/portal/desktop"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PORTAL_REQUEST_RESPONSE_SIGNAL,
	PORTAL_REQUEST_NUM_SIGNALS
};
static guint portal_request_signals[PORTAL_REQUEST_NUM_SIGNALS] = {0};
typedef GDBusProxy portalRequestProxy;
typedef GDBusProxyClass portalRequestProxyClass;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef GDBusProxy portalBackgroundProxy;
typedef GDBusProxyClass portalBackgroundProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	APPLICATION_STARTUP_MANAGER_0_PROPERTY,
	APPLICATION_STARTUP_MANAGER_NUM_PROPERTIES
};
static GParamSpec* application_startup_manager_properties[APPLICATION_STARTUP_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ApplicationStartupManagerRequestBackgroundData ApplicationStartupManagerRequestBackgroundData;
typedef struct _ApplicationStartupManagerHandleAutostartData ApplicationStartupManagerHandleAutostartData;

struct _ApplicationStartupManagerPrivate {
	ApplicationClient* app;
	GFile* installed_file;
	GFile* startup_file;
};

struct _ApplicationStartupManagerRequestBackgroundData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ApplicationStartupManager* self;
	gboolean autostart;
	GDBusConnection* bus;
	GDBusConnection* _tmp0_;
	gchar** cmdline;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gint cmdline_length1;
	gint _cmdline_size_;
	portalBackground* background;
	GDBusConnection* _tmp4_;
	portalBackground* _tmp5_;
	GHashTable* options;
	GHashFunc _tmp6_;
	GEqualFunc _tmp7_;
	GHashTable* _tmp8_;
	GHashTable* _tmp9_;
	gchar* _tmp10_;
	GVariant* _tmp11_;
	GHashTable* _tmp12_;
	gchar* _tmp13_;
	GVariant* _tmp14_;
	GHashTable* _tmp15_;
	gchar* _tmp16_;
	gchar** _tmp17_;
	gint _tmp17__length1;
	GVariant* _tmp18_;
	char* handle;
	portalBackground* _tmp19_;
	GHashTable* _tmp20_;
	char* _tmp21_;
	GDBusConnection* _tmp22_;
	const char* _tmp23_;
	portalRequest* _tmp24_;
	portalRequest* _tmp25_;
	GError* _error_;
	GError* _tmp26_;
	const gchar* _tmp27_;
	GError* _inner_error0_;
};

struct _ApplicationStartupManagerHandleAutostartData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ApplicationStartupManager* self;
	gboolean install;
	GError* err;
	GError* _tmp0_;
	const gchar* _tmp1_;
	GError* _inner_error0_;
};

static gint ApplicationStartupManager_private_offset;
static gpointer application_startup_manager_parent_class = NULL;

static void g_cclosure_user_marshal_VOID__UINT_BOXED (GClosure * closure,
                                               GValue * return_value,
                                               guint n_param_values,
                                               const GValue * param_values,
                                               gpointer invocation_hint,
                                               gpointer marshal_data);
static GType portal_request_get_type_once (void);
static void portal_request_proxy_g_signal (GDBusProxy* proxy,
                                    const gchar* sender_name,
                                    const gchar* signal_name,
                                    GVariant* parameters);
static void _dbus_handle_portal_request_response (portalRequest* self,
                                           GVariant* parameters);
static void portal_request_proxy_portal_request_interface_init (portalRequestIface* iface);
static void portal_request_dbus_interface_method_call (GDBusConnection* connection,
                                                const gchar* sender,
                                                const gchar* object_path,
                                                const gchar* interface_name,
                                                const gchar* method_name,
                                                GVariant* parameters,
                                                GDBusMethodInvocation* invocation,
                                                gpointer user_data);
static GVariant* portal_request_dbus_interface_get_property (GDBusConnection* connection,
                                                      const gchar* sender,
                                                      const gchar* object_path,
                                                      const gchar* interface_name,
                                                      const gchar* property_name,
                                                      GError** error,
                                                      gpointer user_data);
static gboolean portal_request_dbus_interface_set_property (GDBusConnection* connection,
                                                     const gchar* sender,
                                                     const gchar* object_path,
                                                     const gchar* interface_name,
                                                     const gchar* property_name,
                                                     GVariant* value,
                                                     GError** error,
                                                     gpointer user_data);
static void _dbus_portal_request_response (GObject* _sender,
                                    guint response,
                                    GHashTable* results,
                                    gpointer* _data);
static void _portal_request_unregister_object (gpointer user_data);
static GType portal_background_get_type_once (void);
static void portal_background_proxy_g_signal (GDBusProxy* proxy,
                                       const gchar* sender_name,
                                       const gchar* signal_name,
                                       GVariant* parameters);
static char* portal_background_proxy_request_background (portalBackground* self,
                                                  const gchar* parent_window,
                                                  GHashTable* options,
                                                  GError** error);
static void portal_background_proxy_portal_background_interface_init (portalBackgroundIface* iface);
static void _dbus_portal_background_request_background (portalBackground* self,
                                                 GVariant* _parameters_,
                                                 GDBusMethodInvocation* invocation);
static void portal_background_dbus_interface_method_call (GDBusConnection* connection,
                                                   const gchar* sender,
                                                   const gchar* object_path,
                                                   const gchar* interface_name,
                                                   const gchar* method_name,
                                                   GVariant* parameters,
                                                   GDBusMethodInvocation* invocation,
                                                   gpointer user_data);
static GVariant* portal_background_dbus_interface_get_property (GDBusConnection* connection,
                                                         const gchar* sender,
                                                         const gchar* object_path,
                                                         const gchar* interface_name,
                                                         const gchar* property_name,
                                                         GError** error,
                                                         gpointer user_data);
static gboolean portal_background_dbus_interface_set_property (GDBusConnection* connection,
                                                        const gchar* sender,
                                                        const gchar* object_path,
                                                        const gchar* interface_name,
                                                        const gchar* property_name,
                                                        GVariant* value,
                                                        GError** error,
                                                        gpointer user_data);
static void _portal_background_unregister_object (gpointer user_data);
static void application_startup_manager_on_run_in_background_change (ApplicationStartupManager* self);
static void _application_startup_manager_on_run_in_background_change_g_settings_changed (GSettings* _sender,
                                                                                  const gchar* key,
                                                                                  gpointer self);
static GFile* application_startup_manager_get_installed_desktop_file (ApplicationStartupManager* self);
static void application_startup_manager_request_background_data_free (gpointer _data);
static void application_startup_manager_request_background (ApplicationStartupManager* self,
                                                     gboolean autostart,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_);
static void application_startup_manager_request_background_finish (ApplicationStartupManager* self,
                                                            GAsyncResult* _res_);
static gboolean application_startup_manager_request_background_co (ApplicationStartupManagerRequestBackgroundData* _data_);
static void application_startup_manager_request_background_ready (GObject* source_object,
                                                           GAsyncResult* _res_,
                                                           gpointer _user_data_);
static void _g_free0_ (gpointer var);
static void _g_variant_unref0_ (gpointer var);
static void application_startup_manager_handle_autostart_data_free (gpointer _data);
static void application_startup_manager_handle_autostart (ApplicationStartupManager* self,
                                                   gboolean install,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_);
static void application_startup_manager_handle_autostart_finish (ApplicationStartupManager* self,
                                                          GAsyncResult* _res_);
static gboolean application_startup_manager_handle_autostart_co (ApplicationStartupManagerHandleAutostartData* _data_);
static void application_startup_manager_install_startup_file (ApplicationStartupManager* self,
                                                       GError** error);
static void application_startup_manager_delete_startup_file (ApplicationStartupManager* self,
                                                      GError** error);
static void application_startup_manager_finalize (GObject * obj);
static GType application_startup_manager_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GDBusMethodInfo * const _portal_request_dbus_method_info[] = {NULL};
static const GDBusArgInfo _portal_request_dbus_arg_info_response_response = {-1, "response", "u", NULL};
static const GDBusArgInfo _portal_request_dbus_arg_info_response_results = {-1, "results", "a{sv}", NULL};
static const GDBusArgInfo * const _portal_request_dbus_arg_info_response[] = {&_portal_request_dbus_arg_info_response_response, &_portal_request_dbus_arg_info_response_results, NULL};
static const GDBusSignalInfo _portal_request_dbus_signal_info_response = {-1, "Response", (GDBusArgInfo **) (&_portal_request_dbus_arg_info_response), NULL};
static const GDBusSignalInfo * const _portal_request_dbus_signal_info[] = {&_portal_request_dbus_signal_info_response, NULL};
static const GDBusPropertyInfo * const _portal_request_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _portal_request_dbus_interface_info = {-1, "org.freedesktop.portal.Request", (GDBusMethodInfo **) (&_portal_request_dbus_method_info), (GDBusSignalInfo **) (&_portal_request_dbus_signal_info), (GDBusPropertyInfo **) (&_portal_request_dbus_property_info), NULL};
static const GDBusInterfaceVTable _portal_request_dbus_interface_vtable = {portal_request_dbus_interface_method_call, portal_request_dbus_interface_get_property, portal_request_dbus_interface_set_property};
static const GDBusArgInfo _portal_background_dbus_arg_info_request_background_parent_window = {-1, "parent_window", "s", NULL};
static const GDBusArgInfo _portal_background_dbus_arg_info_request_background_options = {-1, "options", "a{sv}", NULL};
static const GDBusArgInfo _portal_background_dbus_arg_info_request_background_result = {-1, "result", "o", NULL};
static const GDBusArgInfo * const _portal_background_dbus_arg_info_request_background_in[] = {&_portal_background_dbus_arg_info_request_background_parent_window, &_portal_background_dbus_arg_info_request_background_options, NULL};
static const GDBusArgInfo * const _portal_background_dbus_arg_info_request_background_out[] = {&_portal_background_dbus_arg_info_request_background_result, NULL};
static const GDBusMethodInfo _portal_background_dbus_method_info_request_background = {-1, "RequestBackground", (GDBusArgInfo **) (&_portal_background_dbus_arg_info_request_background_in), (GDBusArgInfo **) (&_portal_background_dbus_arg_info_request_background_out), NULL};
static const GDBusMethodInfo * const _portal_background_dbus_method_info[] = {&_portal_background_dbus_method_info_request_background, NULL};
static const GDBusSignalInfo * const _portal_background_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _portal_background_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _portal_background_dbus_interface_info = {-1, "org.freedesktop.portal.Background", (GDBusMethodInfo **) (&_portal_background_dbus_method_info), (GDBusSignalInfo **) (&_portal_background_dbus_signal_info), (GDBusPropertyInfo **) (&_portal_background_dbus_property_info), NULL};
static const GDBusInterfaceVTable _portal_background_dbus_interface_vtable = {portal_background_dbus_interface_method_call, portal_background_dbus_interface_get_property, portal_background_dbus_interface_set_property};

static void
g_cclosure_user_marshal_VOID__UINT_BOXED (GClosure * closure,
                                          GValue * return_value,
                                          guint n_param_values,
                                          const GValue * param_values,
                                          gpointer invocation_hint,
                                          gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__UINT_BOXED) (gpointer data1, guint arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__UINT_BOXED callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_BOXED) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_boxed (param_values + 2), data2);
}

static void
portal_request_default_init (portalRequestIface * iface,
                             gpointer iface_data)
{
	portal_request_signals[PORTAL_REQUEST_RESPONSE_SIGNAL] = g_signal_new ("response", PORTAL_TYPE_REQUEST, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_BOXED, G_TYPE_NONE, 2, G_TYPE_UINT, G_TYPE_HASH_TABLE);
}

static GType
portal_request_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (portalRequestIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) portal_request_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType portal_request_type_id;
	portal_request_type_id = g_type_register_static (G_TYPE_INTERFACE, "portalRequest", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (portal_request_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (portal_request_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) portal_request_proxy_get_type);
	g_type_set_qdata (portal_request_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.portal.Request");
	g_type_set_qdata (portal_request_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_portal_request_dbus_interface_info));
	g_type_set_qdata (portal_request_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) portal_request_register_object);
	return portal_request_type_id;
}

GType
portal_request_get_type (void)
{
	static volatile gsize portal_request_type_id__once = 0;
	if (g_once_init_enter (&portal_request_type_id__once)) {
		GType portal_request_type_id;
		portal_request_type_id = portal_request_get_type_once ();
		g_once_init_leave (&portal_request_type_id__once, portal_request_type_id);
	}
	return portal_request_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (portalRequestProxy, portal_request_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (PORTAL_TYPE_REQUEST, portal_request_proxy_portal_request_interface_init) )
static void
portal_request_proxy_class_init (portalRequestProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = portal_request_proxy_g_signal;
}

static void
_dbus_handle_portal_request_response (portalRequest* self,
                                      GVariant* parameters)
{
	GVariantIter _arguments_iter;
	guint response = 0U;
	GVariant* _tmp0_;
	GHashTable* results = NULL;
	GVariant* _tmp1_;
	GHashTable* _tmp2_;
	GVariantIter _tmp3_;
	GVariant* _tmp4_;
	GVariant* _tmp5_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
	response = g_variant_get_uint32 (_tmp0_);
	g_variant_unref (_tmp0_);
	_tmp1_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp2_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, (GDestroyNotify) g_variant_unref);
	g_variant_iter_init (&_tmp3_, _tmp1_);
	while (g_variant_iter_loop (&_tmp3_, "{?*}", &_tmp4_, &_tmp5_)) {
		g_hash_table_insert (_tmp2_, g_variant_dup_string (_tmp4_, NULL), g_variant_get_variant (_tmp5_));
	}
	results = _tmp2_;
	g_variant_unref (_tmp1_);
	g_signal_emit_by_name (self, "response", response, results);
	_g_hash_table_unref0 (results);
}

static void
portal_request_proxy_g_signal (GDBusProxy* proxy,
                               const gchar* sender_name,
                               const gchar* signal_name,
                               GVariant* parameters)
{
	if (strcmp (signal_name, "Response") == 0) {
		_dbus_handle_portal_request_response ((portalRequest*) proxy, parameters);
	}
}

static void
portal_request_proxy_init (portalRequestProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_portal_request_dbus_interface_info));
}

static void
portal_request_proxy_portal_request_interface_init (portalRequestIface* iface)
{
}

static void
portal_request_dbus_interface_method_call (GDBusConnection* connection,
                                           const gchar* sender,
                                           const gchar* object_path,
                                           const gchar* interface_name,
                                           const gchar* method_name,
                                           GVariant* parameters,
                                           GDBusMethodInvocation* invocation,
                                           gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	g_object_unref (invocation);
}

static GVariant*
portal_request_dbus_interface_get_property (GDBusConnection* connection,
                                            const gchar* sender,
                                            const gchar* object_path,
                                            const gchar* interface_name,
                                            const gchar* property_name,
                                            GError** error,
                                            gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
portal_request_dbus_interface_set_property (GDBusConnection* connection,
                                            const gchar* sender,
                                            const gchar* object_path,
                                            const gchar* interface_name,
                                            const gchar* property_name,
                                            GVariant* value,
                                            GError** error,
                                            gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

static void
_dbus_portal_request_response (GObject* _sender,
                               guint response,
                               GHashTable* results,
                               gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GVariantBuilder _tmp6_;
	GHashTableIter _tmp7_;
	gpointer _tmp8_;
	gpointer _tmp9_;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (response));
	g_hash_table_iter_init (&_tmp7_, results);
	g_variant_builder_init (&_tmp6_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp7_, &_tmp8_, &_tmp9_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp8_;
		_value = (GVariant*) _tmp9_;
		g_variant_builder_add (&_tmp6_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp6_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.portal.Request", "Response", _arguments, NULL);
}

guint
portal_request_register_object (gpointer object,
                                GDBusConnection* connection,
                                const gchar* path,
                                GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_portal_request_dbus_interface_info), &_portal_request_dbus_interface_vtable, data, _portal_request_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "response", (GCallback) _dbus_portal_request_response, data);
	return result;
}

static void
_portal_request_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_portal_request_response, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

char*
portal_background_request_background (portalBackground* self,
                                      const gchar* parent_window,
                                      GHashTable* options,
                                      GError** error)
{
	portalBackgroundIface* _iface_;
	g_return_val_if_fail (PORTAL_IS_BACKGROUND (self), NULL);
	_iface_ = PORTAL_BACKGROUND_GET_INTERFACE (self);
	if (_iface_->request_background) {
		return _iface_->request_background (self, parent_window, options, error);
	}
	return NULL;
}

static void
portal_background_default_init (portalBackgroundIface * iface,
                                gpointer iface_data)
{
}

static GType
portal_background_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (portalBackgroundIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) portal_background_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType portal_background_type_id;
	portal_background_type_id = g_type_register_static (G_TYPE_INTERFACE, "portalBackground", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (portal_background_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (portal_background_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) portal_background_proxy_get_type);
	g_type_set_qdata (portal_background_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.portal.Background");
	g_type_set_qdata (portal_background_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_portal_background_dbus_interface_info));
	g_type_set_qdata (portal_background_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) portal_background_register_object);
	return portal_background_type_id;
}

GType
portal_background_get_type (void)
{
	static volatile gsize portal_background_type_id__once = 0;
	if (g_once_init_enter (&portal_background_type_id__once)) {
		GType portal_background_type_id;
		portal_background_type_id = portal_background_get_type_once ();
		g_once_init_leave (&portal_background_type_id__once, portal_background_type_id);
	}
	return portal_background_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (portalBackgroundProxy, portal_background_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (PORTAL_TYPE_BACKGROUND, portal_background_proxy_portal_background_interface_init) )
static void
portal_background_proxy_class_init (portalBackgroundProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = portal_background_proxy_g_signal;
}

static void
portal_background_proxy_g_signal (GDBusProxy* proxy,
                                  const gchar* sender_name,
                                  const gchar* signal_name,
                                  GVariant* parameters)
{
}

static void
portal_background_proxy_init (portalBackgroundProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_portal_background_dbus_interface_info));
}

static char*
portal_background_proxy_request_background (portalBackground* self,
                                            const gchar* parent_window,
                                            GHashTable* options,
                                            GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GVariantBuilder _tmp10_;
	GHashTableIter _tmp11_;
	gpointer _tmp12_;
	gpointer _tmp13_;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	char* _result = NULL;
	GVariant* _tmp14_;
	G_DBUS_ERROR;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.portal.Background", "RequestBackground");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (parent_window));
	g_hash_table_iter_init (&_tmp11_, options);
	g_variant_builder_init (&_tmp10_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp11_, &_tmp12_, &_tmp13_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp12_;
		_value = (GVariant*) _tmp13_;
		g_variant_builder_add (&_tmp10_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp10_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp14_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_dup_string (_tmp14_, NULL);
	g_variant_unref (_tmp14_);
	g_object_unref (_reply_message);
	return _result;
}

static void
portal_background_proxy_portal_background_interface_init (portalBackgroundIface* iface)
{
	iface->request_background = portal_background_proxy_request_background;
}

static void
_dbus_portal_background_request_background (portalBackground* self,
                                            GVariant* _parameters_,
                                            GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* parent_window = NULL;
	GVariant* _tmp15_;
	GHashTable* options = NULL;
	GVariant* _tmp16_;
	GHashTable* _tmp17_;
	GVariantIter _tmp18_;
	GVariant* _tmp19_;
	GVariant* _tmp20_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	char* result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp15_ = g_variant_iter_next_value (&_arguments_iter);
	parent_window = g_variant_dup_string (_tmp15_, NULL);
	g_variant_unref (_tmp15_);
	_tmp16_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp17_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, (GDestroyNotify) g_variant_unref);
	g_variant_iter_init (&_tmp18_, _tmp16_);
	while (g_variant_iter_loop (&_tmp18_, "{?*}", &_tmp19_, &_tmp20_)) {
		g_hash_table_insert (_tmp17_, g_variant_dup_string (_tmp19_, NULL), g_variant_get_variant (_tmp20_));
	}
	options = _tmp17_;
	g_variant_unref (_tmp16_);
	result = portal_background_request_background (self, parent_window, options, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_object_path (result));
	_g_free0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (parent_window);
	_g_hash_table_unref0 (options);
	;
}

static void
portal_background_dbus_interface_method_call (GDBusConnection* connection,
                                              const gchar* sender,
                                              const gchar* object_path,
                                              const gchar* interface_name,
                                              const gchar* method_name,
                                              GVariant* parameters,
                                              GDBusMethodInvocation* invocation,
                                              gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "RequestBackground") == 0) {
		_dbus_portal_background_request_background (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
portal_background_dbus_interface_get_property (GDBusConnection* connection,
                                               const gchar* sender,
                                               const gchar* object_path,
                                               const gchar* interface_name,
                                               const gchar* property_name,
                                               GError** error,
                                               gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
portal_background_dbus_interface_set_property (GDBusConnection* connection,
                                               const gchar* sender,
                                               const gchar* object_path,
                                               const gchar* interface_name,
                                               const gchar* property_name,
                                               GVariant* value,
                                               GError** error,
                                               gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
portal_background_register_object (gpointer object,
                                   GDBusConnection* connection,
                                   const gchar* path,
                                   GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_portal_background_dbus_interface_info), &_portal_background_dbus_interface_vtable, data, _portal_background_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_portal_background_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static inline gpointer
application_startup_manager_get_instance_private (ApplicationStartupManager* self)
{
	return G_STRUCT_MEMBER_P (self, ApplicationStartupManager_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_application_startup_manager_on_run_in_background_change_g_settings_changed (GSettings* _sender,
                                                                             const gchar* key,
                                                                             gpointer self)
{
	application_startup_manager_on_run_in_background_change ((ApplicationStartupManager*) self);
}

ApplicationStartupManager*
application_startup_manager_construct (GType object_type,
                                       ApplicationClient* app)
{
	ApplicationStartupManager * self = NULL;
	GFile* desktop_dir = NULL;
	GFile* _tmp0_;
	ApplicationClient* _tmp1_;
	GFile* _tmp2_;
	const gchar* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	GFile* _tmp8_;
	ApplicationConfiguration* _tmp9_;
	ApplicationConfiguration* _tmp10_;
	GSettings* _tmp11_;
	GSettings* _tmp12_;
	gchar* _tmp13_;
	g_return_val_if_fail (APPLICATION_IS_CLIENT (app), NULL);
	self = (ApplicationStartupManager*) g_object_new (object_type, NULL);
	_tmp0_ = application_client_get_desktop_directory (app);
	desktop_dir = _tmp0_;
	_tmp1_ = _g_object_ref0 (app);
	_g_object_unref0 (self->priv->app);
	self->priv->app = _tmp1_;
	_tmp2_ = g_file_get_child (desktop_dir, APPLICATION_STARTUP_MANAGER_AUTOSTART_DESKTOP_FILE);
	_g_object_unref0 (self->priv->installed_file);
	self->priv->installed_file = _tmp2_;
	_tmp3_ = g_get_user_config_dir ();
	_tmp4_ = g_file_new_for_path (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_file_get_child (_tmp5_, APPLICATION_STARTUP_MANAGER_AUTOSTART_FOLDER);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_file_get_child (_tmp7_, APPLICATION_STARTUP_MANAGER_AUTOSTART_DESKTOP_FILE);
	_g_object_unref0 (self->priv->startup_file);
	self->priv->startup_file = _tmp8_;
	_g_object_unref0 (_tmp7_);
	_g_object_unref0 (_tmp5_);
	_tmp9_ = application_client_get_config (app);
	_tmp10_ = _tmp9_;
	_tmp11_ = application_configuration_get_settings (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strconcat ("changed::", APPLICATION_CONFIGURATION_RUN_IN_BACKGROUND_KEY, NULL);
	g_signal_connect_object (_tmp12_, _tmp13_, (GCallback) _application_startup_manager_on_run_in_background_change_g_settings_changed, self, 0);
	_g_free0 (_tmp13_);
	_g_object_unref0 (desktop_dir);
	return self;
}

ApplicationStartupManager*
application_startup_manager_new (ApplicationClient* app)
{
	return application_startup_manager_construct (APPLICATION_TYPE_STARTUP_MANAGER, app);
}

/**
     * Returns the system-wide autostart desktop file if it exists.
     */
static GFile*
application_startup_manager_get_installed_desktop_file (ApplicationStartupManager* self)
{
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_;
	GFile* _tmp3_;
	GFile* result;
	g_return_val_if_fail (APPLICATION_IS_STARTUP_MANAGER (self), NULL);
	_tmp1_ = self->priv->installed_file;
	if (g_file_query_exists (_tmp1_, NULL)) {
		GFile* _tmp2_;
		_tmp2_ = self->priv->installed_file;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = NULL;
	}
	_tmp3_ = _g_object_ref0 (_tmp0_);
	result = _tmp3_;
	return result;
}

static void
application_startup_manager_request_background_data_free (gpointer _data)
{
	ApplicationStartupManagerRequestBackgroundData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ApplicationStartupManagerRequestBackgroundData, _data_);
}

static void
application_startup_manager_request_background (ApplicationStartupManager* self,
                                                gboolean autostart,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_)
{
	ApplicationStartupManagerRequestBackgroundData* _data_;
	ApplicationStartupManager* _tmp0_;
	g_return_if_fail (APPLICATION_IS_STARTUP_MANAGER (self));
	_data_ = g_slice_new0 (ApplicationStartupManagerRequestBackgroundData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, application_startup_manager_request_background_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->autostart = autostart;
	application_startup_manager_request_background_co (_data_);
}

static void
application_startup_manager_request_background_finish (ApplicationStartupManager* self,
                                                       GAsyncResult* _res_)
{
	ApplicationStartupManagerRequestBackgroundData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

/**
     * Request background mode using Background portal
     */
static void
application_startup_manager_request_background_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_)
{
	ApplicationStartupManagerRequestBackgroundData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	application_startup_manager_request_background_co (_data_);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_variant_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_variant_unref (var), NULL));
}

static gboolean
application_startup_manager_request_background_co (ApplicationStartupManagerRequestBackgroundData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_state_ = 1;
		g_bus_get (G_BUS_TYPE_SESSION, NULL, application_startup_manager_request_background_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp0_ = g_bus_get_finish (_data_->_res_, &_data_->_inner_error0_);
		_data_->bus = _data_->_tmp0_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp1_ = g_strdup ("geary");
		_data_->_tmp2_ = g_strdup ("--gapplication-service");
		_data_->_tmp3_ = g_new0 (gchar*, 2 + 1);
		_data_->_tmp3_[0] = _data_->_tmp1_;
		_data_->_tmp3_[1] = _data_->_tmp2_;
		_data_->cmdline = _data_->_tmp3_;
		_data_->cmdline_length1 = 2;
		_data_->_cmdline_size_ = _data_->cmdline_length1;
		_data_->_tmp4_ = _data_->bus;
		_data_->_state_ = 2;
		g_async_initable_new_async (PORTAL_TYPE_BACKGROUND_PROXY, 0, NULL, application_startup_manager_request_background_ready, _data_, "g-flags", 0, "g-name", APPLICATION_STARTUP_MANAGER_BUS_NAME, "g-connection", _data_->_tmp4_, "g-object-path", APPLICATION_STARTUP_MANAGER_OBJECT_PATH, "g-interface-name", "org.freedesktop.portal.Background", NULL);
		return FALSE;
		_state_2:
		_data_->_tmp5_ = (portalBackground*) g_async_initable_new_finish ((GAsyncInitable *) _data_->_source_object_, _data_->_res_, &_data_->_inner_error0_);
		_data_->background = (portalBackground*) _data_->_tmp5_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_data_->cmdline = (_vala_array_free (_data_->cmdline, _data_->cmdline_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (_data_->bus);
			goto __catch0_g_error;
		}
		_data_->_tmp6_ = g_str_hash;
		_data_->_tmp7_ = g_str_equal;
		_data_->_tmp8_ = g_hash_table_new_full (_data_->_tmp6_, _data_->_tmp7_, _g_free0_, _g_variant_unref0_);
		_data_->options = _data_->_tmp8_;
		_data_->_tmp9_ = _data_->options;
		_data_->_tmp10_ = g_strdup ("reason");
		_data_->_tmp11_ = g_variant_new ("s", _ ("Geary wants to run in background"), NULL);
		g_variant_ref_sink (_data_->_tmp11_);
		g_hash_table_insert (_data_->_tmp9_, _data_->_tmp10_, _data_->_tmp11_);
		_data_->_tmp12_ = _data_->options;
		_data_->_tmp13_ = g_strdup ("autostart");
		_data_->_tmp14_ = g_variant_new ("b", _data_->autostart, NULL);
		g_variant_ref_sink (_data_->_tmp14_);
		g_hash_table_insert (_data_->_tmp12_, _data_->_tmp13_, _data_->_tmp14_);
		_data_->_tmp15_ = _data_->options;
		_data_->_tmp16_ = g_strdup ("commandline");
		_data_->_tmp17_ = _data_->cmdline;
		_data_->_tmp17__length1 = _data_->cmdline_length1;
		_data_->_tmp18_ = g_variant_new_strv (_data_->_tmp17_, _data_->_tmp17__length1);
		g_variant_ref_sink (_data_->_tmp18_);
		g_hash_table_insert (_data_->_tmp15_, _data_->_tmp16_, _data_->_tmp18_);
		_data_->_tmp19_ = _data_->background;
		_data_->_tmp20_ = _data_->options;
		_data_->_tmp21_ = portal_background_request_background (_data_->_tmp19_, _APP_ID, _data_->_tmp20_, &_data_->_inner_error0_);
		_data_->handle = _data_->_tmp21_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_hash_table_unref0 (_data_->options);
			_g_object_unref0 (_data_->background);
			_data_->cmdline = (_vala_array_free (_data_->cmdline, _data_->cmdline_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (_data_->bus);
			goto __catch0_g_error;
		}
		_data_->_tmp22_ = _data_->bus;
		_data_->_tmp23_ = _data_->handle;
		_data_->_state_ = 3;
		g_async_initable_new_async (PORTAL_TYPE_REQUEST_PROXY, 0, NULL, application_startup_manager_request_background_ready, _data_, "g-flags", 0, "g-name", APPLICATION_STARTUP_MANAGER_BUS_NAME, "g-connection", _data_->_tmp22_, "g-object-path", (const gchar*) _data_->_tmp23_, "g-interface-name", "org.freedesktop.portal.Request", NULL);
		return FALSE;
		_state_3:
		_data_->_tmp24_ = (portalRequest*) g_async_initable_new_finish ((GAsyncInitable *) _data_->_source_object_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp25_ = (portalRequest*) _data_->_tmp24_;
		_g_object_unref0 (_data_->_tmp25_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_free0 (_data_->handle);
			_g_hash_table_unref0 (_data_->options);
			_g_object_unref0 (_data_->background);
			_data_->cmdline = (_vala_array_free (_data_->cmdline, _data_->cmdline_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (_data_->bus);
			goto __catch0_g_error;
		}
		_g_free0 (_data_->handle);
		_g_hash_table_unref0 (_data_->options);
		_g_object_unref0 (_data_->background);
		_data_->cmdline = (_vala_array_free (_data_->cmdline, _data_->cmdline_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (_data_->bus);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->_error_ = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp26_ = _data_->_error_;
		_data_->_tmp27_ = _data_->_tmp26_->message;
		g_warning ("application-startup-manager.vala:85: Failed to request to run in backg" \
"round: %s", _data_->_tmp27_);
		_g_error_free0 (_data_->_error_);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
application_startup_manager_handle_autostart_data_free (gpointer _data)
{
	ApplicationStartupManagerHandleAutostartData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ApplicationStartupManagerHandleAutostartData, _data_);
}

static void
application_startup_manager_handle_autostart (ApplicationStartupManager* self,
                                              gboolean install,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_)
{
	ApplicationStartupManagerHandleAutostartData* _data_;
	ApplicationStartupManager* _tmp0_;
	g_return_if_fail (APPLICATION_IS_STARTUP_MANAGER (self));
	_data_ = g_slice_new0 (ApplicationStartupManagerHandleAutostartData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, application_startup_manager_handle_autostart_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->install = install;
	application_startup_manager_handle_autostart_co (_data_);
}

static void
application_startup_manager_handle_autostart_finish (ApplicationStartupManager* self,
                                                     GAsyncResult* _res_)
{
	ApplicationStartupManagerHandleAutostartData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

/**
     * Handle autostart file installation
     */
static gboolean
application_startup_manager_handle_autostart_co (ApplicationStartupManagerHandleAutostartData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		if (_data_->install) {
			application_startup_manager_install_startup_file (_data_->self, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		} else {
			application_startup_manager_delete_startup_file (_data_->self, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp0_ = _data_->err;
		_data_->_tmp1_ = _data_->_tmp0_->message;
		g_warning ("application-startup-manager.vala:100: Failed to update autostart deskt" \
"op file: %s", _data_->_tmp1_);
		_g_error_free0 (_data_->err);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

/**
     * Copies the autostart desktop file to the autostart directory.
     */
static void
application_startup_manager_install_startup_file (ApplicationStartupManager* self,
                                                  GError** error)
{
	GFile* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (APPLICATION_IS_STARTUP_MANAGER (self));
	_tmp0_ = self->priv->startup_file;
	if (!g_file_query_exists (_tmp0_, NULL)) {
		GFile* autostart_dir = NULL;
		GFile* _tmp1_;
		GFile* _tmp2_;
		GFile* _tmp3_;
		GFile* autostart = NULL;
		GFile* _tmp5_;
		GFile* _tmp6_;
		_tmp1_ = self->priv->startup_file;
		_tmp2_ = g_file_get_parent (_tmp1_);
		autostart_dir = _tmp2_;
		_tmp3_ = autostart_dir;
		if (!g_file_query_exists (_tmp3_, NULL)) {
			GFile* _tmp4_;
			_tmp4_ = autostart_dir;
			g_file_make_directory_with_parents (_tmp4_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (autostart_dir);
				return;
			}
		}
		_tmp5_ = application_startup_manager_get_installed_desktop_file (self);
		autostart = _tmp5_;
		_tmp6_ = autostart;
		if (_tmp6_ == NULL) {
			g_warning ("application-startup-manager.vala:115: Autostart file is not installed!");
		} else {
			GFile* _tmp7_;
			GFile* _tmp8_;
			_tmp7_ = autostart;
			_tmp8_ = self->priv->startup_file;
			g_file_copy (_tmp7_, _tmp8_, 0, NULL, NULL, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (autostart);
				_g_object_unref0 (autostart_dir);
				return;
			}
		}
		_g_object_unref0 (autostart);
		_g_object_unref0 (autostart_dir);
	}
}

/**
     * Deletes the desktop file from autostart directory.
     */
static void
application_startup_manager_delete_startup_file (ApplicationStartupManager* self,
                                                 GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (APPLICATION_IS_STARTUP_MANAGER (self));
	{
		GFile* _tmp0_;
		_tmp0_ = self->priv->startup_file;
		g_file_delete (_tmp0_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (g_error_matches (_inner_error0_, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
				goto __catch0_g_io_error_not_found;
			}
			goto __finally0;
		}
	}
	goto __finally0;
	__catch0_g_io_error_not_found:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

/**
     * Install background/autostart support depending on current
     * execution environment
     */
static void
application_startup_manager_on_run_in_background_change (ApplicationStartupManager* self)
{
	ApplicationClient* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (APPLICATION_IS_STARTUP_MANAGER (self));
	_tmp0_ = self->priv->app;
	_tmp1_ = application_client_get_is_flatpak_sandboxed (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		ApplicationClient* _tmp3_;
		ApplicationConfiguration* _tmp4_;
		ApplicationConfiguration* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp3_ = self->priv->app;
		_tmp4_ = application_client_get_config (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = application_configuration_get_run_in_background (_tmp5_);
		_tmp7_ = _tmp6_;
		application_startup_manager_request_background (self, _tmp7_, NULL, NULL);
	} else {
		ApplicationClient* _tmp8_;
		ApplicationConfiguration* _tmp9_;
		ApplicationConfiguration* _tmp10_;
		gboolean _tmp11_;
		gboolean _tmp12_;
		_tmp8_ = self->priv->app;
		_tmp9_ = application_client_get_config (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = application_configuration_get_run_in_background (_tmp10_);
		_tmp12_ = _tmp11_;
		application_startup_manager_handle_autostart (self, _tmp12_, NULL, NULL);
	}
}

static void
application_startup_manager_class_init (ApplicationStartupManagerClass * klass,
                                        gpointer klass_data)
{
	application_startup_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ApplicationStartupManager_private_offset);
	G_OBJECT_CLASS (klass)->finalize = application_startup_manager_finalize;
}

static void
application_startup_manager_instance_init (ApplicationStartupManager * self,
                                           gpointer klass)
{
	self->priv = application_startup_manager_get_instance_private (self);
}

static void
application_startup_manager_finalize (GObject * obj)
{
	ApplicationStartupManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, APPLICATION_TYPE_STARTUP_MANAGER, ApplicationStartupManager);
	_g_object_unref0 (self->priv->app);
	_g_object_unref0 (self->priv->installed_file);
	_g_object_unref0 (self->priv->startup_file);
	G_OBJECT_CLASS (application_startup_manager_parent_class)->finalize (obj);
}

static GType
application_startup_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ApplicationStartupManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) application_startup_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ApplicationStartupManager), 0, (GInstanceInitFunc) application_startup_manager_instance_init, NULL };
	GType application_startup_manager_type_id;
	application_startup_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "ApplicationStartupManager", &g_define_type_info, 0);
	ApplicationStartupManager_private_offset = g_type_add_instance_private (application_startup_manager_type_id, sizeof (ApplicationStartupManagerPrivate));
	return application_startup_manager_type_id;
}

GType
application_startup_manager_get_type (void)
{
	static volatile gsize application_startup_manager_type_id__once = 0;
	if (g_once_init_enter (&application_startup_manager_type_id__once)) {
		GType application_startup_manager_type_id;
		application_startup_manager_type_id = application_startup_manager_get_type_once ();
		g_once_init_leave (&application_startup_manager_type_id__once, application_startup_manager_type_id);
	}
	return application_startup_manager_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

