/* DBus.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from DBus.vala, do not modify */

/*
 * Copyright 2024 elementary, Inc. (https://elementary.io)
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <string.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <granite-7.h>
#include <glib/gi18n-lib.h>

#define GALA_DAEMON_DBUS_DBUS_NAME "org.pantheon.gala"
#define GALA_DAEMON_DBUS_DBUS_OBJECT_PATH "/org/pantheon/gala"
#define GALA_DAEMON_DBUS_DAEMON_DBUS_NAME "org.pantheon.gala.daemon"
#define GALA_DAEMON_DBUS_DAEMON_DBUS_OBJECT_PATH "/org/pantheon/gala/daemon"
#define GALA_DAEMON_DBUS_BG_MENU_ACTION_GROUP_PREFIX "background-menu"
#define GALA_DAEMON_DBUS_BG_MENU_ACTION_PREFIX GALA_DAEMON_DBUS_BG_MENU_ACTION_GROUP_PREFIX "."
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_WMD_BUS (gala_wmd_bus_get_type ())
#define GALA_WMD_BUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WMD_BUS, GalaWMDBus))
#define GALA_IS_WMD_BUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WMD_BUS))
#define GALA_WMD_BUS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GALA_TYPE_WMD_BUS, GalaWMDBusIface))

typedef struct _GalaWMDBus GalaWMDBus;
typedef struct _GalaWMDBusIface GalaWMDBusIface;

#define GALA_TYPE_WMD_BUS_PROXY (gala_wmd_bus_proxy_get_type ())
typedef enum  {
	GALA_ACTION_TYPE_NONE = 0,
	GALA_ACTION_TYPE_SHOW_MULTITASKING_VIEW,
	GALA_ACTION_TYPE_MAXIMIZE_CURRENT,
	GALA_ACTION_TYPE_HIDE_CURRENT,
	GALA_ACTION_TYPE_OPEN_LAUNCHER,
	GALA_ACTION_TYPE_CUSTOM_COMMAND,
	GALA_ACTION_TYPE_WINDOW_OVERVIEW,
	GALA_ACTION_TYPE_WINDOW_OVERVIEW_ALL,
	GALA_ACTION_TYPE_SWITCH_TO_WORKSPACE_PREVIOUS,
	GALA_ACTION_TYPE_SWITCH_TO_WORKSPACE_NEXT,
	GALA_ACTION_TYPE_SWITCH_TO_WORKSPACE_LAST,
	GALA_ACTION_TYPE_START_MOVE_CURRENT,
	GALA_ACTION_TYPE_START_RESIZE_CURRENT,
	GALA_ACTION_TYPE_TOGGLE_ALWAYS_ON_TOP_CURRENT,
	GALA_ACTION_TYPE_TOGGLE_ALWAYS_ON_VISIBLE_WORKSPACE_CURRENT,
	GALA_ACTION_TYPE_MOVE_CURRENT_WORKSPACE_LEFT,
	GALA_ACTION_TYPE_MOVE_CURRENT_WORKSPACE_RIGHT,
	GALA_ACTION_TYPE_CLOSE_CURRENT,
	GALA_ACTION_TYPE_SCREENSHOT_CURRENT
} GalaActionType;

#define GALA_TYPE_ACTION_TYPE (gala_action_type_get_type ())
typedef GDBusProxy GalaWMDBusProxy;
typedef GDBusProxyClass GalaWMDBusProxyClass;

#define GALA_DAEMON_TYPE_MONITOR_LABEL_INFO (gala_daemon_monitor_label_info_get_type ())
typedef struct _GalaDaemonMonitorLabelInfo GalaDaemonMonitorLabelInfo;
#define _g_free0(var) (var = (g_free (var), NULL))

#define GALA_DAEMON_TYPE_DBUS (gala_daemon_dbus_get_type ())
#define GALA_DAEMON_DBUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_DAEMON_TYPE_DBUS, GalaDaemonDBus))
#define GALA_DAEMON_DBUS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_DAEMON_TYPE_DBUS, GalaDaemonDBusClass))
#define GALA_DAEMON_IS_DBUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_DAEMON_TYPE_DBUS))
#define GALA_DAEMON_IS_DBUS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_DAEMON_TYPE_DBUS))
#define GALA_DAEMON_DBUS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_DAEMON_TYPE_DBUS, GalaDaemonDBusClass))

typedef struct _GalaDaemonDBus GalaDaemonDBus;
typedef struct _GalaDaemonDBusClass GalaDaemonDBusClass;
typedef struct _GalaDaemonDBusPrivate GalaDaemonDBusPrivate;

#define GALA_DAEMON_TYPE_WINDOW (gala_daemon_window_get_type ())
#define GALA_DAEMON_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_DAEMON_TYPE_WINDOW, GalaDaemonWindow))
#define GALA_DAEMON_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_DAEMON_TYPE_WINDOW, GalaDaemonWindowClass))
#define GALA_DAEMON_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_DAEMON_TYPE_WINDOW))
#define GALA_DAEMON_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_DAEMON_TYPE_WINDOW))
#define GALA_DAEMON_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_DAEMON_TYPE_WINDOW, GalaDaemonWindowClass))

typedef struct _GalaDaemonWindow GalaDaemonWindow;
typedef struct _GalaDaemonWindowClass GalaDaemonWindowClass;

#define GALA_DAEMON_TYPE_WINDOW_MENU (gala_daemon_window_menu_get_type ())
#define GALA_DAEMON_WINDOW_MENU(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_DAEMON_TYPE_WINDOW_MENU, GalaDaemonWindowMenu))
#define GALA_DAEMON_WINDOW_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_DAEMON_TYPE_WINDOW_MENU, GalaDaemonWindowMenuClass))
#define GALA_DAEMON_IS_WINDOW_MENU(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_DAEMON_TYPE_WINDOW_MENU))
#define GALA_DAEMON_IS_WINDOW_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_DAEMON_TYPE_WINDOW_MENU))
#define GALA_DAEMON_WINDOW_MENU_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_DAEMON_TYPE_WINDOW_MENU, GalaDaemonWindowMenuClass))

typedef struct _GalaDaemonWindowMenu GalaDaemonWindowMenu;
typedef struct _GalaDaemonWindowMenuClass GalaDaemonWindowMenuClass;

#define GALA_DAEMON_TYPE_MONITOR_LABEL (gala_daemon_monitor_label_get_type ())
#define GALA_DAEMON_MONITOR_LABEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_DAEMON_TYPE_MONITOR_LABEL, GalaDaemonMonitorLabel))
#define GALA_DAEMON_MONITOR_LABEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_DAEMON_TYPE_MONITOR_LABEL, GalaDaemonMonitorLabelClass))
#define GALA_DAEMON_IS_MONITOR_LABEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_DAEMON_TYPE_MONITOR_LABEL))
#define GALA_DAEMON_IS_MONITOR_LABEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_DAEMON_TYPE_MONITOR_LABEL))
#define GALA_DAEMON_MONITOR_LABEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_DAEMON_TYPE_MONITOR_LABEL, GalaDaemonMonitorLabelClass))

typedef struct _GalaDaemonMonitorLabel GalaDaemonMonitorLabel;
typedef struct _GalaDaemonMonitorLabelClass GalaDaemonMonitorLabelClass;
enum  {
	GALA_DAEMON_DBUS_0_PROPERTY,
	GALA_DAEMON_DBUS_NUM_PROPERTIES
};
static GParamSpec* gala_daemon_dbus_properties[GALA_DAEMON_DBUS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef enum  {
	GALA_WINDOW_FLAGS_NONE = 0,
	GALA_WINDOW_FLAGS_CAN_HIDE = 1 << 0,
	GALA_WINDOW_FLAGS_CAN_MAXIMIZE = 1 << 1,
	GALA_WINDOW_FLAGS_IS_MAXIMIZED = 1 << 2,
	GALA_WINDOW_FLAGS_ALLOWS_MOVE = 1 << 3,
	GALA_WINDOW_FLAGS_ALLOWS_RESIZE = 1 << 4,
	GALA_WINDOW_FLAGS_ALWAYS_ON_TOP = 1 << 5,
	GALA_WINDOW_FLAGS_ON_ALL_WORKSPACES = 1 << 6,
	GALA_WINDOW_FLAGS_CAN_CLOSE = 1 << 7,
	GALA_WINDOW_FLAGS_IS_TILED = 1 << 8,
	GALA_WINDOW_FLAGS_ALLOWS_MOVE_LEFT = 1 << 9,
	GALA_WINDOW_FLAGS_ALLOWS_MOVE_RIGHT = 1 << 10
} GalaWindowFlags;

#define GALA_TYPE_WINDOW_FLAGS (gala_window_flags_get_type ())
typedef struct _Block2Data Block2Data;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _Block3Data Block3Data;

struct _GalaWMDBusIface {
	GTypeInterface parent_iface;
	void (*perform_action) (GalaWMDBus* self, GalaActionType type, GError** error);
};

struct _GalaDaemonMonitorLabelInfo {
	gint monitor;
	gchar* label;
	gchar* background_color;
	gchar* text_color;
	gint x;
	gint y;
};

struct _GalaDaemonDBus {
	GObject parent_instance;
	GalaDaemonDBusPrivate * priv;
};

struct _GalaDaemonDBusClass {
	GObjectClass parent_class;
};

struct _GalaDaemonDBusPrivate {
	GalaWMDBus* wm_proxy;
	GalaDaemonWindow* window;
	GalaDaemonWindowMenu* window_menu;
	GtkPopoverMenu* background_menu;
	GList* monitor_labels;
};

struct _Block2Data {
	int _ref_count_;
	GalaDaemonDBus* self;
	GtkPopover* menu;
};

struct _Block3Data {
	int _ref_count_;
	GalaDaemonDBus* self;
	GalaActionType type;
};

static gint GalaDaemonDBus_private_offset;
static gpointer gala_daemon_dbus_parent_class = NULL;

VALA_EXTERN GType gala_wmd_bus_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint gala_wmd_bus_register_object (void* object,
                                    GDBusConnection* connection,
                                    const gchar* path,
                                    GError** error);
VALA_EXTERN GType gala_action_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType gala_wmd_bus_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWMDBus, g_object_unref)
VALA_EXTERN void gala_wmd_bus_perform_action (GalaWMDBus* self,
                                  GalaActionType type,
                                  GError** error);
static GType gala_wmd_bus_get_type_once (void);
static void gala_wmd_bus_proxy_g_signal (GDBusProxy* proxy,
                                  const gchar* sender_name,
                                  const gchar* signal_name,
                                  GVariant* parameters);
static void gala_wmd_bus_proxy_perform_action (GalaWMDBus* self,
                                        GalaActionType type,
                                        GError** error);
static void gala_wmd_bus_proxy_gala_wmd_bus_interface_init (GalaWMDBusIface* iface);
static void _dbus_gala_wmd_bus_perform_action (GalaWMDBus* self,
                                        GVariant* _parameters_,
                                        GDBusMethodInvocation* invocation);
static void gala_wmd_bus_dbus_interface_method_call (GDBusConnection* connection,
                                              const gchar* sender,
                                              const gchar* object_path,
                                              const gchar* interface_name,
                                              const gchar* method_name,
                                              GVariant* parameters,
                                              GDBusMethodInvocation* invocation,
                                              gpointer user_data);
static GVariant* gala_wmd_bus_dbus_interface_get_property (GDBusConnection* connection,
                                                    const gchar* sender,
                                                    const gchar* object_path,
                                                    const gchar* interface_name,
                                                    const gchar* property_name,
                                                    GError** error,
                                                    gpointer user_data);
static gboolean gala_wmd_bus_dbus_interface_set_property (GDBusConnection* connection,
                                                   const gchar* sender,
                                                   const gchar* object_path,
                                                   const gchar* interface_name,
                                                   const gchar* property_name,
                                                   GVariant* value,
                                                   GError** error,
                                                   gpointer user_data);
static void _gala_wmd_bus_unregister_object (gpointer user_data);
VALA_EXTERN GType gala_daemon_monitor_label_info_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GalaDaemonMonitorLabelInfo* gala_daemon_monitor_label_info_dup (const GalaDaemonMonitorLabelInfo* self);
VALA_EXTERN void gala_daemon_monitor_label_info_free (GalaDaemonMonitorLabelInfo* self);
VALA_EXTERN void gala_daemon_monitor_label_info_copy (const GalaDaemonMonitorLabelInfo* self,
                                          GalaDaemonMonitorLabelInfo* dest);
VALA_EXTERN void gala_daemon_monitor_label_info_destroy (GalaDaemonMonitorLabelInfo* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (GalaDaemonMonitorLabelInfo, gala_daemon_monitor_label_info_destroy)
VALA_EXTERN GType gala_daemon_dbus_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaDaemonDBus, g_object_unref)
VALA_EXTERN guint gala_daemon_dbus_register_object (void* object,
                                        GDBusConnection* connection,
                                        const gchar* path,
                                        GError** error);
VALA_EXTERN GType gala_daemon_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaDaemonWindow, g_object_unref)
VALA_EXTERN GType gala_daemon_window_menu_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaDaemonWindowMenu, g_object_unref)
VALA_EXTERN GType gala_daemon_monitor_label_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaDaemonMonitorLabel, g_object_unref)
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void gala_daemon_dbus_on_gala_get (GalaDaemonDBus* self,
                                   GObject* obj,
                                   GAsyncResult* res);
static void gala_daemon_dbus_lost_gala (GalaDaemonDBus* self);
static void gala_daemon_dbus_gala_appeared (GalaDaemonDBus* self);
static void _gala_daemon_dbus_on_gala_get_gasync_ready_callback (GObject* source_object,
                                                          GAsyncResult* res,
                                                          gpointer self);
static void gala_daemon_dbus_perform_action (GalaDaemonDBus* self,
                                      GalaActionType type);
VALA_EXTERN GType gala_window_flags_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void gala_daemon_dbus_show_window_menu (GalaDaemonDBus* self,
                                        GalaWindowFlags flags,
                                        gint display_width,
                                        gint display_height,
                                        gint x,
                                        gint y,
                                        GError** error);
VALA_EXTERN void gala_daemon_window_menu_update (GalaDaemonWindowMenu* self,
                                     GalaWindowFlags flags);
static void gala_daemon_dbus_show_menu (GalaDaemonDBus* self,
                                 GtkPopover* menu,
                                 gint display_width,
                                 gint display_height,
                                 gint x,
                                 gint y);
VALA_EXTERN void gala_daemon_dbus_show_desktop_menu (GalaDaemonDBus* self,
                                         gint display_width,
                                         gint display_height,
                                         gint x,
                                         gint y,
                                         GError** error);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
VALA_EXTERN gboolean gala_daemon_display_config_is_logical_layout (void);
static gboolean __lambda15_ (Block2Data* _data2_);
static gboolean ___lambda15__gsource_func (gpointer self);
VALA_EXTERN void gala_daemon_dbus_show_monitor_labels (GalaDaemonDBus* self,
                                           GalaDaemonMonitorLabelInfo* label_infos,
                                           gint label_infos_length1,
                                           GError** error);
VALA_EXTERN void gala_daemon_dbus_hide_monitor_labels (GalaDaemonDBus* self,
                                           GError** error);
VALA_EXTERN GalaDaemonMonitorLabel* gala_daemon_monitor_label_new (GalaDaemonMonitorLabelInfo* info);
VALA_EXTERN GalaDaemonMonitorLabel* gala_daemon_monitor_label_construct (GType object_type,
                                                             GalaDaemonMonitorLabelInfo* info);
static void gala_daemon_dbus_action_launch (GSimpleAction* action,
                                     GVariant* variant);
static void _gtk_window_destroy_gtk_dialog_response (GtkDialog* _sender,
                                              gint response_id,
                                              gpointer self);
VALA_EXTERN GalaDaemonDBus* gala_daemon_dbus_new (void);
VALA_EXTERN GalaDaemonDBus* gala_daemon_dbus_construct (GType object_type);
static GObject * gala_daemon_dbus_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties);
static void _gala_daemon_dbus_gala_appeared_gbus_name_appeared_callback (GDBusConnection* connection,
                                                                  const gchar* name,
                                                                  const gchar* name_owner,
                                                                  gpointer self);
static void _gala_daemon_dbus_lost_gala_gbus_name_vanished_callback (GDBusConnection* connection,
                                                              const gchar* name,
                                                              gpointer self);
VALA_EXTERN GalaDaemonWindow* gala_daemon_window_new (void);
VALA_EXTERN GalaDaemonWindow* gala_daemon_window_construct (GType object_type);
static GVariant* _variant_new1 (const gchar* value);
static GVariant* _variant_new2 (const gchar* value);
static GVariant* _variant_new3 (const gchar* value);
static void _gtk_window_close_gtk_popover_closed (GtkPopover* _sender,
                                           gpointer self);
static void _gala_daemon_dbus_action_launch_g_simple_action_activate (GSimpleAction* _sender,
                                                               GVariant* parameter,
                                                               gpointer self);
VALA_EXTERN GalaDaemonWindowMenu* gala_daemon_window_menu_new (void);
VALA_EXTERN GalaDaemonWindowMenu* gala_daemon_window_menu_construct (GType object_type);
static void _gala_daemon_dbus___lambda16_ (GalaDaemonDBus* self,
                                    GalaActionType type);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static gboolean __lambda17_ (Block3Data* _data3_);
static gboolean ___lambda17__gsource_func (gpointer self);
static void __gala_daemon_dbus___lambda16__gala_daemon_window_menu_perform_action (GalaDaemonWindowMenu* _sender,
                                                                            GalaActionType type,
                                                                            gpointer self);
static void gala_daemon_dbus_finalize (GObject * obj);
static GType gala_daemon_dbus_get_type_once (void);
static void _dbus_gala_daemon_dbus_show_window_menu (GalaDaemonDBus* self,
                                              GVariant* _parameters_,
                                              GDBusMethodInvocation* invocation);
static void _dbus_gala_daemon_dbus_show_desktop_menu (GalaDaemonDBus* self,
                                               GVariant* _parameters_,
                                               GDBusMethodInvocation* invocation);
static void _vala_GalaDaemonMonitorLabelInfo_array_free (GalaDaemonMonitorLabelInfo * array,
                                                  gssize array_length);
static void _dbus_gala_daemon_dbus_show_monitor_labels (GalaDaemonDBus* self,
                                                 GVariant* _parameters_,
                                                 GDBusMethodInvocation* invocation);
static void _dbus_gala_daemon_dbus_hide_monitor_labels (GalaDaemonDBus* self,
                                                 GVariant* _parameters_,
                                                 GDBusMethodInvocation* invocation);
static void gala_daemon_dbus_dbus_interface_method_call (GDBusConnection* connection,
                                                  const gchar* sender,
                                                  const gchar* object_path,
                                                  const gchar* interface_name,
                                                  const gchar* method_name,
                                                  GVariant* parameters,
                                                  GDBusMethodInvocation* invocation,
                                                  gpointer user_data);
static GVariant* gala_daemon_dbus_dbus_interface_get_property (GDBusConnection* connection,
                                                        const gchar* sender,
                                                        const gchar* object_path,
                                                        const gchar* interface_name,
                                                        const gchar* property_name,
                                                        GError** error,
                                                        gpointer user_data);
static gboolean gala_daemon_dbus_dbus_interface_set_property (GDBusConnection* connection,
                                                       const gchar* sender,
                                                       const gchar* object_path,
                                                       const gchar* interface_name,
                                                       const gchar* property_name,
                                                       GVariant* value,
                                                       GError** error,
                                                       gpointer user_data);
static void _gala_daemon_dbus_unregister_object (gpointer user_data);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static const GDBusArgInfo _gala_wmd_bus_dbus_arg_info_perform_action_type = {-1, "type", "i", NULL};
static const GDBusArgInfo * const _gala_wmd_bus_dbus_arg_info_perform_action_in[] = {&_gala_wmd_bus_dbus_arg_info_perform_action_type, NULL};
static const GDBusArgInfo * const _gala_wmd_bus_dbus_arg_info_perform_action_out[] = {NULL};
static const GDBusMethodInfo _gala_wmd_bus_dbus_method_info_perform_action = {-1, "PerformAction", (GDBusArgInfo **) (&_gala_wmd_bus_dbus_arg_info_perform_action_in), (GDBusArgInfo **) (&_gala_wmd_bus_dbus_arg_info_perform_action_out), NULL};
static const GDBusMethodInfo * const _gala_wmd_bus_dbus_method_info[] = {&_gala_wmd_bus_dbus_method_info_perform_action, NULL};
static const GDBusSignalInfo * const _gala_wmd_bus_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _gala_wmd_bus_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _gala_wmd_bus_dbus_interface_info = {-1, "org.pantheon.gala", (GDBusMethodInfo **) (&_gala_wmd_bus_dbus_method_info), (GDBusSignalInfo **) (&_gala_wmd_bus_dbus_signal_info), (GDBusPropertyInfo **) (&_gala_wmd_bus_dbus_property_info), NULL};
static const GDBusInterfaceVTable _gala_wmd_bus_dbus_interface_vtable = {gala_wmd_bus_dbus_interface_method_call, gala_wmd_bus_dbus_interface_get_property, gala_wmd_bus_dbus_interface_set_property};
static const GDBusArgInfo _gala_daemon_dbus_dbus_arg_info_show_window_menu_flags = {-1, "flags", "u", NULL};
static const GDBusArgInfo _gala_daemon_dbus_dbus_arg_info_show_window_menu_display_width = {-1, "display_width", "i", NULL};
static const GDBusArgInfo _gala_daemon_dbus_dbus_arg_info_show_window_menu_display_height = {-1, "display_height", "i", NULL};
static const GDBusArgInfo _gala_daemon_dbus_dbus_arg_info_show_window_menu_x = {-1, "x", "i", NULL};
static const GDBusArgInfo _gala_daemon_dbus_dbus_arg_info_show_window_menu_y = {-1, "y", "i", NULL};
static const GDBusArgInfo * const _gala_daemon_dbus_dbus_arg_info_show_window_menu_in[] = {&_gala_daemon_dbus_dbus_arg_info_show_window_menu_flags, &_gala_daemon_dbus_dbus_arg_info_show_window_menu_display_width, &_gala_daemon_dbus_dbus_arg_info_show_window_menu_display_height, &_gala_daemon_dbus_dbus_arg_info_show_window_menu_x, &_gala_daemon_dbus_dbus_arg_info_show_window_menu_y, NULL};
static const GDBusArgInfo * const _gala_daemon_dbus_dbus_arg_info_show_window_menu_out[] = {NULL};
static const GDBusMethodInfo _gala_daemon_dbus_dbus_method_info_show_window_menu = {-1, "ShowWindowMenu", (GDBusArgInfo **) (&_gala_daemon_dbus_dbus_arg_info_show_window_menu_in), (GDBusArgInfo **) (&_gala_daemon_dbus_dbus_arg_info_show_window_menu_out), NULL};
static const GDBusArgInfo _gala_daemon_dbus_dbus_arg_info_show_desktop_menu_display_width = {-1, "display_width", "i", NULL};
static const GDBusArgInfo _gala_daemon_dbus_dbus_arg_info_show_desktop_menu_display_height = {-1, "display_height", "i", NULL};
static const GDBusArgInfo _gala_daemon_dbus_dbus_arg_info_show_desktop_menu_x = {-1, "x", "i", NULL};
static const GDBusArgInfo _gala_daemon_dbus_dbus_arg_info_show_desktop_menu_y = {-1, "y", "i", NULL};
static const GDBusArgInfo * const _gala_daemon_dbus_dbus_arg_info_show_desktop_menu_in[] = {&_gala_daemon_dbus_dbus_arg_info_show_desktop_menu_display_width, &_gala_daemon_dbus_dbus_arg_info_show_desktop_menu_display_height, &_gala_daemon_dbus_dbus_arg_info_show_desktop_menu_x, &_gala_daemon_dbus_dbus_arg_info_show_desktop_menu_y, NULL};
static const GDBusArgInfo * const _gala_daemon_dbus_dbus_arg_info_show_desktop_menu_out[] = {NULL};
static const GDBusMethodInfo _gala_daemon_dbus_dbus_method_info_show_desktop_menu = {-1, "ShowDesktopMenu", (GDBusArgInfo **) (&_gala_daemon_dbus_dbus_arg_info_show_desktop_menu_in), (GDBusArgInfo **) (&_gala_daemon_dbus_dbus_arg_info_show_desktop_menu_out), NULL};
static const GDBusArgInfo _gala_daemon_dbus_dbus_arg_info_show_monitor_labels_label_infos = {-1, "label_infos", "a(isssii)", NULL};
static const GDBusArgInfo * const _gala_daemon_dbus_dbus_arg_info_show_monitor_labels_in[] = {&_gala_daemon_dbus_dbus_arg_info_show_monitor_labels_label_infos, NULL};
static const GDBusArgInfo * const _gala_daemon_dbus_dbus_arg_info_show_monitor_labels_out[] = {NULL};
static const GDBusMethodInfo _gala_daemon_dbus_dbus_method_info_show_monitor_labels = {-1, "ShowMonitorLabels", (GDBusArgInfo **) (&_gala_daemon_dbus_dbus_arg_info_show_monitor_labels_in), (GDBusArgInfo **) (&_gala_daemon_dbus_dbus_arg_info_show_monitor_labels_out), NULL};
static const GDBusArgInfo * const _gala_daemon_dbus_dbus_arg_info_hide_monitor_labels_in[] = {NULL};
static const GDBusArgInfo * const _gala_daemon_dbus_dbus_arg_info_hide_monitor_labels_out[] = {NULL};
static const GDBusMethodInfo _gala_daemon_dbus_dbus_method_info_hide_monitor_labels = {-1, "HideMonitorLabels", (GDBusArgInfo **) (&_gala_daemon_dbus_dbus_arg_info_hide_monitor_labels_in), (GDBusArgInfo **) (&_gala_daemon_dbus_dbus_arg_info_hide_monitor_labels_out), NULL};
static const GDBusMethodInfo * const _gala_daemon_dbus_dbus_method_info[] = {&_gala_daemon_dbus_dbus_method_info_show_window_menu, &_gala_daemon_dbus_dbus_method_info_show_desktop_menu, &_gala_daemon_dbus_dbus_method_info_show_monitor_labels, &_gala_daemon_dbus_dbus_method_info_hide_monitor_labels, NULL};
static const GDBusSignalInfo * const _gala_daemon_dbus_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _gala_daemon_dbus_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _gala_daemon_dbus_dbus_interface_info = {-1, "org.pantheon.gala.daemon", (GDBusMethodInfo **) (&_gala_daemon_dbus_dbus_method_info), (GDBusSignalInfo **) (&_gala_daemon_dbus_dbus_signal_info), (GDBusPropertyInfo **) (&_gala_daemon_dbus_dbus_property_info), NULL};
static const GDBusInterfaceVTable _gala_daemon_dbus_dbus_interface_vtable = {gala_daemon_dbus_dbus_interface_method_call, gala_daemon_dbus_dbus_interface_get_property, gala_daemon_dbus_dbus_interface_set_property};

void
gala_wmd_bus_perform_action (GalaWMDBus* self,
                             GalaActionType type,
                             GError** error)
{
	GalaWMDBusIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GALA_WMD_BUS_GET_INTERFACE (self);
	if (_iface_->perform_action) {
		_iface_->perform_action (self, type, error);
	}
}

static void
gala_wmd_bus_default_init (GalaWMDBusIface * iface,
                           gpointer iface_data)
{
}

static GType
gala_wmd_bus_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaWMDBusIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_wmd_bus_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType gala_wmd_bus_type_id;
	gala_wmd_bus_type_id = g_type_register_static (G_TYPE_INTERFACE, "GalaWMDBus", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (gala_wmd_bus_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (gala_wmd_bus_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) gala_wmd_bus_proxy_get_type);
	g_type_set_qdata (gala_wmd_bus_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.pantheon.gala");
	g_type_set_qdata (gala_wmd_bus_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_gala_wmd_bus_dbus_interface_info));
	g_type_set_qdata (gala_wmd_bus_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) gala_wmd_bus_register_object);
	return gala_wmd_bus_type_id;
}

GType
gala_wmd_bus_get_type (void)
{
	static volatile gsize gala_wmd_bus_type_id__once = 0;
	if (g_once_init_enter (&gala_wmd_bus_type_id__once)) {
		GType gala_wmd_bus_type_id;
		gala_wmd_bus_type_id = gala_wmd_bus_get_type_once ();
		g_once_init_leave (&gala_wmd_bus_type_id__once, gala_wmd_bus_type_id);
	}
	return gala_wmd_bus_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (GalaWMDBusProxy, gala_wmd_bus_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (GALA_TYPE_WMD_BUS, gala_wmd_bus_proxy_gala_wmd_bus_interface_init) )
static void
gala_wmd_bus_proxy_class_init (GalaWMDBusProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = gala_wmd_bus_proxy_g_signal;
}

static void
gala_wmd_bus_proxy_g_signal (GDBusProxy* proxy,
                             const gchar* sender_name,
                             const gchar* signal_name,
                             GVariant* parameters)
{
}

static void
gala_wmd_bus_proxy_init (GalaWMDBusProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_gala_wmd_bus_dbus_interface_info));
}

static void
gala_wmd_bus_proxy_perform_action (GalaWMDBus* self,
                                   GalaActionType type,
                                   GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	G_DBUS_ERROR;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.pantheon.gala", "PerformAction");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (type));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
gala_wmd_bus_proxy_gala_wmd_bus_interface_init (GalaWMDBusIface* iface)
{
	iface->perform_action = gala_wmd_bus_proxy_perform_action;
}

static void
_dbus_gala_wmd_bus_perform_action (GalaWMDBus* self,
                                   GVariant* _parameters_,
                                   GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GalaActionType type = 0;
	GVariant* _tmp106_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp106_ = g_variant_iter_next_value (&_arguments_iter);
	type = g_variant_get_int32 (_tmp106_);
	g_variant_unref (_tmp106_);
	gala_wmd_bus_perform_action (self, type, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
gala_wmd_bus_dbus_interface_method_call (GDBusConnection* connection,
                                         const gchar* sender,
                                         const gchar* object_path,
                                         const gchar* interface_name,
                                         const gchar* method_name,
                                         GVariant* parameters,
                                         GDBusMethodInvocation* invocation,
                                         gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "PerformAction") == 0) {
		_dbus_gala_wmd_bus_perform_action (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
gala_wmd_bus_dbus_interface_get_property (GDBusConnection* connection,
                                          const gchar* sender,
                                          const gchar* object_path,
                                          const gchar* interface_name,
                                          const gchar* property_name,
                                          GError** error,
                                          gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
gala_wmd_bus_dbus_interface_set_property (GDBusConnection* connection,
                                          const gchar* sender,
                                          const gchar* object_path,
                                          const gchar* interface_name,
                                          const gchar* property_name,
                                          GVariant* value,
                                          GError** error,
                                          gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
gala_wmd_bus_register_object (gpointer object,
                              GDBusConnection* connection,
                              const gchar* path,
                              GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_gala_wmd_bus_dbus_interface_info), &_gala_wmd_bus_dbus_interface_vtable, data, _gala_wmd_bus_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_gala_wmd_bus_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

void
gala_daemon_monitor_label_info_copy (const GalaDaemonMonitorLabelInfo* self,
                                     GalaDaemonMonitorLabelInfo* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	(*dest).monitor = (*self).monitor;
	_tmp0_ = (*self).label;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).label);
	(*dest).label = _tmp1_;
	_tmp2_ = (*self).background_color;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).background_color);
	(*dest).background_color = _tmp3_;
	_tmp4_ = (*self).text_color;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 ((*dest).text_color);
	(*dest).text_color = _tmp5_;
	(*dest).x = (*self).x;
	(*dest).y = (*self).y;
}

void
gala_daemon_monitor_label_info_destroy (GalaDaemonMonitorLabelInfo* self)
{
	_g_free0 ((*self).label);
	_g_free0 ((*self).background_color);
	_g_free0 ((*self).text_color);
}

GalaDaemonMonitorLabelInfo*
gala_daemon_monitor_label_info_dup (const GalaDaemonMonitorLabelInfo* self)
{
	GalaDaemonMonitorLabelInfo* dup;
	dup = g_new0 (GalaDaemonMonitorLabelInfo, 1);
	gala_daemon_monitor_label_info_copy (self, dup);
	return dup;
}

void
gala_daemon_monitor_label_info_free (GalaDaemonMonitorLabelInfo* self)
{
	gala_daemon_monitor_label_info_destroy (self);
	g_free (self);
}

static GType
gala_daemon_monitor_label_info_get_type_once (void)
{
	GType gala_daemon_monitor_label_info_type_id;
	gala_daemon_monitor_label_info_type_id = g_boxed_type_register_static ("GalaDaemonMonitorLabelInfo", (GBoxedCopyFunc) gala_daemon_monitor_label_info_dup, (GBoxedFreeFunc) gala_daemon_monitor_label_info_free);
	return gala_daemon_monitor_label_info_type_id;
}

GType
gala_daemon_monitor_label_info_get_type (void)
{
	static volatile gsize gala_daemon_monitor_label_info_type_id__once = 0;
	if (g_once_init_enter (&gala_daemon_monitor_label_info_type_id__once)) {
		GType gala_daemon_monitor_label_info_type_id;
		gala_daemon_monitor_label_info_type_id = gala_daemon_monitor_label_info_get_type_once ();
		g_once_init_leave (&gala_daemon_monitor_label_info_type_id__once, gala_daemon_monitor_label_info_type_id);
	}
	return gala_daemon_monitor_label_info_type_id__once;
}

static inline gpointer
gala_daemon_dbus_get_instance_private (GalaDaemonDBus* self)
{
	return G_STRUCT_MEMBER_P (self, GalaDaemonDBus_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
gala_daemon_dbus_on_gala_get (GalaDaemonDBus* self,
                              GObject* obj,
                              GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GalaWMDBus* _tmp0_ = NULL;
		GalaWMDBus* _tmp1_;
		GalaWMDBus* _tmp2_;
		GalaWMDBus* _tmp3_;
		_tmp1_ = g_async_result_get_source_object (res);
		_tmp2_ = (GalaWMDBus*) g_async_initable_new_finish ((GAsyncInitable *) _tmp1_, res, &_inner_error0_);
		g_object_unref (_tmp1_);
		_tmp0_ = (GalaWMDBus*) _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->wm_proxy);
		self->priv->wm_proxy = _tmp3_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("DBus.vala:96: Failed to get Gala proxy: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
gala_daemon_dbus_lost_gala (GalaDaemonDBus* self)
{
	g_return_if_fail (self != NULL);
	_g_object_unref0 (self->priv->wm_proxy);
	self->priv->wm_proxy = NULL;
}

static void
_gala_daemon_dbus_on_gala_get_gasync_ready_callback (GObject* source_object,
                                                     GAsyncResult* res,
                                                     gpointer self)
{
	gala_daemon_dbus_on_gala_get ((GalaDaemonDBus*) self, source_object, res);
	g_object_unref (self);
}

static void
gala_daemon_dbus_gala_appeared (GalaDaemonDBus* self)
{
	GalaWMDBus* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->wm_proxy;
	if (_tmp0_ == NULL) {
		g_async_initable_new_async (GALA_TYPE_WMD_BUS_PROXY, 0, NULL, _gala_daemon_dbus_on_gala_get_gasync_ready_callback, g_object_ref (self), "g-flags", 0, "g-name", GALA_DAEMON_DBUS_DBUS_NAME, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", GALA_DAEMON_DBUS_DBUS_OBJECT_PATH, "g-interface-name", "org.pantheon.gala", NULL);
	}
}

static void
gala_daemon_dbus_perform_action (GalaDaemonDBus* self,
                                 GalaActionType type)
{
	GalaWMDBus* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->wm_proxy;
	if (_tmp0_ != NULL) {
		{
			GalaWMDBus* _tmp1_;
			_tmp1_ = self->priv->wm_proxy;
			gala_wmd_bus_perform_action (_tmp1_, type, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp2_;
			const gchar* _tmp3_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp2_ = e;
			_tmp3_ = _tmp2_->message;
			g_warning ("DBus.vala:115: Failed to perform Gala action over DBus: %s", _tmp3_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

void
gala_daemon_dbus_show_window_menu (GalaDaemonDBus* self,
                                   GalaWindowFlags flags,
                                   gint display_width,
                                   gint display_height,
                                   gint x,
                                   gint y,
                                   GError** error)
{
	GalaDaemonWindowMenu* _tmp0_;
	GalaDaemonWindowMenu* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window_menu;
	gala_daemon_window_menu_update (_tmp0_, flags);
	_tmp1_ = self->priv->window_menu;
	gala_daemon_dbus_show_menu (self, (GtkPopover*) _tmp1_, display_width, display_height, x, y);
}

void
gala_daemon_dbus_show_desktop_menu (GalaDaemonDBus* self,
                                    gint display_width,
                                    gint display_height,
                                    gint x,
                                    gint y,
                                    GError** error)
{
	GtkPopoverMenu* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->background_menu;
	gala_daemon_dbus_show_menu (self, (GtkPopover*) _tmp0_, display_width, display_height, x, y);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		GalaDaemonDBus* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->menu);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static gboolean
__lambda15_ (Block2Data* _data2_)
{
	GalaDaemonDBus* self;
	gboolean result;
	self = _data2_->self;
	gtk_popover_popup (_data2_->menu);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda15__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda15_ (self);
	return result;
}

static void
gala_daemon_dbus_show_menu (GalaDaemonDBus* self,
                            GtkPopover* menu,
                            gint display_width,
                            gint display_height,
                            gint x,
                            gint y)
{
	Block2Data* _data2_;
	GtkPopover* _tmp0_;
	GalaDaemonWindow* _tmp4_;
	GtkWidget* _tmp5_;
	GtkWidget* _tmp6_;
	GalaDaemonWindow* _tmp7_;
	GtkWidget* _tmp8_;
	GtkWidget* _tmp9_;
	GalaDaemonWindow* _tmp10_;
	GdkRectangle rect = {0};
	GdkRectangle _tmp11_ = {0};
	GdkRectangle _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (menu != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (menu);
	_g_object_unref0 (_data2_->menu);
	_data2_->menu = _tmp0_;
	if (!gala_daemon_display_config_is_logical_layout ()) {
		gint scale_factor = 0;
		GalaDaemonWindow* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		_tmp1_ = self->priv->window;
		_tmp2_ = gtk_widget_get_scale_factor ((GtkWidget*) _tmp1_);
		_tmp3_ = _tmp2_;
		scale_factor = _tmp3_;
		display_width = display_width / scale_factor;
		display_height = display_height / scale_factor;
		x = x / scale_factor;
		y = y / scale_factor;
	}
	_tmp4_ = self->priv->window;
	_tmp5_ = gtk_window_get_child ((GtkWindow*) _tmp4_);
	_tmp6_ = _tmp5_;
	g_object_set (_tmp6_, "width-request", display_width, NULL);
	_tmp7_ = self->priv->window;
	_tmp8_ = gtk_window_get_child ((GtkWindow*) _tmp7_);
	_tmp9_ = _tmp8_;
	g_object_set (_tmp9_, "height-request", display_height, NULL);
	_tmp10_ = self->priv->window;
	gtk_window_present ((GtkWindow*) _tmp10_);
	_tmp11_.x = x;
	_tmp11_.y = y;
	_tmp11_.width = 0;
	_tmp11_.height = 0;
	rect = _tmp11_;
	_tmp12_ = rect;
	g_object_set (_data2_->menu, "pointing-to", &_tmp12_, NULL);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda15__gsource_func, block2_data_ref (_data2_), block2_data_unref);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}

void
gala_daemon_dbus_show_monitor_labels (GalaDaemonDBus* self,
                                      GalaDaemonMonitorLabelInfo* label_infos,
                                      gint label_infos_length1,
                                      GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	gala_daemon_dbus_hide_monitor_labels (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if ((_inner_error0_->domain == G_DBUS_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	(self->priv->monitor_labels == NULL) ? NULL : (self->priv->monitor_labels = (_g_list_free__g_object_unref0_ (self->priv->monitor_labels), NULL));
	self->priv->monitor_labels = NULL;
	{
		GalaDaemonMonitorLabelInfo* info_collection = NULL;
		gint info_collection_length1 = 0;
		gint _info_collection_size_ = 0;
		gint info_it = 0;
		info_collection = label_infos;
		info_collection_length1 = label_infos_length1;
		for (info_it = 0; info_it < info_collection_length1; info_it = info_it + 1) {
			GalaDaemonMonitorLabelInfo _tmp0_;
			GalaDaemonMonitorLabelInfo _tmp1_ = {0};
			GalaDaemonMonitorLabelInfo info = {0};
			_tmp0_ = info_collection[info_it];
			gala_daemon_monitor_label_info_copy (&_tmp0_, &_tmp1_);
			info = _tmp1_;
			{
				GalaDaemonMonitorLabel* label = NULL;
				GalaDaemonMonitorLabelInfo _tmp2_;
				GalaDaemonMonitorLabel* _tmp3_;
				GalaDaemonMonitorLabel* _tmp4_;
				GalaDaemonMonitorLabel* _tmp5_;
				GalaDaemonMonitorLabel* _tmp6_;
				_tmp2_ = info;
				_tmp3_ = gala_daemon_monitor_label_new (&_tmp2_);
				g_object_ref_sink (_tmp3_);
				label = _tmp3_;
				_tmp4_ = label;
				_tmp5_ = _g_object_ref0 (_tmp4_);
				self->priv->monitor_labels = g_list_append (self->priv->monitor_labels, _tmp5_);
				_tmp6_ = label;
				gtk_window_present ((GtkWindow*) _tmp6_);
				_g_object_unref0 (label);
				gala_daemon_monitor_label_info_destroy (&info);
			}
		}
	}
}

void
gala_daemon_dbus_hide_monitor_labels (GalaDaemonDBus* self,
                                      GError** error)
{
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->monitor_labels;
	{
		GList* monitor_label_collection = NULL;
		GList* monitor_label_it = NULL;
		monitor_label_collection = _tmp0_;
		for (monitor_label_it = monitor_label_collection; monitor_label_it != NULL; monitor_label_it = monitor_label_it->next) {
			GalaDaemonMonitorLabel* _tmp1_;
			GalaDaemonMonitorLabel* monitor_label = NULL;
			_tmp1_ = _g_object_ref0 ((GalaDaemonMonitorLabel*) monitor_label_it->data);
			monitor_label = _tmp1_;
			{
				GalaDaemonMonitorLabel* _tmp2_;
				_tmp2_ = monitor_label;
				gtk_window_close ((GtkWindow*) _tmp2_);
				_g_object_unref0 (monitor_label);
			}
		}
	}
}

static void
_gtk_window_destroy_gtk_dialog_response (GtkDialog* _sender,
                                         gint response_id,
                                         gpointer self)
{
	gtk_window_destroy ((GtkWindow*) self);
}

static void
gala_daemon_dbus_action_launch (GSimpleAction* action,
                                GVariant* variant)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (action != NULL);
	{
		const gchar* _tmp0_;
		_tmp0_ = g_variant_get_string (variant, NULL);
		g_app_info_launch_default_for_uri (_tmp0_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GraniteMessageDialog* message_dialog = NULL;
		GraniteMessageDialog* _tmp1_;
		GraniteMessageDialog* _tmp2_;
		GError* _tmp3_;
		const gchar* _tmp4_;
		GraniteMessageDialog* _tmp5_;
		GraniteMessageDialog* _tmp6_;
		GraniteMessageDialog* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = granite_message_dialog_new_with_image_from_icon_name (_ ("Failed to open System Settings"), _ ("A handler for the “settings://” URI scheme must be installed."), "dialog-error", GTK_BUTTONS_CLOSE);
		g_object_ref_sink (_tmp1_);
		message_dialog = _tmp1_;
		_tmp2_ = message_dialog;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		granite_message_dialog_show_error_details (_tmp2_, _tmp4_);
		_tmp5_ = message_dialog;
		gtk_window_present ((GtkWindow*) _tmp5_);
		_tmp6_ = message_dialog;
		_tmp7_ = message_dialog;
		g_signal_connect_object ((GtkDialog*) _tmp6_, "response", (GCallback) _gtk_window_destroy_gtk_dialog_response, (GtkWindow*) _tmp7_, 0);
		_g_object_unref0 (message_dialog);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

GalaDaemonDBus*
gala_daemon_dbus_construct (GType object_type)
{
	GalaDaemonDBus * self = NULL;
	self = (GalaDaemonDBus*) g_object_new (object_type, NULL);
	return self;
}

GalaDaemonDBus*
gala_daemon_dbus_new (void)
{
	return gala_daemon_dbus_construct (GALA_DAEMON_TYPE_DBUS);
}

static void
_gala_daemon_dbus_gala_appeared_gbus_name_appeared_callback (GDBusConnection* connection,
                                                             const gchar* name,
                                                             const gchar* name_owner,
                                                             gpointer self)
{
	gala_daemon_dbus_gala_appeared ((GalaDaemonDBus*) self);
}

static void
_gala_daemon_dbus_lost_gala_gbus_name_vanished_callback (GDBusConnection* connection,
                                                         const gchar* name,
                                                         gpointer self)
{
	gala_daemon_dbus_lost_gala ((GalaDaemonDBus*) self);
}

static GVariant*
_variant_new1 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new2 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new3 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static void
_gtk_window_close_gtk_popover_closed (GtkPopover* _sender,
                                      gpointer self)
{
	gtk_window_close ((GtkWindow*) self);
}

static void
_gala_daemon_dbus_action_launch_g_simple_action_activate (GSimpleAction* _sender,
                                                          GVariant* parameter,
                                                          gpointer self)
{
	gala_daemon_dbus_action_launch (_sender, parameter);
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		GalaDaemonDBus* self;
		self = _data3_->self;
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static gboolean
__lambda17_ (Block3Data* _data3_)
{
	GalaDaemonDBus* self;
	gboolean result;
	self = _data3_->self;
	gala_daemon_dbus_perform_action (self, _data3_->type);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda17__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda17_ (self);
	return result;
}

static void
_gala_daemon_dbus___lambda16_ (GalaDaemonDBus* self,
                               GalaActionType type)
{
	Block3Data* _data3_;
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_data3_->type = type;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda17__gsource_func, block3_data_ref (_data3_), block3_data_unref);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}

static void
__gala_daemon_dbus___lambda16__gala_daemon_window_menu_perform_action (GalaDaemonWindowMenu* _sender,
                                                                       GalaActionType type,
                                                                       gpointer self)
{
	_gala_daemon_dbus___lambda16_ ((GalaDaemonDBus*) self, type);
}

static GObject *
gala_daemon_dbus_constructor (GType type,
                              guint n_construct_properties,
                              GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaDaemonDBus * self;
	GalaDaemonWindow* _tmp0_;
	GMenu* background_menu_top_section = NULL;
	GMenu* _tmp1_;
	GMenu* _tmp2_;
	GVariant* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GMenu* _tmp6_;
	GVariant* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GMenu* background_menu_bottom_section = NULL;
	GMenu* _tmp10_;
	GMenu* _tmp11_;
	GVariant* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	GMenu* background_menu_model = NULL;
	GMenu* _tmp15_;
	GMenu* _tmp16_;
	GMenu* _tmp17_;
	GMenu* _tmp18_;
	GMenu* _tmp19_;
	GMenu* _tmp20_;
	GtkPopoverMenu* _tmp21_ = NULL;
	GtkPopoverMenu* _tmp22_;
	GalaDaemonWindow* _tmp23_;
	GtkWidget* _tmp24_;
	GtkWidget* _tmp25_;
	GtkPopoverMenu* _tmp26_;
	GalaDaemonWindow* _tmp27_;
	GSimpleAction* launch_action = NULL;
	const GVariantType* _tmp28_;
	GSimpleAction* _tmp29_;
	GSimpleAction* _tmp30_;
	GSimpleActionGroup* action_group = NULL;
	GSimpleActionGroup* _tmp31_;
	GSimpleActionGroup* _tmp32_;
	GSimpleAction* _tmp33_;
	GtkPopoverMenu* _tmp34_;
	GSimpleActionGroup* _tmp35_;
	GalaDaemonWindowMenu* _tmp36_;
	GalaDaemonWindowMenu* _tmp37_;
	GalaDaemonWindow* _tmp38_;
	GtkWidget* _tmp39_;
	GtkWidget* _tmp40_;
	GalaDaemonWindowMenu* _tmp41_;
	GalaDaemonWindow* _tmp42_;
	GalaDaemonWindowMenu* _tmp43_;
	parent_class = G_OBJECT_CLASS (gala_daemon_dbus_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_DAEMON_TYPE_DBUS, GalaDaemonDBus);
	g_bus_watch_name_with_closures (G_BUS_TYPE_SESSION, GALA_DAEMON_DBUS_DBUS_NAME, G_BUS_NAME_WATCHER_FLAGS_NONE, (GClosure*) ((_gala_daemon_dbus_gala_appeared_gbus_name_appeared_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _gala_daemon_dbus_gala_appeared_gbus_name_appeared_callback, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) ((_gala_daemon_dbus_lost_gala_gbus_name_vanished_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _gala_daemon_dbus_lost_gala_gbus_name_vanished_callback, g_object_ref (self), (GClosureNotify) g_object_unref)));
	_tmp0_ = gala_daemon_window_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->window);
	self->priv->window = _tmp0_;
	_tmp1_ = g_menu_new ();
	background_menu_top_section = _tmp1_;
	_tmp2_ = background_menu_top_section;
	_tmp3_ = _variant_new1 ("settings://desktop/appearance/wallpaper");
	_tmp4_ = g_action_print_detailed_name (GALA_DAEMON_DBUS_BG_MENU_ACTION_PREFIX "launch-uri", _tmp3_);
	_tmp5_ = _tmp4_;
	g_menu_append (_tmp2_, _ ("Change Wallpaper…"), _tmp5_);
	_g_free0 (_tmp5_);
	_g_variant_unref0 (_tmp3_);
	_tmp6_ = background_menu_top_section;
	_tmp7_ = _variant_new2 ("settings://display");
	_tmp8_ = g_action_print_detailed_name (GALA_DAEMON_DBUS_BG_MENU_ACTION_PREFIX "launch-uri", _tmp7_);
	_tmp9_ = _tmp8_;
	g_menu_append (_tmp6_, _ ("Display Settings…"), _tmp9_);
	_g_free0 (_tmp9_);
	_g_variant_unref0 (_tmp7_);
	_tmp10_ = g_menu_new ();
	background_menu_bottom_section = _tmp10_;
	_tmp11_ = background_menu_bottom_section;
	_tmp12_ = _variant_new3 ("settings://");
	_tmp13_ = g_action_print_detailed_name (GALA_DAEMON_DBUS_BG_MENU_ACTION_PREFIX "launch-uri", _tmp12_);
	_tmp14_ = _tmp13_;
	g_menu_append (_tmp11_, _ ("System Settings…"), _tmp14_);
	_g_free0 (_tmp14_);
	_g_variant_unref0 (_tmp12_);
	_tmp15_ = g_menu_new ();
	background_menu_model = _tmp15_;
	_tmp16_ = background_menu_model;
	_tmp17_ = background_menu_top_section;
	g_menu_append_section (_tmp16_, NULL, (GMenuModel*) _tmp17_);
	_tmp18_ = background_menu_model;
	_tmp19_ = background_menu_bottom_section;
	g_menu_append_section (_tmp18_, NULL, (GMenuModel*) _tmp19_);
	_tmp20_ = background_menu_model;
	_tmp21_ = (GtkPopoverMenu*) gtk_popover_menu_new_from_model ((GMenuModel*) _tmp20_);
	gtk_widget_set_halign ((GtkWidget*) _tmp21_, GTK_ALIGN_START);
	gtk_popover_set_position ((GtkPopover*) _tmp21_, GTK_POS_BOTTOM);
	gtk_popover_set_autohide ((GtkPopover*) _tmp21_, FALSE);
	gtk_popover_set_has_arrow ((GtkPopover*) _tmp21_, FALSE);
	g_object_ref_sink (_tmp21_);
	_g_object_unref0 (self->priv->background_menu);
	self->priv->background_menu = _tmp21_;
	_tmp22_ = self->priv->background_menu;
	_tmp23_ = self->priv->window;
	_tmp24_ = gtk_window_get_child ((GtkWindow*) _tmp23_);
	_tmp25_ = _tmp24_;
	gtk_widget_set_parent ((GtkWidget*) _tmp22_, _tmp25_);
	_tmp26_ = self->priv->background_menu;
	_tmp27_ = self->priv->window;
	g_signal_connect_object ((GtkPopover*) _tmp26_, "closed", (GCallback) _gtk_window_close_gtk_popover_closed, (GtkWindow*) _tmp27_, 0);
	_tmp28_ = G_VARIANT_TYPE_STRING;
	_tmp29_ = g_simple_action_new ("launch-uri", _tmp28_);
	launch_action = _tmp29_;
	_tmp30_ = launch_action;
	g_signal_connect (_tmp30_, "activate", (GCallback) _gala_daemon_dbus_action_launch_g_simple_action_activate, NULL);
	_tmp31_ = g_simple_action_group_new ();
	action_group = _tmp31_;
	_tmp32_ = action_group;
	_tmp33_ = launch_action;
	g_action_map_add_action ((GActionMap*) _tmp32_, (GAction*) _tmp33_);
	_tmp34_ = self->priv->background_menu;
	_tmp35_ = action_group;
	gtk_widget_insert_action_group ((GtkWidget*) _tmp34_, GALA_DAEMON_DBUS_BG_MENU_ACTION_GROUP_PREFIX, (GActionGroup*) _tmp35_);
	_tmp36_ = gala_daemon_window_menu_new ();
	g_object_ref_sink (_tmp36_);
	_g_object_unref0 (self->priv->window_menu);
	self->priv->window_menu = _tmp36_;
	_tmp37_ = self->priv->window_menu;
	_tmp38_ = self->priv->window;
	_tmp39_ = gtk_window_get_child ((GtkWindow*) _tmp38_);
	_tmp40_ = _tmp39_;
	gtk_widget_set_parent ((GtkWidget*) _tmp37_, _tmp40_);
	_tmp41_ = self->priv->window_menu;
	_tmp42_ = self->priv->window;
	g_signal_connect_object ((GtkPopover*) _tmp41_, "closed", (GCallback) _gtk_window_close_gtk_popover_closed, (GtkWindow*) _tmp42_, 0);
	_tmp43_ = self->priv->window_menu;
	g_signal_connect_object (_tmp43_, "perform-action", (GCallback) __gala_daemon_dbus___lambda16__gala_daemon_window_menu_perform_action, self, 0);
	_g_object_unref0 (action_group);
	_g_object_unref0 (launch_action);
	_g_object_unref0 (background_menu_model);
	_g_object_unref0 (background_menu_bottom_section);
	_g_object_unref0 (background_menu_top_section);
	return obj;
}

static void
gala_daemon_dbus_class_init (GalaDaemonDBusClass * klass,
                             gpointer klass_data)
{
	gala_daemon_dbus_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaDaemonDBus_private_offset);
	G_OBJECT_CLASS (klass)->constructor = gala_daemon_dbus_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_daemon_dbus_finalize;
}

static void
gala_daemon_dbus_instance_init (GalaDaemonDBus * self,
                                gpointer klass)
{
	self->priv = gala_daemon_dbus_get_instance_private (self);
	self->priv->wm_proxy = NULL;
	self->priv->monitor_labels = NULL;
}

static void
gala_daemon_dbus_finalize (GObject * obj)
{
	GalaDaemonDBus * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_DAEMON_TYPE_DBUS, GalaDaemonDBus);
	_g_object_unref0 (self->priv->wm_proxy);
	_g_object_unref0 (self->priv->window);
	_g_object_unref0 (self->priv->window_menu);
	_g_object_unref0 (self->priv->background_menu);
	(self->priv->monitor_labels == NULL) ? NULL : (self->priv->monitor_labels = (_g_list_free__g_object_unref0_ (self->priv->monitor_labels), NULL));
	G_OBJECT_CLASS (gala_daemon_dbus_parent_class)->finalize (obj);
}

static GType
gala_daemon_dbus_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaDaemonDBusClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_daemon_dbus_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaDaemonDBus), 0, (GInstanceInitFunc) gala_daemon_dbus_instance_init, NULL };
	GType gala_daemon_dbus_type_id;
	gala_daemon_dbus_type_id = g_type_register_static (G_TYPE_OBJECT, "GalaDaemonDBus", &g_define_type_info, 0);
	g_type_set_qdata (gala_daemon_dbus_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) gala_daemon_dbus_register_object);
	GalaDaemonDBus_private_offset = g_type_add_instance_private (gala_daemon_dbus_type_id, sizeof (GalaDaemonDBusPrivate));
	return gala_daemon_dbus_type_id;
}

GType
gala_daemon_dbus_get_type (void)
{
	static volatile gsize gala_daemon_dbus_type_id__once = 0;
	if (g_once_init_enter (&gala_daemon_dbus_type_id__once)) {
		GType gala_daemon_dbus_type_id;
		gala_daemon_dbus_type_id = gala_daemon_dbus_get_type_once ();
		g_once_init_leave (&gala_daemon_dbus_type_id__once, gala_daemon_dbus_type_id);
	}
	return gala_daemon_dbus_type_id__once;
}

static void
_dbus_gala_daemon_dbus_show_window_menu (GalaDaemonDBus* self,
                                         GVariant* _parameters_,
                                         GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GalaWindowFlags flags = 0U;
	GVariant* _tmp107_;
	gint display_width = 0;
	GVariant* _tmp108_;
	gint display_height = 0;
	GVariant* _tmp109_;
	gint x = 0;
	GVariant* _tmp110_;
	gint y = 0;
	GVariant* _tmp111_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp107_ = g_variant_iter_next_value (&_arguments_iter);
	flags = g_variant_get_uint32 (_tmp107_);
	g_variant_unref (_tmp107_);
	_tmp108_ = g_variant_iter_next_value (&_arguments_iter);
	display_width = g_variant_get_int32 (_tmp108_);
	g_variant_unref (_tmp108_);
	_tmp109_ = g_variant_iter_next_value (&_arguments_iter);
	display_height = g_variant_get_int32 (_tmp109_);
	g_variant_unref (_tmp109_);
	_tmp110_ = g_variant_iter_next_value (&_arguments_iter);
	x = g_variant_get_int32 (_tmp110_);
	g_variant_unref (_tmp110_);
	_tmp111_ = g_variant_iter_next_value (&_arguments_iter);
	y = g_variant_get_int32 (_tmp111_);
	g_variant_unref (_tmp111_);
	gala_daemon_dbus_show_window_menu (self, flags, display_width, display_height, x, y, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_gala_daemon_dbus_show_desktop_menu (GalaDaemonDBus* self,
                                          GVariant* _parameters_,
                                          GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gint display_width = 0;
	GVariant* _tmp112_;
	gint display_height = 0;
	GVariant* _tmp113_;
	gint x = 0;
	GVariant* _tmp114_;
	gint y = 0;
	GVariant* _tmp115_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp112_ = g_variant_iter_next_value (&_arguments_iter);
	display_width = g_variant_get_int32 (_tmp112_);
	g_variant_unref (_tmp112_);
	_tmp113_ = g_variant_iter_next_value (&_arguments_iter);
	display_height = g_variant_get_int32 (_tmp113_);
	g_variant_unref (_tmp113_);
	_tmp114_ = g_variant_iter_next_value (&_arguments_iter);
	x = g_variant_get_int32 (_tmp114_);
	g_variant_unref (_tmp114_);
	_tmp115_ = g_variant_iter_next_value (&_arguments_iter);
	y = g_variant_get_int32 (_tmp115_);
	g_variant_unref (_tmp115_);
	gala_daemon_dbus_show_desktop_menu (self, display_width, display_height, x, y, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_vala_GalaDaemonMonitorLabelInfo_array_free (GalaDaemonMonitorLabelInfo * array,
                                             gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			gala_daemon_monitor_label_info_destroy (&array[i]);
		}
	}
	g_free (array);
}

static void
_dbus_gala_daemon_dbus_show_monitor_labels (GalaDaemonDBus* self,
                                            GVariant* _parameters_,
                                            GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GalaDaemonMonitorLabelInfo* label_infos = NULL;
	gint label_infos_length1 = 0;
	GVariant* _tmp116_;
	GalaDaemonMonitorLabelInfo* _tmp117_;
	gint _tmp117__length;
	gint _tmp117__size;
	gint _tmp117__length1;
	GVariantIter _tmp118_;
	GVariant* _tmp119_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp116_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp117_ = g_new (GalaDaemonMonitorLabelInfo, 5);
	_tmp117__length = 0;
	_tmp117__size = 4;
	_tmp117__length1 = 0;
	g_variant_iter_init (&_tmp118_, _tmp116_);
	for (; (_tmp119_ = g_variant_iter_next_value (&_tmp118_)) != NULL; _tmp117__length1++) {
		GalaDaemonMonitorLabelInfo _tmp120_;
		GVariantIter _tmp121_;
		GVariant* _tmp122_;
		GVariant* _tmp123_;
		GVariant* _tmp124_;
		GVariant* _tmp125_;
		GVariant* _tmp126_;
		GVariant* _tmp127_;
		if (_tmp117__size == _tmp117__length) {
			_tmp117__size = 2 * _tmp117__size;
			_tmp117_ = g_renew (GalaDaemonMonitorLabelInfo, _tmp117_, _tmp117__size + 1);
		}
		g_variant_iter_init (&_tmp121_, _tmp119_);
		_tmp122_ = g_variant_iter_next_value (&_tmp121_);
		_tmp120_.monitor = g_variant_get_int32 (_tmp122_);
		g_variant_unref (_tmp122_);
		_tmp123_ = g_variant_iter_next_value (&_tmp121_);
		_tmp120_.label = g_variant_dup_string (_tmp123_, NULL);
		g_variant_unref (_tmp123_);
		_tmp124_ = g_variant_iter_next_value (&_tmp121_);
		_tmp120_.background_color = g_variant_dup_string (_tmp124_, NULL);
		g_variant_unref (_tmp124_);
		_tmp125_ = g_variant_iter_next_value (&_tmp121_);
		_tmp120_.text_color = g_variant_dup_string (_tmp125_, NULL);
		g_variant_unref (_tmp125_);
		_tmp126_ = g_variant_iter_next_value (&_tmp121_);
		_tmp120_.x = g_variant_get_int32 (_tmp126_);
		g_variant_unref (_tmp126_);
		_tmp127_ = g_variant_iter_next_value (&_tmp121_);
		_tmp120_.y = g_variant_get_int32 (_tmp127_);
		g_variant_unref (_tmp127_);
		_tmp117_[_tmp117__length++] = _tmp120_;
		g_variant_unref (_tmp119_);
	}
	label_infos_length1 = _tmp117__length1;
	label_infos = _tmp117_;
	g_variant_unref (_tmp116_);
	gala_daemon_dbus_show_monitor_labels (self, label_infos, label_infos_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	label_infos = (_vala_GalaDaemonMonitorLabelInfo_array_free (label_infos, label_infos_length1), NULL);
	;
}

static void
_dbus_gala_daemon_dbus_hide_monitor_labels (GalaDaemonDBus* self,
                                            GVariant* _parameters_,
                                            GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	gala_daemon_dbus_hide_monitor_labels (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
gala_daemon_dbus_dbus_interface_method_call (GDBusConnection* connection,
                                             const gchar* sender,
                                             const gchar* object_path,
                                             const gchar* interface_name,
                                             const gchar* method_name,
                                             GVariant* parameters,
                                             GDBusMethodInvocation* invocation,
                                             gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "ShowWindowMenu") == 0) {
		_dbus_gala_daemon_dbus_show_window_menu (object, parameters, invocation);
	} else if (strcmp (method_name, "ShowDesktopMenu") == 0) {
		_dbus_gala_daemon_dbus_show_desktop_menu (object, parameters, invocation);
	} else if (strcmp (method_name, "ShowMonitorLabels") == 0) {
		_dbus_gala_daemon_dbus_show_monitor_labels (object, parameters, invocation);
	} else if (strcmp (method_name, "HideMonitorLabels") == 0) {
		_dbus_gala_daemon_dbus_hide_monitor_labels (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
gala_daemon_dbus_dbus_interface_get_property (GDBusConnection* connection,
                                              const gchar* sender,
                                              const gchar* object_path,
                                              const gchar* interface_name,
                                              const gchar* property_name,
                                              GError** error,
                                              gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
gala_daemon_dbus_dbus_interface_set_property (GDBusConnection* connection,
                                              const gchar* sender,
                                              const gchar* object_path,
                                              const gchar* interface_name,
                                              const gchar* property_name,
                                              GVariant* value,
                                              GError** error,
                                              gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
gala_daemon_dbus_register_object (gpointer object,
                                  GDBusConnection* connection,
                                  const gchar* path,
                                  GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_gala_daemon_dbus_dbus_interface_info), &_gala_daemon_dbus_dbus_interface_vtable, data, _gala_daemon_dbus_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_gala_daemon_dbus_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

