/* signal-manager.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from signal-manager.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include <glib-object.h>
#include <gee.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define FOLKS_INSPECT_TYPE_SIGNAL_MANAGER (folks_inspect_signal_manager_get_type ())
#define FOLKS_INSPECT_SIGNAL_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_TYPE_SIGNAL_MANAGER, FolksInspectSignalManager))
#define FOLKS_INSPECT_SIGNAL_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_TYPE_SIGNAL_MANAGER, FolksInspectSignalManagerClass))
#define FOLKS_INSPECT_IS_SIGNAL_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_TYPE_SIGNAL_MANAGER))
#define FOLKS_INSPECT_IS_SIGNAL_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_TYPE_SIGNAL_MANAGER))
#define FOLKS_INSPECT_SIGNAL_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_TYPE_SIGNAL_MANAGER, FolksInspectSignalManagerClass))

typedef struct _FolksInspectSignalManager FolksInspectSignalManager;
typedef struct _FolksInspectSignalManagerClass FolksInspectSignalManagerClass;
typedef struct _FolksInspectSignalManagerPrivate FolksInspectSignalManagerPrivate;
enum  {
	FOLKS_INSPECT_SIGNAL_MANAGER_0_PROPERTY,
	FOLKS_INSPECT_SIGNAL_MANAGER_NUM_PROPERTIES
};
static GParamSpec* folks_inspect_signal_manager_properties[FOLKS_INSPECT_SIGNAL_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_closure_unref0(var) ((var == NULL) ? NULL : (var = (g_closure_unref (var), NULL)))
#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))

struct _FolksInspectSignalManager {
	GObject parent_instance;
	FolksInspectSignalManagerPrivate * priv;
};

struct _FolksInspectSignalManagerClass {
	GObjectClass parent_class;
};

struct _FolksInspectSignalManagerPrivate {
	GeeHashMap* signals_by_class_type;
	GeeHashMap* signals_by_class_instance;
};

static gint FolksInspectSignalManager_private_offset;
static gpointer folks_inspect_signal_manager_parent_class = NULL;

VALA_EXTERN GType folks_inspect_signal_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FolksInspectSignalManager, g_object_unref)
VALA_EXTERN FolksInspectSignalManager* folks_inspect_signal_manager_new (void);
VALA_EXTERN FolksInspectSignalManager* folks_inspect_signal_manager_construct (GType object_type);
VALA_EXTERN void folks_inspect_signal_manager_list_signals (FolksInspectSignalManager* self,
                                                GType class_type,
                                                GObject* class_instance);
VALA_EXTERN void folks_inspect_utils_print_line (const gchar* format,
                                     ...)  G_GNUC_PRINTF(1,2) ;
VALA_EXTERN void folks_inspect_utils_indent (void);
static void folks_inspect_signal_manager_list_signals_for_type (FolksInspectSignalManager* self,
                                                         GType type,
                                                         GeeHashMap* signal_id_map);
VALA_EXTERN void folks_inspect_utils_unindent (void);
VALA_EXTERN void folks_inspect_signal_manager_show_signal_details (FolksInspectSignalManager* self,
                                                       GType class_type,
                                                       const gchar* signal_name,
                                                       const gchar* detail_string);
static gchar* folks_inspect_signal_manager_signal_flags_to_string (GSignalFlags flags);
VALA_EXTERN guint folks_inspect_signal_manager_connect_to_signal (FolksInspectSignalManager* self,
                                                      GType class_type,
                                                      GObject* class_instance,
                                                      const gchar* signal_name,
                                                      const gchar* detail_string);
static gboolean folks_inspect_signal_manager_add_emission_hook (FolksInspectSignalManager* self,
                                                         GType class_type,
                                                         guint signal_id,
                                                         const gchar* detail_string);
static void folks_inspect_signal_manager_add_signal_handler (FolksInspectSignalManager* self,
                                                      GObject* class_instance,
                                                      guint signal_id,
                                                      const gchar* detail_string);
VALA_EXTERN guint folks_inspect_signal_manager_disconnect_from_signal (FolksInspectSignalManager* self,
                                                           GType class_type,
                                                           GObject* class_instance,
                                                           const gchar* signal_name,
                                                           const gchar* detail_string);
static gboolean folks_inspect_signal_manager_remove_emission_hook (FolksInspectSignalManager* self,
                                                            GType class_type,
                                                            guint signal_id);
static gboolean folks_inspect_signal_manager_remove_signal_handler (FolksInspectSignalManager* self,
                                                             GObject* class_instance,
                                                             guint signal_id);
static void folks_inspect_signal_manager_signal_meta_marshaller (GClosure* closure,
                                                          GValue** return_value,
                                                          GValue* param_values,
                                                          gint param_values_length1,
                                                          void* invocation_hint,
                                                          void* marshal_data);
static void _folks_inspect_signal_manager_signal_meta_marshaller_gclosure_marshal (GClosure* closure,
                                                                            GValue* return_value,
                                                                            guint n_param_values,
                                                                            GValue* param_values,
                                                                            void* invocation_hint,
                                                                            void* marshal_data);
static void _vala_GValue_free (GValue* self);
VALA_EXTERN gchar* folks_inspect_utils_transform_value_to_string (GValue* prop_value);
static gboolean folks_inspect_signal_manager_emission_hook_cb (FolksInspectSignalManager* self,
                                                        GSignalInvocationHint* hint,
                                                        GValue* param_values,
                                                        gint param_values_length1);
static gboolean _folks_inspect_signal_manager_emission_hook_cb_gsignal_emission_hook (GSignalInvocationHint* ihint,
                                                                               guint n_param_values,
                                                                               GValue* param_values,
                                                                               gpointer self);
static void folks_inspect_signal_manager_finalize (GObject * obj);
static GType folks_inspect_signal_manager_get_type_once (void);

static inline gpointer
folks_inspect_signal_manager_get_instance_private (FolksInspectSignalManager* self)
{
	return G_STRUCT_MEMBER_P (self, FolksInspectSignalManager_private_offset);
}

FolksInspectSignalManager*
folks_inspect_signal_manager_construct (GType object_type)
{
	FolksInspectSignalManager * self = NULL;
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	self = (FolksInspectSignalManager*) g_object_new (object_type, NULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_GTYPE, NULL, NULL, GEE_TYPE_HASH_MAP, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->signals_by_class_type);
	self->priv->signals_by_class_type = _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_OBJECT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, GEE_TYPE_HASH_MAP, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->signals_by_class_instance);
	self->priv->signals_by_class_instance = _tmp1_;
	return self;
}

FolksInspectSignalManager*
folks_inspect_signal_manager_new (void)
{
	return folks_inspect_signal_manager_construct (FOLKS_INSPECT_TYPE_SIGNAL_MANAGER);
}

void
folks_inspect_signal_manager_list_signals (FolksInspectSignalManager* self,
                                           GType class_type,
                                           GObject* class_instance)
{
	g_return_if_fail (self != NULL);
	if (class_type != G_TYPE_INVALID) {
		GeeHashMap* hook_ids = NULL;
		GeeHashMap* _tmp0_;
		gpointer _tmp1_;
		const gchar* _tmp2_;
		GeeHashMap* _tmp3_;
		_tmp0_ = self->priv->signals_by_class_type;
		_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, (gpointer) ((gintptr) class_type));
		hook_ids = (GeeHashMap*) _tmp1_;
		_tmp2_ = g_type_name (class_type);
		folks_inspect_utils_print_line ("Signals on all instances of class type '%s':", _tmp2_);
		folks_inspect_utils_indent ();
		_tmp3_ = hook_ids;
		folks_inspect_signal_manager_list_signals_for_type (self, class_type, _tmp3_);
		folks_inspect_utils_unindent ();
		_g_object_unref0 (hook_ids);
	} else {
		if (class_instance != NULL) {
			GeeHashMap* signal_handler_ids = NULL;
			GeeHashMap* _tmp4_;
			gpointer _tmp5_;
			const gchar* _tmp6_;
			GeeHashMap* _tmp7_;
			_tmp4_ = self->priv->signals_by_class_instance;
			_tmp5_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, class_instance);
			signal_handler_ids = (GeeHashMap*) _tmp5_;
			_tmp6_ = g_type_name (G_TYPE_FROM_INSTANCE (class_instance));
			folks_inspect_utils_print_line ("Signals on instance %p of class type '%s':", class_instance, _tmp6_);
			folks_inspect_utils_indent ();
			_tmp7_ = signal_handler_ids;
			folks_inspect_signal_manager_list_signals_for_type (self, G_TYPE_FROM_INSTANCE (class_instance), _tmp7_);
			folks_inspect_utils_unindent ();
			_g_object_unref0 (signal_handler_ids);
		} else {
			GeeMapIterator* class_type_iter = NULL;
			GeeHashMap* _tmp8_;
			GeeMapIterator* _tmp9_;
			GeeMapIterator* class_instance_iter = NULL;
			GeeHashMap* _tmp24_;
			GeeMapIterator* _tmp25_;
			_tmp8_ = self->priv->signals_by_class_type;
			_tmp9_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp8_);
			class_type_iter = _tmp9_;
			folks_inspect_utils_print_line ("Connected signals on all instances of classes:");
			folks_inspect_utils_indent ();
			while (TRUE) {
				GeeMapIterator* _tmp10_;
				GeeHashMap* hook_ids = NULL;
				GeeMapIterator* _tmp11_;
				gpointer _tmp12_;
				GeeMapIterator* hook_iter = NULL;
				GeeHashMap* _tmp13_;
				GeeMapIterator* _tmp14_;
				gchar* class_name = NULL;
				GeeMapIterator* _tmp15_;
				gpointer _tmp16_;
				const gchar* _tmp17_;
				gchar* _tmp18_;
				_tmp10_ = class_type_iter;
				if (!(gee_map_iterator_next (_tmp10_) == TRUE)) {
					break;
				}
				_tmp11_ = class_type_iter;
				_tmp12_ = gee_map_iterator_get_value (_tmp11_);
				hook_ids = (GeeHashMap*) _tmp12_;
				_tmp13_ = hook_ids;
				_tmp14_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp13_);
				hook_iter = _tmp14_;
				_tmp15_ = class_type_iter;
				_tmp16_ = gee_map_iterator_get_key (_tmp15_);
				_tmp17_ = g_type_name ((GType) ((gintptr) _tmp16_));
				_tmp18_ = g_strdup (_tmp17_);
				class_name = _tmp18_;
				while (TRUE) {
					GeeMapIterator* _tmp19_;
					const gchar* _tmp20_;
					GeeMapIterator* _tmp21_;
					gpointer _tmp22_;
					const gchar* _tmp23_;
					_tmp19_ = hook_iter;
					if (!(gee_map_iterator_next (_tmp19_) == TRUE)) {
						break;
					}
					_tmp20_ = class_name;
					_tmp21_ = hook_iter;
					_tmp22_ = gee_map_iterator_get_key (_tmp21_);
					_tmp23_ = g_signal_name ((guint) ((guintptr) _tmp22_));
					folks_inspect_utils_print_line ("%s::%s — connected", _tmp20_, _tmp23_);
				}
				_g_free0 (class_name);
				_g_object_unref0 (hook_iter);
				_g_object_unref0 (hook_ids);
			}
			folks_inspect_utils_unindent ();
			_tmp24_ = self->priv->signals_by_class_instance;
			_tmp25_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp24_);
			class_instance_iter = _tmp25_;
			folks_inspect_utils_print_line ("%s", "Connected signals on specific instances of " "classes:");
			folks_inspect_utils_indent ();
			while (TRUE) {
				GeeMapIterator* _tmp26_;
				GeeHashMap* signal_handler_ids = NULL;
				GeeMapIterator* _tmp27_;
				gpointer _tmp28_;
				GeeMapIterator* signal_handler_iter = NULL;
				GeeHashMap* _tmp29_;
				GeeMapIterator* _tmp30_;
				gchar* class_name = NULL;
				GeeMapIterator* _tmp31_;
				gpointer _tmp32_;
				GObject* _tmp33_;
				const gchar* _tmp34_;
				gchar* _tmp35_;
				gchar* _tmp36_;
				_tmp26_ = class_instance_iter;
				if (!(gee_map_iterator_next (_tmp26_) == TRUE)) {
					break;
				}
				_tmp27_ = class_instance_iter;
				_tmp28_ = gee_map_iterator_get_value (_tmp27_);
				signal_handler_ids = (GeeHashMap*) _tmp28_;
				_tmp29_ = signal_handler_ids;
				_tmp30_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp29_);
				signal_handler_iter = _tmp30_;
				_tmp31_ = class_instance_iter;
				_tmp32_ = gee_map_iterator_get_key (_tmp31_);
				_tmp33_ = (GObject*) _tmp32_;
				_tmp34_ = g_type_name (G_TYPE_FROM_INSTANCE (_tmp33_));
				_tmp35_ = g_strdup (_tmp34_);
				_tmp36_ = _tmp35_;
				_g_object_unref0 (_tmp33_);
				class_name = _tmp36_;
				while (TRUE) {
					GeeMapIterator* _tmp37_;
					const gchar* _tmp38_;
					GeeMapIterator* _tmp39_;
					gpointer _tmp40_;
					const gchar* _tmp41_;
					_tmp37_ = signal_handler_iter;
					if (!(gee_map_iterator_next (_tmp37_) == TRUE)) {
						break;
					}
					_tmp38_ = class_name;
					_tmp39_ = signal_handler_iter;
					_tmp40_ = gee_map_iterator_get_key (_tmp39_);
					_tmp41_ = g_signal_name ((guint) ((guintptr) _tmp40_));
					folks_inspect_utils_print_line ("%s::%s — connected", _tmp38_, _tmp41_);
				}
				_g_free0 (class_name);
				_g_object_unref0 (signal_handler_iter);
				_g_object_unref0 (signal_handler_ids);
			}
			folks_inspect_utils_unindent ();
			_g_object_unref0 (class_instance_iter);
			_g_object_unref0 (class_type_iter);
		}
	}
}

void
folks_inspect_signal_manager_show_signal_details (FolksInspectSignalManager* self,
                                                  GType class_type,
                                                  const gchar* signal_name,
                                                  const gchar* detail_string)
{
	guint signal_id = 0U;
	GSignalQuery query_info = {0};
	GSignalQuery _tmp1_ = {0};
	GSignalQuery _tmp2_;
	GSignalQuery _tmp3_;
	const gchar* _tmp4_;
	GSignalQuery _tmp5_;
	const gchar* _tmp6_;
	GSignalQuery _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GSignalQuery _tmp10_;
	const gchar* _tmp11_;
	g_return_if_fail (self != NULL);
	signal_id = g_signal_lookup (signal_name, class_type);
	if (signal_id == ((guint) 0)) {
		const gchar* _tmp0_;
		_tmp0_ = g_type_name (class_type);
		folks_inspect_utils_print_line ("Unrecognised signal name '%s' on class '%s'.", signal_name, _tmp0_);
		return;
	}
	g_signal_query (signal_id, &_tmp1_);
	query_info = _tmp1_;
	_tmp2_ = query_info;
	folks_inspect_utils_print_line ("Signal ID        %u", _tmp2_.signal_id);
	_tmp3_ = query_info;
	_tmp4_ = _tmp3_.signal_name;
	folks_inspect_utils_print_line ("Signal name      %s", _tmp4_);
	_tmp5_ = query_info;
	_tmp6_ = g_type_name (_tmp5_.itype);
	folks_inspect_utils_print_line ("Emitting type    %s", _tmp6_);
	_tmp7_ = query_info;
	_tmp8_ = folks_inspect_signal_manager_signal_flags_to_string (_tmp7_.signal_flags);
	_tmp9_ = _tmp8_;
	folks_inspect_utils_print_line ("Signal flags     %s", _tmp9_);
	_g_free0 (_tmp9_);
	_tmp10_ = query_info;
	_tmp11_ = g_type_name (_tmp10_.return_type);
	folks_inspect_utils_print_line ("Return type      %s", _tmp11_);
	folks_inspect_utils_print_line ("Parameter types:");
	folks_inspect_utils_indent ();
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp12_ = FALSE;
			_tmp12_ = TRUE;
			while (TRUE) {
				GSignalQuery _tmp14_;
				GSignalQuery _tmp15_;
				GType* _tmp16_;
				gint _tmp16__length1;
				GType _tmp17_;
				const gchar* _tmp18_;
				if (!_tmp12_) {
					guint _tmp13_;
					_tmp13_ = i;
					i = _tmp13_ + 1;
				}
				_tmp12_ = FALSE;
				_tmp14_ = query_info;
				if (!(i < _tmp14_.n_params)) {
					break;
				}
				_tmp15_ = query_info;
				_tmp16_ = _tmp15_.param_types;
				_tmp16__length1 = _tmp15_.n_params;
				_tmp17_ = _tmp16_[i];
				_tmp18_ = g_type_name (_tmp17_);
				folks_inspect_utils_print_line ("%-4u  %s", i, _tmp18_);
			}
		}
	}
	folks_inspect_utils_unindent ();
}

guint
folks_inspect_signal_manager_connect_to_signal (FolksInspectSignalManager* self,
                                                GType class_type,
                                                GObject* class_instance,
                                                const gchar* signal_name,
                                                const gchar* detail_string)
{
	gboolean _tmp0_ = FALSE;
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	if (class_type != G_TYPE_INVALID) {
		_tmp0_ = signal_name != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		guint signal_id = 0U;
		signal_id = g_signal_lookup (signal_name, class_type);
		if (signal_id == ((guint) 0)) {
			const gchar* _tmp1_;
			_tmp1_ = g_type_name (class_type);
			folks_inspect_utils_print_line ("Unrecognised signal name '%s' on class '%s'.", signal_name, _tmp1_);
			result = (guint) 0;
			return result;
		}
		if (folks_inspect_signal_manager_add_emission_hook (self, class_type, signal_id, detail_string) == FALSE) {
			const gchar* _tmp2_;
			_tmp2_ = g_type_name (class_type);
			folks_inspect_utils_print_line ("Not allowed to connect to signal '%s' on " "class '%s'.", signal_name, _tmp2_);
			result = (guint) 0;
			return result;
		}
		result = (guint) 1;
		return result;
	} else {
		gboolean _tmp3_ = FALSE;
		if (class_type != G_TYPE_INVALID) {
			_tmp3_ = signal_name == NULL;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			guint* signal_ids = NULL;
			guint _tmp4_ = 0;
			guint* _tmp5_;
			gint signal_ids_length1;
			gint _signal_ids_size_;
			guint signal_count = 0U;
			guint* _tmp6_;
			gint _tmp6__length1;
			_tmp5_ = g_signal_list_ids (class_type, &_tmp4_);
			signal_ids = _tmp5_;
			signal_ids_length1 = _tmp4_;
			_signal_ids_size_ = signal_ids_length1;
			signal_count = (guint) 0;
			_tmp6_ = signal_ids;
			_tmp6__length1 = signal_ids_length1;
			{
				guint* signal_id_collection = NULL;
				gint signal_id_collection_length1 = 0;
				gint _signal_id_collection_size_ = 0;
				gint signal_id_it = 0;
				signal_id_collection = _tmp6_;
				signal_id_collection_length1 = _tmp6__length1;
				for (signal_id_it = 0; signal_id_it < signal_id_collection_length1; signal_id_it = signal_id_it + 1) {
					guint signal_id = 0U;
					signal_id = signal_id_collection[signal_id_it];
					{
						if (folks_inspect_signal_manager_add_emission_hook (self, class_type, signal_id, NULL) == TRUE) {
							guint _tmp7_;
							_tmp7_ = signal_count;
							signal_count = _tmp7_ + 1;
						}
					}
				}
			}
			result = signal_count;
			signal_ids = (g_free (signal_ids), NULL);
			return result;
		} else {
			gboolean _tmp8_ = FALSE;
			if (class_instance != NULL) {
				_tmp8_ = signal_name != NULL;
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				guint signal_id = 0U;
				signal_id = g_signal_lookup (signal_name, G_TYPE_FROM_INSTANCE (class_instance));
				if (signal_id == ((guint) 0)) {
					const gchar* _tmp9_;
					_tmp9_ = g_type_name (G_TYPE_FROM_INSTANCE (class_instance));
					folks_inspect_utils_print_line ("Unrecognised signal name '%s' on instance " "%p of class '%s'.", signal_name, class_instance, _tmp9_);
					result = (guint) 0;
					return result;
				}
				folks_inspect_signal_manager_add_signal_handler (self, class_instance, signal_id, detail_string);
				result = (guint) 1;
				return result;
			} else {
				gboolean _tmp10_ = FALSE;
				if (class_instance != NULL) {
					_tmp10_ = signal_name == NULL;
				} else {
					_tmp10_ = FALSE;
				}
				if (_tmp10_) {
					guint* signal_ids = NULL;
					guint _tmp11_ = 0;
					guint* _tmp12_;
					gint signal_ids_length1;
					gint _signal_ids_size_;
					guint signal_count = 0U;
					guint* _tmp13_;
					gint _tmp13__length1;
					_tmp12_ = g_signal_list_ids (G_TYPE_FROM_INSTANCE (class_instance), &_tmp11_);
					signal_ids = _tmp12_;
					signal_ids_length1 = _tmp11_;
					_signal_ids_size_ = signal_ids_length1;
					signal_count = (guint) 0;
					_tmp13_ = signal_ids;
					_tmp13__length1 = signal_ids_length1;
					{
						guint* signal_id_collection = NULL;
						gint signal_id_collection_length1 = 0;
						gint _signal_id_collection_size_ = 0;
						gint signal_id_it = 0;
						signal_id_collection = _tmp13_;
						signal_id_collection_length1 = _tmp13__length1;
						for (signal_id_it = 0; signal_id_it < signal_id_collection_length1; signal_id_it = signal_id_it + 1) {
							guint signal_id = 0U;
							signal_id = signal_id_collection[signal_id_it];
							{
								guint _tmp14_;
								_tmp14_ = signal_count;
								signal_count = _tmp14_ + 1;
								folks_inspect_signal_manager_add_signal_handler (self, class_instance, signal_id, NULL);
							}
						}
					}
					result = signal_count;
					signal_ids = (g_free (signal_ids), NULL);
					return result;
				}
			}
		}
	}
	g_assert_not_reached ();
}

guint
folks_inspect_signal_manager_disconnect_from_signal (FolksInspectSignalManager* self,
                                                     GType class_type,
                                                     GObject* class_instance,
                                                     const gchar* signal_name,
                                                     const gchar* detail_string)
{
	gboolean _tmp0_ = FALSE;
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	if (class_type != G_TYPE_INVALID) {
		_tmp0_ = signal_name != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		guint signal_id = 0U;
		signal_id = g_signal_lookup (signal_name, class_type);
		if (signal_id == ((guint) 0)) {
			const gchar* _tmp1_;
			_tmp1_ = g_type_name (class_type);
			folks_inspect_utils_print_line ("Unrecognised signal name '%s' on class '%s'.", signal_name, _tmp1_);
			result = (guint) 0;
			return result;
		}
		if (folks_inspect_signal_manager_remove_emission_hook (self, class_type, signal_id) == FALSE) {
			const gchar* _tmp2_;
			_tmp2_ = g_type_name (class_type);
			folks_inspect_utils_print_line ("Could not remove hook for signal '%s' on " "class '%s'.", signal_name, _tmp2_);
			result = (guint) 0;
			return result;
		}
		result = (guint) 1;
		return result;
	} else {
		gboolean _tmp3_ = FALSE;
		if (class_type != G_TYPE_INVALID) {
			_tmp3_ = signal_name == NULL;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			guint* signal_ids = NULL;
			guint _tmp4_ = 0;
			guint* _tmp5_;
			gint signal_ids_length1;
			gint _signal_ids_size_;
			guint signal_count = 0U;
			guint* _tmp6_;
			gint _tmp6__length1;
			_tmp5_ = g_signal_list_ids (class_type, &_tmp4_);
			signal_ids = _tmp5_;
			signal_ids_length1 = _tmp4_;
			_signal_ids_size_ = signal_ids_length1;
			signal_count = (guint) 0;
			_tmp6_ = signal_ids;
			_tmp6__length1 = signal_ids_length1;
			{
				guint* signal_id_collection = NULL;
				gint signal_id_collection_length1 = 0;
				gint _signal_id_collection_size_ = 0;
				gint signal_id_it = 0;
				signal_id_collection = _tmp6_;
				signal_id_collection_length1 = _tmp6__length1;
				for (signal_id_it = 0; signal_id_it < signal_id_collection_length1; signal_id_it = signal_id_it + 1) {
					guint signal_id = 0U;
					signal_id = signal_id_collection[signal_id_it];
					{
						if (folks_inspect_signal_manager_remove_emission_hook (self, class_type, signal_id) == TRUE) {
							guint _tmp7_;
							_tmp7_ = signal_count;
							signal_count = _tmp7_ - 1;
						}
					}
				}
			}
			result = signal_count;
			signal_ids = (g_free (signal_ids), NULL);
			return result;
		} else {
			gboolean _tmp8_ = FALSE;
			if (class_instance != NULL) {
				_tmp8_ = signal_name != NULL;
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				guint signal_id = 0U;
				signal_id = g_signal_lookup (signal_name, G_TYPE_FROM_INSTANCE (class_instance));
				if (signal_id == ((guint) 0)) {
					const gchar* _tmp9_;
					_tmp9_ = g_type_name (G_TYPE_FROM_INSTANCE (class_instance));
					folks_inspect_utils_print_line ("Unrecognised signal name '%s' on instance " "%p of class '%s'.", signal_name, class_instance, _tmp9_);
					result = (guint) 0;
					return result;
				}
				folks_inspect_signal_manager_remove_signal_handler (self, class_instance, signal_id);
				result = (guint) 1;
				return result;
			} else {
				gboolean _tmp10_ = FALSE;
				if (class_instance != NULL) {
					_tmp10_ = signal_name == NULL;
				} else {
					_tmp10_ = FALSE;
				}
				if (_tmp10_) {
					guint* signal_ids = NULL;
					guint _tmp11_ = 0;
					guint* _tmp12_;
					gint signal_ids_length1;
					gint _signal_ids_size_;
					guint signal_count = 0U;
					guint* _tmp13_;
					gint _tmp13__length1;
					_tmp12_ = g_signal_list_ids (G_TYPE_FROM_INSTANCE (class_instance), &_tmp11_);
					signal_ids = _tmp12_;
					signal_ids_length1 = _tmp11_;
					_signal_ids_size_ = signal_ids_length1;
					signal_count = (guint) 0;
					_tmp13_ = signal_ids;
					_tmp13__length1 = signal_ids_length1;
					{
						guint* signal_id_collection = NULL;
						gint signal_id_collection_length1 = 0;
						gint _signal_id_collection_size_ = 0;
						gint signal_id_it = 0;
						signal_id_collection = _tmp13_;
						signal_id_collection_length1 = _tmp13__length1;
						for (signal_id_it = 0; signal_id_it < signal_id_collection_length1; signal_id_it = signal_id_it + 1) {
							guint signal_id = 0U;
							signal_id = signal_id_collection[signal_id_it];
							{
								if (folks_inspect_signal_manager_remove_signal_handler (self, class_instance, signal_id)) {
									guint _tmp14_;
									_tmp14_ = signal_count;
									signal_count = _tmp14_ - 1;
								}
							}
						}
					}
					result = signal_count;
					signal_ids = (g_free (signal_ids), NULL);
					return result;
				}
			}
		}
	}
	g_assert_not_reached ();
}

static void
folks_inspect_signal_manager_list_signals_for_type (FolksInspectSignalManager* self,
                                                    GType type,
                                                    GeeHashMap* signal_id_map)
{
	guint* signal_ids = NULL;
	guint _tmp0_ = 0;
	guint* _tmp1_;
	gint signal_ids_length1;
	gint _signal_ids_size_;
	guint* _tmp2_;
	gint _tmp2__length1;
	GType* interfaces = NULL;
	guint _tmp12_ = 0;
	GType* _tmp13_;
	gint interfaces_length1;
	gint _interfaces_size_;
	GType* _tmp14_;
	gint _tmp14__length1;
	GType parent_type = 0UL;
	g_return_if_fail (self != NULL);
	_tmp1_ = g_signal_list_ids (type, &_tmp0_);
	signal_ids = _tmp1_;
	signal_ids_length1 = _tmp0_;
	_signal_ids_size_ = signal_ids_length1;
	_tmp2_ = signal_ids;
	_tmp2__length1 = signal_ids_length1;
	if (_tmp2_ != NULL) {
		gchar* type_name = NULL;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		guint* _tmp5_;
		gint _tmp5__length1;
		_tmp3_ = g_type_name (type);
		_tmp4_ = g_strdup (_tmp3_);
		type_name = _tmp4_;
		_tmp5_ = signal_ids;
		_tmp5__length1 = signal_ids_length1;
		{
			guint* signal_id_collection = NULL;
			gint signal_id_collection_length1 = 0;
			gint _signal_id_collection_size_ = 0;
			gint signal_id_it = 0;
			signal_id_collection = _tmp5_;
			signal_id_collection_length1 = _tmp5__length1;
			for (signal_id_it = 0; signal_id_it < signal_id_collection_length1; signal_id_it = signal_id_it + 1) {
				guint signal_id = 0U;
				signal_id = signal_id_collection[signal_id_it];
				{
					const gchar* signal_name = NULL;
					const gchar* _tmp6_;
					gboolean _tmp7_ = FALSE;
					_tmp6_ = g_signal_name (signal_id);
					signal_name = _tmp6_;
					if (signal_id_map != NULL) {
						_tmp7_ = gee_abstract_map_has_key ((GeeAbstractMap*) signal_id_map, (gpointer) ((guintptr) signal_id)) == TRUE;
					} else {
						_tmp7_ = FALSE;
					}
					if (_tmp7_) {
						const gchar* _tmp8_;
						const gchar* _tmp9_;
						_tmp8_ = type_name;
						_tmp9_ = signal_name;
						folks_inspect_utils_print_line ("%s::%s — connected", _tmp8_, _tmp9_);
					} else {
						const gchar* _tmp10_;
						const gchar* _tmp11_;
						_tmp10_ = type_name;
						_tmp11_ = signal_name;
						folks_inspect_utils_print_line ("%s::%s", _tmp10_, _tmp11_);
					}
				}
			}
		}
		_g_free0 (type_name);
	}
	_tmp13_ = g_type_interfaces (type, &_tmp12_);
	interfaces = _tmp13_;
	interfaces_length1 = _tmp12_;
	_interfaces_size_ = interfaces_length1;
	_tmp14_ = interfaces;
	_tmp14__length1 = interfaces_length1;
	{
		GType* interface_type_collection = NULL;
		gint interface_type_collection_length1 = 0;
		gint _interface_type_collection_size_ = 0;
		gint interface_type_it = 0;
		interface_type_collection = _tmp14_;
		interface_type_collection_length1 = _tmp14__length1;
		for (interface_type_it = 0; interface_type_it < interface_type_collection_length1; interface_type_it = interface_type_it + 1) {
			GType interface_type = 0UL;
			interface_type = interface_type_collection[interface_type_it];
			{
				folks_inspect_signal_manager_list_signals_for_type (self, interface_type, signal_id_map);
			}
		}
	}
	parent_type = g_type_parent (type);
	if (parent_type != G_TYPE_INVALID) {
		folks_inspect_signal_manager_list_signals_for_type (self, parent_type, signal_id_map);
	}
	interfaces = (g_free (interfaces), NULL);
	signal_ids = (g_free (signal_ids), NULL);
}

static void
_folks_inspect_signal_manager_signal_meta_marshaller_gclosure_marshal (GClosure* closure,
                                                                       GValue* return_value,
                                                                       guint n_param_values,
                                                                       GValue* param_values,
                                                                       void* invocation_hint,
                                                                       void* marshal_data)
{
	folks_inspect_signal_manager_signal_meta_marshaller (closure, return_value, param_values, n_param_values, invocation_hint, marshal_data);
}

static void
folks_inspect_signal_manager_add_signal_handler (FolksInspectSignalManager* self,
                                                 GObject* class_instance,
                                                 guint signal_id,
                                                 const gchar* detail_string)
{
	GClosure* closure = NULL;
	GClosure* _tmp0_;
	GClosure* _tmp1_;
	GQuark detail_quark = 0U;
	gulong signal_handler_id = 0UL;
	GClosure* _tmp2_;
	GeeHashMap* signal_handler_ids = NULL;
	GeeHashMap* _tmp3_;
	gpointer _tmp4_;
	GeeHashMap* _tmp5_;
	GeeHashMap* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (class_instance != NULL);
	_tmp0_ = g_closure_new_object ((gulong) sizeof (GClosure), (GObject*) self);
	closure = _tmp0_;
	_tmp1_ = closure;
	g_closure_set_meta_marshal (_tmp1_, NULL, _folks_inspect_signal_manager_signal_meta_marshaller_gclosure_marshal);
	detail_quark = (GQuark) 0;
	if (detail_string != NULL) {
		detail_quark = g_quark_try_string (detail_string);
	}
	_tmp2_ = closure;
	signal_handler_id = g_signal_connect_closure_by_id (class_instance, signal_id, detail_quark, _tmp2_, FALSE);
	_tmp3_ = self->priv->signals_by_class_instance;
	_tmp4_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp3_, class_instance);
	signal_handler_ids = (GeeHashMap*) _tmp4_;
	_tmp5_ = signal_handler_ids;
	if (_tmp5_ == NULL) {
		GeeHashMap* _tmp6_;
		GeeHashMap* _tmp7_;
		GeeHashMap* _tmp8_;
		_tmp6_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, G_TYPE_ULONG, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		_g_object_unref0 (signal_handler_ids);
		signal_handler_ids = _tmp6_;
		_tmp7_ = self->priv->signals_by_class_instance;
		_tmp8_ = signal_handler_ids;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp7_, class_instance, _tmp8_);
	}
	_tmp9_ = signal_handler_ids;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp9_, (gpointer) ((guintptr) signal_id), (gpointer) ((guintptr) signal_handler_id));
	_g_object_unref0 (signal_handler_ids);
	_g_closure_unref0 (closure);
}

static gboolean
folks_inspect_signal_manager_remove_signal_handler (FolksInspectSignalManager* self,
                                                    GObject* class_instance,
                                                    guint signal_id)
{
	GeeHashMap* signal_handler_ids = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	gboolean _tmp2_ = FALSE;
	GeeHashMap* _tmp3_;
	gulong signal_handler_id = 0UL;
	GeeHashMap* _tmp5_;
	gpointer _tmp6_;
	GeeHashMap* _tmp7_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (class_instance != NULL, FALSE);
	_tmp0_ = self->priv->signals_by_class_instance;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, class_instance);
	signal_handler_ids = (GeeHashMap*) _tmp1_;
	_tmp3_ = signal_handler_ids;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		GeeHashMap* _tmp4_;
		_tmp4_ = signal_handler_ids;
		_tmp2_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp4_, (gpointer) ((guintptr) signal_id)) == FALSE;
	}
	if (_tmp2_) {
		result = FALSE;
		_g_object_unref0 (signal_handler_ids);
		return result;
	}
	_tmp5_ = signal_handler_ids;
	_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp5_, (gpointer) ((guintptr) signal_id));
	signal_handler_id = (gulong) ((guintptr) _tmp6_);
	g_signal_handler_disconnect (class_instance, signal_handler_id);
	_tmp7_ = signal_handler_ids;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp7_, (gpointer) ((guintptr) signal_id), NULL);
	result = TRUE;
	_g_object_unref0 (signal_handler_ids);
	return result;
}

static void
_vala_GValue_free (GValue* self)
{
	g_boxed_free (G_TYPE_VALUE, self);
}

static void
folks_inspect_signal_manager_signal_meta_marshaller (GClosure* closure,
                                                     GValue** return_value,
                                                     GValue* param_values,
                                                     gint param_values_length1,
                                                     void* invocation_hint,
                                                     void* marshal_data)
{
	GValue* _vala_return_value = NULL;
	GSignalInvocationHint* hint = NULL;
	GSignalQuery query_info = {0};
	GSignalInvocationHint* _tmp0_;
	GSignalQuery _tmp1_ = {0};
	GSignalQuery _tmp2_;
	const gchar* _tmp3_;
	GSignalQuery _tmp4_;
	const gchar* _tmp5_;
	guint i = 0U;
	g_return_if_fail (closure != NULL);
	hint = (GSignalInvocationHint*) invocation_hint;
	__vala_GValue_free0 (_vala_return_value);
	_vala_return_value = NULL;
	_tmp0_ = hint;
	g_signal_query ((*_tmp0_).signal_id, &_tmp1_);
	query_info = _tmp1_;
	_tmp2_ = query_info;
	_tmp3_ = g_type_name (_tmp2_.itype);
	_tmp4_ = query_info;
	_tmp5_ = _tmp4_.signal_name;
	folks_inspect_utils_print_line ("Signal '%s::%s' emitted with parameters:", _tmp3_, _tmp5_);
	folks_inspect_utils_indent ();
	i = (guint) 0;
	{
		GValue* param_value_collection = NULL;
		gint param_value_collection_length1 = 0;
		gint _param_value_collection_size_ = 0;
		gint param_value_it = 0;
		param_value_collection = param_values;
		param_value_collection_length1 = param_values_length1;
		for (param_value_it = 0; param_value_it < param_value_collection_length1; param_value_it = param_value_it + 1) {
			GValue _tmp6_;
			GValue _tmp7_ = {0};
			GValue param_value = {0};
			_tmp6_ = param_value_collection[param_value_it];
			if (G_IS_VALUE (&_tmp6_)) {
				g_value_init (&_tmp7_, G_VALUE_TYPE (&_tmp6_));
				g_value_copy (&_tmp6_, &_tmp7_);
			} else {
				_tmp7_ = _tmp6_;
			}
			param_value = _tmp7_;
			{
				guint _tmp8_;
				const gchar* _tmp9_;
				GValue _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				_tmp8_ = i;
				i = _tmp8_ + 1;
				_tmp9_ = g_type_name (G_VALUE_TYPE (&param_value));
				_tmp10_ = param_value;
				_tmp11_ = folks_inspect_utils_transform_value_to_string (&_tmp10_);
				_tmp12_ = _tmp11_;
				folks_inspect_utils_print_line ("%-4u  %-10s  %s", _tmp8_, _tmp9_, _tmp12_);
				_g_free0 (_tmp12_);
				G_IS_VALUE (&param_value) ? (g_value_unset (&param_value), NULL) : NULL;
			}
		}
	}
	folks_inspect_utils_unindent ();
	if (return_value) {
		*return_value = _vala_return_value;
	} else {
		__vala_GValue_free0 (_vala_return_value);
	}
}

static gboolean
_folks_inspect_signal_manager_emission_hook_cb_gsignal_emission_hook (GSignalInvocationHint* ihint,
                                                                      guint n_param_values,
                                                                      GValue* param_values,
                                                                      gpointer self)
{
	gboolean result;
	result = folks_inspect_signal_manager_emission_hook_cb ((FolksInspectSignalManager*) self, ihint, param_values, n_param_values);
	return result;
}

static gboolean
folks_inspect_signal_manager_add_emission_hook (FolksInspectSignalManager* self,
                                                GType class_type,
                                                guint signal_id,
                                                const gchar* detail_string)
{
	GQuark detail_quark = 0U;
	GSignalQuery query = {0};
	GSignalQuery _tmp0_ = {0};
	GSignalQuery _tmp1_;
	gulong hook_id = 0UL;
	GeeHashMap* hook_ids = NULL;
	GeeHashMap* _tmp2_;
	gpointer _tmp3_;
	GeeHashMap* _tmp4_;
	GeeHashMap* _tmp8_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	detail_quark = (GQuark) 0;
	if (detail_string != NULL) {
		detail_quark = g_quark_try_string (detail_string);
	}
	g_signal_query (signal_id, &_tmp0_);
	query = _tmp0_;
	_tmp1_ = query;
	if ((_tmp1_.signal_flags & G_SIGNAL_NO_HOOKS) != 0) {
		result = FALSE;
		return result;
	}
	hook_id = g_signal_add_emission_hook (signal_id, detail_quark, _folks_inspect_signal_manager_emission_hook_cb_gsignal_emission_hook, g_object_ref (self), g_object_unref);
	_tmp2_ = self->priv->signals_by_class_type;
	_tmp3_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp2_, (gpointer) ((gintptr) class_type));
	hook_ids = (GeeHashMap*) _tmp3_;
	_tmp4_ = hook_ids;
	if (_tmp4_ == NULL) {
		GeeHashMap* _tmp5_;
		GeeHashMap* _tmp6_;
		GeeHashMap* _tmp7_;
		_tmp5_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, G_TYPE_ULONG, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		_g_object_unref0 (hook_ids);
		hook_ids = _tmp5_;
		_tmp6_ = self->priv->signals_by_class_type;
		_tmp7_ = hook_ids;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp6_, (gpointer) ((gintptr) class_type), _tmp7_);
	}
	_tmp8_ = hook_ids;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp8_, (gpointer) ((guintptr) signal_id), (gpointer) ((guintptr) hook_id));
	result = TRUE;
	_g_object_unref0 (hook_ids);
	return result;
}

static gboolean
folks_inspect_signal_manager_remove_emission_hook (FolksInspectSignalManager* self,
                                                   GType class_type,
                                                   guint signal_id)
{
	GeeHashMap* hook_ids = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	gboolean _tmp2_ = FALSE;
	GeeHashMap* _tmp3_;
	gulong hook_id = 0UL;
	GeeHashMap* _tmp5_;
	gpointer _tmp6_;
	GeeHashMap* _tmp7_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->signals_by_class_type;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, (gpointer) ((gintptr) class_type));
	hook_ids = (GeeHashMap*) _tmp1_;
	_tmp3_ = hook_ids;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		GeeHashMap* _tmp4_;
		_tmp4_ = hook_ids;
		_tmp2_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp4_, (gpointer) ((guintptr) signal_id)) == FALSE;
	}
	if (_tmp2_) {
		result = FALSE;
		_g_object_unref0 (hook_ids);
		return result;
	}
	_tmp5_ = hook_ids;
	_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp5_, (gpointer) ((guintptr) signal_id));
	hook_id = (gulong) ((guintptr) _tmp6_);
	g_signal_remove_emission_hook (signal_id, hook_id);
	_tmp7_ = hook_ids;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp7_, (gpointer) ((guintptr) signal_id), NULL);
	result = TRUE;
	_g_object_unref0 (hook_ids);
	return result;
}

static gboolean
folks_inspect_signal_manager_emission_hook_cb (FolksInspectSignalManager* self,
                                               GSignalInvocationHint* hint,
                                               GValue* param_values,
                                               gint param_values_length1)
{
	GSignalQuery query_info = {0};
	GSignalInvocationHint _tmp0_;
	GSignalQuery _tmp1_ = {0};
	GSignalQuery _tmp2_;
	const gchar* _tmp3_;
	GSignalQuery _tmp4_;
	const gchar* _tmp5_;
	guint i = 0U;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (hint != NULL, FALSE);
	_tmp0_ = *hint;
	g_signal_query (_tmp0_.signal_id, &_tmp1_);
	query_info = _tmp1_;
	_tmp2_ = query_info;
	_tmp3_ = g_type_name (_tmp2_.itype);
	_tmp4_ = query_info;
	_tmp5_ = _tmp4_.signal_name;
	folks_inspect_utils_print_line ("Signal '%s::%s' emitted with parameters:", _tmp3_, _tmp5_);
	folks_inspect_utils_indent ();
	i = (guint) 0;
	{
		GValue* param_value_collection = NULL;
		gint param_value_collection_length1 = 0;
		gint _param_value_collection_size_ = 0;
		gint param_value_it = 0;
		param_value_collection = param_values;
		param_value_collection_length1 = param_values_length1;
		for (param_value_it = 0; param_value_it < param_value_collection_length1; param_value_it = param_value_it + 1) {
			GValue _tmp6_;
			GValue _tmp7_ = {0};
			GValue param_value = {0};
			_tmp6_ = param_value_collection[param_value_it];
			if (G_IS_VALUE (&_tmp6_)) {
				g_value_init (&_tmp7_, G_VALUE_TYPE (&_tmp6_));
				g_value_copy (&_tmp6_, &_tmp7_);
			} else {
				_tmp7_ = _tmp6_;
			}
			param_value = _tmp7_;
			{
				guint _tmp8_;
				const gchar* _tmp9_;
				GValue _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				_tmp8_ = i;
				i = _tmp8_ + 1;
				_tmp9_ = g_type_name (G_VALUE_TYPE (&param_value));
				_tmp10_ = param_value;
				_tmp11_ = folks_inspect_utils_transform_value_to_string (&_tmp10_);
				_tmp12_ = _tmp11_;
				folks_inspect_utils_print_line ("%-4u  %-10s  %s", _tmp8_, _tmp9_, _tmp12_);
				_g_free0 (_tmp12_);
				G_IS_VALUE (&param_value) ? (g_value_unset (&param_value), NULL) : NULL;
			}
		}
	}
	folks_inspect_utils_unindent ();
	result = TRUE;
	return result;
}

static gchar*
folks_inspect_signal_manager_signal_flags_to_string (GSignalFlags flags)
{
	gchar* output = NULL;
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_strdup ("");
	output = _tmp0_;
	if ((flags & G_SIGNAL_RUN_FIRST) != 0) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = output;
		_tmp2_ = g_strconcat (_tmp1_, "G_SIGNAL_RUN_FIRST", NULL);
		_g_free0 (output);
		output = _tmp2_;
	}
	if ((flags & G_SIGNAL_RUN_LAST) != 0) {
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp4_ = output;
		if (g_strcmp0 (_tmp4_, "") != 0) {
			_tmp3_ = " | ";
		} else {
			_tmp3_ = "";
		}
		_tmp5_ = output;
		_tmp6_ = g_strconcat (_tmp3_, "G_SIGNAL_RUN_LAST", NULL);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strconcat (_tmp5_, _tmp7_, NULL);
		_g_free0 (output);
		output = _tmp8_;
		_g_free0 (_tmp7_);
	}
	if ((flags & G_SIGNAL_RUN_CLEANUP) != 0) {
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp10_ = output;
		if (g_strcmp0 (_tmp10_, "") != 0) {
			_tmp9_ = " | ";
		} else {
			_tmp9_ = "";
		}
		_tmp11_ = output;
		_tmp12_ = g_strconcat (_tmp9_, "G_SIGNAL_RUN_CLEANUP", NULL);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strconcat (_tmp11_, _tmp13_, NULL);
		_g_free0 (output);
		output = _tmp14_;
		_g_free0 (_tmp13_);
	}
	if ((flags & G_SIGNAL_DETAILED) != 0) {
		const gchar* _tmp15_ = NULL;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		_tmp16_ = output;
		if (g_strcmp0 (_tmp16_, "") != 0) {
			_tmp15_ = " | ";
		} else {
			_tmp15_ = "";
		}
		_tmp17_ = output;
		_tmp18_ = g_strconcat (_tmp15_, "G_SIGNAL_DETAILED", NULL);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_strconcat (_tmp17_, _tmp19_, NULL);
		_g_free0 (output);
		output = _tmp20_;
		_g_free0 (_tmp19_);
	}
	if ((flags & G_SIGNAL_ACTION) != 0) {
		const gchar* _tmp21_ = NULL;
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		_tmp22_ = output;
		if (g_strcmp0 (_tmp22_, "") != 0) {
			_tmp21_ = " | ";
		} else {
			_tmp21_ = "";
		}
		_tmp23_ = output;
		_tmp24_ = g_strconcat (_tmp21_, "G_SIGNAL_ACTION", NULL);
		_tmp25_ = _tmp24_;
		_tmp26_ = g_strconcat (_tmp23_, _tmp25_, NULL);
		_g_free0 (output);
		output = _tmp26_;
		_g_free0 (_tmp25_);
	}
	if ((flags & G_SIGNAL_NO_HOOKS) != 0) {
		const gchar* _tmp27_ = NULL;
		const gchar* _tmp28_;
		const gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		_tmp28_ = output;
		if (g_strcmp0 (_tmp28_, "") != 0) {
			_tmp27_ = " | ";
		} else {
			_tmp27_ = "";
		}
		_tmp29_ = output;
		_tmp30_ = g_strconcat (_tmp27_, "G_SIGNAL_NO_HOOKS", NULL);
		_tmp31_ = _tmp30_;
		_tmp32_ = g_strconcat (_tmp29_, _tmp31_, NULL);
		_g_free0 (output);
		output = _tmp32_;
		_g_free0 (_tmp31_);
	}
	result = output;
	return result;
}

static void
folks_inspect_signal_manager_class_init (FolksInspectSignalManagerClass * klass,
                                         gpointer klass_data)
{
	folks_inspect_signal_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FolksInspectSignalManager_private_offset);
	G_OBJECT_CLASS (klass)->finalize = folks_inspect_signal_manager_finalize;
}

static void
folks_inspect_signal_manager_instance_init (FolksInspectSignalManager * self,
                                            gpointer klass)
{
	self->priv = folks_inspect_signal_manager_get_instance_private (self);
}

static void
folks_inspect_signal_manager_finalize (GObject * obj)
{
	FolksInspectSignalManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_INSPECT_TYPE_SIGNAL_MANAGER, FolksInspectSignalManager);
	_g_object_unref0 (self->priv->signals_by_class_type);
	_g_object_unref0 (self->priv->signals_by_class_instance);
	G_OBJECT_CLASS (folks_inspect_signal_manager_parent_class)->finalize (obj);
}

static GType
folks_inspect_signal_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FolksInspectSignalManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_inspect_signal_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksInspectSignalManager), 0, (GInstanceInitFunc) folks_inspect_signal_manager_instance_init, NULL };
	GType folks_inspect_signal_manager_type_id;
	folks_inspect_signal_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "FolksInspectSignalManager", &g_define_type_info, 0);
	FolksInspectSignalManager_private_offset = g_type_add_instance_private (folks_inspect_signal_manager_type_id, sizeof (FolksInspectSignalManagerPrivate));
	return folks_inspect_signal_manager_type_id;
}

GType
folks_inspect_signal_manager_get_type (void)
{
	static volatile gsize folks_inspect_signal_manager_type_id__once = 0;
	if (g_once_init_enter (&folks_inspect_signal_manager_type_id__once)) {
		GType folks_inspect_signal_manager_type_id;
		folks_inspect_signal_manager_type_id = folks_inspect_signal_manager_get_type_once ();
		g_once_init_leave (&folks_inspect_signal_manager_type_id__once, folks_inspect_signal_manager_type_id);
	}
	return folks_inspect_signal_manager_type_id__once;
}

