// SPDX-License-Identifier: BSD-2-Clause
/*
  Copyright (c) Matthias Schiffer <mschiffer@universe-factory.net>
  All rights reserved.
*/

/**
   \file

   Generated list of supported method providers
*/


#include "method.h"


extern const fastd_method_provider_t fastd_method_composed_gmac;
extern const fastd_method_provider_t fastd_method_composed_umac;
extern const fastd_method_provider_t fastd_method_generic_gmac;
extern const fastd_method_provider_t fastd_method_generic_poly1305;
extern const fastd_method_provider_t fastd_method_generic_umac;
extern const fastd_method_provider_t fastd_method_null;
extern const fastd_method_provider_t fastd_method_null_l2tp;


/** The list of method providers */
static const fastd_method_provider_t *const providers[] = {
	&fastd_method_composed_gmac,
&fastd_method_composed_umac,
&fastd_method_generic_gmac,
&fastd_method_generic_poly1305,
&fastd_method_generic_umac,
&fastd_method_null,
&fastd_method_null_l2tp,

};


bool fastd_method_create_by_name(const char *name, const fastd_method_provider_t **provider, fastd_method_t **method) {
	size_t i;
	for (i = 0; i < array_size(providers); i++) {
		if (providers[i]->create_by_name(name, method)) {
			*provider = providers[i];
			return true;
		}
	}

	return false;
}
