// Code generated by go-swagger; DO NOT EDIT.

// Copyright Authors of Cilium
// SPDX-License-Identifier: Apache-2.0

package endpoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	stderrors "errors"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/cilium/cilium/api/v1/models"
)

// GetEndpointIDLabelsReader is a Reader for the GetEndpointIDLabels structure.
type GetEndpointIDLabelsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetEndpointIDLabelsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (any, error) {
	switch response.Code() {
	case 200:
		result := NewGetEndpointIDLabelsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 404:
		result := NewGetEndpointIDLabelsNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewGetEndpointIDLabelsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /endpoint/{id}/labels] GetEndpointIDLabels", response, response.Code())
	}
}

// NewGetEndpointIDLabelsOK creates a GetEndpointIDLabelsOK with default headers values
func NewGetEndpointIDLabelsOK() *GetEndpointIDLabelsOK {
	return &GetEndpointIDLabelsOK{}
}

/*
GetEndpointIDLabelsOK describes a response with status code 200, with default header values.

Success
*/
type GetEndpointIDLabelsOK struct {
	Payload *models.LabelConfiguration
}

// IsSuccess returns true when this get endpoint Id labels o k response has a 2xx status code
func (o *GetEndpointIDLabelsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get endpoint Id labels o k response has a 3xx status code
func (o *GetEndpointIDLabelsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get endpoint Id labels o k response has a 4xx status code
func (o *GetEndpointIDLabelsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get endpoint Id labels o k response has a 5xx status code
func (o *GetEndpointIDLabelsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get endpoint Id labels o k response a status code equal to that given
func (o *GetEndpointIDLabelsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get endpoint Id labels o k response
func (o *GetEndpointIDLabelsOK) Code() int {
	return 200
}

func (o *GetEndpointIDLabelsOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /endpoint/{id}/labels][%d] getEndpointIdLabelsOK %s", 200, payload)
}

func (o *GetEndpointIDLabelsOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /endpoint/{id}/labels][%d] getEndpointIdLabelsOK %s", 200, payload)
}

func (o *GetEndpointIDLabelsOK) GetPayload() *models.LabelConfiguration {
	return o.Payload
}

func (o *GetEndpointIDLabelsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.LabelConfiguration)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && !stderrors.Is(err, io.EOF) {
		return err
	}

	return nil
}

// NewGetEndpointIDLabelsNotFound creates a GetEndpointIDLabelsNotFound with default headers values
func NewGetEndpointIDLabelsNotFound() *GetEndpointIDLabelsNotFound {
	return &GetEndpointIDLabelsNotFound{}
}

/*
GetEndpointIDLabelsNotFound describes a response with status code 404, with default header values.

Endpoint not found
*/
type GetEndpointIDLabelsNotFound struct {
}

// IsSuccess returns true when this get endpoint Id labels not found response has a 2xx status code
func (o *GetEndpointIDLabelsNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get endpoint Id labels not found response has a 3xx status code
func (o *GetEndpointIDLabelsNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get endpoint Id labels not found response has a 4xx status code
func (o *GetEndpointIDLabelsNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this get endpoint Id labels not found response has a 5xx status code
func (o *GetEndpointIDLabelsNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this get endpoint Id labels not found response a status code equal to that given
func (o *GetEndpointIDLabelsNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the get endpoint Id labels not found response
func (o *GetEndpointIDLabelsNotFound) Code() int {
	return 404
}

func (o *GetEndpointIDLabelsNotFound) Error() string {
	return fmt.Sprintf("[GET /endpoint/{id}/labels][%d] getEndpointIdLabelsNotFound", 404)
}

func (o *GetEndpointIDLabelsNotFound) String() string {
	return fmt.Sprintf("[GET /endpoint/{id}/labels][%d] getEndpointIdLabelsNotFound", 404)
}

func (o *GetEndpointIDLabelsNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewGetEndpointIDLabelsTooManyRequests creates a GetEndpointIDLabelsTooManyRequests with default headers values
func NewGetEndpointIDLabelsTooManyRequests() *GetEndpointIDLabelsTooManyRequests {
	return &GetEndpointIDLabelsTooManyRequests{}
}

/*
GetEndpointIDLabelsTooManyRequests describes a response with status code 429, with default header values.

Rate-limiting too many requests in the given time frame
*/
type GetEndpointIDLabelsTooManyRequests struct {
}

// IsSuccess returns true when this get endpoint Id labels too many requests response has a 2xx status code
func (o *GetEndpointIDLabelsTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get endpoint Id labels too many requests response has a 3xx status code
func (o *GetEndpointIDLabelsTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get endpoint Id labels too many requests response has a 4xx status code
func (o *GetEndpointIDLabelsTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this get endpoint Id labels too many requests response has a 5xx status code
func (o *GetEndpointIDLabelsTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this get endpoint Id labels too many requests response a status code equal to that given
func (o *GetEndpointIDLabelsTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the get endpoint Id labels too many requests response
func (o *GetEndpointIDLabelsTooManyRequests) Code() int {
	return 429
}

func (o *GetEndpointIDLabelsTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /endpoint/{id}/labels][%d] getEndpointIdLabelsTooManyRequests", 429)
}

func (o *GetEndpointIDLabelsTooManyRequests) String() string {
	return fmt.Sprintf("[GET /endpoint/{id}/labels][%d] getEndpointIdLabelsTooManyRequests", 429)
}

func (o *GetEndpointIDLabelsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}
