#ifndef BOTAN_TARGET_INFO_H_
#define BOTAN_TARGET_INFO_H_

#include <botan/build.h>

/**
* @file  target_info.h
*
* Automatically generated from
* 'configure.py --prefix=/usr --with-bzip --with-lzma --with-zlib --with-boost --with-sqlite3 --with-os-feature=getrandom'
*
* Target
*  - Compiler: g++ -fstack-protector -m64 -pthread -std=c++20 -D_REENTRANT -march=x86-64 -mtune=generic -O2 -pipe -fno-plt -fexceptions         -Wp,-D_FORTIFY_SOURCE=3 -Wformat -Werror=format-security         -fstack-clash-protection -fcf-protection         -fno-omit-frame-pointer -mno-omit-leaf-frame-pointer -Wp,-D_GLIBCXX_ASSERTIONS -g -ffile-prefix-map=/build/botan/src=/usr/src/debug/botan -flto=auto
*  - Arch: x86_64
*  - OS: linux
*/

/* NOLINTBEGIN(*-macro-usage,*-macro-to-enum) */

/*
* Configuration
*/
#define BOTAN_CT_VALUE_BARRIER_USE_ASM

[[maybe_unused]] static constexpr bool OptimizeForSize = false;



/*
* Compiler Information
*/
#define BOTAN_BUILD_COMPILER_IS_GCC

#define BOTAN_COMPILER_INVOCATION_STRING "g++ -fstack-protector -m64 -pthread -march=x86-64 -mtune=generic -O2 -pipe -fno-plt -fexceptions         -Wp,-D_FORTIFY_SOURCE=3 -Wformat -Werror=format-security         -fstack-clash-protection -fcf-protection         -fno-omit-frame-pointer -mno-omit-leaf-frame-pointer -Wp,-D_GLIBCXX_ASSERTIONS -g -ffile-prefix-map=/build/botan/src=/usr/src/debug/botan -flto=auto"

#define BOTAN_USE_GCC_INLINE_ASM


/*
* External tool settings
*/




/*
* CPU feature information
*/
#define BOTAN_TARGET_ARCH "x86_64"

#define BOTAN_TARGET_ARCH_IS_X86_64

#define BOTAN_TARGET_ARCH_IS_X86_FAMILY

#define BOTAN_TARGET_ARCH_SUPPORTS_AESNI
#define BOTAN_TARGET_ARCH_SUPPORTS_AVX2
#define BOTAN_TARGET_ARCH_SUPPORTS_AVX512
#define BOTAN_TARGET_ARCH_SUPPORTS_BMI2
#define BOTAN_TARGET_ARCH_SUPPORTS_GFNI
#define BOTAN_TARGET_ARCH_SUPPORTS_RDRAND
#define BOTAN_TARGET_ARCH_SUPPORTS_RDSEED
#define BOTAN_TARGET_ARCH_SUPPORTS_SHA
#define BOTAN_TARGET_ARCH_SUPPORTS_SHA512
#define BOTAN_TARGET_ARCH_SUPPORTS_SM3
#define BOTAN_TARGET_ARCH_SUPPORTS_SM4
#define BOTAN_TARGET_ARCH_SUPPORTS_SSE2
#define BOTAN_TARGET_ARCH_SUPPORTS_SSE41
#define BOTAN_TARGET_ARCH_SUPPORTS_SSSE3
#define BOTAN_TARGET_ARCH_SUPPORTS_VAES


/*
* Operating system information
*/
#define BOTAN_TARGET_OS_IS_LINUX

#define BOTAN_TARGET_OS_HAS_ATOMICS
#define BOTAN_TARGET_OS_HAS_CLOCK_GETTIME
#define BOTAN_TARGET_OS_HAS_DEV_RANDOM
#define BOTAN_TARGET_OS_HAS_EXPLICIT_BZERO
#define BOTAN_TARGET_OS_HAS_GETAUXVAL
#define BOTAN_TARGET_OS_HAS_GETENTROPY
#define BOTAN_TARGET_OS_HAS_GETRANDOM
#define BOTAN_TARGET_OS_HAS_POSIX1
#define BOTAN_TARGET_OS_HAS_POSIX_MLOCK
#define BOTAN_TARGET_OS_HAS_PRCTL
#define BOTAN_TARGET_OS_HAS_SOCKETS
#define BOTAN_TARGET_OS_HAS_SYSTEM_CLOCK
#define BOTAN_TARGET_OS_HAS_THREAD_LOCAL


/*
* System paths
*/
#define BOTAN_INSTALL_PREFIX R"(/usr)"
#define BOTAN_INSTALL_HEADER_DIR R"(include/botan-3)"
#define BOTAN_INSTALL_LIB_DIR R"(/usr/lib)"
#define BOTAN_LIB_LINK "-lbz2 -ldl -llzma -lrt -lsqlite3 -lz"
#define BOTAN_LINK_FLAGS "-fstack-protector -m64 -pthread"

#define BOTAN_SYSTEM_CERT_BUNDLE "/etc/ssl/certs/ca-certificates.crt"

/* NOLINTEND(*-macro-usage,*-macro-to-enum) */

#endif
